/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.functionaljava.hkt.typeclesses.instances;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.functionaljava.hkt.ListType;
import com.aol.cyclops.functionaljava.hkt.typeclassess.instances.ListInstances;
import com.aol.cyclops.hkt.alias.Higher;
import com.aol.cyclops.hkt.cyclops.MaybeType;
import com.aol.cyclops.hkt.instances.cyclops.MaybeInstances;
import com.aol.cyclops.util.function.Lambda;
import fj.data.List;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ListsTest {
    @Test
    public void unit() {
        ListType list = (ListType)ListInstances.unit().unit((Object)"hello").convert(ListType::narrowK);
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo((Object)List.list((Object[])new String[]{"hello"})));
    }

    @Test
    public void functor() {
        ListType list = (ListType)ListInstances.unit().unit((Object)"hello").then(h -> ListInstances.functor().map(v -> v.length(), h)).convert(ListType::narrowK);
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo((Object)List.list((Object[])new Integer[]{"hello".length()})));
    }

    @Test
    public void apSimple() {
        ListInstances.zippingApplicative().ap((Higher)ListType.widen((List)List.list((Object[])new Function[]{Lambda.l1(this::multiplyByTwo)})), (Higher)ListType.widen((List)List.list((Object[])new Integer[]{1, 2, 3})));
    }

    private int multiplyByTwo(int x) {
        return x * 2;
    }

    @Test
    public void applicative() {
        ListType listFn = (ListType)ListInstances.unit().unit((Object)Lambda.l1(i -> i * 2)).convert(ListType::narrowK);
        ListType list = (ListType)ListInstances.unit().unit((Object)"hello").then(h -> ListInstances.functor().map(v -> v.length(), h)).then(h -> ListInstances.zippingApplicative().ap((Higher)listFn, h)).convert(ListType::narrowK);
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo((Object)List.list((Object[])new Integer[]{"hello".length() * 2})));
    }

    @Test
    public void monadSimple() {
        ListType list = (ListType)ListInstances.monad().flatMap(i -> ListType.widen((List)List.range((int)0, (int)i)), (Higher)ListType.widen((List)List.list((Object[])new Integer[]{1, 2, 3}))).convert(ListType::narrowK);
    }

    @Test
    public void monad() {
        ListType list = (ListType)ListInstances.unit().unit((Object)"hello").then(h -> ListInstances.monad().flatMap(v -> ListInstances.unit().unit((Object)v.length()), h)).convert(ListType::narrowK);
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo((Object)List.list((Object[])new Integer[]{"hello".length()})));
    }

    @Test
    public void monadZeroFilter() {
        ListType list = (ListType)ListInstances.unit().unit((Object)"hello").then(h -> ListInstances.monadZero().filter(t -> t.startsWith("he"), h)).convert(ListType::narrowK);
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo((Object)List.list((Object[])new String[]{"hello"})));
    }

    @Test
    public void monadZeroFilterOut() {
        ListType list = (ListType)ListInstances.unit().unit((Object)"hello").then(h -> ListInstances.monadZero().filter(t -> !t.startsWith("he"), h)).convert(ListType::narrowK);
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo((Object)List.list((Object[])new Object[0])));
    }

    @Test
    public void monadPlus() {
        ListType list = (ListType)ListInstances.monadPlus().plus((Higher)ListType.widen((List)List.list((Object[])new Integer[0])), (Higher)ListType.widen((List)List.list((Object[])new Integer[]{10}))).convert(ListType::narrowK);
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo((Object)List.list((Object[])new Integer[]{10})));
    }

    @Test
    public void monadPlusNonEmpty() {
        Monoid m = Monoid.of((Object)ListType.widen((List)List.list((Object[])new Integer[0])), (a, b) -> a.isEmpty() ? b : a);
        ListType list = (ListType)ListInstances.monadPlus((Monoid)m).plus((Higher)ListType.widen((List)List.list((Object[])new Integer[]{5})), (Higher)ListType.widen((List)List.list((Object[])new Integer[]{10}))).convert(ListType::narrowK);
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo((Object)List.list((Object[])new Integer[]{5})));
    }

    @Test
    public void foldLeft() {
        int sum = (Integer)ListInstances.foldable().foldLeft((Object)0, (a, b) -> a + b, (Higher)ListType.widen((List)List.list((Object[])new Integer[]{1, 2, 3, 4})));
        Assert.assertThat((Object)sum, (Matcher)Matchers.equalTo((Object)10));
    }

    @Test
    public void foldRight() {
        int sum = (Integer)ListInstances.foldable().foldRight((Object)0, (a, b) -> a + b, (Higher)ListType.widen((List)List.list((Object[])new Integer[]{1, 2, 3, 4})));
        Assert.assertThat((Object)sum, (Matcher)Matchers.equalTo((Object)10));
    }

    @Test
    public void traverse() {
        MaybeType res = (MaybeType)ListInstances.traverse().traverseA(MaybeInstances.applicative(), a -> MaybeType.just((Object)(a * 2)), (Higher)ListType.list((Object[])new Integer[]{1, 2, 3})).convert(MaybeType::narrowK);
        Assert.assertThat((Object)res, (Matcher)Matchers.equalTo((Object)Maybe.just((Object)List.list((Object[])new Integer[]{6, 4, 2}))));
    }
}

