/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.functionaljava.hkt.typeclesses.instances;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.functionaljava.hkt.OptionType;
import com.aol.cyclops.functionaljava.hkt.typeclassess.instances.OptionInstances;
import com.aol.cyclops.hkt.alias.Higher;
import com.aol.cyclops.hkt.cyclops.MaybeType;
import com.aol.cyclops.hkt.instances.cyclops.MaybeInstances;
import com.aol.cyclops.util.function.Lambda;
import fj.data.Option;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class OptionTest {
    @Test
    public void unit() {
        OptionType opt = (OptionType)OptionInstances.unit().unit((Object)"hello").convert(OptionType::narrowK);
        Assert.assertThat((Object)opt, (Matcher)Matchers.equalTo((Object)Option.some((Object)"hello")));
    }

    @Test
    public void functor() {
        OptionType opt = (OptionType)OptionInstances.unit().unit((Object)"hello").then(h -> OptionInstances.functor().map(v -> v.length(), h)).convert(OptionType::narrowK);
        Assert.assertThat((Object)opt, (Matcher)Matchers.equalTo((Object)Option.some((Object)"hello".length())));
    }

    @Test
    public void apSimple() {
        OptionInstances.applicative().ap((Higher)OptionType.widen((Option)Option.some((Object)Lambda.l1(this::multiplyByTwo))), (Higher)OptionType.widen((Option)Option.some((Object)1)));
    }

    private int multiplyByTwo(int x) {
        return x * 2;
    }

    @Test
    public void applicative() {
        OptionType optFn = (OptionType)OptionInstances.unit().unit((Object)Lambda.l1(i -> i * 2)).convert(OptionType::narrowK);
        OptionType opt = (OptionType)OptionInstances.unit().unit((Object)"hello").then(h -> OptionInstances.functor().map(v -> v.length(), h)).then(h -> OptionInstances.applicative().ap((Higher)optFn, h)).convert(OptionType::narrowK);
        Assert.assertThat((Object)opt, (Matcher)Matchers.equalTo((Object)Option.some((Object)("hello".length() * 2))));
    }

    @Test
    public void monadSimple() {
        OptionType opt = (OptionType)OptionInstances.monad().flatMap(i -> OptionType.widen((Option)Option.some((Object)(i * 2))), (Higher)OptionType.widen((Option)Option.some((Object)3))).convert(OptionType::narrowK);
    }

    @Test
    public void monad() {
        OptionType opt = (OptionType)OptionInstances.unit().unit((Object)"hello").then(h -> OptionInstances.monad().flatMap(v -> OptionInstances.unit().unit((Object)v.length()), h)).convert(OptionType::narrowK);
        Assert.assertThat((Object)opt, (Matcher)Matchers.equalTo((Object)Option.some((Object)"hello".length())));
    }

    @Test
    public void monadZeroFilter() {
        OptionType opt = (OptionType)OptionInstances.unit().unit((Object)"hello").then(h -> OptionInstances.monadZero().filter(t -> t.startsWith("he"), h)).convert(OptionType::narrowK);
        Assert.assertThat((Object)opt, (Matcher)Matchers.equalTo((Object)Option.some((Object)"hello")));
    }

    @Test
    public void monadZeroFilterOut() {
        OptionType opt = (OptionType)OptionInstances.unit().unit((Object)"hello").then(h -> OptionInstances.monadZero().filter(t -> !t.startsWith("he"), h)).convert(OptionType::narrowK);
        Assert.assertThat((Object)opt, (Matcher)Matchers.equalTo((Object)Option.none()));
    }

    @Test
    public void monadPlus() {
        OptionType opt = (OptionType)OptionInstances.monadPlus().plus((Higher)OptionType.widen((Option)Option.none()), (Higher)OptionType.widen((Option)Option.some((Object)10))).convert(OptionType::narrowK);
        Assert.assertThat((Object)opt, (Matcher)Matchers.equalTo((Object)Option.some((Object)10)));
    }

    @Test
    public void monadPlusNonEmpty() {
        Monoid m = Monoid.of((Object)OptionType.widen((Option)Option.none()), (a, b) -> a.isSome() ? b : a);
        OptionType opt = (OptionType)OptionInstances.monadPlus((Monoid)m).plus((Higher)OptionType.widen((Option)Option.some((Object)5)), (Higher)OptionType.widen((Option)Option.some((Object)10))).convert(OptionType::narrowK);
        Assert.assertThat((Object)opt, (Matcher)Matchers.equalTo((Object)Option.some((Object)10)));
    }

    @Test
    public void foldLeft() {
        int sum = (Integer)OptionInstances.foldable().foldLeft((Object)0, (a, b) -> a + b, (Higher)OptionType.widen((Option)Option.some((Object)4)));
        Assert.assertThat((Object)sum, (Matcher)Matchers.equalTo((Object)4));
    }

    @Test
    public void foldRight() {
        int sum = (Integer)OptionInstances.foldable().foldRight((Object)0, (a, b) -> a + b, (Higher)OptionType.widen((Option)Option.some((Object)1)));
        Assert.assertThat((Object)sum, (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void traverse() {
        MaybeType res = (MaybeType)OptionInstances.traverse().traverseA(MaybeInstances.applicative(), a -> MaybeType.just((Object)(a * 2)), (Higher)OptionType.of((Object)1)).convert(MaybeType::narrowK);
        Assert.assertThat((Object)res, (Matcher)Matchers.equalTo((Object)Maybe.just((Object)Option.some((Object)2))));
    }
}

