/*
 * Decompiled with CFR 0.152.
 */
package com.ardoq.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iso8601Adapter
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    public Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        DateTime dt = ISODateTimeFormat.dateTimeParser().parseDateTime(jsonElement.getAsString());
        return dt.toDate();
    }

    public JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
        String s = ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)date));
        return new JsonPrimitive(s);
    }
}

