/*
 * Decompiled with CFR 0.152.
 */
package com.ardoq.service;

import com.ardoq.model.AggregatedWorkspace;
import com.ardoq.model.Component;
import com.ardoq.model.Workspace;
import com.ardoq.model.WorkspaceBranch;
import com.ardoq.model.WorkspaceBranchRequest;
import java.util.List;
import retrofit.Callback;
import retrofit.client.Response;
import retrofit.http.Body;
import retrofit.http.DELETE;
import retrofit.http.GET;
import retrofit.http.POST;
import retrofit.http.PUT;
import retrofit.http.Path;
import retrofit.http.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface WorkspaceService {
    @GET(value="/api/workspace")
    public List<Workspace> getAllWorkspaces();

    @GET(value="/api/workspace")
    public void getAllWorkspaces(Callback<List<Workspace>> var1);

    @GET(value="/api/workspace/{id}")
    public Workspace getWorkspaceById(@Path(value="id") String var1);

    @GET(value="/api/workspace/{id}")
    public void getWorkspaceById(@Path(value="id") String var1, Callback<Workspace> var2);

    @GET(value="/api/workspace/{id}/branch")
    public List<WorkspaceBranch> getBranches(@Path(value="id") String var1);

    @GET(value="/api/workspace/{id}/branch")
    public void getBranches(@Path(value="id") String var1, Callback<List<WorkspaceBranch>> var2);

    @GET(value="/api/workspace/{id}/aggregated")
    public AggregatedWorkspace getAggregatedWorkspace(@Path(value="id") String var1);

    @GET(value="/api/workspace/{id}/aggregated")
    public void getAggregatedWorkspace(@Path(value="id") String var1, Callback<AggregatedWorkspace> var2);

    @POST(value="/api/workspace")
    public Workspace createWorkspace(@Body Workspace var1);

    @POST(value="/api/workspace")
    public void createWorkspace(@Body Workspace var1, Callback<Workspace> var2);

    @POST(value="/api/workspace/{id}/branch/create")
    public Workspace branchWorkspace(@Path(value="id") String var1, @Body WorkspaceBranchRequest var2);

    @POST(value="/api/workspace/{id}/branch/create")
    public void branchWorkspace(@Path(value="id") String var1, @Body WorkspaceBranchRequest var2, Callback<Workspace> var3);

    @PUT(value="/api/workspace/{id}")
    public Workspace updateWorkspace(@Path(value="id") String var1, @Body Workspace var2);

    @PUT(value="/api/workspace/{id}")
    public void updateWorkspace(@Path(value="id") String var1, @Body Workspace var2, Callback<Workspace> var3);

    @DELETE(value="/api/workspace/{id}")
    public Response deleteWorkspace(@Path(value="id") String var1);

    @DELETE(value="/api/workspace/{id}")
    public void deleteWorkspace(@Path(value="id") String var1, Callback<Response> var2);

    @GET(value="/api/workspace/by-name")
    public List<Workspace> findWorkspacesByName(@Query(value="name") String var1);

    public Workspace createWorkspaceWithModel(String var1, String var2, String var3);

    public Workspace createWorkspaceFromTemplate(String var1, String var2, String var3);

    @GET(value="/api/workspace/{id}/component")
    public List<Component> getAllComponents(@Path(value="id") String var1);

    @GET(value="/api/workspace/{id}/component")
    public void getAllComponents(@Path(value="id") String var1, Callback<List<Component>> var2);
}

