/*
 * Decompiled with CFR 0.152.
 */
package com.ardoq.batch;

import com.ardoq.batch.BatchOp;
import com.ardoq.batch.BatchOptions;
import com.ardoq.model.Component;
import com.ardoq.model.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchCreateRequest {
    private final BatchOp op = BatchOp.create;
    private List<Component> components = new ArrayList<Component>();
    private List<Reference> references = new ArrayList<Reference>();
    private BatchOptions options;

    public BatchCreateRequest(BatchOptions options) {
        this.options = options;
    }

    public BatchCreateRequest() {
        this(new BatchOptions());
    }

    public String getOp() {
        return this.op.toString();
    }

    public BatchOptions getOptions() {
        return this.options;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public void addComponent(Component c) {
        this.components.add(c);
    }

    public void addComponents(Component ... c) {
        this.components.addAll(Arrays.asList(c));
    }

    public void addReference(Reference r) {
        this.references.add(r);
    }

    public void addReferences(Reference ... r) {
        this.references.addAll(Arrays.asList(r));
    }
}

