/*
 * Decompiled with CFR 0.152.
 */
package com.ardoq;

import com.ardoq.adapter.AttachmentAdapter;
import com.ardoq.adapter.BatchCreateAdapter;
import com.ardoq.adapter.ComponentAdapter;
import com.ardoq.adapter.FieldAdapter;
import com.ardoq.adapter.Iso8601Adapter;
import com.ardoq.adapter.ModelAdapter;
import com.ardoq.adapter.ReferenceAdapter;
import com.ardoq.adapter.WorkspaceAdapter;
import com.ardoq.batch.BatchCreateRequest;
import com.ardoq.model.Attachment;
import com.ardoq.model.Component;
import com.ardoq.model.Field;
import com.ardoq.model.Model;
import com.ardoq.model.Reference;
import com.ardoq.model.Workspace;
import com.ardoq.service.AttachmentService;
import com.ardoq.service.BatchService;
import com.ardoq.service.ComponentService;
import com.ardoq.service.FieldService;
import com.ardoq.service.ModelService;
import com.ardoq.service.ReferenceService;
import com.ardoq.service.SimpleModelService;
import com.ardoq.service.SimpleWorkspaceService;
import com.ardoq.service.TagService;
import com.ardoq.service.WorkspaceService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.ApacheClient;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public class ArdoqClient {
    private String org;
    private RestAdapter restAdapter;
    private String endpoint;
    private RequestInterceptor requestInterceptor;
    private Client client;

    private RequestInterceptor getRequestInterceptor(String endpoint, final String token) {
        if (endpoint == null || token == null) {
            throw new IllegalArgumentException("Endpoint and token must be set correctly!");
        }
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade requestFacade) {
                requestFacade.addHeader("Authorization", "Token token=" + token.trim());
                requestFacade.addHeader("User-Agent", "ardoq-java-client-" + ArdoqClient.this.getVersion());
                if (ArdoqClient.this.org != null) {
                    requestFacade.addQueryParam("org", ArdoqClient.this.org);
                }
            }
        };
    }

    public ArdoqClient(String endpoint, String token) {
        this.restAdapter = this.initAdapter(endpoint, this.getRequestInterceptor(endpoint, token));
    }

    public ArdoqClient(String endpoint, String token, HttpClient client) {
        this.restAdapter = this.initAdapter(endpoint, this.getRequestInterceptor(endpoint, token), (Client)new ApacheClient(client));
    }

    public ArdoqClient(String endpoint, String token, long connectionTimeoutSeconds, long readTimeoutSeconds) {
        ApacheClient client = this.getHttpClient(connectionTimeoutSeconds, readTimeoutSeconds);
        this.restAdapter = this.initAdapter(endpoint, this.getRequestInterceptor(endpoint, token), (Client)client);
    }

    public ArdoqClient(String endpoint, String token, RequestConfig defaultRequestConfig) {
        ApacheClient client = new ApacheClient((HttpClient)HttpClientBuilder.create().setDefaultRequestConfig(defaultRequestConfig).build());
        this.restAdapter = this.initAdapter(endpoint, this.getRequestInterceptor(endpoint, token), (Client)client);
    }

    private ApacheClient getHttpClient(long connectionTimeoutSeconds, long readTimeoutSeconds) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(ArdoqClient.coereceToInt(connectionTimeoutSeconds * 1000L)).setConnectionRequestTimeout(ArdoqClient.coereceToInt(readTimeoutSeconds * 100L)).build();
        CloseableHttpClient build = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        return new ApacheClient((HttpClient)build);
    }

    public ArdoqClient(String endpoint, String username, String password) {
        this.restAdapter = this.initAdapter(endpoint, this.getRequestInterceptorBasicAuth(endpoint, username, password));
    }

    public ArdoqClient(String endpoint, String username, String password, HttpClient client) {
        this.restAdapter = this.initAdapter(endpoint, this.getRequestInterceptorBasicAuth(endpoint, username, password), (Client)new ApacheClient(client));
    }

    public ArdoqClient(String endpoint, String username, String password, RequestConfig defaultRequestConfig) {
        ApacheClient client = new ApacheClient((HttpClient)HttpClientBuilder.create().setDefaultRequestConfig(defaultRequestConfig).build());
        this.restAdapter = this.initAdapter(endpoint, this.getRequestInterceptorBasicAuth(endpoint, username, password), (Client)client);
    }

    public ArdoqClient(String endpoint, String username, String password, long connectionTimeoutSeconds, long readTimeoutSeconds) {
        ApacheClient httpClient = this.getHttpClient(connectionTimeoutSeconds, readTimeoutSeconds);
        this.restAdapter = this.initAdapter(endpoint, this.getRequestInterceptorBasicAuth(endpoint, username, password), (Client)httpClient);
    }

    private RequestInterceptor getRequestInterceptorBasicAuth(String endpoint, final String username, final String password) {
        if (endpoint == null || username == null || password == null) {
            throw new IllegalArgumentException("Endpoint, username and password must be set correctly!");
        }
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade requestFacade) {
                String pwd = Base64.encodeBase64String((byte[])(username + ":" + password).getBytes());
                requestFacade.addHeader("Authorization", "Basic " + pwd);
                requestFacade.addHeader("User-Agent", "ardoq-java-client-" + ArdoqClient.this.getVersion());
                if (ArdoqClient.this.org != null) {
                    requestFacade.addQueryParam("org", ArdoqClient.this.org);
                }
            }
        };
    }

    private static int coereceToInt(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(l + " cannot be cast to int without changing its value.");
        }
        return (int)l;
    }

    public void setLogLevel(RestAdapter.LogLevel level) {
        this.restAdapter.setLogLevel(level);
    }

    private RestAdapter.Builder builderDefaults(String endpoint, RequestInterceptor requestInterceptor) {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new Iso8601Adapter()).registerTypeAdapter(Component.class, (Object)new ComponentAdapter()).registerTypeAdapter(BatchCreateRequest.class, (Object)new BatchCreateAdapter()).registerTypeAdapter(Reference.class, (Object)new ReferenceAdapter()).registerTypeAdapter(Workspace.class, (Object)new WorkspaceAdapter()).registerTypeAdapter(Field.class, (Object)new FieldAdapter()).registerTypeAdapter(Attachment.class, (Object)new AttachmentAdapter()).registerTypeAdapter(Model.class, (Object)new ModelAdapter());
        gsonBuilder.serializeNulls();
        Gson gson = gsonBuilder.create();
        return new RestAdapter.Builder().setLogLevel(RestAdapter.LogLevel.NONE).setEndpoint(endpoint).setConverter((Converter)new GsonConverter(gson)).setRequestInterceptor(requestInterceptor);
    }

    private RestAdapter initAdapter(String endpoint, RequestInterceptor requestInterceptor, Client client) {
        this.endpoint = endpoint;
        this.requestInterceptor = requestInterceptor;
        this.client = client;
        return this.builderDefaults(endpoint, requestInterceptor).setClient(client).build();
    }

    private RestAdapter initAdapter(String endpoint, RequestInterceptor requestInterceptor) {
        this.endpoint = endpoint;
        this.requestInterceptor = requestInterceptor;
        return this.builderDefaults(endpoint, requestInterceptor).build();
    }

    private String getVersion() {
        String version;
        Properties properties = new Properties();
        try {
            properties.load(ArdoqClient.class.getResourceAsStream("/version.properties"));
            version = properties.getProperty("client-version");
        }
        catch (IOException e) {
            version = "Unknown";
        }
        return version;
    }

    public ArdoqClient setOrganization(String org) {
        this.org = org;
        return this;
    }

    public WorkspaceService workspace() {
        return new SimpleWorkspaceService((WorkspaceService)this.restAdapter.create(WorkspaceService.class));
    }

    public ComponentService component() {
        return (ComponentService)this.restAdapter.create(ComponentService.class);
    }

    public BatchService batch() {
        return (BatchService)this.restAdapter.create(BatchService.class);
    }

    public ReferenceService reference() {
        return (ReferenceService)this.restAdapter.create(ReferenceService.class);
    }

    public TagService tag() {
        return (TagService)this.restAdapter.create(TagService.class);
    }

    public FieldService field() {
        return (FieldService)this.restAdapter.create(FieldService.class);
    }

    public AttachmentService attachment() {
        return (AttachmentService)this.restAdapter.create(AttachmentService.class);
    }

    public SimpleModelService model() {
        return new SimpleModelService((ModelService)this.restAdapter.create(ModelService.class));
    }
}

