/*
 * Decompiled with CFR 0.152.
 */
package com.ardoq.service;

import com.ardoq.model.Model;
import com.ardoq.service.ModelService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import retrofit.mime.TypedString;

public class SimpleModelService {
    private final ModelService modelService;

    public SimpleModelService(ModelService modelService) {
        this.modelService = modelService;
    }

    public List<Model> getAllModels() {
        return this.modelService.getAllModels();
    }

    public List<Model> getAllTemplate(boolean includeCommon) {
        List<Model> allModels = this.modelService.getAllModelsIncludingCommonTemplate();
        ArrayList<Model> templates = new ArrayList<Model>();
        for (Model model : allModels) {
            if (!model.isTemplate().booleanValue()) continue;
            if (!includeCommon && !model.isTemplate().booleanValue()) {
                templates.add(model);
                continue;
            }
            templates.add(model);
        }
        return templates;
    }

    public Model getModelById(String id) {
        return this.modelService.getModelById(id);
    }

    public Model getTemplateById(String id) {
        List<Model> allModels = this.modelService.getAllModelsIncludingCommonTemplate();
        for (Model model : allModels) {
            if (!model.getId().equals(id)) continue;
            return model;
        }
        return null;
    }

    public Model getTemplateByName(String name) {
        List<Model> allModels = this.modelService.getAllModelsIncludingCommonTemplate();
        ArrayList<Model> result = new ArrayList<Model>();
        for (Model m : allModels) {
            if (!m.getName().equals(name)) continue;
            result.add(m);
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException("No model with the name " + name + " exist!");
        }
        if (result.size() > 1) {
            throw new IllegalArgumentException("Multiple models that match the name " + name + " exist!");
        }
        return (Model)result.get(0);
    }

    public Model findOrCreateTemplate(String name, InputStream modelJson) throws IOException {
        try {
            Model m = this.getTemplateByName(name);
            return m;
        }
        catch (IllegalArgumentException m) {
            String modelStr = IOUtils.toString((InputStream)modelJson, (String)"UTF-8");
            return this.modelService.createModel(new TypedString(modelStr));
        }
    }
}

