/*
 * Decompiled with CFR 0.152.
 */
package com.ardoq.service;

import com.ardoq.model.Model;
import com.ardoq.service.ModelService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import retrofit.mime.TypedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleModelService {
    private final ModelService modelService;

    public SimpleModelService(ModelService modelService) {
        this.modelService = modelService;
    }

    public List<Model> getAllModels() {
        return this.modelService.getAllModels();
    }

    public Model getModelById(String id) {
        return this.modelService.getModelById(id);
    }

    public Model getTemplateById(String id) {
        return this.modelService.getModelById(id);
    }

    public Model getTemplateByName(String name) {
        List<Model> allModels = this.modelService.getAllModels();
        ArrayList<Model> result = new ArrayList<Model>();
        for (Model m : allModels) {
            if (!m.getName().equals(name)) continue;
            result.add(m);
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException("No model with the name " + name + " exist!");
        }
        if (result.size() > 1) {
            throw new IllegalArgumentException("Multiple models that match the name " + name + " exist!");
        }
        return (Model)result.get(0);
    }

    public Model findOrCreateTemplate(String name, InputStream modelJson) throws IOException {
        try {
            Model m = this.getTemplateByName(name);
            return m;
        }
        catch (IllegalArgumentException m) {
            String modelStr = IOUtils.toString((InputStream)modelJson, (String)"UTF-8");
            return this.modelService.createModel(new TypedString(modelStr));
        }
    }
}

