/*
 * Decompiled with CFR 0.152.
 */
package com.ardoq.model;

import com.ardoq.model.BasicModel;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component
implements BasicModel {
    @SerializedName(value="_id")
    private String id;
    private String name;
    private String model;
    private String state;
    private Date created;
    @SerializedName(value="created-by")
    private String createdBy;
    @SerializedName(value="last-updated")
    private Date lastUpdated;
    private String version;
    private Integer _version;
    private String rootWorkspace;
    private Collection<String> children;
    private String parent;
    private String type;
    private String typeId;
    private String description;
    private Map<String, Object> _fields = new HashMap<String, Object>();

    public Component(String name, String rootWorkspace, String description) {
        this.name = name;
        this.rootWorkspace = rootWorkspace;
        this.description = description;
        this.parent = null;
    }

    public Component(String name, String rootWorkspace, String description, String typeId) {
        this.name = name;
        this.rootWorkspace = rootWorkspace;
        this.description = description;
        this.parent = null;
        this.typeId = typeId;
    }

    public Component(String name, String rootWorkspace, String description, String typeId, String parent) {
        this(name, rootWorkspace, description);
        this.setParent(parent);
        this.typeId = typeId;
    }

    public Object clone() {
        Component c = new Component(this.name, this.rootWorkspace, this.description, this.typeId, this.parent);
        c.setModel(new String(this.model));
        c.setId(new String(this.id));
        c.setState(new String(this.state));
        c.setCreated(new Date(this.created.getTime()));
        c.setCreatedBy(new String(this.createdBy));
        c.setLastUpdated(new Date(this.lastUpdated.getTime()));
        c.setRootWorkspace(new String(this.rootWorkspace));
        c.setChildren(this.children);
        c.setType(new String(this.type));
        c.setFields(new HashMap<String, Object>(this._fields));
        return c;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component component = (Component)o;
        if (this._fields != null ? !this._fields.equals(component._fields) : component._fields != null) {
            return false;
        }
        if (this._version != null ? !this._version.equals(component._version) : component._version != null) {
            return false;
        }
        if (this.children != null ? !this.children.equals(component.children) : component.children != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(component.created) : component.created != null) {
            return false;
        }
        if (this.createdBy != null ? !this.createdBy.equals(component.createdBy) : component.createdBy != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(component.description) : component.description != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(component.id) : component.id != null) {
            return false;
        }
        if (this.lastUpdated != null ? !this.lastUpdated.equals(component.lastUpdated) : component.lastUpdated != null) {
            return false;
        }
        if (this.model != null ? !this.model.equals(component.model) : component.model != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(component.name) : component.name != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(component.parent) : component.parent != null) {
            return false;
        }
        if (this.rootWorkspace != null ? !this.rootWorkspace.equals(component.rootWorkspace) : component.rootWorkspace != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals(component.state) : component.state != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(component.type) : component.type != null) {
            return false;
        }
        if (this.typeId != null ? !this.typeId.equals(component.typeId) : component.typeId != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(component.version) : component.version != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.createdBy != null ? this.createdBy.hashCode() : 0);
        result = 31 * result + (this.lastUpdated != null ? this.lastUpdated.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this._version != null ? this._version.hashCode() : 0);
        result = 31 * result + (this.rootWorkspace != null ? this.rootWorkspace.hashCode() : 0);
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.typeId != null ? this.typeId.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this._fields != null ? this._fields.hashCode() : 0);
        return result;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Override
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public Integer get_version() {
        return this._version;
    }

    public void set_version(Integer _version) {
        this._version = _version;
    }

    public String getRootWorkspace() {
        return this.rootWorkspace;
    }

    public void setRootWorkspace(String rootWorkspace) {
        this.rootWorkspace = rootWorkspace;
    }

    public Collection<String> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<String> children) {
        this.children = children;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getFields() {
        return this._fields;
    }

    public void setFields(Map<String, Object> fields) {
        this._fields = fields;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public String toString() {
        return "Component{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", model='" + this.model + '\'' + ", state='" + this.state + '\'' + ", created=" + this.created + ", createdBy='" + this.createdBy + '\'' + ", lastUpdated=" + this.lastUpdated + ", version='" + this.version + '\'' + ", _version=" + this._version + ", rootWorkspace='" + this.rootWorkspace + '\'' + ", children=" + this.children + ", parent='" + this.parent + '\'' + ", type='" + this.type + '\'' + ", typeId='" + this.typeId + '\'' + ", description='" + this.description + '\'' + ", _fields=" + this._fields + '}';
    }
}

