/*
 * Decompiled with CFR 0.152.
 */
package com.ardoq.service;

import com.ardoq.model.Component;
import java.util.List;
import java.util.Map;
import retrofit.Callback;
import retrofit.client.Response;
import retrofit.http.Body;
import retrofit.http.DELETE;
import retrofit.http.GET;
import retrofit.http.POST;
import retrofit.http.PUT;
import retrofit.http.Path;
import retrofit.http.Query;
import retrofit.http.QueryMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ComponentService {
    @GET(value="/api/component")
    public List<Component> getAllComponents();

    @GET(value="/api/component")
    public void getAllComponents(Callback<List<Component>> var1);

    @GET(value="/api/component/{id}")
    public Component getComponentById(@Path(value="id") String var1);

    @GET(value="/api/component/{id}")
    public void getComponentById(@Path(value="id") String var1, Callback<Component> var2);

    @GET(value="/api/component/fieldsearch")
    public List<Component> findComponentsByFields(@QueryMap Map<String, String> var1);

    @GET(value="/api/component/fieldsearch")
    public List<Component> findComponentsByFields(@QueryMap Map<String, String> var1, Callback<Component> var2);

    @GET(value="/api/component/search")
    public List<Component> findComponentsInWorkspaceByName(@Query(value="workspace") String var1, @Query(value="name") String var2);

    @GET(value="/api/component/search")
    public List<Component> findComponentsInWorkspaceByName(@Query(value="workspace") String var1, @Query(value="name") String var2, Callback<Component> var3);

    @POST(value="/api/component")
    public Component createComponent(@Body Component var1);

    @POST(value="/api/component")
    public void createComponent(@Body Component var1, Callback<Component> var2);

    @PUT(value="/api/component/{id}")
    public Component updateComponent(@Path(value="id") String var1, @Body Component var2);

    @PUT(value="/api/component/{id}")
    public void updateComponent(@Path(value="id") String var1, @Body Component var2, Callback<Component> var3);

    @DELETE(value="/api/component/{id}")
    public Response deleteComponent(@Path(value="id") String var1);

    @DELETE(value="/api/component/{id}")
    public void deleteComponent(@Path(value="id") String var1, Callback<Response> var2);
}

