/*
 * Decompiled with CFR 0.152.
 */
package com.ardoq.service;

import com.ardoq.model.AggregatedWorkspace;
import com.ardoq.model.Component;
import com.ardoq.model.Workspace;
import com.ardoq.model.WorkspaceBranch;
import com.ardoq.model.WorkspaceBranchRequest;
import com.ardoq.service.WorkspaceService;
import java.util.List;
import retrofit.Callback;
import retrofit.client.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWorkspaceService
implements WorkspaceService {
    private final WorkspaceService workspaceService;

    public SimpleWorkspaceService(WorkspaceService workspaceService) {
        this.workspaceService = workspaceService;
    }

    @Override
    public List<Workspace> getAllWorkspaces() {
        return this.workspaceService.getAllWorkspaces();
    }

    @Override
    public void getAllWorkspaces(Callback<List<Workspace>> callback) {
        this.workspaceService.getAllWorkspaces(callback);
    }

    @Override
    public Workspace getWorkspaceById(String id) {
        return this.workspaceService.getWorkspaceById(id);
    }

    @Override
    public void getWorkspaceById(String id, Callback<Workspace> callback) {
        this.workspaceService.getWorkspaceById(id, callback);
    }

    @Override
    public List<WorkspaceBranch> getBranches(String id) {
        return this.workspaceService.getBranches(id);
    }

    @Override
    public void getBranches(String id, Callback<List<WorkspaceBranch>> callback) {
        this.workspaceService.getBranches(id, callback);
    }

    @Override
    public AggregatedWorkspace getAggregatedWorkspace(String id) {
        return this.workspaceService.getAggregatedWorkspace(id);
    }

    @Override
    public void getAggregatedWorkspace(String id, Callback<AggregatedWorkspace> callback) {
        this.workspaceService.getAggregatedWorkspace(id, callback);
    }

    @Override
    public Workspace createWorkspace(Workspace workspace) {
        return this.workspaceService.createWorkspace(workspace);
    }

    @Override
    public void createWorkspace(Workspace workspace, Callback<Workspace> callback) {
        this.workspaceService.createWorkspace(workspace, callback);
    }

    @Override
    public Workspace branchWorkspace(String id, WorkspaceBranchRequest branch) {
        return this.workspaceService.branchWorkspace(id, branch);
    }

    @Override
    public void branchWorkspace(String id, WorkspaceBranchRequest branch, Callback<Workspace> callback) {
        this.workspaceService.branchWorkspace(id, branch, callback);
    }

    @Override
    public Workspace updateWorkspace(String id, Workspace workspace) {
        return this.workspaceService.updateWorkspace(id, workspace);
    }

    @Override
    public void updateWorkspace(String id, Workspace workspace, Callback<Workspace> callback) {
        this.workspaceService.updateWorkspace(id, workspace, callback);
    }

    @Override
    public Response deleteWorkspace(String id) {
        return this.workspaceService.deleteWorkspace(id);
    }

    @Override
    public void deleteWorkspace(String id, Callback<Response> callback) {
        this.workspaceService.deleteWorkspace(id, callback);
    }

    @Override
    public List<Workspace> findWorkspacesByName(String workspaceName) {
        return this.workspaceService.findWorkspacesByName(workspaceName);
    }

    @Override
    public Workspace createWorkspaceWithModel(String workspaceName, String modelID, String description) {
        return this.workspaceService.createWorkspace(new Workspace(workspaceName, description).withComponentModel(modelID));
    }

    @Override
    public Workspace createWorkspaceFromTemplate(String workspaceName, String templateID, String decription) {
        return this.workspaceService.createWorkspace(new Workspace(workspaceName, templateID, decription));
    }

    @Override
    public List<Component> getAllComponents(String id) {
        return this.workspaceService.getAllComponents(id);
    }

    @Override
    public void getAllComponents(String id, Callback<List<Component>> callback) {
        this.workspaceService.getAllComponents(id, callback);
    }
}

