/*
 * Decompiled with CFR 0.152.
 */
package com.ardoq.adapter;

import com.ardoq.model.Model;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelAdapter
implements JsonDeserializer<Model> {
    public Model deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        Map<String, Integer> referenceTypes = this.getReferenceTypes(jsonObject);
        JsonObject root = jsonObject.getAsJsonObject("root");
        Map document = (Map)new Gson().fromJson((JsonElement)root, Object.class);
        Map<String, String> componentTypes = this.getComponentTypes(document);
        return new Model(jsonObject.get("_id").getAsString(), jsonObject.get("name").getAsString(), jsonObject.get("description") != null ? jsonObject.get("description").getAsString() : "", jsonObject.get("useAsTemplate") != null ? jsonObject.get("useAsTemplate").getAsBoolean() : false, componentTypes, referenceTypes);
    }

    private Map<String, String> getComponentTypes(Map<String, Object> document) {
        HashMap<String, String> componentTypes = new HashMap<String, String>();
        for (Map.Entry<String, Object> entries : document.entrySet()) {
            Map value = (Map)entries.getValue();
            componentTypes.put((String)value.get("name"), entries.getKey());
            componentTypes.putAll(this.getComponentTypes((Map)value.get("children")));
        }
        return componentTypes;
    }

    private Map<String, Integer> getReferenceTypes(JsonObject jsonObject) {
        JsonObject document;
        HashMap<String, Integer> references = new HashMap<String, Integer>();
        JsonElement referenceTypes = jsonObject.get("referenceTypes");
        if (referenceTypes instanceof JsonObject && (document = (JsonObject)referenceTypes) != null) {
            Set entries = document.entrySet();
            for (Map.Entry entry : entries) {
                JsonObject value = (JsonObject)entry.getValue();
                references.put(value.get("name").getAsString(), value.get("id").getAsInt());
            }
        }
        return references;
    }
}

