/*
 * Decompiled with CFR 0.152.
 */
package com.atlan;

import com.atlan.api.ApiTokensEndpoint;
import com.atlan.api.AssetEndpoint;
import com.atlan.api.GroupsEndpoint;
import com.atlan.api.ImagesEndpoint;
import com.atlan.api.LogsEndpoint;
import com.atlan.api.PlaybooksEndpoint;
import com.atlan.api.QueryParserEndpoint;
import com.atlan.api.RequestsEndpoint;
import com.atlan.api.RolesEndpoint;
import com.atlan.api.TypeDefsEndpoint;
import com.atlan.api.UsersEndpoint;
import com.atlan.api.WorkflowsEndpoint;
import com.atlan.cache.AtlanTagCache;
import com.atlan.cache.CustomMetadataCache;
import com.atlan.cache.EnumCache;
import com.atlan.cache.GroupCache;
import com.atlan.cache.RoleCache;
import com.atlan.cache.UserCache;
import com.atlan.serde.AssetDeserializer;
import com.atlan.serde.AtlanTagDeserializer;
import com.atlan.serde.CustomMetadataAuditDeserializer;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class AtlanClient {
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int DEFAULT_READ_TIMEOUT = 120000;
    public static final String DELETED_AUDIT_OBJECT = "(DELETED)";
    private volatile int connectTimeout = 30000;
    private volatile int readTimeout = 120000;
    private volatile int maxNetworkRetries = 10;
    private final String apiBase;
    private final boolean internalAccess;
    private volatile String apiToken;
    private volatile Proxy connectionProxy = null;
    private volatile PasswordAuthentication proxyCredential = null;
    private volatile Map<String, String> appInfo = null;
    private final AtlanTagCache atlanTagCache;
    private final CustomMetadataCache customMetadataCache;
    private final EnumCache enumCache;
    private final GroupCache groupCache;
    private final RoleCache roleCache;
    private final UserCache userCache;
    private final ObjectMapper mapper;
    public final TypeDefsEndpoint typeDefs;
    public final RolesEndpoint roles;
    public final ApiTokensEndpoint apiTokens;
    public final GroupsEndpoint groups;
    public final UsersEndpoint users;
    public final WorkflowsEndpoint workflows;
    public final QueryParserEndpoint queryParser;
    public final PlaybooksEndpoint playbooks;
    public final LogsEndpoint logs;
    public final ImagesEndpoint images;
    public final AssetEndpoint assets;
    public final RequestsEndpoint requests;
    private final AssetDeserializer assetDeserializer;
    private final CustomMetadataAuditDeserializer customMetadataAuditDeserializer;
    private final AtlanTagDeserializer atlanTagDeserializer;

    AtlanClient(String baseURL) {
        if (baseURL.equals("INTERNAL")) {
            this.apiBase = null;
            this.internalAccess = true;
        } else {
            this.internalAccess = false;
            this.apiBase = baseURL.endsWith("/") ? baseURL.substring(0, baseURL.lastIndexOf("/")) : baseURL;
        }
        this.mapper = Serde.createMapper(this);
        this.typeDefs = new TypeDefsEndpoint(this);
        this.roles = new RolesEndpoint(this);
        this.apiTokens = new ApiTokensEndpoint(this);
        this.groups = new GroupsEndpoint(this);
        this.users = new UsersEndpoint(this);
        this.workflows = new WorkflowsEndpoint(this);
        this.queryParser = new QueryParserEndpoint(this);
        this.playbooks = new PlaybooksEndpoint(this);
        this.logs = new LogsEndpoint(this);
        this.images = new ImagesEndpoint(this);
        this.assets = new AssetEndpoint(this);
        this.requests = new RequestsEndpoint(this);
        this.atlanTagCache = new AtlanTagCache(this.typeDefs);
        this.customMetadataCache = new CustomMetadataCache(this.typeDefs);
        this.enumCache = new EnumCache(this.typeDefs);
        this.groupCache = new GroupCache();
        this.roleCache = new RoleCache(this.roles);
        this.userCache = new UserCache();
        this.assetDeserializer = new AssetDeserializer(this);
        this.customMetadataAuditDeserializer = new CustomMetadataAuditDeserializer(this);
        this.atlanTagDeserializer = new AtlanTagDeserializer(this);
    }

    public <T> T readValue(String value, Class<T> clazz) throws IOException {
        return (T)this.mapper.readValue(value, clazz);
    }

    public <T> T readValue(byte[] value, Class<T> clazz) throws IOException {
        return (T)this.mapper.readValue(value, clazz);
    }

    public <T> T readValue(String value, TypeReference<T> typeRef) throws IOException {
        return (T)this.mapper.readValue(value, typeRef);
    }

    public <T> T convertValue(JsonNode value, TypeReference<T> typeReference) throws IllegalArgumentException {
        return (T)this.mapper.convertValue((Object)value, typeReference);
    }

    public <T> T convertValue(JsonNode value, Class<T> clazz) throws IllegalArgumentException {
        return (T)this.mapper.convertValue((Object)value, clazz);
    }

    public <T> String writeValueAsString(T value) throws IOException {
        return this.mapper.writeValueAsString(value);
    }

    public void writeValue(JsonGenerator g, Object value) throws IOException {
        this.mapper.writeValue(g, value);
    }

    public boolean isInternal() {
        return this.internalAccess;
    }

    public String getBaseUrl() {
        return this.apiBase;
    }

    public void setAppInfo(String name) {
        this.setAppInfo(name, null, null, null);
    }

    public void setAppInfo(String name, String version) {
        this.setAppInfo(name, version, null, null);
    }

    public void setAppInfo(String name, String version, String url) {
        this.setAppInfo(name, version, url, null);
    }

    public void setAppInfo(String name, String version, String url, String partnerId) {
        if (this.appInfo == null) {
            this.appInfo = new HashMap<String, String>();
        }
        this.appInfo.put("name", name);
        this.appInfo.put("version", version);
        this.appInfo.put("url", url);
        this.appInfo.put("partner_id", partnerId);
    }

    @Generated
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Generated
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Generated
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Generated
    public int getMaxNetworkRetries() {
        return this.maxNetworkRetries;
    }

    @Generated
    public void setMaxNetworkRetries(int maxNetworkRetries) {
        this.maxNetworkRetries = maxNetworkRetries;
    }

    @Generated
    public String getApiToken() {
        return this.apiToken;
    }

    @Generated
    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    @Generated
    public Proxy getConnectionProxy() {
        return this.connectionProxy;
    }

    @Generated
    public void setConnectionProxy(Proxy connectionProxy) {
        this.connectionProxy = connectionProxy;
    }

    @Generated
    public PasswordAuthentication getProxyCredential() {
        return this.proxyCredential;
    }

    @Generated
    public void setProxyCredential(PasswordAuthentication proxyCredential) {
        this.proxyCredential = proxyCredential;
    }

    @Generated
    public Map<String, String> getAppInfo() {
        return this.appInfo;
    }

    @Generated
    public AtlanTagCache getAtlanTagCache() {
        return this.atlanTagCache;
    }

    @Generated
    public CustomMetadataCache getCustomMetadataCache() {
        return this.customMetadataCache;
    }

    @Generated
    public EnumCache getEnumCache() {
        return this.enumCache;
    }

    @Generated
    public GroupCache getGroupCache() {
        return this.groupCache;
    }

    @Generated
    public RoleCache getRoleCache() {
        return this.roleCache;
    }

    @Generated
    public UserCache getUserCache() {
        return this.userCache;
    }

    @Generated
    public AssetDeserializer getAssetDeserializer() {
        return this.assetDeserializer;
    }

    @Generated
    public CustomMetadataAuditDeserializer getCustomMetadataAuditDeserializer() {
        return this.customMetadataAuditDeserializer;
    }

    @Generated
    public AtlanTagDeserializer getAtlanTagDeserializer() {
        return this.atlanTagDeserializer;
    }
}

