/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import co.elastic.clients.elasticsearch._types.SortOrder;
import com.atlan.AtlanClient;
import com.atlan.api.AtlasEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetDeletionResponse;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.AssetResponse;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.AtlanTag;
import com.atlan.model.core.ConnectionCreationResponse;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.enums.AtlanDeleteType;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.lineage.LineageListRequest;
import com.atlan.model.lineage.LineageListResponse;
import com.atlan.model.lineage.LineageRequest;
import com.atlan.model.lineage.LineageResponse;
import com.atlan.model.search.AuditSearchRequest;
import com.atlan.model.search.AuditSearchResponse;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.IndexSearchRequest;
import com.atlan.model.search.IndexSearchResponse;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import com.atlan.util.QueryFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetEndpoint
extends AtlasEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetEndpoint.class);
    private static final String audit_endpoint = "/entity/auditSearch";
    private static final String bulk_endpoint = "/entity/bulk";
    private static final String guid_endpoint = "/entity/guid/";
    private static final String unique_attr_endpoint = "/entity/uniqueAttribute/type/";
    private static final String search_endpoint = "/search/indexsearch";
    private static final String lineage_endpoint = "/lineage/getlineage";
    private static final String lineage_list_endpoint = "/lineage/list";

    public AssetEndpoint(AtlanClient client) {
        super(client);
    }

    public FluentSearch.FluentSearchBuilder<?, ?> select() {
        return this.select(false);
    }

    public FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(this.client);
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public AssetFilter.AssetFilterBuilder all() {
        return this.all(false);
    }

    @Deprecated
    public AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(this.client);
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public AuditSearchResponse auditLogs(AuditSearchRequest request) throws AtlanException {
        return this.auditLogs(request, null);
    }

    public AuditSearchResponse auditLogs(AuditSearchRequest request, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), audit_endpoint);
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, request, AuditSearchResponse.class, options);
    }

    public AssetMutationResponse save(Asset value) throws AtlanException {
        return this.save(value, null);
    }

    public AssetMutationResponse save(Asset value, RequestOptions options) throws AtlanException {
        return this.save(value, false, options);
    }

    public AssetMutationResponse save(Asset value, boolean replaceAtlanTags) throws AtlanException {
        return this.save(List.of(value), replaceAtlanTags, null);
    }

    public AssetMutationResponse save(Asset value, boolean replaceAtlanTags, RequestOptions options) throws AtlanException {
        return this.save(List.of(value), replaceAtlanTags, options);
    }

    public AssetMutationResponse save(List<Asset> values, boolean replaceAtlanTags) throws AtlanException {
        return this.save(values, replaceAtlanTags, null);
    }

    public AssetMutationResponse save(List<Asset> values, boolean replaceAtlanTags, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?replaceClassifications=%s&replaceBusinessAttributes=false&overwriteBusinessAttributes=false", bulk_endpoint, replaceAtlanTags));
        AtlanObject beq = ((BulkEntityRequest.BulkEntityRequestBuilder)BulkEntityRequest.builder().entities(values)).build();
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, beq, AssetMutationResponse.class, options);
    }

    public AssetMutationResponse saveMergingCM(List<Asset> values, boolean replaceAtlanTags) throws AtlanException {
        return this.saveMergingCM(values, replaceAtlanTags, null);
    }

    public AssetMutationResponse saveMergingCM(List<Asset> values, boolean replaceAtlanTags, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?replaceClassifications=%s&replaceBusinessAttributes=true&overwriteBusinessAttributes=false", bulk_endpoint, replaceAtlanTags));
        AtlanObject beq = ((BulkEntityRequest.BulkEntityRequestBuilder)BulkEntityRequest.builder().entities(values)).build();
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, beq, AssetMutationResponse.class, options);
    }

    public AssetMutationResponse saveReplacingCM(List<Asset> values, boolean replaceAtlanTags) throws AtlanException {
        return this.saveReplacingCM(values, replaceAtlanTags, null);
    }

    public AssetMutationResponse saveReplacingCM(List<Asset> values, boolean replaceAtlanTags, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?replaceClassifications=%s&replaceBusinessAttributes=true&overwriteBusinessAttributes=true", bulk_endpoint, replaceAtlanTags));
        AtlanObject beq = ((BulkEntityRequest.BulkEntityRequestBuilder)BulkEntityRequest.builder().entities(values)).build();
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, beq, AssetMutationResponse.class, options);
    }

    public ConnectionCreationResponse save(Connection value, boolean replaceAtlanTags) throws AtlanException {
        return this.save(value, replaceAtlanTags, null);
    }

    public ConnectionCreationResponse save(Connection value, boolean replaceAtlanTags, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?replaceClassifications=%s&replaceBusinessAttributes=false&overwriteBusinessAttributes=false", bulk_endpoint, replaceAtlanTags));
        AtlanObject beq = ((BulkEntityRequest.BulkEntityRequestBuilder)BulkEntityRequest.builder().entities(List.of(value))).build();
        ConnectionCreationResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, beq, ConnectionCreationResponse.class, options);
        response.setClient(this.client);
        return response;
    }

    public AssetDeletionResponse delete(String guid, AtlanDeleteType deleteType) throws AtlanException {
        return this.delete(List.of(guid), deleteType, null);
    }

    public AssetDeletionResponse delete(List<String> guids, AtlanDeleteType deleteType) throws AtlanException {
        return this.delete(guids, deleteType, null);
    }

    public AssetDeletionResponse delete(List<String> guids, AtlanDeleteType deleteType, RequestOptions options) throws AtlanException {
        if (guids != null) {
            StringBuilder guidList = new StringBuilder();
            for (String guid : guids) {
                if (guid == null) continue;
                guidList.append("guid=").append(guid).append("&");
            }
            if (guidList.length() > 0) {
                guidList.setLength(guidList.length() - 1);
                String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?%s&deleteType=%s", bulk_endpoint, guidList, deleteType));
                AssetDeletionResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.DELETE, url, "", AssetDeletionResponse.class, options);
                response.setClient(this.client);
                return response;
            }
        }
        throw new InvalidRequestException(ErrorCode.MISSING_GUID_FOR_DELETE);
    }

    public AssetMutationResponse restore(Asset value) throws AtlanException {
        return this.restore(List.of(value));
    }

    public AssetMutationResponse restore(Asset value, RequestOptions options) throws AtlanException {
        return this.restore(List.of(value), options);
    }

    public AssetMutationResponse restore(List<Asset> values) throws AtlanException {
        return this.restore(values, null);
    }

    public AssetMutationResponse restore(List<Asset> values, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?replaceClassifications=false&replaceBusinessAttributes=false&overwriteBusinessAttributes=false", bulk_endpoint));
        ArrayList<Asset> culled = new ArrayList<Asset>();
        for (Asset one : values) {
            culled.add((Asset)((Asset.AssetBuilder)one.trimToRequired().status(AtlanStatus.ACTIVE)).build());
        }
        AtlanObject beq = ((BulkEntityRequest.BulkEntityRequestBuilder)BulkEntityRequest.builder().entities(culled)).build();
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, beq, AssetMutationResponse.class, options);
    }

    public AssetResponse get(String guid, boolean ignoreRelationships, boolean minExtInfo) throws AtlanException {
        return this.get(guid, ignoreRelationships, minExtInfo, null);
    }

    public AssetResponse get(String guid, boolean ignoreRelationships, boolean minExtInfo, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s%s?ignoreRelationships=%s&minExtInfo=%s", guid_endpoint, ApiResource.urlEncodeId(guid), ignoreRelationships, minExtInfo));
        return ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", AssetResponse.class, options);
    }

    public void updateCustomMetadataAttributes(String guid, String cmName, CustomMetadataAttributes values) throws AtlanException {
        this.updateCustomMetadataAttributes(guid, cmName, values, null);
    }

    public void updateCustomMetadataAttributes(String guid, String cmName, CustomMetadataAttributes values, RequestOptions options) throws AtlanException {
        if (values != null) {
            this.client.getCustomMetadataCache().getIdForName(cmName);
            String url = String.format("%s%s", this.getBaseUrl(), String.format("%s%s/businessmetadata?isOverwrite=false", guid_endpoint, ApiResource.urlEncodeId(guid)));
            CustomMetadataUpdateRequest cmur = new CustomMetadataUpdateRequest(cmName, values.getAttributes(), true);
            ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, cmur, null, options);
        }
    }

    public void replaceCustomMetadata(String guid, String cmName, CustomMetadataAttributes values) throws AtlanException {
        this.replaceCustomMetadata(guid, cmName, values, null);
    }

    public void replaceCustomMetadata(String guid, String cmName, CustomMetadataAttributes values, RequestOptions options) throws AtlanException {
        String cmId = this.client.getCustomMetadataCache().getIdForName(cmName);
        Map<String, Object> baseMap = this.client.getCustomMetadataCache().getEmptyAttributes(cmName);
        if (values != null && !values.isEmpty()) {
            baseMap.putAll(values.getAttributes());
        }
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s%s/businessmetadata/%s", guid_endpoint, ApiResource.urlEncodeId(guid), ApiResource.urlEncodeId(cmId)));
        CustomMetadataUpdateRequest cmur = new CustomMetadataUpdateRequest(cmName, baseMap, false);
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, cmur, null, options);
    }

    public void removeCustomMetadata(String guid, String cmName) throws AtlanException {
        this.removeCustomMetadata(guid, cmName, null);
    }

    public void removeCustomMetadata(String guid, String cmName, RequestOptions options) throws AtlanException {
        this.client.getCustomMetadataCache().getIdForName(cmName);
        Map<String, Object> map = this.client.getCustomMetadataCache().getEmptyAttributes(cmName);
        AtlanObject cma = ((CustomMetadataAttributes.CustomMetadataAttributesBuilder)CustomMetadataAttributes.builder().attributes(map)).build();
        this.updateCustomMetadataAttributes(guid, cmName, (CustomMetadataAttributes)cma, options);
    }

    public AssetResponse get(String typeName, String qualifiedName, boolean ignoreRelationships, boolean minExtInfo) throws AtlanException {
        return this.get(typeName, qualifiedName, ignoreRelationships, minExtInfo, null);
    }

    public AssetResponse get(String typeName, String qualifiedName, boolean ignoreRelationships, boolean minExtInfo, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s%s?attr:qualifiedName=%s&ignoreRelationships=%s&minExtInfo=%s", unique_attr_endpoint, ApiResource.urlEncodeId(typeName), ApiResource.urlEncodeId(qualifiedName), ignoreRelationships, minExtInfo));
        return ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", AssetResponse.class, options);
    }

    public AssetMutationResponse updateAttributes(String typeName, String qualifiedName, Asset value) throws AtlanException {
        return this.updateAttributes(typeName, qualifiedName, value, null);
    }

    public AssetMutationResponse updateAttributes(String typeName, String qualifiedName, Asset value, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s%s?attr:qualifiedName=%s", unique_attr_endpoint, typeName, ApiResource.urlEncode(qualifiedName)));
        AtlanObject seq = ((SingleEntityRequest.SingleEntityRequestBuilder)SingleEntityRequest.builder().entity(value)).build();
        return ApiResource.request(this.client, ApiResource.RequestMethod.PUT, url, seq, AssetMutationResponse.class, options);
    }

    public void addAtlanTags(String typeName, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        this.addAtlanTags(typeName, qualifiedName, atlanTagNames, true, true, false, null);
    }

    public void addAtlanTags(String typeName, String qualifiedName, List<String> atlanTagNames, RequestOptions options) throws AtlanException {
        this.addAtlanTags(typeName, qualifiedName, atlanTagNames, true, true, false, options);
    }

    public void addAtlanTags(String typeName, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        this.addAtlanTags(typeName, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation, null);
    }

    public void addAtlanTags(String typeName, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation, RequestOptions options) throws AtlanException {
        ArrayList<AtlanTag> tags = new ArrayList<AtlanTag>();
        for (String atlanTagName : atlanTagNames) {
            tags.add((AtlanTag)((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)AtlanTag.builder().typeName(atlanTagName)).propagate(propagate)).removePropagationsOnEntityDelete(removePropagationsOnDelete)).restrictPropagationThroughLineage(restrictLineagePropagation)).build());
        }
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s%s/classifications?attr:qualifiedName=%s", unique_attr_endpoint, typeName, ApiResource.urlEncode(qualifiedName)));
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, new AtlanTagList(tags), null, options);
    }

    public void removeAtlanTag(String typeName, String qualifiedName, String atlanTagName, boolean idempotent) throws AtlanException {
        this.removeAtlanTag(typeName, qualifiedName, atlanTagName, idempotent, null);
    }

    public void removeAtlanTag(String typeName, String qualifiedName, String atlanTagName, boolean idempotent, RequestOptions options) throws AtlanException {
        String atlanTagId = this.client.getAtlanTagCache().getIdForName(atlanTagName);
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s%s/classification/%s?attr:qualifiedName=%s", unique_attr_endpoint, typeName, atlanTagId, ApiResource.urlEncode(qualifiedName)));
        try {
            ApiResource.request(this.client, ApiResource.RequestMethod.DELETE, url, "", null, options);
        }
        catch (InvalidRequestException e) {
            if (idempotent && e.getMessage().equals("ATLAS-400-00-06D")) {
                log.debug("Attempted to remove Atlan tag '{}' from asset that does not have the Atlan tag, ignoring: {}", (Object)atlanTagName, (Object)qualifiedName);
            }
            throw e;
        }
    }

    public IndexSearchResponse search(IndexSearchRequest request) throws AtlanException {
        return this.search(request, null);
    }

    public IndexSearchResponse search(IndexSearchRequest request, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), search_endpoint);
        if (request.getDsl().getSort() == null || request.getDsl().getSort().isEmpty()) {
            request = ((IndexSearchRequest.IndexSearchRequestBuilder)request.toBuilder().dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)request.getDsl().toBuilder().sortOption(IReferenceable.GUID.order(SortOrder.Asc))).build())).build();
        }
        IndexSearchResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, request, IndexSearchResponse.class, options);
        response.setClient(this.client);
        return response;
    }

    public LineageResponse lineage(LineageRequest request) throws AtlanException {
        return this.lineage(request, null);
    }

    public LineageResponse lineage(LineageRequest request, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), lineage_endpoint);
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, request, LineageResponse.class, options);
    }

    public LineageListResponse lineage(LineageListRequest request) throws AtlanException {
        return this.lineage(request, null);
    }

    public LineageListResponse lineage(LineageListRequest request, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), lineage_list_endpoint);
        LineageListResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, request, LineageListResponse.class, options);
        response.setClient(this.client);
        return response;
    }

    static class BulkEntityRequest
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        List<Asset> entities;

        @Generated
        protected BulkEntityRequest(BulkEntityRequestBuilder<?, ?> b) {
            super(b);
            this.entities = b.entities;
        }

        @Generated
        public static BulkEntityRequestBuilder<?, ?> builder() {
            return new BulkEntityRequestBuilderImpl();
        }

        @Generated
        public List<Asset> getEntities() {
            return this.entities;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkEntityRequest)) {
                return false;
            }
            BulkEntityRequest other = (BulkEntityRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Asset> this$entities = this.getEntities();
            List<Asset> other$entities = other.getEntities();
            return !(this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BulkEntityRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Asset> $entities = this.getEntities();
            result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
            return result;
        }

        @Generated
        private static final class BulkEntityRequestBuilderImpl
        extends BulkEntityRequestBuilder<BulkEntityRequest, BulkEntityRequestBuilderImpl> {
            @Generated
            private BulkEntityRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected BulkEntityRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public BulkEntityRequest build() {
                return new BulkEntityRequest(this);
            }
        }

        @Generated
        public static abstract class BulkEntityRequestBuilder<C extends BulkEntityRequest, B extends BulkEntityRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private List<Asset> entities;

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B entities(List<Asset> entities) {
                this.entities = entities;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "AssetEndpoint.BulkEntityRequest.BulkEntityRequestBuilder(super=" + super.toString() + ", entities=" + this.entities + ")";
            }
        }
    }

    static class CustomMetadataUpdateRequest
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        private final transient boolean includeName;
        private final transient String name;
        private final transient Map<String, Object> attributes;

        public CustomMetadataUpdateRequest(String name, Map<String, Object> attributes, boolean includeName) {
            this.name = name;
            this.attributes = attributes;
            this.includeName = includeName;
        }

        @Override
        public String toJson(AtlanClient client) {
            LinkedHashMap<String, Object> businessMetadataAttributes = new LinkedHashMap<String, Object>();
            try {
                client.getCustomMetadataCache().getIdMapFromNameMap(this.name, this.attributes, businessMetadataAttributes);
                if (this.includeName) {
                    LinkedHashMap<String, LinkedHashMap<String, Object>> wrapped = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
                    String cmId = client.getCustomMetadataCache().getIdForName(this.name);
                    wrapped.put(cmId, businessMetadataAttributes);
                    return client.writeValueAsString(wrapped);
                }
                return client.writeValueAsString(businessMetadataAttributes);
            }
            catch (AtlanException | IOException e) {
                throw new RuntimeException("Unable to serialize custom metadata for '" + this.name + "' with: " + this.attributes, e);
            }
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomMetadataUpdateRequest)) {
                return false;
            }
            CustomMetadataUpdateRequest other = (CustomMetadataUpdateRequest)o;
            return other.canEqual(this);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomMetadataUpdateRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    static class SingleEntityRequest
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        Asset entity;

        @Generated
        protected SingleEntityRequest(SingleEntityRequestBuilder<?, ?> b) {
            super(b);
            this.entity = b.entity;
        }

        @Generated
        public static SingleEntityRequestBuilder<?, ?> builder() {
            return new SingleEntityRequestBuilderImpl();
        }

        @Generated
        public Asset getEntity() {
            return this.entity;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SingleEntityRequest)) {
                return false;
            }
            SingleEntityRequest other = (SingleEntityRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Asset this$entity = this.getEntity();
            Asset other$entity = other.getEntity();
            return !(this$entity == null ? other$entity != null : !((Object)this$entity).equals(other$entity));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SingleEntityRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Asset $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : ((Object)$entity).hashCode());
            return result;
        }

        @Generated
        private static final class SingleEntityRequestBuilderImpl
        extends SingleEntityRequestBuilder<SingleEntityRequest, SingleEntityRequestBuilderImpl> {
            @Generated
            private SingleEntityRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected SingleEntityRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public SingleEntityRequest build() {
                return new SingleEntityRequest(this);
            }
        }

        @Generated
        public static abstract class SingleEntityRequestBuilder<C extends SingleEntityRequest, B extends SingleEntityRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private Asset entity;

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B entity(Asset entity) {
                this.entity = entity;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "AssetEndpoint.SingleEntityRequest.SingleEntityRequestBuilder(super=" + super.toString() + ", entity=" + this.entity + ")";
            }
        }
    }

    public static class AtlanTagList
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        private final List<AtlanTag> tags;

        public AtlanTagList(List<AtlanTag> tags) {
            this.tags = tags;
        }

        @Override
        public String toJson(AtlanClient client) {
            try {
                return client.writeValueAsString(this.tags);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to serialize list of Atlan tags.", e);
            }
        }
    }
}

