/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.api.HeraclesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AtlanGroup;
import com.atlan.model.admin.CreateGroupResponse;
import com.atlan.model.admin.GroupResponse;
import com.atlan.model.admin.UserResponse;
import com.atlan.model.core.AtlanObject;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class GroupsEndpoint
extends HeraclesEndpoint {
    private static final String endpoint = "/groups";

    public GroupsEndpoint(AtlanClient client) {
        super(client);
    }

    public GroupResponse list(String filter, String sort, boolean count, int offset, int limit) throws AtlanException {
        return this.list(filter, sort, count, offset, limit, null);
    }

    public GroupResponse list(String filter, String sort, boolean count, int offset, int limit, RequestOptions options) throws AtlanException {
        if (filter == null) {
            filter = "";
        }
        if (sort == null) {
            sort = "";
        }
        String url = String.format("%s%s?filter=%s&sort=%s&count=%s&offset=%s&limit=%s", this.getBaseUrl(), endpoint, ApiResource.urlEncode(filter), ApiResource.urlEncode(sort), count, offset, limit);
        return ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", GroupResponse.class, options);
    }

    public GroupResponse list(String filter) throws AtlanException {
        return this.list(filter, null);
    }

    public GroupResponse list(String filter, RequestOptions options) throws AtlanException {
        if (filter == null) {
            filter = "";
        }
        String url = String.format("%s%s?filter=%s", this.getBaseUrl(), endpoint, ApiResource.urlEncode(filter));
        return ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", GroupResponse.class, options);
    }

    public List<AtlanGroup> list() throws AtlanException {
        return this.list((RequestOptions)null);
    }

    public List<AtlanGroup> list(RequestOptions options) throws AtlanException {
        return this.list(20, options);
    }

    public List<AtlanGroup> list(int pageSize, RequestOptions options) throws AtlanException {
        ArrayList<AtlanGroup> groups = new ArrayList<AtlanGroup>();
        String unlimitedUrl = String.format("%s%s?sort=createdAt", this.getBaseUrl(), endpoint);
        int offset = 0;
        String url = String.format("%s&limit=%s&offset=%s", unlimitedUrl, pageSize, offset);
        GroupResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", GroupResponse.class, options);
        while (response != null) {
            List<AtlanGroup> page = response.getRecords();
            if (page != null) {
                groups.addAll(page);
                url = String.format("%s&limit=%s&offset=%s", unlimitedUrl, pageSize, offset += pageSize);
                response = ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", GroupResponse.class, null);
                continue;
            }
            response = null;
        }
        return groups;
    }

    public List<AtlanGroup> get(String alias) throws AtlanException {
        return this.get(alias, null);
    }

    public List<AtlanGroup> get(String alias, RequestOptions options) throws AtlanException {
        GroupResponse response = this.list("{\"$and\":[{\"alias\":{\"$ilike\":\"%" + alias + "%\"}}]}", options);
        if (response != null && response.getRecords() != null) {
            return response.getRecords();
        }
        return null;
    }

    public String create(AtlanGroup group) throws AtlanException {
        return this.create(group, (RequestOptions)null);
    }

    public String create(AtlanGroup group, RequestOptions options) throws AtlanException {
        CreateGroupResponse response = this.create(group, null, options);
        if (response != null) {
            return response.getGroup();
        }
        return null;
    }

    public CreateGroupResponse create(AtlanGroup group, List<String> userIds) throws AtlanException {
        return this.create(group, userIds, null);
    }

    public CreateGroupResponse create(AtlanGroup group, List<String> userIds, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), endpoint);
        Object cgr = CreateGroupRequest.builder().group(group);
        if (userIds != null && !userIds.isEmpty()) {
            cgr = ((CreateGroupRequest.CreateGroupRequestBuilder)cgr).users(userIds);
        }
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, ((CreateGroupRequest.CreateGroupRequestBuilder)cgr).build(), CreateGroupResponse.class, options);
    }

    public void update(String id, AtlanGroup group) throws AtlanException {
        this.update(id, group, null);
    }

    public void update(String id, AtlanGroup group, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s", this.getBaseUrl(), endpoint, id);
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, group, null, options);
    }

    public UserResponse listMembers(String id) throws AtlanException {
        return this.listMembers(id, null);
    }

    public UserResponse listMembers(String id, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s/members", this.getBaseUrl(), endpoint, id);
        return ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", UserResponse.class, options);
    }

    public void removeMembers(String id, List<String> userIds) throws AtlanException {
        this.removeMembers(id, userIds, null);
    }

    public void removeMembers(String id, List<String> userIds, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s/members/remove", this.getBaseUrl(), endpoint, id);
        AtlanObject rfgr = ((RemoveFromGroupRequest.RemoveFromGroupRequestBuilder)RemoveFromGroupRequest.builder().users(userIds)).build();
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, rfgr, null, options);
    }

    public void purge(String id) throws AtlanException {
        this.purge(id, null);
    }

    public void purge(String id, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s/delete", this.getBaseUrl(), endpoint, id);
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, "", null, options);
    }

    static final class RemoveFromGroupRequest
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        List<String> users;

        @Generated
        protected RemoveFromGroupRequest(RemoveFromGroupRequestBuilder<?, ?> b) {
            super(b);
            this.users = b.users;
        }

        @Generated
        public static RemoveFromGroupRequestBuilder<?, ?> builder() {
            return new RemoveFromGroupRequestBuilderImpl();
        }

        @Generated
        public List<String> getUsers() {
            return this.users;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveFromGroupRequest)) {
                return false;
            }
            RemoveFromGroupRequest other = (RemoveFromGroupRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$users = this.getUsers();
            List<String> other$users = other.getUsers();
            return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RemoveFromGroupRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $users = this.getUsers();
            result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
            return result;
        }

        @Generated
        private static final class RemoveFromGroupRequestBuilderImpl
        extends RemoveFromGroupRequestBuilder<RemoveFromGroupRequest, RemoveFromGroupRequestBuilderImpl> {
            @Generated
            private RemoveFromGroupRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected RemoveFromGroupRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public RemoveFromGroupRequest build() {
                return new RemoveFromGroupRequest(this);
            }
        }

        @Generated
        public static abstract class RemoveFromGroupRequestBuilder<C extends RemoveFromGroupRequest, B extends RemoveFromGroupRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private List<String> users;

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B users(List<String> users) {
                this.users = users;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "GroupsEndpoint.RemoveFromGroupRequest.RemoveFromGroupRequestBuilder(super=" + super.toString() + ", users=" + this.users + ")";
            }
        }
    }

    static final class CreateGroupRequest
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        AtlanGroup group;
        List<String> users;

        @Generated
        protected CreateGroupRequest(CreateGroupRequestBuilder<?, ?> b) {
            super(b);
            this.group = b.group;
            this.users = b.users;
        }

        @Generated
        public static CreateGroupRequestBuilder<?, ?> builder() {
            return new CreateGroupRequestBuilderImpl();
        }

        @Generated
        public AtlanGroup getGroup() {
            return this.group;
        }

        @Generated
        public List<String> getUsers() {
            return this.users;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateGroupRequest)) {
                return false;
            }
            CreateGroupRequest other = (CreateGroupRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AtlanGroup this$group = this.getGroup();
            AtlanGroup other$group = other.getGroup();
            if (this$group == null ? other$group != null : !((Object)this$group).equals(other$group)) {
                return false;
            }
            List<String> this$users = this.getUsers();
            List<String> other$users = other.getUsers();
            return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateGroupRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AtlanGroup $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : ((Object)$group).hashCode());
            List<String> $users = this.getUsers();
            result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
            return result;
        }

        @Generated
        private static final class CreateGroupRequestBuilderImpl
        extends CreateGroupRequestBuilder<CreateGroupRequest, CreateGroupRequestBuilderImpl> {
            @Generated
            private CreateGroupRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected CreateGroupRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public CreateGroupRequest build() {
                return new CreateGroupRequest(this);
            }
        }

        @Generated
        public static abstract class CreateGroupRequestBuilder<C extends CreateGroupRequest, B extends CreateGroupRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private AtlanGroup group;
            @Generated
            private List<String> users;

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B group(AtlanGroup group) {
                this.group = group;
                return (B)this.self();
            }

            @Generated
            public B users(List<String> users) {
                this.users = users;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "GroupsEndpoint.CreateGroupRequest.CreateGroupRequestBuilder(super=" + super.toString() + ", group=" + this.group + ", users=" + this.users + ")";
            }
        }
    }
}

