/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.api.HeraclesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AtlanImage;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ImagesEndpoint
extends HeraclesEndpoint {
    private static final String endpoint = "/images";

    public ImagesEndpoint(AtlanClient client) {
        super(client);
    }

    public AtlanImage upload(String fromUrl) throws AtlanException, MalformedURLException, IOException {
        return this.upload(fromUrl, null);
    }

    public AtlanImage upload(String fromUrl, RequestOptions options) throws AtlanException, MalformedURLException, IOException {
        URL url = new URL(fromUrl);
        return this.upload(url.openStream(), url.getFile(), options);
    }

    public AtlanImage upload(File file) throws AtlanException, IOException {
        return this.upload(file, null);
    }

    public AtlanImage upload(File file, RequestOptions options) throws AtlanException, IOException {
        return this.upload(new FileInputStream(file), file.getName(), options);
    }

    public AtlanImage upload(InputStream imageSrc, String filename) throws AtlanException {
        return this.upload(imageSrc, filename, null);
    }

    public AtlanImage upload(InputStream imageSrc, String filename, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), endpoint);
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, imageSrc, filename, AtlanImage.class, options);
    }
}

