/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.api.TypeDefsEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.AtlanTagDef;
import com.atlan.model.typedefs.TypeDefResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlanTagCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtlanTagCache.class);
    private Map<String, AtlanTagDef> cacheById = new ConcurrentHashMap<String, AtlanTagDef>();
    private Map<String, String> mapIdToName = new ConcurrentHashMap<String, String>();
    private Map<String, String> mapNameToId = new ConcurrentHashMap<String, String>();
    private final Set<String> deletedIds = ConcurrentHashMap.newKeySet();
    private final Set<String> deletedNames = ConcurrentHashMap.newKeySet();
    private final TypeDefsEndpoint typeDefsEndpoint;

    public AtlanTagCache(TypeDefsEndpoint typeDefsEndpoint) {
        this.typeDefsEndpoint = typeDefsEndpoint;
    }

    public synchronized void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of Atlan tags...");
        TypeDefResponse response = this.typeDefsEndpoint.list(AtlanTypeCategory.ATLAN_TAG);
        List<Object> tags = response != null ? response.getAtlanTagDefs() : Collections.emptyList();
        this.cacheById = new ConcurrentHashMap<String, AtlanTagDef>();
        this.mapIdToName = new ConcurrentHashMap<String, String>();
        this.mapNameToId = new ConcurrentHashMap<String, String>();
        for (AtlanTagDef atlanTagDef : tags) {
            String typeId = atlanTagDef.getName();
            this.cacheById.put(typeId, atlanTagDef);
            this.mapIdToName.put(typeId, atlanTagDef.getDisplayName());
            this.mapNameToId.put(atlanTagDef.getDisplayName(), typeId);
        }
    }

    public String getIdForName(String name) throws AtlanException {
        if (name != null && !name.isEmpty()) {
            String cmId = this.mapNameToId.get(name);
            if (cmId == null && !this.deletedNames.contains(name)) {
                this.refreshCache();
                cmId = this.mapNameToId.get(name);
                if (cmId == null) {
                    this.deletedNames.add(name);
                    throw new NotFoundException(ErrorCode.ATLAN_TAG_NOT_FOUND_BY_NAME, name);
                }
            }
            return cmId;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ATLAN_TAG_NAME);
    }

    public String getNameForId(String id) throws AtlanException {
        if (id != null && !id.isEmpty()) {
            String cmName = this.mapIdToName.get(id);
            if (cmName == null && !this.deletedIds.contains(id)) {
                this.refreshCache();
                cmName = this.mapIdToName.get(id);
                if (cmName == null) {
                    this.deletedIds.add(id);
                    throw new NotFoundException(ErrorCode.ATLAN_TAG_NOT_FOUND_BY_ID, id);
                }
            }
            return cmName;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ATLAN_TAG_ID);
    }
}

