/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.api.TypeDefsEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.EnumDef;
import com.atlan.model.typedefs.TypeDefResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnumCache.class);
    private Map<String, EnumDef> cacheById = new ConcurrentHashMap<String, EnumDef>();
    private final TypeDefsEndpoint typeDefsEndpoint;

    public EnumCache(TypeDefsEndpoint typeDefsEndpoint) {
        this.typeDefsEndpoint = typeDefsEndpoint;
    }

    public synchronized void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of enumerations...");
        TypeDefResponse response = this.typeDefsEndpoint.list(AtlanTypeCategory.ENUM);
        List<Object> enumerations = response != null ? response.getEnumDefs() : Collections.emptyList();
        this.cacheById = new ConcurrentHashMap<String, EnumDef>();
        for (EnumDef enumDef : enumerations) {
            String typeId = enumDef.getName();
            this.cacheById.put(typeId, enumDef);
        }
    }

    public EnumDef getByName(String name) throws AtlanException {
        if (name != null && !name.isEmpty()) {
            EnumDef enumDef = this.cacheById.get(name);
            if (enumDef == null) {
                this.refreshCache();
                enumDef = this.cacheById.get(name);
                if (enumDef == null) {
                    throw new NotFoundException(ErrorCode.ENUM_NOT_FOUND, name);
                }
            }
            return enumDef;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ENUM_NAME);
    }
}

