/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.admin.AtlanGroup;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupCache.class);
    private Map<String, String> mapIdToName = new ConcurrentHashMap<String, String>();
    private Map<String, String> mapNameToId = new ConcurrentHashMap<String, String>();
    private Map<String, String> mapAliasToId = new ConcurrentHashMap<String, String>();

    private synchronized void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of groups...");
        List<AtlanGroup> groups = AtlanGroup.list();
        this.mapIdToName = new ConcurrentHashMap<String, String>();
        this.mapNameToId = new ConcurrentHashMap<String, String>();
        this.mapAliasToId = new ConcurrentHashMap<String, String>();
        for (AtlanGroup group : groups) {
            String groupId = group.getId();
            String groupName = group.getName();
            String groupAlias = group.getAlias();
            this.mapIdToName.put(groupId, groupName);
            this.mapNameToId.put(groupName, groupId);
            this.mapAliasToId.put(groupAlias, groupId);
        }
    }

    public String getIdForName(String name) throws AtlanException {
        if (name != null && !name.isEmpty()) {
            String groupId = this.mapNameToId.get(name);
            if (groupId == null) {
                this.refreshCache();
                groupId = this.mapNameToId.get(name);
                if (groupId == null) {
                    throw new NotFoundException(ErrorCode.GROUP_NOT_FOUND_BY_NAME, name);
                }
            }
            return groupId;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_GROUP_NAME);
    }

    public String getIdForAlias(String alias) throws AtlanException {
        if (alias != null && !alias.isEmpty()) {
            String groupId = this.mapAliasToId.get(alias);
            if (groupId == null) {
                this.refreshCache();
                groupId = this.mapAliasToId.get(alias);
                if (groupId == null) {
                    throw new NotFoundException(ErrorCode.GROUP_NOT_FOUND_BY_ALIAS, alias);
                }
            }
            return groupId;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_GROUP_ALIAS);
    }

    public String getNameForId(String id) throws AtlanException {
        if (id != null && !id.isEmpty()) {
            String groupName = this.mapIdToName.get(id);
            if (groupName == null) {
                this.refreshCache();
                groupName = this.mapIdToName.get(id);
                if (groupName == null) {
                    throw new NotFoundException(ErrorCode.GROUP_NOT_FOUND_BY_ID, id);
                }
            }
            return groupName;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_GROUP_ID);
    }
}

