/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.serde.Removable;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectionCache {
    private static final Map<String, Map<String, Field>> fieldMap = new ConcurrentHashMap<String, Map<String, Field>>();
    private static final Map<String, Map<String, Method>> getterMap = new ConcurrentHashMap<String, Map<String, Method>>();
    private static final Map<String, Map<String, Method>> setterMap = new ConcurrentHashMap<String, Map<String, Method>>();
    private static final Map<String, Map<String, String>> attributesMap = new ConcurrentHashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, String>> fieldNameToSerialize = new ConcurrentHashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, String>> fieldNameToDeserialize = new ConcurrentHashMap<String, Map<String, String>>();
    private static final Map<String, Set<String>> fieldList = new ConcurrentHashMap<String, Set<String>>();

    private static void getAllFields(Map<String, Field> map, Class<?> b, Class<?> o) {
        Class<?> a = b.getSuperclass();
        if (a != null) {
            ReflectionCache.getAllFields(map, a, o);
        }
        String originalClassName = o.getCanonicalName();
        for (Field field : b.getDeclaredFields()) {
            if (field.isAnnotationPresent(JsonIgnore.class)) continue;
            String fieldName = field.getName();
            map.put(fieldName, field);
            if (field.isAnnotationPresent(JsonProperty.class)) {
                JsonProperty jp = field.getAnnotation(JsonProperty.class);
                String overrideName = jp.value();
                fieldNameToSerialize.get(originalClassName).put(fieldName, overrideName);
                fieldNameToDeserialize.get(originalClassName).put(overrideName, fieldName);
            }
            if (!field.isAnnotationPresent(Attribute.class)) continue;
            attributesMap.get(originalClassName).put(fieldName, fieldName);
        }
    }

    private static void getMethods(Map<String, Method> map, Class<?> b, String prefix) {
        Class<?> a = b.getSuperclass();
        if (a != null) {
            ReflectionCache.getMethods(map, a, prefix);
        }
        for (Method method : b.getDeclaredMethods()) {
            String name = method.getName();
            if (prefix == null) {
                map.put(name, method);
                continue;
            }
            if (!name.startsWith(prefix)) continue;
            map.put(StringUtils.getFieldNameFromMethodName(name), method);
        }
    }

    private static void addClass(Class<?> b) {
        HashMap<String, Method> map;
        String className = b.getCanonicalName();
        if (!fieldMap.containsKey(className)) {
            if (!fieldNameToSerialize.containsKey(className)) {
                fieldNameToSerialize.put(className, new ConcurrentHashMap());
            }
            if (!fieldNameToDeserialize.containsKey(className)) {
                fieldNameToDeserialize.put(className, new ConcurrentHashMap());
            }
            if (!attributesMap.containsKey(className)) {
                attributesMap.put(className, new ConcurrentHashMap());
            }
            map = new HashMap();
            ReflectionCache.getAllFields(map, b, b);
            fieldMap.put(className, Collections.unmodifiableMap(map));
        }
        if (className.endsWith("BuilderImpl")) {
            if (!setterMap.containsKey(className)) {
                map = new HashMap<String, Method>();
                ReflectionCache.getMethods(map, b, null);
                setterMap.put(className, Collections.unmodifiableMap(map));
            }
        } else if (!getterMap.containsKey(className)) {
            map = new HashMap();
            ReflectionCache.getMethods(map, b, "get");
            getterMap.put(className, Collections.unmodifiableMap(map));
        }
    }

    public static Set<String> getFieldNames(Class<?> b) {
        ReflectionCache.addClass(b);
        if (!fieldList.containsKey(b.getCanonicalName())) {
            HashSet<String> fields = new HashSet<String>(getterMap.get(b.getCanonicalName()).keySet());
            fields.retainAll(fieldMap.get(b.getCanonicalName()).keySet());
            fieldList.put(b.getCanonicalName(), Collections.unmodifiableSet(fields));
        }
        return fieldList.get(b.getCanonicalName());
    }

    public static Class<?> getFieldType(Class<?> b, String fieldName) {
        ReflectionCache.addClass(b);
        return fieldMap.get(b.getCanonicalName()).get(fieldName).getType();
    }

    public static boolean isAttribute(Class<?> b, String fieldName) {
        ReflectionCache.addClass(b);
        return attributesMap.get(b.getCanonicalName()).containsKey(fieldName);
    }

    public static Method getGetter(Class<?> b, String fieldName) {
        ReflectionCache.addClass(b);
        return getterMap.get(b.getCanonicalName()).get(fieldName);
    }

    public static Object getValue(Asset a, String fieldName) throws IOException {
        Method getter = ReflectionCache.getGetter(a.getClass(), fieldName);
        if (getter == null) {
            return null;
        }
        try {
            return getter.invoke((Object)a, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IOException("Failed to retrieve value for " + a.getClass().getName() + "." + fieldName + " through reflection.", e);
        }
    }

    public static Method getSetter(Class<?> b, String fieldName) {
        ReflectionCache.addClass(b);
        return setterMap.get(b.getCanonicalName()).get(fieldName);
    }

    public static boolean setValue(Asset.AssetBuilder<?, ?> builder, String fieldName, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method setter = ReflectionCache.getSetter(builder.getClass(), fieldName);
        if (setter != null) {
            if (value instanceof Removable) {
                builder.nullField(fieldName);
            } else if (value instanceof String && ((String)value).isEmpty()) {
                builder.nullField(fieldName);
            } else if (value == null) {
                builder.nullField(fieldName);
            } else {
                setter.invoke(builder, value);
            }
            return true;
        }
        return false;
    }

    public static String getSerializedName(Class<?> b, String fieldName) {
        ReflectionCache.addClass(b);
        return fieldNameToSerialize.get(b.getCanonicalName()).getOrDefault(fieldName, fieldName);
    }

    public static String getDeserializedName(Class<?> b, String fieldName) {
        ReflectionCache.addClass(b);
        return fieldNameToDeserialize.get(b.getCanonicalName()).getOrDefault(fieldName, fieldName);
    }

    public static Class<?> getParameterOfMethod(Method method) {
        Parameter[] params = method.getParameters();
        return params[0].getType();
    }

    public static Type getParameterizedTypeOfMethod(Method method) {
        Parameter[] params = method.getParameters();
        return params[0].getParameterizedType();
    }

    public static Class<?> getClassOfParameterizedType(Type parameterizedType) {
        WildcardType genericType;
        Type parameterType = null;
        if (parameterizedType instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)parameterizedType).getActualTypeArguments();
            parameterType = typeArguments[0];
        }
        if (parameterType instanceof ParameterizedType) {
            parameterType = ((ParameterizedType)parameterType).getRawType();
        } else if (parameterType instanceof WildcardType && (parameterType = (genericType = (WildcardType)parameterType).getUpperBounds()[0]) instanceof ParameterizedType) {
            parameterType = ((ParameterizedType)parameterType).getRawType();
        }
        return (Class)parameterType;
    }
}

