/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.api.RolesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.admin.AtlanRole;
import com.atlan.model.admin.RoleResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoleCache.class);
    private Map<String, AtlanRole> cacheById = new ConcurrentHashMap<String, AtlanRole>();
    private Map<String, String> mapIdToName = new ConcurrentHashMap<String, String>();
    private Map<String, String> mapNameToId = new ConcurrentHashMap<String, String>();
    private final RolesEndpoint rolesEndpoint;

    public RoleCache(RolesEndpoint rolesEndpoint) {
        this.rolesEndpoint = rolesEndpoint;
    }

    private synchronized void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of roles...");
        RoleResponse response = this.rolesEndpoint.list("{\"name\":{\"$ilike\":\"$%\"}}");
        List<Object> roles = response != null ? response.getRecords() : Collections.emptyList();
        this.cacheById = new ConcurrentHashMap<String, AtlanRole>();
        this.mapIdToName = new ConcurrentHashMap<String, String>();
        this.mapNameToId = new ConcurrentHashMap<String, String>();
        for (AtlanRole atlanRole : roles) {
            String roleId = atlanRole.getId();
            String roleName = atlanRole.getName();
            this.cacheById.put(roleId, atlanRole);
            this.mapIdToName.put(roleId, roleName);
            this.mapNameToId.put(roleName, roleId);
        }
    }

    public String getIdForName(String name) throws AtlanException {
        if (name != null && !name.isEmpty()) {
            String roleId = this.mapNameToId.get(name);
            if (roleId == null) {
                this.refreshCache();
                roleId = this.mapNameToId.get(name);
                if (roleId == null) {
                    throw new NotFoundException(ErrorCode.ROLE_NOT_FOUND_BY_NAME, name);
                }
            }
            return roleId;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ROLE_NAME);
    }

    public String getNameForId(String id) throws AtlanException {
        if (id != null && !id.isEmpty()) {
            String roleName = this.mapIdToName.get(id);
            if (roleName == null) {
                this.refreshCache();
                roleName = this.mapIdToName.get(id);
                if (roleName == null) {
                    throw new NotFoundException(ErrorCode.ROLE_NOT_FOUND_BY_ID, id);
                }
            }
            return roleName;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ROLE_ID);
    }
}

