/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.admin.AtlanUser;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserCache.class);
    private Map<String, String> mapIdToName = new ConcurrentHashMap<String, String>();
    private Map<String, String> mapNameToId = new ConcurrentHashMap<String, String>();
    private Map<String, String> mapEmailToId = new ConcurrentHashMap<String, String>();

    private synchronized void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of users...");
        List<AtlanUser> users = AtlanUser.list();
        this.mapIdToName = new ConcurrentHashMap<String, String>();
        this.mapNameToId = new ConcurrentHashMap<String, String>();
        this.mapEmailToId = new ConcurrentHashMap<String, String>();
        for (AtlanUser user : users) {
            String userId = user.getId();
            String userName = user.getUsername();
            String email = user.getEmail();
            this.mapIdToName.put(userId, userName);
            this.mapNameToId.put(userName, userId);
            this.mapEmailToId.put(email, userId);
        }
    }

    public String getIdForName(String username) throws AtlanException {
        if (username != null && !username.isEmpty()) {
            String userId = this.mapNameToId.get(username);
            if (userId == null) {
                this.refreshCache();
                userId = this.mapNameToId.get(username);
                if (userId == null) {
                    throw new NotFoundException(ErrorCode.USER_NOT_FOUND_BY_NAME, username);
                }
            }
            return userId;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_USER_NAME);
    }

    public String getIdForEmail(String email) throws AtlanException {
        if (email != null && !email.isEmpty()) {
            String userId = this.mapEmailToId.get(email);
            if (userId == null) {
                this.refreshCache();
                userId = this.mapEmailToId.get(email);
                if (userId == null) {
                    throw new NotFoundException(ErrorCode.USER_NOT_FOUND_BY_EMAIL, email);
                }
            }
            return userId;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_USER_EMAIL);
    }

    public String getNameForId(String id) throws AtlanException {
        if (id != null && !id.isEmpty()) {
            String userName = this.mapIdToName.get(id);
            if (userName == null) {
                this.refreshCache();
                userName = this.mapIdToName.get(id);
                if (userName == null) {
                    throw new NotFoundException(ErrorCode.USER_NOT_FOUND_BY_ID, id);
                }
            }
            return userName;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_USER_ID);
    }
}

