/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.api.TypeDefsEndpoint;
import com.atlan.generators.AttributeGenerator;
import com.atlan.generators.GeneratorConfig;
import com.atlan.generators.TypeGenerator;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.EntityDef;
import com.atlan.model.typedefs.EnumDef;
import com.atlan.model.typedefs.RelationshipAttributeDef;
import com.atlan.model.typedefs.StructDef;
import freemarker.template.TemplateNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetGenerator
extends TypeGenerator
implements Comparable<AssetGenerator> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetGenerator.class);
    public static final String DIRECTORY = "assets";
    private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
    private static final Comparator<AssetGenerator> assetComparator = Comparator.comparing(TypeGenerator::getOriginalName, stringComparator);
    private final EntityDef entityDef;
    private String parentClassName;
    private SortedSet<Attribute<?>> interfaceAttributes;
    private SortedSet<Attribute<?>> classAttributes;
    private SortedSet<Attribute<?>> nonInheritedAttributes;
    private List<AssetGenerator> originalSuperTypes = null;
    private List<AssetGenerator> fullSubTypes = null;
    private List<String> originalSubTypes = null;
    private List<String> subTypes = null;
    private List<String> mapContainers = null;
    private final Set<String> superTypes;

    public AssetGenerator(EntityDef entityDef, GeneratorConfig cfg) {
        super(entityDef, cfg);
        this.entityDef = entityDef;
        this.resolveClassName();
        this.description = this.cache.getTypeDescription(this.originalName);
        this.superTypes = this.cache.getAllSuperTypesForType(this.getOriginalName());
    }

    @Override
    protected void resolveClassName() {
        this.className = this.cfg.resolveClassName(this.originalName);
    }

    public String resolveSuperTypeName(String name) {
        if (name.equals("Referenceable")) {
            return name;
        }
        return this.cfg.resolveClassName(name);
    }

    public void resolveDetails() {
        this.resolveParentClassName();
        this.resolveSubTypes();
        this.resolveAttributes();
        this.resolveRelationships();
    }

    public String getClassTemplateFile() {
        try {
            return this.cfg.getFreemarkerConfig().getTemplate(this.className + ".ftl").getSourceName();
        }
        catch (TemplateNotFoundException templateNotFoundException) {
        }
        catch (IOException e) {
            log.error("Error reading template: {}.ftl", (Object)this.className, (Object)e);
        }
        return null;
    }

    public String getInterfaceTemplateFile() {
        try {
            return this.cfg.getFreemarkerConfig().getTemplate("I" + this.className + ".ftl").getSourceName();
        }
        catch (TemplateNotFoundException templateNotFoundException) {
        }
        catch (IOException e) {
            log.error("Error reading template: I{}.ftl", (Object)this.className, (Object)e);
        }
        return null;
    }

    public boolean isBuiltIn(String orgName, String reTyped) {
        if (orgName != null) {
            EntityDef entity = this.cache.getEntityDefCache().get(orgName);
            if (entity != null) {
                return entity.getServiceType() != null && TypeDefsEndpoint.RESERVED_SERVICE_TYPES.contains(entity.getServiceType());
            }
            StructDef struct = this.cache.getStructDefCache().get(orgName);
            if (struct != null) {
                return struct.getServiceType() != null && TypeDefsEndpoint.RESERVED_SERVICE_TYPES.contains(struct.getServiceType()) || GeneratorConfig.BUILT_IN_STRUCTS.contains(orgName);
            }
            EnumDef enumDef = this.cache.getEnumDefCache().get(orgName);
            return enumDef != null && enumDef.getServiceType() != null && TypeDefsEndpoint.RESERVED_SERVICE_TYPES.contains(enumDef.getServiceType()) || GeneratorConfig.BUILT_IN_ENUMS.contains(orgName) || orgName.equals("string") && GeneratorConfig.BUILT_IN_ENUMS.contains(reTyped);
        }
        return false;
    }

    public boolean isAbstract() {
        return this.originalSubTypes != null && !this.originalSubTypes.isEmpty() && !this.cfg.forceNonAbstract(this.getOriginalName());
    }

    public void resolveParentClassName() {
        this.parentClassName = this.getOriginalName().equals("Asset") ? "Reference" : "Asset";
    }

    public SortedSet<String> getAllSubTypes(String originalTypeName) {
        TreeSet<String> localSubTypes = new TreeSet<String>();
        AssetGenerator assetGen = this.cache.getCachedAssetType(originalTypeName);
        if (assetGen != null) {
            List<String> subTypes;
            assetGen.resolveSubTypes();
            if (!assetGen.isAbstract()) {
                log.info("Adding concrete subtype {} to: {}", (Object)assetGen.getClassName(), (Object)originalTypeName);
                localSubTypes.add(assetGen.getClassName());
            }
            if ((subTypes = assetGen.getOriginalSubTypes()) != null && !subTypes.isEmpty()) {
                for (String subType : subTypes) {
                    SortedSet<String> further = this.getAllSubTypes(subType);
                    localSubTypes.addAll(further);
                }
            }
        }
        return localSubTypes;
    }

    private void resolveSubTypes() {
        List<String> superTypes;
        this.originalSubTypes = this.entityDef.getSubTypes();
        if (this.originalSubTypes != null && !this.originalSubTypes.isEmpty()) {
            this.subTypes = new ArrayList<String>();
            this.fullSubTypes = new ArrayList<AssetGenerator>();
            for (String originalSubType : this.originalSubTypes) {
                AssetGenerator sub = this.cache.getCachedAssetType(originalSubType);
                if (sub != null) {
                    this.fullSubTypes.add(sub);
                }
                if (!this.cfg.includeTypedef(sub.getEntityDef())) continue;
                TypeGenerator.MappedType subType = this.cache.getCachedType(originalSubType);
                if (subType != null) {
                    this.subTypes.add(subType.getName());
                    continue;
                }
                log.warn("Mapped subType was not found: {}", (Object)originalSubType);
            }
        }
        if ((superTypes = this.entityDef.getSuperTypes()) != null && !superTypes.isEmpty()) {
            this.originalSuperTypes = new ArrayList<AssetGenerator>();
            for (String superType : superTypes) {
                AssetGenerator parent = this.cache.getCachedAssetType(superType);
                if (parent == null) continue;
                this.originalSuperTypes.add(parent);
            }
        }
    }

    private void resolveAttributes() {
        Attribute attribute;
        SortedSet<AttributeDef> allAttributes = this.getOriginalName().equals("Asset") ? this.cache.getAllAttributesForType(this.getOriginalName()) : this.cache.getAllNonAssetAttributesForType(this.getOriginalName());
        this.nonInheritedAttributes = new TreeSet();
        for (AttributeDef attributeDef : this.cache.getEntityDefCache().get(this.getOriginalName()).getAttributeDefs()) {
            attribute = new Attribute(this.className, attributeDef, this.cfg);
            if (attribute.getType().getName().equals("Internal")) continue;
            this.nonInheritedAttributes.add(attribute);
            this.checkAndAddMapContainer(attribute);
        }
        this.classAttributes = new TreeSet();
        for (AttributeDef attributeDef : allAttributes) {
            attribute = new Attribute(this.className, attributeDef, this.cfg);
            if (attribute.getType().getName().equals("Internal")) continue;
            this.classAttributes.add(attribute);
            this.checkAndAddMapContainer(attribute);
        }
        this.interfaceAttributes = new TreeSet();
        for (AttributeDef attributeDef : this.cache.getAllAttributesForType(this.getOriginalName())) {
            attribute = new Attribute(this.className, attributeDef, this.cfg);
            if (attribute.getType().getName().equals("Internal")) continue;
            this.interfaceAttributes.add(attribute);
            this.checkAndAddMapContainer(attribute);
        }
    }

    private void resolveRelationships() {
        Attribute attribute;
        SortedSet<RelationshipAttributeDef> allRelationships = this.getOriginalName().equals("Asset") ? this.cache.getAllRelationshipsForType(this.getOriginalName()) : this.cache.getAllNonAssetRelationshipsForType(this.getOriginalName());
        Set<String> uniqueRelationships = this.cache.getUniqueRelationshipsForType(this.getOriginalName());
        for (RelationshipAttributeDef relationshipAttributeDef : this.cache.getEntityDefCache().get(this.getOriginalName()).getRelationshipAttributeDefs()) {
            if (!uniqueRelationships.contains(relationshipAttributeDef.getName()) || (attribute = new Attribute(this.className, relationshipAttributeDef, this.cfg)).getType().getName().equals("Internal")) continue;
            this.nonInheritedAttributes.add(attribute);
            this.checkAndAddMapContainer(attribute);
        }
        for (RelationshipAttributeDef relationshipAttributeDef : allRelationships) {
            attribute = new Attribute(this.className, relationshipAttributeDef, this.cfg);
            if (attribute.getType().getName().equals("Internal")) continue;
            this.classAttributes.add(attribute);
            this.checkAndAddMapContainer(attribute);
        }
        for (RelationshipAttributeDef relationshipAttributeDef : this.cache.getAllRelationshipsForType(this.getOriginalName())) {
            attribute = new Attribute(this.className, relationshipAttributeDef, this.cfg);
            if (attribute.getType().getName().equals("Internal")) continue;
            this.interfaceAttributes.add(attribute);
            this.checkAndAddMapContainer(attribute);
        }
    }

    private void checkAndAddMapContainer(Attribute<?> attribute) {
        if (attribute.getType().getContainer() != null && attribute.getType().getContainer().contains("Map")) {
            if (this.mapContainers == null) {
                this.mapContainers = new ArrayList<String>();
            }
            this.mapContainers.add(attribute.getRenamed());
        }
    }

    @Override
    public int compareTo(AssetGenerator o) {
        return assetComparator.compare(this, o);
    }

    @Generated
    public EntityDef getEntityDef() {
        return this.entityDef;
    }

    @Generated
    public String getParentClassName() {
        return this.parentClassName;
    }

    @Generated
    public SortedSet<Attribute<?>> getInterfaceAttributes() {
        return this.interfaceAttributes;
    }

    @Generated
    public SortedSet<Attribute<?>> getClassAttributes() {
        return this.classAttributes;
    }

    @Generated
    public SortedSet<Attribute<?>> getNonInheritedAttributes() {
        return this.nonInheritedAttributes;
    }

    @Generated
    public List<AssetGenerator> getOriginalSuperTypes() {
        return this.originalSuperTypes;
    }

    @Generated
    public List<AssetGenerator> getFullSubTypes() {
        return this.fullSubTypes;
    }

    @Generated
    public List<String> getOriginalSubTypes() {
        return this.originalSubTypes;
    }

    @Generated
    public List<String> getSubTypes() {
        return this.subTypes;
    }

    @Generated
    public List<String> getMapContainers() {
        return this.mapContainers;
    }

    @Generated
    public Set<String> getSuperTypes() {
        return this.superTypes;
    }

    public static class Attribute<T extends Attribute<?>>
    extends AttributeGenerator
    implements Comparable<T> {
        private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
        private static final Comparator<Attribute<?>> attributeComparator = Comparator.comparing(AttributeGenerator::getRenamed, stringComparator);
        private String searchType;
        private String searchTypeArgs;

        protected Attribute(GeneratorConfig cfg) {
            super(cfg);
        }

        public Attribute(String className, AttributeDef attributeDef, GeneratorConfig cfg) {
            super(className, attributeDef, cfg);
        }

        @Override
        protected void resolveName() {
            super.resolveName();
            this.setRenamed(this.cfg.resolveAttributeName(this.getOriginalName()));
        }

        @Override
        protected void resolveType(AttributeDef attributeDef) {
            Map<IndexType, String> searchMap;
            Set<IndexType> indices;
            String assetTypeOverride;
            super.resolveType(attributeDef);
            String enumName = this.cfg.resolveAttributeToEnumeration(this.getOriginalName());
            if (enumName != null) {
                this.setType(this.getType().toBuilder().name(enumName).type(TypeGenerator.MappedType.Type.ENUM).build());
            }
            if ((assetTypeOverride = this.cfg.resolveAttributeToTypeOverride(this.className, this.getOriginalName())) != null) {
                this.setType(this.getType().toBuilder().name(assetTypeOverride).type(TypeGenerator.MappedType.Type.ASSET).build());
                this.setRetyped(true);
            }
            if (!(indices = (searchMap = this.getIndexesForAttribute(attributeDef)).keySet()).isEmpty()) {
                if (indices.equals(Set.of(IndexType.RELATION))) {
                    this.searchType = "RelationField";
                    this.searchTypeArgs = null;
                } else if (indices.equals(Set.of(IndexType.KEYWORD))) {
                    this.searchType = "KeywordField";
                    this.searchTypeArgs = "\"" + searchMap.get((Object)IndexType.KEYWORD) + "\"";
                } else if (indices.equals(Set.of(IndexType.TEXT))) {
                    this.searchType = "TextField";
                    this.searchTypeArgs = "\"" + searchMap.get((Object)IndexType.TEXT) + "\"";
                } else if (indices.equals(Set.of(IndexType.NUMERIC))) {
                    this.searchType = "NumericField";
                    this.searchTypeArgs = "\"" + searchMap.get((Object)IndexType.NUMERIC) + "\"";
                } else if (indices.equals(Set.of(IndexType.BOOLEAN))) {
                    this.searchType = "BooleanField";
                    this.searchTypeArgs = "\"" + searchMap.get((Object)IndexType.BOOLEAN) + "\"";
                } else if (indices.equals(Set.of(IndexType.NUMERIC, IndexType.RANK_FEATURE))) {
                    this.searchType = "NumericRankField";
                    this.searchTypeArgs = "\"" + searchMap.get((Object)IndexType.NUMERIC) + "\", \"" + searchMap.get((Object)IndexType.RANK_FEATURE) + "\"";
                } else if (indices.equals(Set.of(IndexType.KEYWORD, IndexType.TEXT))) {
                    this.searchType = "KeywordTextField";
                    this.searchTypeArgs = "\"" + searchMap.get((Object)IndexType.KEYWORD) + "\", \"" + searchMap.get((Object)IndexType.TEXT) + "\"";
                } else if (indices.equals(Set.of(IndexType.KEYWORD, IndexType.TEXT, IndexType.STEMMED))) {
                    this.searchType = "KeywordTextStemmedField";
                    this.searchTypeArgs = "\"" + searchMap.get((Object)IndexType.KEYWORD) + "\", \"" + searchMap.get((Object)IndexType.TEXT) + "\", \"" + searchMap.get((Object)IndexType.STEMMED) + "\"";
                } else {
                    log.warn("Found index combination for {} that is not handled: {}", (Object)this.getOriginalName(), indices);
                }
            }
        }

        public String getSingular() {
            if (this.getType().getContainer() != null) {
                return this.cfg.resolveSingular(this.getOriginalName());
            }
            return null;
        }

        private Map<IndexType, String> getIndexesForAttribute(AttributeDef attributeDef) {
            LinkedHashMap<IndexType, String> searchable = new LinkedHashMap<IndexType, String>();
            Map<String, String> config = attributeDef.getIndexTypeESConfig();
            String attrName = attributeDef.getName();
            if (attributeDef instanceof RelationshipAttributeDef) {
                searchable.put(IndexType.RELATION, attrName);
            } else {
                if (config != null && config.containsKey("analyzer")) {
                    String analyzer = config.get("analyzer");
                    if (analyzer.equals("atlan_text_analyzer")) {
                        if (attrName.endsWith(".stemmed")) {
                            searchable.put(IndexType.STEMMED, attrName);
                        } else {
                            searchable.put(IndexType.TEXT, attrName);
                        }
                    } else {
                        log.warn("Unknown analyzer on attribute {}: {}", (Object)attrName, (Object)analyzer);
                    }
                } else {
                    IndexType defIndex = Attribute.getDefaultIndexForType(this.getType());
                    searchable.put(defIndex, attrName);
                }
                boolean duplicate = false;
                Map<String, Map<String, String>> fields = attributeDef.getIndexTypeESFields();
                if (fields != null) {
                    for (Map.Entry<String, Map<String, String>> entry : fields.entrySet()) {
                        String fieldName = attrName + "." + entry.getKey();
                        Map<String, String> indexDetails = entry.getValue();
                        if (indexDetails != null && indexDetails.containsKey("type")) {
                            String indexType;
                            switch (indexType = indexDetails.get("type")) {
                                case "keyword": {
                                    duplicate = searchable.put(IndexType.KEYWORD, fieldName) != null;
                                    break;
                                }
                                case "text": {
                                    if (fieldName.endsWith(".stemmed")) {
                                        duplicate = searchable.put(IndexType.STEMMED, fieldName) != null;
                                        break;
                                    }
                                    duplicate = searchable.put(IndexType.TEXT, fieldName) != null;
                                    break;
                                }
                                case "rank_feature": {
                                    duplicate = searchable.put(IndexType.RANK_FEATURE, fieldName) != null;
                                    break;
                                }
                                default: {
                                    log.warn("Unknown index type on attribute {}, field {}: {}", new Object[]{attributeDef.getName(), fieldName, indexType});
                                    break;
                                }
                            }
                            continue;
                        }
                        IndexType defIndex = Attribute.getDefaultIndexForType(this.getType());
                        duplicate = searchable.put(defIndex, fieldName) != null;
                    }
                }
                if (duplicate) {
                    log.info("Same attribute had multiple (identical) index references: {}", (Object)attrName);
                }
            }
            return searchable;
        }

        private static IndexType getDefaultIndexForType(TypeGenerator.MappedType type) {
            IndexType toUse;
            String baseType;
            switch (baseType = type.getOriginalBase()) {
                case "date": 
                case "float": 
                case "double": 
                case "int": 
                case "long": {
                    toUse = IndexType.NUMERIC;
                    break;
                }
                case "boolean": {
                    toUse = IndexType.BOOLEAN;
                    break;
                }
                default: {
                    toUse = IndexType.KEYWORD;
                }
            }
            return toUse;
        }

        public String getEnumForAttr() {
            return this.getRenamed().replaceAll("_", "").replaceAll("([A-Z]+)([A-Z][a-z])", "$1_$2").replaceAll("([a-z])([A-Z])", "$1_$2").toUpperCase(Locale.ROOT);
        }

        @Override
        public int compareTo(Attribute o) {
            return attributeComparator.compare(this, o);
        }

        @Generated
        public String getSearchType() {
            return this.searchType;
        }

        @Generated
        public String getSearchTypeArgs() {
            return this.searchTypeArgs;
        }

        static enum IndexType {
            KEYWORD,
            TEXT,
            RANK_FEATURE,
            BOOLEAN,
            NUMERIC,
            STEMMED,
            RELATION;

        }
    }
}

