/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeCSVCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttributeCSVCache.class);
    private static final String CSV_TYPE_NAME = "Type Name";
    private static final String CSV_TYPE_DESC = "Type Description";
    private static final String CSV_ATTR_NAME = "Attribute Name";
    private static final String CSV_ATTR_DESC = "Attribute Description";
    public static final String[] CSV_HEADER = List.of("Type Name", "Type Description", "Attribute Name", "Attribute Description").toArray(new String[0]);
    static final String DEFAULT_ATTR_DESCRIPTION = "TBC";
    static final String DEFAULT_CLASS_DESCRIPTION = "TBC";
    private static boolean haveCached = false;
    public static final String DESCRIPTIONS_FILE = "src" + File.separator + "main" + File.separator + "resources" + File.separator + "attributes.csv";
    private static final Map<String, String> qualifiedAttrToDescription = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> typeNameToDescription = new ConcurrentHashMap<String, String>();

    public static void cacheDescriptions() {
        if (!haveCached) {
            try (BufferedReader in = Files.newBufferedReader(Paths.get(DESCRIPTIONS_FILE, new String[0]), StandardCharsets.UTF_8);){
                CSVParser records = CSVFormat.DEFAULT.builder().setHeader(CSV_HEADER).setSkipHeaderRecord(true).build().parse((Reader)in);
                for (CSVRecord record : records) {
                    String typeName = record.get(CSV_TYPE_NAME);
                    String typeDesc = record.get(CSV_TYPE_DESC);
                    typeNameToDescription.put(typeName, typeDesc == null || typeDesc.length() == 0 ? "" : typeDesc);
                    String attrName = record.get(CSV_ATTR_NAME);
                    String attrDesc = record.get(CSV_ATTR_DESC);
                    if (attrDesc == null || attrDesc.length() <= 0) continue;
                    String attrQN = AttributeCSVCache.getAttrQualifiedName(typeName, attrName);
                    qualifiedAttrToDescription.put(attrQN, attrDesc);
                }
            }
            catch (IOException e) {
                log.warn("Unable to access or read descriptions CSV file \u2014 will only use descriptions direct from type definitions.", (Throwable)e);
            }
            haveCached = true;
        }
    }

    static String getAttrQualifiedName(String typeName, String attrName) {
        return typeName + "|" + attrName;
    }

    public static String getTypeDescription(String typeName) {
        if (typeNameToDescription.isEmpty()) {
            AttributeCSVCache.cacheDescriptions();
        }
        return typeNameToDescription.getOrDefault(typeName, "TBC");
    }

    public static String getAttributeDescription(String objectName, String attrName) {
        String attrQN = AttributeCSVCache.getAttrQualifiedName(objectName, attrName);
        if (qualifiedAttrToDescription.isEmpty()) {
            AttributeCSVCache.cacheDescriptions();
        }
        return qualifiedAttrToDescription.getOrDefault(attrQN, "TBC");
    }
}

