/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.generators.AbstractGenerator;
import com.atlan.generators.AssetDocGenerator;
import com.atlan.generators.AssetGenerator;
import com.atlan.generators.AttributeCSVCache;
import com.atlan.generators.EnumGenerator;
import com.atlan.generators.GeneratorConfig;
import com.atlan.generators.StructGenerator;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.EntityDef;
import com.atlan.model.typedefs.EnumDef;
import com.atlan.model.typedefs.RelationshipAttributeDef;
import com.atlan.model.typedefs.StructDef;
import com.atlan.model.typedefs.TypeDef;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocGenerator
extends AbstractGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocGenerator.class);

    public DocGenerator(GeneratorConfig cfg) {
        super(cfg);
    }

    @Override
    public void generate() throws Exception {
        this.generateAssetDocs();
        this.generateEnumDocs();
        this.generateStructDocs();
        this.generateFullModelDiagram();
        this.generateAttributeCSV();
    }

    private void generateAssetDocs() throws Exception {
        Template docTemplate = this.ftl.getTemplate("asset_doc.ftl");
        Template javaPropertySnippetTemplate = this.ftl.getTemplate("snippet_java_properties.ftl");
        Template javaRelationshipSnippetTemplate = this.ftl.getTemplate("snippet_java_relationships.ftl");
        Template rawPropertySnippetTemplate = this.ftl.getTemplate("snippet_raw_properties.ftl");
        Template rawRelationshipSnippetTemplate = this.ftl.getTemplate("snippet_raw_relationships.ftl");
        for (EntityDef entityDef : this.cache.getEntityDefCache().values()) {
            BufferedWriter fs;
            BufferedWriter fs2;
            if (!this.cfg.includeTypedef(entityDef)) continue;
            AssetGenerator assetGen = this.cache.getAssetGenerator(entityDef.getName());
            AssetDocGenerator generator = new AssetDocGenerator(assetGen, this.cfg);
            generator.resolveDetails();
            String originalName = generator.getOriginalName().toLowerCase(Locale.ROOT);
            String directory = AssetDocGenerator.DIRECTORY + File.separator + "entities";
            this.createDirectoryIdempotent(directory);
            String filename = directory + File.separator + originalName + ".md";
            try (BufferedWriter fs3 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
                docTemplate.process((Object)generator, (Writer)fs3);
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
            String javaSnippets = AssetDocGenerator.DIRECTORY + File.separator + "snippets" + File.separator + "model" + File.separator + "java";
            this.createDirectoryIdempotent(javaSnippets);
            filename = javaSnippets + File.separator + originalName + "-properties.md";
            try {
                fs2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));
                try {
                    javaPropertySnippetTemplate.process((Object)generator, (Writer)fs2);
                }
                finally {
                    fs2.close();
                }
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
            filename = javaSnippets + File.separator + originalName + "-relationships.md";
            try {
                fs2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));
                try {
                    javaRelationshipSnippetTemplate.process((Object)generator, (Writer)fs2);
                }
                finally {
                    fs2.close();
                }
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
            String rawSnippets = AssetDocGenerator.DIRECTORY + File.separator + "snippets" + File.separator + "model" + File.separator + "raw";
            this.createDirectoryIdempotent(rawSnippets);
            filename = rawSnippets + File.separator + originalName + "-properties.md";
            try {
                fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));
                try {
                    rawPropertySnippetTemplate.process((Object)generator, (Writer)fs);
                }
                finally {
                    fs.close();
                }
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
            filename = rawSnippets + File.separator + originalName + "-relationships.md";
            try {
                fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));
                try {
                    rawRelationshipSnippetTemplate.process((Object)generator, (Writer)fs);
                }
                finally {
                    fs.close();
                }
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
        }
    }

    private void generateEnumDocs() throws Exception {
        Template docTemplate = this.ftl.getTemplate("enum_doc.ftl");
        for (EnumDef enumDef : this.cache.getEnumDefCache().values()) {
            EnumGenerator enumGen = new EnumGenerator(enumDef, this.cfg);
            String originalName = enumGen.getOriginalName().toLowerCase(Locale.ROOT);
            String directory = AssetDocGenerator.DIRECTORY + File.separator + "enums";
            this.createDirectoryIdempotent(directory);
            String filename = directory + File.separator + originalName + ".md";
            try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
                docTemplate.process((Object)enumGen, (Writer)fs);
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
        }
    }

    private void generateStructDocs() throws Exception {
        Template docTemplate = this.ftl.getTemplate("struct_doc.ftl");
        Template javaPropertySnippetTemplate = this.ftl.getTemplate("snippet_java_properties_struct.ftl");
        Template rawPropertySnippetTemplate = this.ftl.getTemplate("snippet_raw_properties_struct.ftl");
        for (StructDef structDef : this.cache.getStructDefCache().values()) {
            StructGenerator structGen = new StructGenerator(structDef, this.cfg);
            String originalName = structGen.getOriginalName().toLowerCase(Locale.ROOT);
            String directory = AssetDocGenerator.DIRECTORY + File.separator + "structs";
            this.createDirectoryIdempotent(directory);
            String filename = directory + File.separator + originalName + ".md";
            try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
                docTemplate.process((Object)structGen, (Writer)fs);
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
            String javaSnippets = AssetDocGenerator.DIRECTORY + File.separator + "snippets" + File.separator + "model" + File.separator + "java";
            this.createDirectoryIdempotent(javaSnippets);
            filename = javaSnippets + File.separator + originalName + "-properties.md";
            try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
                javaPropertySnippetTemplate.process((Object)structGen, (Writer)fs);
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
            String rawSnippets = AssetDocGenerator.DIRECTORY + File.separator + "snippets" + File.separator + "model" + File.separator + "raw";
            this.createDirectoryIdempotent(rawSnippets);
            filename = rawSnippets + File.separator + originalName + "-properties.md";
            try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
                rawPropertySnippetTemplate.process((Object)structGen, (Writer)fs);
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
        }
    }

    private void generateFullModelDiagram() throws Exception {
        Template modelTemplate = this.ftl.getTemplate("full_model.ftl");
        AssetGenerator referenceable = this.cache.getAssetGenerator("Referenceable");
        AssetDocGenerator generator = new AssetDocGenerator(referenceable, this.cfg);
        generator.resolveDetails();
        this.createDirectoryIdempotent(AssetDocGenerator.DIRECTORY);
        String filename = AssetDocGenerator.DIRECTORY + File.separator + "index.md";
        try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
            modelTemplate.process((Object)generator, (Writer)fs);
        }
        catch (IOException e) {
            log.error("Unable to open file output: {}", (Object)filename, (Object)e);
        }
    }

    private void generateAttributeCSV() {
        try (CSVPrinter printer = new CSVPrinter((Appendable)Files.newBufferedWriter(Paths.get(AttributeCSVCache.DESCRIPTIONS_FILE, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]), CSVFormat.DEFAULT.builder().setHeader(AttributeCSVCache.CSV_HEADER).setRecordSeparator("\n").build());){
            List<Object> sortedTypeNames = this.cache.getEntityDefCache().keySet().stream().sorted().collect(Collectors.toList());
            for (String string : sortedTypeNames) {
                this.addModelToCSV(printer, string);
            }
            sortedTypeNames = this.cache.getStructNames();
            for (String string : sortedTypeNames) {
                this.addStructToCSV(printer, string);
            }
        }
        catch (IOException e) {
            log.error("Unable to create attributes CSV file as expected.", (Throwable)e);
            System.exit(1);
        }
    }

    private void addModelToCSV(CSVPrinter printer, String typeName) throws IOException {
        if (!typeName.startsWith("__")) {
            EntityDef entityDef = this.cache.getEntityDefCache().get(typeName);
            String description = this.addAttributesToCSV(printer, entityDef);
            Set<String> uniqueRelationships = this.cache.getUniqueRelationshipsForType(typeName);
            for (RelationshipAttributeDef relationship : entityDef.getRelationshipAttributeDefs()) {
                String name = relationship.getName();
                if (name.equals("__internal") || !uniqueRelationships.contains(name)) continue;
                printer.printRecord(new Object[]{typeName, description, name, this.getMergedDescription(typeName, relationship)});
            }
        }
    }

    private void addStructToCSV(CSVPrinter printer, String typeName) throws IOException {
        if (!typeName.startsWith("__")) {
            StructDef structDef = this.cache.getStructDefCache().get(typeName);
            this.addAttributesToCSV(printer, structDef);
        }
    }

    private String addAttributesToCSV(CSVPrinter printer, TypeDef typeDef) throws IOException {
        String typeName = typeDef.getName();
        String description = this.cache.getTypeDescription(typeName);
        for (AttributeDef attribute : typeDef.getAttributeDefs()) {
            String attrName = attribute.getName();
            if (attrName.equals("__internal")) continue;
            printer.printRecord(new Object[]{typeName, description, attribute.getName(), this.getMergedDescription(typeName, attribute)});
        }
        return description;
    }

    private String getMergedDescription(String typeName, AttributeDef attribute) {
        return this.cache.getAttributeDescription(typeName, attribute.getName());
    }
}

