/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.atlan.generators.AssetGenerator;
import com.atlan.generators.AttributeCSVCache;
import com.atlan.generators.EnumGenerator;
import com.atlan.generators.GeneratorConfig;
import com.atlan.generators.SearchFieldGenerator;
import com.atlan.generators.StructGenerator;
import com.atlan.generators.TypeGenerator;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.EntityDef;
import com.atlan.model.typedefs.EnumDef;
import com.atlan.model.typedefs.RelationshipAttributeDef;
import com.atlan.model.typedefs.RelationshipDef;
import com.atlan.model.typedefs.StructDef;
import com.atlan.model.typedefs.TypeDef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelCache.class);
    private final Map<String, EnumDef> enumDefCache;
    private final Map<String, StructDef> structDefCache;
    private final Map<String, EntityDef> entityDefCache;
    private final Map<String, RelationshipDef> relationshipDefCache;
    private final Map<String, EnumGenerator> enumCache = new HashMap<String, EnumGenerator>();
    private final Map<String, StructGenerator> structCache = new HashMap<String, StructGenerator>();
    private final Map<String, AssetGenerator> assetCache = new HashMap<String, AssetGenerator>();
    private final Map<String, Set<SearchFieldGenerator.Field>> searchCache = new HashMap<String, Set<SearchFieldGenerator.Field>>();
    private final Map<String, List<String>> subTypeToSuperTypes = new ConcurrentHashMap<String, List<String>>();
    private GeneratorConfig config = null;
    private static ModelCache INSTANCE = null;
    private static final Set<String> attributesToIgnore = Set.of("inputs", "outputs");

    private ModelCache() throws AtlanException {
        this.enumDefCache = new ConcurrentHashMap<String, EnumDef>();
        for (EnumDef enumDef : Atlan.getDefaultClient().typeDefs.list(AtlanTypeCategory.ENUM).getEnumDefs()) {
            this.enumDefCache.put(enumDef.getName(), enumDef);
        }
        this.structDefCache = new ConcurrentHashMap<String, StructDef>();
        for (StructDef structDef : Atlan.getDefaultClient().typeDefs.list(AtlanTypeCategory.STRUCT).getStructDefs()) {
            this.structDefCache.put(structDef.getName(), structDef);
        }
        this.entityDefCache = new ConcurrentHashMap<String, EntityDef>();
        for (EntityDef entityDef : Atlan.getDefaultClient().typeDefs.list(AtlanTypeCategory.ENTITY).getEntityDefs()) {
            this.entityDefCache.put(entityDef.getName(), entityDef);
        }
        this.relationshipDefCache = new ConcurrentHashMap<String, RelationshipDef>();
        for (RelationshipDef relationshipDef : Atlan.getDefaultClient().typeDefs.list(AtlanTypeCategory.RELATIONSHIP).getRelationshipDefs()) {
            this.relationshipDefCache.put(relationshipDef.getName(), relationshipDef);
        }
    }

    private static ModelCache createInstance(GeneratorConfig cfg) {
        try {
            ModelCache cache = new ModelCache();
            cache.config = cfg;
            cache.cacheInheritance(cache.getEntityDefCache().values());
            return cache;
        }
        catch (AtlanException e) {
            log.error("Unable to refresh typedef caches.", (Throwable)e);
            return null;
        }
    }

    public static ModelCache getInstance(GeneratorConfig cfg) {
        if (INSTANCE == null) {
            INSTANCE = ModelCache.createInstance(cfg);
        }
        return INSTANCE;
    }

    public EnumGenerator addEnumGenerator(String name, EnumGenerator generator) {
        return this.enumCache.put(name, generator);
    }

    public StructGenerator addStructGenerator(String name, StructGenerator generator) {
        return this.structCache.put(name, generator);
    }

    public AssetGenerator addAssetGenerator(String name, AssetGenerator generator) {
        return this.assetCache.put(name, generator);
    }

    public List<String> getStructNames() {
        return this.structCache.keySet().stream().sorted().collect(Collectors.toList());
    }

    public Collection<AssetGenerator> getAssetGenerators() {
        return this.assetCache.values();
    }

    public AssetGenerator getAssetGenerator(String entityDefName) {
        return this.assetCache.get(entityDefName);
    }

    public TypeGenerator.MappedType getCachedType(String typeName) {
        if (this.enumCache.containsKey(typeName)) {
            return TypeGenerator.MappedType.builder().type(TypeGenerator.MappedType.Type.ENUM).name(this.enumCache.get(typeName).getClassName()).build();
        }
        if (this.structCache.containsKey(typeName)) {
            return TypeGenerator.MappedType.builder().type(TypeGenerator.MappedType.Type.STRUCT).name(this.structCache.get(typeName).getClassName()).build();
        }
        if (this.assetCache.containsKey(typeName)) {
            return TypeGenerator.MappedType.builder().type(TypeGenerator.MappedType.Type.ASSET).name(this.assetCache.get(typeName).getClassName()).build();
        }
        return null;
    }

    public AssetGenerator getCachedAssetType(String typeName) {
        return this.assetCache.get(typeName);
    }

    public Set<String> getUniqueAttributesForType(String originalName) {
        EntityDef entityDef = this.entityDefCache.get(originalName);
        return new TreeSet<String>(entityDef.getAttributeDefs().stream().map(AttributeDef::getName).collect(Collectors.toSet()));
    }

    public Set<String> getUniqueRelationshipsForType(String originalName) {
        EntityDef entityDef = this.entityDefCache.get(originalName);
        TreeSet<String> startingPoint = new TreeSet<String>(entityDef.getRelationshipAttributeDefs().stream().map(AttributeDef::getName).collect(Collectors.toSet()));
        Set<String> superTypes = this.getAllSuperTypesForType(originalName);
        for (String superType : superTypes) {
            if (superType == null || superType.equals("Referenceable")) continue;
            EntityDef superDef = this.entityDefCache.get(superType);
            Set toRemove = superDef.getRelationshipAttributeDefs().stream().map(AttributeDef::getName).collect(Collectors.toSet());
            startingPoint.removeAll(toRemove);
        }
        return startingPoint;
    }

    public String getTypeDescription(String originalName) {
        String fromTypeDef = null;
        String fromCSV = AttributeCSVCache.getTypeDescription(originalName);
        TypeDef def = this.enumDefCache.getOrDefault(originalName, null);
        if (def == null) {
            def = this.structDefCache.getOrDefault(originalName, null);
        }
        if (def == null) {
            def = this.entityDefCache.getOrDefault(originalName, null);
        }
        if (def != null) {
            fromTypeDef = def.getDescription();
        }
        return this.getPreferredDescription(fromTypeDef, fromCSV, "TBC");
    }

    public String getAttributeDescription(String objectName, String attrName) {
        String fromTypeDef = null;
        String fromCSV = AttributeCSVCache.getAttributeDescription(objectName, attrName);
        TypeDef def = this.enumDefCache.getOrDefault(objectName, null);
        if (def == null) {
            def = this.structDefCache.getOrDefault(objectName, null);
        }
        if (def == null) {
            def = this.entityDefCache.getOrDefault(objectName, null);
        }
        if (def != null) {
            for (AttributeDef attributeDef : def.getAttributeDefs()) {
                if (!attrName.equals(attributeDef.getName())) continue;
                fromTypeDef = attributeDef.getDescription();
                break;
            }
            if (fromTypeDef == null && def instanceof EntityDef) {
                for (RelationshipAttributeDef relationshipAttributeDef : ((EntityDef)def).getRelationshipAttributeDefs()) {
                    String relnDefName = relationshipAttributeDef.getRelationshipTypeName();
                    RelationshipDef relnDef = this.relationshipDefCache.get(relnDefName);
                    if (relnDef == null) continue;
                    if (attrName.equals(relnDef.getEndDef1().getName())) {
                        fromTypeDef = relnDef.getEndDef1().getDescription();
                        break;
                    }
                    if (!attrName.equals(relnDef.getEndDef2().getName())) continue;
                    fromTypeDef = relnDef.getEndDef2().getDescription();
                    break;
                }
            }
        }
        return this.getPreferredDescription(fromTypeDef, fromCSV, "TBC");
    }

    private String getPreferredDescription(String fromTypeDef, String fromCSV, String fallback) {
        String typeDefIfExists;
        String string = typeDefIfExists = fromTypeDef != null && fromTypeDef.length() > 0 ? fromTypeDef : fromCSV;
        if (this.config.getPreferTypeDefDescriptions()) {
            return typeDefIfExists;
        }
        if (!fromCSV.equals(fallback)) {
            return fromCSV;
        }
        return typeDefIfExists;
    }

    private void cacheInheritance(Collection<EntityDef> toCache) {
        if (!toCache.isEmpty()) {
            ArrayList<EntityDef> leftOvers = new ArrayList<EntityDef>();
            for (EntityDef entityDef : toCache) {
                String typeName = entityDef.getName();
                List<String> superTypes = entityDef.getSuperTypes();
                if (superTypes == null || superTypes.isEmpty()) {
                    this.subTypeToSuperTypes.put(typeName, new ArrayList());
                } else {
                    this.subTypeToSuperTypes.put(typeName, superTypes);
                }
                if (superTypes == null || superTypes.isEmpty() || typeName.equals("Asset")) continue;
                for (String superType : superTypes) {
                    if (this.subTypeToSuperTypes.containsKey(superType)) continue;
                    leftOvers.add(this.entityDefCache.get(superType));
                }
            }
            this.cacheInheritance(leftOvers);
        }
    }

    public void addSearchFieldToCache(String className, String attrName, SearchFieldGenerator.Field field) {
        String attrQName = AttributeCSVCache.getAttrQualifiedName(className, attrName);
        if (!this.searchCache.containsKey(attrQName)) {
            this.searchCache.put(attrQName, new TreeSet());
        }
        this.searchCache.get(attrQName).add(field);
    }

    public Set<SearchFieldGenerator.Field> getCachedSearchFields(String className, String attrName) {
        return this.searchCache.get(AttributeCSVCache.getAttrQualifiedName(className, attrName));
    }

    public Set<String> getAllSuperTypesForType(String typeName) {
        List<String> next = this.subTypeToSuperTypes.get(typeName);
        if (next.isEmpty()) {
            LinkedHashSet<String> root = new LinkedHashSet<String>();
            root.add(typeName);
            return root;
        }
        LinkedHashSet<String> now = new LinkedHashSet<String>(next);
        for (String superType : next) {
            Set<String> again = this.getAllSuperTypesForType(superType);
            now.addAll(again);
        }
        return now;
    }

    public SortedSet<AttributeDef> getAllNonAssetAttributesForType(String originalName) {
        SortedSet<AttributeDef> all = this.getAllAttributesForType(originalName);
        all.removeAll(this.getAllAttributesForType("Asset"));
        return all;
    }

    public SortedSet<RelationshipAttributeDef> getAllNonAssetRelationshipsForType(String originalName) {
        SortedSet<RelationshipAttributeDef> all = this.getAllRelationshipsForType(originalName);
        all.removeAll(this.getAllRelationshipsForType("Asset"));
        return all;
    }

    SortedSet<AttributeDef> getAllAttributesForType(String originalName) {
        TreeSet<AttributeDef> full = new TreeSet<AttributeDef>();
        this.getAttributesForType(originalName, full, new HashSet<String>());
        return full;
    }

    private void getAttributesForType(String originalName, SortedSet<AttributeDef> aggregated, Set<String> processedTypes) {
        block2: {
            EntityDef entityDef;
            block3: {
                if (processedTypes.contains(originalName)) break block2;
                entityDef = this.entityDefCache.get(originalName);
                if (!originalName.equals("Referenceable")) break block3;
                List<AttributeDef> attrs = this.entityDefCache.get(originalName).getAttributeDefs();
                for (AttributeDef attributeDef : attrs) {
                    if (!attributeDef.getName().equals("qualifiedName")) continue;
                    aggregated.add(attributeDef);
                }
                break block2;
            }
            this.addAndLogAttributeConflicts(originalName, aggregated, entityDef.getAttributeDefs(), originalName);
            processedTypes.add(originalName);
            List<String> superTypes = entityDef.getSuperTypes();
            if (superTypes == null || superTypes.isEmpty()) break block2;
            for (String superType : superTypes) {
                this.getAttributesForType(superType, aggregated, processedTypes);
            }
        }
    }

    SortedSet<RelationshipAttributeDef> getAllRelationshipsForType(String originalName) {
        TreeSet<RelationshipAttributeDef> full = new TreeSet<RelationshipAttributeDef>();
        this.getRelationshipsForType(originalName, full, new HashSet<String>());
        return full;
    }

    private void getRelationshipsForType(String originalName, SortedSet<RelationshipAttributeDef> aggregated, Set<String> processedTypes) {
        block4: {
            EntityDef entityDef;
            block5: {
                if (processedTypes.contains(originalName)) break block4;
                entityDef = this.entityDefCache.get(originalName);
                if (!originalName.equals("Referenceable")) break block5;
                List<RelationshipAttributeDef> attrs = entityDef.getRelationshipAttributeDefs();
                for (RelationshipAttributeDef attributeDef : attrs) {
                    if (!attributeDef.getName().equals("meanings")) continue;
                    aggregated.add(attributeDef);
                }
                break block4;
            }
            Set<String> uniqueRelationships = this.getUniqueRelationshipsForType(originalName);
            TreeSet<RelationshipAttributeDef> retained = new TreeSet<RelationshipAttributeDef>();
            for (RelationshipAttributeDef attributeDef : entityDef.getRelationshipAttributeDefs()) {
                boolean added;
                if (!uniqueRelationships.contains(attributeDef.getName()) || (added = retained.add(attributeDef))) continue;
                log.warn("Conflicting relationship found for {}, within own typedef: {}", (Object)originalName, (Object)attributeDef.getName());
            }
            if (!retained.isEmpty()) {
                this.addAndLogRelationshipConflicts(originalName, aggregated, retained, originalName);
            }
            processedTypes.add(originalName);
            List<String> superTypes = entityDef.getSuperTypes();
            if (superTypes == null || superTypes.isEmpty()) break block4;
            for (String superType : superTypes) {
                this.getRelationshipsForType(superType, aggregated, processedTypes);
            }
        }
    }

    private void addAndLogAttributeConflicts(String typeName, SortedSet<AttributeDef> toAddTo, Collection<AttributeDef> toAdd, String fromSuperType) {
        for (AttributeDef one : toAdd) {
            boolean added;
            if (attributesToIgnore.contains(one.getName()) || (added = toAddTo.add(one))) continue;
            log.warn("Conflicting attribute found for {}, from {}: {}", new Object[]{typeName, fromSuperType, one.getName()});
        }
    }

    private void addAndLogRelationshipConflicts(String typeName, SortedSet<RelationshipAttributeDef> toAddTo, Collection<RelationshipAttributeDef> toAdd, String fromSuperType) {
        for (RelationshipAttributeDef one : toAdd) {
            boolean added = toAddTo.add(one);
            if (added) continue;
            log.warn("Conflicting relationship found for {}, from {}: {}", new Object[]{typeName, fromSuperType, one.getName()});
        }
    }

    @Generated
    public Map<String, EnumDef> getEnumDefCache() {
        return this.enumDefCache;
    }

    @Generated
    public Map<String, StructDef> getStructDefCache() {
        return this.structDefCache;
    }

    @Generated
    public Map<String, EntityDef> getEntityDefCache() {
        return this.entityDefCache;
    }

    @Generated
    public Map<String, RelationshipDef> getRelationshipDefCache() {
        return this.relationshipDefCache;
    }
}

