/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.generators.AbstractGenerator;
import com.atlan.generators.AssetGenerator;
import com.atlan.generators.EnumGenerator;
import com.atlan.generators.GeneratorConfig;
import com.atlan.generators.ListGenerator;
import com.atlan.generators.SearchFieldGenerator;
import com.atlan.generators.SerdeGenerator;
import com.atlan.generators.StructGenerator;
import com.atlan.model.typedefs.EntityDef;
import com.atlan.model.typedefs.EnumDef;
import com.atlan.model.typedefs.StructDef;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelGenerator
extends AbstractGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelGenerator.class);

    public ModelGenerator(GeneratorConfig cfg) {
        super(cfg);
    }

    @Override
    public void generate() throws Exception {
        this.generateEnums();
        this.generateStructs();
        this.generateAssets();
        this.generateSearchFields();
    }

    private void generateEnums() throws Exception {
        Template enumTemplate = this.ftl.getTemplate("enum.ftl");
        for (EnumDef enumDef : this.cache.getEnumDefCache().values()) {
            EnumGenerator generator = new EnumGenerator(enumDef, this.cfg);
            if (this.cfg.includeTypedef(enumDef)) {
                this.createDirectoryIdempotent(this.cfg.getPackagePath() + File.separator + "enums");
                String filename = this.cfg.getPackagePath() + File.separator + "enums" + File.separator + generator.getClassName() + ".java";
                try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
                    enumTemplate.process((Object)generator, (Writer)fs);
                    this.cache.addEnumGenerator(enumDef.getName(), generator);
                }
                catch (IOException e) {
                    log.error("Unable to open file output: {}", (Object)filename, (Object)e);
                }
                continue;
            }
            this.cache.addEnumGenerator(enumDef.getName(), generator);
        }
    }

    private void generateStructs() throws Exception {
        Template structTemplate = this.ftl.getTemplate("struct.ftl");
        for (StructDef structDef : this.cache.getStructDefCache().values()) {
            StructGenerator generator = new StructGenerator(structDef, this.cfg);
            if (this.cfg.includeTypedef(structDef)) {
                this.createDirectoryIdempotent(this.cfg.getPackagePath() + File.separator + "structs");
                String filename = this.cfg.getPackagePath() + File.separator + "structs" + File.separator + generator.getClassName() + ".java";
                try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
                    structTemplate.process((Object)generator, (Writer)fs);
                    this.cache.addStructGenerator(structDef.getName(), generator);
                }
                catch (IOException e) {
                    log.error("Unable to open file output: {}", (Object)filename, (Object)e);
                }
                continue;
            }
            this.cache.addStructGenerator(structDef.getName(), generator);
        }
        if (this.cfg.getPackageRoot().equals("com.atlan.model")) {
            Template abstractStructTemplate = this.ftl.getTemplate("AtlanStruct.ftl");
            this.createDirectoryIdempotent(this.cfg.getPackagePath() + File.separator + "structs");
            String filename = this.cfg.getPackagePath() + File.separator + "structs" + File.separator + "AtlanStruct.java";
            try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
                ListGenerator generator = new ListGenerator(this.cache.getStructNames(), this.cfg.getGeneratorName());
                abstractStructTemplate.process((Object)generator, (Writer)fs);
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
        }
    }

    private void generateAssets() throws Exception {
        for (EntityDef entityDef : this.cache.getEntityDefCache().values()) {
            AssetGenerator generator = new AssetGenerator(entityDef, this.cfg);
            this.cache.addAssetGenerator(entityDef.getName(), generator);
        }
        Template interfaceTemplate = this.ftl.getTemplate("entity_interface.ftl");
        Template entityTemplate = this.ftl.getTemplate("entity.ftl");
        for (EntityDef entityDef : this.cache.getEntityDefCache().values()) {
            if (!this.cfg.includeTypedef(entityDef)) continue;
            AssetGenerator generator = this.cache.getAssetGenerator(entityDef.getName());
            generator.resolveDetails();
            this.createDirectoryIdempotent(this.cfg.getPackagePath() + File.separator + "assets");
            String fInterface = this.cfg.getPackagePath() + File.separator + "assets" + File.separator + "I" + generator.getClassName() + ".java";
            try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fInterface), StandardCharsets.UTF_8));){
                interfaceTemplate.process((Object)generator, (Writer)fs);
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)fInterface, (Object)e);
            }
            if (!generator.getOriginalName().equals("Asset") && generator.isAbstract()) continue;
            String fClass = this.cfg.getPackagePath() + File.separator + "assets" + File.separator + generator.getClassName() + ".java";
            try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fClass), StandardCharsets.UTF_8));){
                entityTemplate.process((Object)generator, (Writer)fs);
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)fClass, (Object)e);
            }
        }
        if (this.cfg.getPackageRoot().equals("com.atlan.model")) {
            Template attributeDefOptionsTemplate = this.ftl.getTemplate("AttributeDefOptions.ftl");
            String directory = "src" + File.separator + "main" + File.separator + "java" + File.separator + "com" + File.separator + "atlan" + File.separator + "model" + File.separator + "typedefs";
            this.createDirectoryIdempotent(directory);
            String filename = directory + File.separator + "AttributeDefOptions.java";
            try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
                SerdeGenerator generator = new SerdeGenerator(this.cache.getAssetGenerators(), this.cfg);
                attributeDefOptionsTemplate.process((Object)generator, (Writer)fs);
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
        }
    }

    private void generateSearchFields() throws Exception {
        Template searchTemplate = this.ftl.getTemplate("enum_search.ftl");
        Set<SearchFieldGenerator.IndexType> enumsToGenerate = Set.of(SearchFieldGenerator.IndexType.NUMERIC, SearchFieldGenerator.IndexType.KEYWORD, SearchFieldGenerator.IndexType.TEXT, SearchFieldGenerator.IndexType.STEMMED, SearchFieldGenerator.IndexType.BOOLEAN, SearchFieldGenerator.IndexType.RANK_FEATURE);
        for (SearchFieldGenerator.IndexType toGenerate : enumsToGenerate) {
            log.info("Generating for: {}", (Object)toGenerate);
            SearchFieldGenerator generator = new SearchFieldGenerator(this.cache.getEntityDefCache().values(), toGenerate, this.cfg);
            this.createDirectoryIdempotent(this.cfg.getPackagePath() + File.separator + "enums");
            String filename = this.cfg.getPackagePath() + File.separator + "enums" + File.separator + generator.getClassName() + ".java";
            try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
                searchTemplate.process((Object)generator, (Writer)fs);
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
        }
    }
}

