/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.generators.AssetGenerator;
import com.atlan.generators.GeneratorConfig;
import com.atlan.generators.TypeGenerator;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.EntityDef;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchFieldGenerator
extends TypeGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchFieldGenerator.class);
    public static final String DIRECTORY = "enums";
    private final IndexType toGenerate;
    private SortedSet<Field> fields;
    private static final List<FieldDetails> COMMON_KEYWORDS = List.of(new FieldDetails("GUID", "__guid", "Globally unique identifier (GUID) of any object in Atlan.", IndexType.KEYWORD), new FieldDetails("CREATED_BY", "__createdBy", "Atlan user who created this asset.", IndexType.KEYWORD), new FieldDetails("MODIFIED_BY", "__modifiedBy", "Atlan user who last updated the asset.", IndexType.KEYWORD), new FieldDetails("STATE", "__state", "Asset status in Atlan (active vs deleted).", IndexType.KEYWORD), new FieldDetails("TRAIT_NAMES", "__traitNames", "All directly-assigned Atlan tags that exist on an asset, searchable by the internal hashed-string ID of the Atlan tag.", IndexType.KEYWORD), new FieldDetails("PROPAGATED_TRAIT_NAMES", "__propagatedTraitNames", "All propagated Atlan tags that exist on an asset, searchable by the internal hashed-string ID of the Atlan tag.", IndexType.KEYWORD), new FieldDetails("ASSIGNED_TERMS", "__meanings", "All terms attached to an asset, searchable by the term's qualifiedName.", IndexType.KEYWORD), new FieldDetails("TYPE_NAME", "__typeName.keyword", "Type of the asset. For example Table, Column, and so on.", IndexType.KEYWORD), new FieldDetails("SUPER_TYPE_NAMES", "__superTypeNames.keyword", "All super types of an asset.", IndexType.KEYWORD), new FieldDetails("QUALIFIED_NAME", "qualifiedName", "Unique fully-qualified name of the asset in Atlan.", IndexType.KEYWORD), new FieldDetails("GLOSSARY", "__glossary", "Glossary in which the asset is contained, searchable by the qualifiedName of the glossary.", IndexType.KEYWORD), new FieldDetails("CATEGORIES", "__categories", "Categories in which the term is organized, searchable by the qualifiedName of the category.", IndexType.KEYWORD), new FieldDetails("PARENT_CATEGORY", "__parentCategory", "Parent category in which a subcategory is contained, searchable by the qualifiedName of the category.", IndexType.KEYWORD));
    private static final List<FieldDetails> COMMON_TEXT = List.of(new FieldDetails("ATLAN_TAGS_TEXT", "__classificationsText", "All Atlan tags that exist on an asset, whether directly assigned or propagated, searchable by the internal hashed-string ID of the Atlan tag.", IndexType.TEXT), new FieldDetails("MEANINGS_TEXT", "__meaningsText", "All terms attached to an asset, as a single comma-separated string.", IndexType.TEXT), new FieldDetails("TYPE_NAME", "__typeName", "Type of the asset. For example Table, Column, and so on.", IndexType.TEXT), new FieldDetails("SUPER_TYPE_NAMES", "__superTypeNames", "All super types of an asset.", IndexType.TEXT), new FieldDetails("QUALIFIED_NAME", "qualifiedName.text", "Unique fully-qualified name of the asset in Atlan.", IndexType.TEXT));
    private static final List<FieldDetails> COMMON_NUMERICS = List.of(new FieldDetails("TIMESTAMP", "__timestamp", "Time (in milliseconds) when the asset was created.", IndexType.NUMERIC), new FieldDetails("MODIFICATION_TIMESTAMP", "__modificationTimestamp", "Time (in milliseconds) when the asset was last updated.", IndexType.NUMERIC));

    public SearchFieldGenerator(Collection<EntityDef> entityDefs, IndexType toGenerate, GeneratorConfig cfg) {
        super(cfg);
        this.toGenerate = toGenerate;
        this.resolveClassName();
        this.resolveFields(entityDefs);
    }

    @Override
    protected void resolveClassName() {
        this.className = this.toGenerate.getClassName();
    }

    private void resolveFields(Collection<EntityDef> entityDefs) {
        this.fields = new TreeSet<Field>();
        switch (this.toGenerate) {
            case KEYWORD: {
                for (FieldDetails details : COMMON_KEYWORDS) {
                    this.fields.add(new Field(details, this.cfg));
                }
                break;
            }
            case TEXT: {
                for (FieldDetails details : COMMON_TEXT) {
                    this.fields.add(new Field(details, this.cfg));
                }
                break;
            }
            case NUMERIC: {
                for (FieldDetails details : COMMON_NUMERICS) {
                    this.fields.add(new Field(details, this.cfg));
                }
                break;
            }
        }
        for (EntityDef entityDef : entityDefs) {
            for (AttributeDef attributeDef : entityDef.getAttributeDefs()) {
                Field field = new Field(this.getClassName(), entityDef.getName(), attributeDef, this.toGenerate, this.cfg);
                if (field.getType().getName().equals("Internal") || field.getSearchFieldName() == null) continue;
                if (!this.fields.add(field)) {
                    log.info("Skipping duplicate field {}, from asset {}", (Object)field.getEnumName(), (Object)entityDef.getName());
                }
                this.cache.addSearchFieldToCache(entityDef.getName(), attributeDef.getName(), field);
            }
        }
    }

    @Generated
    public IndexType getToGenerate() {
        return this.toGenerate;
    }

    @Generated
    public SortedSet<Field> getFields() {
        return this.fields;
    }

    public static class Field
    extends AssetGenerator.Attribute<Field>
    implements Comparable<Field> {
        private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
        private static final Comparator<Field> comparator = Comparator.comparing(Field::getEnumName, stringComparator).thenComparing(Field::getToFilter);
        private String searchFieldName;
        private String enumName;
        private final IndexType toFilter;

        private Field(FieldDetails details, GeneratorConfig cfg) {
            super(cfg);
            this.enumName = details.getEnumName();
            this.searchFieldName = details.getSearchFieldName();
            this.description = details.getDescription();
            this.toFilter = details.getToFilter();
        }

        public Field(String className, String entityName, AttributeDef attributeDef, IndexType toFilter, GeneratorConfig cfg) {
            super(className, attributeDef, cfg);
            this.toFilter = toFilter;
            this.resolveSearchDetails(attributeDef);
            this.description = this.cache.getAttributeDescription(entityName, this.getOriginalName());
        }

        private void resolveSearchDetails(AttributeDef attributeDef) {
            this.searchFieldName = this.getSearchFieldForAttribute(attributeDef);
            if (this.searchFieldName != null) {
                this.enumName = Field.getEnumFromAttrName(this.getRenamed());
            }
        }

        private String getSearchFieldForAttribute(AttributeDef attributeDef) {
            LinkedHashSet<Object> searchable = new LinkedHashSet<Object>();
            Map<String, String> config = attributeDef.getIndexTypeESConfig();
            String attrName = attributeDef.getName();
            if (config != null && config.containsKey("analyzer")) {
                String analyzer = config.get("analyzer");
                if (analyzer.equals("atlan_text_analyzer")) {
                    if (this.toFilter == IndexType.STEMMED && attrName.endsWith(".stemmed")) {
                        searchable.add(attrName);
                    } else if (this.toFilter == IndexType.TEXT && !attrName.endsWith(".stemmed")) {
                        searchable.add(attrName);
                    }
                } else {
                    log.warn("Unknown analyzer on attribute {}: {}", (Object)attrName, (Object)analyzer);
                }
            } else {
                IndexType defIndex = Field.getDefaultIndexForType(this.getType());
                if (defIndex == this.toFilter || this.toFilter == IndexType.NUMERIC && (defIndex == IndexType.DATE || defIndex == IndexType.FLOAT)) {
                    searchable.add(attrName);
                }
            }
            boolean duplicate = false;
            Map<String, Map<String, String>> fields = attributeDef.getIndexTypeESFields();
            if (fields != null) {
                block10: for (Map.Entry<String, Map<String, String>> entry : fields.entrySet()) {
                    String fieldName = attrName + "." + entry.getKey();
                    Map<String, String> indexDetails = entry.getValue();
                    if (indexDetails != null && indexDetails.containsKey("type")) {
                        String indexType;
                        switch (indexType = indexDetails.get("type")) {
                            case "keyword": {
                                if (this.toFilter != IndexType.KEYWORD) continue block10;
                                duplicate = searchable.add(fieldName);
                                break;
                            }
                            case "text": {
                                if (this.toFilter == IndexType.STEMMED && fieldName.endsWith(".stemmed")) {
                                    duplicate = searchable.add(fieldName);
                                    break;
                                }
                                if (this.toFilter != IndexType.TEXT || fieldName.endsWith(".stemmed")) continue block10;
                                duplicate = searchable.add(fieldName);
                                break;
                            }
                            case "rank_feature": {
                                if (this.toFilter != IndexType.RANK_FEATURE) continue block10;
                                duplicate = searchable.add(fieldName);
                                break;
                            }
                            default: {
                                log.warn("Unknown index type on attribute {}, field {}: {}", new Object[]{attributeDef.getName(), fieldName, indexType});
                                break;
                            }
                        }
                        continue;
                    }
                    IndexType defIndex = Field.getDefaultIndexForType(this.getType());
                    if (defIndex != this.toFilter && (this.toFilter != IndexType.NUMERIC || defIndex != IndexType.DATE && defIndex != IndexType.FLOAT)) continue;
                    duplicate = searchable.add(fieldName);
                }
            }
            if (duplicate) {
                log.info("Same attribute had multiple (identical) index references: {}", (Object)attrName);
            }
            if (searchable.size() > 1) {
                log.warn("Multiple searchable fields of the same index type for attribute {}: {}", (Object)attrName, searchable);
            }
            if (!searchable.isEmpty()) {
                return (String)searchable.iterator().next();
            }
            return null;
        }

        public String getEnumClassName() {
            return this.toFilter.getClassName();
        }

        @Override
        public int compareTo(Field o) {
            return comparator.compare(this, o);
        }

        private static IndexType getDefaultIndexForType(TypeGenerator.MappedType type) {
            IndexType toUse;
            String baseType;
            switch (baseType = type.getOriginalBase()) {
                case "date": {
                    toUse = IndexType.DATE;
                    break;
                }
                case "float": 
                case "double": 
                case "int": 
                case "long": {
                    toUse = IndexType.FLOAT;
                    break;
                }
                case "boolean": {
                    toUse = IndexType.BOOLEAN;
                    break;
                }
                default: {
                    toUse = IndexType.KEYWORD;
                }
            }
            return toUse;
        }

        static String getEnumFromAttrName(String attrName) {
            return attrName.replaceAll("_", "").replaceAll("([A-Z]+)([A-Z][a-z])", "$1_$2").replaceAll("([a-z])([A-Z])", "$1_$2").toUpperCase(Locale.ROOT);
        }

        @Generated
        public String getSearchFieldName() {
            return this.searchFieldName;
        }

        @Generated
        public String getEnumName() {
            return this.enumName;
        }

        @Generated
        public IndexType getToFilter() {
            return this.toFilter;
        }
    }

    private static class FieldDetails {
        private final String enumName;
        private final String searchFieldName;
        private final String description;
        private final IndexType toFilter;

        private FieldDetails(String enumName, String searchFieldName, String description, IndexType toFilter) {
            this.enumName = enumName;
            this.searchFieldName = searchFieldName;
            this.description = description;
            this.toFilter = toFilter;
        }

        @Generated
        public String getEnumName() {
            return this.enumName;
        }

        @Generated
        public String getSearchFieldName() {
            return this.searchFieldName;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public IndexType getToFilter() {
            return this.toFilter;
        }
    }

    static enum IndexType {
        KEYWORD("KeywordFields"),
        TEXT("TextFields"),
        RANK_FEATURE("RankFields"),
        BOOLEAN("BooleanFields"),
        NUMERIC("NumericFields"),
        DATE("NumericFields"),
        FLOAT("NumericFields"),
        STEMMED("StemmedFields");

        private final String className;

        private IndexType(String className) {
            this.className = className;
        }

        @Generated
        public String getClassName() {
            return this.className;
        }
    }
}

