/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.generators.AttributeGenerator;
import com.atlan.generators.GeneratorConfig;
import com.atlan.generators.TypeGenerator;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.StructDef;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructGenerator
extends TypeGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StructGenerator.class);
    public static final String DIRECTORY = "structs";
    private final StructDef structDef;
    private List<Attribute> attributes;

    public StructGenerator(StructDef structDef, GeneratorConfig cfg) {
        super(structDef, cfg);
        this.structDef = structDef;
        this.resolveClassName();
        this.description = this.cache.getTypeDescription(this.originalName);
        this.resolveAttributes();
    }

    @Override
    protected void resolveClassName() {
        this.className = this.cfg.resolveClassName(this.getOriginalName());
    }

    private void resolveAttributes() {
        this.attributes = new ArrayList<Attribute>();
        for (AttributeDef attributeDef : this.structDef.getAttributeDefs()) {
            Attribute attribute = new Attribute(this.className, attributeDef, this.cfg);
            if (this.className.equals("BadgeCondition") && attribute.getRenamed().equals("badgeConditionOperator")) {
                attribute.setType(TypeGenerator.MappedType.builder().type(TypeGenerator.MappedType.Type.ENUM).name("BadgeComparisonOperator").build());
            }
            this.attributes.add(attribute);
        }
    }

    @Generated
    public StructDef getStructDef() {
        return this.structDef;
    }

    @Generated
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public static final class Attribute
    extends AttributeGenerator {
        public Attribute(String className, AttributeDef attributeDef, GeneratorConfig cfg) {
            super(className, attributeDef, cfg);
        }

        @Override
        protected void resolveType(AttributeDef attributeDef) {
            super.resolveType(attributeDef);
            if (attributeDef.getTypeName().startsWith("array<")) {
                this.setType(this.getType().toBuilder().container("List<").build());
            }
        }
    }
}

