/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.generators.GeneratorConfig;
import com.atlan.generators.ModelCache;
import com.atlan.model.typedefs.TypeDef;
import java.util.Map;
import lombok.Generated;

public abstract class TypeGenerator {
    protected static final Map<String, String> PRIMITIVE_MAPPINGS = Map.ofEntries(Map.entry("string", "String"), Map.entry("boolean", "Boolean"), Map.entry("int", "Integer"), Map.entry("long", "Long"), Map.entry("date", "Long"), Map.entry("float", "Double"), Map.entry("string,string", "String, String"), Map.entry("string,long", "String, Long"));
    protected String generatorName;
    protected String packageRoot;
    protected String originalName;
    protected String className;
    protected String description;
    protected GeneratorConfig cfg;
    protected ModelCache cache;

    protected TypeGenerator(GeneratorConfig cfg) {
        this.cfg = cfg;
        this.cache = ModelCache.getInstance(cfg);
        this.packageRoot = cfg.getPackageRoot();
        this.generatorName = cfg.getGeneratorName();
    }

    protected TypeGenerator(TypeDef typeDef, GeneratorConfig cfg) {
        this.originalName = typeDef.getDisplayName() == null ? typeDef.getName() : typeDef.getDisplayName();
        this.cfg = cfg;
        this.cache = ModelCache.getInstance(cfg);
        this.packageRoot = cfg.getPackageRoot();
        this.generatorName = cfg.getGeneratorName();
    }

    protected abstract void resolveClassName();

    protected MappedType getMappedType(String type) {
        String baseType = type;
        String container = null;
        if (type.contains("<")) {
            if (type.startsWith("array<")) {
                if (type.startsWith("array<map<")) {
                    baseType = TypeGenerator.getEmbeddedType(type.substring("array<".length(), type.length() - 1));
                    container = "List<Map<";
                } else {
                    baseType = TypeGenerator.getEmbeddedType(type);
                    container = "SortedSet<";
                }
            } else if (type.startsWith("map<")) {
                baseType = TypeGenerator.getEmbeddedType(type);
                container = "Map<";
            }
        }
        MappedType.MappedTypeBuilder builder = MappedType.builder().originalBase(baseType);
        String primitiveName = PRIMITIVE_MAPPINGS.getOrDefault(baseType, null);
        if (primitiveName != null) {
            builder.type(MappedType.Type.PRIMITIVE).name(primitiveName);
        } else {
            MappedType mappedType = this.cache.getCachedType(baseType);
            if (mappedType == null) {
                builder.type(MappedType.Type.ASSET).name(baseType);
            } else {
                MappedType.Type baseTypeOfMapped = mappedType.getType();
                builder.type(baseTypeOfMapped).name(mappedType.getName());
                if (baseTypeOfMapped == MappedType.Type.STRUCT) {
                    container = "List<";
                }
            }
        }
        if (container != null) {
            builder.container(container);
        }
        return builder.build();
    }

    private static String getEmbeddedType(String attrType) {
        return attrType.substring(attrType.indexOf("<") + 1, attrType.indexOf(">"));
    }

    @Generated
    public String getGeneratorName() {
        return this.generatorName;
    }

    @Generated
    public String getPackageRoot() {
        return this.packageRoot;
    }

    @Generated
    public String getOriginalName() {
        return this.originalName;
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public GeneratorConfig getCfg() {
        return this.cfg;
    }

    @Generated
    public ModelCache getCache() {
        return this.cache;
    }

    public static final class MappedType {
        private String originalBase;
        private String name;
        private String container;
        private Type type;

        @Generated
        MappedType(String originalBase, String name, String container, Type type) {
            this.originalBase = originalBase;
            this.name = name;
            this.container = container;
            this.type = type;
        }

        @Generated
        public static MappedTypeBuilder builder() {
            return new MappedTypeBuilder();
        }

        @Generated
        public MappedTypeBuilder toBuilder() {
            return new MappedTypeBuilder().originalBase(this.originalBase).name(this.name).container(this.container).type(this.type);
        }

        @Generated
        public String getOriginalBase() {
            return this.originalBase;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getContainer() {
            return this.container;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public static class MappedTypeBuilder {
            @Generated
            private String originalBase;
            @Generated
            private String name;
            @Generated
            private String container;
            @Generated
            private Type type;

            @Generated
            MappedTypeBuilder() {
            }

            @Generated
            public MappedTypeBuilder originalBase(String originalBase) {
                this.originalBase = originalBase;
                return this;
            }

            @Generated
            public MappedTypeBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public MappedTypeBuilder container(String container) {
                this.container = container;
                return this;
            }

            @Generated
            public MappedTypeBuilder type(Type type) {
                this.type = type;
                return this;
            }

            @Generated
            public MappedType build() {
                return new MappedType(this.originalBase, this.name, this.container, this.type);
            }

            @Generated
            public String toString() {
                return "TypeGenerator.MappedType.MappedTypeBuilder(originalBase=" + this.originalBase + ", name=" + this.name + ", container=" + this.container + ", type=" + this.type + ")";
            }
        }

        public static enum Type {
            PRIMITIVE,
            ENUM,
            STRUCT,
            ASSET;

        }
    }
}

