/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.admin;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.atlan.serde.StringToSetDeserializer;
import com.atlan.util.JacksonUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

@JsonDeserialize(builder=ApiTokenBuilderImpl.class)
public class ApiToken
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    String id;
    String clientId;
    String displayName;
    ApiTokenAttributes attributes;

    public String getClientId() {
        if (this.clientId != null) {
            return this.clientId;
        }
        if (this.attributes != null) {
            return this.attributes.getClientId();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        if (this.attributes != null) {
            return this.attributes.getDisplayName();
        }
        return null;
    }

    public static ApiToken create(String displayName) throws AtlanException {
        return ApiToken.create(Atlan.getDefaultClient(), displayName);
    }

    public static ApiToken create(AtlanClient client, String displayName) throws AtlanException {
        return ApiToken.create(client, displayName, null, null, -1L);
    }

    public static ApiToken create(String displayName, String description, Set<String> personas, Long validity) throws AtlanException {
        return ApiToken.create(Atlan.getDefaultClient(), displayName, description, personas, validity);
    }

    public static ApiToken create(AtlanClient client, String displayName, String description, Set<String> personas, Long validity) throws AtlanException {
        return client.apiTokens.create(displayName, description, personas, validity);
    }

    public static ApiToken retrieveByName(String displayName) throws AtlanException {
        return ApiToken.retrieveByName(Atlan.getDefaultClient(), displayName);
    }

    public static ApiToken retrieveByName(AtlanClient client, String displayName) throws AtlanException {
        return client.apiTokens.get(displayName);
    }

    public ApiToken update() throws AtlanException {
        return this.update(Atlan.getDefaultClient());
    }

    public ApiToken update(AtlanClient client) throws AtlanException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_TOKEN_ID);
        }
        if (this.displayName == null || this.displayName.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_TOKEN_NAME);
        }
        String description = null;
        HashSet<String> personas = null;
        if (this.attributes != null) {
            description = this.attributes.getDescription();
            if (this.attributes.getPersonas() != null) {
                personas = new HashSet<String>();
                for (ApiTokenPersona persona : this.attributes.getPersonas()) {
                    personas.add(persona.getPersonaQualifiedName());
                }
            }
        }
        return client.apiTokens.update(this.id, this.displayName, description, personas);
    }

    public static void delete(String guid) throws AtlanException {
        ApiToken.delete(Atlan.getDefaultClient(), guid);
    }

    public static void delete(AtlanClient client, String guid) throws AtlanException {
        client.apiTokens.purge(guid);
    }

    @Generated
    protected ApiToken(ApiTokenBuilder<?, ?> b) {
        super(b);
        this.id = b.id;
        this.clientId = b.clientId;
        this.displayName = b.displayName;
        this.attributes = b.attributes;
    }

    @Generated
    public static ApiTokenBuilder<?, ?> builder() {
        return new ApiTokenBuilderImpl();
    }

    @Generated
    public ApiTokenBuilder<?, ?> toBuilder() {
        return new ApiTokenBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiToken)) {
            return false;
        }
        ApiToken other = (ApiToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        ApiTokenAttributes this$attributes = this.getAttributes();
        ApiTokenAttributes other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiToken;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        ApiTokenAttributes $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ApiToken(super=" + super.toString() + ", id=" + this.getId() + ", clientId=" + this.getClientId() + ", displayName=" + this.getDisplayName() + ", attributes=" + this.getAttributes() + ")";
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public ApiTokenAttributes getAttributes() {
        return this.attributes;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class ApiTokenBuilderImpl
    extends ApiTokenBuilder<ApiToken, ApiTokenBuilderImpl> {
        @Generated
        private ApiTokenBuilderImpl() {
        }

        @Override
        @Generated
        protected ApiTokenBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ApiToken build() {
            return new ApiToken(this);
        }
    }

    @Generated
    public static abstract class ApiTokenBuilder<C extends ApiToken, B extends ApiTokenBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private String id;
        @Generated
        private String clientId;
        @Generated
        private String displayName;
        @Generated
        private ApiTokenAttributes attributes;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ApiTokenBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ApiToken instance, ApiTokenBuilder<?, ?> b) {
            b.id(instance.id);
            b.clientId(instance.clientId);
            b.displayName(instance.displayName);
            b.attributes(instance.attributes);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B id(String id) {
            this.id = id;
            return (B)this.self();
        }

        @Generated
        public B clientId(String clientId) {
            this.clientId = clientId;
            return (B)this.self();
        }

        @Generated
        public B displayName(String displayName) {
            this.displayName = displayName;
            return (B)this.self();
        }

        @Generated
        public B attributes(ApiTokenAttributes attributes) {
            this.attributes = attributes;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ApiToken.ApiTokenBuilder(super=" + super.toString() + ", id=" + this.id + ", clientId=" + this.clientId + ", displayName=" + this.displayName + ", attributes=" + this.attributes + ")";
        }
    }

    static class ApiTokenAttributesDeserializer
    extends StdDeserializer<ApiTokenAttributes> {
        private static final long serialVersionUID = 2L;
        private final AtlanClient client;

        public ApiTokenAttributesDeserializer(AtlanClient client) {
            super(ApiToken.class);
            this.client = client;
        }

        public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
            return this.deserialize(parser, context);
        }

        public ApiTokenAttributes deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            JsonNode root = (JsonNode)parser.getCodec().readTree(parser);
            Set<Object> personas = new TreeSet();
            JsonNode personasJson = root.get("personas");
            if (personasJson.isTextual()) {
                personas = Collections.emptySet();
            } else if (personasJson.isArray()) {
                personas = JacksonUtils.deserializeObject(this.client, root, "personas", new TypeReference<Set<ApiTokenPersona>>(){});
            }
            Set<Object> workspacePermissions = new TreeSet();
            JsonNode workspacePermissionsJson = root.get("workspacePermissions");
            if (workspacePermissionsJson.isTextual()) {
                workspacePermissions = StringToSetDeserializer.deserialize(this.client, workspacePermissionsJson.asText());
            } else if (workspacePermissionsJson.isArray()) {
                workspacePermissions = JacksonUtils.deserializeObject(this.client, root, "workspacePermissions", new TypeReference<Set<String>>(){});
            }
            return ApiTokenAttributes.builder().accessTokenLifespan(JacksonUtils.deserializeLong(root, "access.token.lifespan")).accessToken(JacksonUtils.deserializeString(root, "accessToken")).clientId(JacksonUtils.deserializeString(root, "clientId")).createdAt(JacksonUtils.deserializeLong(root, "createdAt")).createdBy(JacksonUtils.deserializeString(root, "createdBy")).description(JacksonUtils.deserializeString(root, "description")).displayName(JacksonUtils.deserializeString(root, "displayName")).personas(personas).purposes(JacksonUtils.deserializeString(root, "purposes")).workspacePermissions(workspacePermissions).build();
        }
    }

    static class ApiTokenAttributesSerializer
    extends StdSerializer<ApiTokenAttributes> {
        private static final long serialVersionUID = 2L;

        public ApiTokenAttributesSerializer() {
            this(null);
        }

        public ApiTokenAttributesSerializer(Class<ApiTokenAttributes> t) {
            super(t);
        }

        public void serializeWithType(ApiTokenAttributes value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            this.serialize(value, gen, serializers);
        }

        public void serialize(ApiTokenAttributes ata, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
            gen.writeStartObject();
            JacksonUtils.serializeString(gen, "access.token.lifespan", "" + ata.getAccessTokenLifespan());
            JacksonUtils.serializeString(gen, "accessToken", ata.getAccessToken());
            JacksonUtils.serializeString(gen, "clientId", ata.getClientId());
            JacksonUtils.serializeString(gen, "createdAt", "" + ata.getCreatedAt());
            JacksonUtils.serializeString(gen, "createdBy", ata.getCreatedBy());
            JacksonUtils.serializeString(gen, "description", ata.getDescription());
            JacksonUtils.serializeString(gen, "displayName", ata.getDisplayName());
            JacksonUtils.serializeObject(gen, "personas", ata.getPersonas());
            JacksonUtils.serializeString(gen, "purposes", ata.getPurposes());
            JacksonUtils.serializeObject(gen, "workspacePermissions", ata.getWorkspacePermissions());
            gen.writeEndObject();
        }
    }

    @JsonDeserialize(builder=ApiTokenPersonaBuilder.class)
    public static final class ApiTokenPersona
    extends AtlanObject
    implements Comparable<ApiTokenPersona> {
        private static final long serialVersionUID = 2L;
        private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
        private static final Comparator<ApiTokenPersona> personaComparator = Comparator.comparing(ApiTokenPersona::getId, stringComparator).thenComparing(ApiTokenPersona::getPersona, stringComparator).thenComparing(ApiTokenPersona::getPersonaQualifiedName, stringComparator);
        String id;
        String persona;
        String personaQualifiedName;

        public static ApiTokenPersona of(String id, String persona, String personaQualifiedName) {
            return ApiTokenPersona.builder().id(id).persona(persona).personaQualifiedName(personaQualifiedName).build();
        }

        @Override
        public int compareTo(ApiTokenPersona o) {
            return personaComparator.compare(this, o);
        }

        @Generated
        ApiTokenPersona(String id, String persona, String personaQualifiedName) {
            this.id = id;
            this.persona = persona;
            this.personaQualifiedName = personaQualifiedName;
        }

        @Generated
        public static ApiTokenPersonaBuilder builder() {
            return new ApiTokenPersonaBuilder();
        }

        @Generated
        public ApiTokenPersonaBuilder toBuilder() {
            return new ApiTokenPersonaBuilder().id(this.id).persona(this.persona).personaQualifiedName(this.personaQualifiedName);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getPersona() {
            return this.persona;
        }

        @Generated
        public String getPersonaQualifiedName() {
            return this.personaQualifiedName;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiTokenPersona)) {
                return false;
            }
            ApiTokenPersona other = (ApiTokenPersona)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$persona = this.getPersona();
            String other$persona = other.getPersona();
            if (this$persona == null ? other$persona != null : !this$persona.equals(other$persona)) {
                return false;
            }
            String this$personaQualifiedName = this.getPersonaQualifiedName();
            String other$personaQualifiedName = other.getPersonaQualifiedName();
            return !(this$personaQualifiedName == null ? other$personaQualifiedName != null : !this$personaQualifiedName.equals(other$personaQualifiedName));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApiTokenPersona;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $persona = this.getPersona();
            result = result * 59 + ($persona == null ? 43 : $persona.hashCode());
            String $personaQualifiedName = this.getPersonaQualifiedName();
            result = result * 59 + ($personaQualifiedName == null ? 43 : $personaQualifiedName.hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "ApiToken.ApiTokenPersona(super=" + super.toString() + ", id=" + this.getId() + ", persona=" + this.getPersona() + ", personaQualifiedName=" + this.getPersonaQualifiedName() + ")";
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class ApiTokenPersonaBuilder {
            @Generated
            private String id;
            @Generated
            private String persona;
            @Generated
            private String personaQualifiedName;

            @Generated
            ApiTokenPersonaBuilder() {
            }

            @Generated
            public ApiTokenPersonaBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public ApiTokenPersonaBuilder persona(String persona) {
                this.persona = persona;
                return this;
            }

            @Generated
            public ApiTokenPersonaBuilder personaQualifiedName(String personaQualifiedName) {
                this.personaQualifiedName = personaQualifiedName;
                return this;
            }

            @Generated
            public ApiTokenPersona build() {
                return new ApiTokenPersona(this.id, this.persona, this.personaQualifiedName);
            }

            @Generated
            public String toString() {
                return "ApiToken.ApiTokenPersona.ApiTokenPersonaBuilder(id=" + this.id + ", persona=" + this.persona + ", personaQualifiedName=" + this.personaQualifiedName + ")";
            }
        }
    }

    @JsonSerialize(using=ApiTokenAttributesSerializer.class)
    @JsonDeserialize(using=ApiTokenAttributesDeserializer.class)
    public static final class ApiTokenAttributes
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        @JsonProperty(value="access.token.lifespan")
        Long accessTokenLifespan;
        final String accessToken;
        String clientId;
        Long createdAt;
        String createdBy;
        String description;
        String displayName;
        SortedSet<ApiTokenPersona> personas;
        @JsonIgnore
        String purposes;
        SortedSet<String> workspacePermissions;

        @Generated
        ApiTokenAttributes(Long accessTokenLifespan, String accessToken, String clientId, Long createdAt, String createdBy, String description, String displayName, SortedSet<ApiTokenPersona> personas, String purposes, SortedSet<String> workspacePermissions) {
            this.accessTokenLifespan = accessTokenLifespan;
            this.accessToken = accessToken;
            this.clientId = clientId;
            this.createdAt = createdAt;
            this.createdBy = createdBy;
            this.description = description;
            this.displayName = displayName;
            this.personas = personas;
            this.purposes = purposes;
            this.workspacePermissions = workspacePermissions;
        }

        @Generated
        public static ApiTokenAttributesBuilder builder() {
            return new ApiTokenAttributesBuilder();
        }

        @Generated
        public ApiTokenAttributesBuilder toBuilder() {
            ApiTokenAttributesBuilder builder = new ApiTokenAttributesBuilder().accessTokenLifespan(this.accessTokenLifespan).accessToken(this.accessToken).clientId(this.clientId).createdAt(this.createdAt).createdBy(this.createdBy).description(this.description).displayName(this.displayName).purposes(this.purposes);
            if (this.personas != null) {
                builder.personas(this.personas);
            }
            if (this.workspacePermissions != null) {
                builder.workspacePermissions(this.workspacePermissions);
            }
            return builder;
        }

        @Generated
        public Long getAccessTokenLifespan() {
            return this.accessTokenLifespan;
        }

        @Generated
        public String getAccessToken() {
            return this.accessToken;
        }

        @Generated
        public String getClientId() {
            return this.clientId;
        }

        @Generated
        public Long getCreatedAt() {
            return this.createdAt;
        }

        @Generated
        public String getCreatedBy() {
            return this.createdBy;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public SortedSet<ApiTokenPersona> getPersonas() {
            return this.personas;
        }

        @Generated
        public String getPurposes() {
            return this.purposes;
        }

        @Generated
        public SortedSet<String> getWorkspacePermissions() {
            return this.workspacePermissions;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiTokenAttributes)) {
                return false;
            }
            ApiTokenAttributes other = (ApiTokenAttributes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Long this$accessTokenLifespan = this.getAccessTokenLifespan();
            Long other$accessTokenLifespan = other.getAccessTokenLifespan();
            if (this$accessTokenLifespan == null ? other$accessTokenLifespan != null : !((Object)this$accessTokenLifespan).equals(other$accessTokenLifespan)) {
                return false;
            }
            Long this$createdAt = this.getCreatedAt();
            Long other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
                return false;
            }
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                return false;
            }
            String this$createdBy = this.getCreatedBy();
            String other$createdBy = other.getCreatedBy();
            if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            SortedSet<ApiTokenPersona> this$personas = this.getPersonas();
            SortedSet<ApiTokenPersona> other$personas = other.getPersonas();
            if (this$personas == null ? other$personas != null : !this$personas.equals(other$personas)) {
                return false;
            }
            String this$purposes = this.getPurposes();
            String other$purposes = other.getPurposes();
            if (this$purposes == null ? other$purposes != null : !this$purposes.equals(other$purposes)) {
                return false;
            }
            SortedSet<String> this$workspacePermissions = this.getWorkspacePermissions();
            SortedSet<String> other$workspacePermissions = other.getWorkspacePermissions();
            return !(this$workspacePermissions == null ? other$workspacePermissions != null : !this$workspacePermissions.equals(other$workspacePermissions));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApiTokenAttributes;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Long $accessTokenLifespan = this.getAccessTokenLifespan();
            result = result * 59 + ($accessTokenLifespan == null ? 43 : ((Object)$accessTokenLifespan).hashCode());
            Long $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            String $createdBy = this.getCreatedBy();
            result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            SortedSet<ApiTokenPersona> $personas = this.getPersonas();
            result = result * 59 + ($personas == null ? 43 : $personas.hashCode());
            String $purposes = this.getPurposes();
            result = result * 59 + ($purposes == null ? 43 : $purposes.hashCode());
            SortedSet<String> $workspacePermissions = this.getWorkspacePermissions();
            result = result * 59 + ($workspacePermissions == null ? 43 : $workspacePermissions.hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "ApiToken.ApiTokenAttributes(super=" + super.toString() + ", accessTokenLifespan=" + this.getAccessTokenLifespan() + ", accessToken=" + this.getAccessToken() + ", clientId=" + this.getClientId() + ", createdAt=" + this.getCreatedAt() + ", createdBy=" + this.getCreatedBy() + ", description=" + this.getDescription() + ", displayName=" + this.getDisplayName() + ", personas=" + this.getPersonas() + ", purposes=" + this.getPurposes() + ", workspacePermissions=" + this.getWorkspacePermissions() + ")";
        }

        @Generated
        public static class ApiTokenAttributesBuilder {
            @Generated
            private Long accessTokenLifespan;
            @Generated
            private String accessToken;
            @Generated
            private String clientId;
            @Generated
            private Long createdAt;
            @Generated
            private String createdBy;
            @Generated
            private String description;
            @Generated
            private String displayName;
            @Generated
            private ArrayList<ApiTokenPersona> personas;
            @Generated
            private String purposes;
            @Generated
            private ArrayList<String> workspacePermissions;

            @Generated
            ApiTokenAttributesBuilder() {
            }

            @JsonProperty(value="access.token.lifespan")
            @Generated
            public ApiTokenAttributesBuilder accessTokenLifespan(Long accessTokenLifespan) {
                this.accessTokenLifespan = accessTokenLifespan;
                return this;
            }

            @Generated
            public ApiTokenAttributesBuilder accessToken(String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            @Generated
            public ApiTokenAttributesBuilder clientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            @Generated
            public ApiTokenAttributesBuilder createdAt(Long createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @Generated
            public ApiTokenAttributesBuilder createdBy(String createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            @Generated
            public ApiTokenAttributesBuilder description(String description) {
                this.description = description;
                return this;
            }

            @Generated
            public ApiTokenAttributesBuilder displayName(String displayName) {
                this.displayName = displayName;
                return this;
            }

            @Generated
            public ApiTokenAttributesBuilder persona(ApiTokenPersona persona) {
                if (this.personas == null) {
                    this.personas = new ArrayList();
                }
                this.personas.add(persona);
                return this;
            }

            @Generated
            public ApiTokenAttributesBuilder personas(Collection<? extends ApiTokenPersona> personas) {
                if (personas == null) {
                    throw new NullPointerException("personas cannot be null");
                }
                if (this.personas == null) {
                    this.personas = new ArrayList();
                }
                this.personas.addAll(personas);
                return this;
            }

            @Generated
            public ApiTokenAttributesBuilder clearPersonas() {
                if (this.personas != null) {
                    this.personas.clear();
                }
                return this;
            }

            @JsonIgnore
            @Generated
            public ApiTokenAttributesBuilder purposes(String purposes) {
                this.purposes = purposes;
                return this;
            }

            @Generated
            public ApiTokenAttributesBuilder workspacePermission(String workspacePermission) {
                if (this.workspacePermissions == null) {
                    this.workspacePermissions = new ArrayList();
                }
                this.workspacePermissions.add(workspacePermission);
                return this;
            }

            @Generated
            public ApiTokenAttributesBuilder workspacePermissions(Collection<? extends String> workspacePermissions) {
                if (workspacePermissions == null) {
                    throw new NullPointerException("workspacePermissions cannot be null");
                }
                if (this.workspacePermissions == null) {
                    this.workspacePermissions = new ArrayList();
                }
                this.workspacePermissions.addAll(workspacePermissions);
                return this;
            }

            @Generated
            public ApiTokenAttributesBuilder clearWorkspacePermissions() {
                if (this.workspacePermissions != null) {
                    this.workspacePermissions.clear();
                }
                return this;
            }

            @Generated
            public ApiTokenAttributes build() {
                TreeSet<ApiTokenPersona> personas = new TreeSet<ApiTokenPersona>();
                if (this.personas != null) {
                    personas.addAll(this.personas);
                }
                personas = Collections.unmodifiableSortedSet(personas);
                TreeSet<String> workspacePermissions = new TreeSet<String>();
                if (this.workspacePermissions != null) {
                    workspacePermissions.addAll(this.workspacePermissions);
                }
                workspacePermissions = Collections.unmodifiableSortedSet(workspacePermissions);
                return new ApiTokenAttributes(this.accessTokenLifespan, this.accessToken, this.clientId, this.createdAt, this.createdBy, this.description, this.displayName, personas, this.purposes, workspacePermissions);
            }

            @Generated
            public String toString() {
                return "ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder(accessTokenLifespan=" + this.accessTokenLifespan + ", accessToken=" + this.accessToken + ", clientId=" + this.clientId + ", createdAt=" + this.createdAt + ", createdBy=" + this.createdBy + ", description=" + this.description + ", displayName=" + this.displayName + ", personas=" + this.personas + ", purposes=" + this.purposes + ", workspacePermissions=" + this.workspacePermissions + ")";
            }
        }
    }
}

