/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.admin;

import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.AtlanRequest;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.GlossaryTerm;
import java.util.ArrayList;
import java.util.UUID;
import lombok.Generated;

public class TermLinkRequest
extends AtlanRequest {
    private static final long serialVersionUID = 2L;
    public static final String REQUEST_TYPE = "term_link";
    public static final String SOURCE_TYPE = "atlas";
    String requestType;
    String sourceType;

    public static TermLinkRequestBuilder<?, ?> creator(Asset asset, GlossaryTerm term) throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (asset.getQualifiedName() == null || asset.getQualifiedName().isEmpty()) {
            missing.add("qualifiedName");
        }
        if (asset.getGuid() == null || asset.getGuid().isEmpty()) {
            missing.add("guid");
        }
        if (term.getQualifiedName() == null || term.getQualifiedName().isEmpty()) {
            missing.add("term::qualifiedName");
        }
        if (term.getGuid() == null || term.getGuid().isEmpty()) {
            missing.add("term::guid");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, asset.getTypeName(), String.join((CharSequence)",", missing));
        }
        return TermLinkRequest.creator(asset.getGuid(), asset.getQualifiedName(), asset.getTypeName(), term.getGuid(), term.getQualifiedName());
    }

    public static TermLinkRequestBuilder<?, ?> creator(String assetGuid, String assetQualifiedName, String assetType, String termGuid, String termQualifiedName) {
        return (TermLinkRequestBuilder)((TermLinkRequestBuilder)((TermLinkRequestBuilder)((TermLinkRequestBuilder)((TermLinkRequestBuilder)((TermLinkRequestBuilder)TermLinkRequest.builder().id(UUID.randomUUID().toString())).destinationGuid(assetGuid)).destinationQualifiedName(assetQualifiedName)).entityType(assetType)).sourceGuid(termGuid)).sourceQualifiedName(termQualifiedName);
    }

    @Generated
    private static String $default$requestType() {
        return REQUEST_TYPE;
    }

    @Generated
    private static String $default$sourceType() {
        return SOURCE_TYPE;
    }

    @Generated
    protected TermLinkRequest(TermLinkRequestBuilder<?, ?> b) {
        super((AtlanRequest.AtlanRequestBuilder<?, ?>)b);
        this.requestType = b.requestType$set ? b.requestType$value : TermLinkRequest.$default$requestType();
        this.sourceType = b.sourceType$set ? b.sourceType$value : TermLinkRequest.$default$sourceType();
    }

    @Generated
    public static TermLinkRequestBuilder<?, ?> builder() {
        return new TermLinkRequestBuilderImpl();
    }

    @Generated
    public TermLinkRequestBuilder<?, ?> toBuilder() {
        return new TermLinkRequestBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TermLinkRequest)) {
            return false;
        }
        TermLinkRequest other = (TermLinkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$requestType = this.getRequestType();
        String other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !this$requestType.equals(other$requestType)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        return !(this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TermLinkRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $requestType = this.getRequestType();
        result = result * 59 + ($requestType == null ? 43 : $requestType.hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "TermLinkRequest(super=" + super.toString() + ", requestType=" + this.getRequestType() + ", sourceType=" + this.getSourceType() + ")";
    }

    @Override
    @Generated
    public String getRequestType() {
        return this.requestType;
    }

    @Override
    @Generated
    public String getSourceType() {
        return this.sourceType;
    }

    @Generated
    private static final class TermLinkRequestBuilderImpl
    extends TermLinkRequestBuilder<TermLinkRequest, TermLinkRequestBuilderImpl> {
        @Generated
        private TermLinkRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected TermLinkRequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TermLinkRequest build() {
            return new TermLinkRequest(this);
        }
    }

    @Generated
    public static abstract class TermLinkRequestBuilder<C extends TermLinkRequest, B extends TermLinkRequestBuilder<C, B>>
    extends AtlanRequest.AtlanRequestBuilder<C, B> {
        @Generated
        private boolean requestType$set;
        @Generated
        private String requestType$value;
        @Generated
        private boolean sourceType$set;
        @Generated
        private String sourceType$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TermLinkRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TermLinkRequest instance, TermLinkRequestBuilder<?, ?> b) {
            b.requestType(instance.requestType);
            b.sourceType(instance.sourceType);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B requestType(String requestType) {
            this.requestType$value = requestType;
            this.requestType$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public B sourceType(String sourceType) {
            this.sourceType$value = sourceType;
            this.sourceType$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TermLinkRequest.TermLinkRequestBuilder(super=" + super.toString() + ", requestType$value=" + this.requestType$value + ", sourceType$value=" + this.sourceType$value + ")";
        }
    }
}

