/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IADLS;
import com.atlan.model.assets.IADLSAccount;
import com.atlan.model.assets.IADLSContainer;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IAzure;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.ICloud;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IObjectStore;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.ADLSAccessTier;
import com.atlan.model.enums.ADLSAccountStatus;
import com.atlan.model.enums.ADLSEncryptionTypes;
import com.atlan.model.enums.ADLSPerformance;
import com.atlan.model.enums.ADLSProvisionState;
import com.atlan.model.enums.ADLSReplicationType;
import com.atlan.model.enums.ADLSStorageKind;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.AzureTag;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADLSAccount
extends Asset
implements IADLSAccount,
IADLS,
IObjectStore,
IAzure,
ICatalog,
IAsset,
IReferenceable,
ICloud {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ADLSAccount.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ADLSAccount";
    String typeName;
    @Attribute
    ADLSAccessTier adlsAccountAccessTier;
    @Attribute
    ADLSStorageKind adlsAccountKind;
    @Attribute
    ADLSPerformance adlsAccountPerformance;
    @Attribute
    ADLSProvisionState adlsAccountProvisionState;
    @Attribute
    String adlsAccountQualifiedName;
    @Attribute
    ADLSReplicationType adlsAccountReplication;
    @Attribute
    String adlsAccountResourceGroup;
    @Attribute
    String adlsAccountSecondaryLocation;
    @Attribute
    String adlsAccountSubscription;
    @Attribute
    SortedSet<IADLSContainer> adlsContainers;
    @Attribute
    String adlsETag;
    @Attribute
    ADLSEncryptionTypes adlsEncryptionType;
    @Attribute
    ADLSAccountStatus adlsPrimaryDiskState;
    @Attribute
    String azureLocation;
    @Attribute
    String azureResourceId;
    @Attribute
    List<AzureTag> azureTags;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;

    @Override
    public ADLSAccount trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ADLSAccount.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ADLSAccount.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ADLSAccount.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return ADLSAccount.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ADLSAccount.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return ADLSAccount.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return ADLSAccount.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return ADLSAccount.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return ADLSAccount.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static ADLSAccount refByGuid(String guid) {
        return ((ADLSAccountBuilder)ADLSAccount._internal().guid(guid)).build();
    }

    public static ADLSAccount refByQualifiedName(String qualifiedName) {
        return ((ADLSAccountBuilder)ADLSAccount._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static ADLSAccount get(String id) throws AtlanException {
        return ADLSAccount.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static ADLSAccount get(AtlanClient client, String id) throws AtlanException {
        return ADLSAccount.get(client, id, true);
    }

    @JsonIgnore
    public static ADLSAccount get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ADLSAccount) {
                return (ADLSAccount)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof ADLSAccount) {
            return (ADLSAccount)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static ADLSAccount retrieveByGuid(String guid) throws AtlanException {
        return ADLSAccount.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static ADLSAccount retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return ADLSAccount.get(client, guid);
    }

    @Deprecated
    public static ADLSAccount retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return ADLSAccount.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static ADLSAccount retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return ADLSAccount.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return ADLSAccount.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ADLSAccountBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return (ADLSAccountBuilder)((ADLSAccountBuilder)((ADLSAccountBuilder)((ADLSAccountBuilder)((ADLSAccountBuilder)ADLSAccount._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(ADLSAccount.generateQualifiedName(name, connectionQualifiedName))).name(name)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.ADLS);
    }

    public static String generateQualifiedName(String name, String connectionQualifiedName) {
        return connectionQualifiedName + "/" + name;
    }

    public static ADLSAccountBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ADLSAccountBuilder)((ADLSAccountBuilder)((ADLSAccountBuilder)ADLSAccount._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ADLSAccountBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return ADLSAccount.updater(this.getQualifiedName(), this.getName());
    }

    public static ADLSAccount removeDescription(String qualifiedName, String name) throws AtlanException {
        return ADLSAccount.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ADLSAccount removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSAccount)Asset.removeDescription(client, ADLSAccount.updater(qualifiedName, name));
    }

    public static ADLSAccount removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return ADLSAccount.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ADLSAccount removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSAccount)Asset.removeUserDescription(client, ADLSAccount.updater(qualifiedName, name));
    }

    public static ADLSAccount removeOwners(String qualifiedName, String name) throws AtlanException {
        return ADLSAccount.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ADLSAccount removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSAccount)Asset.removeOwners(client, ADLSAccount.updater(qualifiedName, name));
    }

    public static ADLSAccount updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return ADLSAccount.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static ADLSAccount updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ADLSAccount)Asset.updateCertificate(client, ADLSAccount._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ADLSAccount removeCertificate(String qualifiedName, String name) throws AtlanException {
        return ADLSAccount.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ADLSAccount removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSAccount)Asset.removeCertificate(client, ADLSAccount.updater(qualifiedName, name));
    }

    public static ADLSAccount updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return ADLSAccount.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static ADLSAccount updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ADLSAccount)Asset.updateAnnouncement(client, ADLSAccount._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ADLSAccount removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return ADLSAccount.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ADLSAccount removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSAccount)Asset.removeAnnouncement(client, ADLSAccount.updater(qualifiedName, name));
    }

    public static ADLSAccount replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return ADLSAccount.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static ADLSAccount replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ADLSAccount)Asset.replaceTerms(client, ADLSAccount.updater(qualifiedName, name), terms);
    }

    public static ADLSAccount appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ADLSAccount.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ADLSAccount appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ADLSAccount)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ADLSAccount removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ADLSAccount.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ADLSAccount removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ADLSAccount)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ADLSAccount appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return ADLSAccount.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static ADLSAccount appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ADLSAccount)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static ADLSAccount appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return ADLSAccount.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static ADLSAccount appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ADLSAccount)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        ADLSAccount.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        ADLSAccount.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        ADLSAccount.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ADLSAccount(ADLSAccountBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        List<Object> azureTags;
        this.typeName = b.typeName$set ? b.typeName$value : ADLSAccount.$default$typeName();
        this.adlsAccountAccessTier = b.adlsAccountAccessTier;
        this.adlsAccountKind = b.adlsAccountKind;
        this.adlsAccountPerformance = b.adlsAccountPerformance;
        this.adlsAccountProvisionState = b.adlsAccountProvisionState;
        this.adlsAccountQualifiedName = b.adlsAccountQualifiedName;
        this.adlsAccountReplication = b.adlsAccountReplication;
        this.adlsAccountResourceGroup = b.adlsAccountResourceGroup;
        this.adlsAccountSecondaryLocation = b.adlsAccountSecondaryLocation;
        this.adlsAccountSubscription = b.adlsAccountSubscription;
        SortedSet<IADLSContainer> adlsContainers = new TreeSet<IADLSContainer>();
        if (b.adlsContainers != null) {
            adlsContainers.addAll(b.adlsContainers);
        }
        adlsContainers = Collections.unmodifiableSortedSet(adlsContainers);
        this.adlsContainers = adlsContainers;
        this.adlsETag = b.adlsETag;
        this.adlsEncryptionType = b.adlsEncryptionType;
        this.adlsPrimaryDiskState = b.adlsPrimaryDiskState;
        this.azureLocation = b.azureLocation;
        this.azureResourceId = b.azureResourceId;
        switch (b.azureTags == null ? 0 : b.azureTags.size()) {
            case 0: {
                azureTags = Collections.emptyList();
                break;
            }
            case 1: {
                azureTags = Collections.singletonList(b.azureTags.get(0));
                break;
            }
            default: {
                azureTags = Collections.unmodifiableList(new ArrayList<AzureTag>(b.azureTags));
            }
        }
        this.azureTags = azureTags;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
    }

    @Generated
    public static ADLSAccountBuilder<?, ?> _internal() {
        return new ADLSAccountBuilderImpl();
    }

    @Generated
    public ADLSAccountBuilder<?, ?> toBuilder() {
        return new ADLSAccountBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public ADLSAccessTier getAdlsAccountAccessTier() {
        return this.adlsAccountAccessTier;
    }

    @Override
    @Generated
    public ADLSStorageKind getAdlsAccountKind() {
        return this.adlsAccountKind;
    }

    @Override
    @Generated
    public ADLSPerformance getAdlsAccountPerformance() {
        return this.adlsAccountPerformance;
    }

    @Override
    @Generated
    public ADLSProvisionState getAdlsAccountProvisionState() {
        return this.adlsAccountProvisionState;
    }

    @Override
    @Generated
    public String getAdlsAccountQualifiedName() {
        return this.adlsAccountQualifiedName;
    }

    @Override
    @Generated
    public ADLSReplicationType getAdlsAccountReplication() {
        return this.adlsAccountReplication;
    }

    @Override
    @Generated
    public String getAdlsAccountResourceGroup() {
        return this.adlsAccountResourceGroup;
    }

    @Override
    @Generated
    public String getAdlsAccountSecondaryLocation() {
        return this.adlsAccountSecondaryLocation;
    }

    @Override
    @Generated
    public String getAdlsAccountSubscription() {
        return this.adlsAccountSubscription;
    }

    @Override
    @Generated
    public SortedSet<IADLSContainer> getAdlsContainers() {
        return this.adlsContainers;
    }

    @Override
    @Generated
    public String getAdlsETag() {
        return this.adlsETag;
    }

    @Override
    @Generated
    public ADLSEncryptionTypes getAdlsEncryptionType() {
        return this.adlsEncryptionType;
    }

    @Override
    @Generated
    public ADLSAccountStatus getAdlsPrimaryDiskState() {
        return this.adlsPrimaryDiskState;
    }

    @Override
    @Generated
    public String getAzureLocation() {
        return this.azureLocation;
    }

    @Override
    @Generated
    public String getAzureResourceId() {
        return this.azureResourceId;
    }

    @Override
    @Generated
    public List<AzureTag> getAzureTags() {
        return this.azureTags;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ADLSAccount)) {
            return false;
        }
        ADLSAccount other = (ADLSAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        ADLSAccessTier this$adlsAccountAccessTier = this.getAdlsAccountAccessTier();
        ADLSAccessTier other$adlsAccountAccessTier = other.getAdlsAccountAccessTier();
        if (this$adlsAccountAccessTier == null ? other$adlsAccountAccessTier != null : !this$adlsAccountAccessTier.equals(other$adlsAccountAccessTier)) {
            return false;
        }
        ADLSStorageKind this$adlsAccountKind = this.getAdlsAccountKind();
        ADLSStorageKind other$adlsAccountKind = other.getAdlsAccountKind();
        if (this$adlsAccountKind == null ? other$adlsAccountKind != null : !this$adlsAccountKind.equals(other$adlsAccountKind)) {
            return false;
        }
        ADLSPerformance this$adlsAccountPerformance = this.getAdlsAccountPerformance();
        ADLSPerformance other$adlsAccountPerformance = other.getAdlsAccountPerformance();
        if (this$adlsAccountPerformance == null ? other$adlsAccountPerformance != null : !this$adlsAccountPerformance.equals(other$adlsAccountPerformance)) {
            return false;
        }
        ADLSProvisionState this$adlsAccountProvisionState = this.getAdlsAccountProvisionState();
        ADLSProvisionState other$adlsAccountProvisionState = other.getAdlsAccountProvisionState();
        if (this$adlsAccountProvisionState == null ? other$adlsAccountProvisionState != null : !this$adlsAccountProvisionState.equals(other$adlsAccountProvisionState)) {
            return false;
        }
        String this$adlsAccountQualifiedName = this.getAdlsAccountQualifiedName();
        String other$adlsAccountQualifiedName = other.getAdlsAccountQualifiedName();
        if (this$adlsAccountQualifiedName == null ? other$adlsAccountQualifiedName != null : !this$adlsAccountQualifiedName.equals(other$adlsAccountQualifiedName)) {
            return false;
        }
        ADLSReplicationType this$adlsAccountReplication = this.getAdlsAccountReplication();
        ADLSReplicationType other$adlsAccountReplication = other.getAdlsAccountReplication();
        if (this$adlsAccountReplication == null ? other$adlsAccountReplication != null : !this$adlsAccountReplication.equals(other$adlsAccountReplication)) {
            return false;
        }
        String this$adlsAccountResourceGroup = this.getAdlsAccountResourceGroup();
        String other$adlsAccountResourceGroup = other.getAdlsAccountResourceGroup();
        if (this$adlsAccountResourceGroup == null ? other$adlsAccountResourceGroup != null : !this$adlsAccountResourceGroup.equals(other$adlsAccountResourceGroup)) {
            return false;
        }
        String this$adlsAccountSecondaryLocation = this.getAdlsAccountSecondaryLocation();
        String other$adlsAccountSecondaryLocation = other.getAdlsAccountSecondaryLocation();
        if (this$adlsAccountSecondaryLocation == null ? other$adlsAccountSecondaryLocation != null : !this$adlsAccountSecondaryLocation.equals(other$adlsAccountSecondaryLocation)) {
            return false;
        }
        String this$adlsAccountSubscription = this.getAdlsAccountSubscription();
        String other$adlsAccountSubscription = other.getAdlsAccountSubscription();
        if (this$adlsAccountSubscription == null ? other$adlsAccountSubscription != null : !this$adlsAccountSubscription.equals(other$adlsAccountSubscription)) {
            return false;
        }
        SortedSet<IADLSContainer> this$adlsContainers = this.getAdlsContainers();
        SortedSet<IADLSContainer> other$adlsContainers = other.getAdlsContainers();
        if (this$adlsContainers == null ? other$adlsContainers != null : !this$adlsContainers.equals(other$adlsContainers)) {
            return false;
        }
        String this$adlsETag = this.getAdlsETag();
        String other$adlsETag = other.getAdlsETag();
        if (this$adlsETag == null ? other$adlsETag != null : !this$adlsETag.equals(other$adlsETag)) {
            return false;
        }
        ADLSEncryptionTypes this$adlsEncryptionType = this.getAdlsEncryptionType();
        ADLSEncryptionTypes other$adlsEncryptionType = other.getAdlsEncryptionType();
        if (this$adlsEncryptionType == null ? other$adlsEncryptionType != null : !this$adlsEncryptionType.equals(other$adlsEncryptionType)) {
            return false;
        }
        ADLSAccountStatus this$adlsPrimaryDiskState = this.getAdlsPrimaryDiskState();
        ADLSAccountStatus other$adlsPrimaryDiskState = other.getAdlsPrimaryDiskState();
        if (this$adlsPrimaryDiskState == null ? other$adlsPrimaryDiskState != null : !this$adlsPrimaryDiskState.equals(other$adlsPrimaryDiskState)) {
            return false;
        }
        String this$azureLocation = this.getAzureLocation();
        String other$azureLocation = other.getAzureLocation();
        if (this$azureLocation == null ? other$azureLocation != null : !this$azureLocation.equals(other$azureLocation)) {
            return false;
        }
        String this$azureResourceId = this.getAzureResourceId();
        String other$azureResourceId = other.getAzureResourceId();
        if (this$azureResourceId == null ? other$azureResourceId != null : !this$azureResourceId.equals(other$azureResourceId)) {
            return false;
        }
        List<AzureTag> this$azureTags = this.getAzureTags();
        List<AzureTag> other$azureTags = other.getAzureTags();
        if (this$azureTags == null ? other$azureTags != null : !((Object)this$azureTags).equals(other$azureTags)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ADLSAccount;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        ADLSAccessTier $adlsAccountAccessTier = this.getAdlsAccountAccessTier();
        result = result * 59 + ($adlsAccountAccessTier == null ? 43 : $adlsAccountAccessTier.hashCode());
        ADLSStorageKind $adlsAccountKind = this.getAdlsAccountKind();
        result = result * 59 + ($adlsAccountKind == null ? 43 : $adlsAccountKind.hashCode());
        ADLSPerformance $adlsAccountPerformance = this.getAdlsAccountPerformance();
        result = result * 59 + ($adlsAccountPerformance == null ? 43 : $adlsAccountPerformance.hashCode());
        ADLSProvisionState $adlsAccountProvisionState = this.getAdlsAccountProvisionState();
        result = result * 59 + ($adlsAccountProvisionState == null ? 43 : $adlsAccountProvisionState.hashCode());
        String $adlsAccountQualifiedName = this.getAdlsAccountQualifiedName();
        result = result * 59 + ($adlsAccountQualifiedName == null ? 43 : $adlsAccountQualifiedName.hashCode());
        ADLSReplicationType $adlsAccountReplication = this.getAdlsAccountReplication();
        result = result * 59 + ($adlsAccountReplication == null ? 43 : $adlsAccountReplication.hashCode());
        String $adlsAccountResourceGroup = this.getAdlsAccountResourceGroup();
        result = result * 59 + ($adlsAccountResourceGroup == null ? 43 : $adlsAccountResourceGroup.hashCode());
        String $adlsAccountSecondaryLocation = this.getAdlsAccountSecondaryLocation();
        result = result * 59 + ($adlsAccountSecondaryLocation == null ? 43 : $adlsAccountSecondaryLocation.hashCode());
        String $adlsAccountSubscription = this.getAdlsAccountSubscription();
        result = result * 59 + ($adlsAccountSubscription == null ? 43 : $adlsAccountSubscription.hashCode());
        SortedSet<IADLSContainer> $adlsContainers = this.getAdlsContainers();
        result = result * 59 + ($adlsContainers == null ? 43 : $adlsContainers.hashCode());
        String $adlsETag = this.getAdlsETag();
        result = result * 59 + ($adlsETag == null ? 43 : $adlsETag.hashCode());
        ADLSEncryptionTypes $adlsEncryptionType = this.getAdlsEncryptionType();
        result = result * 59 + ($adlsEncryptionType == null ? 43 : $adlsEncryptionType.hashCode());
        ADLSAccountStatus $adlsPrimaryDiskState = this.getAdlsPrimaryDiskState();
        result = result * 59 + ($adlsPrimaryDiskState == null ? 43 : $adlsPrimaryDiskState.hashCode());
        String $azureLocation = this.getAzureLocation();
        result = result * 59 + ($azureLocation == null ? 43 : $azureLocation.hashCode());
        String $azureResourceId = this.getAzureResourceId();
        result = result * 59 + ($azureResourceId == null ? 43 : $azureResourceId.hashCode());
        List<AzureTag> $azureTags = this.getAzureTags();
        result = result * 59 + ($azureTags == null ? 43 : ((Object)$azureTags).hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ADLSAccount(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", adlsAccountAccessTier=" + this.getAdlsAccountAccessTier() + ", adlsAccountKind=" + this.getAdlsAccountKind() + ", adlsAccountPerformance=" + this.getAdlsAccountPerformance() + ", adlsAccountProvisionState=" + this.getAdlsAccountProvisionState() + ", adlsAccountQualifiedName=" + this.getAdlsAccountQualifiedName() + ", adlsAccountReplication=" + this.getAdlsAccountReplication() + ", adlsAccountResourceGroup=" + this.getAdlsAccountResourceGroup() + ", adlsAccountSecondaryLocation=" + this.getAdlsAccountSecondaryLocation() + ", adlsAccountSubscription=" + this.getAdlsAccountSubscription() + ", adlsContainers=" + this.getAdlsContainers() + ", adlsETag=" + this.getAdlsETag() + ", adlsEncryptionType=" + this.getAdlsEncryptionType() + ", adlsPrimaryDiskState=" + this.getAdlsPrimaryDiskState() + ", azureLocation=" + this.getAzureLocation() + ", azureResourceId=" + this.getAzureResourceId() + ", azureTags=" + this.getAzureTags() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class ADLSAccountBuilderImpl
    extends ADLSAccountBuilder<ADLSAccount, ADLSAccountBuilderImpl> {
        @Generated
        private ADLSAccountBuilderImpl() {
        }

        @Override
        @Generated
        protected ADLSAccountBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ADLSAccount build() {
            return new ADLSAccount(this);
        }
    }

    @Generated
    public static abstract class ADLSAccountBuilder<C extends ADLSAccount, B extends ADLSAccountBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ADLSAccessTier adlsAccountAccessTier;
        @Generated
        private ADLSStorageKind adlsAccountKind;
        @Generated
        private ADLSPerformance adlsAccountPerformance;
        @Generated
        private ADLSProvisionState adlsAccountProvisionState;
        @Generated
        private String adlsAccountQualifiedName;
        @Generated
        private ADLSReplicationType adlsAccountReplication;
        @Generated
        private String adlsAccountResourceGroup;
        @Generated
        private String adlsAccountSecondaryLocation;
        @Generated
        private String adlsAccountSubscription;
        @Generated
        private ArrayList<IADLSContainer> adlsContainers;
        @Generated
        private String adlsETag;
        @Generated
        private ADLSEncryptionTypes adlsEncryptionType;
        @Generated
        private ADLSAccountStatus adlsPrimaryDiskState;
        @Generated
        private String azureLocation;
        @Generated
        private String azureResourceId;
        @Generated
        private ArrayList<AzureTag> azureTags;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ADLSAccountBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ADLSAccount instance, ADLSAccountBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.adlsAccountAccessTier(instance.adlsAccountAccessTier);
            b.adlsAccountKind(instance.adlsAccountKind);
            b.adlsAccountPerformance(instance.adlsAccountPerformance);
            b.adlsAccountProvisionState(instance.adlsAccountProvisionState);
            b.adlsAccountQualifiedName(instance.adlsAccountQualifiedName);
            b.adlsAccountReplication(instance.adlsAccountReplication);
            b.adlsAccountResourceGroup(instance.adlsAccountResourceGroup);
            b.adlsAccountSecondaryLocation(instance.adlsAccountSecondaryLocation);
            b.adlsAccountSubscription(instance.adlsAccountSubscription);
            b.adlsContainers(instance.adlsContainers == null ? Collections.emptySortedSet() : instance.adlsContainers);
            b.adlsETag(instance.adlsETag);
            b.adlsEncryptionType(instance.adlsEncryptionType);
            b.adlsPrimaryDiskState(instance.adlsPrimaryDiskState);
            b.azureLocation(instance.azureLocation);
            b.azureResourceId(instance.azureResourceId);
            b.azureTags(instance.azureTags == null ? Collections.emptyList() : instance.azureTags);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B adlsAccountAccessTier(ADLSAccessTier adlsAccountAccessTier) {
            this.adlsAccountAccessTier = adlsAccountAccessTier;
            return (B)this.self();
        }

        @Generated
        public B adlsAccountKind(ADLSStorageKind adlsAccountKind) {
            this.adlsAccountKind = adlsAccountKind;
            return (B)this.self();
        }

        @Generated
        public B adlsAccountPerformance(ADLSPerformance adlsAccountPerformance) {
            this.adlsAccountPerformance = adlsAccountPerformance;
            return (B)this.self();
        }

        @Generated
        public B adlsAccountProvisionState(ADLSProvisionState adlsAccountProvisionState) {
            this.adlsAccountProvisionState = adlsAccountProvisionState;
            return (B)this.self();
        }

        @Generated
        public B adlsAccountQualifiedName(String adlsAccountQualifiedName) {
            this.adlsAccountQualifiedName = adlsAccountQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B adlsAccountReplication(ADLSReplicationType adlsAccountReplication) {
            this.adlsAccountReplication = adlsAccountReplication;
            return (B)this.self();
        }

        @Generated
        public B adlsAccountResourceGroup(String adlsAccountResourceGroup) {
            this.adlsAccountResourceGroup = adlsAccountResourceGroup;
            return (B)this.self();
        }

        @Generated
        public B adlsAccountSecondaryLocation(String adlsAccountSecondaryLocation) {
            this.adlsAccountSecondaryLocation = adlsAccountSecondaryLocation;
            return (B)this.self();
        }

        @Generated
        public B adlsAccountSubscription(String adlsAccountSubscription) {
            this.adlsAccountSubscription = adlsAccountSubscription;
            return (B)this.self();
        }

        @Generated
        public B adlsContainer(IADLSContainer adlsContainer) {
            if (this.adlsContainers == null) {
                this.adlsContainers = new ArrayList();
            }
            this.adlsContainers.add(adlsContainer);
            return (B)this.self();
        }

        @Generated
        public B adlsContainers(Collection<? extends IADLSContainer> adlsContainers) {
            if (adlsContainers == null) {
                throw new NullPointerException("adlsContainers cannot be null");
            }
            if (this.adlsContainers == null) {
                this.adlsContainers = new ArrayList();
            }
            this.adlsContainers.addAll(adlsContainers);
            return (B)this.self();
        }

        @Generated
        public B clearAdlsContainers() {
            if (this.adlsContainers != null) {
                this.adlsContainers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adlsETag(String adlsETag) {
            this.adlsETag = adlsETag;
            return (B)this.self();
        }

        @Generated
        public B adlsEncryptionType(ADLSEncryptionTypes adlsEncryptionType) {
            this.adlsEncryptionType = adlsEncryptionType;
            return (B)this.self();
        }

        @Generated
        public B adlsPrimaryDiskState(ADLSAccountStatus adlsPrimaryDiskState) {
            this.adlsPrimaryDiskState = adlsPrimaryDiskState;
            return (B)this.self();
        }

        @Generated
        public B azureLocation(String azureLocation) {
            this.azureLocation = azureLocation;
            return (B)this.self();
        }

        @Generated
        public B azureResourceId(String azureResourceId) {
            this.azureResourceId = azureResourceId;
            return (B)this.self();
        }

        @Generated
        public B azureTag(AzureTag azureTag) {
            if (this.azureTags == null) {
                this.azureTags = new ArrayList();
            }
            this.azureTags.add(azureTag);
            return (B)this.self();
        }

        @Generated
        public B azureTags(Collection<? extends AzureTag> azureTags) {
            if (azureTags == null) {
                throw new NullPointerException("azureTags cannot be null");
            }
            if (this.azureTags == null) {
                this.azureTags = new ArrayList();
            }
            this.azureTags.addAll(azureTags);
            return (B)this.self();
        }

        @Generated
        public B clearAzureTags() {
            if (this.azureTags != null) {
                this.azureTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ADLSAccount.ADLSAccountBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", adlsAccountAccessTier=" + this.adlsAccountAccessTier + ", adlsAccountKind=" + this.adlsAccountKind + ", adlsAccountPerformance=" + this.adlsAccountPerformance + ", adlsAccountProvisionState=" + this.adlsAccountProvisionState + ", adlsAccountQualifiedName=" + this.adlsAccountQualifiedName + ", adlsAccountReplication=" + this.adlsAccountReplication + ", adlsAccountResourceGroup=" + this.adlsAccountResourceGroup + ", adlsAccountSecondaryLocation=" + this.adlsAccountSecondaryLocation + ", adlsAccountSubscription=" + this.adlsAccountSubscription + ", adlsContainers=" + this.adlsContainers + ", adlsETag=" + this.adlsETag + ", adlsEncryptionType=" + this.adlsEncryptionType + ", adlsPrimaryDiskState=" + this.adlsPrimaryDiskState + ", azureLocation=" + this.azureLocation + ", azureResourceId=" + this.azureResourceId + ", azureTags=" + this.azureTags + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ")";
        }
    }
}

