/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAPI;
import com.atlan.model.assets.IAPIPath;
import com.atlan.model.assets.IAPISpec;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APISpec
extends Asset
implements IAPISpec,
IAPI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(APISpec.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "APISpec";
    String typeName;
    @Attribute
    Map<String, String> apiExternalDocs;
    @Attribute
    Boolean apiIsAuthOptional;
    @Attribute
    SortedSet<IAPIPath> apiPaths;
    @Attribute
    String apiSpecContactEmail;
    @Attribute
    String apiSpecContactName;
    @Attribute
    String apiSpecContactURL;
    @Attribute
    String apiSpecContractVersion;
    @Attribute
    String apiSpecLicenseName;
    @Attribute
    String apiSpecLicenseURL;
    @Attribute
    String apiSpecName;
    @Attribute
    String apiSpecQualifiedName;
    @Attribute
    String apiSpecServiceAlias;
    @Attribute
    String apiSpecTermsOfServiceURL;
    @Attribute
    String apiSpecType;
    @Attribute
    String apiSpecVersion;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;

    @Override
    public APISpec trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return APISpec.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return APISpec.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return APISpec.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return APISpec.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return APISpec.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return APISpec.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return APISpec.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return APISpec.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return APISpec.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static APISpec refByGuid(String guid) {
        return ((APISpecBuilder)APISpec._internal().guid(guid)).build();
    }

    public static APISpec refByQualifiedName(String qualifiedName) {
        return ((APISpecBuilder)APISpec._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static APISpec get(String id) throws AtlanException {
        return APISpec.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static APISpec get(AtlanClient client, String id) throws AtlanException {
        return APISpec.get(client, id, true);
    }

    @JsonIgnore
    public static APISpec get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof APISpec) {
                return (APISpec)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof APISpec) {
            return (APISpec)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static APISpec retrieveByGuid(String guid) throws AtlanException {
        return APISpec.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static APISpec retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return APISpec.get(client, guid);
    }

    @Deprecated
    public static APISpec retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return APISpec.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static APISpec retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return APISpec.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return APISpec.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static APISpecBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return (APISpecBuilder)((APISpecBuilder)((APISpecBuilder)((APISpecBuilder)((APISpecBuilder)APISpec._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(connectionQualifiedName + "/" + name)).name(name)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.API);
    }

    public static APISpecBuilder<?, ?> updater(String qualifiedName, String name) {
        return (APISpecBuilder)((APISpecBuilder)((APISpecBuilder)APISpec._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public APISpecBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return APISpec.updater(this.getQualifiedName(), this.getName());
    }

    public static APISpec removeDescription(String qualifiedName, String name) throws AtlanException {
        return APISpec.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static APISpec removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APISpec)Asset.removeDescription(client, APISpec.updater(qualifiedName, name));
    }

    public static APISpec removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return APISpec.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static APISpec removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APISpec)Asset.removeUserDescription(client, APISpec.updater(qualifiedName, name));
    }

    public static APISpec removeOwners(String qualifiedName, String name) throws AtlanException {
        return APISpec.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static APISpec removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APISpec)Asset.removeOwners(client, APISpec.updater(qualifiedName, name));
    }

    public static APISpec updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return APISpec.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static APISpec updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (APISpec)Asset.updateCertificate(client, APISpec._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static APISpec removeCertificate(String qualifiedName, String name) throws AtlanException {
        return APISpec.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static APISpec removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APISpec)Asset.removeCertificate(client, APISpec.updater(qualifiedName, name));
    }

    public static APISpec updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return APISpec.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static APISpec updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (APISpec)Asset.updateAnnouncement(client, APISpec._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static APISpec removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return APISpec.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static APISpec removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APISpec)Asset.removeAnnouncement(client, APISpec.updater(qualifiedName, name));
    }

    public static APISpec replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return APISpec.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static APISpec replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (APISpec)Asset.replaceTerms(client, APISpec.updater(qualifiedName, name), terms);
    }

    public static APISpec appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return APISpec.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static APISpec appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (APISpec)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static APISpec removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return APISpec.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static APISpec removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (APISpec)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static APISpec appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return APISpec.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static APISpec appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (APISpec)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static APISpec appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return APISpec.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static APISpec appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (APISpec)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        APISpec.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        APISpec.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        APISpec.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected APISpec(APISpecBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> apiExternalDocs;
        this.typeName = b.typeName$set ? b.typeName$value : APISpec.$default$typeName();
        switch (b.apiExternalDocs$key == null ? 0 : b.apiExternalDocs$key.size()) {
            case 0: {
                apiExternalDocs = Collections.emptyMap();
                break;
            }
            case 1: {
                apiExternalDocs = Collections.singletonMap(b.apiExternalDocs$key.get(0), b.apiExternalDocs$value.get(0));
                break;
            }
            default: {
                apiExternalDocs = new LinkedHashMap(b.apiExternalDocs$key.size() < 0x40000000 ? 1 + b.apiExternalDocs$key.size() + (b.apiExternalDocs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.apiExternalDocs$key.size(); ++$i) {
                    apiExternalDocs.put(b.apiExternalDocs$key.get($i), b.apiExternalDocs$value.get($i));
                }
                apiExternalDocs = Collections.unmodifiableMap(apiExternalDocs);
            }
        }
        this.apiExternalDocs = apiExternalDocs;
        this.apiIsAuthOptional = b.apiIsAuthOptional;
        SortedSet<IAPIPath> apiPaths = new TreeSet<IAPIPath>();
        if (b.apiPaths != null) {
            apiPaths.addAll(b.apiPaths);
        }
        apiPaths = Collections.unmodifiableSortedSet(apiPaths);
        this.apiPaths = apiPaths;
        this.apiSpecContactEmail = b.apiSpecContactEmail;
        this.apiSpecContactName = b.apiSpecContactName;
        this.apiSpecContactURL = b.apiSpecContactURL;
        this.apiSpecContractVersion = b.apiSpecContractVersion;
        this.apiSpecLicenseName = b.apiSpecLicenseName;
        this.apiSpecLicenseURL = b.apiSpecLicenseURL;
        this.apiSpecName = b.apiSpecName;
        this.apiSpecQualifiedName = b.apiSpecQualifiedName;
        this.apiSpecServiceAlias = b.apiSpecServiceAlias;
        this.apiSpecTermsOfServiceURL = b.apiSpecTermsOfServiceURL;
        this.apiSpecType = b.apiSpecType;
        this.apiSpecVersion = b.apiSpecVersion;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
    }

    @Generated
    public static APISpecBuilder<?, ?> _internal() {
        return new APISpecBuilderImpl();
    }

    @Generated
    public APISpecBuilder<?, ?> toBuilder() {
        return new APISpecBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Map<String, String> getApiExternalDocs() {
        return this.apiExternalDocs;
    }

    @Override
    @Generated
    public Boolean getApiIsAuthOptional() {
        return this.apiIsAuthOptional;
    }

    @Override
    @Generated
    public SortedSet<IAPIPath> getApiPaths() {
        return this.apiPaths;
    }

    @Override
    @Generated
    public String getApiSpecContactEmail() {
        return this.apiSpecContactEmail;
    }

    @Override
    @Generated
    public String getApiSpecContactName() {
        return this.apiSpecContactName;
    }

    @Override
    @Generated
    public String getApiSpecContactURL() {
        return this.apiSpecContactURL;
    }

    @Override
    @Generated
    public String getApiSpecContractVersion() {
        return this.apiSpecContractVersion;
    }

    @Override
    @Generated
    public String getApiSpecLicenseName() {
        return this.apiSpecLicenseName;
    }

    @Override
    @Generated
    public String getApiSpecLicenseURL() {
        return this.apiSpecLicenseURL;
    }

    @Override
    @Generated
    public String getApiSpecName() {
        return this.apiSpecName;
    }

    @Override
    @Generated
    public String getApiSpecQualifiedName() {
        return this.apiSpecQualifiedName;
    }

    @Override
    @Generated
    public String getApiSpecServiceAlias() {
        return this.apiSpecServiceAlias;
    }

    @Override
    @Generated
    public String getApiSpecTermsOfServiceURL() {
        return this.apiSpecTermsOfServiceURL;
    }

    @Override
    @Generated
    public String getApiSpecType() {
        return this.apiSpecType;
    }

    @Override
    @Generated
    public String getApiSpecVersion() {
        return this.apiSpecVersion;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APISpec)) {
            return false;
        }
        APISpec other = (APISpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$apiIsAuthOptional = this.getApiIsAuthOptional();
        Boolean other$apiIsAuthOptional = other.getApiIsAuthOptional();
        if (this$apiIsAuthOptional == null ? other$apiIsAuthOptional != null : !((Object)this$apiIsAuthOptional).equals(other$apiIsAuthOptional)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        Map<String, String> this$apiExternalDocs = this.getApiExternalDocs();
        Map<String, String> other$apiExternalDocs = other.getApiExternalDocs();
        if (this$apiExternalDocs == null ? other$apiExternalDocs != null : !((Object)this$apiExternalDocs).equals(other$apiExternalDocs)) {
            return false;
        }
        SortedSet<IAPIPath> this$apiPaths = this.getApiPaths();
        SortedSet<IAPIPath> other$apiPaths = other.getApiPaths();
        if (this$apiPaths == null ? other$apiPaths != null : !this$apiPaths.equals(other$apiPaths)) {
            return false;
        }
        String this$apiSpecContactEmail = this.getApiSpecContactEmail();
        String other$apiSpecContactEmail = other.getApiSpecContactEmail();
        if (this$apiSpecContactEmail == null ? other$apiSpecContactEmail != null : !this$apiSpecContactEmail.equals(other$apiSpecContactEmail)) {
            return false;
        }
        String this$apiSpecContactName = this.getApiSpecContactName();
        String other$apiSpecContactName = other.getApiSpecContactName();
        if (this$apiSpecContactName == null ? other$apiSpecContactName != null : !this$apiSpecContactName.equals(other$apiSpecContactName)) {
            return false;
        }
        String this$apiSpecContactURL = this.getApiSpecContactURL();
        String other$apiSpecContactURL = other.getApiSpecContactURL();
        if (this$apiSpecContactURL == null ? other$apiSpecContactURL != null : !this$apiSpecContactURL.equals(other$apiSpecContactURL)) {
            return false;
        }
        String this$apiSpecContractVersion = this.getApiSpecContractVersion();
        String other$apiSpecContractVersion = other.getApiSpecContractVersion();
        if (this$apiSpecContractVersion == null ? other$apiSpecContractVersion != null : !this$apiSpecContractVersion.equals(other$apiSpecContractVersion)) {
            return false;
        }
        String this$apiSpecLicenseName = this.getApiSpecLicenseName();
        String other$apiSpecLicenseName = other.getApiSpecLicenseName();
        if (this$apiSpecLicenseName == null ? other$apiSpecLicenseName != null : !this$apiSpecLicenseName.equals(other$apiSpecLicenseName)) {
            return false;
        }
        String this$apiSpecLicenseURL = this.getApiSpecLicenseURL();
        String other$apiSpecLicenseURL = other.getApiSpecLicenseURL();
        if (this$apiSpecLicenseURL == null ? other$apiSpecLicenseURL != null : !this$apiSpecLicenseURL.equals(other$apiSpecLicenseURL)) {
            return false;
        }
        String this$apiSpecName = this.getApiSpecName();
        String other$apiSpecName = other.getApiSpecName();
        if (this$apiSpecName == null ? other$apiSpecName != null : !this$apiSpecName.equals(other$apiSpecName)) {
            return false;
        }
        String this$apiSpecQualifiedName = this.getApiSpecQualifiedName();
        String other$apiSpecQualifiedName = other.getApiSpecQualifiedName();
        if (this$apiSpecQualifiedName == null ? other$apiSpecQualifiedName != null : !this$apiSpecQualifiedName.equals(other$apiSpecQualifiedName)) {
            return false;
        }
        String this$apiSpecServiceAlias = this.getApiSpecServiceAlias();
        String other$apiSpecServiceAlias = other.getApiSpecServiceAlias();
        if (this$apiSpecServiceAlias == null ? other$apiSpecServiceAlias != null : !this$apiSpecServiceAlias.equals(other$apiSpecServiceAlias)) {
            return false;
        }
        String this$apiSpecTermsOfServiceURL = this.getApiSpecTermsOfServiceURL();
        String other$apiSpecTermsOfServiceURL = other.getApiSpecTermsOfServiceURL();
        if (this$apiSpecTermsOfServiceURL == null ? other$apiSpecTermsOfServiceURL != null : !this$apiSpecTermsOfServiceURL.equals(other$apiSpecTermsOfServiceURL)) {
            return false;
        }
        String this$apiSpecType = this.getApiSpecType();
        String other$apiSpecType = other.getApiSpecType();
        if (this$apiSpecType == null ? other$apiSpecType != null : !this$apiSpecType.equals(other$apiSpecType)) {
            return false;
        }
        String this$apiSpecVersion = this.getApiSpecVersion();
        String other$apiSpecVersion = other.getApiSpecVersion();
        if (this$apiSpecVersion == null ? other$apiSpecVersion != null : !this$apiSpecVersion.equals(other$apiSpecVersion)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof APISpec;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $apiIsAuthOptional = this.getApiIsAuthOptional();
        result = result * 59 + ($apiIsAuthOptional == null ? 43 : ((Object)$apiIsAuthOptional).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        Map<String, String> $apiExternalDocs = this.getApiExternalDocs();
        result = result * 59 + ($apiExternalDocs == null ? 43 : ((Object)$apiExternalDocs).hashCode());
        SortedSet<IAPIPath> $apiPaths = this.getApiPaths();
        result = result * 59 + ($apiPaths == null ? 43 : $apiPaths.hashCode());
        String $apiSpecContactEmail = this.getApiSpecContactEmail();
        result = result * 59 + ($apiSpecContactEmail == null ? 43 : $apiSpecContactEmail.hashCode());
        String $apiSpecContactName = this.getApiSpecContactName();
        result = result * 59 + ($apiSpecContactName == null ? 43 : $apiSpecContactName.hashCode());
        String $apiSpecContactURL = this.getApiSpecContactURL();
        result = result * 59 + ($apiSpecContactURL == null ? 43 : $apiSpecContactURL.hashCode());
        String $apiSpecContractVersion = this.getApiSpecContractVersion();
        result = result * 59 + ($apiSpecContractVersion == null ? 43 : $apiSpecContractVersion.hashCode());
        String $apiSpecLicenseName = this.getApiSpecLicenseName();
        result = result * 59 + ($apiSpecLicenseName == null ? 43 : $apiSpecLicenseName.hashCode());
        String $apiSpecLicenseURL = this.getApiSpecLicenseURL();
        result = result * 59 + ($apiSpecLicenseURL == null ? 43 : $apiSpecLicenseURL.hashCode());
        String $apiSpecName = this.getApiSpecName();
        result = result * 59 + ($apiSpecName == null ? 43 : $apiSpecName.hashCode());
        String $apiSpecQualifiedName = this.getApiSpecQualifiedName();
        result = result * 59 + ($apiSpecQualifiedName == null ? 43 : $apiSpecQualifiedName.hashCode());
        String $apiSpecServiceAlias = this.getApiSpecServiceAlias();
        result = result * 59 + ($apiSpecServiceAlias == null ? 43 : $apiSpecServiceAlias.hashCode());
        String $apiSpecTermsOfServiceURL = this.getApiSpecTermsOfServiceURL();
        result = result * 59 + ($apiSpecTermsOfServiceURL == null ? 43 : $apiSpecTermsOfServiceURL.hashCode());
        String $apiSpecType = this.getApiSpecType();
        result = result * 59 + ($apiSpecType == null ? 43 : $apiSpecType.hashCode());
        String $apiSpecVersion = this.getApiSpecVersion();
        result = result * 59 + ($apiSpecVersion == null ? 43 : $apiSpecVersion.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "APISpec(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", apiExternalDocs=" + this.getApiExternalDocs() + ", apiIsAuthOptional=" + this.getApiIsAuthOptional() + ", apiPaths=" + this.getApiPaths() + ", apiSpecContactEmail=" + this.getApiSpecContactEmail() + ", apiSpecContactName=" + this.getApiSpecContactName() + ", apiSpecContactURL=" + this.getApiSpecContactURL() + ", apiSpecContractVersion=" + this.getApiSpecContractVersion() + ", apiSpecLicenseName=" + this.getApiSpecLicenseName() + ", apiSpecLicenseURL=" + this.getApiSpecLicenseURL() + ", apiSpecName=" + this.getApiSpecName() + ", apiSpecQualifiedName=" + this.getApiSpecQualifiedName() + ", apiSpecServiceAlias=" + this.getApiSpecServiceAlias() + ", apiSpecTermsOfServiceURL=" + this.getApiSpecTermsOfServiceURL() + ", apiSpecType=" + this.getApiSpecType() + ", apiSpecVersion=" + this.getApiSpecVersion() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class APISpecBuilderImpl
    extends APISpecBuilder<APISpec, APISpecBuilderImpl> {
        @Generated
        private APISpecBuilderImpl() {
        }

        @Override
        @Generated
        protected APISpecBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public APISpec build() {
            return new APISpec(this);
        }
    }

    @Generated
    public static abstract class APISpecBuilder<C extends APISpec, B extends APISpecBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<String> apiExternalDocs$key;
        @Generated
        private ArrayList<String> apiExternalDocs$value;
        @Generated
        private Boolean apiIsAuthOptional;
        @Generated
        private ArrayList<IAPIPath> apiPaths;
        @Generated
        private String apiSpecContactEmail;
        @Generated
        private String apiSpecContactName;
        @Generated
        private String apiSpecContactURL;
        @Generated
        private String apiSpecContractVersion;
        @Generated
        private String apiSpecLicenseName;
        @Generated
        private String apiSpecLicenseURL;
        @Generated
        private String apiSpecName;
        @Generated
        private String apiSpecQualifiedName;
        @Generated
        private String apiSpecServiceAlias;
        @Generated
        private String apiSpecTermsOfServiceURL;
        @Generated
        private String apiSpecType;
        @Generated
        private String apiSpecVersion;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            APISpecBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(APISpec instance, APISpecBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.apiExternalDocs(instance.apiExternalDocs == null ? Collections.emptyMap() : instance.apiExternalDocs);
            b.apiIsAuthOptional(instance.apiIsAuthOptional);
            b.apiPaths(instance.apiPaths == null ? Collections.emptySortedSet() : instance.apiPaths);
            b.apiSpecContactEmail(instance.apiSpecContactEmail);
            b.apiSpecContactName(instance.apiSpecContactName);
            b.apiSpecContactURL(instance.apiSpecContactURL);
            b.apiSpecContractVersion(instance.apiSpecContractVersion);
            b.apiSpecLicenseName(instance.apiSpecLicenseName);
            b.apiSpecLicenseURL(instance.apiSpecLicenseURL);
            b.apiSpecName(instance.apiSpecName);
            b.apiSpecQualifiedName(instance.apiSpecQualifiedName);
            b.apiSpecServiceAlias(instance.apiSpecServiceAlias);
            b.apiSpecTermsOfServiceURL(instance.apiSpecTermsOfServiceURL);
            b.apiSpecType(instance.apiSpecType);
            b.apiSpecVersion(instance.apiSpecVersion);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B apiExternalDoc(String apiExternalDocKey, String apiExternalDocValue) {
            if (this.apiExternalDocs$key == null) {
                this.apiExternalDocs$key = new ArrayList();
                this.apiExternalDocs$value = new ArrayList();
            }
            this.apiExternalDocs$key.add(apiExternalDocKey);
            this.apiExternalDocs$value.add(apiExternalDocValue);
            return (B)this.self();
        }

        @Generated
        public B apiExternalDocs(Map<? extends String, ? extends String> apiExternalDocs) {
            if (apiExternalDocs == null) {
                throw new NullPointerException("apiExternalDocs cannot be null");
            }
            if (this.apiExternalDocs$key == null) {
                this.apiExternalDocs$key = new ArrayList();
                this.apiExternalDocs$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : apiExternalDocs.entrySet()) {
                this.apiExternalDocs$key.add($lombokEntry.getKey());
                this.apiExternalDocs$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearApiExternalDocs() {
            if (this.apiExternalDocs$key != null) {
                this.apiExternalDocs$key.clear();
                this.apiExternalDocs$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B apiIsAuthOptional(Boolean apiIsAuthOptional) {
            this.apiIsAuthOptional = apiIsAuthOptional;
            return (B)this.self();
        }

        @Generated
        public B apiPath(IAPIPath apiPath) {
            if (this.apiPaths == null) {
                this.apiPaths = new ArrayList();
            }
            this.apiPaths.add(apiPath);
            return (B)this.self();
        }

        @Generated
        public B apiPaths(Collection<? extends IAPIPath> apiPaths) {
            if (apiPaths == null) {
                throw new NullPointerException("apiPaths cannot be null");
            }
            if (this.apiPaths == null) {
                this.apiPaths = new ArrayList();
            }
            this.apiPaths.addAll(apiPaths);
            return (B)this.self();
        }

        @Generated
        public B clearApiPaths() {
            if (this.apiPaths != null) {
                this.apiPaths.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B apiSpecContactEmail(String apiSpecContactEmail) {
            this.apiSpecContactEmail = apiSpecContactEmail;
            return (B)this.self();
        }

        @Generated
        public B apiSpecContactName(String apiSpecContactName) {
            this.apiSpecContactName = apiSpecContactName;
            return (B)this.self();
        }

        @Generated
        public B apiSpecContactURL(String apiSpecContactURL) {
            this.apiSpecContactURL = apiSpecContactURL;
            return (B)this.self();
        }

        @Generated
        public B apiSpecContractVersion(String apiSpecContractVersion) {
            this.apiSpecContractVersion = apiSpecContractVersion;
            return (B)this.self();
        }

        @Generated
        public B apiSpecLicenseName(String apiSpecLicenseName) {
            this.apiSpecLicenseName = apiSpecLicenseName;
            return (B)this.self();
        }

        @Generated
        public B apiSpecLicenseURL(String apiSpecLicenseURL) {
            this.apiSpecLicenseURL = apiSpecLicenseURL;
            return (B)this.self();
        }

        @Generated
        public B apiSpecName(String apiSpecName) {
            this.apiSpecName = apiSpecName;
            return (B)this.self();
        }

        @Generated
        public B apiSpecQualifiedName(String apiSpecQualifiedName) {
            this.apiSpecQualifiedName = apiSpecQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B apiSpecServiceAlias(String apiSpecServiceAlias) {
            this.apiSpecServiceAlias = apiSpecServiceAlias;
            return (B)this.self();
        }

        @Generated
        public B apiSpecTermsOfServiceURL(String apiSpecTermsOfServiceURL) {
            this.apiSpecTermsOfServiceURL = apiSpecTermsOfServiceURL;
            return (B)this.self();
        }

        @Generated
        public B apiSpecType(String apiSpecType) {
            this.apiSpecType = apiSpecType;
            return (B)this.self();
        }

        @Generated
        public B apiSpecVersion(String apiSpecVersion) {
            this.apiSpecVersion = apiSpecVersion;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "APISpec.APISpecBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", apiExternalDocs$key=" + this.apiExternalDocs$key + ", apiExternalDocs$value=" + this.apiExternalDocs$value + ", apiIsAuthOptional=" + this.apiIsAuthOptional + ", apiPaths=" + this.apiPaths + ", apiSpecContactEmail=" + this.apiSpecContactEmail + ", apiSpecContactName=" + this.apiSpecContactName + ", apiSpecContactURL=" + this.apiSpecContactURL + ", apiSpecContractVersion=" + this.apiSpecContractVersion + ", apiSpecLicenseName=" + this.apiSpecLicenseName + ", apiSpecLicenseURL=" + this.apiSpecLicenseURL + ", apiSpecName=" + this.apiSpecName + ", apiSpecQualifiedName=" + this.apiSpecQualifiedName + ", apiSpecServiceAlias=" + this.apiSpecServiceAlias + ", apiSpecTermsOfServiceURL=" + this.apiSpecTermsOfServiceURL + ", apiSpecType=" + this.apiSpecType + ", apiSpecVersion=" + this.apiSpecVersion + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ")";
        }
    }
}

