/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflow;
import com.atlan.model.assets.IAirflowDag;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.OpenLineageRunState;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirflowDag
extends Asset
implements IAirflowDag,
IAirflow,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AirflowDag.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AirflowDag";
    String typeName;
    @Attribute
    String airflowDagSchedule;
    @Attribute
    Long airflowDagScheduleDelta;
    @Attribute
    Long airflowRunEndTime;
    @Attribute
    String airflowRunName;
    @Attribute
    OpenLineageRunState airflowRunOpenLineageState;
    @Attribute
    String airflowRunOpenLineageVersion;
    @Attribute
    Long airflowRunStartTime;
    @Attribute
    String airflowRunType;
    @Attribute
    String airflowRunVersion;
    @Attribute
    SortedSet<String> airflowTags;
    @Attribute
    SortedSet<IAirflowTask> airflowTasks;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;

    @Override
    public AirflowDag trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return AirflowDag.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return AirflowDag.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return AirflowDag.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return AirflowDag.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return AirflowDag.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return AirflowDag.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return AirflowDag.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return AirflowDag.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return AirflowDag.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static AirflowDag refByGuid(String guid) {
        return ((AirflowDagBuilder)AirflowDag._internal().guid(guid)).build();
    }

    public static AirflowDag refByQualifiedName(String qualifiedName) {
        return ((AirflowDagBuilder)AirflowDag._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static AirflowDag get(String id) throws AtlanException {
        return AirflowDag.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static AirflowDag get(AtlanClient client, String id) throws AtlanException {
        return AirflowDag.get(client, id, true);
    }

    @JsonIgnore
    public static AirflowDag get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof AirflowDag) {
                return (AirflowDag)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof AirflowDag) {
            return (AirflowDag)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static AirflowDag retrieveByGuid(String guid) throws AtlanException {
        return AirflowDag.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static AirflowDag retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return AirflowDag.get(client, guid);
    }

    @Deprecated
    public static AirflowDag retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return AirflowDag.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static AirflowDag retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return AirflowDag.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return AirflowDag.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static AirflowDagBuilder<?, ?> updater(String qualifiedName, String name) {
        return (AirflowDagBuilder)((AirflowDagBuilder)((AirflowDagBuilder)AirflowDag._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public AirflowDagBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return AirflowDag.updater(this.getQualifiedName(), this.getName());
    }

    public static AirflowDag removeDescription(String qualifiedName, String name) throws AtlanException {
        return AirflowDag.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static AirflowDag removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowDag)Asset.removeDescription(client, AirflowDag.updater(qualifiedName, name));
    }

    public static AirflowDag removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return AirflowDag.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static AirflowDag removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowDag)Asset.removeUserDescription(client, AirflowDag.updater(qualifiedName, name));
    }

    public static AirflowDag removeOwners(String qualifiedName, String name) throws AtlanException {
        return AirflowDag.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static AirflowDag removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowDag)Asset.removeOwners(client, AirflowDag.updater(qualifiedName, name));
    }

    public static AirflowDag updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return AirflowDag.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static AirflowDag updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AirflowDag)Asset.updateCertificate(client, AirflowDag._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static AirflowDag removeCertificate(String qualifiedName, String name) throws AtlanException {
        return AirflowDag.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static AirflowDag removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowDag)Asset.removeCertificate(client, AirflowDag.updater(qualifiedName, name));
    }

    public static AirflowDag updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return AirflowDag.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static AirflowDag updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AirflowDag)Asset.updateAnnouncement(client, AirflowDag._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static AirflowDag removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return AirflowDag.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static AirflowDag removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowDag)Asset.removeAnnouncement(client, AirflowDag.updater(qualifiedName, name));
    }

    public static AirflowDag replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return AirflowDag.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static AirflowDag replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AirflowDag)Asset.replaceTerms(client, AirflowDag.updater(qualifiedName, name), terms);
    }

    public static AirflowDag appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return AirflowDag.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static AirflowDag appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AirflowDag)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static AirflowDag removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return AirflowDag.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static AirflowDag removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AirflowDag)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static AirflowDag appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return AirflowDag.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static AirflowDag appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AirflowDag)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static AirflowDag appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return AirflowDag.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static AirflowDag appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AirflowDag)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        AirflowDag.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        AirflowDag.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        AirflowDag.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AirflowDag(AirflowDagBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : AirflowDag.$default$typeName();
        this.airflowDagSchedule = b.airflowDagSchedule;
        this.airflowDagScheduleDelta = b.airflowDagScheduleDelta;
        this.airflowRunEndTime = b.airflowRunEndTime;
        this.airflowRunName = b.airflowRunName;
        this.airflowRunOpenLineageState = b.airflowRunOpenLineageState;
        this.airflowRunOpenLineageVersion = b.airflowRunOpenLineageVersion;
        this.airflowRunStartTime = b.airflowRunStartTime;
        this.airflowRunType = b.airflowRunType;
        this.airflowRunVersion = b.airflowRunVersion;
        SortedSet<String> airflowTags = new TreeSet<String>();
        if (b.airflowTags != null) {
            airflowTags.addAll(b.airflowTags);
        }
        airflowTags = Collections.unmodifiableSortedSet(airflowTags);
        this.airflowTags = airflowTags;
        SortedSet<IAirflowTask> airflowTasks = new TreeSet<IAirflowTask>();
        if (b.airflowTasks != null) {
            airflowTasks.addAll(b.airflowTasks);
        }
        airflowTasks = Collections.unmodifiableSortedSet(airflowTasks);
        this.airflowTasks = airflowTasks;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
    }

    @Generated
    public static AirflowDagBuilder<?, ?> _internal() {
        return new AirflowDagBuilderImpl();
    }

    @Generated
    public AirflowDagBuilder<?, ?> toBuilder() {
        return new AirflowDagBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getAirflowDagSchedule() {
        return this.airflowDagSchedule;
    }

    @Override
    @Generated
    public Long getAirflowDagScheduleDelta() {
        return this.airflowDagScheduleDelta;
    }

    @Override
    @Generated
    public Long getAirflowRunEndTime() {
        return this.airflowRunEndTime;
    }

    @Override
    @Generated
    public String getAirflowRunName() {
        return this.airflowRunName;
    }

    @Override
    @Generated
    public OpenLineageRunState getAirflowRunOpenLineageState() {
        return this.airflowRunOpenLineageState;
    }

    @Override
    @Generated
    public String getAirflowRunOpenLineageVersion() {
        return this.airflowRunOpenLineageVersion;
    }

    @Override
    @Generated
    public Long getAirflowRunStartTime() {
        return this.airflowRunStartTime;
    }

    @Override
    @Generated
    public String getAirflowRunType() {
        return this.airflowRunType;
    }

    @Override
    @Generated
    public String getAirflowRunVersion() {
        return this.airflowRunVersion;
    }

    @Override
    @Generated
    public SortedSet<String> getAirflowTags() {
        return this.airflowTags;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getAirflowTasks() {
        return this.airflowTasks;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AirflowDag)) {
            return false;
        }
        AirflowDag other = (AirflowDag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$airflowDagScheduleDelta = this.getAirflowDagScheduleDelta();
        Long other$airflowDagScheduleDelta = other.getAirflowDagScheduleDelta();
        if (this$airflowDagScheduleDelta == null ? other$airflowDagScheduleDelta != null : !((Object)this$airflowDagScheduleDelta).equals(other$airflowDagScheduleDelta)) {
            return false;
        }
        Long this$airflowRunEndTime = this.getAirflowRunEndTime();
        Long other$airflowRunEndTime = other.getAirflowRunEndTime();
        if (this$airflowRunEndTime == null ? other$airflowRunEndTime != null : !((Object)this$airflowRunEndTime).equals(other$airflowRunEndTime)) {
            return false;
        }
        Long this$airflowRunStartTime = this.getAirflowRunStartTime();
        Long other$airflowRunStartTime = other.getAirflowRunStartTime();
        if (this$airflowRunStartTime == null ? other$airflowRunStartTime != null : !((Object)this$airflowRunStartTime).equals(other$airflowRunStartTime)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$airflowDagSchedule = this.getAirflowDagSchedule();
        String other$airflowDagSchedule = other.getAirflowDagSchedule();
        if (this$airflowDagSchedule == null ? other$airflowDagSchedule != null : !this$airflowDagSchedule.equals(other$airflowDagSchedule)) {
            return false;
        }
        String this$airflowRunName = this.getAirflowRunName();
        String other$airflowRunName = other.getAirflowRunName();
        if (this$airflowRunName == null ? other$airflowRunName != null : !this$airflowRunName.equals(other$airflowRunName)) {
            return false;
        }
        OpenLineageRunState this$airflowRunOpenLineageState = this.getAirflowRunOpenLineageState();
        OpenLineageRunState other$airflowRunOpenLineageState = other.getAirflowRunOpenLineageState();
        if (this$airflowRunOpenLineageState == null ? other$airflowRunOpenLineageState != null : !this$airflowRunOpenLineageState.equals(other$airflowRunOpenLineageState)) {
            return false;
        }
        String this$airflowRunOpenLineageVersion = this.getAirflowRunOpenLineageVersion();
        String other$airflowRunOpenLineageVersion = other.getAirflowRunOpenLineageVersion();
        if (this$airflowRunOpenLineageVersion == null ? other$airflowRunOpenLineageVersion != null : !this$airflowRunOpenLineageVersion.equals(other$airflowRunOpenLineageVersion)) {
            return false;
        }
        String this$airflowRunType = this.getAirflowRunType();
        String other$airflowRunType = other.getAirflowRunType();
        if (this$airflowRunType == null ? other$airflowRunType != null : !this$airflowRunType.equals(other$airflowRunType)) {
            return false;
        }
        String this$airflowRunVersion = this.getAirflowRunVersion();
        String other$airflowRunVersion = other.getAirflowRunVersion();
        if (this$airflowRunVersion == null ? other$airflowRunVersion != null : !this$airflowRunVersion.equals(other$airflowRunVersion)) {
            return false;
        }
        SortedSet<String> this$airflowTags = this.getAirflowTags();
        SortedSet<String> other$airflowTags = other.getAirflowTags();
        if (this$airflowTags == null ? other$airflowTags != null : !this$airflowTags.equals(other$airflowTags)) {
            return false;
        }
        SortedSet<IAirflowTask> this$airflowTasks = this.getAirflowTasks();
        SortedSet<IAirflowTask> other$airflowTasks = other.getAirflowTasks();
        if (this$airflowTasks == null ? other$airflowTasks != null : !this$airflowTasks.equals(other$airflowTasks)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AirflowDag;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $airflowDagScheduleDelta = this.getAirflowDagScheduleDelta();
        result = result * 59 + ($airflowDagScheduleDelta == null ? 43 : ((Object)$airflowDagScheduleDelta).hashCode());
        Long $airflowRunEndTime = this.getAirflowRunEndTime();
        result = result * 59 + ($airflowRunEndTime == null ? 43 : ((Object)$airflowRunEndTime).hashCode());
        Long $airflowRunStartTime = this.getAirflowRunStartTime();
        result = result * 59 + ($airflowRunStartTime == null ? 43 : ((Object)$airflowRunStartTime).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $airflowDagSchedule = this.getAirflowDagSchedule();
        result = result * 59 + ($airflowDagSchedule == null ? 43 : $airflowDagSchedule.hashCode());
        String $airflowRunName = this.getAirflowRunName();
        result = result * 59 + ($airflowRunName == null ? 43 : $airflowRunName.hashCode());
        OpenLineageRunState $airflowRunOpenLineageState = this.getAirflowRunOpenLineageState();
        result = result * 59 + ($airflowRunOpenLineageState == null ? 43 : $airflowRunOpenLineageState.hashCode());
        String $airflowRunOpenLineageVersion = this.getAirflowRunOpenLineageVersion();
        result = result * 59 + ($airflowRunOpenLineageVersion == null ? 43 : $airflowRunOpenLineageVersion.hashCode());
        String $airflowRunType = this.getAirflowRunType();
        result = result * 59 + ($airflowRunType == null ? 43 : $airflowRunType.hashCode());
        String $airflowRunVersion = this.getAirflowRunVersion();
        result = result * 59 + ($airflowRunVersion == null ? 43 : $airflowRunVersion.hashCode());
        SortedSet<String> $airflowTags = this.getAirflowTags();
        result = result * 59 + ($airflowTags == null ? 43 : $airflowTags.hashCode());
        SortedSet<IAirflowTask> $airflowTasks = this.getAirflowTasks();
        result = result * 59 + ($airflowTasks == null ? 43 : $airflowTasks.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AirflowDag(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", airflowDagSchedule=" + this.getAirflowDagSchedule() + ", airflowDagScheduleDelta=" + this.getAirflowDagScheduleDelta() + ", airflowRunEndTime=" + this.getAirflowRunEndTime() + ", airflowRunName=" + this.getAirflowRunName() + ", airflowRunOpenLineageState=" + this.getAirflowRunOpenLineageState() + ", airflowRunOpenLineageVersion=" + this.getAirflowRunOpenLineageVersion() + ", airflowRunStartTime=" + this.getAirflowRunStartTime() + ", airflowRunType=" + this.getAirflowRunType() + ", airflowRunVersion=" + this.getAirflowRunVersion() + ", airflowTags=" + this.getAirflowTags() + ", airflowTasks=" + this.getAirflowTasks() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class AirflowDagBuilderImpl
    extends AirflowDagBuilder<AirflowDag, AirflowDagBuilderImpl> {
        @Generated
        private AirflowDagBuilderImpl() {
        }

        @Override
        @Generated
        protected AirflowDagBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AirflowDag build() {
            return new AirflowDag(this);
        }
    }

    @Generated
    public static abstract class AirflowDagBuilder<C extends AirflowDag, B extends AirflowDagBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String airflowDagSchedule;
        @Generated
        private Long airflowDagScheduleDelta;
        @Generated
        private Long airflowRunEndTime;
        @Generated
        private String airflowRunName;
        @Generated
        private OpenLineageRunState airflowRunOpenLineageState;
        @Generated
        private String airflowRunOpenLineageVersion;
        @Generated
        private Long airflowRunStartTime;
        @Generated
        private String airflowRunType;
        @Generated
        private String airflowRunVersion;
        @Generated
        private ArrayList<String> airflowTags;
        @Generated
        private ArrayList<IAirflowTask> airflowTasks;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AirflowDagBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AirflowDag instance, AirflowDagBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.airflowDagSchedule(instance.airflowDagSchedule);
            b.airflowDagScheduleDelta(instance.airflowDagScheduleDelta);
            b.airflowRunEndTime(instance.airflowRunEndTime);
            b.airflowRunName(instance.airflowRunName);
            b.airflowRunOpenLineageState(instance.airflowRunOpenLineageState);
            b.airflowRunOpenLineageVersion(instance.airflowRunOpenLineageVersion);
            b.airflowRunStartTime(instance.airflowRunStartTime);
            b.airflowRunType(instance.airflowRunType);
            b.airflowRunVersion(instance.airflowRunVersion);
            b.airflowTags(instance.airflowTags == null ? Collections.emptySortedSet() : instance.airflowTags);
            b.airflowTasks(instance.airflowTasks == null ? Collections.emptySortedSet() : instance.airflowTasks);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B airflowDagSchedule(String airflowDagSchedule) {
            this.airflowDagSchedule = airflowDagSchedule;
            return (B)this.self();
        }

        @Generated
        public B airflowDagScheduleDelta(Long airflowDagScheduleDelta) {
            this.airflowDagScheduleDelta = airflowDagScheduleDelta;
            return (B)this.self();
        }

        @Generated
        public B airflowRunEndTime(Long airflowRunEndTime) {
            this.airflowRunEndTime = airflowRunEndTime;
            return (B)this.self();
        }

        @Generated
        public B airflowRunName(String airflowRunName) {
            this.airflowRunName = airflowRunName;
            return (B)this.self();
        }

        @Generated
        public B airflowRunOpenLineageState(OpenLineageRunState airflowRunOpenLineageState) {
            this.airflowRunOpenLineageState = airflowRunOpenLineageState;
            return (B)this.self();
        }

        @Generated
        public B airflowRunOpenLineageVersion(String airflowRunOpenLineageVersion) {
            this.airflowRunOpenLineageVersion = airflowRunOpenLineageVersion;
            return (B)this.self();
        }

        @Generated
        public B airflowRunStartTime(Long airflowRunStartTime) {
            this.airflowRunStartTime = airflowRunStartTime;
            return (B)this.self();
        }

        @Generated
        public B airflowRunType(String airflowRunType) {
            this.airflowRunType = airflowRunType;
            return (B)this.self();
        }

        @Generated
        public B airflowRunVersion(String airflowRunVersion) {
            this.airflowRunVersion = airflowRunVersion;
            return (B)this.self();
        }

        @Generated
        public B airflowTag(String airflowTag) {
            if (this.airflowTags == null) {
                this.airflowTags = new ArrayList();
            }
            this.airflowTags.add(airflowTag);
            return (B)this.self();
        }

        @Generated
        public B airflowTags(Collection<? extends String> airflowTags) {
            if (airflowTags == null) {
                throw new NullPointerException("airflowTags cannot be null");
            }
            if (this.airflowTags == null) {
                this.airflowTags = new ArrayList();
            }
            this.airflowTags.addAll(airflowTags);
            return (B)this.self();
        }

        @Generated
        public B clearAirflowTags() {
            if (this.airflowTags != null) {
                this.airflowTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B airflowTask(IAirflowTask airflowTask) {
            if (this.airflowTasks == null) {
                this.airflowTasks = new ArrayList();
            }
            this.airflowTasks.add(airflowTask);
            return (B)this.self();
        }

        @Generated
        public B airflowTasks(Collection<? extends IAirflowTask> airflowTasks) {
            if (airflowTasks == null) {
                throw new NullPointerException("airflowTasks cannot be null");
            }
            if (this.airflowTasks == null) {
                this.airflowTasks = new ArrayList();
            }
            this.airflowTasks.addAll(airflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearAirflowTasks() {
            if (this.airflowTasks != null) {
                this.airflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "AirflowDag.AirflowDagBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", airflowDagSchedule=" + this.airflowDagSchedule + ", airflowDagScheduleDelta=" + this.airflowDagScheduleDelta + ", airflowRunEndTime=" + this.airflowRunEndTime + ", airflowRunName=" + this.airflowRunName + ", airflowRunOpenLineageState=" + this.airflowRunOpenLineageState + ", airflowRunOpenLineageVersion=" + this.airflowRunOpenLineageVersion + ", airflowRunStartTime=" + this.airflowRunStartTime + ", airflowRunType=" + this.airflowRunType + ", airflowRunVersion=" + this.airflowRunVersion + ", airflowTags=" + this.airflowTags + ", airflowTasks=" + this.airflowTasks + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ")";
        }
    }
}

