/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.ApiException;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IFile;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILink;
import com.atlan.model.assets.IMCIncident;
import com.atlan.model.assets.IMCMonitor;
import com.atlan.model.assets.IMetric;
import com.atlan.model.assets.IReadme;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISchemaRegistrySubject;
import com.atlan.model.assets.ISodaCheck;
import com.atlan.model.assets.IndistinctAsset;
import com.atlan.model.assets.Meaning;
import com.atlan.model.core.AssetDeletionResponse;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.AssetResponse;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.AtlanTag;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanDeleteType;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.SourceCostUnitType;
import com.atlan.model.relations.Reference;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.PopularityInsights;
import com.atlan.model.structs.StarredDetails;
import com.atlan.net.HttpClient;
import com.atlan.serde.AssetDeserializer;
import com.atlan.serde.AssetSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=AssetSerializer.class)
@JsonDeserialize(using=AssetDeserializer.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="typeName", defaultImpl=IndistinctAsset.class)
public abstract class Asset
extends Reference
implements IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Asset.class);
    private static final long serialVersionUID = 2L;
    @Attribute
    SortedSet<String> adminGroups;
    @Attribute
    SortedSet<String> adminRoles;
    @Attribute
    SortedSet<String> adminUsers;
    @Attribute
    String announcementMessage;
    @Attribute
    String announcementTitle;
    @Attribute
    AtlanAnnouncementType announcementType;
    @Attribute
    Long announcementUpdatedAt;
    @Attribute
    String announcementUpdatedBy;
    @Attribute
    String assetDbtAccountName;
    @Attribute
    String assetDbtAlias;
    @Attribute
    String assetDbtEnvironmentDbtVersion;
    @Attribute
    String assetDbtEnvironmentName;
    @Attribute
    Long assetDbtJobLastRun;
    @Attribute
    String assetDbtJobLastRunArtifactS3Path;
    @Attribute
    Boolean assetDbtJobLastRunArtifactsSaved;
    @Attribute
    Long assetDbtJobLastRunCreatedAt;
    @Attribute
    Long assetDbtJobLastRunDequedAt;
    @Attribute
    String assetDbtJobLastRunExecutedByThreadId;
    @Attribute
    String assetDbtJobLastRunGitBranch;
    @Attribute
    String assetDbtJobLastRunGitSha;
    @Attribute
    Boolean assetDbtJobLastRunHasDocsGenerated;
    @Attribute
    Boolean assetDbtJobLastRunHasSourcesGenerated;
    @Attribute
    Boolean assetDbtJobLastRunNotificationsSent;
    @Attribute
    String assetDbtJobLastRunOwnerThreadId;
    @Attribute
    String assetDbtJobLastRunQueuedDuration;
    @Attribute
    String assetDbtJobLastRunQueuedDurationHumanized;
    @Attribute
    String assetDbtJobLastRunRunDuration;
    @Attribute
    String assetDbtJobLastRunRunDurationHumanized;
    @Attribute
    Long assetDbtJobLastRunStartedAt;
    @Attribute
    String assetDbtJobLastRunStatusMessage;
    @Attribute
    String assetDbtJobLastRunTotalDuration;
    @Attribute
    String assetDbtJobLastRunTotalDurationHumanized;
    @Attribute
    Long assetDbtJobLastRunUpdatedAt;
    @Attribute
    String assetDbtJobLastRunUrl;
    @Attribute
    String assetDbtJobName;
    @Attribute
    Long assetDbtJobNextRun;
    @Attribute
    String assetDbtJobNextRunHumanized;
    @Attribute
    String assetDbtJobSchedule;
    @Attribute
    String assetDbtJobScheduleCronHumanized;
    @Attribute
    String assetDbtJobStatus;
    @Attribute
    String assetDbtMeta;
    @Attribute
    String assetDbtPackageName;
    @Attribute
    String assetDbtProjectName;
    @Attribute
    String assetDbtSemanticLayerProxyUrl;
    @Attribute
    String assetDbtSourceFreshnessCriteria;
    @Attribute
    SortedSet<String> assetDbtTags;
    @Attribute
    String assetDbtTestStatus;
    @Attribute
    String assetDbtUniqueId;
    @Attribute
    String assetIcon;
    @Attribute
    SortedSet<String> assetMcIncidentNames;
    @Attribute
    SortedSet<String> assetMcIncidentQualifiedNames;
    @Attribute
    SortedSet<String> assetMcIncidentSeverities;
    @Attribute
    SortedSet<String> assetMcIncidentStates;
    @Attribute
    SortedSet<String> assetMcIncidentSubTypes;
    @Attribute
    SortedSet<String> assetMcIncidentTypes;
    @Attribute
    Long assetMcLastSyncRunAt;
    @Attribute
    SortedSet<String> assetMcMonitorNames;
    @Attribute
    SortedSet<String> assetMcMonitorQualifiedNames;
    @Attribute
    SortedSet<String> assetMcMonitorScheduleTypes;
    @Attribute
    SortedSet<String> assetMcMonitorStatuses;
    @Attribute
    SortedSet<String> assetMcMonitorTypes;
    @Attribute
    Long assetSodaCheckCount;
    @Attribute
    String assetSodaCheckStatuses;
    @Attribute
    String assetSodaDQStatus;
    @Attribute
    Long assetSodaLastScanAt;
    @Attribute
    Long assetSodaLastSyncRunAt;
    @Attribute
    String assetSodaSourceURL;
    @Attribute
    SortedSet<String> assetTags;
    @Attribute
    @JsonProperty(value="meanings")
    SortedSet<IGlossaryTerm> assignedTerms;
    @Attribute
    CertificateStatus certificateStatus;
    @Attribute
    String certificateStatusMessage;
    @Attribute
    Long certificateUpdatedAt;
    @Attribute
    String certificateUpdatedBy;
    @Attribute
    String connectionName;
    @Attribute
    String connectionQualifiedName;
    @Attribute
    @JsonProperty(value="connectorName")
    AtlanConnectorType connectorType;
    @Attribute
    String dbtQualifiedName;
    @Attribute
    String description;
    @Attribute
    String displayName;
    @Attribute
    SortedSet<IFile> files;
    @Attribute
    @JsonProperty(value="__hasLineage")
    Boolean hasLineage;
    @Attribute
    Boolean isDiscoverable;
    @Attribute
    Boolean isEditable;
    @Attribute
    Long lastRowChangedAt;
    @Attribute
    String lastSyncRun;
    @Attribute
    Long lastSyncRunAt;
    @Attribute
    String lastSyncWorkflowName;
    @Attribute
    SortedSet<ILink> links;
    @Attribute
    SortedSet<IMCIncident> mcIncidents;
    @Attribute
    SortedSet<IMCMonitor> mcMonitors;
    @Attribute
    SortedSet<IMetric> metrics;
    @Attribute
    String name;
    @Attribute
    SortedSet<String> ownerGroups;
    @Attribute
    SortedSet<String> ownerUsers;
    @Attribute
    Double popularityScore;
    @Attribute
    String qualifiedName;
    @Attribute
    IReadme readme;
    @Attribute
    String sampleDataUrl;
    @Attribute
    SortedSet<ISchemaRegistrySubject> schemaRegistrySubjects;
    @Attribute
    SortedSet<ISodaCheck> sodaChecks;
    @Attribute
    SourceCostUnitType sourceCostUnit;
    @Attribute
    Long sourceCreatedAt;
    @Attribute
    String sourceCreatedBy;
    @Attribute
    String sourceEmbedURL;
    @Attribute
    Long sourceLastReadAt;
    @Attribute
    String sourceOwners;
    @Attribute
    @JsonProperty(value="sourceQueryComputeCostRecordList")
    List<PopularityInsights> sourceQueryComputeCostRecords;
    @Attribute
    @JsonProperty(value="sourceQueryComputeCostList")
    SortedSet<String> sourceQueryComputeCosts;
    @Attribute
    Long sourceReadCount;
    @Attribute
    @JsonProperty(value="sourceReadExpensiveQueryRecordList")
    List<PopularityInsights> sourceReadExpensiveQueryRecords;
    @Attribute
    @JsonProperty(value="sourceReadPopularQueryRecordList")
    List<PopularityInsights> sourceReadPopularQueryRecords;
    @Attribute
    Double sourceReadQueryCost;
    @Attribute
    @JsonProperty(value="sourceReadRecentUserRecordList")
    List<PopularityInsights> sourceReadRecentUserRecords;
    @Attribute
    @JsonProperty(value="sourceReadRecentUserList")
    SortedSet<String> sourceReadRecentUsers;
    @Attribute
    @JsonProperty(value="sourceReadSlowQueryRecordList")
    List<PopularityInsights> sourceReadSlowQueryRecords;
    @Attribute
    @JsonProperty(value="sourceReadTopUserRecordList")
    List<PopularityInsights> sourceReadTopUserRecords;
    @Attribute
    @JsonProperty(value="sourceReadTopUserList")
    SortedSet<String> sourceReadTopUsers;
    @Attribute
    Long sourceReadUserCount;
    @Attribute
    Double sourceTotalCost;
    @Attribute
    String sourceURL;
    @Attribute
    Long sourceUpdatedAt;
    @Attribute
    String sourceUpdatedBy;
    @Attribute
    SortedSet<String> starredBy;
    @Attribute
    Integer starredCount;
    @Attribute
    @JsonProperty(value="starredDetailsList")
    List<StarredDetails> starredDetails;
    @Attribute
    String subType;
    @Attribute
    String tenantId;
    @Attribute
    String userDescription;
    @Attribute
    Double viewScore;
    @Attribute
    SortedSet<String> viewerGroups;
    @Attribute
    SortedSet<String> viewerUsers;
    @JsonIgnore
    transient Set<String> nullFields;
    @JsonProperty(value="classifications")
    SortedSet<AtlanTag> atlanTags;
    Map<String, CustomMetadataAttributes> customMetadataSets;
    AtlanStatus status;
    final String createdBy;
    final String updatedBy;
    final Long createTime;
    final Long updateTime;
    final String deleteHandler;
    @Deprecated
    @JsonProperty(value="classificationNames")
    SortedSet<String> atlanTagNames;
    Boolean isIncomplete;
    SortedSet<String> meaningNames;
    @Deprecated
    SortedSet<Meaning> meanings;
    final SortedSet<String> pendingTasks;

    @JsonIgnore
    public Set<String> getNullFields() {
        if (this.nullFields == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.nullFields);
    }

    @JsonIgnore
    public Object getCustomMetadata(String setName, String attrName) {
        if (this.customMetadataSets == null) {
            return null;
        }
        if (!this.customMetadataSets.containsKey(setName)) {
            return null;
        }
        Map<String, Object> attrs = this.customMetadataSets.get(setName).getAttributes();
        if (!attrs.containsKey(attrName)) {
            return null;
        }
        return attrs.get(attrName);
    }

    public abstract AssetBuilder<?, ?> trimToRequired() throws InvalidRequestException;

    public abstract Asset trimToReference() throws InvalidRequestException;

    @Deprecated
    public AssetMutationResponse upsert() throws AtlanException {
        return this.save(Atlan.getDefaultClient());
    }

    public AssetMutationResponse save() throws AtlanException {
        return this.save(Atlan.getDefaultClient());
    }

    public AssetMutationResponse save(AtlanClient client) throws AtlanException {
        return client.assets.save(this, false);
    }

    @Deprecated
    public AssetMutationResponse upsert(boolean replaceAtlanTags) throws AtlanException {
        return this.save(Atlan.getDefaultClient(), replaceAtlanTags);
    }

    public AssetMutationResponse save(boolean replaceAtlanTags) throws AtlanException {
        return this.save(Atlan.getDefaultClient(), replaceAtlanTags);
    }

    public AssetMutationResponse save(AtlanClient client, boolean replaceAtlanTags) throws AtlanException {
        return client.assets.save(this, replaceAtlanTags);
    }

    @Deprecated
    public AssetMutationResponse upsertMergingCM(boolean replaceAtlanTags) throws AtlanException {
        return this.saveMergingCM(Atlan.getDefaultClient(), replaceAtlanTags);
    }

    public AssetMutationResponse saveMergingCM(boolean replaceAtlanTags) throws AtlanException {
        return this.saveMergingCM(Atlan.getDefaultClient(), replaceAtlanTags);
    }

    public AssetMutationResponse saveMergingCM(AtlanClient client, boolean replaceAtlanTags) throws AtlanException {
        return client.assets.saveMergingCM(List.of(this), replaceAtlanTags);
    }

    @Deprecated
    public AssetMutationResponse upsertReplacingCM(boolean replaceAtlanTags) throws AtlanException {
        return this.saveReplacingCM(Atlan.getDefaultClient(), replaceAtlanTags);
    }

    public AssetMutationResponse saveReplacingCM(boolean replaceAtlanTags) throws AtlanException {
        return this.saveReplacingCM(Atlan.getDefaultClient(), replaceAtlanTags);
    }

    public AssetMutationResponse saveReplacingCM(AtlanClient client, boolean replaceAtlanTags) throws AtlanException {
        return client.assets.saveReplacingCM(List.of(this), replaceAtlanTags);
    }

    public AssetMutationResponse updateMergingCM(boolean replaceAtlanTags) throws AtlanException {
        return this.updateMergingCM(Atlan.getDefaultClient(), replaceAtlanTags);
    }

    public AssetMutationResponse updateMergingCM(AtlanClient client, boolean replaceAtlanTags) throws AtlanException {
        Asset.get(client, this.getTypeName(), this.getQualifiedName(), false);
        return this.saveReplacingCM(client, replaceAtlanTags);
    }

    public AssetMutationResponse updateReplacingCM(boolean replaceAtlanTags) throws AtlanException {
        return this.updateReplacingCM(Atlan.getDefaultClient(), replaceAtlanTags);
    }

    public AssetMutationResponse updateReplacingCM(AtlanClient client, boolean replaceAtlanTags) throws AtlanException {
        Asset.get(client, this.getTypeName(), this.getQualifiedName(), false);
        return this.saveReplacingCM(client, replaceAtlanTags);
    }

    protected static AssetMutationResponse addApiTokenAsAdmin(String assetGuid, String impersonationToken) throws AtlanException {
        AtlanClient client = Atlan.getDefaultClient();
        String token = client.users.getCurrentUser().getUsername();
        String clientGuid = UUID.randomUUID().toString();
        AtlanClient tmp = Atlan.getClient(client.getBaseUrl(), clientGuid);
        tmp.setApiToken(impersonationToken);
        Optional<Asset> found = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)tmp.assets.select().where(GUID.eq(assetGuid))).includeOnResults(ADMIN_USERS)).pageSize(1)).stream().findFirst();
        AssetMutationResponse response = null;
        if (!found.isPresent()) {
            Atlan.removeClient(client.getBaseUrl(), clientGuid);
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, assetGuid);
        }
        Asset asset = found.get();
        SortedSet<String> existingAdmins = asset.getAdminUsers();
        response = ((Asset)((AssetBuilder)((AssetBuilder)asset.trimToRequired().adminUsers(existingAdmins)).adminUser(token)).build()).save(tmp);
        Atlan.removeClient(client.getBaseUrl(), clientGuid);
        return response;
    }

    @JsonIgnore
    public static Asset get(AtlanClient client, String guid, boolean includeRelationships) throws AtlanException {
        AssetResponse response = client.assets.get(guid, !includeRelationships, !includeRelationships);
        Asset asset = response.getAsset();
        if (asset != null && includeRelationships) {
            asset.setCompleteObject();
        }
        return asset;
    }

    @Deprecated
    public static Asset retrieveFull(String guid) throws AtlanException {
        return Asset.get(Atlan.getDefaultClient(), guid, true);
    }

    @Deprecated
    public static Asset retrieveFull(AtlanClient client, String guid) throws AtlanException {
        return Asset.get(client, guid, true);
    }

    @Deprecated
    public static Asset retrieveMinimal(String guid) throws AtlanException {
        return Asset.get(Atlan.getDefaultClient(), guid, false);
    }

    @Deprecated
    public static Asset retrieveMinimal(AtlanClient client, String guid) throws AtlanException {
        return Asset.get(client, guid, false);
    }

    @JsonIgnore
    public static Asset get(AtlanClient client, String typeName, String qualifiedName, boolean includeRelationships) throws AtlanException {
        AssetResponse response = client.assets.get(typeName, qualifiedName, !includeRelationships, !includeRelationships);
        Asset asset = response.getAsset();
        if (asset != null && includeRelationships) {
            asset.setCompleteObject();
        }
        return asset;
    }

    @Deprecated
    protected static Asset retrieveFull(AtlanClient client, String typeName, String qualifiedName) throws AtlanException {
        return Asset.get(client, typeName, qualifiedName, true);
    }

    @Deprecated
    public static Asset retrieveMinimal(String typeName, String qualifiedName) throws AtlanException {
        return Asset.get(Atlan.getDefaultClient(), typeName, qualifiedName, false);
    }

    @Deprecated
    public static Asset retrieveMinimal(AtlanClient client, String typeName, String qualifiedName) throws AtlanException {
        return Asset.get(client, typeName, qualifiedName, false);
    }

    public static AssetDeletionResponse delete(String guid) throws AtlanException {
        return Asset.delete(Atlan.getDefaultClient(), guid);
    }

    public static AssetDeletionResponse delete(AtlanClient client, String guid) throws AtlanException {
        return client.assets.delete(guid, AtlanDeleteType.SOFT);
    }

    public static AssetDeletionResponse purge(String guid) throws AtlanException {
        return Asset.purge(Atlan.getDefaultClient(), guid);
    }

    public static AssetDeletionResponse purge(AtlanClient client, String guid) throws AtlanException {
        return client.assets.delete(guid, AtlanDeleteType.PURGE);
    }

    public static void updateCustomMetadataAttributes(String guid, String cmName, CustomMetadataAttributes attributes) throws AtlanException {
        Asset.updateCustomMetadataAttributes(Atlan.getDefaultClient(), guid, cmName, attributes);
    }

    public static void updateCustomMetadataAttributes(AtlanClient client, String guid, String cmName, CustomMetadataAttributes attributes) throws AtlanException {
        client.assets.updateCustomMetadataAttributes(guid, cmName, attributes);
    }

    public static void replaceCustomMetadata(String guid, String cmName, CustomMetadataAttributes attributes) throws AtlanException {
        Asset.replaceCustomMetadata(Atlan.getDefaultClient(), guid, cmName, attributes);
    }

    public static void replaceCustomMetadata(AtlanClient client, String guid, String cmName, CustomMetadataAttributes attributes) throws AtlanException {
        client.assets.replaceCustomMetadata(guid, cmName, attributes);
    }

    public static void removeCustomMetadata(String guid, String cmName) throws AtlanException {
        Asset.removeCustomMetadata(Atlan.getDefaultClient(), guid, cmName);
    }

    public static void removeCustomMetadata(AtlanClient client, String guid, String cmName) throws AtlanException {
        client.assets.removeCustomMetadata(guid, cmName);
    }

    protected static Asset appendAtlanTags(AtlanClient client, String typeName, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return Asset.appendAtlanTags(client, typeName, qualifiedName, atlanTagNames, true, true, false);
    }

    protected static Asset appendAtlanTags(AtlanClient client, String typeName, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset existing = Asset.retrieveFull(client, typeName, qualifiedName);
        if (atlanTagNames == null) {
            return existing;
        }
        if (existing != null) {
            TreeSet<AtlanObject> replacementAtlanTags = new TreeSet<AtlanObject>();
            SortedSet<AtlanTag> existingAtlanTags = existing.getAtlanTags();
            if (existingAtlanTags != null) {
                for (AtlanTag atlanTag : existingAtlanTags) {
                    if (!existing.getGuid().equals(atlanTag.getEntityGuid()) || atlanTagNames.contains(atlanTag.getTypeName())) continue;
                    replacementAtlanTags.add(atlanTag);
                }
            }
            for (String atlanTagName : atlanTagNames) {
                replacementAtlanTags.add(((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)AtlanTag.builder().typeName(atlanTagName)).propagate(propagate)).removePropagationsOnEntityDelete(removePropagationsOnDelete)).restrictPropagationThroughLineage(restrictLineagePropagation)).build());
            }
            AssetBuilder<?, ?> minimal = existing.trimToRequired();
            return Asset.replaceAtlanTags(client, (Asset)((AssetBuilder)minimal.atlanTags(replacementAtlanTags)).build());
        }
        return null;
    }

    @Deprecated
    protected static void addAtlanTags(AtlanClient client, String typeName, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        client.assets.addAtlanTags(typeName, qualifiedName, atlanTagNames);
    }

    @Deprecated
    protected static void addAtlanTags(AtlanClient client, String typeName, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        client.assets.addAtlanTags(typeName, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    protected static void removeAtlanTag(AtlanClient client, String typeName, String qualifiedName, String atlanTagName) throws AtlanException {
        client.assets.removeAtlanTag(typeName, qualifiedName, atlanTagName, true);
    }

    protected static Asset updateCertificate(AtlanClient client, AssetBuilder<?, ?> builder, CertificateStatus certificate, String message) throws AtlanException {
        builder.certificateStatus(certificate);
        if (message != null && message.length() > 1) {
            builder.certificateStatusMessage(message);
        }
        return Asset.updateAttributes(client, (Asset)builder.build());
    }

    protected static Asset removeCertificate(AtlanClient client, AssetBuilder<?, ?> builder) throws AtlanException {
        Reference asset = ((AssetBuilder)builder.removeCertificate()).build();
        AssetMutationResponse response = ((Asset)asset).save(client);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        }
        return null;
    }

    protected static Asset updateAnnouncement(AtlanClient client, AssetBuilder<?, ?> builder, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        builder.announcementType(type);
        if (title != null && title.length() > 1) {
            builder.announcementTitle(title);
        }
        if (message != null && message.length() > 1) {
            builder.announcementMessage(message);
        }
        return Asset.updateAttributes(client, (Asset)builder.build());
    }

    protected static Asset removeAnnouncement(AtlanClient client, AssetBuilder<?, ?> builder) throws AtlanException {
        Reference asset = ((AssetBuilder)builder.removeAnnouncement()).build();
        AssetMutationResponse response = ((Asset)asset).save(client);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        }
        return null;
    }

    protected static Asset removeDescription(AtlanClient client, AssetBuilder<?, ?> builder) throws AtlanException {
        Reference asset = ((AssetBuilder)builder.removeDescription()).build();
        AssetMutationResponse response = ((Asset)asset).save(client);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        }
        return null;
    }

    protected static Asset removeUserDescription(AtlanClient client, AssetBuilder<?, ?> builder) throws AtlanException {
        Reference asset = ((AssetBuilder)builder.removeUserDescription()).build();
        AssetMutationResponse response = ((Asset)asset).save(client);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        }
        return null;
    }

    protected static Asset removeOwners(AtlanClient client, AssetBuilder<?, ?> builder) throws AtlanException {
        Reference asset = ((AssetBuilder)builder.removeOwners()).build();
        AssetMutationResponse response = ((Asset)asset).save(client);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        }
        return null;
    }

    private static Asset updateAttributes(AtlanClient client, Asset asset) throws AtlanException {
        AssetMutationResponse response = client.assets.save(asset, false);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        }
        return null;
    }

    private static Asset replaceAtlanTags(AtlanClient client, Asset asset) throws AtlanException {
        AssetMutationResponse response = client.assets.save(asset, true);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        }
        return null;
    }

    protected static Asset updateCertificate(AtlanClient client, AssetBuilder<?, ?> builder, String typeName, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        ((AssetBuilder)builder.qualifiedName(qualifiedName)).certificateStatus(certificate);
        if (message != null && message.length() > 1) {
            builder.certificateStatusMessage(message);
        }
        return Asset.updateAttributes(client, typeName, qualifiedName, (Asset)builder.build());
    }

    protected static Asset updateAnnouncement(AtlanClient client, AssetBuilder<?, ?> builder, String typeName, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        ((AssetBuilder)builder.qualifiedName(qualifiedName)).announcementType(type);
        if (title != null && title.length() > 1) {
            builder.announcementTitle(title);
        }
        if (message != null && message.length() > 1) {
            builder.announcementMessage(message);
        }
        return Asset.updateAttributes(client, typeName, qualifiedName, (Asset)builder.build());
    }

    private static Asset updateAttributes(AtlanClient client, String typeName, String qualifiedName, Asset asset) throws AtlanException {
        AssetMutationResponse response = client.assets.updateAttributes(typeName, qualifiedName, asset);
        if (response != null && !response.getPartiallyUpdatedAssets().isEmpty()) {
            return response.getPartiallyUpdatedAssets().get(0);
        }
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        }
        return null;
    }

    protected static boolean restore(AtlanClient client, String typeName, String qualifiedName) throws AtlanException {
        try {
            return Asset.restore(client, typeName, qualifiedName, 0);
        }
        catch (InterruptedException e) {
            throw new ApiException(ErrorCode.RETRIES_INTERRUPTED, (Throwable)e, new String[0]);
        }
    }

    private static boolean restore(AtlanClient client, String typeName, String qualifiedName, int retryCount) throws AtlanException, InterruptedException {
        Asset existing = Asset.retrieveFull(client, typeName, qualifiedName);
        if (existing == null) {
            return false;
        }
        if (existing.getStatus() == AtlanStatus.ACTIVE) {
            if (retryCount < Atlan.getMaxNetworkRetries()) {
                log.debug("Attempted to restore an active asset, retrying status check for async delete handling (attempt: {}).", (Object)(retryCount + 1));
                Thread.sleep(HttpClient.waitTime(retryCount).toMillis());
                return Asset.restore(client, typeName, qualifiedName, retryCount + 1);
            }
            return true;
        }
        Optional<String> guidRestored = Asset.restore(client, existing);
        return guidRestored.isPresent() && guidRestored.get().equals(existing.getGuid());
    }

    protected static Asset replaceTerms(AtlanClient client, AssetBuilder<?, ?> builder, List<IGlossaryTerm> terms) throws AtlanException {
        if (terms == null || terms.isEmpty()) {
            Reference asset = ((AssetBuilder)builder.removeAssignedTerms()).build();
            return Asset.updateRelationships(client, (Asset)asset);
        }
        return Asset.updateRelationships(client, (Asset)((AssetBuilder)builder.assignedTerms(Asset.getTermRefs(terms))).build());
    }

    protected static Asset appendTerms(AtlanClient client, String typeName, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        Asset existing = Asset.retrieveFull(client, typeName, qualifiedName);
        if (terms == null) {
            return existing;
        }
        if (existing != null) {
            TreeSet<IGlossaryTerm> replacementTerms = new TreeSet<IGlossaryTerm>();
            SortedSet<IGlossaryTerm> existingTerms = existing.getAssignedTerms();
            if (existingTerms != null) {
                for (IGlossaryTerm term : existingTerms) {
                    if (term.getRelationshipStatus() == AtlanStatus.DELETED) continue;
                    replacementTerms.add(term);
                }
            }
            replacementTerms.addAll(terms);
            AssetBuilder<?, ?> minimal = existing.trimToRequired();
            return Asset.updateRelationships(client, (Asset)((AssetBuilder)minimal.assignedTerms(Asset.getTermRefs(replacementTerms))).build());
        }
        return null;
    }

    protected static Asset removeTerms(AtlanClient client, String typeName, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        Asset existing = Asset.retrieveFull(client, typeName, qualifiedName);
        if (existing != null) {
            TreeSet<IGlossaryTerm> replacementTerms = new TreeSet<IGlossaryTerm>();
            SortedSet<IGlossaryTerm> existingTerms = existing.getAssignedTerms();
            HashSet<String> removeGuids = new HashSet<String>();
            for (IGlossaryTerm term : terms) {
                if (term.isValidReferenceByGuid()) {
                    removeGuids.add(term.getGuid());
                    continue;
                }
                throw new InvalidRequestException(ErrorCode.MISSING_TERM_GUID);
            }
            for (IGlossaryTerm term : existingTerms) {
                String existingTermGuid = term.getGuid();
                if (removeGuids.contains(existingTermGuid) || term.getRelationshipStatus() == AtlanStatus.DELETED) continue;
                replacementTerms.add(term);
            }
            AssetBuilder<?, ?> minimal = existing.trimToRequired();
            Reference update = replacementTerms.isEmpty() ? ((AssetBuilder)minimal.removeAssignedTerms()).build() : ((AssetBuilder)minimal.assignedTerms(Asset.getTermRefs(replacementTerms))).build();
            return Asset.updateRelationships(client, (Asset)update);
        }
        return null;
    }

    private static Collection<IGlossaryTerm> getTermRefs(Collection<IGlossaryTerm> terms) {
        if (terms != null && !terms.isEmpty()) {
            TreeSet<IGlossaryTerm> termRefs = new TreeSet<IGlossaryTerm>();
            for (IGlossaryTerm term : terms) {
                if (term.getGuid() != null) {
                    termRefs.add(GlossaryTerm.refByGuid(term.getGuid()));
                    continue;
                }
                if (term.getQualifiedName() == null) continue;
                termRefs.add(GlossaryTerm.refByQualifiedName(term.getQualifiedName()));
            }
            return termRefs;
        }
        return Collections.emptySet();
    }

    private static Asset updateRelationships(AtlanClient client, Asset asset) throws AtlanException {
        String typeNameToUpdate = asset.getTypeName();
        AssetMutationResponse response = client.assets.save(asset, false);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            for (Asset result : response.getUpdatedAssets()) {
                String foundQN;
                if (!result.getTypeName().equals(typeNameToUpdate) || (foundQN = result.getQualifiedName()) == null || !foundQN.equals(asset.getQualifiedName())) continue;
                return result;
            }
        }
        return null;
    }

    private static Optional<String> restore(AtlanClient client, Asset asset) throws AtlanException {
        AssetMutationResponse response = client.assets.restore(asset);
        if (response != null && !response.getGuidAssignments().isEmpty()) {
            return response.getGuidAssignments().values().stream().findFirst();
        }
        return Optional.empty();
    }

    @Generated
    protected Asset(AssetBuilder<?, ?> b) {
        super((Reference.ReferenceBuilder<?, ?>)b);
        Map<Object, Object> customMetadataSets;
        Set<Object> nullFields;
        List<Object> starredDetails;
        List<Object> sourceReadTopUserRecords;
        List<Object> sourceReadSlowQueryRecords;
        List<Object> sourceReadRecentUserRecords;
        List<Object> sourceReadPopularQueryRecords;
        List<Object> sourceReadExpensiveQueryRecords;
        List<Object> sourceQueryComputeCostRecords;
        SortedSet<String> adminGroups = new TreeSet<String>();
        if (b.adminGroups != null) {
            adminGroups.addAll(b.adminGroups);
        }
        adminGroups = Collections.unmodifiableSortedSet(adminGroups);
        this.adminGroups = adminGroups;
        SortedSet<String> adminRoles = new TreeSet<String>();
        if (b.adminRoles != null) {
            adminRoles.addAll(b.adminRoles);
        }
        adminRoles = Collections.unmodifiableSortedSet(adminRoles);
        this.adminRoles = adminRoles;
        SortedSet<String> adminUsers = new TreeSet<String>();
        if (b.adminUsers != null) {
            adminUsers.addAll(b.adminUsers);
        }
        adminUsers = Collections.unmodifiableSortedSet(adminUsers);
        this.adminUsers = adminUsers;
        this.announcementMessage = b.announcementMessage;
        this.announcementTitle = b.announcementTitle;
        this.announcementType = b.announcementType;
        this.announcementUpdatedAt = b.announcementUpdatedAt;
        this.announcementUpdatedBy = b.announcementUpdatedBy;
        this.assetDbtAccountName = b.assetDbtAccountName;
        this.assetDbtAlias = b.assetDbtAlias;
        this.assetDbtEnvironmentDbtVersion = b.assetDbtEnvironmentDbtVersion;
        this.assetDbtEnvironmentName = b.assetDbtEnvironmentName;
        this.assetDbtJobLastRun = b.assetDbtJobLastRun;
        this.assetDbtJobLastRunArtifactS3Path = b.assetDbtJobLastRunArtifactS3Path;
        this.assetDbtJobLastRunArtifactsSaved = b.assetDbtJobLastRunArtifactsSaved;
        this.assetDbtJobLastRunCreatedAt = b.assetDbtJobLastRunCreatedAt;
        this.assetDbtJobLastRunDequedAt = b.assetDbtJobLastRunDequedAt;
        this.assetDbtJobLastRunExecutedByThreadId = b.assetDbtJobLastRunExecutedByThreadId;
        this.assetDbtJobLastRunGitBranch = b.assetDbtJobLastRunGitBranch;
        this.assetDbtJobLastRunGitSha = b.assetDbtJobLastRunGitSha;
        this.assetDbtJobLastRunHasDocsGenerated = b.assetDbtJobLastRunHasDocsGenerated;
        this.assetDbtJobLastRunHasSourcesGenerated = b.assetDbtJobLastRunHasSourcesGenerated;
        this.assetDbtJobLastRunNotificationsSent = b.assetDbtJobLastRunNotificationsSent;
        this.assetDbtJobLastRunOwnerThreadId = b.assetDbtJobLastRunOwnerThreadId;
        this.assetDbtJobLastRunQueuedDuration = b.assetDbtJobLastRunQueuedDuration;
        this.assetDbtJobLastRunQueuedDurationHumanized = b.assetDbtJobLastRunQueuedDurationHumanized;
        this.assetDbtJobLastRunRunDuration = b.assetDbtJobLastRunRunDuration;
        this.assetDbtJobLastRunRunDurationHumanized = b.assetDbtJobLastRunRunDurationHumanized;
        this.assetDbtJobLastRunStartedAt = b.assetDbtJobLastRunStartedAt;
        this.assetDbtJobLastRunStatusMessage = b.assetDbtJobLastRunStatusMessage;
        this.assetDbtJobLastRunTotalDuration = b.assetDbtJobLastRunTotalDuration;
        this.assetDbtJobLastRunTotalDurationHumanized = b.assetDbtJobLastRunTotalDurationHumanized;
        this.assetDbtJobLastRunUpdatedAt = b.assetDbtJobLastRunUpdatedAt;
        this.assetDbtJobLastRunUrl = b.assetDbtJobLastRunUrl;
        this.assetDbtJobName = b.assetDbtJobName;
        this.assetDbtJobNextRun = b.assetDbtJobNextRun;
        this.assetDbtJobNextRunHumanized = b.assetDbtJobNextRunHumanized;
        this.assetDbtJobSchedule = b.assetDbtJobSchedule;
        this.assetDbtJobScheduleCronHumanized = b.assetDbtJobScheduleCronHumanized;
        this.assetDbtJobStatus = b.assetDbtJobStatus;
        this.assetDbtMeta = b.assetDbtMeta;
        this.assetDbtPackageName = b.assetDbtPackageName;
        this.assetDbtProjectName = b.assetDbtProjectName;
        this.assetDbtSemanticLayerProxyUrl = b.assetDbtSemanticLayerProxyUrl;
        this.assetDbtSourceFreshnessCriteria = b.assetDbtSourceFreshnessCriteria;
        SortedSet<String> assetDbtTags = new TreeSet<String>();
        if (b.assetDbtTags != null) {
            assetDbtTags.addAll(b.assetDbtTags);
        }
        assetDbtTags = Collections.unmodifiableSortedSet(assetDbtTags);
        this.assetDbtTags = assetDbtTags;
        this.assetDbtTestStatus = b.assetDbtTestStatus;
        this.assetDbtUniqueId = b.assetDbtUniqueId;
        this.assetIcon = b.assetIcon;
        SortedSet<String> assetMcIncidentNames = new TreeSet<String>();
        if (b.assetMcIncidentNames != null) {
            assetMcIncidentNames.addAll(b.assetMcIncidentNames);
        }
        assetMcIncidentNames = Collections.unmodifiableSortedSet(assetMcIncidentNames);
        this.assetMcIncidentNames = assetMcIncidentNames;
        SortedSet<String> assetMcIncidentQualifiedNames = new TreeSet<String>();
        if (b.assetMcIncidentQualifiedNames != null) {
            assetMcIncidentQualifiedNames.addAll(b.assetMcIncidentQualifiedNames);
        }
        assetMcIncidentQualifiedNames = Collections.unmodifiableSortedSet(assetMcIncidentQualifiedNames);
        this.assetMcIncidentQualifiedNames = assetMcIncidentQualifiedNames;
        SortedSet<String> assetMcIncidentSeverities = new TreeSet<String>();
        if (b.assetMcIncidentSeverities != null) {
            assetMcIncidentSeverities.addAll(b.assetMcIncidentSeverities);
        }
        assetMcIncidentSeverities = Collections.unmodifiableSortedSet(assetMcIncidentSeverities);
        this.assetMcIncidentSeverities = assetMcIncidentSeverities;
        SortedSet<String> assetMcIncidentStates = new TreeSet<String>();
        if (b.assetMcIncidentStates != null) {
            assetMcIncidentStates.addAll(b.assetMcIncidentStates);
        }
        assetMcIncidentStates = Collections.unmodifiableSortedSet(assetMcIncidentStates);
        this.assetMcIncidentStates = assetMcIncidentStates;
        SortedSet<String> assetMcIncidentSubTypes = new TreeSet<String>();
        if (b.assetMcIncidentSubTypes != null) {
            assetMcIncidentSubTypes.addAll(b.assetMcIncidentSubTypes);
        }
        assetMcIncidentSubTypes = Collections.unmodifiableSortedSet(assetMcIncidentSubTypes);
        this.assetMcIncidentSubTypes = assetMcIncidentSubTypes;
        SortedSet<String> assetMcIncidentTypes = new TreeSet<String>();
        if (b.assetMcIncidentTypes != null) {
            assetMcIncidentTypes.addAll(b.assetMcIncidentTypes);
        }
        assetMcIncidentTypes = Collections.unmodifiableSortedSet(assetMcIncidentTypes);
        this.assetMcIncidentTypes = assetMcIncidentTypes;
        this.assetMcLastSyncRunAt = b.assetMcLastSyncRunAt;
        SortedSet<String> assetMcMonitorNames = new TreeSet<String>();
        if (b.assetMcMonitorNames != null) {
            assetMcMonitorNames.addAll(b.assetMcMonitorNames);
        }
        assetMcMonitorNames = Collections.unmodifiableSortedSet(assetMcMonitorNames);
        this.assetMcMonitorNames = assetMcMonitorNames;
        SortedSet<String> assetMcMonitorQualifiedNames = new TreeSet<String>();
        if (b.assetMcMonitorQualifiedNames != null) {
            assetMcMonitorQualifiedNames.addAll(b.assetMcMonitorQualifiedNames);
        }
        assetMcMonitorQualifiedNames = Collections.unmodifiableSortedSet(assetMcMonitorQualifiedNames);
        this.assetMcMonitorQualifiedNames = assetMcMonitorQualifiedNames;
        SortedSet<String> assetMcMonitorScheduleTypes = new TreeSet<String>();
        if (b.assetMcMonitorScheduleTypes != null) {
            assetMcMonitorScheduleTypes.addAll(b.assetMcMonitorScheduleTypes);
        }
        assetMcMonitorScheduleTypes = Collections.unmodifiableSortedSet(assetMcMonitorScheduleTypes);
        this.assetMcMonitorScheduleTypes = assetMcMonitorScheduleTypes;
        SortedSet<String> assetMcMonitorStatuses = new TreeSet<String>();
        if (b.assetMcMonitorStatuses != null) {
            assetMcMonitorStatuses.addAll(b.assetMcMonitorStatuses);
        }
        assetMcMonitorStatuses = Collections.unmodifiableSortedSet(assetMcMonitorStatuses);
        this.assetMcMonitorStatuses = assetMcMonitorStatuses;
        SortedSet<String> assetMcMonitorTypes = new TreeSet<String>();
        if (b.assetMcMonitorTypes != null) {
            assetMcMonitorTypes.addAll(b.assetMcMonitorTypes);
        }
        assetMcMonitorTypes = Collections.unmodifiableSortedSet(assetMcMonitorTypes);
        this.assetMcMonitorTypes = assetMcMonitorTypes;
        this.assetSodaCheckCount = b.assetSodaCheckCount;
        this.assetSodaCheckStatuses = b.assetSodaCheckStatuses;
        this.assetSodaDQStatus = b.assetSodaDQStatus;
        this.assetSodaLastScanAt = b.assetSodaLastScanAt;
        this.assetSodaLastSyncRunAt = b.assetSodaLastSyncRunAt;
        this.assetSodaSourceURL = b.assetSodaSourceURL;
        SortedSet<String> assetTags = new TreeSet<String>();
        if (b.assetTags != null) {
            assetTags.addAll(b.assetTags);
        }
        assetTags = Collections.unmodifiableSortedSet(assetTags);
        this.assetTags = assetTags;
        SortedSet<IGlossaryTerm> assignedTerms = new TreeSet<IGlossaryTerm>();
        if (b.assignedTerms != null) {
            assignedTerms.addAll(b.assignedTerms);
        }
        assignedTerms = Collections.unmodifiableSortedSet(assignedTerms);
        this.assignedTerms = assignedTerms;
        this.certificateStatus = b.certificateStatus;
        this.certificateStatusMessage = b.certificateStatusMessage;
        this.certificateUpdatedAt = b.certificateUpdatedAt;
        this.certificateUpdatedBy = b.certificateUpdatedBy;
        this.connectionName = b.connectionName;
        this.connectionQualifiedName = b.connectionQualifiedName;
        this.connectorType = b.connectorType;
        this.dbtQualifiedName = b.dbtQualifiedName;
        this.description = b.description;
        this.displayName = b.displayName;
        SortedSet<IFile> files = new TreeSet<IFile>();
        if (b.files != null) {
            files.addAll(b.files);
        }
        files = Collections.unmodifiableSortedSet(files);
        this.files = files;
        this.hasLineage = b.hasLineage;
        this.isDiscoverable = b.isDiscoverable;
        this.isEditable = b.isEditable;
        this.lastRowChangedAt = b.lastRowChangedAt;
        this.lastSyncRun = b.lastSyncRun;
        this.lastSyncRunAt = b.lastSyncRunAt;
        this.lastSyncWorkflowName = b.lastSyncWorkflowName;
        SortedSet<ILink> links = new TreeSet<ILink>();
        if (b.links != null) {
            links.addAll(b.links);
        }
        links = Collections.unmodifiableSortedSet(links);
        this.links = links;
        SortedSet<IMCIncident> mcIncidents = new TreeSet<IMCIncident>();
        if (b.mcIncidents != null) {
            mcIncidents.addAll(b.mcIncidents);
        }
        mcIncidents = Collections.unmodifiableSortedSet(mcIncidents);
        this.mcIncidents = mcIncidents;
        SortedSet<IMCMonitor> mcMonitors = new TreeSet<IMCMonitor>();
        if (b.mcMonitors != null) {
            mcMonitors.addAll(b.mcMonitors);
        }
        mcMonitors = Collections.unmodifiableSortedSet(mcMonitors);
        this.mcMonitors = mcMonitors;
        SortedSet<IMetric> metrics = new TreeSet<IMetric>();
        if (b.metrics != null) {
            metrics.addAll(b.metrics);
        }
        metrics = Collections.unmodifiableSortedSet(metrics);
        this.metrics = metrics;
        this.name = b.name;
        SortedSet<String> ownerGroups = new TreeSet<String>();
        if (b.ownerGroups != null) {
            ownerGroups.addAll(b.ownerGroups);
        }
        ownerGroups = Collections.unmodifiableSortedSet(ownerGroups);
        this.ownerGroups = ownerGroups;
        SortedSet<String> ownerUsers = new TreeSet<String>();
        if (b.ownerUsers != null) {
            ownerUsers.addAll(b.ownerUsers);
        }
        ownerUsers = Collections.unmodifiableSortedSet(ownerUsers);
        this.ownerUsers = ownerUsers;
        this.popularityScore = b.popularityScore;
        this.qualifiedName = b.qualifiedName;
        this.readme = b.readme;
        this.sampleDataUrl = b.sampleDataUrl;
        SortedSet<ISchemaRegistrySubject> schemaRegistrySubjects = new TreeSet<ISchemaRegistrySubject>();
        if (b.schemaRegistrySubjects != null) {
            schemaRegistrySubjects.addAll(b.schemaRegistrySubjects);
        }
        schemaRegistrySubjects = Collections.unmodifiableSortedSet(schemaRegistrySubjects);
        this.schemaRegistrySubjects = schemaRegistrySubjects;
        SortedSet<ISodaCheck> sodaChecks = new TreeSet<ISodaCheck>();
        if (b.sodaChecks != null) {
            sodaChecks.addAll(b.sodaChecks);
        }
        sodaChecks = Collections.unmodifiableSortedSet(sodaChecks);
        this.sodaChecks = sodaChecks;
        this.sourceCostUnit = b.sourceCostUnit;
        this.sourceCreatedAt = b.sourceCreatedAt;
        this.sourceCreatedBy = b.sourceCreatedBy;
        this.sourceEmbedURL = b.sourceEmbedURL;
        this.sourceLastReadAt = b.sourceLastReadAt;
        this.sourceOwners = b.sourceOwners;
        switch (b.sourceQueryComputeCostRecords == null ? 0 : b.sourceQueryComputeCostRecords.size()) {
            case 0: {
                sourceQueryComputeCostRecords = Collections.emptyList();
                break;
            }
            case 1: {
                sourceQueryComputeCostRecords = Collections.singletonList(b.sourceQueryComputeCostRecords.get(0));
                break;
            }
            default: {
                sourceQueryComputeCostRecords = Collections.unmodifiableList(new ArrayList<PopularityInsights>(b.sourceQueryComputeCostRecords));
            }
        }
        this.sourceQueryComputeCostRecords = sourceQueryComputeCostRecords;
        SortedSet<String> sourceQueryComputeCosts = new TreeSet<String>();
        if (b.sourceQueryComputeCosts != null) {
            sourceQueryComputeCosts.addAll(b.sourceQueryComputeCosts);
        }
        sourceQueryComputeCosts = Collections.unmodifiableSortedSet(sourceQueryComputeCosts);
        this.sourceQueryComputeCosts = sourceQueryComputeCosts;
        this.sourceReadCount = b.sourceReadCount;
        switch (b.sourceReadExpensiveQueryRecords == null ? 0 : b.sourceReadExpensiveQueryRecords.size()) {
            case 0: {
                sourceReadExpensiveQueryRecords = Collections.emptyList();
                break;
            }
            case 1: {
                sourceReadExpensiveQueryRecords = Collections.singletonList(b.sourceReadExpensiveQueryRecords.get(0));
                break;
            }
            default: {
                sourceReadExpensiveQueryRecords = Collections.unmodifiableList(new ArrayList<PopularityInsights>(b.sourceReadExpensiveQueryRecords));
            }
        }
        this.sourceReadExpensiveQueryRecords = sourceReadExpensiveQueryRecords;
        switch (b.sourceReadPopularQueryRecords == null ? 0 : b.sourceReadPopularQueryRecords.size()) {
            case 0: {
                sourceReadPopularQueryRecords = Collections.emptyList();
                break;
            }
            case 1: {
                sourceReadPopularQueryRecords = Collections.singletonList(b.sourceReadPopularQueryRecords.get(0));
                break;
            }
            default: {
                sourceReadPopularQueryRecords = Collections.unmodifiableList(new ArrayList<PopularityInsights>(b.sourceReadPopularQueryRecords));
            }
        }
        this.sourceReadPopularQueryRecords = sourceReadPopularQueryRecords;
        this.sourceReadQueryCost = b.sourceReadQueryCost;
        switch (b.sourceReadRecentUserRecords == null ? 0 : b.sourceReadRecentUserRecords.size()) {
            case 0: {
                sourceReadRecentUserRecords = Collections.emptyList();
                break;
            }
            case 1: {
                sourceReadRecentUserRecords = Collections.singletonList(b.sourceReadRecentUserRecords.get(0));
                break;
            }
            default: {
                sourceReadRecentUserRecords = Collections.unmodifiableList(new ArrayList<PopularityInsights>(b.sourceReadRecentUserRecords));
            }
        }
        this.sourceReadRecentUserRecords = sourceReadRecentUserRecords;
        SortedSet<String> sourceReadRecentUsers = new TreeSet<String>();
        if (b.sourceReadRecentUsers != null) {
            sourceReadRecentUsers.addAll(b.sourceReadRecentUsers);
        }
        sourceReadRecentUsers = Collections.unmodifiableSortedSet(sourceReadRecentUsers);
        this.sourceReadRecentUsers = sourceReadRecentUsers;
        switch (b.sourceReadSlowQueryRecords == null ? 0 : b.sourceReadSlowQueryRecords.size()) {
            case 0: {
                sourceReadSlowQueryRecords = Collections.emptyList();
                break;
            }
            case 1: {
                sourceReadSlowQueryRecords = Collections.singletonList(b.sourceReadSlowQueryRecords.get(0));
                break;
            }
            default: {
                sourceReadSlowQueryRecords = Collections.unmodifiableList(new ArrayList<PopularityInsights>(b.sourceReadSlowQueryRecords));
            }
        }
        this.sourceReadSlowQueryRecords = sourceReadSlowQueryRecords;
        switch (b.sourceReadTopUserRecords == null ? 0 : b.sourceReadTopUserRecords.size()) {
            case 0: {
                sourceReadTopUserRecords = Collections.emptyList();
                break;
            }
            case 1: {
                sourceReadTopUserRecords = Collections.singletonList(b.sourceReadTopUserRecords.get(0));
                break;
            }
            default: {
                sourceReadTopUserRecords = Collections.unmodifiableList(new ArrayList<PopularityInsights>(b.sourceReadTopUserRecords));
            }
        }
        this.sourceReadTopUserRecords = sourceReadTopUserRecords;
        SortedSet<String> sourceReadTopUsers = new TreeSet<String>();
        if (b.sourceReadTopUsers != null) {
            sourceReadTopUsers.addAll(b.sourceReadTopUsers);
        }
        sourceReadTopUsers = Collections.unmodifiableSortedSet(sourceReadTopUsers);
        this.sourceReadTopUsers = sourceReadTopUsers;
        this.sourceReadUserCount = b.sourceReadUserCount;
        this.sourceTotalCost = b.sourceTotalCost;
        this.sourceURL = b.sourceURL;
        this.sourceUpdatedAt = b.sourceUpdatedAt;
        this.sourceUpdatedBy = b.sourceUpdatedBy;
        SortedSet<String> starredBy = new TreeSet<String>();
        if (b.starredBy != null) {
            starredBy.addAll(b.starredBy);
        }
        starredBy = Collections.unmodifiableSortedSet(starredBy);
        this.starredBy = starredBy;
        this.starredCount = b.starredCount;
        switch (b.starredDetails == null ? 0 : b.starredDetails.size()) {
            case 0: {
                starredDetails = Collections.emptyList();
                break;
            }
            case 1: {
                starredDetails = Collections.singletonList(b.starredDetails.get(0));
                break;
            }
            default: {
                starredDetails = Collections.unmodifiableList(new ArrayList<StarredDetails>(b.starredDetails));
            }
        }
        this.starredDetails = starredDetails;
        this.subType = b.subType;
        this.tenantId = b.tenantId;
        this.userDescription = b.userDescription;
        this.viewScore = b.viewScore;
        SortedSet<String> viewerGroups = new TreeSet<String>();
        if (b.viewerGroups != null) {
            viewerGroups.addAll(b.viewerGroups);
        }
        viewerGroups = Collections.unmodifiableSortedSet(viewerGroups);
        this.viewerGroups = viewerGroups;
        SortedSet<String> viewerUsers = new TreeSet<String>();
        if (b.viewerUsers != null) {
            viewerUsers.addAll(b.viewerUsers);
        }
        viewerUsers = Collections.unmodifiableSortedSet(viewerUsers);
        this.viewerUsers = viewerUsers;
        switch (b.nullFields == null ? 0 : b.nullFields.size()) {
            case 0: {
                nullFields = Collections.emptySet();
                break;
            }
            case 1: {
                nullFields = Collections.singleton(b.nullFields.get(0));
                break;
            }
            default: {
                nullFields = new LinkedHashSet(b.nullFields.size() < 0x40000000 ? 1 + b.nullFields.size() + (b.nullFields.size() - 3) / 3 : Integer.MAX_VALUE);
                nullFields.addAll(b.nullFields);
                nullFields = Collections.unmodifiableSet(nullFields);
            }
        }
        this.nullFields = nullFields;
        SortedSet<AtlanTag> atlanTags = new TreeSet<AtlanTag>();
        if (b.atlanTags != null) {
            atlanTags.addAll(b.atlanTags);
        }
        atlanTags = Collections.unmodifiableSortedSet(atlanTags);
        this.atlanTags = atlanTags;
        switch (b.customMetadataSets$key == null ? 0 : b.customMetadataSets$key.size()) {
            case 0: {
                customMetadataSets = Collections.emptyMap();
                break;
            }
            case 1: {
                customMetadataSets = Collections.singletonMap(b.customMetadataSets$key.get(0), b.customMetadataSets$value.get(0));
                break;
            }
            default: {
                customMetadataSets = new LinkedHashMap(b.customMetadataSets$key.size() < 0x40000000 ? 1 + b.customMetadataSets$key.size() + (b.customMetadataSets$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.customMetadataSets$key.size(); ++$i) {
                    customMetadataSets.put(b.customMetadataSets$key.get($i), b.customMetadataSets$value.get($i));
                }
                customMetadataSets = Collections.unmodifiableMap(customMetadataSets);
            }
        }
        this.customMetadataSets = customMetadataSets;
        this.status = b.status;
        this.createdBy = b.createdBy;
        this.updatedBy = b.updatedBy;
        this.createTime = b.createTime;
        this.updateTime = b.updateTime;
        this.deleteHandler = b.deleteHandler;
        SortedSet<String> atlanTagNames = new TreeSet<String>();
        if (b.atlanTagNames != null) {
            atlanTagNames.addAll(b.atlanTagNames);
        }
        atlanTagNames = Collections.unmodifiableSortedSet(atlanTagNames);
        this.atlanTagNames = atlanTagNames;
        this.isIncomplete = b.isIncomplete;
        SortedSet<String> meaningNames = new TreeSet<String>();
        if (b.meaningNames != null) {
            meaningNames.addAll(b.meaningNames);
        }
        meaningNames = Collections.unmodifiableSortedSet(meaningNames);
        this.meaningNames = meaningNames;
        SortedSet<Meaning> meanings = new TreeSet<Meaning>();
        if (b.meanings != null) {
            meanings.addAll(b.meanings);
        }
        meanings = Collections.unmodifiableSortedSet(meanings);
        this.meanings = meanings;
        SortedSet<String> pendingTasks = new TreeSet<String>();
        if (b.pendingTasks != null) {
            pendingTasks.addAll(b.pendingTasks);
        }
        pendingTasks = Collections.unmodifiableSortedSet(pendingTasks);
        this.pendingTasks = pendingTasks;
    }

    @Override
    @Generated
    public SortedSet<String> getAdminGroups() {
        return this.adminGroups;
    }

    @Override
    @Generated
    public SortedSet<String> getAdminRoles() {
        return this.adminRoles;
    }

    @Override
    @Generated
    public SortedSet<String> getAdminUsers() {
        return this.adminUsers;
    }

    @Override
    @Generated
    public String getAnnouncementMessage() {
        return this.announcementMessage;
    }

    @Override
    @Generated
    public String getAnnouncementTitle() {
        return this.announcementTitle;
    }

    @Override
    @Generated
    public AtlanAnnouncementType getAnnouncementType() {
        return this.announcementType;
    }

    @Override
    @Generated
    public Long getAnnouncementUpdatedAt() {
        return this.announcementUpdatedAt;
    }

    @Override
    @Generated
    public String getAnnouncementUpdatedBy() {
        return this.announcementUpdatedBy;
    }

    @Override
    @Generated
    public String getAssetDbtAccountName() {
        return this.assetDbtAccountName;
    }

    @Override
    @Generated
    public String getAssetDbtAlias() {
        return this.assetDbtAlias;
    }

    @Override
    @Generated
    public String getAssetDbtEnvironmentDbtVersion() {
        return this.assetDbtEnvironmentDbtVersion;
    }

    @Override
    @Generated
    public String getAssetDbtEnvironmentName() {
        return this.assetDbtEnvironmentName;
    }

    @Override
    @Generated
    public Long getAssetDbtJobLastRun() {
        return this.assetDbtJobLastRun;
    }

    @Override
    @Generated
    public String getAssetDbtJobLastRunArtifactS3Path() {
        return this.assetDbtJobLastRunArtifactS3Path;
    }

    @Override
    @Generated
    public Boolean getAssetDbtJobLastRunArtifactsSaved() {
        return this.assetDbtJobLastRunArtifactsSaved;
    }

    @Override
    @Generated
    public Long getAssetDbtJobLastRunCreatedAt() {
        return this.assetDbtJobLastRunCreatedAt;
    }

    @Override
    @Generated
    public Long getAssetDbtJobLastRunDequedAt() {
        return this.assetDbtJobLastRunDequedAt;
    }

    @Override
    @Generated
    public String getAssetDbtJobLastRunExecutedByThreadId() {
        return this.assetDbtJobLastRunExecutedByThreadId;
    }

    @Override
    @Generated
    public String getAssetDbtJobLastRunGitBranch() {
        return this.assetDbtJobLastRunGitBranch;
    }

    @Override
    @Generated
    public String getAssetDbtJobLastRunGitSha() {
        return this.assetDbtJobLastRunGitSha;
    }

    @Override
    @Generated
    public Boolean getAssetDbtJobLastRunHasDocsGenerated() {
        return this.assetDbtJobLastRunHasDocsGenerated;
    }

    @Override
    @Generated
    public Boolean getAssetDbtJobLastRunHasSourcesGenerated() {
        return this.assetDbtJobLastRunHasSourcesGenerated;
    }

    @Override
    @Generated
    public Boolean getAssetDbtJobLastRunNotificationsSent() {
        return this.assetDbtJobLastRunNotificationsSent;
    }

    @Override
    @Generated
    public String getAssetDbtJobLastRunOwnerThreadId() {
        return this.assetDbtJobLastRunOwnerThreadId;
    }

    @Override
    @Generated
    public String getAssetDbtJobLastRunQueuedDuration() {
        return this.assetDbtJobLastRunQueuedDuration;
    }

    @Override
    @Generated
    public String getAssetDbtJobLastRunQueuedDurationHumanized() {
        return this.assetDbtJobLastRunQueuedDurationHumanized;
    }

    @Override
    @Generated
    public String getAssetDbtJobLastRunRunDuration() {
        return this.assetDbtJobLastRunRunDuration;
    }

    @Override
    @Generated
    public String getAssetDbtJobLastRunRunDurationHumanized() {
        return this.assetDbtJobLastRunRunDurationHumanized;
    }

    @Override
    @Generated
    public Long getAssetDbtJobLastRunStartedAt() {
        return this.assetDbtJobLastRunStartedAt;
    }

    @Override
    @Generated
    public String getAssetDbtJobLastRunStatusMessage() {
        return this.assetDbtJobLastRunStatusMessage;
    }

    @Override
    @Generated
    public String getAssetDbtJobLastRunTotalDuration() {
        return this.assetDbtJobLastRunTotalDuration;
    }

    @Override
    @Generated
    public String getAssetDbtJobLastRunTotalDurationHumanized() {
        return this.assetDbtJobLastRunTotalDurationHumanized;
    }

    @Override
    @Generated
    public Long getAssetDbtJobLastRunUpdatedAt() {
        return this.assetDbtJobLastRunUpdatedAt;
    }

    @Override
    @Generated
    public String getAssetDbtJobLastRunUrl() {
        return this.assetDbtJobLastRunUrl;
    }

    @Override
    @Generated
    public String getAssetDbtJobName() {
        return this.assetDbtJobName;
    }

    @Override
    @Generated
    public Long getAssetDbtJobNextRun() {
        return this.assetDbtJobNextRun;
    }

    @Override
    @Generated
    public String getAssetDbtJobNextRunHumanized() {
        return this.assetDbtJobNextRunHumanized;
    }

    @Override
    @Generated
    public String getAssetDbtJobSchedule() {
        return this.assetDbtJobSchedule;
    }

    @Override
    @Generated
    public String getAssetDbtJobScheduleCronHumanized() {
        return this.assetDbtJobScheduleCronHumanized;
    }

    @Override
    @Generated
    public String getAssetDbtJobStatus() {
        return this.assetDbtJobStatus;
    }

    @Override
    @Generated
    public String getAssetDbtMeta() {
        return this.assetDbtMeta;
    }

    @Override
    @Generated
    public String getAssetDbtPackageName() {
        return this.assetDbtPackageName;
    }

    @Override
    @Generated
    public String getAssetDbtProjectName() {
        return this.assetDbtProjectName;
    }

    @Override
    @Generated
    public String getAssetDbtSemanticLayerProxyUrl() {
        return this.assetDbtSemanticLayerProxyUrl;
    }

    @Override
    @Generated
    public String getAssetDbtSourceFreshnessCriteria() {
        return this.assetDbtSourceFreshnessCriteria;
    }

    @Override
    @Generated
    public SortedSet<String> getAssetDbtTags() {
        return this.assetDbtTags;
    }

    @Override
    @Generated
    public String getAssetDbtTestStatus() {
        return this.assetDbtTestStatus;
    }

    @Override
    @Generated
    public String getAssetDbtUniqueId() {
        return this.assetDbtUniqueId;
    }

    @Override
    @Generated
    public String getAssetIcon() {
        return this.assetIcon;
    }

    @Override
    @Generated
    public SortedSet<String> getAssetMcIncidentNames() {
        return this.assetMcIncidentNames;
    }

    @Override
    @Generated
    public SortedSet<String> getAssetMcIncidentQualifiedNames() {
        return this.assetMcIncidentQualifiedNames;
    }

    @Override
    @Generated
    public SortedSet<String> getAssetMcIncidentSeverities() {
        return this.assetMcIncidentSeverities;
    }

    @Override
    @Generated
    public SortedSet<String> getAssetMcIncidentStates() {
        return this.assetMcIncidentStates;
    }

    @Override
    @Generated
    public SortedSet<String> getAssetMcIncidentSubTypes() {
        return this.assetMcIncidentSubTypes;
    }

    @Override
    @Generated
    public SortedSet<String> getAssetMcIncidentTypes() {
        return this.assetMcIncidentTypes;
    }

    @Override
    @Generated
    public Long getAssetMcLastSyncRunAt() {
        return this.assetMcLastSyncRunAt;
    }

    @Override
    @Generated
    public SortedSet<String> getAssetMcMonitorNames() {
        return this.assetMcMonitorNames;
    }

    @Override
    @Generated
    public SortedSet<String> getAssetMcMonitorQualifiedNames() {
        return this.assetMcMonitorQualifiedNames;
    }

    @Override
    @Generated
    public SortedSet<String> getAssetMcMonitorScheduleTypes() {
        return this.assetMcMonitorScheduleTypes;
    }

    @Override
    @Generated
    public SortedSet<String> getAssetMcMonitorStatuses() {
        return this.assetMcMonitorStatuses;
    }

    @Override
    @Generated
    public SortedSet<String> getAssetMcMonitorTypes() {
        return this.assetMcMonitorTypes;
    }

    @Override
    @Generated
    public Long getAssetSodaCheckCount() {
        return this.assetSodaCheckCount;
    }

    @Override
    @Generated
    public String getAssetSodaCheckStatuses() {
        return this.assetSodaCheckStatuses;
    }

    @Override
    @Generated
    public String getAssetSodaDQStatus() {
        return this.assetSodaDQStatus;
    }

    @Override
    @Generated
    public Long getAssetSodaLastScanAt() {
        return this.assetSodaLastScanAt;
    }

    @Override
    @Generated
    public Long getAssetSodaLastSyncRunAt() {
        return this.assetSodaLastSyncRunAt;
    }

    @Override
    @Generated
    public String getAssetSodaSourceURL() {
        return this.assetSodaSourceURL;
    }

    @Override
    @Generated
    public SortedSet<String> getAssetTags() {
        return this.assetTags;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getAssignedTerms() {
        return this.assignedTerms;
    }

    @Override
    @Generated
    public CertificateStatus getCertificateStatus() {
        return this.certificateStatus;
    }

    @Override
    @Generated
    public String getCertificateStatusMessage() {
        return this.certificateStatusMessage;
    }

    @Override
    @Generated
    public Long getCertificateUpdatedAt() {
        return this.certificateUpdatedAt;
    }

    @Override
    @Generated
    public String getCertificateUpdatedBy() {
        return this.certificateUpdatedBy;
    }

    @Override
    @Generated
    public String getConnectionName() {
        return this.connectionName;
    }

    @Override
    @Generated
    public String getConnectionQualifiedName() {
        return this.connectionQualifiedName;
    }

    @Override
    @Generated
    public AtlanConnectorType getConnectorType() {
        return this.connectorType;
    }

    @Override
    @Generated
    public String getDbtQualifiedName() {
        return this.dbtQualifiedName;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public SortedSet<IFile> getFiles() {
        return this.files;
    }

    @Override
    @Generated
    public Boolean getHasLineage() {
        return this.hasLineage;
    }

    @Override
    @Generated
    public Boolean getIsDiscoverable() {
        return this.isDiscoverable;
    }

    @Override
    @Generated
    public Boolean getIsEditable() {
        return this.isEditable;
    }

    @Override
    @Generated
    public Long getLastRowChangedAt() {
        return this.lastRowChangedAt;
    }

    @Override
    @Generated
    public String getLastSyncRun() {
        return this.lastSyncRun;
    }

    @Override
    @Generated
    public Long getLastSyncRunAt() {
        return this.lastSyncRunAt;
    }

    @Override
    @Generated
    public String getLastSyncWorkflowName() {
        return this.lastSyncWorkflowName;
    }

    @Override
    @Generated
    public SortedSet<ILink> getLinks() {
        return this.links;
    }

    @Override
    @Generated
    public SortedSet<IMCIncident> getMcIncidents() {
        return this.mcIncidents;
    }

    @Override
    @Generated
    public SortedSet<IMCMonitor> getMcMonitors() {
        return this.mcMonitors;
    }

    @Override
    @Generated
    public SortedSet<IMetric> getMetrics() {
        return this.metrics;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public SortedSet<String> getOwnerGroups() {
        return this.ownerGroups;
    }

    @Override
    @Generated
    public SortedSet<String> getOwnerUsers() {
        return this.ownerUsers;
    }

    @Override
    @Generated
    public Double getPopularityScore() {
        return this.popularityScore;
    }

    @Override
    @Generated
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    @Generated
    public IReadme getReadme() {
        return this.readme;
    }

    @Override
    @Generated
    public String getSampleDataUrl() {
        return this.sampleDataUrl;
    }

    @Override
    @Generated
    public SortedSet<ISchemaRegistrySubject> getSchemaRegistrySubjects() {
        return this.schemaRegistrySubjects;
    }

    @Override
    @Generated
    public SortedSet<ISodaCheck> getSodaChecks() {
        return this.sodaChecks;
    }

    @Override
    @Generated
    public SourceCostUnitType getSourceCostUnit() {
        return this.sourceCostUnit;
    }

    @Override
    @Generated
    public Long getSourceCreatedAt() {
        return this.sourceCreatedAt;
    }

    @Override
    @Generated
    public String getSourceCreatedBy() {
        return this.sourceCreatedBy;
    }

    @Override
    @Generated
    public String getSourceEmbedURL() {
        return this.sourceEmbedURL;
    }

    @Override
    @Generated
    public Long getSourceLastReadAt() {
        return this.sourceLastReadAt;
    }

    @Override
    @Generated
    public String getSourceOwners() {
        return this.sourceOwners;
    }

    @Override
    @Generated
    public List<PopularityInsights> getSourceQueryComputeCostRecords() {
        return this.sourceQueryComputeCostRecords;
    }

    @Override
    @Generated
    public SortedSet<String> getSourceQueryComputeCosts() {
        return this.sourceQueryComputeCosts;
    }

    @Override
    @Generated
    public Long getSourceReadCount() {
        return this.sourceReadCount;
    }

    @Override
    @Generated
    public List<PopularityInsights> getSourceReadExpensiveQueryRecords() {
        return this.sourceReadExpensiveQueryRecords;
    }

    @Override
    @Generated
    public List<PopularityInsights> getSourceReadPopularQueryRecords() {
        return this.sourceReadPopularQueryRecords;
    }

    @Override
    @Generated
    public Double getSourceReadQueryCost() {
        return this.sourceReadQueryCost;
    }

    @Override
    @Generated
    public List<PopularityInsights> getSourceReadRecentUserRecords() {
        return this.sourceReadRecentUserRecords;
    }

    @Override
    @Generated
    public SortedSet<String> getSourceReadRecentUsers() {
        return this.sourceReadRecentUsers;
    }

    @Override
    @Generated
    public List<PopularityInsights> getSourceReadSlowQueryRecords() {
        return this.sourceReadSlowQueryRecords;
    }

    @Override
    @Generated
    public List<PopularityInsights> getSourceReadTopUserRecords() {
        return this.sourceReadTopUserRecords;
    }

    @Override
    @Generated
    public SortedSet<String> getSourceReadTopUsers() {
        return this.sourceReadTopUsers;
    }

    @Override
    @Generated
    public Long getSourceReadUserCount() {
        return this.sourceReadUserCount;
    }

    @Override
    @Generated
    public Double getSourceTotalCost() {
        return this.sourceTotalCost;
    }

    @Override
    @Generated
    public String getSourceURL() {
        return this.sourceURL;
    }

    @Override
    @Generated
    public Long getSourceUpdatedAt() {
        return this.sourceUpdatedAt;
    }

    @Override
    @Generated
    public String getSourceUpdatedBy() {
        return this.sourceUpdatedBy;
    }

    @Override
    @Generated
    public SortedSet<String> getStarredBy() {
        return this.starredBy;
    }

    @Override
    @Generated
    public Integer getStarredCount() {
        return this.starredCount;
    }

    @Override
    @Generated
    public List<StarredDetails> getStarredDetails() {
        return this.starredDetails;
    }

    @Override
    @Generated
    public String getSubType() {
        return this.subType;
    }

    @Override
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public String getUserDescription() {
        return this.userDescription;
    }

    @Override
    @Generated
    public Double getViewScore() {
        return this.viewScore;
    }

    @Override
    @Generated
    public SortedSet<String> getViewerGroups() {
        return this.viewerGroups;
    }

    @Override
    @Generated
    public SortedSet<String> getViewerUsers() {
        return this.viewerUsers;
    }

    @Override
    @Generated
    public SortedSet<AtlanTag> getAtlanTags() {
        return this.atlanTags;
    }

    @Override
    @Generated
    public Map<String, CustomMetadataAttributes> getCustomMetadataSets() {
        return this.customMetadataSets;
    }

    @Override
    @Generated
    public AtlanStatus getStatus() {
        return this.status;
    }

    @Override
    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Override
    @Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    @Generated
    public Long getCreateTime() {
        return this.createTime;
    }

    @Override
    @Generated
    public Long getUpdateTime() {
        return this.updateTime;
    }

    @Override
    @Generated
    public String getDeleteHandler() {
        return this.deleteHandler;
    }

    @Override
    @Deprecated
    @Generated
    public SortedSet<String> getAtlanTagNames() {
        return this.atlanTagNames;
    }

    @Override
    @Generated
    public Boolean getIsIncomplete() {
        return this.isIncomplete;
    }

    @Override
    @Generated
    public SortedSet<String> getMeaningNames() {
        return this.meaningNames;
    }

    @Override
    @Deprecated
    @Generated
    public SortedSet<Meaning> getMeanings() {
        return this.meanings;
    }

    @Override
    @Generated
    public SortedSet<String> getPendingTasks() {
        return this.pendingTasks;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Generated
    public boolean equals(Object o) {
        void other$pendingTasks;
        void this$pendingTasks;
        void other$meanings;
        void this$meanings;
        void other$meaningNames;
        void this$meaningNames;
        void other$atlanTagNames;
        void this$atlanTagNames;
        void other$deleteHandler;
        void this$deleteHandler;
        void other$updatedBy;
        void this$updatedBy;
        void other$createdBy;
        void this$createdBy;
        void other$status;
        void this$status;
        void other$customMetadataSets;
        void this$customMetadataSets;
        void other$atlanTags;
        void this$atlanTags;
        void other$viewerUsers;
        void this$viewerUsers;
        void other$viewerGroups;
        void this$viewerGroups;
        void other$userDescription;
        void this$userDescription;
        void other$tenantId;
        void this$tenantId;
        void other$subType;
        void this$subType;
        void other$starredDetails;
        void this$starredDetails;
        void other$starredBy;
        void this$starredBy;
        void other$sourceUpdatedBy;
        if (o == this) {
            return true;
        }
        if (!(o instanceof Asset)) {
            return false;
        }
        Asset other = (Asset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$announcementUpdatedAt = this.getAnnouncementUpdatedAt();
        Long other$announcementUpdatedAt = other.getAnnouncementUpdatedAt();
        if (this$announcementUpdatedAt == null ? other$announcementUpdatedAt != null : !((Object)this$announcementUpdatedAt).equals(other$announcementUpdatedAt)) {
            return false;
        }
        Long this$assetDbtJobLastRun = this.getAssetDbtJobLastRun();
        Long other$assetDbtJobLastRun = other.getAssetDbtJobLastRun();
        if (this$assetDbtJobLastRun == null ? other$assetDbtJobLastRun != null : !((Object)this$assetDbtJobLastRun).equals(other$assetDbtJobLastRun)) {
            return false;
        }
        Boolean this$assetDbtJobLastRunArtifactsSaved = this.getAssetDbtJobLastRunArtifactsSaved();
        Boolean other$assetDbtJobLastRunArtifactsSaved = other.getAssetDbtJobLastRunArtifactsSaved();
        if (this$assetDbtJobLastRunArtifactsSaved == null ? other$assetDbtJobLastRunArtifactsSaved != null : !((Object)this$assetDbtJobLastRunArtifactsSaved).equals(other$assetDbtJobLastRunArtifactsSaved)) {
            return false;
        }
        Long this$assetDbtJobLastRunCreatedAt = this.getAssetDbtJobLastRunCreatedAt();
        Long other$assetDbtJobLastRunCreatedAt = other.getAssetDbtJobLastRunCreatedAt();
        if (this$assetDbtJobLastRunCreatedAt == null ? other$assetDbtJobLastRunCreatedAt != null : !((Object)this$assetDbtJobLastRunCreatedAt).equals(other$assetDbtJobLastRunCreatedAt)) {
            return false;
        }
        Long this$assetDbtJobLastRunDequedAt = this.getAssetDbtJobLastRunDequedAt();
        Long other$assetDbtJobLastRunDequedAt = other.getAssetDbtJobLastRunDequedAt();
        if (this$assetDbtJobLastRunDequedAt == null ? other$assetDbtJobLastRunDequedAt != null : !((Object)this$assetDbtJobLastRunDequedAt).equals(other$assetDbtJobLastRunDequedAt)) {
            return false;
        }
        Boolean this$assetDbtJobLastRunHasDocsGenerated = this.getAssetDbtJobLastRunHasDocsGenerated();
        Boolean other$assetDbtJobLastRunHasDocsGenerated = other.getAssetDbtJobLastRunHasDocsGenerated();
        if (this$assetDbtJobLastRunHasDocsGenerated == null ? other$assetDbtJobLastRunHasDocsGenerated != null : !((Object)this$assetDbtJobLastRunHasDocsGenerated).equals(other$assetDbtJobLastRunHasDocsGenerated)) {
            return false;
        }
        Boolean this$assetDbtJobLastRunHasSourcesGenerated = this.getAssetDbtJobLastRunHasSourcesGenerated();
        Boolean other$assetDbtJobLastRunHasSourcesGenerated = other.getAssetDbtJobLastRunHasSourcesGenerated();
        if (this$assetDbtJobLastRunHasSourcesGenerated == null ? other$assetDbtJobLastRunHasSourcesGenerated != null : !((Object)this$assetDbtJobLastRunHasSourcesGenerated).equals(other$assetDbtJobLastRunHasSourcesGenerated)) {
            return false;
        }
        Boolean this$assetDbtJobLastRunNotificationsSent = this.getAssetDbtJobLastRunNotificationsSent();
        Boolean other$assetDbtJobLastRunNotificationsSent = other.getAssetDbtJobLastRunNotificationsSent();
        if (this$assetDbtJobLastRunNotificationsSent == null ? other$assetDbtJobLastRunNotificationsSent != null : !((Object)this$assetDbtJobLastRunNotificationsSent).equals(other$assetDbtJobLastRunNotificationsSent)) {
            return false;
        }
        Long this$assetDbtJobLastRunStartedAt = this.getAssetDbtJobLastRunStartedAt();
        Long other$assetDbtJobLastRunStartedAt = other.getAssetDbtJobLastRunStartedAt();
        if (this$assetDbtJobLastRunStartedAt == null ? other$assetDbtJobLastRunStartedAt != null : !((Object)this$assetDbtJobLastRunStartedAt).equals(other$assetDbtJobLastRunStartedAt)) {
            return false;
        }
        Long this$assetDbtJobLastRunUpdatedAt = this.getAssetDbtJobLastRunUpdatedAt();
        Long other$assetDbtJobLastRunUpdatedAt = other.getAssetDbtJobLastRunUpdatedAt();
        if (this$assetDbtJobLastRunUpdatedAt == null ? other$assetDbtJobLastRunUpdatedAt != null : !((Object)this$assetDbtJobLastRunUpdatedAt).equals(other$assetDbtJobLastRunUpdatedAt)) {
            return false;
        }
        Long this$assetDbtJobNextRun = this.getAssetDbtJobNextRun();
        Long other$assetDbtJobNextRun = other.getAssetDbtJobNextRun();
        if (this$assetDbtJobNextRun == null ? other$assetDbtJobNextRun != null : !((Object)this$assetDbtJobNextRun).equals(other$assetDbtJobNextRun)) {
            return false;
        }
        Long this$assetMcLastSyncRunAt = this.getAssetMcLastSyncRunAt();
        Long other$assetMcLastSyncRunAt = other.getAssetMcLastSyncRunAt();
        if (this$assetMcLastSyncRunAt == null ? other$assetMcLastSyncRunAt != null : !((Object)this$assetMcLastSyncRunAt).equals(other$assetMcLastSyncRunAt)) {
            return false;
        }
        Long this$assetSodaCheckCount = this.getAssetSodaCheckCount();
        Long other$assetSodaCheckCount = other.getAssetSodaCheckCount();
        if (this$assetSodaCheckCount == null ? other$assetSodaCheckCount != null : !((Object)this$assetSodaCheckCount).equals(other$assetSodaCheckCount)) {
            return false;
        }
        Long this$assetSodaLastScanAt = this.getAssetSodaLastScanAt();
        Long other$assetSodaLastScanAt = other.getAssetSodaLastScanAt();
        if (this$assetSodaLastScanAt == null ? other$assetSodaLastScanAt != null : !((Object)this$assetSodaLastScanAt).equals(other$assetSodaLastScanAt)) {
            return false;
        }
        Long this$assetSodaLastSyncRunAt = this.getAssetSodaLastSyncRunAt();
        Long other$assetSodaLastSyncRunAt = other.getAssetSodaLastSyncRunAt();
        if (this$assetSodaLastSyncRunAt == null ? other$assetSodaLastSyncRunAt != null : !((Object)this$assetSodaLastSyncRunAt).equals(other$assetSodaLastSyncRunAt)) {
            return false;
        }
        Long this$certificateUpdatedAt = this.getCertificateUpdatedAt();
        Long other$certificateUpdatedAt = other.getCertificateUpdatedAt();
        if (this$certificateUpdatedAt == null ? other$certificateUpdatedAt != null : !((Object)this$certificateUpdatedAt).equals(other$certificateUpdatedAt)) {
            return false;
        }
        Boolean this$hasLineage = this.getHasLineage();
        Boolean other$hasLineage = other.getHasLineage();
        if (this$hasLineage == null ? other$hasLineage != null : !((Object)this$hasLineage).equals(other$hasLineage)) {
            return false;
        }
        Boolean this$isDiscoverable = this.getIsDiscoverable();
        Boolean other$isDiscoverable = other.getIsDiscoverable();
        if (this$isDiscoverable == null ? other$isDiscoverable != null : !((Object)this$isDiscoverable).equals(other$isDiscoverable)) {
            return false;
        }
        Boolean this$isEditable = this.getIsEditable();
        Boolean other$isEditable = other.getIsEditable();
        if (this$isEditable == null ? other$isEditable != null : !((Object)this$isEditable).equals(other$isEditable)) {
            return false;
        }
        Long this$lastRowChangedAt = this.getLastRowChangedAt();
        Long other$lastRowChangedAt = other.getLastRowChangedAt();
        if (this$lastRowChangedAt == null ? other$lastRowChangedAt != null : !((Object)this$lastRowChangedAt).equals(other$lastRowChangedAt)) {
            return false;
        }
        Long this$lastSyncRunAt = this.getLastSyncRunAt();
        Long other$lastSyncRunAt = other.getLastSyncRunAt();
        if (this$lastSyncRunAt == null ? other$lastSyncRunAt != null : !((Object)this$lastSyncRunAt).equals(other$lastSyncRunAt)) {
            return false;
        }
        Double this$popularityScore = this.getPopularityScore();
        Double other$popularityScore = other.getPopularityScore();
        if (this$popularityScore == null ? other$popularityScore != null : !((Object)this$popularityScore).equals(other$popularityScore)) {
            return false;
        }
        Long this$sourceCreatedAt = this.getSourceCreatedAt();
        Long other$sourceCreatedAt = other.getSourceCreatedAt();
        if (this$sourceCreatedAt == null ? other$sourceCreatedAt != null : !((Object)this$sourceCreatedAt).equals(other$sourceCreatedAt)) {
            return false;
        }
        Long this$sourceLastReadAt = this.getSourceLastReadAt();
        Long other$sourceLastReadAt = other.getSourceLastReadAt();
        if (this$sourceLastReadAt == null ? other$sourceLastReadAt != null : !((Object)this$sourceLastReadAt).equals(other$sourceLastReadAt)) {
            return false;
        }
        Long this$sourceReadCount = this.getSourceReadCount();
        Long other$sourceReadCount = other.getSourceReadCount();
        if (this$sourceReadCount == null ? other$sourceReadCount != null : !((Object)this$sourceReadCount).equals(other$sourceReadCount)) {
            return false;
        }
        Double this$sourceReadQueryCost = this.getSourceReadQueryCost();
        Double other$sourceReadQueryCost = other.getSourceReadQueryCost();
        if (this$sourceReadQueryCost == null ? other$sourceReadQueryCost != null : !((Object)this$sourceReadQueryCost).equals(other$sourceReadQueryCost)) {
            return false;
        }
        Long this$sourceReadUserCount = this.getSourceReadUserCount();
        Long other$sourceReadUserCount = other.getSourceReadUserCount();
        if (this$sourceReadUserCount == null ? other$sourceReadUserCount != null : !((Object)this$sourceReadUserCount).equals(other$sourceReadUserCount)) {
            return false;
        }
        Double this$sourceTotalCost = this.getSourceTotalCost();
        Double other$sourceTotalCost = other.getSourceTotalCost();
        if (this$sourceTotalCost == null ? other$sourceTotalCost != null : !((Object)this$sourceTotalCost).equals(other$sourceTotalCost)) {
            return false;
        }
        Long this$sourceUpdatedAt = this.getSourceUpdatedAt();
        Long other$sourceUpdatedAt = other.getSourceUpdatedAt();
        if (this$sourceUpdatedAt == null ? other$sourceUpdatedAt != null : !((Object)this$sourceUpdatedAt).equals(other$sourceUpdatedAt)) {
            return false;
        }
        Integer this$starredCount = this.getStarredCount();
        Integer other$starredCount = other.getStarredCount();
        if (this$starredCount == null ? other$starredCount != null : !((Object)this$starredCount).equals(other$starredCount)) {
            return false;
        }
        Double this$viewScore = this.getViewScore();
        Double other$viewScore = other.getViewScore();
        if (this$viewScore == null ? other$viewScore != null : !((Object)this$viewScore).equals(other$viewScore)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Long this$updateTime = this.getUpdateTime();
        Long other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Boolean this$isIncomplete = this.getIsIncomplete();
        Boolean other$isIncomplete = other.getIsIncomplete();
        if (this$isIncomplete == null ? other$isIncomplete != null : !((Object)this$isIncomplete).equals(other$isIncomplete)) {
            return false;
        }
        SortedSet<String> this$adminGroups = this.getAdminGroups();
        SortedSet<String> other$adminGroups = other.getAdminGroups();
        if (this$adminGroups == null ? other$adminGroups != null : !this$adminGroups.equals(other$adminGroups)) {
            return false;
        }
        SortedSet<String> this$adminRoles = this.getAdminRoles();
        SortedSet<String> other$adminRoles = other.getAdminRoles();
        if (this$adminRoles == null ? other$adminRoles != null : !this$adminRoles.equals(other$adminRoles)) {
            return false;
        }
        SortedSet<String> this$adminUsers = this.getAdminUsers();
        SortedSet<String> other$adminUsers = other.getAdminUsers();
        if (this$adminUsers == null ? other$adminUsers != null : !this$adminUsers.equals(other$adminUsers)) {
            return false;
        }
        String this$announcementMessage = this.getAnnouncementMessage();
        String other$announcementMessage = other.getAnnouncementMessage();
        if (this$announcementMessage == null ? other$announcementMessage != null : !this$announcementMessage.equals(other$announcementMessage)) {
            return false;
        }
        String this$announcementTitle = this.getAnnouncementTitle();
        String other$announcementTitle = other.getAnnouncementTitle();
        if (this$announcementTitle == null ? other$announcementTitle != null : !this$announcementTitle.equals(other$announcementTitle)) {
            return false;
        }
        AtlanAnnouncementType this$announcementType = this.getAnnouncementType();
        AtlanAnnouncementType other$announcementType = other.getAnnouncementType();
        if (this$announcementType == null ? other$announcementType != null : !this$announcementType.equals(other$announcementType)) {
            return false;
        }
        String this$announcementUpdatedBy = this.getAnnouncementUpdatedBy();
        String other$announcementUpdatedBy = other.getAnnouncementUpdatedBy();
        if (this$announcementUpdatedBy == null ? other$announcementUpdatedBy != null : !this$announcementUpdatedBy.equals(other$announcementUpdatedBy)) {
            return false;
        }
        String this$assetDbtAccountName = this.getAssetDbtAccountName();
        String other$assetDbtAccountName = other.getAssetDbtAccountName();
        if (this$assetDbtAccountName == null ? other$assetDbtAccountName != null : !this$assetDbtAccountName.equals(other$assetDbtAccountName)) {
            return false;
        }
        String this$assetDbtAlias = this.getAssetDbtAlias();
        String other$assetDbtAlias = other.getAssetDbtAlias();
        if (this$assetDbtAlias == null ? other$assetDbtAlias != null : !this$assetDbtAlias.equals(other$assetDbtAlias)) {
            return false;
        }
        String this$assetDbtEnvironmentDbtVersion = this.getAssetDbtEnvironmentDbtVersion();
        String other$assetDbtEnvironmentDbtVersion = other.getAssetDbtEnvironmentDbtVersion();
        if (this$assetDbtEnvironmentDbtVersion == null ? other$assetDbtEnvironmentDbtVersion != null : !this$assetDbtEnvironmentDbtVersion.equals(other$assetDbtEnvironmentDbtVersion)) {
            return false;
        }
        String this$assetDbtEnvironmentName = this.getAssetDbtEnvironmentName();
        String other$assetDbtEnvironmentName = other.getAssetDbtEnvironmentName();
        if (this$assetDbtEnvironmentName == null ? other$assetDbtEnvironmentName != null : !this$assetDbtEnvironmentName.equals(other$assetDbtEnvironmentName)) {
            return false;
        }
        String this$assetDbtJobLastRunArtifactS3Path = this.getAssetDbtJobLastRunArtifactS3Path();
        String other$assetDbtJobLastRunArtifactS3Path = other.getAssetDbtJobLastRunArtifactS3Path();
        if (this$assetDbtJobLastRunArtifactS3Path == null ? other$assetDbtJobLastRunArtifactS3Path != null : !this$assetDbtJobLastRunArtifactS3Path.equals(other$assetDbtJobLastRunArtifactS3Path)) {
            return false;
        }
        String this$assetDbtJobLastRunExecutedByThreadId = this.getAssetDbtJobLastRunExecutedByThreadId();
        String other$assetDbtJobLastRunExecutedByThreadId = other.getAssetDbtJobLastRunExecutedByThreadId();
        if (this$assetDbtJobLastRunExecutedByThreadId == null ? other$assetDbtJobLastRunExecutedByThreadId != null : !this$assetDbtJobLastRunExecutedByThreadId.equals(other$assetDbtJobLastRunExecutedByThreadId)) {
            return false;
        }
        String this$assetDbtJobLastRunGitBranch = this.getAssetDbtJobLastRunGitBranch();
        String other$assetDbtJobLastRunGitBranch = other.getAssetDbtJobLastRunGitBranch();
        if (this$assetDbtJobLastRunGitBranch == null ? other$assetDbtJobLastRunGitBranch != null : !this$assetDbtJobLastRunGitBranch.equals(other$assetDbtJobLastRunGitBranch)) {
            return false;
        }
        String this$assetDbtJobLastRunGitSha = this.getAssetDbtJobLastRunGitSha();
        String other$assetDbtJobLastRunGitSha = other.getAssetDbtJobLastRunGitSha();
        if (this$assetDbtJobLastRunGitSha == null ? other$assetDbtJobLastRunGitSha != null : !this$assetDbtJobLastRunGitSha.equals(other$assetDbtJobLastRunGitSha)) {
            return false;
        }
        String this$assetDbtJobLastRunOwnerThreadId = this.getAssetDbtJobLastRunOwnerThreadId();
        String other$assetDbtJobLastRunOwnerThreadId = other.getAssetDbtJobLastRunOwnerThreadId();
        if (this$assetDbtJobLastRunOwnerThreadId == null ? other$assetDbtJobLastRunOwnerThreadId != null : !this$assetDbtJobLastRunOwnerThreadId.equals(other$assetDbtJobLastRunOwnerThreadId)) {
            return false;
        }
        String this$assetDbtJobLastRunQueuedDuration = this.getAssetDbtJobLastRunQueuedDuration();
        String other$assetDbtJobLastRunQueuedDuration = other.getAssetDbtJobLastRunQueuedDuration();
        if (this$assetDbtJobLastRunQueuedDuration == null ? other$assetDbtJobLastRunQueuedDuration != null : !this$assetDbtJobLastRunQueuedDuration.equals(other$assetDbtJobLastRunQueuedDuration)) {
            return false;
        }
        String this$assetDbtJobLastRunQueuedDurationHumanized = this.getAssetDbtJobLastRunQueuedDurationHumanized();
        String other$assetDbtJobLastRunQueuedDurationHumanized = other.getAssetDbtJobLastRunQueuedDurationHumanized();
        if (this$assetDbtJobLastRunQueuedDurationHumanized == null ? other$assetDbtJobLastRunQueuedDurationHumanized != null : !this$assetDbtJobLastRunQueuedDurationHumanized.equals(other$assetDbtJobLastRunQueuedDurationHumanized)) {
            return false;
        }
        String this$assetDbtJobLastRunRunDuration = this.getAssetDbtJobLastRunRunDuration();
        String other$assetDbtJobLastRunRunDuration = other.getAssetDbtJobLastRunRunDuration();
        if (this$assetDbtJobLastRunRunDuration == null ? other$assetDbtJobLastRunRunDuration != null : !this$assetDbtJobLastRunRunDuration.equals(other$assetDbtJobLastRunRunDuration)) {
            return false;
        }
        String this$assetDbtJobLastRunRunDurationHumanized = this.getAssetDbtJobLastRunRunDurationHumanized();
        String other$assetDbtJobLastRunRunDurationHumanized = other.getAssetDbtJobLastRunRunDurationHumanized();
        if (this$assetDbtJobLastRunRunDurationHumanized == null ? other$assetDbtJobLastRunRunDurationHumanized != null : !this$assetDbtJobLastRunRunDurationHumanized.equals(other$assetDbtJobLastRunRunDurationHumanized)) {
            return false;
        }
        String this$assetDbtJobLastRunStatusMessage = this.getAssetDbtJobLastRunStatusMessage();
        String other$assetDbtJobLastRunStatusMessage = other.getAssetDbtJobLastRunStatusMessage();
        if (this$assetDbtJobLastRunStatusMessage == null ? other$assetDbtJobLastRunStatusMessage != null : !this$assetDbtJobLastRunStatusMessage.equals(other$assetDbtJobLastRunStatusMessage)) {
            return false;
        }
        String this$assetDbtJobLastRunTotalDuration = this.getAssetDbtJobLastRunTotalDuration();
        String other$assetDbtJobLastRunTotalDuration = other.getAssetDbtJobLastRunTotalDuration();
        if (this$assetDbtJobLastRunTotalDuration == null ? other$assetDbtJobLastRunTotalDuration != null : !this$assetDbtJobLastRunTotalDuration.equals(other$assetDbtJobLastRunTotalDuration)) {
            return false;
        }
        String this$assetDbtJobLastRunTotalDurationHumanized = this.getAssetDbtJobLastRunTotalDurationHumanized();
        String other$assetDbtJobLastRunTotalDurationHumanized = other.getAssetDbtJobLastRunTotalDurationHumanized();
        if (this$assetDbtJobLastRunTotalDurationHumanized == null ? other$assetDbtJobLastRunTotalDurationHumanized != null : !this$assetDbtJobLastRunTotalDurationHumanized.equals(other$assetDbtJobLastRunTotalDurationHumanized)) {
            return false;
        }
        String this$assetDbtJobLastRunUrl = this.getAssetDbtJobLastRunUrl();
        String other$assetDbtJobLastRunUrl = other.getAssetDbtJobLastRunUrl();
        if (this$assetDbtJobLastRunUrl == null ? other$assetDbtJobLastRunUrl != null : !this$assetDbtJobLastRunUrl.equals(other$assetDbtJobLastRunUrl)) {
            return false;
        }
        String this$assetDbtJobName = this.getAssetDbtJobName();
        String other$assetDbtJobName = other.getAssetDbtJobName();
        if (this$assetDbtJobName == null ? other$assetDbtJobName != null : !this$assetDbtJobName.equals(other$assetDbtJobName)) {
            return false;
        }
        String this$assetDbtJobNextRunHumanized = this.getAssetDbtJobNextRunHumanized();
        String other$assetDbtJobNextRunHumanized = other.getAssetDbtJobNextRunHumanized();
        if (this$assetDbtJobNextRunHumanized == null ? other$assetDbtJobNextRunHumanized != null : !this$assetDbtJobNextRunHumanized.equals(other$assetDbtJobNextRunHumanized)) {
            return false;
        }
        String this$assetDbtJobSchedule = this.getAssetDbtJobSchedule();
        String other$assetDbtJobSchedule = other.getAssetDbtJobSchedule();
        if (this$assetDbtJobSchedule == null ? other$assetDbtJobSchedule != null : !this$assetDbtJobSchedule.equals(other$assetDbtJobSchedule)) {
            return false;
        }
        String this$assetDbtJobScheduleCronHumanized = this.getAssetDbtJobScheduleCronHumanized();
        String other$assetDbtJobScheduleCronHumanized = other.getAssetDbtJobScheduleCronHumanized();
        if (this$assetDbtJobScheduleCronHumanized == null ? other$assetDbtJobScheduleCronHumanized != null : !this$assetDbtJobScheduleCronHumanized.equals(other$assetDbtJobScheduleCronHumanized)) {
            return false;
        }
        String this$assetDbtJobStatus = this.getAssetDbtJobStatus();
        String other$assetDbtJobStatus = other.getAssetDbtJobStatus();
        if (this$assetDbtJobStatus == null ? other$assetDbtJobStatus != null : !this$assetDbtJobStatus.equals(other$assetDbtJobStatus)) {
            return false;
        }
        String this$assetDbtMeta = this.getAssetDbtMeta();
        String other$assetDbtMeta = other.getAssetDbtMeta();
        if (this$assetDbtMeta == null ? other$assetDbtMeta != null : !this$assetDbtMeta.equals(other$assetDbtMeta)) {
            return false;
        }
        String this$assetDbtPackageName = this.getAssetDbtPackageName();
        String other$assetDbtPackageName = other.getAssetDbtPackageName();
        if (this$assetDbtPackageName == null ? other$assetDbtPackageName != null : !this$assetDbtPackageName.equals(other$assetDbtPackageName)) {
            return false;
        }
        String this$assetDbtProjectName = this.getAssetDbtProjectName();
        String other$assetDbtProjectName = other.getAssetDbtProjectName();
        if (this$assetDbtProjectName == null ? other$assetDbtProjectName != null : !this$assetDbtProjectName.equals(other$assetDbtProjectName)) {
            return false;
        }
        String this$assetDbtSemanticLayerProxyUrl = this.getAssetDbtSemanticLayerProxyUrl();
        String other$assetDbtSemanticLayerProxyUrl = other.getAssetDbtSemanticLayerProxyUrl();
        if (this$assetDbtSemanticLayerProxyUrl == null ? other$assetDbtSemanticLayerProxyUrl != null : !this$assetDbtSemanticLayerProxyUrl.equals(other$assetDbtSemanticLayerProxyUrl)) {
            return false;
        }
        String this$assetDbtSourceFreshnessCriteria = this.getAssetDbtSourceFreshnessCriteria();
        String other$assetDbtSourceFreshnessCriteria = other.getAssetDbtSourceFreshnessCriteria();
        if (this$assetDbtSourceFreshnessCriteria == null ? other$assetDbtSourceFreshnessCriteria != null : !this$assetDbtSourceFreshnessCriteria.equals(other$assetDbtSourceFreshnessCriteria)) {
            return false;
        }
        SortedSet<String> this$assetDbtTags = this.getAssetDbtTags();
        SortedSet<String> other$assetDbtTags = other.getAssetDbtTags();
        if (this$assetDbtTags == null ? other$assetDbtTags != null : !this$assetDbtTags.equals(other$assetDbtTags)) {
            return false;
        }
        String this$assetDbtTestStatus = this.getAssetDbtTestStatus();
        String other$assetDbtTestStatus = other.getAssetDbtTestStatus();
        if (this$assetDbtTestStatus == null ? other$assetDbtTestStatus != null : !this$assetDbtTestStatus.equals(other$assetDbtTestStatus)) {
            return false;
        }
        String this$assetDbtUniqueId = this.getAssetDbtUniqueId();
        String other$assetDbtUniqueId = other.getAssetDbtUniqueId();
        if (this$assetDbtUniqueId == null ? other$assetDbtUniqueId != null : !this$assetDbtUniqueId.equals(other$assetDbtUniqueId)) {
            return false;
        }
        String this$assetIcon = this.getAssetIcon();
        String other$assetIcon = other.getAssetIcon();
        if (this$assetIcon == null ? other$assetIcon != null : !this$assetIcon.equals(other$assetIcon)) {
            return false;
        }
        SortedSet<String> this$assetMcIncidentNames = this.getAssetMcIncidentNames();
        SortedSet<String> other$assetMcIncidentNames = other.getAssetMcIncidentNames();
        if (this$assetMcIncidentNames == null ? other$assetMcIncidentNames != null : !this$assetMcIncidentNames.equals(other$assetMcIncidentNames)) {
            return false;
        }
        SortedSet<String> this$assetMcIncidentQualifiedNames = this.getAssetMcIncidentQualifiedNames();
        SortedSet<String> other$assetMcIncidentQualifiedNames = other.getAssetMcIncidentQualifiedNames();
        if (this$assetMcIncidentQualifiedNames == null ? other$assetMcIncidentQualifiedNames != null : !this$assetMcIncidentQualifiedNames.equals(other$assetMcIncidentQualifiedNames)) {
            return false;
        }
        SortedSet<String> this$assetMcIncidentSeverities = this.getAssetMcIncidentSeverities();
        SortedSet<String> other$assetMcIncidentSeverities = other.getAssetMcIncidentSeverities();
        if (this$assetMcIncidentSeverities == null ? other$assetMcIncidentSeverities != null : !this$assetMcIncidentSeverities.equals(other$assetMcIncidentSeverities)) {
            return false;
        }
        SortedSet<String> this$assetMcIncidentStates = this.getAssetMcIncidentStates();
        SortedSet<String> other$assetMcIncidentStates = other.getAssetMcIncidentStates();
        if (this$assetMcIncidentStates == null ? other$assetMcIncidentStates != null : !this$assetMcIncidentStates.equals(other$assetMcIncidentStates)) {
            return false;
        }
        SortedSet<String> this$assetMcIncidentSubTypes = this.getAssetMcIncidentSubTypes();
        SortedSet<String> other$assetMcIncidentSubTypes = other.getAssetMcIncidentSubTypes();
        if (this$assetMcIncidentSubTypes == null ? other$assetMcIncidentSubTypes != null : !this$assetMcIncidentSubTypes.equals(other$assetMcIncidentSubTypes)) {
            return false;
        }
        SortedSet<String> this$assetMcIncidentTypes = this.getAssetMcIncidentTypes();
        SortedSet<String> other$assetMcIncidentTypes = other.getAssetMcIncidentTypes();
        if (this$assetMcIncidentTypes == null ? other$assetMcIncidentTypes != null : !this$assetMcIncidentTypes.equals(other$assetMcIncidentTypes)) {
            return false;
        }
        SortedSet<String> this$assetMcMonitorNames = this.getAssetMcMonitorNames();
        SortedSet<String> other$assetMcMonitorNames = other.getAssetMcMonitorNames();
        if (this$assetMcMonitorNames == null ? other$assetMcMonitorNames != null : !this$assetMcMonitorNames.equals(other$assetMcMonitorNames)) {
            return false;
        }
        SortedSet<String> this$assetMcMonitorQualifiedNames = this.getAssetMcMonitorQualifiedNames();
        SortedSet<String> other$assetMcMonitorQualifiedNames = other.getAssetMcMonitorQualifiedNames();
        if (this$assetMcMonitorQualifiedNames == null ? other$assetMcMonitorQualifiedNames != null : !this$assetMcMonitorQualifiedNames.equals(other$assetMcMonitorQualifiedNames)) {
            return false;
        }
        SortedSet<String> this$assetMcMonitorScheduleTypes = this.getAssetMcMonitorScheduleTypes();
        SortedSet<String> other$assetMcMonitorScheduleTypes = other.getAssetMcMonitorScheduleTypes();
        if (this$assetMcMonitorScheduleTypes == null ? other$assetMcMonitorScheduleTypes != null : !this$assetMcMonitorScheduleTypes.equals(other$assetMcMonitorScheduleTypes)) {
            return false;
        }
        SortedSet<String> this$assetMcMonitorStatuses = this.getAssetMcMonitorStatuses();
        SortedSet<String> other$assetMcMonitorStatuses = other.getAssetMcMonitorStatuses();
        if (this$assetMcMonitorStatuses == null ? other$assetMcMonitorStatuses != null : !this$assetMcMonitorStatuses.equals(other$assetMcMonitorStatuses)) {
            return false;
        }
        SortedSet<String> this$assetMcMonitorTypes = this.getAssetMcMonitorTypes();
        SortedSet<String> other$assetMcMonitorTypes = other.getAssetMcMonitorTypes();
        if (this$assetMcMonitorTypes == null ? other$assetMcMonitorTypes != null : !this$assetMcMonitorTypes.equals(other$assetMcMonitorTypes)) {
            return false;
        }
        String this$assetSodaCheckStatuses = this.getAssetSodaCheckStatuses();
        String other$assetSodaCheckStatuses = other.getAssetSodaCheckStatuses();
        if (this$assetSodaCheckStatuses == null ? other$assetSodaCheckStatuses != null : !this$assetSodaCheckStatuses.equals(other$assetSodaCheckStatuses)) {
            return false;
        }
        String this$assetSodaDQStatus = this.getAssetSodaDQStatus();
        String other$assetSodaDQStatus = other.getAssetSodaDQStatus();
        if (this$assetSodaDQStatus == null ? other$assetSodaDQStatus != null : !this$assetSodaDQStatus.equals(other$assetSodaDQStatus)) {
            return false;
        }
        String this$assetSodaSourceURL = this.getAssetSodaSourceURL();
        String other$assetSodaSourceURL = other.getAssetSodaSourceURL();
        if (this$assetSodaSourceURL == null ? other$assetSodaSourceURL != null : !this$assetSodaSourceURL.equals(other$assetSodaSourceURL)) {
            return false;
        }
        SortedSet<String> this$assetTags = this.getAssetTags();
        SortedSet<String> other$assetTags = other.getAssetTags();
        if (this$assetTags == null ? other$assetTags != null : !this$assetTags.equals(other$assetTags)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$assignedTerms = this.getAssignedTerms();
        SortedSet<IGlossaryTerm> other$assignedTerms = other.getAssignedTerms();
        if (this$assignedTerms == null ? other$assignedTerms != null : !this$assignedTerms.equals(other$assignedTerms)) {
            return false;
        }
        CertificateStatus this$certificateStatus = this.getCertificateStatus();
        CertificateStatus other$certificateStatus = other.getCertificateStatus();
        if (this$certificateStatus == null ? other$certificateStatus != null : !this$certificateStatus.equals(other$certificateStatus)) {
            return false;
        }
        String this$certificateStatusMessage = this.getCertificateStatusMessage();
        String other$certificateStatusMessage = other.getCertificateStatusMessage();
        if (this$certificateStatusMessage == null ? other$certificateStatusMessage != null : !this$certificateStatusMessage.equals(other$certificateStatusMessage)) {
            return false;
        }
        String this$certificateUpdatedBy = this.getCertificateUpdatedBy();
        String other$certificateUpdatedBy = other.getCertificateUpdatedBy();
        if (this$certificateUpdatedBy == null ? other$certificateUpdatedBy != null : !this$certificateUpdatedBy.equals(other$certificateUpdatedBy)) {
            return false;
        }
        String this$connectionName = this.getConnectionName();
        String other$connectionName = other.getConnectionName();
        if (this$connectionName == null ? other$connectionName != null : !this$connectionName.equals(other$connectionName)) {
            return false;
        }
        String this$connectionQualifiedName = this.getConnectionQualifiedName();
        String other$connectionQualifiedName = other.getConnectionQualifiedName();
        if (this$connectionQualifiedName == null ? other$connectionQualifiedName != null : !this$connectionQualifiedName.equals(other$connectionQualifiedName)) {
            return false;
        }
        AtlanConnectorType this$connectorType = this.getConnectorType();
        AtlanConnectorType other$connectorType = other.getConnectorType();
        if (this$connectorType == null ? other$connectorType != null : !this$connectorType.equals(other$connectorType)) {
            return false;
        }
        String this$dbtQualifiedName = this.getDbtQualifiedName();
        String other$dbtQualifiedName = other.getDbtQualifiedName();
        if (this$dbtQualifiedName == null ? other$dbtQualifiedName != null : !this$dbtQualifiedName.equals(other$dbtQualifiedName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        SortedSet<IFile> this$files = this.getFiles();
        SortedSet<IFile> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !this$files.equals(other$files)) {
            return false;
        }
        String this$lastSyncRun = this.getLastSyncRun();
        String other$lastSyncRun = other.getLastSyncRun();
        if (this$lastSyncRun == null ? other$lastSyncRun != null : !this$lastSyncRun.equals(other$lastSyncRun)) {
            return false;
        }
        String this$lastSyncWorkflowName = this.getLastSyncWorkflowName();
        String other$lastSyncWorkflowName = other.getLastSyncWorkflowName();
        if (this$lastSyncWorkflowName == null ? other$lastSyncWorkflowName != null : !this$lastSyncWorkflowName.equals(other$lastSyncWorkflowName)) {
            return false;
        }
        SortedSet<ILink> this$links = this.getLinks();
        SortedSet<ILink> other$links = other.getLinks();
        if (this$links == null ? other$links != null : !this$links.equals(other$links)) {
            return false;
        }
        SortedSet<IMCIncident> this$mcIncidents = this.getMcIncidents();
        SortedSet<IMCIncident> other$mcIncidents = other.getMcIncidents();
        if (this$mcIncidents == null ? other$mcIncidents != null : !this$mcIncidents.equals(other$mcIncidents)) {
            return false;
        }
        SortedSet<IMCMonitor> this$mcMonitors = this.getMcMonitors();
        SortedSet<IMCMonitor> other$mcMonitors = other.getMcMonitors();
        if (this$mcMonitors == null ? other$mcMonitors != null : !this$mcMonitors.equals(other$mcMonitors)) {
            return false;
        }
        SortedSet<IMetric> this$metrics = this.getMetrics();
        SortedSet<IMetric> other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        SortedSet<String> this$ownerGroups = this.getOwnerGroups();
        SortedSet<String> other$ownerGroups = other.getOwnerGroups();
        if (this$ownerGroups == null ? other$ownerGroups != null : !this$ownerGroups.equals(other$ownerGroups)) {
            return false;
        }
        SortedSet<String> this$ownerUsers = this.getOwnerUsers();
        SortedSet<String> other$ownerUsers = other.getOwnerUsers();
        if (this$ownerUsers == null ? other$ownerUsers != null : !this$ownerUsers.equals(other$ownerUsers)) {
            return false;
        }
        String this$qualifiedName = this.getQualifiedName();
        String other$qualifiedName = other.getQualifiedName();
        if (this$qualifiedName == null ? other$qualifiedName != null : !this$qualifiedName.equals(other$qualifiedName)) {
            return false;
        }
        IReadme this$readme = this.getReadme();
        IReadme other$readme = other.getReadme();
        if (this$readme == null ? other$readme != null : !this$readme.equals(other$readme)) {
            return false;
        }
        String this$sampleDataUrl = this.getSampleDataUrl();
        String other$sampleDataUrl = other.getSampleDataUrl();
        if (this$sampleDataUrl == null ? other$sampleDataUrl != null : !this$sampleDataUrl.equals(other$sampleDataUrl)) {
            return false;
        }
        SortedSet<ISchemaRegistrySubject> this$schemaRegistrySubjects = this.getSchemaRegistrySubjects();
        SortedSet<ISchemaRegistrySubject> other$schemaRegistrySubjects = other.getSchemaRegistrySubjects();
        if (this$schemaRegistrySubjects == null ? other$schemaRegistrySubjects != null : !this$schemaRegistrySubjects.equals(other$schemaRegistrySubjects)) {
            return false;
        }
        SortedSet<ISodaCheck> this$sodaChecks = this.getSodaChecks();
        SortedSet<ISodaCheck> other$sodaChecks = other.getSodaChecks();
        if (this$sodaChecks == null ? other$sodaChecks != null : !this$sodaChecks.equals(other$sodaChecks)) {
            return false;
        }
        SourceCostUnitType this$sourceCostUnit = this.getSourceCostUnit();
        SourceCostUnitType other$sourceCostUnit = other.getSourceCostUnit();
        if (this$sourceCostUnit == null ? other$sourceCostUnit != null : !this$sourceCostUnit.equals(other$sourceCostUnit)) {
            return false;
        }
        String this$sourceCreatedBy = this.getSourceCreatedBy();
        String other$sourceCreatedBy = other.getSourceCreatedBy();
        if (this$sourceCreatedBy == null ? other$sourceCreatedBy != null : !this$sourceCreatedBy.equals(other$sourceCreatedBy)) {
            return false;
        }
        String this$sourceEmbedURL = this.getSourceEmbedURL();
        String other$sourceEmbedURL = other.getSourceEmbedURL();
        if (this$sourceEmbedURL == null ? other$sourceEmbedURL != null : !this$sourceEmbedURL.equals(other$sourceEmbedURL)) {
            return false;
        }
        String this$sourceOwners = this.getSourceOwners();
        String other$sourceOwners = other.getSourceOwners();
        if (this$sourceOwners == null ? other$sourceOwners != null : !this$sourceOwners.equals(other$sourceOwners)) {
            return false;
        }
        List<PopularityInsights> this$sourceQueryComputeCostRecords = this.getSourceQueryComputeCostRecords();
        List<PopularityInsights> other$sourceQueryComputeCostRecords = other.getSourceQueryComputeCostRecords();
        if (this$sourceQueryComputeCostRecords == null ? other$sourceQueryComputeCostRecords != null : !((Object)this$sourceQueryComputeCostRecords).equals(other$sourceQueryComputeCostRecords)) {
            return false;
        }
        SortedSet<String> this$sourceQueryComputeCosts = this.getSourceQueryComputeCosts();
        SortedSet<String> other$sourceQueryComputeCosts = other.getSourceQueryComputeCosts();
        if (this$sourceQueryComputeCosts == null ? other$sourceQueryComputeCosts != null : !this$sourceQueryComputeCosts.equals(other$sourceQueryComputeCosts)) {
            return false;
        }
        List<PopularityInsights> this$sourceReadExpensiveQueryRecords = this.getSourceReadExpensiveQueryRecords();
        List<PopularityInsights> other$sourceReadExpensiveQueryRecords = other.getSourceReadExpensiveQueryRecords();
        if (this$sourceReadExpensiveQueryRecords == null ? other$sourceReadExpensiveQueryRecords != null : !((Object)this$sourceReadExpensiveQueryRecords).equals(other$sourceReadExpensiveQueryRecords)) {
            return false;
        }
        List<PopularityInsights> this$sourceReadPopularQueryRecords = this.getSourceReadPopularQueryRecords();
        List<PopularityInsights> other$sourceReadPopularQueryRecords = other.getSourceReadPopularQueryRecords();
        if (this$sourceReadPopularQueryRecords == null ? other$sourceReadPopularQueryRecords != null : !((Object)this$sourceReadPopularQueryRecords).equals(other$sourceReadPopularQueryRecords)) {
            return false;
        }
        List<PopularityInsights> this$sourceReadRecentUserRecords = this.getSourceReadRecentUserRecords();
        List<PopularityInsights> other$sourceReadRecentUserRecords = other.getSourceReadRecentUserRecords();
        if (this$sourceReadRecentUserRecords == null ? other$sourceReadRecentUserRecords != null : !((Object)this$sourceReadRecentUserRecords).equals(other$sourceReadRecentUserRecords)) {
            return false;
        }
        SortedSet<String> this$sourceReadRecentUsers = this.getSourceReadRecentUsers();
        SortedSet<String> other$sourceReadRecentUsers = other.getSourceReadRecentUsers();
        if (this$sourceReadRecentUsers == null ? other$sourceReadRecentUsers != null : !this$sourceReadRecentUsers.equals(other$sourceReadRecentUsers)) {
            return false;
        }
        List<PopularityInsights> this$sourceReadSlowQueryRecords = this.getSourceReadSlowQueryRecords();
        List<PopularityInsights> other$sourceReadSlowQueryRecords = other.getSourceReadSlowQueryRecords();
        if (this$sourceReadSlowQueryRecords == null ? other$sourceReadSlowQueryRecords != null : !((Object)this$sourceReadSlowQueryRecords).equals(other$sourceReadSlowQueryRecords)) {
            return false;
        }
        List<PopularityInsights> this$sourceReadTopUserRecords = this.getSourceReadTopUserRecords();
        List<PopularityInsights> other$sourceReadTopUserRecords = other.getSourceReadTopUserRecords();
        if (this$sourceReadTopUserRecords == null ? other$sourceReadTopUserRecords != null : !((Object)this$sourceReadTopUserRecords).equals(other$sourceReadTopUserRecords)) {
            return false;
        }
        SortedSet<String> this$sourceReadTopUsers = this.getSourceReadTopUsers();
        SortedSet<String> other$sourceReadTopUsers = other.getSourceReadTopUsers();
        if (this$sourceReadTopUsers == null ? other$sourceReadTopUsers != null : !this$sourceReadTopUsers.equals(other$sourceReadTopUsers)) {
            return false;
        }
        String this$sourceURL = this.getSourceURL();
        String other$sourceURL = other.getSourceURL();
        if (this$sourceURL == null ? other$sourceURL != null : !this$sourceURL.equals(other$sourceURL)) {
            return false;
        }
        String this$sourceUpdatedBy = this.getSourceUpdatedBy();
        String string = other.getSourceUpdatedBy();
        if (this$sourceUpdatedBy == null ? other$sourceUpdatedBy != null : !this$sourceUpdatedBy.equals(other$sourceUpdatedBy)) {
            return false;
        }
        SortedSet<String> sortedSet = this.getStarredBy();
        SortedSet<String> sortedSet2 = other.getStarredBy();
        if (this$starredBy == null ? other$starredBy != null : !this$starredBy.equals(other$starredBy)) {
            return false;
        }
        List<StarredDetails> list = this.getStarredDetails();
        List<StarredDetails> list2 = other.getStarredDetails();
        if (this$starredDetails == null ? other$starredDetails != null : !this$starredDetails.equals(other$starredDetails)) {
            return false;
        }
        String string2 = this.getSubType();
        String string3 = other.getSubType();
        if (this$subType == null ? other$subType != null : !this$subType.equals(other$subType)) {
            return false;
        }
        String string4 = this.getTenantId();
        String string5 = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String string6 = this.getUserDescription();
        String string7 = other.getUserDescription();
        if (this$userDescription == null ? other$userDescription != null : !this$userDescription.equals(other$userDescription)) {
            return false;
        }
        SortedSet<String> sortedSet3 = this.getViewerGroups();
        SortedSet<String> sortedSet4 = other.getViewerGroups();
        if (this$viewerGroups == null ? other$viewerGroups != null : !this$viewerGroups.equals(other$viewerGroups)) {
            return false;
        }
        SortedSet<String> sortedSet5 = this.getViewerUsers();
        SortedSet<String> sortedSet6 = other.getViewerUsers();
        if (this$viewerUsers == null ? other$viewerUsers != null : !this$viewerUsers.equals(other$viewerUsers)) {
            return false;
        }
        SortedSet<AtlanTag> sortedSet7 = this.getAtlanTags();
        SortedSet<AtlanTag> sortedSet8 = other.getAtlanTags();
        if (this$atlanTags == null ? other$atlanTags != null : !this$atlanTags.equals(other$atlanTags)) {
            return false;
        }
        Map<String, CustomMetadataAttributes> map = this.getCustomMetadataSets();
        Map<String, CustomMetadataAttributes> map2 = other.getCustomMetadataSets();
        if (this$customMetadataSets == null ? other$customMetadataSets != null : !this$customMetadataSets.equals(other$customMetadataSets)) {
            return false;
        }
        AtlanStatus atlanStatus = this.getStatus();
        AtlanStatus atlanStatus2 = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String string8 = this.getCreatedBy();
        String string9 = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String string10 = this.getUpdatedBy();
        String string11 = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) {
            return false;
        }
        String string12 = this.getDeleteHandler();
        String string13 = other.getDeleteHandler();
        if (this$deleteHandler == null ? other$deleteHandler != null : !this$deleteHandler.equals(other$deleteHandler)) {
            return false;
        }
        SortedSet<String> sortedSet9 = this.getAtlanTagNames();
        SortedSet<String> sortedSet10 = other.getAtlanTagNames();
        if (this$atlanTagNames == null ? other$atlanTagNames != null : !this$atlanTagNames.equals(other$atlanTagNames)) {
            return false;
        }
        SortedSet<String> sortedSet11 = this.getMeaningNames();
        SortedSet<String> sortedSet12 = other.getMeaningNames();
        if (this$meaningNames == null ? other$meaningNames != null : !this$meaningNames.equals(other$meaningNames)) {
            return false;
        }
        SortedSet<Meaning> sortedSet13 = this.getMeanings();
        SortedSet<Meaning> sortedSet14 = other.getMeanings();
        if (this$meanings == null ? other$meanings != null : !this$meanings.equals(other$meanings)) {
            return false;
        }
        SortedSet<String> sortedSet15 = this.getPendingTasks();
        SortedSet<String> sortedSet16 = other.getPendingTasks();
        return !(this$pendingTasks == null ? other$pendingTasks != null : !this$pendingTasks.equals(other$pendingTasks));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Asset;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $announcementUpdatedAt = this.getAnnouncementUpdatedAt();
        result = result * 59 + ($announcementUpdatedAt == null ? 43 : ((Object)$announcementUpdatedAt).hashCode());
        Long $assetDbtJobLastRun = this.getAssetDbtJobLastRun();
        result = result * 59 + ($assetDbtJobLastRun == null ? 43 : ((Object)$assetDbtJobLastRun).hashCode());
        Boolean $assetDbtJobLastRunArtifactsSaved = this.getAssetDbtJobLastRunArtifactsSaved();
        result = result * 59 + ($assetDbtJobLastRunArtifactsSaved == null ? 43 : ((Object)$assetDbtJobLastRunArtifactsSaved).hashCode());
        Long $assetDbtJobLastRunCreatedAt = this.getAssetDbtJobLastRunCreatedAt();
        result = result * 59 + ($assetDbtJobLastRunCreatedAt == null ? 43 : ((Object)$assetDbtJobLastRunCreatedAt).hashCode());
        Long $assetDbtJobLastRunDequedAt = this.getAssetDbtJobLastRunDequedAt();
        result = result * 59 + ($assetDbtJobLastRunDequedAt == null ? 43 : ((Object)$assetDbtJobLastRunDequedAt).hashCode());
        Boolean $assetDbtJobLastRunHasDocsGenerated = this.getAssetDbtJobLastRunHasDocsGenerated();
        result = result * 59 + ($assetDbtJobLastRunHasDocsGenerated == null ? 43 : ((Object)$assetDbtJobLastRunHasDocsGenerated).hashCode());
        Boolean $assetDbtJobLastRunHasSourcesGenerated = this.getAssetDbtJobLastRunHasSourcesGenerated();
        result = result * 59 + ($assetDbtJobLastRunHasSourcesGenerated == null ? 43 : ((Object)$assetDbtJobLastRunHasSourcesGenerated).hashCode());
        Boolean $assetDbtJobLastRunNotificationsSent = this.getAssetDbtJobLastRunNotificationsSent();
        result = result * 59 + ($assetDbtJobLastRunNotificationsSent == null ? 43 : ((Object)$assetDbtJobLastRunNotificationsSent).hashCode());
        Long $assetDbtJobLastRunStartedAt = this.getAssetDbtJobLastRunStartedAt();
        result = result * 59 + ($assetDbtJobLastRunStartedAt == null ? 43 : ((Object)$assetDbtJobLastRunStartedAt).hashCode());
        Long $assetDbtJobLastRunUpdatedAt = this.getAssetDbtJobLastRunUpdatedAt();
        result = result * 59 + ($assetDbtJobLastRunUpdatedAt == null ? 43 : ((Object)$assetDbtJobLastRunUpdatedAt).hashCode());
        Long $assetDbtJobNextRun = this.getAssetDbtJobNextRun();
        result = result * 59 + ($assetDbtJobNextRun == null ? 43 : ((Object)$assetDbtJobNextRun).hashCode());
        Long $assetMcLastSyncRunAt = this.getAssetMcLastSyncRunAt();
        result = result * 59 + ($assetMcLastSyncRunAt == null ? 43 : ((Object)$assetMcLastSyncRunAt).hashCode());
        Long $assetSodaCheckCount = this.getAssetSodaCheckCount();
        result = result * 59 + ($assetSodaCheckCount == null ? 43 : ((Object)$assetSodaCheckCount).hashCode());
        Long $assetSodaLastScanAt = this.getAssetSodaLastScanAt();
        result = result * 59 + ($assetSodaLastScanAt == null ? 43 : ((Object)$assetSodaLastScanAt).hashCode());
        Long $assetSodaLastSyncRunAt = this.getAssetSodaLastSyncRunAt();
        result = result * 59 + ($assetSodaLastSyncRunAt == null ? 43 : ((Object)$assetSodaLastSyncRunAt).hashCode());
        Long $certificateUpdatedAt = this.getCertificateUpdatedAt();
        result = result * 59 + ($certificateUpdatedAt == null ? 43 : ((Object)$certificateUpdatedAt).hashCode());
        Boolean $hasLineage = this.getHasLineage();
        result = result * 59 + ($hasLineage == null ? 43 : ((Object)$hasLineage).hashCode());
        Boolean $isDiscoverable = this.getIsDiscoverable();
        result = result * 59 + ($isDiscoverable == null ? 43 : ((Object)$isDiscoverable).hashCode());
        Boolean $isEditable = this.getIsEditable();
        result = result * 59 + ($isEditable == null ? 43 : ((Object)$isEditable).hashCode());
        Long $lastRowChangedAt = this.getLastRowChangedAt();
        result = result * 59 + ($lastRowChangedAt == null ? 43 : ((Object)$lastRowChangedAt).hashCode());
        Long $lastSyncRunAt = this.getLastSyncRunAt();
        result = result * 59 + ($lastSyncRunAt == null ? 43 : ((Object)$lastSyncRunAt).hashCode());
        Double $popularityScore = this.getPopularityScore();
        result = result * 59 + ($popularityScore == null ? 43 : ((Object)$popularityScore).hashCode());
        Long $sourceCreatedAt = this.getSourceCreatedAt();
        result = result * 59 + ($sourceCreatedAt == null ? 43 : ((Object)$sourceCreatedAt).hashCode());
        Long $sourceLastReadAt = this.getSourceLastReadAt();
        result = result * 59 + ($sourceLastReadAt == null ? 43 : ((Object)$sourceLastReadAt).hashCode());
        Long $sourceReadCount = this.getSourceReadCount();
        result = result * 59 + ($sourceReadCount == null ? 43 : ((Object)$sourceReadCount).hashCode());
        Double $sourceReadQueryCost = this.getSourceReadQueryCost();
        result = result * 59 + ($sourceReadQueryCost == null ? 43 : ((Object)$sourceReadQueryCost).hashCode());
        Long $sourceReadUserCount = this.getSourceReadUserCount();
        result = result * 59 + ($sourceReadUserCount == null ? 43 : ((Object)$sourceReadUserCount).hashCode());
        Double $sourceTotalCost = this.getSourceTotalCost();
        result = result * 59 + ($sourceTotalCost == null ? 43 : ((Object)$sourceTotalCost).hashCode());
        Long $sourceUpdatedAt = this.getSourceUpdatedAt();
        result = result * 59 + ($sourceUpdatedAt == null ? 43 : ((Object)$sourceUpdatedAt).hashCode());
        Integer $starredCount = this.getStarredCount();
        result = result * 59 + ($starredCount == null ? 43 : ((Object)$starredCount).hashCode());
        Double $viewScore = this.getViewScore();
        result = result * 59 + ($viewScore == null ? 43 : ((Object)$viewScore).hashCode());
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Long $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Boolean $isIncomplete = this.getIsIncomplete();
        result = result * 59 + ($isIncomplete == null ? 43 : ((Object)$isIncomplete).hashCode());
        SortedSet<String> $adminGroups = this.getAdminGroups();
        result = result * 59 + ($adminGroups == null ? 43 : $adminGroups.hashCode());
        SortedSet<String> $adminRoles = this.getAdminRoles();
        result = result * 59 + ($adminRoles == null ? 43 : $adminRoles.hashCode());
        SortedSet<String> $adminUsers = this.getAdminUsers();
        result = result * 59 + ($adminUsers == null ? 43 : $adminUsers.hashCode());
        String $announcementMessage = this.getAnnouncementMessage();
        result = result * 59 + ($announcementMessage == null ? 43 : $announcementMessage.hashCode());
        String $announcementTitle = this.getAnnouncementTitle();
        result = result * 59 + ($announcementTitle == null ? 43 : $announcementTitle.hashCode());
        AtlanAnnouncementType $announcementType = this.getAnnouncementType();
        result = result * 59 + ($announcementType == null ? 43 : $announcementType.hashCode());
        String $announcementUpdatedBy = this.getAnnouncementUpdatedBy();
        result = result * 59 + ($announcementUpdatedBy == null ? 43 : $announcementUpdatedBy.hashCode());
        String $assetDbtAccountName = this.getAssetDbtAccountName();
        result = result * 59 + ($assetDbtAccountName == null ? 43 : $assetDbtAccountName.hashCode());
        String $assetDbtAlias = this.getAssetDbtAlias();
        result = result * 59 + ($assetDbtAlias == null ? 43 : $assetDbtAlias.hashCode());
        String $assetDbtEnvironmentDbtVersion = this.getAssetDbtEnvironmentDbtVersion();
        result = result * 59 + ($assetDbtEnvironmentDbtVersion == null ? 43 : $assetDbtEnvironmentDbtVersion.hashCode());
        String $assetDbtEnvironmentName = this.getAssetDbtEnvironmentName();
        result = result * 59 + ($assetDbtEnvironmentName == null ? 43 : $assetDbtEnvironmentName.hashCode());
        String $assetDbtJobLastRunArtifactS3Path = this.getAssetDbtJobLastRunArtifactS3Path();
        result = result * 59 + ($assetDbtJobLastRunArtifactS3Path == null ? 43 : $assetDbtJobLastRunArtifactS3Path.hashCode());
        String $assetDbtJobLastRunExecutedByThreadId = this.getAssetDbtJobLastRunExecutedByThreadId();
        result = result * 59 + ($assetDbtJobLastRunExecutedByThreadId == null ? 43 : $assetDbtJobLastRunExecutedByThreadId.hashCode());
        String $assetDbtJobLastRunGitBranch = this.getAssetDbtJobLastRunGitBranch();
        result = result * 59 + ($assetDbtJobLastRunGitBranch == null ? 43 : $assetDbtJobLastRunGitBranch.hashCode());
        String $assetDbtJobLastRunGitSha = this.getAssetDbtJobLastRunGitSha();
        result = result * 59 + ($assetDbtJobLastRunGitSha == null ? 43 : $assetDbtJobLastRunGitSha.hashCode());
        String $assetDbtJobLastRunOwnerThreadId = this.getAssetDbtJobLastRunOwnerThreadId();
        result = result * 59 + ($assetDbtJobLastRunOwnerThreadId == null ? 43 : $assetDbtJobLastRunOwnerThreadId.hashCode());
        String $assetDbtJobLastRunQueuedDuration = this.getAssetDbtJobLastRunQueuedDuration();
        result = result * 59 + ($assetDbtJobLastRunQueuedDuration == null ? 43 : $assetDbtJobLastRunQueuedDuration.hashCode());
        String $assetDbtJobLastRunQueuedDurationHumanized = this.getAssetDbtJobLastRunQueuedDurationHumanized();
        result = result * 59 + ($assetDbtJobLastRunQueuedDurationHumanized == null ? 43 : $assetDbtJobLastRunQueuedDurationHumanized.hashCode());
        String $assetDbtJobLastRunRunDuration = this.getAssetDbtJobLastRunRunDuration();
        result = result * 59 + ($assetDbtJobLastRunRunDuration == null ? 43 : $assetDbtJobLastRunRunDuration.hashCode());
        String $assetDbtJobLastRunRunDurationHumanized = this.getAssetDbtJobLastRunRunDurationHumanized();
        result = result * 59 + ($assetDbtJobLastRunRunDurationHumanized == null ? 43 : $assetDbtJobLastRunRunDurationHumanized.hashCode());
        String $assetDbtJobLastRunStatusMessage = this.getAssetDbtJobLastRunStatusMessage();
        result = result * 59 + ($assetDbtJobLastRunStatusMessage == null ? 43 : $assetDbtJobLastRunStatusMessage.hashCode());
        String $assetDbtJobLastRunTotalDuration = this.getAssetDbtJobLastRunTotalDuration();
        result = result * 59 + ($assetDbtJobLastRunTotalDuration == null ? 43 : $assetDbtJobLastRunTotalDuration.hashCode());
        String $assetDbtJobLastRunTotalDurationHumanized = this.getAssetDbtJobLastRunTotalDurationHumanized();
        result = result * 59 + ($assetDbtJobLastRunTotalDurationHumanized == null ? 43 : $assetDbtJobLastRunTotalDurationHumanized.hashCode());
        String $assetDbtJobLastRunUrl = this.getAssetDbtJobLastRunUrl();
        result = result * 59 + ($assetDbtJobLastRunUrl == null ? 43 : $assetDbtJobLastRunUrl.hashCode());
        String $assetDbtJobName = this.getAssetDbtJobName();
        result = result * 59 + ($assetDbtJobName == null ? 43 : $assetDbtJobName.hashCode());
        String $assetDbtJobNextRunHumanized = this.getAssetDbtJobNextRunHumanized();
        result = result * 59 + ($assetDbtJobNextRunHumanized == null ? 43 : $assetDbtJobNextRunHumanized.hashCode());
        String $assetDbtJobSchedule = this.getAssetDbtJobSchedule();
        result = result * 59 + ($assetDbtJobSchedule == null ? 43 : $assetDbtJobSchedule.hashCode());
        String $assetDbtJobScheduleCronHumanized = this.getAssetDbtJobScheduleCronHumanized();
        result = result * 59 + ($assetDbtJobScheduleCronHumanized == null ? 43 : $assetDbtJobScheduleCronHumanized.hashCode());
        String $assetDbtJobStatus = this.getAssetDbtJobStatus();
        result = result * 59 + ($assetDbtJobStatus == null ? 43 : $assetDbtJobStatus.hashCode());
        String $assetDbtMeta = this.getAssetDbtMeta();
        result = result * 59 + ($assetDbtMeta == null ? 43 : $assetDbtMeta.hashCode());
        String $assetDbtPackageName = this.getAssetDbtPackageName();
        result = result * 59 + ($assetDbtPackageName == null ? 43 : $assetDbtPackageName.hashCode());
        String $assetDbtProjectName = this.getAssetDbtProjectName();
        result = result * 59 + ($assetDbtProjectName == null ? 43 : $assetDbtProjectName.hashCode());
        String $assetDbtSemanticLayerProxyUrl = this.getAssetDbtSemanticLayerProxyUrl();
        result = result * 59 + ($assetDbtSemanticLayerProxyUrl == null ? 43 : $assetDbtSemanticLayerProxyUrl.hashCode());
        String $assetDbtSourceFreshnessCriteria = this.getAssetDbtSourceFreshnessCriteria();
        result = result * 59 + ($assetDbtSourceFreshnessCriteria == null ? 43 : $assetDbtSourceFreshnessCriteria.hashCode());
        SortedSet<String> $assetDbtTags = this.getAssetDbtTags();
        result = result * 59 + ($assetDbtTags == null ? 43 : $assetDbtTags.hashCode());
        String $assetDbtTestStatus = this.getAssetDbtTestStatus();
        result = result * 59 + ($assetDbtTestStatus == null ? 43 : $assetDbtTestStatus.hashCode());
        String $assetDbtUniqueId = this.getAssetDbtUniqueId();
        result = result * 59 + ($assetDbtUniqueId == null ? 43 : $assetDbtUniqueId.hashCode());
        String $assetIcon = this.getAssetIcon();
        result = result * 59 + ($assetIcon == null ? 43 : $assetIcon.hashCode());
        SortedSet<String> $assetMcIncidentNames = this.getAssetMcIncidentNames();
        result = result * 59 + ($assetMcIncidentNames == null ? 43 : $assetMcIncidentNames.hashCode());
        SortedSet<String> $assetMcIncidentQualifiedNames = this.getAssetMcIncidentQualifiedNames();
        result = result * 59 + ($assetMcIncidentQualifiedNames == null ? 43 : $assetMcIncidentQualifiedNames.hashCode());
        SortedSet<String> $assetMcIncidentSeverities = this.getAssetMcIncidentSeverities();
        result = result * 59 + ($assetMcIncidentSeverities == null ? 43 : $assetMcIncidentSeverities.hashCode());
        SortedSet<String> $assetMcIncidentStates = this.getAssetMcIncidentStates();
        result = result * 59 + ($assetMcIncidentStates == null ? 43 : $assetMcIncidentStates.hashCode());
        SortedSet<String> $assetMcIncidentSubTypes = this.getAssetMcIncidentSubTypes();
        result = result * 59 + ($assetMcIncidentSubTypes == null ? 43 : $assetMcIncidentSubTypes.hashCode());
        SortedSet<String> $assetMcIncidentTypes = this.getAssetMcIncidentTypes();
        result = result * 59 + ($assetMcIncidentTypes == null ? 43 : $assetMcIncidentTypes.hashCode());
        SortedSet<String> $assetMcMonitorNames = this.getAssetMcMonitorNames();
        result = result * 59 + ($assetMcMonitorNames == null ? 43 : $assetMcMonitorNames.hashCode());
        SortedSet<String> $assetMcMonitorQualifiedNames = this.getAssetMcMonitorQualifiedNames();
        result = result * 59 + ($assetMcMonitorQualifiedNames == null ? 43 : $assetMcMonitorQualifiedNames.hashCode());
        SortedSet<String> $assetMcMonitorScheduleTypes = this.getAssetMcMonitorScheduleTypes();
        result = result * 59 + ($assetMcMonitorScheduleTypes == null ? 43 : $assetMcMonitorScheduleTypes.hashCode());
        SortedSet<String> $assetMcMonitorStatuses = this.getAssetMcMonitorStatuses();
        result = result * 59 + ($assetMcMonitorStatuses == null ? 43 : $assetMcMonitorStatuses.hashCode());
        SortedSet<String> $assetMcMonitorTypes = this.getAssetMcMonitorTypes();
        result = result * 59 + ($assetMcMonitorTypes == null ? 43 : $assetMcMonitorTypes.hashCode());
        String $assetSodaCheckStatuses = this.getAssetSodaCheckStatuses();
        result = result * 59 + ($assetSodaCheckStatuses == null ? 43 : $assetSodaCheckStatuses.hashCode());
        String $assetSodaDQStatus = this.getAssetSodaDQStatus();
        result = result * 59 + ($assetSodaDQStatus == null ? 43 : $assetSodaDQStatus.hashCode());
        String $assetSodaSourceURL = this.getAssetSodaSourceURL();
        result = result * 59 + ($assetSodaSourceURL == null ? 43 : $assetSodaSourceURL.hashCode());
        SortedSet<String> $assetTags = this.getAssetTags();
        result = result * 59 + ($assetTags == null ? 43 : $assetTags.hashCode());
        SortedSet<IGlossaryTerm> $assignedTerms = this.getAssignedTerms();
        result = result * 59 + ($assignedTerms == null ? 43 : $assignedTerms.hashCode());
        CertificateStatus $certificateStatus = this.getCertificateStatus();
        result = result * 59 + ($certificateStatus == null ? 43 : $certificateStatus.hashCode());
        String $certificateStatusMessage = this.getCertificateStatusMessage();
        result = result * 59 + ($certificateStatusMessage == null ? 43 : $certificateStatusMessage.hashCode());
        String $certificateUpdatedBy = this.getCertificateUpdatedBy();
        result = result * 59 + ($certificateUpdatedBy == null ? 43 : $certificateUpdatedBy.hashCode());
        String $connectionName = this.getConnectionName();
        result = result * 59 + ($connectionName == null ? 43 : $connectionName.hashCode());
        String $connectionQualifiedName = this.getConnectionQualifiedName();
        result = result * 59 + ($connectionQualifiedName == null ? 43 : $connectionQualifiedName.hashCode());
        AtlanConnectorType $connectorType = this.getConnectorType();
        result = result * 59 + ($connectorType == null ? 43 : $connectorType.hashCode());
        String $dbtQualifiedName = this.getDbtQualifiedName();
        result = result * 59 + ($dbtQualifiedName == null ? 43 : $dbtQualifiedName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        SortedSet<IFile> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : $files.hashCode());
        String $lastSyncRun = this.getLastSyncRun();
        result = result * 59 + ($lastSyncRun == null ? 43 : $lastSyncRun.hashCode());
        String $lastSyncWorkflowName = this.getLastSyncWorkflowName();
        result = result * 59 + ($lastSyncWorkflowName == null ? 43 : $lastSyncWorkflowName.hashCode());
        SortedSet<ILink> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : $links.hashCode());
        SortedSet<IMCIncident> $mcIncidents = this.getMcIncidents();
        result = result * 59 + ($mcIncidents == null ? 43 : $mcIncidents.hashCode());
        SortedSet<IMCMonitor> $mcMonitors = this.getMcMonitors();
        result = result * 59 + ($mcMonitors == null ? 43 : $mcMonitors.hashCode());
        SortedSet<IMetric> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        SortedSet<String> $ownerGroups = this.getOwnerGroups();
        result = result * 59 + ($ownerGroups == null ? 43 : $ownerGroups.hashCode());
        SortedSet<String> $ownerUsers = this.getOwnerUsers();
        result = result * 59 + ($ownerUsers == null ? 43 : $ownerUsers.hashCode());
        String $qualifiedName = this.getQualifiedName();
        result = result * 59 + ($qualifiedName == null ? 43 : $qualifiedName.hashCode());
        IReadme $readme = this.getReadme();
        result = result * 59 + ($readme == null ? 43 : $readme.hashCode());
        String $sampleDataUrl = this.getSampleDataUrl();
        result = result * 59 + ($sampleDataUrl == null ? 43 : $sampleDataUrl.hashCode());
        SortedSet<ISchemaRegistrySubject> $schemaRegistrySubjects = this.getSchemaRegistrySubjects();
        result = result * 59 + ($schemaRegistrySubjects == null ? 43 : $schemaRegistrySubjects.hashCode());
        SortedSet<ISodaCheck> $sodaChecks = this.getSodaChecks();
        result = result * 59 + ($sodaChecks == null ? 43 : $sodaChecks.hashCode());
        SourceCostUnitType $sourceCostUnit = this.getSourceCostUnit();
        result = result * 59 + ($sourceCostUnit == null ? 43 : $sourceCostUnit.hashCode());
        String $sourceCreatedBy = this.getSourceCreatedBy();
        result = result * 59 + ($sourceCreatedBy == null ? 43 : $sourceCreatedBy.hashCode());
        String $sourceEmbedURL = this.getSourceEmbedURL();
        result = result * 59 + ($sourceEmbedURL == null ? 43 : $sourceEmbedURL.hashCode());
        String $sourceOwners = this.getSourceOwners();
        result = result * 59 + ($sourceOwners == null ? 43 : $sourceOwners.hashCode());
        List<PopularityInsights> $sourceQueryComputeCostRecords = this.getSourceQueryComputeCostRecords();
        result = result * 59 + ($sourceQueryComputeCostRecords == null ? 43 : ((Object)$sourceQueryComputeCostRecords).hashCode());
        SortedSet<String> $sourceQueryComputeCosts = this.getSourceQueryComputeCosts();
        result = result * 59 + ($sourceQueryComputeCosts == null ? 43 : $sourceQueryComputeCosts.hashCode());
        List<PopularityInsights> $sourceReadExpensiveQueryRecords = this.getSourceReadExpensiveQueryRecords();
        result = result * 59 + ($sourceReadExpensiveQueryRecords == null ? 43 : ((Object)$sourceReadExpensiveQueryRecords).hashCode());
        List<PopularityInsights> $sourceReadPopularQueryRecords = this.getSourceReadPopularQueryRecords();
        result = result * 59 + ($sourceReadPopularQueryRecords == null ? 43 : ((Object)$sourceReadPopularQueryRecords).hashCode());
        List<PopularityInsights> $sourceReadRecentUserRecords = this.getSourceReadRecentUserRecords();
        result = result * 59 + ($sourceReadRecentUserRecords == null ? 43 : ((Object)$sourceReadRecentUserRecords).hashCode());
        SortedSet<String> $sourceReadRecentUsers = this.getSourceReadRecentUsers();
        result = result * 59 + ($sourceReadRecentUsers == null ? 43 : $sourceReadRecentUsers.hashCode());
        List<PopularityInsights> $sourceReadSlowQueryRecords = this.getSourceReadSlowQueryRecords();
        result = result * 59 + ($sourceReadSlowQueryRecords == null ? 43 : ((Object)$sourceReadSlowQueryRecords).hashCode());
        List<PopularityInsights> $sourceReadTopUserRecords = this.getSourceReadTopUserRecords();
        result = result * 59 + ($sourceReadTopUserRecords == null ? 43 : ((Object)$sourceReadTopUserRecords).hashCode());
        SortedSet<String> $sourceReadTopUsers = this.getSourceReadTopUsers();
        result = result * 59 + ($sourceReadTopUsers == null ? 43 : $sourceReadTopUsers.hashCode());
        String $sourceURL = this.getSourceURL();
        result = result * 59 + ($sourceURL == null ? 43 : $sourceURL.hashCode());
        String $sourceUpdatedBy = this.getSourceUpdatedBy();
        result = result * 59 + ($sourceUpdatedBy == null ? 43 : $sourceUpdatedBy.hashCode());
        SortedSet<String> $starredBy = this.getStarredBy();
        result = result * 59 + ($starredBy == null ? 43 : $starredBy.hashCode());
        List<StarredDetails> $starredDetails = this.getStarredDetails();
        result = result * 59 + ($starredDetails == null ? 43 : ((Object)$starredDetails).hashCode());
        String $subType = this.getSubType();
        result = result * 59 + ($subType == null ? 43 : $subType.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $userDescription = this.getUserDescription();
        result = result * 59 + ($userDescription == null ? 43 : $userDescription.hashCode());
        SortedSet<String> $viewerGroups = this.getViewerGroups();
        result = result * 59 + ($viewerGroups == null ? 43 : $viewerGroups.hashCode());
        SortedSet<String> $viewerUsers = this.getViewerUsers();
        result = result * 59 + ($viewerUsers == null ? 43 : $viewerUsers.hashCode());
        SortedSet<AtlanTag> $atlanTags = this.getAtlanTags();
        result = result * 59 + ($atlanTags == null ? 43 : $atlanTags.hashCode());
        Map<String, CustomMetadataAttributes> $customMetadataSets = this.getCustomMetadataSets();
        result = result * 59 + ($customMetadataSets == null ? 43 : ((Object)$customMetadataSets).hashCode());
        AtlanStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        String $deleteHandler = this.getDeleteHandler();
        result = result * 59 + ($deleteHandler == null ? 43 : $deleteHandler.hashCode());
        SortedSet<String> $atlanTagNames = this.getAtlanTagNames();
        result = result * 59 + ($atlanTagNames == null ? 43 : $atlanTagNames.hashCode());
        SortedSet<String> $meaningNames = this.getMeaningNames();
        result = result * 59 + ($meaningNames == null ? 43 : $meaningNames.hashCode());
        SortedSet<Meaning> $meanings = this.getMeanings();
        result = result * 59 + ($meanings == null ? 43 : $meanings.hashCode());
        SortedSet<String> $pendingTasks = this.getPendingTasks();
        result = result * 59 + ($pendingTasks == null ? 43 : $pendingTasks.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Asset(super=" + super.toString() + ", adminGroups=" + this.getAdminGroups() + ", adminRoles=" + this.getAdminRoles() + ", adminUsers=" + this.getAdminUsers() + ", announcementMessage=" + this.getAnnouncementMessage() + ", announcementTitle=" + this.getAnnouncementTitle() + ", announcementType=" + this.getAnnouncementType() + ", announcementUpdatedAt=" + this.getAnnouncementUpdatedAt() + ", announcementUpdatedBy=" + this.getAnnouncementUpdatedBy() + ", assetDbtAccountName=" + this.getAssetDbtAccountName() + ", assetDbtAlias=" + this.getAssetDbtAlias() + ", assetDbtEnvironmentDbtVersion=" + this.getAssetDbtEnvironmentDbtVersion() + ", assetDbtEnvironmentName=" + this.getAssetDbtEnvironmentName() + ", assetDbtJobLastRun=" + this.getAssetDbtJobLastRun() + ", assetDbtJobLastRunArtifactS3Path=" + this.getAssetDbtJobLastRunArtifactS3Path() + ", assetDbtJobLastRunArtifactsSaved=" + this.getAssetDbtJobLastRunArtifactsSaved() + ", assetDbtJobLastRunCreatedAt=" + this.getAssetDbtJobLastRunCreatedAt() + ", assetDbtJobLastRunDequedAt=" + this.getAssetDbtJobLastRunDequedAt() + ", assetDbtJobLastRunExecutedByThreadId=" + this.getAssetDbtJobLastRunExecutedByThreadId() + ", assetDbtJobLastRunGitBranch=" + this.getAssetDbtJobLastRunGitBranch() + ", assetDbtJobLastRunGitSha=" + this.getAssetDbtJobLastRunGitSha() + ", assetDbtJobLastRunHasDocsGenerated=" + this.getAssetDbtJobLastRunHasDocsGenerated() + ", assetDbtJobLastRunHasSourcesGenerated=" + this.getAssetDbtJobLastRunHasSourcesGenerated() + ", assetDbtJobLastRunNotificationsSent=" + this.getAssetDbtJobLastRunNotificationsSent() + ", assetDbtJobLastRunOwnerThreadId=" + this.getAssetDbtJobLastRunOwnerThreadId() + ", assetDbtJobLastRunQueuedDuration=" + this.getAssetDbtJobLastRunQueuedDuration() + ", assetDbtJobLastRunQueuedDurationHumanized=" + this.getAssetDbtJobLastRunQueuedDurationHumanized() + ", assetDbtJobLastRunRunDuration=" + this.getAssetDbtJobLastRunRunDuration() + ", assetDbtJobLastRunRunDurationHumanized=" + this.getAssetDbtJobLastRunRunDurationHumanized() + ", assetDbtJobLastRunStartedAt=" + this.getAssetDbtJobLastRunStartedAt() + ", assetDbtJobLastRunStatusMessage=" + this.getAssetDbtJobLastRunStatusMessage() + ", assetDbtJobLastRunTotalDuration=" + this.getAssetDbtJobLastRunTotalDuration() + ", assetDbtJobLastRunTotalDurationHumanized=" + this.getAssetDbtJobLastRunTotalDurationHumanized() + ", assetDbtJobLastRunUpdatedAt=" + this.getAssetDbtJobLastRunUpdatedAt() + ", assetDbtJobLastRunUrl=" + this.getAssetDbtJobLastRunUrl() + ", assetDbtJobName=" + this.getAssetDbtJobName() + ", assetDbtJobNextRun=" + this.getAssetDbtJobNextRun() + ", assetDbtJobNextRunHumanized=" + this.getAssetDbtJobNextRunHumanized() + ", assetDbtJobSchedule=" + this.getAssetDbtJobSchedule() + ", assetDbtJobScheduleCronHumanized=" + this.getAssetDbtJobScheduleCronHumanized() + ", assetDbtJobStatus=" + this.getAssetDbtJobStatus() + ", assetDbtMeta=" + this.getAssetDbtMeta() + ", assetDbtPackageName=" + this.getAssetDbtPackageName() + ", assetDbtProjectName=" + this.getAssetDbtProjectName() + ", assetDbtSemanticLayerProxyUrl=" + this.getAssetDbtSemanticLayerProxyUrl() + ", assetDbtSourceFreshnessCriteria=" + this.getAssetDbtSourceFreshnessCriteria() + ", assetDbtTags=" + this.getAssetDbtTags() + ", assetDbtTestStatus=" + this.getAssetDbtTestStatus() + ", assetDbtUniqueId=" + this.getAssetDbtUniqueId() + ", assetIcon=" + this.getAssetIcon() + ", assetMcIncidentNames=" + this.getAssetMcIncidentNames() + ", assetMcIncidentQualifiedNames=" + this.getAssetMcIncidentQualifiedNames() + ", assetMcIncidentSeverities=" + this.getAssetMcIncidentSeverities() + ", assetMcIncidentStates=" + this.getAssetMcIncidentStates() + ", assetMcIncidentSubTypes=" + this.getAssetMcIncidentSubTypes() + ", assetMcIncidentTypes=" + this.getAssetMcIncidentTypes() + ", assetMcLastSyncRunAt=" + this.getAssetMcLastSyncRunAt() + ", assetMcMonitorNames=" + this.getAssetMcMonitorNames() + ", assetMcMonitorQualifiedNames=" + this.getAssetMcMonitorQualifiedNames() + ", assetMcMonitorScheduleTypes=" + this.getAssetMcMonitorScheduleTypes() + ", assetMcMonitorStatuses=" + this.getAssetMcMonitorStatuses() + ", assetMcMonitorTypes=" + this.getAssetMcMonitorTypes() + ", assetSodaCheckCount=" + this.getAssetSodaCheckCount() + ", assetSodaCheckStatuses=" + this.getAssetSodaCheckStatuses() + ", assetSodaDQStatus=" + this.getAssetSodaDQStatus() + ", assetSodaLastScanAt=" + this.getAssetSodaLastScanAt() + ", assetSodaLastSyncRunAt=" + this.getAssetSodaLastSyncRunAt() + ", assetSodaSourceURL=" + this.getAssetSodaSourceURL() + ", assetTags=" + this.getAssetTags() + ", assignedTerms=" + this.getAssignedTerms() + ", certificateStatus=" + this.getCertificateStatus() + ", certificateStatusMessage=" + this.getCertificateStatusMessage() + ", certificateUpdatedAt=" + this.getCertificateUpdatedAt() + ", certificateUpdatedBy=" + this.getCertificateUpdatedBy() + ", connectionName=" + this.getConnectionName() + ", connectionQualifiedName=" + this.getConnectionQualifiedName() + ", connectorType=" + this.getConnectorType() + ", dbtQualifiedName=" + this.getDbtQualifiedName() + ", description=" + this.getDescription() + ", displayName=" + this.getDisplayName() + ", files=" + this.getFiles() + ", hasLineage=" + this.getHasLineage() + ", isDiscoverable=" + this.getIsDiscoverable() + ", isEditable=" + this.getIsEditable() + ", lastRowChangedAt=" + this.getLastRowChangedAt() + ", lastSyncRun=" + this.getLastSyncRun() + ", lastSyncRunAt=" + this.getLastSyncRunAt() + ", lastSyncWorkflowName=" + this.getLastSyncWorkflowName() + ", links=" + this.getLinks() + ", mcIncidents=" + this.getMcIncidents() + ", mcMonitors=" + this.getMcMonitors() + ", metrics=" + this.getMetrics() + ", name=" + this.getName() + ", ownerGroups=" + this.getOwnerGroups() + ", ownerUsers=" + this.getOwnerUsers() + ", popularityScore=" + this.getPopularityScore() + ", qualifiedName=" + this.getQualifiedName() + ", readme=" + this.getReadme() + ", sampleDataUrl=" + this.getSampleDataUrl() + ", schemaRegistrySubjects=" + (this.getSchemaRegistrySubjects() + ", sodaChecks=" + this.getSodaChecks() + ", sourceCostUnit=" + this.getSourceCostUnit() + ", sourceCreatedAt=" + this.getSourceCreatedAt() + ", sourceCreatedBy=" + this.getSourceCreatedBy() + ", sourceEmbedURL=" + this.getSourceEmbedURL() + ", sourceLastReadAt=" + this.getSourceLastReadAt() + ", sourceOwners=" + this.getSourceOwners() + ", sourceQueryComputeCostRecords=" + this.getSourceQueryComputeCostRecords() + ", sourceQueryComputeCosts=" + this.getSourceQueryComputeCosts() + ", sourceReadCount=" + this.getSourceReadCount() + ", sourceReadExpensiveQueryRecords=" + this.getSourceReadExpensiveQueryRecords() + ", sourceReadPopularQueryRecords=" + this.getSourceReadPopularQueryRecords() + ", sourceReadQueryCost=" + this.getSourceReadQueryCost() + ", sourceReadRecentUserRecords=" + this.getSourceReadRecentUserRecords() + ", sourceReadRecentUsers=" + this.getSourceReadRecentUsers() + ", sourceReadSlowQueryRecords=" + this.getSourceReadSlowQueryRecords() + ", sourceReadTopUserRecords=" + this.getSourceReadTopUserRecords() + ", sourceReadTopUsers=" + this.getSourceReadTopUsers() + ", sourceReadUserCount=" + this.getSourceReadUserCount() + ", sourceTotalCost=" + this.getSourceTotalCost() + ", sourceURL=" + this.getSourceURL() + ", sourceUpdatedAt=" + this.getSourceUpdatedAt() + ", sourceUpdatedBy=" + this.getSourceUpdatedBy() + ", starredBy=" + this.getStarredBy() + ", starredCount=" + this.getStarredCount() + ", starredDetails=" + this.getStarredDetails() + ", subType=" + this.getSubType() + ", tenantId=" + this.getTenantId() + ", userDescription=" + this.getUserDescription() + ", viewScore=" + this.getViewScore() + ", viewerGroups=" + this.getViewerGroups() + ", viewerUsers=" + this.getViewerUsers() + ", nullFields=" + this.getNullFields() + ", atlanTags=" + this.getAtlanTags() + ", customMetadataSets=" + this.getCustomMetadataSets() + ", status=" + this.getStatus() + ", createdBy=" + this.getCreatedBy() + ", updatedBy=" + this.getUpdatedBy() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", deleteHandler=" + this.getDeleteHandler() + ", atlanTagNames=" + this.getAtlanTagNames() + ", isIncomplete=" + this.getIsIncomplete() + ", meaningNames=" + this.getMeaningNames() + ", meanings=" + this.getMeanings() + ", pendingTasks=" + this.getPendingTasks() + ")");
    }

    public static abstract class AssetBuilder<C extends Asset, B extends AssetBuilder<C, B>>
    extends Reference.ReferenceBuilder<C, B> {
        @Generated
        private ArrayList<String> adminGroups;
        @Generated
        private ArrayList<String> adminRoles;
        @Generated
        private ArrayList<String> adminUsers;
        @Generated
        private String announcementMessage;
        @Generated
        private String announcementTitle;
        @Generated
        private AtlanAnnouncementType announcementType;
        @Generated
        private Long announcementUpdatedAt;
        @Generated
        private String announcementUpdatedBy;
        @Generated
        private String assetDbtAccountName;
        @Generated
        private String assetDbtAlias;
        @Generated
        private String assetDbtEnvironmentDbtVersion;
        @Generated
        private String assetDbtEnvironmentName;
        @Generated
        private Long assetDbtJobLastRun;
        @Generated
        private String assetDbtJobLastRunArtifactS3Path;
        @Generated
        private Boolean assetDbtJobLastRunArtifactsSaved;
        @Generated
        private Long assetDbtJobLastRunCreatedAt;
        @Generated
        private Long assetDbtJobLastRunDequedAt;
        @Generated
        private String assetDbtJobLastRunExecutedByThreadId;
        @Generated
        private String assetDbtJobLastRunGitBranch;
        @Generated
        private String assetDbtJobLastRunGitSha;
        @Generated
        private Boolean assetDbtJobLastRunHasDocsGenerated;
        @Generated
        private Boolean assetDbtJobLastRunHasSourcesGenerated;
        @Generated
        private Boolean assetDbtJobLastRunNotificationsSent;
        @Generated
        private String assetDbtJobLastRunOwnerThreadId;
        @Generated
        private String assetDbtJobLastRunQueuedDuration;
        @Generated
        private String assetDbtJobLastRunQueuedDurationHumanized;
        @Generated
        private String assetDbtJobLastRunRunDuration;
        @Generated
        private String assetDbtJobLastRunRunDurationHumanized;
        @Generated
        private Long assetDbtJobLastRunStartedAt;
        @Generated
        private String assetDbtJobLastRunStatusMessage;
        @Generated
        private String assetDbtJobLastRunTotalDuration;
        @Generated
        private String assetDbtJobLastRunTotalDurationHumanized;
        @Generated
        private Long assetDbtJobLastRunUpdatedAt;
        @Generated
        private String assetDbtJobLastRunUrl;
        @Generated
        private String assetDbtJobName;
        @Generated
        private Long assetDbtJobNextRun;
        @Generated
        private String assetDbtJobNextRunHumanized;
        @Generated
        private String assetDbtJobSchedule;
        @Generated
        private String assetDbtJobScheduleCronHumanized;
        @Generated
        private String assetDbtJobStatus;
        @Generated
        private String assetDbtMeta;
        @Generated
        private String assetDbtPackageName;
        @Generated
        private String assetDbtProjectName;
        @Generated
        private String assetDbtSemanticLayerProxyUrl;
        @Generated
        private String assetDbtSourceFreshnessCriteria;
        @Generated
        private ArrayList<String> assetDbtTags;
        @Generated
        private String assetDbtTestStatus;
        @Generated
        private String assetDbtUniqueId;
        @Generated
        private String assetIcon;
        @Generated
        private ArrayList<String> assetMcIncidentNames;
        @Generated
        private ArrayList<String> assetMcIncidentQualifiedNames;
        @Generated
        private ArrayList<String> assetMcIncidentSeverities;
        @Generated
        private ArrayList<String> assetMcIncidentStates;
        @Generated
        private ArrayList<String> assetMcIncidentSubTypes;
        @Generated
        private ArrayList<String> assetMcIncidentTypes;
        @Generated
        private Long assetMcLastSyncRunAt;
        @Generated
        private ArrayList<String> assetMcMonitorNames;
        @Generated
        private ArrayList<String> assetMcMonitorQualifiedNames;
        @Generated
        private ArrayList<String> assetMcMonitorScheduleTypes;
        @Generated
        private ArrayList<String> assetMcMonitorStatuses;
        @Generated
        private ArrayList<String> assetMcMonitorTypes;
        @Generated
        private Long assetSodaCheckCount;
        @Generated
        private String assetSodaCheckStatuses;
        @Generated
        private String assetSodaDQStatus;
        @Generated
        private Long assetSodaLastScanAt;
        @Generated
        private Long assetSodaLastSyncRunAt;
        @Generated
        private String assetSodaSourceURL;
        @Generated
        private ArrayList<String> assetTags;
        @Generated
        private ArrayList<IGlossaryTerm> assignedTerms;
        @Generated
        private CertificateStatus certificateStatus;
        @Generated
        private String certificateStatusMessage;
        @Generated
        private Long certificateUpdatedAt;
        @Generated
        private String certificateUpdatedBy;
        @Generated
        private String connectionName;
        @Generated
        private String connectionQualifiedName;
        @Generated
        private AtlanConnectorType connectorType;
        @Generated
        private String dbtQualifiedName;
        @Generated
        private String description;
        @Generated
        private String displayName;
        @Generated
        private ArrayList<IFile> files;
        @Generated
        private Boolean hasLineage;
        @Generated
        private Boolean isDiscoverable;
        @Generated
        private Boolean isEditable;
        @Generated
        private Long lastRowChangedAt;
        @Generated
        private String lastSyncRun;
        @Generated
        private Long lastSyncRunAt;
        @Generated
        private String lastSyncWorkflowName;
        @Generated
        private ArrayList<ILink> links;
        @Generated
        private ArrayList<IMCIncident> mcIncidents;
        @Generated
        private ArrayList<IMCMonitor> mcMonitors;
        @Generated
        private ArrayList<IMetric> metrics;
        @Generated
        private String name;
        @Generated
        private ArrayList<String> ownerGroups;
        @Generated
        private ArrayList<String> ownerUsers;
        @Generated
        private Double popularityScore;
        @Generated
        private String qualifiedName;
        @Generated
        private IReadme readme;
        @Generated
        private String sampleDataUrl;
        @Generated
        private ArrayList<ISchemaRegistrySubject> schemaRegistrySubjects;
        @Generated
        private ArrayList<ISodaCheck> sodaChecks;
        @Generated
        private SourceCostUnitType sourceCostUnit;
        @Generated
        private Long sourceCreatedAt;
        @Generated
        private String sourceCreatedBy;
        @Generated
        private String sourceEmbedURL;
        @Generated
        private Long sourceLastReadAt;
        @Generated
        private String sourceOwners;
        @Generated
        private ArrayList<PopularityInsights> sourceQueryComputeCostRecords;
        @Generated
        private ArrayList<String> sourceQueryComputeCosts;
        @Generated
        private Long sourceReadCount;
        @Generated
        private ArrayList<PopularityInsights> sourceReadExpensiveQueryRecords;
        @Generated
        private ArrayList<PopularityInsights> sourceReadPopularQueryRecords;
        @Generated
        private Double sourceReadQueryCost;
        @Generated
        private ArrayList<PopularityInsights> sourceReadRecentUserRecords;
        @Generated
        private ArrayList<String> sourceReadRecentUsers;
        @Generated
        private ArrayList<PopularityInsights> sourceReadSlowQueryRecords;
        @Generated
        private ArrayList<PopularityInsights> sourceReadTopUserRecords;
        @Generated
        private ArrayList<String> sourceReadTopUsers;
        @Generated
        private Long sourceReadUserCount;
        @Generated
        private Double sourceTotalCost;
        @Generated
        private String sourceURL;
        @Generated
        private Long sourceUpdatedAt;
        @Generated
        private String sourceUpdatedBy;
        @Generated
        private ArrayList<String> starredBy;
        @Generated
        private Integer starredCount;
        @Generated
        private ArrayList<StarredDetails> starredDetails;
        @Generated
        private String subType;
        @Generated
        private String tenantId;
        @Generated
        private String userDescription;
        @Generated
        private Double viewScore;
        @Generated
        private ArrayList<String> viewerGroups;
        @Generated
        private ArrayList<String> viewerUsers;
        @Generated
        private ArrayList<String> nullFields;
        @Generated
        private ArrayList<AtlanTag> atlanTags;
        @Generated
        private ArrayList<String> customMetadataSets$key;
        @Generated
        private ArrayList<CustomMetadataAttributes> customMetadataSets$value;
        @Generated
        private AtlanStatus status;
        @Generated
        private String createdBy;
        @Generated
        private String updatedBy;
        @Generated
        private Long createTime;
        @Generated
        private Long updateTime;
        @Generated
        private String deleteHandler;
        @Generated
        private ArrayList<String> atlanTagNames;
        @Generated
        private Boolean isIncomplete;
        @Generated
        private ArrayList<String> meaningNames;
        @Generated
        private ArrayList<Meaning> meanings;
        @Generated
        private ArrayList<String> pendingTasks;

        public B removeAnnouncement() {
            this.nullField("announcementType");
            this.nullField("announcementTitle");
            this.nullField("announcementMessage");
            return (B)this.self();
        }

        public B removeCustomMetadata() {
            this.clearCustomMetadataSets();
            return (B)this.self();
        }

        public B removeAtlanTags() {
            this.clearAtlanTags();
            this.clearAtlanTagNames();
            return (B)this.self();
        }

        public B removeDescription() {
            this.nullField("description");
            return (B)this.self();
        }

        public B removeUserDescription() {
            this.nullField("userDescription");
            return (B)this.self();
        }

        public B removeOwners() {
            this.nullField("ownerUsers");
            this.nullField("ownerGroups");
            return (B)this.self();
        }

        public B removeCertificate() {
            this.nullField("certificateStatus");
            this.nullField("certificateStatusMessage");
            return (B)this.self();
        }

        public B removeAssignedTerms() {
            this.nullField("assignedTerms");
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AssetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Asset instance, AssetBuilder<?, ?> b) {
            b.adminGroups(instance.adminGroups == null ? Collections.emptySortedSet() : instance.adminGroups);
            b.adminRoles(instance.adminRoles == null ? Collections.emptySortedSet() : instance.adminRoles);
            b.adminUsers(instance.adminUsers == null ? Collections.emptySortedSet() : instance.adminUsers);
            b.announcementMessage(instance.announcementMessage);
            b.announcementTitle(instance.announcementTitle);
            b.announcementType(instance.announcementType);
            b.announcementUpdatedAt(instance.announcementUpdatedAt);
            b.announcementUpdatedBy(instance.announcementUpdatedBy);
            b.assetDbtAccountName(instance.assetDbtAccountName);
            b.assetDbtAlias(instance.assetDbtAlias);
            b.assetDbtEnvironmentDbtVersion(instance.assetDbtEnvironmentDbtVersion);
            b.assetDbtEnvironmentName(instance.assetDbtEnvironmentName);
            b.assetDbtJobLastRun(instance.assetDbtJobLastRun);
            b.assetDbtJobLastRunArtifactS3Path(instance.assetDbtJobLastRunArtifactS3Path);
            b.assetDbtJobLastRunArtifactsSaved(instance.assetDbtJobLastRunArtifactsSaved);
            b.assetDbtJobLastRunCreatedAt(instance.assetDbtJobLastRunCreatedAt);
            b.assetDbtJobLastRunDequedAt(instance.assetDbtJobLastRunDequedAt);
            b.assetDbtJobLastRunExecutedByThreadId(instance.assetDbtJobLastRunExecutedByThreadId);
            b.assetDbtJobLastRunGitBranch(instance.assetDbtJobLastRunGitBranch);
            b.assetDbtJobLastRunGitSha(instance.assetDbtJobLastRunGitSha);
            b.assetDbtJobLastRunHasDocsGenerated(instance.assetDbtJobLastRunHasDocsGenerated);
            b.assetDbtJobLastRunHasSourcesGenerated(instance.assetDbtJobLastRunHasSourcesGenerated);
            b.assetDbtJobLastRunNotificationsSent(instance.assetDbtJobLastRunNotificationsSent);
            b.assetDbtJobLastRunOwnerThreadId(instance.assetDbtJobLastRunOwnerThreadId);
            b.assetDbtJobLastRunQueuedDuration(instance.assetDbtJobLastRunQueuedDuration);
            b.assetDbtJobLastRunQueuedDurationHumanized(instance.assetDbtJobLastRunQueuedDurationHumanized);
            b.assetDbtJobLastRunRunDuration(instance.assetDbtJobLastRunRunDuration);
            b.assetDbtJobLastRunRunDurationHumanized(instance.assetDbtJobLastRunRunDurationHumanized);
            b.assetDbtJobLastRunStartedAt(instance.assetDbtJobLastRunStartedAt);
            b.assetDbtJobLastRunStatusMessage(instance.assetDbtJobLastRunStatusMessage);
            b.assetDbtJobLastRunTotalDuration(instance.assetDbtJobLastRunTotalDuration);
            b.assetDbtJobLastRunTotalDurationHumanized(instance.assetDbtJobLastRunTotalDurationHumanized);
            b.assetDbtJobLastRunUpdatedAt(instance.assetDbtJobLastRunUpdatedAt);
            b.assetDbtJobLastRunUrl(instance.assetDbtJobLastRunUrl);
            b.assetDbtJobName(instance.assetDbtJobName);
            b.assetDbtJobNextRun(instance.assetDbtJobNextRun);
            b.assetDbtJobNextRunHumanized(instance.assetDbtJobNextRunHumanized);
            b.assetDbtJobSchedule(instance.assetDbtJobSchedule);
            b.assetDbtJobScheduleCronHumanized(instance.assetDbtJobScheduleCronHumanized);
            b.assetDbtJobStatus(instance.assetDbtJobStatus);
            b.assetDbtMeta(instance.assetDbtMeta);
            b.assetDbtPackageName(instance.assetDbtPackageName);
            b.assetDbtProjectName(instance.assetDbtProjectName);
            b.assetDbtSemanticLayerProxyUrl(instance.assetDbtSemanticLayerProxyUrl);
            b.assetDbtSourceFreshnessCriteria(instance.assetDbtSourceFreshnessCriteria);
            b.assetDbtTags(instance.assetDbtTags == null ? Collections.emptySortedSet() : instance.assetDbtTags);
            b.assetDbtTestStatus(instance.assetDbtTestStatus);
            b.assetDbtUniqueId(instance.assetDbtUniqueId);
            b.assetIcon(instance.assetIcon);
            b.assetMcIncidentNames(instance.assetMcIncidentNames == null ? Collections.emptySortedSet() : instance.assetMcIncidentNames);
            b.assetMcIncidentQualifiedNames(instance.assetMcIncidentQualifiedNames == null ? Collections.emptySortedSet() : instance.assetMcIncidentQualifiedNames);
            b.assetMcIncidentSeverities(instance.assetMcIncidentSeverities == null ? Collections.emptySortedSet() : instance.assetMcIncidentSeverities);
            b.assetMcIncidentStates(instance.assetMcIncidentStates == null ? Collections.emptySortedSet() : instance.assetMcIncidentStates);
            b.assetMcIncidentSubTypes(instance.assetMcIncidentSubTypes == null ? Collections.emptySortedSet() : instance.assetMcIncidentSubTypes);
            b.assetMcIncidentTypes(instance.assetMcIncidentTypes == null ? Collections.emptySortedSet() : instance.assetMcIncidentTypes);
            b.assetMcLastSyncRunAt(instance.assetMcLastSyncRunAt);
            b.assetMcMonitorNames(instance.assetMcMonitorNames == null ? Collections.emptySortedSet() : instance.assetMcMonitorNames);
            b.assetMcMonitorQualifiedNames(instance.assetMcMonitorQualifiedNames == null ? Collections.emptySortedSet() : instance.assetMcMonitorQualifiedNames);
            b.assetMcMonitorScheduleTypes(instance.assetMcMonitorScheduleTypes == null ? Collections.emptySortedSet() : instance.assetMcMonitorScheduleTypes);
            b.assetMcMonitorStatuses(instance.assetMcMonitorStatuses == null ? Collections.emptySortedSet() : instance.assetMcMonitorStatuses);
            b.assetMcMonitorTypes(instance.assetMcMonitorTypes == null ? Collections.emptySortedSet() : instance.assetMcMonitorTypes);
            b.assetSodaCheckCount(instance.assetSodaCheckCount);
            b.assetSodaCheckStatuses(instance.assetSodaCheckStatuses);
            b.assetSodaDQStatus(instance.assetSodaDQStatus);
            b.assetSodaLastScanAt(instance.assetSodaLastScanAt);
            b.assetSodaLastSyncRunAt(instance.assetSodaLastSyncRunAt);
            b.assetSodaSourceURL(instance.assetSodaSourceURL);
            b.assetTags(instance.assetTags == null ? Collections.emptySortedSet() : instance.assetTags);
            b.assignedTerms(instance.assignedTerms == null ? Collections.emptySortedSet() : instance.assignedTerms);
            b.certificateStatus(instance.certificateStatus);
            b.certificateStatusMessage(instance.certificateStatusMessage);
            b.certificateUpdatedAt(instance.certificateUpdatedAt);
            b.certificateUpdatedBy(instance.certificateUpdatedBy);
            b.connectionName(instance.connectionName);
            b.connectionQualifiedName(instance.connectionQualifiedName);
            b.connectorType(instance.connectorType);
            b.dbtQualifiedName(instance.dbtQualifiedName);
            b.description(instance.description);
            b.displayName(instance.displayName);
            b.files(instance.files == null ? Collections.emptySortedSet() : instance.files);
            b.hasLineage(instance.hasLineage);
            b.isDiscoverable(instance.isDiscoverable);
            b.isEditable(instance.isEditable);
            b.lastRowChangedAt(instance.lastRowChangedAt);
            b.lastSyncRun(instance.lastSyncRun);
            b.lastSyncRunAt(instance.lastSyncRunAt);
            b.lastSyncWorkflowName(instance.lastSyncWorkflowName);
            b.links(instance.links == null ? Collections.emptySortedSet() : instance.links);
            b.mcIncidents(instance.mcIncidents == null ? Collections.emptySortedSet() : instance.mcIncidents);
            b.mcMonitors(instance.mcMonitors == null ? Collections.emptySortedSet() : instance.mcMonitors);
            b.metrics(instance.metrics == null ? Collections.emptySortedSet() : instance.metrics);
            b.name(instance.name);
            b.ownerGroups(instance.ownerGroups == null ? Collections.emptySortedSet() : instance.ownerGroups);
            b.ownerUsers(instance.ownerUsers == null ? Collections.emptySortedSet() : instance.ownerUsers);
            b.popularityScore(instance.popularityScore);
            b.qualifiedName(instance.qualifiedName);
            b.readme(instance.readme);
            b.sampleDataUrl(instance.sampleDataUrl);
            b.schemaRegistrySubjects(instance.schemaRegistrySubjects == null ? Collections.emptySortedSet() : instance.schemaRegistrySubjects);
            b.sodaChecks(instance.sodaChecks == null ? Collections.emptySortedSet() : instance.sodaChecks);
            b.sourceCostUnit(instance.sourceCostUnit);
            b.sourceCreatedAt(instance.sourceCreatedAt);
            b.sourceCreatedBy(instance.sourceCreatedBy);
            b.sourceEmbedURL(instance.sourceEmbedURL);
            b.sourceLastReadAt(instance.sourceLastReadAt);
            b.sourceOwners(instance.sourceOwners);
            b.sourceQueryComputeCostRecords(instance.sourceQueryComputeCostRecords == null ? Collections.emptyList() : instance.sourceQueryComputeCostRecords);
            b.sourceQueryComputeCosts(instance.sourceQueryComputeCosts == null ? Collections.emptySortedSet() : instance.sourceQueryComputeCosts);
            b.sourceReadCount(instance.sourceReadCount);
            b.sourceReadExpensiveQueryRecords(instance.sourceReadExpensiveQueryRecords == null ? Collections.emptyList() : instance.sourceReadExpensiveQueryRecords);
            b.sourceReadPopularQueryRecords(instance.sourceReadPopularQueryRecords == null ? Collections.emptyList() : instance.sourceReadPopularQueryRecords);
            b.sourceReadQueryCost(instance.sourceReadQueryCost);
            b.sourceReadRecentUserRecords(instance.sourceReadRecentUserRecords == null ? Collections.emptyList() : instance.sourceReadRecentUserRecords);
            b.sourceReadRecentUsers(instance.sourceReadRecentUsers == null ? Collections.emptySortedSet() : instance.sourceReadRecentUsers);
            b.sourceReadSlowQueryRecords(instance.sourceReadSlowQueryRecords == null ? Collections.emptyList() : instance.sourceReadSlowQueryRecords);
            b.sourceReadTopUserRecords(instance.sourceReadTopUserRecords == null ? Collections.emptyList() : instance.sourceReadTopUserRecords);
            b.sourceReadTopUsers(instance.sourceReadTopUsers == null ? Collections.emptySortedSet() : instance.sourceReadTopUsers);
            b.sourceReadUserCount(instance.sourceReadUserCount);
            b.sourceTotalCost(instance.sourceTotalCost);
            b.sourceURL(instance.sourceURL);
            b.sourceUpdatedAt(instance.sourceUpdatedAt);
            b.sourceUpdatedBy(instance.sourceUpdatedBy);
            b.starredBy(instance.starredBy == null ? Collections.emptySortedSet() : instance.starredBy);
            b.starredCount(instance.starredCount);
            b.starredDetails(instance.starredDetails == null ? Collections.emptyList() : instance.starredDetails);
            b.subType(instance.subType);
            b.tenantId(instance.tenantId);
            b.userDescription(instance.userDescription);
            b.viewScore(instance.viewScore);
            b.viewerGroups(instance.viewerGroups == null ? Collections.emptySortedSet() : instance.viewerGroups);
            b.viewerUsers(instance.viewerUsers == null ? Collections.emptySortedSet() : instance.viewerUsers);
            b.nullFields(instance.nullFields == null ? Collections.emptySet() : instance.nullFields);
            b.atlanTags(instance.atlanTags == null ? Collections.emptySortedSet() : instance.atlanTags);
            b.customMetadataSets(instance.customMetadataSets == null ? Collections.emptyMap() : instance.customMetadataSets);
            b.status(instance.status);
            b.createdBy(instance.createdBy);
            b.updatedBy(instance.updatedBy);
            b.createTime(instance.createTime);
            b.updateTime(instance.updateTime);
            b.deleteHandler(instance.deleteHandler);
            b.atlanTagNames(instance.atlanTagNames == null ? Collections.emptySortedSet() : instance.atlanTagNames);
            b.isIncomplete(instance.isIncomplete);
            b.meaningNames(instance.meaningNames == null ? Collections.emptySortedSet() : instance.meaningNames);
            b.meanings(instance.meanings == null ? Collections.emptySortedSet() : instance.meanings);
            b.pendingTasks(instance.pendingTasks == null ? Collections.emptySortedSet() : instance.pendingTasks);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B adminGroup(String adminGroup) {
            if (this.adminGroups == null) {
                this.adminGroups = new ArrayList();
            }
            this.adminGroups.add(adminGroup);
            return (B)this.self();
        }

        @Generated
        public B adminGroups(Collection<? extends String> adminGroups) {
            if (adminGroups == null) {
                throw new NullPointerException("adminGroups cannot be null");
            }
            if (this.adminGroups == null) {
                this.adminGroups = new ArrayList();
            }
            this.adminGroups.addAll(adminGroups);
            return (B)this.self();
        }

        @Generated
        public B clearAdminGroups() {
            if (this.adminGroups != null) {
                this.adminGroups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adminRole(String adminRole) {
            if (this.adminRoles == null) {
                this.adminRoles = new ArrayList();
            }
            this.adminRoles.add(adminRole);
            return (B)this.self();
        }

        @Generated
        public B adminRoles(Collection<? extends String> adminRoles) {
            if (adminRoles == null) {
                throw new NullPointerException("adminRoles cannot be null");
            }
            if (this.adminRoles == null) {
                this.adminRoles = new ArrayList();
            }
            this.adminRoles.addAll(adminRoles);
            return (B)this.self();
        }

        @Generated
        public B clearAdminRoles() {
            if (this.adminRoles != null) {
                this.adminRoles.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adminUser(String adminUser) {
            if (this.adminUsers == null) {
                this.adminUsers = new ArrayList();
            }
            this.adminUsers.add(adminUser);
            return (B)this.self();
        }

        @Generated
        public B adminUsers(Collection<? extends String> adminUsers) {
            if (adminUsers == null) {
                throw new NullPointerException("adminUsers cannot be null");
            }
            if (this.adminUsers == null) {
                this.adminUsers = new ArrayList();
            }
            this.adminUsers.addAll(adminUsers);
            return (B)this.self();
        }

        @Generated
        public B clearAdminUsers() {
            if (this.adminUsers != null) {
                this.adminUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B announcementMessage(String announcementMessage) {
            this.announcementMessage = announcementMessage;
            return (B)this.self();
        }

        @Generated
        public B announcementTitle(String announcementTitle) {
            this.announcementTitle = announcementTitle;
            return (B)this.self();
        }

        @Generated
        public B announcementType(AtlanAnnouncementType announcementType) {
            this.announcementType = announcementType;
            return (B)this.self();
        }

        @Generated
        public B announcementUpdatedAt(Long announcementUpdatedAt) {
            this.announcementUpdatedAt = announcementUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B announcementUpdatedBy(String announcementUpdatedBy) {
            this.announcementUpdatedBy = announcementUpdatedBy;
            return (B)this.self();
        }

        @Generated
        public B assetDbtAccountName(String assetDbtAccountName) {
            this.assetDbtAccountName = assetDbtAccountName;
            return (B)this.self();
        }

        @Generated
        public B assetDbtAlias(String assetDbtAlias) {
            this.assetDbtAlias = assetDbtAlias;
            return (B)this.self();
        }

        @Generated
        public B assetDbtEnvironmentDbtVersion(String assetDbtEnvironmentDbtVersion) {
            this.assetDbtEnvironmentDbtVersion = assetDbtEnvironmentDbtVersion;
            return (B)this.self();
        }

        @Generated
        public B assetDbtEnvironmentName(String assetDbtEnvironmentName) {
            this.assetDbtEnvironmentName = assetDbtEnvironmentName;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRun(Long assetDbtJobLastRun) {
            this.assetDbtJobLastRun = assetDbtJobLastRun;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunArtifactS3Path(String assetDbtJobLastRunArtifactS3Path) {
            this.assetDbtJobLastRunArtifactS3Path = assetDbtJobLastRunArtifactS3Path;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunArtifactsSaved(Boolean assetDbtJobLastRunArtifactsSaved) {
            this.assetDbtJobLastRunArtifactsSaved = assetDbtJobLastRunArtifactsSaved;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunCreatedAt(Long assetDbtJobLastRunCreatedAt) {
            this.assetDbtJobLastRunCreatedAt = assetDbtJobLastRunCreatedAt;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunDequedAt(Long assetDbtJobLastRunDequedAt) {
            this.assetDbtJobLastRunDequedAt = assetDbtJobLastRunDequedAt;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunExecutedByThreadId(String assetDbtJobLastRunExecutedByThreadId) {
            this.assetDbtJobLastRunExecutedByThreadId = assetDbtJobLastRunExecutedByThreadId;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunGitBranch(String assetDbtJobLastRunGitBranch) {
            this.assetDbtJobLastRunGitBranch = assetDbtJobLastRunGitBranch;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunGitSha(String assetDbtJobLastRunGitSha) {
            this.assetDbtJobLastRunGitSha = assetDbtJobLastRunGitSha;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunHasDocsGenerated(Boolean assetDbtJobLastRunHasDocsGenerated) {
            this.assetDbtJobLastRunHasDocsGenerated = assetDbtJobLastRunHasDocsGenerated;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunHasSourcesGenerated(Boolean assetDbtJobLastRunHasSourcesGenerated) {
            this.assetDbtJobLastRunHasSourcesGenerated = assetDbtJobLastRunHasSourcesGenerated;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunNotificationsSent(Boolean assetDbtJobLastRunNotificationsSent) {
            this.assetDbtJobLastRunNotificationsSent = assetDbtJobLastRunNotificationsSent;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunOwnerThreadId(String assetDbtJobLastRunOwnerThreadId) {
            this.assetDbtJobLastRunOwnerThreadId = assetDbtJobLastRunOwnerThreadId;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunQueuedDuration(String assetDbtJobLastRunQueuedDuration) {
            this.assetDbtJobLastRunQueuedDuration = assetDbtJobLastRunQueuedDuration;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunQueuedDurationHumanized(String assetDbtJobLastRunQueuedDurationHumanized) {
            this.assetDbtJobLastRunQueuedDurationHumanized = assetDbtJobLastRunQueuedDurationHumanized;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunRunDuration(String assetDbtJobLastRunRunDuration) {
            this.assetDbtJobLastRunRunDuration = assetDbtJobLastRunRunDuration;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunRunDurationHumanized(String assetDbtJobLastRunRunDurationHumanized) {
            this.assetDbtJobLastRunRunDurationHumanized = assetDbtJobLastRunRunDurationHumanized;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunStartedAt(Long assetDbtJobLastRunStartedAt) {
            this.assetDbtJobLastRunStartedAt = assetDbtJobLastRunStartedAt;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunStatusMessage(String assetDbtJobLastRunStatusMessage) {
            this.assetDbtJobLastRunStatusMessage = assetDbtJobLastRunStatusMessage;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunTotalDuration(String assetDbtJobLastRunTotalDuration) {
            this.assetDbtJobLastRunTotalDuration = assetDbtJobLastRunTotalDuration;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunTotalDurationHumanized(String assetDbtJobLastRunTotalDurationHumanized) {
            this.assetDbtJobLastRunTotalDurationHumanized = assetDbtJobLastRunTotalDurationHumanized;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunUpdatedAt(Long assetDbtJobLastRunUpdatedAt) {
            this.assetDbtJobLastRunUpdatedAt = assetDbtJobLastRunUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunUrl(String assetDbtJobLastRunUrl) {
            this.assetDbtJobLastRunUrl = assetDbtJobLastRunUrl;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobName(String assetDbtJobName) {
            this.assetDbtJobName = assetDbtJobName;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobNextRun(Long assetDbtJobNextRun) {
            this.assetDbtJobNextRun = assetDbtJobNextRun;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobNextRunHumanized(String assetDbtJobNextRunHumanized) {
            this.assetDbtJobNextRunHumanized = assetDbtJobNextRunHumanized;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobSchedule(String assetDbtJobSchedule) {
            this.assetDbtJobSchedule = assetDbtJobSchedule;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobScheduleCronHumanized(String assetDbtJobScheduleCronHumanized) {
            this.assetDbtJobScheduleCronHumanized = assetDbtJobScheduleCronHumanized;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobStatus(String assetDbtJobStatus) {
            this.assetDbtJobStatus = assetDbtJobStatus;
            return (B)this.self();
        }

        @Generated
        public B assetDbtMeta(String assetDbtMeta) {
            this.assetDbtMeta = assetDbtMeta;
            return (B)this.self();
        }

        @Generated
        public B assetDbtPackageName(String assetDbtPackageName) {
            this.assetDbtPackageName = assetDbtPackageName;
            return (B)this.self();
        }

        @Generated
        public B assetDbtProjectName(String assetDbtProjectName) {
            this.assetDbtProjectName = assetDbtProjectName;
            return (B)this.self();
        }

        @Generated
        public B assetDbtSemanticLayerProxyUrl(String assetDbtSemanticLayerProxyUrl) {
            this.assetDbtSemanticLayerProxyUrl = assetDbtSemanticLayerProxyUrl;
            return (B)this.self();
        }

        @Generated
        public B assetDbtSourceFreshnessCriteria(String assetDbtSourceFreshnessCriteria) {
            this.assetDbtSourceFreshnessCriteria = assetDbtSourceFreshnessCriteria;
            return (B)this.self();
        }

        @Generated
        public B assetDbtTag(String assetDbtTag) {
            if (this.assetDbtTags == null) {
                this.assetDbtTags = new ArrayList();
            }
            this.assetDbtTags.add(assetDbtTag);
            return (B)this.self();
        }

        @Generated
        public B assetDbtTags(Collection<? extends String> assetDbtTags) {
            if (assetDbtTags == null) {
                throw new NullPointerException("assetDbtTags cannot be null");
            }
            if (this.assetDbtTags == null) {
                this.assetDbtTags = new ArrayList();
            }
            this.assetDbtTags.addAll(assetDbtTags);
            return (B)this.self();
        }

        @Generated
        public B clearAssetDbtTags() {
            if (this.assetDbtTags != null) {
                this.assetDbtTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assetDbtTestStatus(String assetDbtTestStatus) {
            this.assetDbtTestStatus = assetDbtTestStatus;
            return (B)this.self();
        }

        @Generated
        public B assetDbtUniqueId(String assetDbtUniqueId) {
            this.assetDbtUniqueId = assetDbtUniqueId;
            return (B)this.self();
        }

        @Generated
        public B assetIcon(String assetIcon) {
            this.assetIcon = assetIcon;
            return (B)this.self();
        }

        @Generated
        public B assetMcIncidentName(String assetMcIncidentName) {
            if (this.assetMcIncidentNames == null) {
                this.assetMcIncidentNames = new ArrayList();
            }
            this.assetMcIncidentNames.add(assetMcIncidentName);
            return (B)this.self();
        }

        @Generated
        public B assetMcIncidentNames(Collection<? extends String> assetMcIncidentNames) {
            if (assetMcIncidentNames == null) {
                throw new NullPointerException("assetMcIncidentNames cannot be null");
            }
            if (this.assetMcIncidentNames == null) {
                this.assetMcIncidentNames = new ArrayList();
            }
            this.assetMcIncidentNames.addAll(assetMcIncidentNames);
            return (B)this.self();
        }

        @Generated
        public B clearAssetMcIncidentNames() {
            if (this.assetMcIncidentNames != null) {
                this.assetMcIncidentNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assetMcIncidentQualifiedName(String assetMcIncidentQualifiedName) {
            if (this.assetMcIncidentQualifiedNames == null) {
                this.assetMcIncidentQualifiedNames = new ArrayList();
            }
            this.assetMcIncidentQualifiedNames.add(assetMcIncidentQualifiedName);
            return (B)this.self();
        }

        @Generated
        public B assetMcIncidentQualifiedNames(Collection<? extends String> assetMcIncidentQualifiedNames) {
            if (assetMcIncidentQualifiedNames == null) {
                throw new NullPointerException("assetMcIncidentQualifiedNames cannot be null");
            }
            if (this.assetMcIncidentQualifiedNames == null) {
                this.assetMcIncidentQualifiedNames = new ArrayList();
            }
            this.assetMcIncidentQualifiedNames.addAll(assetMcIncidentQualifiedNames);
            return (B)this.self();
        }

        @Generated
        public B clearAssetMcIncidentQualifiedNames() {
            if (this.assetMcIncidentQualifiedNames != null) {
                this.assetMcIncidentQualifiedNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assetMcIncidentSeverity(String assetMcIncidentSeverity) {
            if (this.assetMcIncidentSeverities == null) {
                this.assetMcIncidentSeverities = new ArrayList();
            }
            this.assetMcIncidentSeverities.add(assetMcIncidentSeverity);
            return (B)this.self();
        }

        @Generated
        public B assetMcIncidentSeverities(Collection<? extends String> assetMcIncidentSeverities) {
            if (assetMcIncidentSeverities == null) {
                throw new NullPointerException("assetMcIncidentSeverities cannot be null");
            }
            if (this.assetMcIncidentSeverities == null) {
                this.assetMcIncidentSeverities = new ArrayList();
            }
            this.assetMcIncidentSeverities.addAll(assetMcIncidentSeverities);
            return (B)this.self();
        }

        @Generated
        public B clearAssetMcIncidentSeverities() {
            if (this.assetMcIncidentSeverities != null) {
                this.assetMcIncidentSeverities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assetMcIncidentState(String assetMcIncidentState) {
            if (this.assetMcIncidentStates == null) {
                this.assetMcIncidentStates = new ArrayList();
            }
            this.assetMcIncidentStates.add(assetMcIncidentState);
            return (B)this.self();
        }

        @Generated
        public B assetMcIncidentStates(Collection<? extends String> assetMcIncidentStates) {
            if (assetMcIncidentStates == null) {
                throw new NullPointerException("assetMcIncidentStates cannot be null");
            }
            if (this.assetMcIncidentStates == null) {
                this.assetMcIncidentStates = new ArrayList();
            }
            this.assetMcIncidentStates.addAll(assetMcIncidentStates);
            return (B)this.self();
        }

        @Generated
        public B clearAssetMcIncidentStates() {
            if (this.assetMcIncidentStates != null) {
                this.assetMcIncidentStates.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assetMcIncidentSubType(String assetMcIncidentSubType) {
            if (this.assetMcIncidentSubTypes == null) {
                this.assetMcIncidentSubTypes = new ArrayList();
            }
            this.assetMcIncidentSubTypes.add(assetMcIncidentSubType);
            return (B)this.self();
        }

        @Generated
        public B assetMcIncidentSubTypes(Collection<? extends String> assetMcIncidentSubTypes) {
            if (assetMcIncidentSubTypes == null) {
                throw new NullPointerException("assetMcIncidentSubTypes cannot be null");
            }
            if (this.assetMcIncidentSubTypes == null) {
                this.assetMcIncidentSubTypes = new ArrayList();
            }
            this.assetMcIncidentSubTypes.addAll(assetMcIncidentSubTypes);
            return (B)this.self();
        }

        @Generated
        public B clearAssetMcIncidentSubTypes() {
            if (this.assetMcIncidentSubTypes != null) {
                this.assetMcIncidentSubTypes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assetMcIncidentType(String assetMcIncidentType) {
            if (this.assetMcIncidentTypes == null) {
                this.assetMcIncidentTypes = new ArrayList();
            }
            this.assetMcIncidentTypes.add(assetMcIncidentType);
            return (B)this.self();
        }

        @Generated
        public B assetMcIncidentTypes(Collection<? extends String> assetMcIncidentTypes) {
            if (assetMcIncidentTypes == null) {
                throw new NullPointerException("assetMcIncidentTypes cannot be null");
            }
            if (this.assetMcIncidentTypes == null) {
                this.assetMcIncidentTypes = new ArrayList();
            }
            this.assetMcIncidentTypes.addAll(assetMcIncidentTypes);
            return (B)this.self();
        }

        @Generated
        public B clearAssetMcIncidentTypes() {
            if (this.assetMcIncidentTypes != null) {
                this.assetMcIncidentTypes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assetMcLastSyncRunAt(Long assetMcLastSyncRunAt) {
            this.assetMcLastSyncRunAt = assetMcLastSyncRunAt;
            return (B)this.self();
        }

        @Generated
        public B assetMcMonitorName(String assetMcMonitorName) {
            if (this.assetMcMonitorNames == null) {
                this.assetMcMonitorNames = new ArrayList();
            }
            this.assetMcMonitorNames.add(assetMcMonitorName);
            return (B)this.self();
        }

        @Generated
        public B assetMcMonitorNames(Collection<? extends String> assetMcMonitorNames) {
            if (assetMcMonitorNames == null) {
                throw new NullPointerException("assetMcMonitorNames cannot be null");
            }
            if (this.assetMcMonitorNames == null) {
                this.assetMcMonitorNames = new ArrayList();
            }
            this.assetMcMonitorNames.addAll(assetMcMonitorNames);
            return (B)this.self();
        }

        @Generated
        public B clearAssetMcMonitorNames() {
            if (this.assetMcMonitorNames != null) {
                this.assetMcMonitorNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assetMcMonitorQualifiedName(String assetMcMonitorQualifiedName) {
            if (this.assetMcMonitorQualifiedNames == null) {
                this.assetMcMonitorQualifiedNames = new ArrayList();
            }
            this.assetMcMonitorQualifiedNames.add(assetMcMonitorQualifiedName);
            return (B)this.self();
        }

        @Generated
        public B assetMcMonitorQualifiedNames(Collection<? extends String> assetMcMonitorQualifiedNames) {
            if (assetMcMonitorQualifiedNames == null) {
                throw new NullPointerException("assetMcMonitorQualifiedNames cannot be null");
            }
            if (this.assetMcMonitorQualifiedNames == null) {
                this.assetMcMonitorQualifiedNames = new ArrayList();
            }
            this.assetMcMonitorQualifiedNames.addAll(assetMcMonitorQualifiedNames);
            return (B)this.self();
        }

        @Generated
        public B clearAssetMcMonitorQualifiedNames() {
            if (this.assetMcMonitorQualifiedNames != null) {
                this.assetMcMonitorQualifiedNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assetMcMonitorScheduleType(String assetMcMonitorScheduleType) {
            if (this.assetMcMonitorScheduleTypes == null) {
                this.assetMcMonitorScheduleTypes = new ArrayList();
            }
            this.assetMcMonitorScheduleTypes.add(assetMcMonitorScheduleType);
            return (B)this.self();
        }

        @Generated
        public B assetMcMonitorScheduleTypes(Collection<? extends String> assetMcMonitorScheduleTypes) {
            if (assetMcMonitorScheduleTypes == null) {
                throw new NullPointerException("assetMcMonitorScheduleTypes cannot be null");
            }
            if (this.assetMcMonitorScheduleTypes == null) {
                this.assetMcMonitorScheduleTypes = new ArrayList();
            }
            this.assetMcMonitorScheduleTypes.addAll(assetMcMonitorScheduleTypes);
            return (B)this.self();
        }

        @Generated
        public B clearAssetMcMonitorScheduleTypes() {
            if (this.assetMcMonitorScheduleTypes != null) {
                this.assetMcMonitorScheduleTypes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assetMcMonitorStatus(String assetMcMonitorStatus) {
            if (this.assetMcMonitorStatuses == null) {
                this.assetMcMonitorStatuses = new ArrayList();
            }
            this.assetMcMonitorStatuses.add(assetMcMonitorStatus);
            return (B)this.self();
        }

        @Generated
        public B assetMcMonitorStatuses(Collection<? extends String> assetMcMonitorStatuses) {
            if (assetMcMonitorStatuses == null) {
                throw new NullPointerException("assetMcMonitorStatuses cannot be null");
            }
            if (this.assetMcMonitorStatuses == null) {
                this.assetMcMonitorStatuses = new ArrayList();
            }
            this.assetMcMonitorStatuses.addAll(assetMcMonitorStatuses);
            return (B)this.self();
        }

        @Generated
        public B clearAssetMcMonitorStatuses() {
            if (this.assetMcMonitorStatuses != null) {
                this.assetMcMonitorStatuses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assetMcMonitorType(String assetMcMonitorType) {
            if (this.assetMcMonitorTypes == null) {
                this.assetMcMonitorTypes = new ArrayList();
            }
            this.assetMcMonitorTypes.add(assetMcMonitorType);
            return (B)this.self();
        }

        @Generated
        public B assetMcMonitorTypes(Collection<? extends String> assetMcMonitorTypes) {
            if (assetMcMonitorTypes == null) {
                throw new NullPointerException("assetMcMonitorTypes cannot be null");
            }
            if (this.assetMcMonitorTypes == null) {
                this.assetMcMonitorTypes = new ArrayList();
            }
            this.assetMcMonitorTypes.addAll(assetMcMonitorTypes);
            return (B)this.self();
        }

        @Generated
        public B clearAssetMcMonitorTypes() {
            if (this.assetMcMonitorTypes != null) {
                this.assetMcMonitorTypes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assetSodaCheckCount(Long assetSodaCheckCount) {
            this.assetSodaCheckCount = assetSodaCheckCount;
            return (B)this.self();
        }

        @Generated
        public B assetSodaCheckStatuses(String assetSodaCheckStatuses) {
            this.assetSodaCheckStatuses = assetSodaCheckStatuses;
            return (B)this.self();
        }

        @Generated
        public B assetSodaDQStatus(String assetSodaDQStatus) {
            this.assetSodaDQStatus = assetSodaDQStatus;
            return (B)this.self();
        }

        @Generated
        public B assetSodaLastScanAt(Long assetSodaLastScanAt) {
            this.assetSodaLastScanAt = assetSodaLastScanAt;
            return (B)this.self();
        }

        @Generated
        public B assetSodaLastSyncRunAt(Long assetSodaLastSyncRunAt) {
            this.assetSodaLastSyncRunAt = assetSodaLastSyncRunAt;
            return (B)this.self();
        }

        @Generated
        public B assetSodaSourceURL(String assetSodaSourceURL) {
            this.assetSodaSourceURL = assetSodaSourceURL;
            return (B)this.self();
        }

        @Generated
        public B assetTag(String assetTag) {
            if (this.assetTags == null) {
                this.assetTags = new ArrayList();
            }
            this.assetTags.add(assetTag);
            return (B)this.self();
        }

        @Generated
        public B assetTags(Collection<? extends String> assetTags) {
            if (assetTags == null) {
                throw new NullPointerException("assetTags cannot be null");
            }
            if (this.assetTags == null) {
                this.assetTags = new ArrayList();
            }
            this.assetTags.addAll(assetTags);
            return (B)this.self();
        }

        @Generated
        public B clearAssetTags() {
            if (this.assetTags != null) {
                this.assetTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assignedTerm(IGlossaryTerm assignedTerm) {
            if (this.assignedTerms == null) {
                this.assignedTerms = new ArrayList();
            }
            this.assignedTerms.add(assignedTerm);
            return (B)this.self();
        }

        @JsonProperty(value="meanings")
        @Generated
        public B assignedTerms(Collection<? extends IGlossaryTerm> assignedTerms) {
            if (assignedTerms == null) {
                throw new NullPointerException("assignedTerms cannot be null");
            }
            if (this.assignedTerms == null) {
                this.assignedTerms = new ArrayList();
            }
            this.assignedTerms.addAll(assignedTerms);
            return (B)this.self();
        }

        @Generated
        public B clearAssignedTerms() {
            if (this.assignedTerms != null) {
                this.assignedTerms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B certificateStatus(CertificateStatus certificateStatus) {
            this.certificateStatus = certificateStatus;
            return (B)this.self();
        }

        @Generated
        public B certificateStatusMessage(String certificateStatusMessage) {
            this.certificateStatusMessage = certificateStatusMessage;
            return (B)this.self();
        }

        @Generated
        public B certificateUpdatedAt(Long certificateUpdatedAt) {
            this.certificateUpdatedAt = certificateUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B certificateUpdatedBy(String certificateUpdatedBy) {
            this.certificateUpdatedBy = certificateUpdatedBy;
            return (B)this.self();
        }

        @Generated
        public B connectionName(String connectionName) {
            this.connectionName = connectionName;
            return (B)this.self();
        }

        @Generated
        public B connectionQualifiedName(String connectionQualifiedName) {
            this.connectionQualifiedName = connectionQualifiedName;
            return (B)this.self();
        }

        @JsonProperty(value="connectorName")
        @Generated
        public B connectorType(AtlanConnectorType connectorType) {
            this.connectorType = connectorType;
            return (B)this.self();
        }

        @Generated
        public B dbtQualifiedName(String dbtQualifiedName) {
            this.dbtQualifiedName = dbtQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return (B)this.self();
        }

        @Generated
        public B displayName(String displayName) {
            this.displayName = displayName;
            return (B)this.self();
        }

        @Generated
        public B file(IFile file) {
            if (this.files == null) {
                this.files = new ArrayList();
            }
            this.files.add(file);
            return (B)this.self();
        }

        @Generated
        public B files(Collection<? extends IFile> files) {
            if (files == null) {
                throw new NullPointerException("files cannot be null");
            }
            if (this.files == null) {
                this.files = new ArrayList();
            }
            this.files.addAll(files);
            return (B)this.self();
        }

        @Generated
        public B clearFiles() {
            if (this.files != null) {
                this.files.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="__hasLineage")
        @Generated
        public B hasLineage(Boolean hasLineage) {
            this.hasLineage = hasLineage;
            return (B)this.self();
        }

        @Generated
        public B isDiscoverable(Boolean isDiscoverable) {
            this.isDiscoverable = isDiscoverable;
            return (B)this.self();
        }

        @Generated
        public B isEditable(Boolean isEditable) {
            this.isEditable = isEditable;
            return (B)this.self();
        }

        @Generated
        public B lastRowChangedAt(Long lastRowChangedAt) {
            this.lastRowChangedAt = lastRowChangedAt;
            return (B)this.self();
        }

        @Generated
        public B lastSyncRun(String lastSyncRun) {
            this.lastSyncRun = lastSyncRun;
            return (B)this.self();
        }

        @Generated
        public B lastSyncRunAt(Long lastSyncRunAt) {
            this.lastSyncRunAt = lastSyncRunAt;
            return (B)this.self();
        }

        @Generated
        public B lastSyncWorkflowName(String lastSyncWorkflowName) {
            this.lastSyncWorkflowName = lastSyncWorkflowName;
            return (B)this.self();
        }

        @Generated
        public B link(ILink link) {
            if (this.links == null) {
                this.links = new ArrayList();
            }
            this.links.add(link);
            return (B)this.self();
        }

        @Generated
        public B links(Collection<? extends ILink> links) {
            if (links == null) {
                throw new NullPointerException("links cannot be null");
            }
            if (this.links == null) {
                this.links = new ArrayList();
            }
            this.links.addAll(links);
            return (B)this.self();
        }

        @Generated
        public B clearLinks() {
            if (this.links != null) {
                this.links.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B mcIncident(IMCIncident mcIncident) {
            if (this.mcIncidents == null) {
                this.mcIncidents = new ArrayList();
            }
            this.mcIncidents.add(mcIncident);
            return (B)this.self();
        }

        @Generated
        public B mcIncidents(Collection<? extends IMCIncident> mcIncidents) {
            if (mcIncidents == null) {
                throw new NullPointerException("mcIncidents cannot be null");
            }
            if (this.mcIncidents == null) {
                this.mcIncidents = new ArrayList();
            }
            this.mcIncidents.addAll(mcIncidents);
            return (B)this.self();
        }

        @Generated
        public B clearMcIncidents() {
            if (this.mcIncidents != null) {
                this.mcIncidents.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B mcMonitor(IMCMonitor mcMonitor) {
            if (this.mcMonitors == null) {
                this.mcMonitors = new ArrayList();
            }
            this.mcMonitors.add(mcMonitor);
            return (B)this.self();
        }

        @Generated
        public B mcMonitors(Collection<? extends IMCMonitor> mcMonitors) {
            if (mcMonitors == null) {
                throw new NullPointerException("mcMonitors cannot be null");
            }
            if (this.mcMonitors == null) {
                this.mcMonitors = new ArrayList();
            }
            this.mcMonitors.addAll(mcMonitors);
            return (B)this.self();
        }

        @Generated
        public B clearMcMonitors() {
            if (this.mcMonitors != null) {
                this.mcMonitors.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metric(IMetric metric) {
            if (this.metrics == null) {
                this.metrics = new ArrayList();
            }
            this.metrics.add(metric);
            return (B)this.self();
        }

        @Generated
        public B metrics(Collection<? extends IMetric> metrics) {
            if (metrics == null) {
                throw new NullPointerException("metrics cannot be null");
            }
            if (this.metrics == null) {
                this.metrics = new ArrayList();
            }
            this.metrics.addAll(metrics);
            return (B)this.self();
        }

        @Generated
        public B clearMetrics() {
            if (this.metrics != null) {
                this.metrics.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Generated
        public B ownerGroup(String ownerGroup) {
            if (this.ownerGroups == null) {
                this.ownerGroups = new ArrayList();
            }
            this.ownerGroups.add(ownerGroup);
            return (B)this.self();
        }

        @Generated
        public B ownerGroups(Collection<? extends String> ownerGroups) {
            if (ownerGroups == null) {
                throw new NullPointerException("ownerGroups cannot be null");
            }
            if (this.ownerGroups == null) {
                this.ownerGroups = new ArrayList();
            }
            this.ownerGroups.addAll(ownerGroups);
            return (B)this.self();
        }

        @Generated
        public B clearOwnerGroups() {
            if (this.ownerGroups != null) {
                this.ownerGroups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B ownerUser(String ownerUser) {
            if (this.ownerUsers == null) {
                this.ownerUsers = new ArrayList();
            }
            this.ownerUsers.add(ownerUser);
            return (B)this.self();
        }

        @Generated
        public B ownerUsers(Collection<? extends String> ownerUsers) {
            if (ownerUsers == null) {
                throw new NullPointerException("ownerUsers cannot be null");
            }
            if (this.ownerUsers == null) {
                this.ownerUsers = new ArrayList();
            }
            this.ownerUsers.addAll(ownerUsers);
            return (B)this.self();
        }

        @Generated
        public B clearOwnerUsers() {
            if (this.ownerUsers != null) {
                this.ownerUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B popularityScore(Double popularityScore) {
            this.popularityScore = popularityScore;
            return (B)this.self();
        }

        @Generated
        public B qualifiedName(String qualifiedName) {
            this.qualifiedName = qualifiedName;
            return (B)this.self();
        }

        @Generated
        public B readme(IReadme readme) {
            this.readme = readme;
            return (B)this.self();
        }

        @Generated
        public B sampleDataUrl(String sampleDataUrl) {
            this.sampleDataUrl = sampleDataUrl;
            return (B)this.self();
        }

        @Generated
        public B schemaRegistrySubject(ISchemaRegistrySubject schemaRegistrySubject) {
            if (this.schemaRegistrySubjects == null) {
                this.schemaRegistrySubjects = new ArrayList();
            }
            this.schemaRegistrySubjects.add(schemaRegistrySubject);
            return (B)this.self();
        }

        @Generated
        public B schemaRegistrySubjects(Collection<? extends ISchemaRegistrySubject> schemaRegistrySubjects) {
            if (schemaRegistrySubjects == null) {
                throw new NullPointerException("schemaRegistrySubjects cannot be null");
            }
            if (this.schemaRegistrySubjects == null) {
                this.schemaRegistrySubjects = new ArrayList();
            }
            this.schemaRegistrySubjects.addAll(schemaRegistrySubjects);
            return (B)this.self();
        }

        @Generated
        public B clearSchemaRegistrySubjects() {
            if (this.schemaRegistrySubjects != null) {
                this.schemaRegistrySubjects.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sodaCheck(ISodaCheck sodaCheck) {
            if (this.sodaChecks == null) {
                this.sodaChecks = new ArrayList();
            }
            this.sodaChecks.add(sodaCheck);
            return (B)this.self();
        }

        @Generated
        public B sodaChecks(Collection<? extends ISodaCheck> sodaChecks) {
            if (sodaChecks == null) {
                throw new NullPointerException("sodaChecks cannot be null");
            }
            if (this.sodaChecks == null) {
                this.sodaChecks = new ArrayList();
            }
            this.sodaChecks.addAll(sodaChecks);
            return (B)this.self();
        }

        @Generated
        public B clearSodaChecks() {
            if (this.sodaChecks != null) {
                this.sodaChecks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sourceCostUnit(SourceCostUnitType sourceCostUnit) {
            this.sourceCostUnit = sourceCostUnit;
            return (B)this.self();
        }

        @Generated
        public B sourceCreatedAt(Long sourceCreatedAt) {
            this.sourceCreatedAt = sourceCreatedAt;
            return (B)this.self();
        }

        @Generated
        public B sourceCreatedBy(String sourceCreatedBy) {
            this.sourceCreatedBy = sourceCreatedBy;
            return (B)this.self();
        }

        @Generated
        public B sourceEmbedURL(String sourceEmbedURL) {
            this.sourceEmbedURL = sourceEmbedURL;
            return (B)this.self();
        }

        @Generated
        public B sourceLastReadAt(Long sourceLastReadAt) {
            this.sourceLastReadAt = sourceLastReadAt;
            return (B)this.self();
        }

        @Generated
        public B sourceOwners(String sourceOwners) {
            this.sourceOwners = sourceOwners;
            return (B)this.self();
        }

        @Generated
        public B sourceQueryComputeCostRecord(PopularityInsights sourceQueryComputeCostRecord) {
            if (this.sourceQueryComputeCostRecords == null) {
                this.sourceQueryComputeCostRecords = new ArrayList();
            }
            this.sourceQueryComputeCostRecords.add(sourceQueryComputeCostRecord);
            return (B)this.self();
        }

        @JsonProperty(value="sourceQueryComputeCostRecordList")
        @Generated
        public B sourceQueryComputeCostRecords(Collection<? extends PopularityInsights> sourceQueryComputeCostRecords) {
            if (sourceQueryComputeCostRecords == null) {
                throw new NullPointerException("sourceQueryComputeCostRecords cannot be null");
            }
            if (this.sourceQueryComputeCostRecords == null) {
                this.sourceQueryComputeCostRecords = new ArrayList();
            }
            this.sourceQueryComputeCostRecords.addAll(sourceQueryComputeCostRecords);
            return (B)this.self();
        }

        @Generated
        public B clearSourceQueryComputeCostRecords() {
            if (this.sourceQueryComputeCostRecords != null) {
                this.sourceQueryComputeCostRecords.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sourceQueryComputeCost(String sourceQueryComputeCost) {
            if (this.sourceQueryComputeCosts == null) {
                this.sourceQueryComputeCosts = new ArrayList();
            }
            this.sourceQueryComputeCosts.add(sourceQueryComputeCost);
            return (B)this.self();
        }

        @JsonProperty(value="sourceQueryComputeCostList")
        @Generated
        public B sourceQueryComputeCosts(Collection<? extends String> sourceQueryComputeCosts) {
            if (sourceQueryComputeCosts == null) {
                throw new NullPointerException("sourceQueryComputeCosts cannot be null");
            }
            if (this.sourceQueryComputeCosts == null) {
                this.sourceQueryComputeCosts = new ArrayList();
            }
            this.sourceQueryComputeCosts.addAll(sourceQueryComputeCosts);
            return (B)this.self();
        }

        @Generated
        public B clearSourceQueryComputeCosts() {
            if (this.sourceQueryComputeCosts != null) {
                this.sourceQueryComputeCosts.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sourceReadCount(Long sourceReadCount) {
            this.sourceReadCount = sourceReadCount;
            return (B)this.self();
        }

        @Generated
        public B sourceReadExpensiveQueryRecord(PopularityInsights sourceReadExpensiveQueryRecord) {
            if (this.sourceReadExpensiveQueryRecords == null) {
                this.sourceReadExpensiveQueryRecords = new ArrayList();
            }
            this.sourceReadExpensiveQueryRecords.add(sourceReadExpensiveQueryRecord);
            return (B)this.self();
        }

        @JsonProperty(value="sourceReadExpensiveQueryRecordList")
        @Generated
        public B sourceReadExpensiveQueryRecords(Collection<? extends PopularityInsights> sourceReadExpensiveQueryRecords) {
            if (sourceReadExpensiveQueryRecords == null) {
                throw new NullPointerException("sourceReadExpensiveQueryRecords cannot be null");
            }
            if (this.sourceReadExpensiveQueryRecords == null) {
                this.sourceReadExpensiveQueryRecords = new ArrayList();
            }
            this.sourceReadExpensiveQueryRecords.addAll(sourceReadExpensiveQueryRecords);
            return (B)this.self();
        }

        @Generated
        public B clearSourceReadExpensiveQueryRecords() {
            if (this.sourceReadExpensiveQueryRecords != null) {
                this.sourceReadExpensiveQueryRecords.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sourceReadPopularQueryRecord(PopularityInsights sourceReadPopularQueryRecord) {
            if (this.sourceReadPopularQueryRecords == null) {
                this.sourceReadPopularQueryRecords = new ArrayList();
            }
            this.sourceReadPopularQueryRecords.add(sourceReadPopularQueryRecord);
            return (B)this.self();
        }

        @JsonProperty(value="sourceReadPopularQueryRecordList")
        @Generated
        public B sourceReadPopularQueryRecords(Collection<? extends PopularityInsights> sourceReadPopularQueryRecords) {
            if (sourceReadPopularQueryRecords == null) {
                throw new NullPointerException("sourceReadPopularQueryRecords cannot be null");
            }
            if (this.sourceReadPopularQueryRecords == null) {
                this.sourceReadPopularQueryRecords = new ArrayList();
            }
            this.sourceReadPopularQueryRecords.addAll(sourceReadPopularQueryRecords);
            return (B)this.self();
        }

        @Generated
        public B clearSourceReadPopularQueryRecords() {
            if (this.sourceReadPopularQueryRecords != null) {
                this.sourceReadPopularQueryRecords.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sourceReadQueryCost(Double sourceReadQueryCost) {
            this.sourceReadQueryCost = sourceReadQueryCost;
            return (B)this.self();
        }

        @Generated
        public B sourceReadRecentUserRecord(PopularityInsights sourceReadRecentUserRecord) {
            if (this.sourceReadRecentUserRecords == null) {
                this.sourceReadRecentUserRecords = new ArrayList();
            }
            this.sourceReadRecentUserRecords.add(sourceReadRecentUserRecord);
            return (B)this.self();
        }

        @JsonProperty(value="sourceReadRecentUserRecordList")
        @Generated
        public B sourceReadRecentUserRecords(Collection<? extends PopularityInsights> sourceReadRecentUserRecords) {
            if (sourceReadRecentUserRecords == null) {
                throw new NullPointerException("sourceReadRecentUserRecords cannot be null");
            }
            if (this.sourceReadRecentUserRecords == null) {
                this.sourceReadRecentUserRecords = new ArrayList();
            }
            this.sourceReadRecentUserRecords.addAll(sourceReadRecentUserRecords);
            return (B)this.self();
        }

        @Generated
        public B clearSourceReadRecentUserRecords() {
            if (this.sourceReadRecentUserRecords != null) {
                this.sourceReadRecentUserRecords.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sourceReadRecentUser(String sourceReadRecentUser) {
            if (this.sourceReadRecentUsers == null) {
                this.sourceReadRecentUsers = new ArrayList();
            }
            this.sourceReadRecentUsers.add(sourceReadRecentUser);
            return (B)this.self();
        }

        @JsonProperty(value="sourceReadRecentUserList")
        @Generated
        public B sourceReadRecentUsers(Collection<? extends String> sourceReadRecentUsers) {
            if (sourceReadRecentUsers == null) {
                throw new NullPointerException("sourceReadRecentUsers cannot be null");
            }
            if (this.sourceReadRecentUsers == null) {
                this.sourceReadRecentUsers = new ArrayList();
            }
            this.sourceReadRecentUsers.addAll(sourceReadRecentUsers);
            return (B)this.self();
        }

        @Generated
        public B clearSourceReadRecentUsers() {
            if (this.sourceReadRecentUsers != null) {
                this.sourceReadRecentUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sourceReadSlowQueryRecord(PopularityInsights sourceReadSlowQueryRecord) {
            if (this.sourceReadSlowQueryRecords == null) {
                this.sourceReadSlowQueryRecords = new ArrayList();
            }
            this.sourceReadSlowQueryRecords.add(sourceReadSlowQueryRecord);
            return (B)this.self();
        }

        @JsonProperty(value="sourceReadSlowQueryRecordList")
        @Generated
        public B sourceReadSlowQueryRecords(Collection<? extends PopularityInsights> sourceReadSlowQueryRecords) {
            if (sourceReadSlowQueryRecords == null) {
                throw new NullPointerException("sourceReadSlowQueryRecords cannot be null");
            }
            if (this.sourceReadSlowQueryRecords == null) {
                this.sourceReadSlowQueryRecords = new ArrayList();
            }
            this.sourceReadSlowQueryRecords.addAll(sourceReadSlowQueryRecords);
            return (B)this.self();
        }

        @Generated
        public B clearSourceReadSlowQueryRecords() {
            if (this.sourceReadSlowQueryRecords != null) {
                this.sourceReadSlowQueryRecords.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sourceReadTopUserRecord(PopularityInsights sourceReadTopUserRecord) {
            if (this.sourceReadTopUserRecords == null) {
                this.sourceReadTopUserRecords = new ArrayList();
            }
            this.sourceReadTopUserRecords.add(sourceReadTopUserRecord);
            return (B)this.self();
        }

        @JsonProperty(value="sourceReadTopUserRecordList")
        @Generated
        public B sourceReadTopUserRecords(Collection<? extends PopularityInsights> sourceReadTopUserRecords) {
            if (sourceReadTopUserRecords == null) {
                throw new NullPointerException("sourceReadTopUserRecords cannot be null");
            }
            if (this.sourceReadTopUserRecords == null) {
                this.sourceReadTopUserRecords = new ArrayList();
            }
            this.sourceReadTopUserRecords.addAll(sourceReadTopUserRecords);
            return (B)this.self();
        }

        @Generated
        public B clearSourceReadTopUserRecords() {
            if (this.sourceReadTopUserRecords != null) {
                this.sourceReadTopUserRecords.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sourceReadTopUser(String sourceReadTopUser) {
            if (this.sourceReadTopUsers == null) {
                this.sourceReadTopUsers = new ArrayList();
            }
            this.sourceReadTopUsers.add(sourceReadTopUser);
            return (B)this.self();
        }

        @JsonProperty(value="sourceReadTopUserList")
        @Generated
        public B sourceReadTopUsers(Collection<? extends String> sourceReadTopUsers) {
            if (sourceReadTopUsers == null) {
                throw new NullPointerException("sourceReadTopUsers cannot be null");
            }
            if (this.sourceReadTopUsers == null) {
                this.sourceReadTopUsers = new ArrayList();
            }
            this.sourceReadTopUsers.addAll(sourceReadTopUsers);
            return (B)this.self();
        }

        @Generated
        public B clearSourceReadTopUsers() {
            if (this.sourceReadTopUsers != null) {
                this.sourceReadTopUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sourceReadUserCount(Long sourceReadUserCount) {
            this.sourceReadUserCount = sourceReadUserCount;
            return (B)this.self();
        }

        @Generated
        public B sourceTotalCost(Double sourceTotalCost) {
            this.sourceTotalCost = sourceTotalCost;
            return (B)this.self();
        }

        @Generated
        public B sourceURL(String sourceURL) {
            this.sourceURL = sourceURL;
            return (B)this.self();
        }

        @Generated
        public B sourceUpdatedAt(Long sourceUpdatedAt) {
            this.sourceUpdatedAt = sourceUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B sourceUpdatedBy(String sourceUpdatedBy) {
            this.sourceUpdatedBy = sourceUpdatedBy;
            return (B)this.self();
        }

        @Generated
        public B addStarredBy(String addStarredBy) {
            if (this.starredBy == null) {
                this.starredBy = new ArrayList();
            }
            this.starredBy.add(addStarredBy);
            return (B)this.self();
        }

        @Generated
        public B starredBy(Collection<? extends String> starredBy) {
            if (starredBy == null) {
                throw new NullPointerException("starredBy cannot be null");
            }
            if (this.starredBy == null) {
                this.starredBy = new ArrayList();
            }
            this.starredBy.addAll(starredBy);
            return (B)this.self();
        }

        @Generated
        public B clearStarredBy() {
            if (this.starredBy != null) {
                this.starredBy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B starredCount(Integer starredCount) {
            this.starredCount = starredCount;
            return (B)this.self();
        }

        @Generated
        public B starredDetail(StarredDetails starredDetail) {
            if (this.starredDetails == null) {
                this.starredDetails = new ArrayList();
            }
            this.starredDetails.add(starredDetail);
            return (B)this.self();
        }

        @JsonProperty(value="starredDetailsList")
        @Generated
        public B starredDetails(Collection<? extends StarredDetails> starredDetails) {
            if (starredDetails == null) {
                throw new NullPointerException("starredDetails cannot be null");
            }
            if (this.starredDetails == null) {
                this.starredDetails = new ArrayList();
            }
            this.starredDetails.addAll(starredDetails);
            return (B)this.self();
        }

        @Generated
        public B clearStarredDetails() {
            if (this.starredDetails != null) {
                this.starredDetails.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B subType(String subType) {
            this.subType = subType;
            return (B)this.self();
        }

        @Generated
        public B tenantId(String tenantId) {
            this.tenantId = tenantId;
            return (B)this.self();
        }

        @Generated
        public B userDescription(String userDescription) {
            this.userDescription = userDescription;
            return (B)this.self();
        }

        @Generated
        public B viewScore(Double viewScore) {
            this.viewScore = viewScore;
            return (B)this.self();
        }

        @Generated
        public B viewerGroup(String viewerGroup) {
            if (this.viewerGroups == null) {
                this.viewerGroups = new ArrayList();
            }
            this.viewerGroups.add(viewerGroup);
            return (B)this.self();
        }

        @Generated
        public B viewerGroups(Collection<? extends String> viewerGroups) {
            if (viewerGroups == null) {
                throw new NullPointerException("viewerGroups cannot be null");
            }
            if (this.viewerGroups == null) {
                this.viewerGroups = new ArrayList();
            }
            this.viewerGroups.addAll(viewerGroups);
            return (B)this.self();
        }

        @Generated
        public B clearViewerGroups() {
            if (this.viewerGroups != null) {
                this.viewerGroups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B viewerUser(String viewerUser) {
            if (this.viewerUsers == null) {
                this.viewerUsers = new ArrayList();
            }
            this.viewerUsers.add(viewerUser);
            return (B)this.self();
        }

        @Generated
        public B viewerUsers(Collection<? extends String> viewerUsers) {
            if (viewerUsers == null) {
                throw new NullPointerException("viewerUsers cannot be null");
            }
            if (this.viewerUsers == null) {
                this.viewerUsers = new ArrayList();
            }
            this.viewerUsers.addAll(viewerUsers);
            return (B)this.self();
        }

        @Generated
        public B clearViewerUsers() {
            if (this.viewerUsers != null) {
                this.viewerUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B nullField(String nullField) {
            if (this.nullFields == null) {
                this.nullFields = new ArrayList();
            }
            this.nullFields.add(nullField);
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B nullFields(Collection<? extends String> nullFields) {
            if (nullFields == null) {
                throw new NullPointerException("nullFields cannot be null");
            }
            if (this.nullFields == null) {
                this.nullFields = new ArrayList();
            }
            this.nullFields.addAll(nullFields);
            return (B)this.self();
        }

        @Generated
        public B clearNullFields() {
            if (this.nullFields != null) {
                this.nullFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B atlanTag(AtlanTag atlanTag) {
            if (this.atlanTags == null) {
                this.atlanTags = new ArrayList();
            }
            this.atlanTags.add(atlanTag);
            return (B)this.self();
        }

        @JsonProperty(value="classifications")
        @Generated
        public B atlanTags(Collection<? extends AtlanTag> atlanTags) {
            if (atlanTags == null) {
                throw new NullPointerException("atlanTags cannot be null");
            }
            if (this.atlanTags == null) {
                this.atlanTags = new ArrayList();
            }
            this.atlanTags.addAll(atlanTags);
            return (B)this.self();
        }

        @Generated
        public B clearAtlanTags() {
            if (this.atlanTags != null) {
                this.atlanTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B customMetadata(String customMetadataKey, CustomMetadataAttributes customMetadataValue) {
            if (this.customMetadataSets$key == null) {
                this.customMetadataSets$key = new ArrayList();
                this.customMetadataSets$value = new ArrayList();
            }
            this.customMetadataSets$key.add(customMetadataKey);
            this.customMetadataSets$value.add(customMetadataValue);
            return (B)this.self();
        }

        @Generated
        public B customMetadataSets(Map<? extends String, ? extends CustomMetadataAttributes> customMetadataSets) {
            if (customMetadataSets == null) {
                throw new NullPointerException("customMetadataSets cannot be null");
            }
            if (this.customMetadataSets$key == null) {
                this.customMetadataSets$key = new ArrayList();
                this.customMetadataSets$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends CustomMetadataAttributes> $lombokEntry : customMetadataSets.entrySet()) {
                this.customMetadataSets$key.add($lombokEntry.getKey());
                this.customMetadataSets$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearCustomMetadataSets() {
            if (this.customMetadataSets$key != null) {
                this.customMetadataSets$key.clear();
                this.customMetadataSets$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B status(AtlanStatus status) {
            this.status = status;
            return (B)this.self();
        }

        @Generated
        public B createdBy(String createdBy) {
            this.createdBy = createdBy;
            return (B)this.self();
        }

        @Generated
        public B updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return (B)this.self();
        }

        @Generated
        public B createTime(Long createTime) {
            this.createTime = createTime;
            return (B)this.self();
        }

        @Generated
        public B updateTime(Long updateTime) {
            this.updateTime = updateTime;
            return (B)this.self();
        }

        @Generated
        public B deleteHandler(String deleteHandler) {
            this.deleteHandler = deleteHandler;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B atlanTagName(String atlanTagName) {
            if (this.atlanTagNames == null) {
                this.atlanTagNames = new ArrayList();
            }
            this.atlanTagNames.add(atlanTagName);
            return (B)this.self();
        }

        @Deprecated
        @JsonProperty(value="classificationNames")
        @Generated
        public B atlanTagNames(Collection<? extends String> atlanTagNames) {
            if (atlanTagNames == null) {
                throw new NullPointerException("atlanTagNames cannot be null");
            }
            if (this.atlanTagNames == null) {
                this.atlanTagNames = new ArrayList();
            }
            this.atlanTagNames.addAll(atlanTagNames);
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B clearAtlanTagNames() {
            if (this.atlanTagNames != null) {
                this.atlanTagNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isIncomplete(Boolean isIncomplete) {
            this.isIncomplete = isIncomplete;
            return (B)this.self();
        }

        @Generated
        public B meaningName(String meaningName) {
            if (this.meaningNames == null) {
                this.meaningNames = new ArrayList();
            }
            this.meaningNames.add(meaningName);
            return (B)this.self();
        }

        @Generated
        public B meaningNames(Collection<? extends String> meaningNames) {
            if (meaningNames == null) {
                throw new NullPointerException("meaningNames cannot be null");
            }
            if (this.meaningNames == null) {
                this.meaningNames = new ArrayList();
            }
            this.meaningNames.addAll(meaningNames);
            return (B)this.self();
        }

        @Generated
        public B clearMeaningNames() {
            if (this.meaningNames != null) {
                this.meaningNames.clear();
            }
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B meaning(Meaning meaning) {
            if (this.meanings == null) {
                this.meanings = new ArrayList();
            }
            this.meanings.add(meaning);
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B meanings(Collection<? extends Meaning> meanings) {
            if (meanings == null) {
                throw new NullPointerException("meanings cannot be null");
            }
            if (this.meanings == null) {
                this.meanings = new ArrayList();
            }
            this.meanings.addAll(meanings);
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B clearMeanings() {
            if (this.meanings != null) {
                this.meanings.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B pendingTask(String pendingTask) {
            if (this.pendingTasks == null) {
                this.pendingTasks = new ArrayList();
            }
            this.pendingTasks.add(pendingTask);
            return (B)this.self();
        }

        @Generated
        public B pendingTasks(Collection<? extends String> pendingTasks) {
            if (pendingTasks == null) {
                throw new NullPointerException("pendingTasks cannot be null");
            }
            if (this.pendingTasks == null) {
                this.pendingTasks = new ArrayList();
            }
            this.pendingTasks.addAll(pendingTasks);
            return (B)this.self();
        }

        @Generated
        public B clearPendingTasks() {
            if (this.pendingTasks != null) {
                this.pendingTasks.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Asset.AssetBuilder(super=" + super.toString() + ", adminGroups=" + this.adminGroups + ", adminRoles=" + this.adminRoles + ", adminUsers=" + this.adminUsers + ", announcementMessage=" + this.announcementMessage + ", announcementTitle=" + this.announcementTitle + ", announcementType=" + this.announcementType + ", announcementUpdatedAt=" + this.announcementUpdatedAt + ", announcementUpdatedBy=" + this.announcementUpdatedBy + ", assetDbtAccountName=" + this.assetDbtAccountName + ", assetDbtAlias=" + this.assetDbtAlias + ", assetDbtEnvironmentDbtVersion=" + this.assetDbtEnvironmentDbtVersion + ", assetDbtEnvironmentName=" + this.assetDbtEnvironmentName + ", assetDbtJobLastRun=" + this.assetDbtJobLastRun + ", assetDbtJobLastRunArtifactS3Path=" + this.assetDbtJobLastRunArtifactS3Path + ", assetDbtJobLastRunArtifactsSaved=" + this.assetDbtJobLastRunArtifactsSaved + ", assetDbtJobLastRunCreatedAt=" + this.assetDbtJobLastRunCreatedAt + ", assetDbtJobLastRunDequedAt=" + this.assetDbtJobLastRunDequedAt + ", assetDbtJobLastRunExecutedByThreadId=" + this.assetDbtJobLastRunExecutedByThreadId + ", assetDbtJobLastRunGitBranch=" + this.assetDbtJobLastRunGitBranch + ", assetDbtJobLastRunGitSha=" + this.assetDbtJobLastRunGitSha + ", assetDbtJobLastRunHasDocsGenerated=" + this.assetDbtJobLastRunHasDocsGenerated + ", assetDbtJobLastRunHasSourcesGenerated=" + this.assetDbtJobLastRunHasSourcesGenerated + ", assetDbtJobLastRunNotificationsSent=" + this.assetDbtJobLastRunNotificationsSent + ", assetDbtJobLastRunOwnerThreadId=" + this.assetDbtJobLastRunOwnerThreadId + ", assetDbtJobLastRunQueuedDuration=" + this.assetDbtJobLastRunQueuedDuration + ", assetDbtJobLastRunQueuedDurationHumanized=" + this.assetDbtJobLastRunQueuedDurationHumanized + ", assetDbtJobLastRunRunDuration=" + this.assetDbtJobLastRunRunDuration + ", assetDbtJobLastRunRunDurationHumanized=" + this.assetDbtJobLastRunRunDurationHumanized + ", assetDbtJobLastRunStartedAt=" + this.assetDbtJobLastRunStartedAt + ", assetDbtJobLastRunStatusMessage=" + this.assetDbtJobLastRunStatusMessage + ", assetDbtJobLastRunTotalDuration=" + this.assetDbtJobLastRunTotalDuration + ", assetDbtJobLastRunTotalDurationHumanized=" + this.assetDbtJobLastRunTotalDurationHumanized + ", assetDbtJobLastRunUpdatedAt=" + this.assetDbtJobLastRunUpdatedAt + ", assetDbtJobLastRunUrl=" + this.assetDbtJobLastRunUrl + ", assetDbtJobName=" + this.assetDbtJobName + ", assetDbtJobNextRun=" + this.assetDbtJobNextRun + ", assetDbtJobNextRunHumanized=" + this.assetDbtJobNextRunHumanized + ", assetDbtJobSchedule=" + this.assetDbtJobSchedule + ", assetDbtJobScheduleCronHumanized=" + this.assetDbtJobScheduleCronHumanized + ", assetDbtJobStatus=" + this.assetDbtJobStatus + ", assetDbtMeta=" + this.assetDbtMeta + ", assetDbtPackageName=" + this.assetDbtPackageName + ", assetDbtProjectName=" + this.assetDbtProjectName + ", assetDbtSemanticLayerProxyUrl=" + this.assetDbtSemanticLayerProxyUrl + ", assetDbtSourceFreshnessCriteria=" + this.assetDbtSourceFreshnessCriteria + ", assetDbtTags=" + this.assetDbtTags + ", assetDbtTestStatus=" + this.assetDbtTestStatus + ", assetDbtUniqueId=" + this.assetDbtUniqueId + ", assetIcon=" + this.assetIcon + ", assetMcIncidentNames=" + this.assetMcIncidentNames + ", assetMcIncidentQualifiedNames=" + this.assetMcIncidentQualifiedNames + ", assetMcIncidentSeverities=" + this.assetMcIncidentSeverities + ", assetMcIncidentStates=" + this.assetMcIncidentStates + ", assetMcIncidentSubTypes=" + this.assetMcIncidentSubTypes + ", assetMcIncidentTypes=" + this.assetMcIncidentTypes + ", assetMcLastSyncRunAt=" + this.assetMcLastSyncRunAt + ", assetMcMonitorNames=" + this.assetMcMonitorNames + ", assetMcMonitorQualifiedNames=" + this.assetMcMonitorQualifiedNames + ", assetMcMonitorScheduleTypes=" + this.assetMcMonitorScheduleTypes + ", assetMcMonitorStatuses=" + this.assetMcMonitorStatuses + ", assetMcMonitorTypes=" + this.assetMcMonitorTypes + ", assetSodaCheckCount=" + this.assetSodaCheckCount + ", assetSodaCheckStatuses=" + this.assetSodaCheckStatuses + ", assetSodaDQStatus=" + this.assetSodaDQStatus + ", assetSodaLastScanAt=" + this.assetSodaLastScanAt + ", assetSodaLastSyncRunAt=" + this.assetSodaLastSyncRunAt + ", assetSodaSourceURL=" + this.assetSodaSourceURL + ", assetTags=" + this.assetTags + ", assignedTerms=" + this.assignedTerms + ", certificateStatus=" + this.certificateStatus + ", certificateStatusMessage=" + this.certificateStatusMessage + ", certificateUpdatedAt=" + this.certificateUpdatedAt + ", certificateUpdatedBy=" + this.certificateUpdatedBy + ", connectionName=" + this.connectionName + ", connectionQualifiedName=" + this.connectionQualifiedName + ", connectorType=" + this.connectorType + ", dbtQualifiedName=" + this.dbtQualifiedName + ", description=" + this.description + ", displayName=" + this.displayName + ", files=" + this.files + ", hasLineage=" + this.hasLineage + ", isDiscoverable=" + this.isDiscoverable + ", isEditable=" + this.isEditable + ", lastRowChangedAt=" + this.lastRowChangedAt + ", lastSyncRun=" + this.lastSyncRun + ", lastSyncRunAt=" + this.lastSyncRunAt + ", lastSyncWorkflowName=" + this.lastSyncWorkflowName + ", links=" + this.links + ", mcIncidents=" + this.mcIncidents + ", mcMonitors=" + this.mcMonitors + ", metrics=" + this.metrics + ", name=" + this.name + ", ownerGroups=" + this.ownerGroups + ", ownerUsers=" + this.ownerUsers + ", popularityScore=" + this.popularityScore + ", qualifiedName=" + this.qualifiedName + ", readme=" + this.readme + ", sampleDataUrl=" + this.sampleDataUrl + ", schemaRegistrySubjects=" + (this.schemaRegistrySubjects + ", sodaChecks=" + this.sodaChecks + ", sourceCostUnit=" + this.sourceCostUnit + ", sourceCreatedAt=" + this.sourceCreatedAt + ", sourceCreatedBy=" + this.sourceCreatedBy + ", sourceEmbedURL=" + this.sourceEmbedURL + ", sourceLastReadAt=" + this.sourceLastReadAt + ", sourceOwners=" + this.sourceOwners + ", sourceQueryComputeCostRecords=" + this.sourceQueryComputeCostRecords + ", sourceQueryComputeCosts=" + this.sourceQueryComputeCosts + ", sourceReadCount=" + this.sourceReadCount + ", sourceReadExpensiveQueryRecords=" + this.sourceReadExpensiveQueryRecords + ", sourceReadPopularQueryRecords=" + this.sourceReadPopularQueryRecords + ", sourceReadQueryCost=" + this.sourceReadQueryCost + ", sourceReadRecentUserRecords=" + this.sourceReadRecentUserRecords + ", sourceReadRecentUsers=" + this.sourceReadRecentUsers + ", sourceReadSlowQueryRecords=" + this.sourceReadSlowQueryRecords + ", sourceReadTopUserRecords=" + this.sourceReadTopUserRecords + ", sourceReadTopUsers=" + this.sourceReadTopUsers + ", sourceReadUserCount=" + this.sourceReadUserCount + ", sourceTotalCost=" + this.sourceTotalCost + ", sourceURL=" + this.sourceURL + ", sourceUpdatedAt=" + this.sourceUpdatedAt + ", sourceUpdatedBy=" + this.sourceUpdatedBy + ", starredBy=" + this.starredBy + ", starredCount=" + this.starredCount + ", starredDetails=" + this.starredDetails + ", subType=" + this.subType + ", tenantId=" + this.tenantId + ", userDescription=" + this.userDescription + ", viewScore=" + this.viewScore + ", viewerGroups=" + this.viewerGroups + ", viewerUsers=" + this.viewerUsers + ", nullFields=" + this.nullFields + ", atlanTags=" + this.atlanTags + ", customMetadataSets$key=" + this.customMetadataSets$key + ", customMetadataSets$value=" + this.customMetadataSets$value + ", status=" + this.status + ", createdBy=" + this.createdBy + ", updatedBy=" + this.updatedBy + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", deleteHandler=" + this.deleteHandler + ", atlanTagNames=" + this.atlanTagNames + ", isIncomplete=" + this.isIncomplete + ", meaningNames=" + this.meaningNames + ", meanings=" + this.meanings + ", pendingTasks=" + this.pendingTasks + ")");
        }
    }
}

