/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.AtlanCollection;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Folder;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IAtlanQuery;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IColumn;
import com.atlan.model.assets.IDbtModel;
import com.atlan.model.assets.IDbtSource;
import com.atlan.model.assets.IDbtTest;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.INamespace;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISQL;
import com.atlan.model.assets.ITable;
import com.atlan.model.assets.IView;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlanQuery
extends Asset
implements IAtlanQuery,
ISQL,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtlanQuery.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Query";
    String typeName;
    @Attribute
    String collectionQualifiedName;
    @Attribute
    SortedSet<IColumn> columns;
    @Attribute
    String databaseName;
    @Attribute
    String databaseQualifiedName;
    @Attribute
    SortedSet<IDbtModel> dbtModels;
    @Attribute
    SortedSet<IDbtSource> dbtSources;
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    @Attribute
    String defaultDatabaseQualifiedName;
    @Attribute
    String defaultSchemaQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    Boolean isPrivate;
    @Attribute
    Boolean isProfiled;
    @Attribute
    Boolean isSqlSnippet;
    @Attribute
    Boolean isVisualQuery;
    @Attribute
    Long lastProfiledAt;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    INamespace parent;
    @Attribute
    String parentQualifiedName;
    @Attribute
    Long queryCount;
    @Attribute
    Long queryCountUpdatedAt;
    @Attribute
    Long queryUserCount;
    @Attribute
    Map<String, Long> queryUserMap;
    @Attribute
    String rawQuery;
    @Attribute
    String schemaName;
    @Attribute
    String schemaQualifiedName;
    @Attribute
    SortedSet<IDbtSource> sqlDBTSources;
    @Attribute
    SortedSet<IDbtModel> sqlDbtModels;
    @Attribute
    String tableName;
    @Attribute
    String tableQualifiedName;
    @Attribute
    SortedSet<ITable> tables;
    @Attribute
    String variablesSchemaBase64;
    @Attribute
    String viewName;
    @Attribute
    String viewQualifiedName;
    @Attribute
    SortedSet<IView> views;
    @Attribute
    String visualBuilderSchemaBase64;

    @Override
    public AtlanQuery trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return AtlanQuery.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return AtlanQuery.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return AtlanQuery.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return AtlanQuery.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return AtlanQuery.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return AtlanQuery.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return AtlanQuery.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return AtlanQuery.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return AtlanQuery.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static AtlanQuery refByGuid(String guid) {
        return ((AtlanQueryBuilder)AtlanQuery._internal().guid(guid)).build();
    }

    public static AtlanQuery refByQualifiedName(String qualifiedName) {
        return ((AtlanQueryBuilder)AtlanQuery._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static AtlanQuery get(String id) throws AtlanException {
        return AtlanQuery.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static AtlanQuery get(AtlanClient client, String id) throws AtlanException {
        return AtlanQuery.get(client, id, true);
    }

    @JsonIgnore
    public static AtlanQuery get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof AtlanQuery) {
                return (AtlanQuery)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof AtlanQuery) {
            return (AtlanQuery)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static AtlanQuery retrieveByGuid(String guid) throws AtlanException {
        return AtlanQuery.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static AtlanQuery retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return AtlanQuery.get(client, guid);
    }

    @Deprecated
    public static AtlanQuery retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return AtlanQuery.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static AtlanQuery retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return AtlanQuery.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return AtlanQuery.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static AtlanQueryBuilder<?, ?> updater(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) {
        Asset parent = collectionQualifiedName.equals(parentQualifiedName) ? AtlanCollection.refByQualifiedName(collectionQualifiedName) : Folder.refByQualifiedName(parentQualifiedName);
        return ((AtlanQueryBuilder)((AtlanQueryBuilder)((AtlanQueryBuilder)((AtlanQueryBuilder)((AtlanQueryBuilder)AtlanQuery._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name)).parent((INamespace)((Object)parent))).parentQualifiedName(parentQualifiedName)).collectionQualifiedName(collectionQualifiedName);
    }

    public AtlanQueryBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (this.getCollectionQualifiedName() == null || this.getCollectionQualifiedName().length() == 0) {
            missing.add("collectionQualifiedName");
        }
        if (this.getParentQualifiedName() == null || this.getParentQualifiedName().length() == 0) {
            missing.add("parentQualifiedName");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return AtlanQuery.updater(this.getQualifiedName(), this.getName(), this.getCollectionQualifiedName(), this.getParentQualifiedName());
    }

    public static List<AtlanQuery> findByName(String name) throws AtlanException {
        return AtlanQuery.findByName(name, (List<AtlanField>)null);
    }

    public static List<AtlanQuery> findByName(String name, Collection<String> attributes) throws AtlanException {
        return AtlanQuery.findByName(Atlan.getDefaultClient(), name, attributes);
    }

    public static List<AtlanQuery> findByName(String name, List<AtlanField> attributes) throws AtlanException {
        return AtlanQuery.findByName(Atlan.getDefaultClient(), name, attributes);
    }

    public static List<AtlanQuery> findByName(AtlanClient client, String name) throws AtlanException {
        return AtlanQuery.findByName(client, name, (List<AtlanField>)null);
    }

    public static List<AtlanQuery> findByName(AtlanClient client, String name, Collection<String> attributes) throws AtlanException {
        ArrayList<AtlanQuery> results = new ArrayList<AtlanQuery>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AtlanQuery.select(client).where(NAME.eq(name)))._includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof AtlanQuery).forEach(q -> results.add((AtlanQuery)q));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.QUERY_NOT_FOUND_BY_NAME, name);
        }
        return results;
    }

    public static List<AtlanQuery> findByName(AtlanClient client, String name, List<AtlanField> attributes) throws AtlanException {
        ArrayList<AtlanQuery> results = new ArrayList<AtlanQuery>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AtlanQuery.select(client).where(NAME.eq(name))).includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof AtlanQuery).forEach(q -> results.add((AtlanQuery)q));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.QUERY_NOT_FOUND_BY_NAME, name);
        }
        return results;
    }

    public static AtlanQuery removeDescription(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return AtlanQuery.removeDescription(Atlan.getDefaultClient(), qualifiedName, name, collectionQualifiedName, parentQualifiedName);
    }

    public static AtlanQuery removeDescription(AtlanClient client, String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return (AtlanQuery)Asset.removeDescription(client, AtlanQuery.updater(qualifiedName, name, collectionQualifiedName, parentQualifiedName));
    }

    public static AtlanQuery removeUserDescription(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return AtlanQuery.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name, collectionQualifiedName, parentQualifiedName);
    }

    public static AtlanQuery removeUserDescription(AtlanClient client, String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return (AtlanQuery)Asset.removeUserDescription(client, AtlanQuery.updater(qualifiedName, name, collectionQualifiedName, parentQualifiedName));
    }

    public static AtlanQuery removeOwners(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return AtlanQuery.removeOwners(Atlan.getDefaultClient(), qualifiedName, name, collectionQualifiedName, parentQualifiedName);
    }

    public static AtlanQuery removeOwners(AtlanClient client, String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return (AtlanQuery)Asset.removeOwners(client, AtlanQuery.updater(qualifiedName, name, collectionQualifiedName, parentQualifiedName));
    }

    public static AtlanQuery updateCertificate(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return AtlanQuery.updateCertificate(Atlan.getDefaultClient(), qualifiedName, name, collectionQualifiedName, parentQualifiedName, certificate, message);
    }

    public static AtlanQuery updateCertificate(AtlanClient client, String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AtlanQuery)Asset.updateCertificate(client, AtlanQuery.updater(qualifiedName, name, collectionQualifiedName, parentQualifiedName), certificate, message);
    }

    public static AtlanQuery removeCertificate(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return AtlanQuery.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name, collectionQualifiedName, parentQualifiedName);
    }

    public static AtlanQuery removeCertificate(AtlanClient client, String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return (AtlanQuery)Asset.removeCertificate(client, AtlanQuery.updater(qualifiedName, name, collectionQualifiedName, parentQualifiedName));
    }

    public static AtlanQuery updateAnnouncement(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return AtlanQuery.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, name, collectionQualifiedName, parentQualifiedName, type, title, message);
    }

    public static AtlanQuery updateAnnouncement(AtlanClient client, String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AtlanQuery)Asset.updateAnnouncement(client, AtlanQuery.updater(qualifiedName, name, collectionQualifiedName, parentQualifiedName), type, title, message);
    }

    public static AtlanQuery removeAnnouncement(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return AtlanQuery.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name, collectionQualifiedName, parentQualifiedName);
    }

    public static AtlanQuery removeAnnouncement(AtlanClient client, String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return (AtlanQuery)Asset.removeAnnouncement(client, AtlanQuery.updater(qualifiedName, name, collectionQualifiedName, parentQualifiedName));
    }

    public static AtlanQuery appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return AtlanQuery.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static AtlanQuery appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AtlanQuery)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static AtlanQuery appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return AtlanQuery.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static AtlanQuery appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AtlanQuery)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        AtlanQuery.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        AtlanQuery.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        AtlanQuery.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AtlanQuery(AtlanQueryBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> queryUserMap;
        this.typeName = b.typeName$set ? b.typeName$value : AtlanQuery.$default$typeName();
        this.collectionQualifiedName = b.collectionQualifiedName;
        SortedSet<IColumn> columns = new TreeSet<IColumn>();
        if (b.columns != null) {
            columns.addAll(b.columns);
        }
        columns = Collections.unmodifiableSortedSet(columns);
        this.columns = columns;
        this.databaseName = b.databaseName;
        this.databaseQualifiedName = b.databaseQualifiedName;
        SortedSet<IDbtModel> dbtModels = new TreeSet<IDbtModel>();
        if (b.dbtModels != null) {
            dbtModels.addAll(b.dbtModels);
        }
        dbtModels = Collections.unmodifiableSortedSet(dbtModels);
        this.dbtModels = dbtModels;
        SortedSet<IDbtSource> dbtSources = new TreeSet<IDbtSource>();
        if (b.dbtSources != null) {
            dbtSources.addAll(b.dbtSources);
        }
        dbtSources = Collections.unmodifiableSortedSet(dbtSources);
        this.dbtSources = dbtSources;
        SortedSet<IDbtTest> dbtTests = new TreeSet<IDbtTest>();
        if (b.dbtTests != null) {
            dbtTests.addAll(b.dbtTests);
        }
        dbtTests = Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        this.defaultDatabaseQualifiedName = b.defaultDatabaseQualifiedName;
        this.defaultSchemaQualifiedName = b.defaultSchemaQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        this.isPrivate = b.isPrivate;
        this.isProfiled = b.isProfiled;
        this.isSqlSnippet = b.isSqlSnippet;
        this.isVisualQuery = b.isVisualQuery;
        this.lastProfiledAt = b.lastProfiledAt;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        this.parent = b.parent;
        this.parentQualifiedName = b.parentQualifiedName;
        this.queryCount = b.queryCount;
        this.queryCountUpdatedAt = b.queryCountUpdatedAt;
        this.queryUserCount = b.queryUserCount;
        switch (b.queryUserMap$key == null ? 0 : b.queryUserMap$key.size()) {
            case 0: {
                queryUserMap = Collections.emptyMap();
                break;
            }
            case 1: {
                queryUserMap = Collections.singletonMap(b.queryUserMap$key.get(0), b.queryUserMap$value.get(0));
                break;
            }
            default: {
                queryUserMap = new LinkedHashMap(b.queryUserMap$key.size() < 0x40000000 ? 1 + b.queryUserMap$key.size() + (b.queryUserMap$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryUserMap$key.size(); ++$i) {
                    queryUserMap.put(b.queryUserMap$key.get($i), b.queryUserMap$value.get($i));
                }
                queryUserMap = Collections.unmodifiableMap(queryUserMap);
            }
        }
        this.queryUserMap = queryUserMap;
        this.rawQuery = b.rawQuery;
        this.schemaName = b.schemaName;
        this.schemaQualifiedName = b.schemaQualifiedName;
        SortedSet<IDbtSource> sqlDBTSources = new TreeSet<IDbtSource>();
        if (b.sqlDBTSources != null) {
            sqlDBTSources.addAll(b.sqlDBTSources);
        }
        sqlDBTSources = Collections.unmodifiableSortedSet(sqlDBTSources);
        this.sqlDBTSources = sqlDBTSources;
        SortedSet<IDbtModel> sqlDbtModels = new TreeSet<IDbtModel>();
        if (b.sqlDbtModels != null) {
            sqlDbtModels.addAll(b.sqlDbtModels);
        }
        sqlDbtModels = Collections.unmodifiableSortedSet(sqlDbtModels);
        this.sqlDbtModels = sqlDbtModels;
        this.tableName = b.tableName;
        this.tableQualifiedName = b.tableQualifiedName;
        SortedSet<ITable> tables = new TreeSet<ITable>();
        if (b.tables != null) {
            tables.addAll(b.tables);
        }
        tables = Collections.unmodifiableSortedSet(tables);
        this.tables = tables;
        this.variablesSchemaBase64 = b.variablesSchemaBase64;
        this.viewName = b.viewName;
        this.viewQualifiedName = b.viewQualifiedName;
        SortedSet<IView> views = new TreeSet<IView>();
        if (b.views != null) {
            views.addAll(b.views);
        }
        views = Collections.unmodifiableSortedSet(views);
        this.views = views;
        this.visualBuilderSchemaBase64 = b.visualBuilderSchemaBase64;
    }

    @Generated
    public static AtlanQueryBuilder<?, ?> _internal() {
        return new AtlanQueryBuilderImpl();
    }

    @Generated
    public AtlanQueryBuilder<?, ?> toBuilder() {
        return new AtlanQueryBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getCollectionQualifiedName() {
        return this.collectionQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IColumn> getColumns() {
        return this.columns;
    }

    @Override
    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    @Generated
    public String getDatabaseQualifiedName() {
        return this.databaseQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IDbtModel> getDbtModels() {
        return this.dbtModels;
    }

    @Override
    @Generated
    public SortedSet<IDbtSource> getDbtSources() {
        return this.dbtSources;
    }

    @Override
    @Generated
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    @Override
    @Generated
    public String getDefaultDatabaseQualifiedName() {
        return this.defaultDatabaseQualifiedName;
    }

    @Override
    @Generated
    public String getDefaultSchemaQualifiedName() {
        return this.defaultSchemaQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public Boolean getIsPrivate() {
        return this.isPrivate;
    }

    @Override
    @Generated
    public Boolean getIsProfiled() {
        return this.isProfiled;
    }

    @Override
    @Generated
    public Boolean getIsSqlSnippet() {
        return this.isSqlSnippet;
    }

    @Override
    @Generated
    public Boolean getIsVisualQuery() {
        return this.isVisualQuery;
    }

    @Override
    @Generated
    public Long getLastProfiledAt() {
        return this.lastProfiledAt;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public INamespace getParent() {
        return this.parent;
    }

    @Override
    @Generated
    public String getParentQualifiedName() {
        return this.parentQualifiedName;
    }

    @Override
    @Generated
    public Long getQueryCount() {
        return this.queryCount;
    }

    @Override
    @Generated
    public Long getQueryCountUpdatedAt() {
        return this.queryCountUpdatedAt;
    }

    @Override
    @Generated
    public Long getQueryUserCount() {
        return this.queryUserCount;
    }

    @Override
    @Generated
    public Map<String, Long> getQueryUserMap() {
        return this.queryUserMap;
    }

    @Override
    @Generated
    public String getRawQuery() {
        return this.rawQuery;
    }

    @Override
    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    @Generated
    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IDbtSource> getSqlDBTSources() {
        return this.sqlDBTSources;
    }

    @Override
    @Generated
    public SortedSet<IDbtModel> getSqlDbtModels() {
        return this.sqlDbtModels;
    }

    @Override
    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @Generated
    public String getTableQualifiedName() {
        return this.tableQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<ITable> getTables() {
        return this.tables;
    }

    @Override
    @Generated
    public String getVariablesSchemaBase64() {
        return this.variablesSchemaBase64;
    }

    @Override
    @Generated
    public String getViewName() {
        return this.viewName;
    }

    @Override
    @Generated
    public String getViewQualifiedName() {
        return this.viewQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IView> getViews() {
        return this.views;
    }

    @Override
    @Generated
    public String getVisualBuilderSchemaBase64() {
        return this.visualBuilderSchemaBase64;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtlanQuery)) {
            return false;
        }
        AtlanQuery other = (AtlanQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isPrivate = this.getIsPrivate();
        Boolean other$isPrivate = other.getIsPrivate();
        if (this$isPrivate == null ? other$isPrivate != null : !((Object)this$isPrivate).equals(other$isPrivate)) {
            return false;
        }
        Boolean this$isProfiled = this.getIsProfiled();
        Boolean other$isProfiled = other.getIsProfiled();
        if (this$isProfiled == null ? other$isProfiled != null : !((Object)this$isProfiled).equals(other$isProfiled)) {
            return false;
        }
        Boolean this$isSqlSnippet = this.getIsSqlSnippet();
        Boolean other$isSqlSnippet = other.getIsSqlSnippet();
        if (this$isSqlSnippet == null ? other$isSqlSnippet != null : !((Object)this$isSqlSnippet).equals(other$isSqlSnippet)) {
            return false;
        }
        Boolean this$isVisualQuery = this.getIsVisualQuery();
        Boolean other$isVisualQuery = other.getIsVisualQuery();
        if (this$isVisualQuery == null ? other$isVisualQuery != null : !((Object)this$isVisualQuery).equals(other$isVisualQuery)) {
            return false;
        }
        Long this$lastProfiledAt = this.getLastProfiledAt();
        Long other$lastProfiledAt = other.getLastProfiledAt();
        if (this$lastProfiledAt == null ? other$lastProfiledAt != null : !((Object)this$lastProfiledAt).equals(other$lastProfiledAt)) {
            return false;
        }
        Long this$queryCount = this.getQueryCount();
        Long other$queryCount = other.getQueryCount();
        if (this$queryCount == null ? other$queryCount != null : !((Object)this$queryCount).equals(other$queryCount)) {
            return false;
        }
        Long this$queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        Long other$queryCountUpdatedAt = other.getQueryCountUpdatedAt();
        if (this$queryCountUpdatedAt == null ? other$queryCountUpdatedAt != null : !((Object)this$queryCountUpdatedAt).equals(other$queryCountUpdatedAt)) {
            return false;
        }
        Long this$queryUserCount = this.getQueryUserCount();
        Long other$queryUserCount = other.getQueryUserCount();
        if (this$queryUserCount == null ? other$queryUserCount != null : !((Object)this$queryUserCount).equals(other$queryUserCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$collectionQualifiedName = this.getCollectionQualifiedName();
        String other$collectionQualifiedName = other.getCollectionQualifiedName();
        if (this$collectionQualifiedName == null ? other$collectionQualifiedName != null : !this$collectionQualifiedName.equals(other$collectionQualifiedName)) {
            return false;
        }
        SortedSet<IColumn> this$columns = this.getColumns();
        SortedSet<IColumn> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$databaseQualifiedName = this.getDatabaseQualifiedName();
        String other$databaseQualifiedName = other.getDatabaseQualifiedName();
        if (this$databaseQualifiedName == null ? other$databaseQualifiedName != null : !this$databaseQualifiedName.equals(other$databaseQualifiedName)) {
            return false;
        }
        SortedSet<IDbtModel> this$dbtModels = this.getDbtModels();
        SortedSet<IDbtModel> other$dbtModels = other.getDbtModels();
        if (this$dbtModels == null ? other$dbtModels != null : !this$dbtModels.equals(other$dbtModels)) {
            return false;
        }
        SortedSet<IDbtSource> this$dbtSources = this.getDbtSources();
        SortedSet<IDbtSource> other$dbtSources = other.getDbtSources();
        if (this$dbtSources == null ? other$dbtSources != null : !this$dbtSources.equals(other$dbtSources)) {
            return false;
        }
        SortedSet<IDbtTest> this$dbtTests = this.getDbtTests();
        SortedSet<IDbtTest> other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) {
            return false;
        }
        String this$defaultDatabaseQualifiedName = this.getDefaultDatabaseQualifiedName();
        String other$defaultDatabaseQualifiedName = other.getDefaultDatabaseQualifiedName();
        if (this$defaultDatabaseQualifiedName == null ? other$defaultDatabaseQualifiedName != null : !this$defaultDatabaseQualifiedName.equals(other$defaultDatabaseQualifiedName)) {
            return false;
        }
        String this$defaultSchemaQualifiedName = this.getDefaultSchemaQualifiedName();
        String other$defaultSchemaQualifiedName = other.getDefaultSchemaQualifiedName();
        if (this$defaultSchemaQualifiedName == null ? other$defaultSchemaQualifiedName != null : !this$defaultSchemaQualifiedName.equals(other$defaultSchemaQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        INamespace this$parent = this.getParent();
        INamespace other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        String this$parentQualifiedName = this.getParentQualifiedName();
        String other$parentQualifiedName = other.getParentQualifiedName();
        if (this$parentQualifiedName == null ? other$parentQualifiedName != null : !this$parentQualifiedName.equals(other$parentQualifiedName)) {
            return false;
        }
        Map<String, Long> this$queryUserMap = this.getQueryUserMap();
        Map<String, Long> other$queryUserMap = other.getQueryUserMap();
        if (this$queryUserMap == null ? other$queryUserMap != null : !((Object)this$queryUserMap).equals(other$queryUserMap)) {
            return false;
        }
        String this$rawQuery = this.getRawQuery();
        String other$rawQuery = other.getRawQuery();
        if (this$rawQuery == null ? other$rawQuery != null : !this$rawQuery.equals(other$rawQuery)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$schemaQualifiedName = this.getSchemaQualifiedName();
        String other$schemaQualifiedName = other.getSchemaQualifiedName();
        if (this$schemaQualifiedName == null ? other$schemaQualifiedName != null : !this$schemaQualifiedName.equals(other$schemaQualifiedName)) {
            return false;
        }
        SortedSet<IDbtSource> this$sqlDBTSources = this.getSqlDBTSources();
        SortedSet<IDbtSource> other$sqlDBTSources = other.getSqlDBTSources();
        if (this$sqlDBTSources == null ? other$sqlDBTSources != null : !this$sqlDBTSources.equals(other$sqlDBTSources)) {
            return false;
        }
        SortedSet<IDbtModel> this$sqlDbtModels = this.getSqlDbtModels();
        SortedSet<IDbtModel> other$sqlDbtModels = other.getSqlDbtModels();
        if (this$sqlDbtModels == null ? other$sqlDbtModels != null : !this$sqlDbtModels.equals(other$sqlDbtModels)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$tableQualifiedName = this.getTableQualifiedName();
        String other$tableQualifiedName = other.getTableQualifiedName();
        if (this$tableQualifiedName == null ? other$tableQualifiedName != null : !this$tableQualifiedName.equals(other$tableQualifiedName)) {
            return false;
        }
        SortedSet<ITable> this$tables = this.getTables();
        SortedSet<ITable> other$tables = other.getTables();
        if (this$tables == null ? other$tables != null : !this$tables.equals(other$tables)) {
            return false;
        }
        String this$variablesSchemaBase64 = this.getVariablesSchemaBase64();
        String other$variablesSchemaBase64 = other.getVariablesSchemaBase64();
        if (this$variablesSchemaBase64 == null ? other$variablesSchemaBase64 != null : !this$variablesSchemaBase64.equals(other$variablesSchemaBase64)) {
            return false;
        }
        String this$viewName = this.getViewName();
        String other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName)) {
            return false;
        }
        String this$viewQualifiedName = this.getViewQualifiedName();
        String other$viewQualifiedName = other.getViewQualifiedName();
        if (this$viewQualifiedName == null ? other$viewQualifiedName != null : !this$viewQualifiedName.equals(other$viewQualifiedName)) {
            return false;
        }
        SortedSet<IView> this$views = this.getViews();
        SortedSet<IView> other$views = other.getViews();
        if (this$views == null ? other$views != null : !this$views.equals(other$views)) {
            return false;
        }
        String this$visualBuilderSchemaBase64 = this.getVisualBuilderSchemaBase64();
        String other$visualBuilderSchemaBase64 = other.getVisualBuilderSchemaBase64();
        return !(this$visualBuilderSchemaBase64 == null ? other$visualBuilderSchemaBase64 != null : !this$visualBuilderSchemaBase64.equals(other$visualBuilderSchemaBase64));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtlanQuery;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isPrivate = this.getIsPrivate();
        result = result * 59 + ($isPrivate == null ? 43 : ((Object)$isPrivate).hashCode());
        Boolean $isProfiled = this.getIsProfiled();
        result = result * 59 + ($isProfiled == null ? 43 : ((Object)$isProfiled).hashCode());
        Boolean $isSqlSnippet = this.getIsSqlSnippet();
        result = result * 59 + ($isSqlSnippet == null ? 43 : ((Object)$isSqlSnippet).hashCode());
        Boolean $isVisualQuery = this.getIsVisualQuery();
        result = result * 59 + ($isVisualQuery == null ? 43 : ((Object)$isVisualQuery).hashCode());
        Long $lastProfiledAt = this.getLastProfiledAt();
        result = result * 59 + ($lastProfiledAt == null ? 43 : ((Object)$lastProfiledAt).hashCode());
        Long $queryCount = this.getQueryCount();
        result = result * 59 + ($queryCount == null ? 43 : ((Object)$queryCount).hashCode());
        Long $queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        result = result * 59 + ($queryCountUpdatedAt == null ? 43 : ((Object)$queryCountUpdatedAt).hashCode());
        Long $queryUserCount = this.getQueryUserCount();
        result = result * 59 + ($queryUserCount == null ? 43 : ((Object)$queryUserCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $collectionQualifiedName = this.getCollectionQualifiedName();
        result = result * 59 + ($collectionQualifiedName == null ? 43 : $collectionQualifiedName.hashCode());
        SortedSet<IColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : $columns.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $databaseQualifiedName = this.getDatabaseQualifiedName();
        result = result * 59 + ($databaseQualifiedName == null ? 43 : $databaseQualifiedName.hashCode());
        SortedSet<IDbtModel> $dbtModels = this.getDbtModels();
        result = result * 59 + ($dbtModels == null ? 43 : $dbtModels.hashCode());
        SortedSet<IDbtSource> $dbtSources = this.getDbtSources();
        result = result * 59 + ($dbtSources == null ? 43 : $dbtSources.hashCode());
        SortedSet<IDbtTest> $dbtTests = this.getDbtTests();
        result = result * 59 + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        String $defaultDatabaseQualifiedName = this.getDefaultDatabaseQualifiedName();
        result = result * 59 + ($defaultDatabaseQualifiedName == null ? 43 : $defaultDatabaseQualifiedName.hashCode());
        String $defaultSchemaQualifiedName = this.getDefaultSchemaQualifiedName();
        result = result * 59 + ($defaultSchemaQualifiedName == null ? 43 : $defaultSchemaQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        INamespace $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        String $parentQualifiedName = this.getParentQualifiedName();
        result = result * 59 + ($parentQualifiedName == null ? 43 : $parentQualifiedName.hashCode());
        Map<String, Long> $queryUserMap = this.getQueryUserMap();
        result = result * 59 + ($queryUserMap == null ? 43 : ((Object)$queryUserMap).hashCode());
        String $rawQuery = this.getRawQuery();
        result = result * 59 + ($rawQuery == null ? 43 : $rawQuery.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $schemaQualifiedName = this.getSchemaQualifiedName();
        result = result * 59 + ($schemaQualifiedName == null ? 43 : $schemaQualifiedName.hashCode());
        SortedSet<IDbtSource> $sqlDBTSources = this.getSqlDBTSources();
        result = result * 59 + ($sqlDBTSources == null ? 43 : $sqlDBTSources.hashCode());
        SortedSet<IDbtModel> $sqlDbtModels = this.getSqlDbtModels();
        result = result * 59 + ($sqlDbtModels == null ? 43 : $sqlDbtModels.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $tableQualifiedName = this.getTableQualifiedName();
        result = result * 59 + ($tableQualifiedName == null ? 43 : $tableQualifiedName.hashCode());
        SortedSet<ITable> $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : $tables.hashCode());
        String $variablesSchemaBase64 = this.getVariablesSchemaBase64();
        result = result * 59 + ($variablesSchemaBase64 == null ? 43 : $variablesSchemaBase64.hashCode());
        String $viewName = this.getViewName();
        result = result * 59 + ($viewName == null ? 43 : $viewName.hashCode());
        String $viewQualifiedName = this.getViewQualifiedName();
        result = result * 59 + ($viewQualifiedName == null ? 43 : $viewQualifiedName.hashCode());
        SortedSet<IView> $views = this.getViews();
        result = result * 59 + ($views == null ? 43 : $views.hashCode());
        String $visualBuilderSchemaBase64 = this.getVisualBuilderSchemaBase64();
        result = result * 59 + ($visualBuilderSchemaBase64 == null ? 43 : $visualBuilderSchemaBase64.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AtlanQuery(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", collectionQualifiedName=" + this.getCollectionQualifiedName() + ", columns=" + this.getColumns() + ", databaseName=" + this.getDatabaseName() + ", databaseQualifiedName=" + this.getDatabaseQualifiedName() + ", dbtModels=" + this.getDbtModels() + ", dbtSources=" + this.getDbtSources() + ", dbtTests=" + this.getDbtTests() + ", defaultDatabaseQualifiedName=" + this.getDefaultDatabaseQualifiedName() + ", defaultSchemaQualifiedName=" + this.getDefaultSchemaQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", isPrivate=" + this.getIsPrivate() + ", isProfiled=" + this.getIsProfiled() + ", isSqlSnippet=" + this.getIsSqlSnippet() + ", isVisualQuery=" + this.getIsVisualQuery() + ", lastProfiledAt=" + this.getLastProfiledAt() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", parent=" + this.getParent() + ", parentQualifiedName=" + this.getParentQualifiedName() + ", queryCount=" + this.getQueryCount() + ", queryCountUpdatedAt=" + this.getQueryCountUpdatedAt() + ", queryUserCount=" + this.getQueryUserCount() + ", queryUserMap=" + this.getQueryUserMap() + ", rawQuery=" + this.getRawQuery() + ", schemaName=" + this.getSchemaName() + ", schemaQualifiedName=" + this.getSchemaQualifiedName() + ", sqlDBTSources=" + this.getSqlDBTSources() + ", sqlDbtModels=" + this.getSqlDbtModels() + ", tableName=" + this.getTableName() + ", tableQualifiedName=" + this.getTableQualifiedName() + ", tables=" + this.getTables() + ", variablesSchemaBase64=" + this.getVariablesSchemaBase64() + ", viewName=" + this.getViewName() + ", viewQualifiedName=" + this.getViewQualifiedName() + ", views=" + this.getViews() + ", visualBuilderSchemaBase64=" + this.getVisualBuilderSchemaBase64() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class AtlanQueryBuilderImpl
    extends AtlanQueryBuilder<AtlanQuery, AtlanQueryBuilderImpl> {
        @Generated
        private AtlanQueryBuilderImpl() {
        }

        @Override
        @Generated
        protected AtlanQueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AtlanQuery build() {
            return new AtlanQuery(this);
        }
    }

    @Generated
    public static abstract class AtlanQueryBuilder<C extends AtlanQuery, B extends AtlanQueryBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String collectionQualifiedName;
        @Generated
        private ArrayList<IColumn> columns;
        @Generated
        private String databaseName;
        @Generated
        private String databaseQualifiedName;
        @Generated
        private ArrayList<IDbtModel> dbtModels;
        @Generated
        private ArrayList<IDbtSource> dbtSources;
        @Generated
        private ArrayList<IDbtTest> dbtTests;
        @Generated
        private String defaultDatabaseQualifiedName;
        @Generated
        private String defaultSchemaQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private Boolean isPrivate;
        @Generated
        private Boolean isProfiled;
        @Generated
        private Boolean isSqlSnippet;
        @Generated
        private Boolean isVisualQuery;
        @Generated
        private Long lastProfiledAt;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private INamespace parent;
        @Generated
        private String parentQualifiedName;
        @Generated
        private Long queryCount;
        @Generated
        private Long queryCountUpdatedAt;
        @Generated
        private Long queryUserCount;
        @Generated
        private ArrayList<String> queryUserMap$key;
        @Generated
        private ArrayList<Long> queryUserMap$value;
        @Generated
        private String rawQuery;
        @Generated
        private String schemaName;
        @Generated
        private String schemaQualifiedName;
        @Generated
        private ArrayList<IDbtSource> sqlDBTSources;
        @Generated
        private ArrayList<IDbtModel> sqlDbtModels;
        @Generated
        private String tableName;
        @Generated
        private String tableQualifiedName;
        @Generated
        private ArrayList<ITable> tables;
        @Generated
        private String variablesSchemaBase64;
        @Generated
        private String viewName;
        @Generated
        private String viewQualifiedName;
        @Generated
        private ArrayList<IView> views;
        @Generated
        private String visualBuilderSchemaBase64;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AtlanQueryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AtlanQuery instance, AtlanQueryBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.collectionQualifiedName(instance.collectionQualifiedName);
            b.columns(instance.columns == null ? Collections.emptySortedSet() : instance.columns);
            b.databaseName(instance.databaseName);
            b.databaseQualifiedName(instance.databaseQualifiedName);
            b.dbtModels(instance.dbtModels == null ? Collections.emptySortedSet() : instance.dbtModels);
            b.dbtSources(instance.dbtSources == null ? Collections.emptySortedSet() : instance.dbtSources);
            b.dbtTests(instance.dbtTests == null ? Collections.emptySortedSet() : instance.dbtTests);
            b.defaultDatabaseQualifiedName(instance.defaultDatabaseQualifiedName);
            b.defaultSchemaQualifiedName(instance.defaultSchemaQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.isPrivate(instance.isPrivate);
            b.isProfiled(instance.isProfiled);
            b.isSqlSnippet(instance.isSqlSnippet);
            b.isVisualQuery(instance.isVisualQuery);
            b.lastProfiledAt(instance.lastProfiledAt);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.parent(instance.parent);
            b.parentQualifiedName(instance.parentQualifiedName);
            b.queryCount(instance.queryCount);
            b.queryCountUpdatedAt(instance.queryCountUpdatedAt);
            b.queryUserCount(instance.queryUserCount);
            b.queryUserMap(instance.queryUserMap == null ? Collections.emptyMap() : instance.queryUserMap);
            b.rawQuery(instance.rawQuery);
            b.schemaName(instance.schemaName);
            b.schemaQualifiedName(instance.schemaQualifiedName);
            b.sqlDBTSources(instance.sqlDBTSources == null ? Collections.emptySortedSet() : instance.sqlDBTSources);
            b.sqlDbtModels(instance.sqlDbtModels == null ? Collections.emptySortedSet() : instance.sqlDbtModels);
            b.tableName(instance.tableName);
            b.tableQualifiedName(instance.tableQualifiedName);
            b.tables(instance.tables == null ? Collections.emptySortedSet() : instance.tables);
            b.variablesSchemaBase64(instance.variablesSchemaBase64);
            b.viewName(instance.viewName);
            b.viewQualifiedName(instance.viewQualifiedName);
            b.views(instance.views == null ? Collections.emptySortedSet() : instance.views);
            b.visualBuilderSchemaBase64(instance.visualBuilderSchemaBase64);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B collectionQualifiedName(String collectionQualifiedName) {
            this.collectionQualifiedName = collectionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B column(IColumn column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return (B)this.self();
        }

        @Generated
        public B columns(Collection<? extends IColumn> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return (B)this.self();
        }

        @Generated
        public B clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B databaseName(String databaseName) {
            this.databaseName = databaseName;
            return (B)this.self();
        }

        @Generated
        public B databaseQualifiedName(String databaseQualifiedName) {
            this.databaseQualifiedName = databaseQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dbtModel(IDbtModel dbtModel) {
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.add(dbtModel);
            return (B)this.self();
        }

        @Generated
        public B dbtModels(Collection<? extends IDbtModel> dbtModels) {
            if (dbtModels == null) {
                throw new NullPointerException("dbtModels cannot be null");
            }
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.addAll(dbtModels);
            return (B)this.self();
        }

        @Generated
        public B clearDbtModels() {
            if (this.dbtModels != null) {
                this.dbtModels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtSource(IDbtSource dbtSource) {
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.add(dbtSource);
            return (B)this.self();
        }

        @Generated
        public B dbtSources(Collection<? extends IDbtSource> dbtSources) {
            if (dbtSources == null) {
                throw new NullPointerException("dbtSources cannot be null");
            }
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.addAll(dbtSources);
            return (B)this.self();
        }

        @Generated
        public B clearDbtSources() {
            if (this.dbtSources != null) {
                this.dbtSources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtTest(IDbtTest dbtTest) {
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.add(dbtTest);
            return (B)this.self();
        }

        @Generated
        public B dbtTests(Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.addAll(dbtTests);
            return (B)this.self();
        }

        @Generated
        public B clearDbtTests() {
            if (this.dbtTests != null) {
                this.dbtTests.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B defaultDatabaseQualifiedName(String defaultDatabaseQualifiedName) {
            this.defaultDatabaseQualifiedName = defaultDatabaseQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B defaultSchemaQualifiedName(String defaultSchemaQualifiedName) {
            this.defaultSchemaQualifiedName = defaultSchemaQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isPrivate(Boolean isPrivate) {
            this.isPrivate = isPrivate;
            return (B)this.self();
        }

        @Generated
        public B isProfiled(Boolean isProfiled) {
            this.isProfiled = isProfiled;
            return (B)this.self();
        }

        @Generated
        public B isSqlSnippet(Boolean isSqlSnippet) {
            this.isSqlSnippet = isSqlSnippet;
            return (B)this.self();
        }

        @Generated
        public B isVisualQuery(Boolean isVisualQuery) {
            this.isVisualQuery = isVisualQuery;
            return (B)this.self();
        }

        @Generated
        public B lastProfiledAt(Long lastProfiledAt) {
            this.lastProfiledAt = lastProfiledAt;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B parent(INamespace parent) {
            this.parent = parent;
            return (B)this.self();
        }

        @Generated
        public B parentQualifiedName(String parentQualifiedName) {
            this.parentQualifiedName = parentQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B queryCount(Long queryCount) {
            this.queryCount = queryCount;
            return (B)this.self();
        }

        @Generated
        public B queryCountUpdatedAt(Long queryCountUpdatedAt) {
            this.queryCountUpdatedAt = queryCountUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B queryUserCount(Long queryUserCount) {
            this.queryUserCount = queryUserCount;
            return (B)this.self();
        }

        @Generated
        public B putQueryUserMap(String putQueryUserMapKey, Long putQueryUserMapValue) {
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            this.queryUserMap$key.add(putQueryUserMapKey);
            this.queryUserMap$value.add(putQueryUserMapValue);
            return (B)this.self();
        }

        @Generated
        public B queryUserMap(Map<? extends String, ? extends Long> queryUserMap) {
            if (queryUserMap == null) {
                throw new NullPointerException("queryUserMap cannot be null");
            }
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Long> $lombokEntry : queryUserMap.entrySet()) {
                this.queryUserMap$key.add($lombokEntry.getKey());
                this.queryUserMap$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearQueryUserMap() {
            if (this.queryUserMap$key != null) {
                this.queryUserMap$key.clear();
                this.queryUserMap$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B rawQuery(String rawQuery) {
            this.rawQuery = rawQuery;
            return (B)this.self();
        }

        @Generated
        public B schemaName(String schemaName) {
            this.schemaName = schemaName;
            return (B)this.self();
        }

        @Generated
        public B schemaQualifiedName(String schemaQualifiedName) {
            this.schemaQualifiedName = schemaQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sqlDBTSource(IDbtSource sqlDBTSource) {
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.add(sqlDBTSource);
            return (B)this.self();
        }

        @Generated
        public B sqlDBTSources(Collection<? extends IDbtSource> sqlDBTSources) {
            if (sqlDBTSources == null) {
                throw new NullPointerException("sqlDBTSources cannot be null");
            }
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.addAll(sqlDBTSources);
            return (B)this.self();
        }

        @Generated
        public B clearSqlDBTSources() {
            if (this.sqlDBTSources != null) {
                this.sqlDBTSources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sqlDbtModel(IDbtModel sqlDbtModel) {
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.add(sqlDbtModel);
            return (B)this.self();
        }

        @Generated
        public B sqlDbtModels(Collection<? extends IDbtModel> sqlDbtModels) {
            if (sqlDbtModels == null) {
                throw new NullPointerException("sqlDbtModels cannot be null");
            }
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.addAll(sqlDbtModels);
            return (B)this.self();
        }

        @Generated
        public B clearSqlDbtModels() {
            if (this.sqlDbtModels != null) {
                this.sqlDbtModels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        @Generated
        public B tableQualifiedName(String tableQualifiedName) {
            this.tableQualifiedName = tableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B table(ITable table) {
            if (this.tables == null) {
                this.tables = new ArrayList();
            }
            this.tables.add(table);
            return (B)this.self();
        }

        @Generated
        public B tables(Collection<? extends ITable> tables) {
            if (tables == null) {
                throw new NullPointerException("tables cannot be null");
            }
            if (this.tables == null) {
                this.tables = new ArrayList();
            }
            this.tables.addAll(tables);
            return (B)this.self();
        }

        @Generated
        public B clearTables() {
            if (this.tables != null) {
                this.tables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B variablesSchemaBase64(String variablesSchemaBase64) {
            this.variablesSchemaBase64 = variablesSchemaBase64;
            return (B)this.self();
        }

        @Generated
        public B viewName(String viewName) {
            this.viewName = viewName;
            return (B)this.self();
        }

        @Generated
        public B viewQualifiedName(String viewQualifiedName) {
            this.viewQualifiedName = viewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B view(IView view) {
            if (this.views == null) {
                this.views = new ArrayList();
            }
            this.views.add(view);
            return (B)this.self();
        }

        @Generated
        public B views(Collection<? extends IView> views) {
            if (views == null) {
                throw new NullPointerException("views cannot be null");
            }
            if (this.views == null) {
                this.views = new ArrayList();
            }
            this.views.addAll(views);
            return (B)this.self();
        }

        @Generated
        public B clearViews() {
            if (this.views != null) {
                this.views.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B visualBuilderSchemaBase64(String visualBuilderSchemaBase64) {
            this.visualBuilderSchemaBase64 = visualBuilderSchemaBase64;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "AtlanQuery.AtlanQueryBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", collectionQualifiedName=" + this.collectionQualifiedName + ", columns=" + this.columns + ", databaseName=" + this.databaseName + ", databaseQualifiedName=" + this.databaseQualifiedName + ", dbtModels=" + this.dbtModels + ", dbtSources=" + this.dbtSources + ", dbtTests=" + this.dbtTests + ", defaultDatabaseQualifiedName=" + this.defaultDatabaseQualifiedName + ", defaultSchemaQualifiedName=" + this.defaultSchemaQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", isPrivate=" + this.isPrivate + ", isProfiled=" + this.isProfiled + ", isSqlSnippet=" + this.isSqlSnippet + ", isVisualQuery=" + this.isVisualQuery + ", lastProfiledAt=" + this.lastProfiledAt + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", parent=" + this.parent + ", parentQualifiedName=" + this.parentQualifiedName + ", queryCount=" + this.queryCount + ", queryCountUpdatedAt=" + this.queryCountUpdatedAt + ", queryUserCount=" + this.queryUserCount + ", queryUserMap$key=" + this.queryUserMap$key + ", queryUserMap$value=" + this.queryUserMap$value + ", rawQuery=" + this.rawQuery + ", schemaName=" + this.schemaName + ", schemaQualifiedName=" + this.schemaQualifiedName + ", sqlDBTSources=" + this.sqlDBTSources + ", sqlDbtModels=" + this.sqlDbtModels + ", tableName=" + this.tableName + ", tableQualifiedName=" + this.tableQualifiedName + ", tables=" + this.tables + ", variablesSchemaBase64=" + this.variablesSchemaBase64 + ", viewName=" + this.viewName + ", viewQualifiedName=" + this.viewQualifiedName + ", views=" + this.views + ", visualBuilderSchemaBase64=" + this.visualBuilderSchemaBase64 + ")";
        }
    }
}

