/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBIProcess;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IColumnProcess;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BIProcess
extends Asset
implements IBIProcess,
ILineageProcess,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BIProcess.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "BIProcess";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> airflowTasks;
    @Attribute
    String ast;
    @Attribute
    String code;
    @Attribute
    SortedSet<IColumnProcess> columnProcesses;
    @Attribute
    SortedSet<ICatalog> inputs;
    @Attribute
    SortedSet<ICatalog> outputs;
    @Attribute
    String sql;

    @Override
    public BIProcess trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return BIProcess.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return BIProcess.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return BIProcess.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return BIProcess.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return BIProcess.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return BIProcess.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return BIProcess.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return BIProcess.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return BIProcess.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static BIProcess refByGuid(String guid) {
        return ((BIProcessBuilder)BIProcess._internal().guid(guid)).build();
    }

    public static BIProcess refByQualifiedName(String qualifiedName) {
        return ((BIProcessBuilder)BIProcess._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static BIProcess get(String id) throws AtlanException {
        return BIProcess.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static BIProcess get(AtlanClient client, String id) throws AtlanException {
        return BIProcess.get(client, id, true);
    }

    @JsonIgnore
    public static BIProcess get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof BIProcess) {
                return (BIProcess)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof BIProcess) {
            return (BIProcess)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static BIProcess retrieveByGuid(String guid) throws AtlanException {
        return BIProcess.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static BIProcess retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return BIProcess.get(client, guid);
    }

    @Deprecated
    public static BIProcess retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return BIProcess.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static BIProcess retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return BIProcess.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return BIProcess.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static BIProcessBuilder<?, ?> updater(String qualifiedName, String name) {
        return (BIProcessBuilder)((BIProcessBuilder)((BIProcessBuilder)BIProcess._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public BIProcessBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return BIProcess.updater(this.getQualifiedName(), this.getName());
    }

    public static BIProcess removeDescription(String qualifiedName, String name) throws AtlanException {
        return BIProcess.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static BIProcess removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BIProcess)Asset.removeDescription(client, BIProcess.updater(qualifiedName, name));
    }

    public static BIProcess removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return BIProcess.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static BIProcess removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BIProcess)Asset.removeUserDescription(client, BIProcess.updater(qualifiedName, name));
    }

    public static BIProcess removeOwners(String qualifiedName, String name) throws AtlanException {
        return BIProcess.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static BIProcess removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BIProcess)Asset.removeOwners(client, BIProcess.updater(qualifiedName, name));
    }

    public static BIProcess updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return BIProcess.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static BIProcess updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (BIProcess)Asset.updateCertificate(client, BIProcess._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static BIProcess removeCertificate(String qualifiedName, String name) throws AtlanException {
        return BIProcess.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static BIProcess removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BIProcess)Asset.removeCertificate(client, BIProcess.updater(qualifiedName, name));
    }

    public static BIProcess updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return BIProcess.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static BIProcess updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (BIProcess)Asset.updateAnnouncement(client, BIProcess._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static BIProcess removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return BIProcess.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static BIProcess removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BIProcess)Asset.removeAnnouncement(client, BIProcess.updater(qualifiedName, name));
    }

    public static BIProcess replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return BIProcess.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static BIProcess replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (BIProcess)Asset.replaceTerms(client, BIProcess.updater(qualifiedName, name), terms);
    }

    public static BIProcess appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return BIProcess.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static BIProcess appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (BIProcess)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static BIProcess removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return BIProcess.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static BIProcess removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (BIProcess)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static BIProcess appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return BIProcess.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static BIProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (BIProcess)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static BIProcess appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return BIProcess.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static BIProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (BIProcess)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        BIProcess.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        BIProcess.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        BIProcess.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected BIProcess(BIProcessBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : BIProcess.$default$typeName();
        SortedSet<IAirflowTask> airflowTasks = new TreeSet<IAirflowTask>();
        if (b.airflowTasks != null) {
            airflowTasks.addAll(b.airflowTasks);
        }
        airflowTasks = Collections.unmodifiableSortedSet(airflowTasks);
        this.airflowTasks = airflowTasks;
        this.ast = b.ast;
        this.code = b.code;
        SortedSet<IColumnProcess> columnProcesses = new TreeSet<IColumnProcess>();
        if (b.columnProcesses != null) {
            columnProcesses.addAll(b.columnProcesses);
        }
        columnProcesses = Collections.unmodifiableSortedSet(columnProcesses);
        this.columnProcesses = columnProcesses;
        SortedSet<ICatalog> inputs = new TreeSet<ICatalog>();
        if (b.inputs != null) {
            inputs.addAll(b.inputs);
        }
        inputs = Collections.unmodifiableSortedSet(inputs);
        this.inputs = inputs;
        SortedSet<ICatalog> outputs = new TreeSet<ICatalog>();
        if (b.outputs != null) {
            outputs.addAll(b.outputs);
        }
        outputs = Collections.unmodifiableSortedSet(outputs);
        this.outputs = outputs;
        this.sql = b.sql;
    }

    @Generated
    public static BIProcessBuilder<?, ?> _internal() {
        return new BIProcessBuilderImpl();
    }

    @Generated
    public BIProcessBuilder<?, ?> toBuilder() {
        return new BIProcessBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getAirflowTasks() {
        return this.airflowTasks;
    }

    @Override
    @Generated
    public String getAst() {
        return this.ast;
    }

    @Override
    @Generated
    public String getCode() {
        return this.code;
    }

    @Override
    @Generated
    public SortedSet<IColumnProcess> getColumnProcesses() {
        return this.columnProcesses;
    }

    @Override
    @Generated
    public SortedSet<ICatalog> getInputs() {
        return this.inputs;
    }

    @Override
    @Generated
    public SortedSet<ICatalog> getOutputs() {
        return this.outputs;
    }

    @Override
    @Generated
    public String getSql() {
        return this.sql;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BIProcess)) {
            return false;
        }
        BIProcess other = (BIProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$airflowTasks = this.getAirflowTasks();
        SortedSet<IAirflowTask> other$airflowTasks = other.getAirflowTasks();
        if (this$airflowTasks == null ? other$airflowTasks != null : !this$airflowTasks.equals(other$airflowTasks)) {
            return false;
        }
        String this$ast = this.getAst();
        String other$ast = other.getAst();
        if (this$ast == null ? other$ast != null : !this$ast.equals(other$ast)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        SortedSet<IColumnProcess> this$columnProcesses = this.getColumnProcesses();
        SortedSet<IColumnProcess> other$columnProcesses = other.getColumnProcesses();
        if (this$columnProcesses == null ? other$columnProcesses != null : !this$columnProcesses.equals(other$columnProcesses)) {
            return false;
        }
        SortedSet<ICatalog> this$inputs = this.getInputs();
        SortedSet<ICatalog> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) {
            return false;
        }
        SortedSet<ICatalog> this$outputs = this.getOutputs();
        SortedSet<ICatalog> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !this$outputs.equals(other$outputs)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        return !(this$sql == null ? other$sql != null : !this$sql.equals(other$sql));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BIProcess;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $airflowTasks = this.getAirflowTasks();
        result = result * 59 + ($airflowTasks == null ? 43 : $airflowTasks.hashCode());
        String $ast = this.getAst();
        result = result * 59 + ($ast == null ? 43 : $ast.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        SortedSet<IColumnProcess> $columnProcesses = this.getColumnProcesses();
        result = result * 59 + ($columnProcesses == null ? 43 : $columnProcesses.hashCode());
        SortedSet<ICatalog> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : $inputs.hashCode());
        SortedSet<ICatalog> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : $outputs.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "BIProcess(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", airflowTasks=" + this.getAirflowTasks() + ", ast=" + this.getAst() + ", code=" + this.getCode() + ", columnProcesses=" + this.getColumnProcesses() + ", inputs=" + this.getInputs() + ", outputs=" + this.getOutputs() + ", sql=" + this.getSql() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class BIProcessBuilderImpl
    extends BIProcessBuilder<BIProcess, BIProcessBuilderImpl> {
        @Generated
        private BIProcessBuilderImpl() {
        }

        @Override
        @Generated
        protected BIProcessBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BIProcess build() {
            return new BIProcess(this);
        }
    }

    @Generated
    public static abstract class BIProcessBuilder<C extends BIProcess, B extends BIProcessBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> airflowTasks;
        @Generated
        private String ast;
        @Generated
        private String code;
        @Generated
        private ArrayList<IColumnProcess> columnProcesses;
        @Generated
        private ArrayList<ICatalog> inputs;
        @Generated
        private ArrayList<ICatalog> outputs;
        @Generated
        private String sql;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BIProcessBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(BIProcess instance, BIProcessBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.airflowTasks(instance.airflowTasks == null ? Collections.emptySortedSet() : instance.airflowTasks);
            b.ast(instance.ast);
            b.code(instance.code);
            b.columnProcesses(instance.columnProcesses == null ? Collections.emptySortedSet() : instance.columnProcesses);
            b.inputs(instance.inputs == null ? Collections.emptySortedSet() : instance.inputs);
            b.outputs(instance.outputs == null ? Collections.emptySortedSet() : instance.outputs);
            b.sql(instance.sql);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B airflowTask(IAirflowTask airflowTask) {
            if (this.airflowTasks == null) {
                this.airflowTasks = new ArrayList();
            }
            this.airflowTasks.add(airflowTask);
            return (B)this.self();
        }

        @Generated
        public B airflowTasks(Collection<? extends IAirflowTask> airflowTasks) {
            if (airflowTasks == null) {
                throw new NullPointerException("airflowTasks cannot be null");
            }
            if (this.airflowTasks == null) {
                this.airflowTasks = new ArrayList();
            }
            this.airflowTasks.addAll(airflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearAirflowTasks() {
            if (this.airflowTasks != null) {
                this.airflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B ast(String ast) {
            this.ast = ast;
            return (B)this.self();
        }

        @Generated
        public B code(String code) {
            this.code = code;
            return (B)this.self();
        }

        @Generated
        public B columnProcess(IColumnProcess columnProcess) {
            if (this.columnProcesses == null) {
                this.columnProcesses = new ArrayList();
            }
            this.columnProcesses.add(columnProcess);
            return (B)this.self();
        }

        @Generated
        public B columnProcesses(Collection<? extends IColumnProcess> columnProcesses) {
            if (columnProcesses == null) {
                throw new NullPointerException("columnProcesses cannot be null");
            }
            if (this.columnProcesses == null) {
                this.columnProcesses = new ArrayList();
            }
            this.columnProcesses.addAll(columnProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearColumnProcesses() {
            if (this.columnProcesses != null) {
                this.columnProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B input(ICatalog input) {
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.add(input);
            return (B)this.self();
        }

        @Generated
        public B inputs(Collection<? extends ICatalog> inputs) {
            if (inputs == null) {
                throw new NullPointerException("inputs cannot be null");
            }
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.addAll(inputs);
            return (B)this.self();
        }

        @Generated
        public B clearInputs() {
            if (this.inputs != null) {
                this.inputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B output(ICatalog output) {
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.add(output);
            return (B)this.self();
        }

        @Generated
        public B outputs(Collection<? extends ICatalog> outputs) {
            if (outputs == null) {
                throw new NullPointerException("outputs cannot be null");
            }
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.addAll(outputs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputs() {
            if (this.outputs != null) {
                this.outputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sql(String sql) {
            this.sql = sql;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "BIProcess.BIProcessBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", airflowTasks=" + this.airflowTasks + ", ast=" + this.ast + ", code=" + this.code + ", columnProcesses=" + this.columnProcesses + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ", sql=" + this.sql + ")";
        }
    }
}

