/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IColumnProcess;
import com.atlan.model.assets.IDbt;
import com.atlan.model.assets.IDbtColumnProcess;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbtColumnProcess
extends Asset
implements IDbtColumnProcess,
IDbt,
IColumnProcess,
ICatalog,
IAsset,
IReferenceable,
ILineageProcess {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DbtColumnProcess.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DbtColumnProcess";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> airflowTasks;
    @Attribute
    String ast;
    @Attribute
    String code;
    @Attribute
    SortedSet<IColumnProcess> columnProcesses;
    @Attribute
    String dbtAccountName;
    @Attribute
    String dbtAlias;
    @Attribute
    String dbtColumnProcessJobStatus;
    @Attribute
    String dbtConnectionContext;
    @Attribute
    String dbtEnvironmentDbtVersion;
    @Attribute
    String dbtEnvironmentName;
    @Attribute
    Long dbtJobLastRun;
    @Attribute
    String dbtJobName;
    @Attribute
    Long dbtJobNextRun;
    @Attribute
    String dbtJobNextRunHumanized;
    @Attribute
    String dbtJobSchedule;
    @Attribute
    String dbtJobScheduleCronHumanized;
    @Attribute
    String dbtJobStatus;
    @Attribute
    String dbtMeta;
    @Attribute
    String dbtPackageName;
    @Attribute
    String dbtProjectName;
    @Attribute
    String dbtSemanticLayerProxyUrl;
    @Attribute
    SortedSet<String> dbtTags;
    @Attribute
    String dbtUniqueId;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ICatalog> inputs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ICatalog> outputs;
    @Attribute
    ILineageProcess process;
    @Attribute
    String sql;

    @Override
    public DbtColumnProcess trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DbtColumnProcess.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DbtColumnProcess.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DbtColumnProcess.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return DbtColumnProcess.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DbtColumnProcess.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return DbtColumnProcess.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return DbtColumnProcess.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return DbtColumnProcess.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return DbtColumnProcess.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static DbtColumnProcess refByGuid(String guid) {
        return ((DbtColumnProcessBuilder)DbtColumnProcess._internal().guid(guid)).build();
    }

    public static DbtColumnProcess refByQualifiedName(String qualifiedName) {
        return ((DbtColumnProcessBuilder)DbtColumnProcess._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static DbtColumnProcess get(String id) throws AtlanException {
        return DbtColumnProcess.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static DbtColumnProcess get(AtlanClient client, String id) throws AtlanException {
        return DbtColumnProcess.get(client, id, true);
    }

    @JsonIgnore
    public static DbtColumnProcess get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DbtColumnProcess) {
                return (DbtColumnProcess)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof DbtColumnProcess) {
            return (DbtColumnProcess)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static DbtColumnProcess retrieveByGuid(String guid) throws AtlanException {
        return DbtColumnProcess.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static DbtColumnProcess retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return DbtColumnProcess.get(client, guid);
    }

    @Deprecated
    public static DbtColumnProcess retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return DbtColumnProcess.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static DbtColumnProcess retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return DbtColumnProcess.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return DbtColumnProcess.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DbtColumnProcessBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DbtColumnProcessBuilder)((DbtColumnProcessBuilder)((DbtColumnProcessBuilder)DbtColumnProcess._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public DbtColumnProcessBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return DbtColumnProcess.updater(this.getQualifiedName(), this.getName());
    }

    public static DbtColumnProcess removeDescription(String qualifiedName, String name) throws AtlanException {
        return DbtColumnProcess.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtColumnProcess removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtColumnProcess)Asset.removeDescription(client, DbtColumnProcess.updater(qualifiedName, name));
    }

    public static DbtColumnProcess removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return DbtColumnProcess.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtColumnProcess removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtColumnProcess)Asset.removeUserDescription(client, DbtColumnProcess.updater(qualifiedName, name));
    }

    public static DbtColumnProcess removeOwners(String qualifiedName, String name) throws AtlanException {
        return DbtColumnProcess.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtColumnProcess removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtColumnProcess)Asset.removeOwners(client, DbtColumnProcess.updater(qualifiedName, name));
    }

    public static DbtColumnProcess updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return DbtColumnProcess.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static DbtColumnProcess updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DbtColumnProcess)Asset.updateCertificate(client, DbtColumnProcess._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DbtColumnProcess removeCertificate(String qualifiedName, String name) throws AtlanException {
        return DbtColumnProcess.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtColumnProcess removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtColumnProcess)Asset.removeCertificate(client, DbtColumnProcess.updater(qualifiedName, name));
    }

    public static DbtColumnProcess updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return DbtColumnProcess.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static DbtColumnProcess updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DbtColumnProcess)Asset.updateAnnouncement(client, DbtColumnProcess._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DbtColumnProcess removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return DbtColumnProcess.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtColumnProcess removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtColumnProcess)Asset.removeAnnouncement(client, DbtColumnProcess.updater(qualifiedName, name));
    }

    public static DbtColumnProcess replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return DbtColumnProcess.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static DbtColumnProcess replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtColumnProcess)Asset.replaceTerms(client, DbtColumnProcess.updater(qualifiedName, name), terms);
    }

    public static DbtColumnProcess appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DbtColumnProcess.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DbtColumnProcess appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtColumnProcess)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DbtColumnProcess removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DbtColumnProcess.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DbtColumnProcess removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtColumnProcess)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DbtColumnProcess appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return DbtColumnProcess.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static DbtColumnProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DbtColumnProcess)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static DbtColumnProcess appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return DbtColumnProcess.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static DbtColumnProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DbtColumnProcess)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        DbtColumnProcess.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        DbtColumnProcess.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        DbtColumnProcess.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DbtColumnProcess(DbtColumnProcessBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DbtColumnProcess.$default$typeName();
        SortedSet<IAirflowTask> airflowTasks = new TreeSet<IAirflowTask>();
        if (b.airflowTasks != null) {
            airflowTasks.addAll(b.airflowTasks);
        }
        airflowTasks = Collections.unmodifiableSortedSet(airflowTasks);
        this.airflowTasks = airflowTasks;
        this.ast = b.ast;
        this.code = b.code;
        SortedSet<IColumnProcess> columnProcesses = new TreeSet<IColumnProcess>();
        if (b.columnProcesses != null) {
            columnProcesses.addAll(b.columnProcesses);
        }
        columnProcesses = Collections.unmodifiableSortedSet(columnProcesses);
        this.columnProcesses = columnProcesses;
        this.dbtAccountName = b.dbtAccountName;
        this.dbtAlias = b.dbtAlias;
        this.dbtColumnProcessJobStatus = b.dbtColumnProcessJobStatus;
        this.dbtConnectionContext = b.dbtConnectionContext;
        this.dbtEnvironmentDbtVersion = b.dbtEnvironmentDbtVersion;
        this.dbtEnvironmentName = b.dbtEnvironmentName;
        this.dbtJobLastRun = b.dbtJobLastRun;
        this.dbtJobName = b.dbtJobName;
        this.dbtJobNextRun = b.dbtJobNextRun;
        this.dbtJobNextRunHumanized = b.dbtJobNextRunHumanized;
        this.dbtJobSchedule = b.dbtJobSchedule;
        this.dbtJobScheduleCronHumanized = b.dbtJobScheduleCronHumanized;
        this.dbtJobStatus = b.dbtJobStatus;
        this.dbtMeta = b.dbtMeta;
        this.dbtPackageName = b.dbtPackageName;
        this.dbtProjectName = b.dbtProjectName;
        this.dbtSemanticLayerProxyUrl = b.dbtSemanticLayerProxyUrl;
        SortedSet<String> dbtTags = new TreeSet<String>();
        if (b.dbtTags != null) {
            dbtTags.addAll(b.dbtTags);
        }
        dbtTags = Collections.unmodifiableSortedSet(dbtTags);
        this.dbtTags = dbtTags;
        this.dbtUniqueId = b.dbtUniqueId;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ICatalog> inputs = new TreeSet<ICatalog>();
        if (b.inputs != null) {
            inputs.addAll(b.inputs);
        }
        inputs = Collections.unmodifiableSortedSet(inputs);
        this.inputs = inputs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ICatalog> outputs = new TreeSet<ICatalog>();
        if (b.outputs != null) {
            outputs.addAll(b.outputs);
        }
        outputs = Collections.unmodifiableSortedSet(outputs);
        this.outputs = outputs;
        this.process = b.process;
        this.sql = b.sql;
    }

    @Generated
    public static DbtColumnProcessBuilder<?, ?> _internal() {
        return new DbtColumnProcessBuilderImpl();
    }

    @Generated
    public DbtColumnProcessBuilder<?, ?> toBuilder() {
        return new DbtColumnProcessBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getAirflowTasks() {
        return this.airflowTasks;
    }

    @Override
    @Generated
    public String getAst() {
        return this.ast;
    }

    @Override
    @Generated
    public String getCode() {
        return this.code;
    }

    @Override
    @Generated
    public SortedSet<IColumnProcess> getColumnProcesses() {
        return this.columnProcesses;
    }

    @Override
    @Generated
    public String getDbtAccountName() {
        return this.dbtAccountName;
    }

    @Override
    @Generated
    public String getDbtAlias() {
        return this.dbtAlias;
    }

    @Override
    @Generated
    public String getDbtColumnProcessJobStatus() {
        return this.dbtColumnProcessJobStatus;
    }

    @Override
    @Generated
    public String getDbtConnectionContext() {
        return this.dbtConnectionContext;
    }

    @Override
    @Generated
    public String getDbtEnvironmentDbtVersion() {
        return this.dbtEnvironmentDbtVersion;
    }

    @Override
    @Generated
    public String getDbtEnvironmentName() {
        return this.dbtEnvironmentName;
    }

    @Override
    @Generated
    public Long getDbtJobLastRun() {
        return this.dbtJobLastRun;
    }

    @Override
    @Generated
    public String getDbtJobName() {
        return this.dbtJobName;
    }

    @Override
    @Generated
    public Long getDbtJobNextRun() {
        return this.dbtJobNextRun;
    }

    @Override
    @Generated
    public String getDbtJobNextRunHumanized() {
        return this.dbtJobNextRunHumanized;
    }

    @Override
    @Generated
    public String getDbtJobSchedule() {
        return this.dbtJobSchedule;
    }

    @Override
    @Generated
    public String getDbtJobScheduleCronHumanized() {
        return this.dbtJobScheduleCronHumanized;
    }

    @Override
    @Generated
    public String getDbtJobStatus() {
        return this.dbtJobStatus;
    }

    @Override
    @Generated
    public String getDbtMeta() {
        return this.dbtMeta;
    }

    @Override
    @Generated
    public String getDbtPackageName() {
        return this.dbtPackageName;
    }

    @Override
    @Generated
    public String getDbtProjectName() {
        return this.dbtProjectName;
    }

    @Override
    @Generated
    public String getDbtSemanticLayerProxyUrl() {
        return this.dbtSemanticLayerProxyUrl;
    }

    @Override
    @Generated
    public SortedSet<String> getDbtTags() {
        return this.dbtTags;
    }

    @Override
    @Generated
    public String getDbtUniqueId() {
        return this.dbtUniqueId;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ICatalog> getInputs() {
        return this.inputs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ICatalog> getOutputs() {
        return this.outputs;
    }

    @Override
    @Generated
    public ILineageProcess getProcess() {
        return this.process;
    }

    @Override
    @Generated
    public String getSql() {
        return this.sql;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbtColumnProcess)) {
            return false;
        }
        DbtColumnProcess other = (DbtColumnProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$dbtJobLastRun = this.getDbtJobLastRun();
        Long other$dbtJobLastRun = other.getDbtJobLastRun();
        if (this$dbtJobLastRun == null ? other$dbtJobLastRun != null : !((Object)this$dbtJobLastRun).equals(other$dbtJobLastRun)) {
            return false;
        }
        Long this$dbtJobNextRun = this.getDbtJobNextRun();
        Long other$dbtJobNextRun = other.getDbtJobNextRun();
        if (this$dbtJobNextRun == null ? other$dbtJobNextRun != null : !((Object)this$dbtJobNextRun).equals(other$dbtJobNextRun)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$airflowTasks = this.getAirflowTasks();
        SortedSet<IAirflowTask> other$airflowTasks = other.getAirflowTasks();
        if (this$airflowTasks == null ? other$airflowTasks != null : !this$airflowTasks.equals(other$airflowTasks)) {
            return false;
        }
        String this$ast = this.getAst();
        String other$ast = other.getAst();
        if (this$ast == null ? other$ast != null : !this$ast.equals(other$ast)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        SortedSet<IColumnProcess> this$columnProcesses = this.getColumnProcesses();
        SortedSet<IColumnProcess> other$columnProcesses = other.getColumnProcesses();
        if (this$columnProcesses == null ? other$columnProcesses != null : !this$columnProcesses.equals(other$columnProcesses)) {
            return false;
        }
        String this$dbtAccountName = this.getDbtAccountName();
        String other$dbtAccountName = other.getDbtAccountName();
        if (this$dbtAccountName == null ? other$dbtAccountName != null : !this$dbtAccountName.equals(other$dbtAccountName)) {
            return false;
        }
        String this$dbtAlias = this.getDbtAlias();
        String other$dbtAlias = other.getDbtAlias();
        if (this$dbtAlias == null ? other$dbtAlias != null : !this$dbtAlias.equals(other$dbtAlias)) {
            return false;
        }
        String this$dbtColumnProcessJobStatus = this.getDbtColumnProcessJobStatus();
        String other$dbtColumnProcessJobStatus = other.getDbtColumnProcessJobStatus();
        if (this$dbtColumnProcessJobStatus == null ? other$dbtColumnProcessJobStatus != null : !this$dbtColumnProcessJobStatus.equals(other$dbtColumnProcessJobStatus)) {
            return false;
        }
        String this$dbtConnectionContext = this.getDbtConnectionContext();
        String other$dbtConnectionContext = other.getDbtConnectionContext();
        if (this$dbtConnectionContext == null ? other$dbtConnectionContext != null : !this$dbtConnectionContext.equals(other$dbtConnectionContext)) {
            return false;
        }
        String this$dbtEnvironmentDbtVersion = this.getDbtEnvironmentDbtVersion();
        String other$dbtEnvironmentDbtVersion = other.getDbtEnvironmentDbtVersion();
        if (this$dbtEnvironmentDbtVersion == null ? other$dbtEnvironmentDbtVersion != null : !this$dbtEnvironmentDbtVersion.equals(other$dbtEnvironmentDbtVersion)) {
            return false;
        }
        String this$dbtEnvironmentName = this.getDbtEnvironmentName();
        String other$dbtEnvironmentName = other.getDbtEnvironmentName();
        if (this$dbtEnvironmentName == null ? other$dbtEnvironmentName != null : !this$dbtEnvironmentName.equals(other$dbtEnvironmentName)) {
            return false;
        }
        String this$dbtJobName = this.getDbtJobName();
        String other$dbtJobName = other.getDbtJobName();
        if (this$dbtJobName == null ? other$dbtJobName != null : !this$dbtJobName.equals(other$dbtJobName)) {
            return false;
        }
        String this$dbtJobNextRunHumanized = this.getDbtJobNextRunHumanized();
        String other$dbtJobNextRunHumanized = other.getDbtJobNextRunHumanized();
        if (this$dbtJobNextRunHumanized == null ? other$dbtJobNextRunHumanized != null : !this$dbtJobNextRunHumanized.equals(other$dbtJobNextRunHumanized)) {
            return false;
        }
        String this$dbtJobSchedule = this.getDbtJobSchedule();
        String other$dbtJobSchedule = other.getDbtJobSchedule();
        if (this$dbtJobSchedule == null ? other$dbtJobSchedule != null : !this$dbtJobSchedule.equals(other$dbtJobSchedule)) {
            return false;
        }
        String this$dbtJobScheduleCronHumanized = this.getDbtJobScheduleCronHumanized();
        String other$dbtJobScheduleCronHumanized = other.getDbtJobScheduleCronHumanized();
        if (this$dbtJobScheduleCronHumanized == null ? other$dbtJobScheduleCronHumanized != null : !this$dbtJobScheduleCronHumanized.equals(other$dbtJobScheduleCronHumanized)) {
            return false;
        }
        String this$dbtJobStatus = this.getDbtJobStatus();
        String other$dbtJobStatus = other.getDbtJobStatus();
        if (this$dbtJobStatus == null ? other$dbtJobStatus != null : !this$dbtJobStatus.equals(other$dbtJobStatus)) {
            return false;
        }
        String this$dbtMeta = this.getDbtMeta();
        String other$dbtMeta = other.getDbtMeta();
        if (this$dbtMeta == null ? other$dbtMeta != null : !this$dbtMeta.equals(other$dbtMeta)) {
            return false;
        }
        String this$dbtPackageName = this.getDbtPackageName();
        String other$dbtPackageName = other.getDbtPackageName();
        if (this$dbtPackageName == null ? other$dbtPackageName != null : !this$dbtPackageName.equals(other$dbtPackageName)) {
            return false;
        }
        String this$dbtProjectName = this.getDbtProjectName();
        String other$dbtProjectName = other.getDbtProjectName();
        if (this$dbtProjectName == null ? other$dbtProjectName != null : !this$dbtProjectName.equals(other$dbtProjectName)) {
            return false;
        }
        String this$dbtSemanticLayerProxyUrl = this.getDbtSemanticLayerProxyUrl();
        String other$dbtSemanticLayerProxyUrl = other.getDbtSemanticLayerProxyUrl();
        if (this$dbtSemanticLayerProxyUrl == null ? other$dbtSemanticLayerProxyUrl != null : !this$dbtSemanticLayerProxyUrl.equals(other$dbtSemanticLayerProxyUrl)) {
            return false;
        }
        SortedSet<String> this$dbtTags = this.getDbtTags();
        SortedSet<String> other$dbtTags = other.getDbtTags();
        if (this$dbtTags == null ? other$dbtTags != null : !this$dbtTags.equals(other$dbtTags)) {
            return false;
        }
        String this$dbtUniqueId = this.getDbtUniqueId();
        String other$dbtUniqueId = other.getDbtUniqueId();
        if (this$dbtUniqueId == null ? other$dbtUniqueId != null : !this$dbtUniqueId.equals(other$dbtUniqueId)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ICatalog> this$inputs = this.getInputs();
        SortedSet<ICatalog> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ICatalog> this$outputs = this.getOutputs();
        SortedSet<ICatalog> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !this$outputs.equals(other$outputs)) {
            return false;
        }
        ILineageProcess this$process = this.getProcess();
        ILineageProcess other$process = other.getProcess();
        if (this$process == null ? other$process != null : !this$process.equals(other$process)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        return !(this$sql == null ? other$sql != null : !this$sql.equals(other$sql));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DbtColumnProcess;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $dbtJobLastRun = this.getDbtJobLastRun();
        result = result * 59 + ($dbtJobLastRun == null ? 43 : ((Object)$dbtJobLastRun).hashCode());
        Long $dbtJobNextRun = this.getDbtJobNextRun();
        result = result * 59 + ($dbtJobNextRun == null ? 43 : ((Object)$dbtJobNextRun).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $airflowTasks = this.getAirflowTasks();
        result = result * 59 + ($airflowTasks == null ? 43 : $airflowTasks.hashCode());
        String $ast = this.getAst();
        result = result * 59 + ($ast == null ? 43 : $ast.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        SortedSet<IColumnProcess> $columnProcesses = this.getColumnProcesses();
        result = result * 59 + ($columnProcesses == null ? 43 : $columnProcesses.hashCode());
        String $dbtAccountName = this.getDbtAccountName();
        result = result * 59 + ($dbtAccountName == null ? 43 : $dbtAccountName.hashCode());
        String $dbtAlias = this.getDbtAlias();
        result = result * 59 + ($dbtAlias == null ? 43 : $dbtAlias.hashCode());
        String $dbtColumnProcessJobStatus = this.getDbtColumnProcessJobStatus();
        result = result * 59 + ($dbtColumnProcessJobStatus == null ? 43 : $dbtColumnProcessJobStatus.hashCode());
        String $dbtConnectionContext = this.getDbtConnectionContext();
        result = result * 59 + ($dbtConnectionContext == null ? 43 : $dbtConnectionContext.hashCode());
        String $dbtEnvironmentDbtVersion = this.getDbtEnvironmentDbtVersion();
        result = result * 59 + ($dbtEnvironmentDbtVersion == null ? 43 : $dbtEnvironmentDbtVersion.hashCode());
        String $dbtEnvironmentName = this.getDbtEnvironmentName();
        result = result * 59 + ($dbtEnvironmentName == null ? 43 : $dbtEnvironmentName.hashCode());
        String $dbtJobName = this.getDbtJobName();
        result = result * 59 + ($dbtJobName == null ? 43 : $dbtJobName.hashCode());
        String $dbtJobNextRunHumanized = this.getDbtJobNextRunHumanized();
        result = result * 59 + ($dbtJobNextRunHumanized == null ? 43 : $dbtJobNextRunHumanized.hashCode());
        String $dbtJobSchedule = this.getDbtJobSchedule();
        result = result * 59 + ($dbtJobSchedule == null ? 43 : $dbtJobSchedule.hashCode());
        String $dbtJobScheduleCronHumanized = this.getDbtJobScheduleCronHumanized();
        result = result * 59 + ($dbtJobScheduleCronHumanized == null ? 43 : $dbtJobScheduleCronHumanized.hashCode());
        String $dbtJobStatus = this.getDbtJobStatus();
        result = result * 59 + ($dbtJobStatus == null ? 43 : $dbtJobStatus.hashCode());
        String $dbtMeta = this.getDbtMeta();
        result = result * 59 + ($dbtMeta == null ? 43 : $dbtMeta.hashCode());
        String $dbtPackageName = this.getDbtPackageName();
        result = result * 59 + ($dbtPackageName == null ? 43 : $dbtPackageName.hashCode());
        String $dbtProjectName = this.getDbtProjectName();
        result = result * 59 + ($dbtProjectName == null ? 43 : $dbtProjectName.hashCode());
        String $dbtSemanticLayerProxyUrl = this.getDbtSemanticLayerProxyUrl();
        result = result * 59 + ($dbtSemanticLayerProxyUrl == null ? 43 : $dbtSemanticLayerProxyUrl.hashCode());
        SortedSet<String> $dbtTags = this.getDbtTags();
        result = result * 59 + ($dbtTags == null ? 43 : $dbtTags.hashCode());
        String $dbtUniqueId = this.getDbtUniqueId();
        result = result * 59 + ($dbtUniqueId == null ? 43 : $dbtUniqueId.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ICatalog> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : $inputs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ICatalog> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : $outputs.hashCode());
        ILineageProcess $process = this.getProcess();
        result = result * 59 + ($process == null ? 43 : $process.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DbtColumnProcess(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", airflowTasks=" + this.getAirflowTasks() + ", ast=" + this.getAst() + ", code=" + this.getCode() + ", columnProcesses=" + this.getColumnProcesses() + ", dbtAccountName=" + this.getDbtAccountName() + ", dbtAlias=" + this.getDbtAlias() + ", dbtColumnProcessJobStatus=" + this.getDbtColumnProcessJobStatus() + ", dbtConnectionContext=" + this.getDbtConnectionContext() + ", dbtEnvironmentDbtVersion=" + this.getDbtEnvironmentDbtVersion() + ", dbtEnvironmentName=" + this.getDbtEnvironmentName() + ", dbtJobLastRun=" + this.getDbtJobLastRun() + ", dbtJobName=" + this.getDbtJobName() + ", dbtJobNextRun=" + this.getDbtJobNextRun() + ", dbtJobNextRunHumanized=" + this.getDbtJobNextRunHumanized() + ", dbtJobSchedule=" + this.getDbtJobSchedule() + ", dbtJobScheduleCronHumanized=" + this.getDbtJobScheduleCronHumanized() + ", dbtJobStatus=" + this.getDbtJobStatus() + ", dbtMeta=" + this.getDbtMeta() + ", dbtPackageName=" + this.getDbtPackageName() + ", dbtProjectName=" + this.getDbtProjectName() + ", dbtSemanticLayerProxyUrl=" + this.getDbtSemanticLayerProxyUrl() + ", dbtTags=" + this.getDbtTags() + ", dbtUniqueId=" + this.getDbtUniqueId() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputs=" + this.getInputs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputs=" + this.getOutputs() + ", process=" + this.getProcess() + ", sql=" + this.getSql() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class DbtColumnProcessBuilderImpl
    extends DbtColumnProcessBuilder<DbtColumnProcess, DbtColumnProcessBuilderImpl> {
        @Generated
        private DbtColumnProcessBuilderImpl() {
        }

        @Override
        @Generated
        protected DbtColumnProcessBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DbtColumnProcess build() {
            return new DbtColumnProcess(this);
        }
    }

    @Generated
    public static abstract class DbtColumnProcessBuilder<C extends DbtColumnProcess, B extends DbtColumnProcessBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> airflowTasks;
        @Generated
        private String ast;
        @Generated
        private String code;
        @Generated
        private ArrayList<IColumnProcess> columnProcesses;
        @Generated
        private String dbtAccountName;
        @Generated
        private String dbtAlias;
        @Generated
        private String dbtColumnProcessJobStatus;
        @Generated
        private String dbtConnectionContext;
        @Generated
        private String dbtEnvironmentDbtVersion;
        @Generated
        private String dbtEnvironmentName;
        @Generated
        private Long dbtJobLastRun;
        @Generated
        private String dbtJobName;
        @Generated
        private Long dbtJobNextRun;
        @Generated
        private String dbtJobNextRunHumanized;
        @Generated
        private String dbtJobSchedule;
        @Generated
        private String dbtJobScheduleCronHumanized;
        @Generated
        private String dbtJobStatus;
        @Generated
        private String dbtMeta;
        @Generated
        private String dbtPackageName;
        @Generated
        private String dbtProjectName;
        @Generated
        private String dbtSemanticLayerProxyUrl;
        @Generated
        private ArrayList<String> dbtTags;
        @Generated
        private String dbtUniqueId;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ICatalog> inputs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ICatalog> outputs;
        @Generated
        private ILineageProcess process;
        @Generated
        private String sql;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DbtColumnProcessBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DbtColumnProcess instance, DbtColumnProcessBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.airflowTasks(instance.airflowTasks == null ? Collections.emptySortedSet() : instance.airflowTasks);
            b.ast(instance.ast);
            b.code(instance.code);
            b.columnProcesses(instance.columnProcesses == null ? Collections.emptySortedSet() : instance.columnProcesses);
            b.dbtAccountName(instance.dbtAccountName);
            b.dbtAlias(instance.dbtAlias);
            b.dbtColumnProcessJobStatus(instance.dbtColumnProcessJobStatus);
            b.dbtConnectionContext(instance.dbtConnectionContext);
            b.dbtEnvironmentDbtVersion(instance.dbtEnvironmentDbtVersion);
            b.dbtEnvironmentName(instance.dbtEnvironmentName);
            b.dbtJobLastRun(instance.dbtJobLastRun);
            b.dbtJobName(instance.dbtJobName);
            b.dbtJobNextRun(instance.dbtJobNextRun);
            b.dbtJobNextRunHumanized(instance.dbtJobNextRunHumanized);
            b.dbtJobSchedule(instance.dbtJobSchedule);
            b.dbtJobScheduleCronHumanized(instance.dbtJobScheduleCronHumanized);
            b.dbtJobStatus(instance.dbtJobStatus);
            b.dbtMeta(instance.dbtMeta);
            b.dbtPackageName(instance.dbtPackageName);
            b.dbtProjectName(instance.dbtProjectName);
            b.dbtSemanticLayerProxyUrl(instance.dbtSemanticLayerProxyUrl);
            b.dbtTags(instance.dbtTags == null ? Collections.emptySortedSet() : instance.dbtTags);
            b.dbtUniqueId(instance.dbtUniqueId);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputs(instance.inputs == null ? Collections.emptySortedSet() : instance.inputs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputs(instance.outputs == null ? Collections.emptySortedSet() : instance.outputs);
            b.process(instance.process);
            b.sql(instance.sql);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B airflowTask(IAirflowTask airflowTask) {
            if (this.airflowTasks == null) {
                this.airflowTasks = new ArrayList();
            }
            this.airflowTasks.add(airflowTask);
            return (B)this.self();
        }

        @Generated
        public B airflowTasks(Collection<? extends IAirflowTask> airflowTasks) {
            if (airflowTasks == null) {
                throw new NullPointerException("airflowTasks cannot be null");
            }
            if (this.airflowTasks == null) {
                this.airflowTasks = new ArrayList();
            }
            this.airflowTasks.addAll(airflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearAirflowTasks() {
            if (this.airflowTasks != null) {
                this.airflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B ast(String ast) {
            this.ast = ast;
            return (B)this.self();
        }

        @Generated
        public B code(String code) {
            this.code = code;
            return (B)this.self();
        }

        @Generated
        public B columnProcess(IColumnProcess columnProcess) {
            if (this.columnProcesses == null) {
                this.columnProcesses = new ArrayList();
            }
            this.columnProcesses.add(columnProcess);
            return (B)this.self();
        }

        @Generated
        public B columnProcesses(Collection<? extends IColumnProcess> columnProcesses) {
            if (columnProcesses == null) {
                throw new NullPointerException("columnProcesses cannot be null");
            }
            if (this.columnProcesses == null) {
                this.columnProcesses = new ArrayList();
            }
            this.columnProcesses.addAll(columnProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearColumnProcesses() {
            if (this.columnProcesses != null) {
                this.columnProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtAccountName(String dbtAccountName) {
            this.dbtAccountName = dbtAccountName;
            return (B)this.self();
        }

        @Generated
        public B dbtAlias(String dbtAlias) {
            this.dbtAlias = dbtAlias;
            return (B)this.self();
        }

        @Generated
        public B dbtColumnProcessJobStatus(String dbtColumnProcessJobStatus) {
            this.dbtColumnProcessJobStatus = dbtColumnProcessJobStatus;
            return (B)this.self();
        }

        @Generated
        public B dbtConnectionContext(String dbtConnectionContext) {
            this.dbtConnectionContext = dbtConnectionContext;
            return (B)this.self();
        }

        @Generated
        public B dbtEnvironmentDbtVersion(String dbtEnvironmentDbtVersion) {
            this.dbtEnvironmentDbtVersion = dbtEnvironmentDbtVersion;
            return (B)this.self();
        }

        @Generated
        public B dbtEnvironmentName(String dbtEnvironmentName) {
            this.dbtEnvironmentName = dbtEnvironmentName;
            return (B)this.self();
        }

        @Generated
        public B dbtJobLastRun(Long dbtJobLastRun) {
            this.dbtJobLastRun = dbtJobLastRun;
            return (B)this.self();
        }

        @Generated
        public B dbtJobName(String dbtJobName) {
            this.dbtJobName = dbtJobName;
            return (B)this.self();
        }

        @Generated
        public B dbtJobNextRun(Long dbtJobNextRun) {
            this.dbtJobNextRun = dbtJobNextRun;
            return (B)this.self();
        }

        @Generated
        public B dbtJobNextRunHumanized(String dbtJobNextRunHumanized) {
            this.dbtJobNextRunHumanized = dbtJobNextRunHumanized;
            return (B)this.self();
        }

        @Generated
        public B dbtJobSchedule(String dbtJobSchedule) {
            this.dbtJobSchedule = dbtJobSchedule;
            return (B)this.self();
        }

        @Generated
        public B dbtJobScheduleCronHumanized(String dbtJobScheduleCronHumanized) {
            this.dbtJobScheduleCronHumanized = dbtJobScheduleCronHumanized;
            return (B)this.self();
        }

        @Generated
        public B dbtJobStatus(String dbtJobStatus) {
            this.dbtJobStatus = dbtJobStatus;
            return (B)this.self();
        }

        @Generated
        public B dbtMeta(String dbtMeta) {
            this.dbtMeta = dbtMeta;
            return (B)this.self();
        }

        @Generated
        public B dbtPackageName(String dbtPackageName) {
            this.dbtPackageName = dbtPackageName;
            return (B)this.self();
        }

        @Generated
        public B dbtProjectName(String dbtProjectName) {
            this.dbtProjectName = dbtProjectName;
            return (B)this.self();
        }

        @Generated
        public B dbtSemanticLayerProxyUrl(String dbtSemanticLayerProxyUrl) {
            this.dbtSemanticLayerProxyUrl = dbtSemanticLayerProxyUrl;
            return (B)this.self();
        }

        @Generated
        public B dbtTag(String dbtTag) {
            if (this.dbtTags == null) {
                this.dbtTags = new ArrayList();
            }
            this.dbtTags.add(dbtTag);
            return (B)this.self();
        }

        @Generated
        public B dbtTags(Collection<? extends String> dbtTags) {
            if (dbtTags == null) {
                throw new NullPointerException("dbtTags cannot be null");
            }
            if (this.dbtTags == null) {
                this.dbtTags = new ArrayList();
            }
            this.dbtTags.addAll(dbtTags);
            return (B)this.self();
        }

        @Generated
        public B clearDbtTags() {
            if (this.dbtTags != null) {
                this.dbtTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtUniqueId(String dbtUniqueId) {
            this.dbtUniqueId = dbtUniqueId;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B input(ICatalog input) {
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.add(input);
            return (B)this.self();
        }

        @Generated
        public B inputs(Collection<? extends ICatalog> inputs) {
            if (inputs == null) {
                throw new NullPointerException("inputs cannot be null");
            }
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.addAll(inputs);
            return (B)this.self();
        }

        @Generated
        public B clearInputs() {
            if (this.inputs != null) {
                this.inputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B output(ICatalog output) {
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.add(output);
            return (B)this.self();
        }

        @Generated
        public B outputs(Collection<? extends ICatalog> outputs) {
            if (outputs == null) {
                throw new NullPointerException("outputs cannot be null");
            }
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.addAll(outputs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputs() {
            if (this.outputs != null) {
                this.outputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B process(ILineageProcess process) {
            this.process = process;
            return (B)this.self();
        }

        @Generated
        public B sql(String sql) {
            this.sql = sql;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "DbtColumnProcess.DbtColumnProcessBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", airflowTasks=" + this.airflowTasks + ", ast=" + this.ast + ", code=" + this.code + ", columnProcesses=" + this.columnProcesses + ", dbtAccountName=" + this.dbtAccountName + ", dbtAlias=" + this.dbtAlias + ", dbtColumnProcessJobStatus=" + this.dbtColumnProcessJobStatus + ", dbtConnectionContext=" + this.dbtConnectionContext + ", dbtEnvironmentDbtVersion=" + this.dbtEnvironmentDbtVersion + ", dbtEnvironmentName=" + this.dbtEnvironmentName + ", dbtJobLastRun=" + this.dbtJobLastRun + ", dbtJobName=" + this.dbtJobName + ", dbtJobNextRun=" + this.dbtJobNextRun + ", dbtJobNextRunHumanized=" + this.dbtJobNextRunHumanized + ", dbtJobSchedule=" + this.dbtJobSchedule + ", dbtJobScheduleCronHumanized=" + this.dbtJobScheduleCronHumanized + ", dbtJobStatus=" + this.dbtJobStatus + ", dbtMeta=" + this.dbtMeta + ", dbtPackageName=" + this.dbtPackageName + ", dbtProjectName=" + this.dbtProjectName + ", dbtSemanticLayerProxyUrl=" + this.dbtSemanticLayerProxyUrl + ", dbtTags=" + this.dbtTags + ", dbtUniqueId=" + this.dbtUniqueId + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputs=" + this.inputs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputs=" + this.outputs + ", process=" + this.process + ", sql=" + this.sql + ")";
        }
    }
}

