/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.ICloud;
import com.atlan.model.assets.IGCS;
import com.atlan.model.assets.IGCSBucket;
import com.atlan.model.assets.IGCSObject;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IGoogle;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IObjectStore;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.GoogleLabel;
import com.atlan.model.structs.GoogleTag;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCSBucket
extends Asset
implements IGCSBucket,
IGCS,
IGoogle,
IObjectStore,
ICloud,
IAsset,
IReferenceable,
ICatalog {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GCSBucket.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "GCSBucket";
    String typeName;
    @Attribute
    String gcsAccessControl;
    @Attribute
    String gcsBucketLifecycleRules;
    @Attribute
    Long gcsBucketRetentionEffectiveTime;
    @Attribute
    Boolean gcsBucketRetentionLocked;
    @Attribute
    Long gcsBucketRetentionPeriod;
    @Attribute
    String gcsBucketRetentionPolicy;
    @Attribute
    Boolean gcsBucketVersioningEnabled;
    @Attribute
    String gcsETag;
    @Attribute
    String gcsEncryptionType;
    @Attribute
    Long gcsMetaGenerationId;
    @Attribute
    Long gcsObjectCount;
    @Attribute
    SortedSet<IGCSObject> gcsObjects;
    @Attribute
    Boolean gcsRequesterPays;
    @Attribute
    String gcsStorageClass;
    @Attribute
    List<GoogleLabel> googleLabels;
    @Attribute
    String googleLocation;
    @Attribute
    String googleLocationType;
    @Attribute
    String googleProjectId;
    @Attribute
    String googleProjectName;
    @Attribute
    Long googleProjectNumber;
    @Attribute
    String googleService;
    @Attribute
    List<GoogleTag> googleTags;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;

    @Override
    public GCSBucket trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return GCSBucket.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return GCSBucket.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return GCSBucket.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return GCSBucket.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return GCSBucket.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return GCSBucket.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return GCSBucket.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return GCSBucket.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return GCSBucket.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static GCSBucket refByGuid(String guid) {
        return ((GCSBucketBuilder)GCSBucket._internal().guid(guid)).build();
    }

    public static GCSBucket refByQualifiedName(String qualifiedName) {
        return ((GCSBucketBuilder)GCSBucket._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static GCSBucket get(String id) throws AtlanException {
        return GCSBucket.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static GCSBucket get(AtlanClient client, String id) throws AtlanException {
        return GCSBucket.get(client, id, true);
    }

    @JsonIgnore
    public static GCSBucket get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof GCSBucket) {
                return (GCSBucket)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof GCSBucket) {
            return (GCSBucket)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static GCSBucket retrieveByGuid(String guid) throws AtlanException {
        return GCSBucket.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static GCSBucket retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return GCSBucket.get(client, guid);
    }

    @Deprecated
    public static GCSBucket retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return GCSBucket.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static GCSBucket retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return GCSBucket.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return GCSBucket.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static GCSBucketBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return (GCSBucketBuilder)((GCSBucketBuilder)((GCSBucketBuilder)((GCSBucketBuilder)((GCSBucketBuilder)GCSBucket._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(GCSBucket.generateQualifiedName(name, connectionQualifiedName))).name(name)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.GCS);
    }

    public static String generateQualifiedName(String name, String connectionQualifiedName) {
        return connectionQualifiedName + "/" + name;
    }

    public static GCSBucketBuilder<?, ?> updater(String qualifiedName, String name) {
        return (GCSBucketBuilder)((GCSBucketBuilder)((GCSBucketBuilder)GCSBucket._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public GCSBucketBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return GCSBucket.updater(this.getQualifiedName(), this.getName());
    }

    public static GCSBucket removeDescription(String qualifiedName, String name) throws AtlanException {
        return GCSBucket.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static GCSBucket removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GCSBucket)Asset.removeDescription(client, GCSBucket.updater(qualifiedName, name));
    }

    public static GCSBucket removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return GCSBucket.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static GCSBucket removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GCSBucket)Asset.removeUserDescription(client, GCSBucket.updater(qualifiedName, name));
    }

    public static GCSBucket removeOwners(String qualifiedName, String name) throws AtlanException {
        return GCSBucket.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static GCSBucket removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GCSBucket)Asset.removeOwners(client, GCSBucket.updater(qualifiedName, name));
    }

    public static GCSBucket updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return GCSBucket.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static GCSBucket updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (GCSBucket)Asset.updateCertificate(client, GCSBucket._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static GCSBucket removeCertificate(String qualifiedName, String name) throws AtlanException {
        return GCSBucket.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static GCSBucket removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GCSBucket)Asset.removeCertificate(client, GCSBucket.updater(qualifiedName, name));
    }

    public static GCSBucket updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return GCSBucket.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static GCSBucket updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (GCSBucket)Asset.updateAnnouncement(client, GCSBucket._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static GCSBucket removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return GCSBucket.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static GCSBucket removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GCSBucket)Asset.removeAnnouncement(client, GCSBucket.updater(qualifiedName, name));
    }

    public static GCSBucket replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return GCSBucket.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static GCSBucket replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (GCSBucket)Asset.replaceTerms(client, GCSBucket.updater(qualifiedName, name), terms);
    }

    public static GCSBucket appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return GCSBucket.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static GCSBucket appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (GCSBucket)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static GCSBucket removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return GCSBucket.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static GCSBucket removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (GCSBucket)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static GCSBucket appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return GCSBucket.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static GCSBucket appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (GCSBucket)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static GCSBucket appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return GCSBucket.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static GCSBucket appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (GCSBucket)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        GCSBucket.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        GCSBucket.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        GCSBucket.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected GCSBucket(GCSBucketBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        List<Object> googleTags;
        List<Object> googleLabels;
        this.typeName = b.typeName$set ? b.typeName$value : GCSBucket.$default$typeName();
        this.gcsAccessControl = b.gcsAccessControl;
        this.gcsBucketLifecycleRules = b.gcsBucketLifecycleRules;
        this.gcsBucketRetentionEffectiveTime = b.gcsBucketRetentionEffectiveTime;
        this.gcsBucketRetentionLocked = b.gcsBucketRetentionLocked;
        this.gcsBucketRetentionPeriod = b.gcsBucketRetentionPeriod;
        this.gcsBucketRetentionPolicy = b.gcsBucketRetentionPolicy;
        this.gcsBucketVersioningEnabled = b.gcsBucketVersioningEnabled;
        this.gcsETag = b.gcsETag;
        this.gcsEncryptionType = b.gcsEncryptionType;
        this.gcsMetaGenerationId = b.gcsMetaGenerationId;
        this.gcsObjectCount = b.gcsObjectCount;
        SortedSet<IGCSObject> gcsObjects = new TreeSet<IGCSObject>();
        if (b.gcsObjects != null) {
            gcsObjects.addAll(b.gcsObjects);
        }
        gcsObjects = Collections.unmodifiableSortedSet(gcsObjects);
        this.gcsObjects = gcsObjects;
        this.gcsRequesterPays = b.gcsRequesterPays;
        this.gcsStorageClass = b.gcsStorageClass;
        switch (b.googleLabels == null ? 0 : b.googleLabels.size()) {
            case 0: {
                googleLabels = Collections.emptyList();
                break;
            }
            case 1: {
                googleLabels = Collections.singletonList(b.googleLabels.get(0));
                break;
            }
            default: {
                googleLabels = Collections.unmodifiableList(new ArrayList<GoogleLabel>(b.googleLabels));
            }
        }
        this.googleLabels = googleLabels;
        this.googleLocation = b.googleLocation;
        this.googleLocationType = b.googleLocationType;
        this.googleProjectId = b.googleProjectId;
        this.googleProjectName = b.googleProjectName;
        this.googleProjectNumber = b.googleProjectNumber;
        this.googleService = b.googleService;
        switch (b.googleTags == null ? 0 : b.googleTags.size()) {
            case 0: {
                googleTags = Collections.emptyList();
                break;
            }
            case 1: {
                googleTags = Collections.singletonList(b.googleTags.get(0));
                break;
            }
            default: {
                googleTags = Collections.unmodifiableList(new ArrayList<GoogleTag>(b.googleTags));
            }
        }
        this.googleTags = googleTags;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
    }

    @Generated
    public static GCSBucketBuilder<?, ?> _internal() {
        return new GCSBucketBuilderImpl();
    }

    @Generated
    public GCSBucketBuilder<?, ?> toBuilder() {
        return new GCSBucketBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getGcsAccessControl() {
        return this.gcsAccessControl;
    }

    @Override
    @Generated
    public String getGcsBucketLifecycleRules() {
        return this.gcsBucketLifecycleRules;
    }

    @Override
    @Generated
    public Long getGcsBucketRetentionEffectiveTime() {
        return this.gcsBucketRetentionEffectiveTime;
    }

    @Override
    @Generated
    public Boolean getGcsBucketRetentionLocked() {
        return this.gcsBucketRetentionLocked;
    }

    @Override
    @Generated
    public Long getGcsBucketRetentionPeriod() {
        return this.gcsBucketRetentionPeriod;
    }

    @Override
    @Generated
    public String getGcsBucketRetentionPolicy() {
        return this.gcsBucketRetentionPolicy;
    }

    @Override
    @Generated
    public Boolean getGcsBucketVersioningEnabled() {
        return this.gcsBucketVersioningEnabled;
    }

    @Override
    @Generated
    public String getGcsETag() {
        return this.gcsETag;
    }

    @Override
    @Generated
    public String getGcsEncryptionType() {
        return this.gcsEncryptionType;
    }

    @Override
    @Generated
    public Long getGcsMetaGenerationId() {
        return this.gcsMetaGenerationId;
    }

    @Override
    @Generated
    public Long getGcsObjectCount() {
        return this.gcsObjectCount;
    }

    @Override
    @Generated
    public SortedSet<IGCSObject> getGcsObjects() {
        return this.gcsObjects;
    }

    @Override
    @Generated
    public Boolean getGcsRequesterPays() {
        return this.gcsRequesterPays;
    }

    @Override
    @Generated
    public String getGcsStorageClass() {
        return this.gcsStorageClass;
    }

    @Override
    @Generated
    public List<GoogleLabel> getGoogleLabels() {
        return this.googleLabels;
    }

    @Override
    @Generated
    public String getGoogleLocation() {
        return this.googleLocation;
    }

    @Override
    @Generated
    public String getGoogleLocationType() {
        return this.googleLocationType;
    }

    @Override
    @Generated
    public String getGoogleProjectId() {
        return this.googleProjectId;
    }

    @Override
    @Generated
    public String getGoogleProjectName() {
        return this.googleProjectName;
    }

    @Override
    @Generated
    public Long getGoogleProjectNumber() {
        return this.googleProjectNumber;
    }

    @Override
    @Generated
    public String getGoogleService() {
        return this.googleService;
    }

    @Override
    @Generated
    public List<GoogleTag> getGoogleTags() {
        return this.googleTags;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GCSBucket)) {
            return false;
        }
        GCSBucket other = (GCSBucket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$gcsBucketRetentionEffectiveTime = this.getGcsBucketRetentionEffectiveTime();
        Long other$gcsBucketRetentionEffectiveTime = other.getGcsBucketRetentionEffectiveTime();
        if (this$gcsBucketRetentionEffectiveTime == null ? other$gcsBucketRetentionEffectiveTime != null : !((Object)this$gcsBucketRetentionEffectiveTime).equals(other$gcsBucketRetentionEffectiveTime)) {
            return false;
        }
        Boolean this$gcsBucketRetentionLocked = this.getGcsBucketRetentionLocked();
        Boolean other$gcsBucketRetentionLocked = other.getGcsBucketRetentionLocked();
        if (this$gcsBucketRetentionLocked == null ? other$gcsBucketRetentionLocked != null : !((Object)this$gcsBucketRetentionLocked).equals(other$gcsBucketRetentionLocked)) {
            return false;
        }
        Long this$gcsBucketRetentionPeriod = this.getGcsBucketRetentionPeriod();
        Long other$gcsBucketRetentionPeriod = other.getGcsBucketRetentionPeriod();
        if (this$gcsBucketRetentionPeriod == null ? other$gcsBucketRetentionPeriod != null : !((Object)this$gcsBucketRetentionPeriod).equals(other$gcsBucketRetentionPeriod)) {
            return false;
        }
        Boolean this$gcsBucketVersioningEnabled = this.getGcsBucketVersioningEnabled();
        Boolean other$gcsBucketVersioningEnabled = other.getGcsBucketVersioningEnabled();
        if (this$gcsBucketVersioningEnabled == null ? other$gcsBucketVersioningEnabled != null : !((Object)this$gcsBucketVersioningEnabled).equals(other$gcsBucketVersioningEnabled)) {
            return false;
        }
        Long this$gcsMetaGenerationId = this.getGcsMetaGenerationId();
        Long other$gcsMetaGenerationId = other.getGcsMetaGenerationId();
        if (this$gcsMetaGenerationId == null ? other$gcsMetaGenerationId != null : !((Object)this$gcsMetaGenerationId).equals(other$gcsMetaGenerationId)) {
            return false;
        }
        Long this$gcsObjectCount = this.getGcsObjectCount();
        Long other$gcsObjectCount = other.getGcsObjectCount();
        if (this$gcsObjectCount == null ? other$gcsObjectCount != null : !((Object)this$gcsObjectCount).equals(other$gcsObjectCount)) {
            return false;
        }
        Boolean this$gcsRequesterPays = this.getGcsRequesterPays();
        Boolean other$gcsRequesterPays = other.getGcsRequesterPays();
        if (this$gcsRequesterPays == null ? other$gcsRequesterPays != null : !((Object)this$gcsRequesterPays).equals(other$gcsRequesterPays)) {
            return false;
        }
        Long this$googleProjectNumber = this.getGoogleProjectNumber();
        Long other$googleProjectNumber = other.getGoogleProjectNumber();
        if (this$googleProjectNumber == null ? other$googleProjectNumber != null : !((Object)this$googleProjectNumber).equals(other$googleProjectNumber)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$gcsAccessControl = this.getGcsAccessControl();
        String other$gcsAccessControl = other.getGcsAccessControl();
        if (this$gcsAccessControl == null ? other$gcsAccessControl != null : !this$gcsAccessControl.equals(other$gcsAccessControl)) {
            return false;
        }
        String this$gcsBucketLifecycleRules = this.getGcsBucketLifecycleRules();
        String other$gcsBucketLifecycleRules = other.getGcsBucketLifecycleRules();
        if (this$gcsBucketLifecycleRules == null ? other$gcsBucketLifecycleRules != null : !this$gcsBucketLifecycleRules.equals(other$gcsBucketLifecycleRules)) {
            return false;
        }
        String this$gcsBucketRetentionPolicy = this.getGcsBucketRetentionPolicy();
        String other$gcsBucketRetentionPolicy = other.getGcsBucketRetentionPolicy();
        if (this$gcsBucketRetentionPolicy == null ? other$gcsBucketRetentionPolicy != null : !this$gcsBucketRetentionPolicy.equals(other$gcsBucketRetentionPolicy)) {
            return false;
        }
        String this$gcsETag = this.getGcsETag();
        String other$gcsETag = other.getGcsETag();
        if (this$gcsETag == null ? other$gcsETag != null : !this$gcsETag.equals(other$gcsETag)) {
            return false;
        }
        String this$gcsEncryptionType = this.getGcsEncryptionType();
        String other$gcsEncryptionType = other.getGcsEncryptionType();
        if (this$gcsEncryptionType == null ? other$gcsEncryptionType != null : !this$gcsEncryptionType.equals(other$gcsEncryptionType)) {
            return false;
        }
        SortedSet<IGCSObject> this$gcsObjects = this.getGcsObjects();
        SortedSet<IGCSObject> other$gcsObjects = other.getGcsObjects();
        if (this$gcsObjects == null ? other$gcsObjects != null : !this$gcsObjects.equals(other$gcsObjects)) {
            return false;
        }
        String this$gcsStorageClass = this.getGcsStorageClass();
        String other$gcsStorageClass = other.getGcsStorageClass();
        if (this$gcsStorageClass == null ? other$gcsStorageClass != null : !this$gcsStorageClass.equals(other$gcsStorageClass)) {
            return false;
        }
        List<GoogleLabel> this$googleLabels = this.getGoogleLabels();
        List<GoogleLabel> other$googleLabels = other.getGoogleLabels();
        if (this$googleLabels == null ? other$googleLabels != null : !((Object)this$googleLabels).equals(other$googleLabels)) {
            return false;
        }
        String this$googleLocation = this.getGoogleLocation();
        String other$googleLocation = other.getGoogleLocation();
        if (this$googleLocation == null ? other$googleLocation != null : !this$googleLocation.equals(other$googleLocation)) {
            return false;
        }
        String this$googleLocationType = this.getGoogleLocationType();
        String other$googleLocationType = other.getGoogleLocationType();
        if (this$googleLocationType == null ? other$googleLocationType != null : !this$googleLocationType.equals(other$googleLocationType)) {
            return false;
        }
        String this$googleProjectId = this.getGoogleProjectId();
        String other$googleProjectId = other.getGoogleProjectId();
        if (this$googleProjectId == null ? other$googleProjectId != null : !this$googleProjectId.equals(other$googleProjectId)) {
            return false;
        }
        String this$googleProjectName = this.getGoogleProjectName();
        String other$googleProjectName = other.getGoogleProjectName();
        if (this$googleProjectName == null ? other$googleProjectName != null : !this$googleProjectName.equals(other$googleProjectName)) {
            return false;
        }
        String this$googleService = this.getGoogleService();
        String other$googleService = other.getGoogleService();
        if (this$googleService == null ? other$googleService != null : !this$googleService.equals(other$googleService)) {
            return false;
        }
        List<GoogleTag> this$googleTags = this.getGoogleTags();
        List<GoogleTag> other$googleTags = other.getGoogleTags();
        if (this$googleTags == null ? other$googleTags != null : !((Object)this$googleTags).equals(other$googleTags)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GCSBucket;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $gcsBucketRetentionEffectiveTime = this.getGcsBucketRetentionEffectiveTime();
        result = result * 59 + ($gcsBucketRetentionEffectiveTime == null ? 43 : ((Object)$gcsBucketRetentionEffectiveTime).hashCode());
        Boolean $gcsBucketRetentionLocked = this.getGcsBucketRetentionLocked();
        result = result * 59 + ($gcsBucketRetentionLocked == null ? 43 : ((Object)$gcsBucketRetentionLocked).hashCode());
        Long $gcsBucketRetentionPeriod = this.getGcsBucketRetentionPeriod();
        result = result * 59 + ($gcsBucketRetentionPeriod == null ? 43 : ((Object)$gcsBucketRetentionPeriod).hashCode());
        Boolean $gcsBucketVersioningEnabled = this.getGcsBucketVersioningEnabled();
        result = result * 59 + ($gcsBucketVersioningEnabled == null ? 43 : ((Object)$gcsBucketVersioningEnabled).hashCode());
        Long $gcsMetaGenerationId = this.getGcsMetaGenerationId();
        result = result * 59 + ($gcsMetaGenerationId == null ? 43 : ((Object)$gcsMetaGenerationId).hashCode());
        Long $gcsObjectCount = this.getGcsObjectCount();
        result = result * 59 + ($gcsObjectCount == null ? 43 : ((Object)$gcsObjectCount).hashCode());
        Boolean $gcsRequesterPays = this.getGcsRequesterPays();
        result = result * 59 + ($gcsRequesterPays == null ? 43 : ((Object)$gcsRequesterPays).hashCode());
        Long $googleProjectNumber = this.getGoogleProjectNumber();
        result = result * 59 + ($googleProjectNumber == null ? 43 : ((Object)$googleProjectNumber).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $gcsAccessControl = this.getGcsAccessControl();
        result = result * 59 + ($gcsAccessControl == null ? 43 : $gcsAccessControl.hashCode());
        String $gcsBucketLifecycleRules = this.getGcsBucketLifecycleRules();
        result = result * 59 + ($gcsBucketLifecycleRules == null ? 43 : $gcsBucketLifecycleRules.hashCode());
        String $gcsBucketRetentionPolicy = this.getGcsBucketRetentionPolicy();
        result = result * 59 + ($gcsBucketRetentionPolicy == null ? 43 : $gcsBucketRetentionPolicy.hashCode());
        String $gcsETag = this.getGcsETag();
        result = result * 59 + ($gcsETag == null ? 43 : $gcsETag.hashCode());
        String $gcsEncryptionType = this.getGcsEncryptionType();
        result = result * 59 + ($gcsEncryptionType == null ? 43 : $gcsEncryptionType.hashCode());
        SortedSet<IGCSObject> $gcsObjects = this.getGcsObjects();
        result = result * 59 + ($gcsObjects == null ? 43 : $gcsObjects.hashCode());
        String $gcsStorageClass = this.getGcsStorageClass();
        result = result * 59 + ($gcsStorageClass == null ? 43 : $gcsStorageClass.hashCode());
        List<GoogleLabel> $googleLabels = this.getGoogleLabels();
        result = result * 59 + ($googleLabels == null ? 43 : ((Object)$googleLabels).hashCode());
        String $googleLocation = this.getGoogleLocation();
        result = result * 59 + ($googleLocation == null ? 43 : $googleLocation.hashCode());
        String $googleLocationType = this.getGoogleLocationType();
        result = result * 59 + ($googleLocationType == null ? 43 : $googleLocationType.hashCode());
        String $googleProjectId = this.getGoogleProjectId();
        result = result * 59 + ($googleProjectId == null ? 43 : $googleProjectId.hashCode());
        String $googleProjectName = this.getGoogleProjectName();
        result = result * 59 + ($googleProjectName == null ? 43 : $googleProjectName.hashCode());
        String $googleService = this.getGoogleService();
        result = result * 59 + ($googleService == null ? 43 : $googleService.hashCode());
        List<GoogleTag> $googleTags = this.getGoogleTags();
        result = result * 59 + ($googleTags == null ? 43 : ((Object)$googleTags).hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "GCSBucket(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", gcsAccessControl=" + this.getGcsAccessControl() + ", gcsBucketLifecycleRules=" + this.getGcsBucketLifecycleRules() + ", gcsBucketRetentionEffectiveTime=" + this.getGcsBucketRetentionEffectiveTime() + ", gcsBucketRetentionLocked=" + this.getGcsBucketRetentionLocked() + ", gcsBucketRetentionPeriod=" + this.getGcsBucketRetentionPeriod() + ", gcsBucketRetentionPolicy=" + this.getGcsBucketRetentionPolicy() + ", gcsBucketVersioningEnabled=" + this.getGcsBucketVersioningEnabled() + ", gcsETag=" + this.getGcsETag() + ", gcsEncryptionType=" + this.getGcsEncryptionType() + ", gcsMetaGenerationId=" + this.getGcsMetaGenerationId() + ", gcsObjectCount=" + this.getGcsObjectCount() + ", gcsObjects=" + this.getGcsObjects() + ", gcsRequesterPays=" + this.getGcsRequesterPays() + ", gcsStorageClass=" + this.getGcsStorageClass() + ", googleLabels=" + this.getGoogleLabels() + ", googleLocation=" + this.getGoogleLocation() + ", googleLocationType=" + this.getGoogleLocationType() + ", googleProjectId=" + this.getGoogleProjectId() + ", googleProjectName=" + this.getGoogleProjectName() + ", googleProjectNumber=" + this.getGoogleProjectNumber() + ", googleService=" + this.getGoogleService() + ", googleTags=" + this.getGoogleTags() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class GCSBucketBuilderImpl
    extends GCSBucketBuilder<GCSBucket, GCSBucketBuilderImpl> {
        @Generated
        private GCSBucketBuilderImpl() {
        }

        @Override
        @Generated
        protected GCSBucketBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public GCSBucket build() {
            return new GCSBucket(this);
        }
    }

    @Generated
    public static abstract class GCSBucketBuilder<C extends GCSBucket, B extends GCSBucketBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String gcsAccessControl;
        @Generated
        private String gcsBucketLifecycleRules;
        @Generated
        private Long gcsBucketRetentionEffectiveTime;
        @Generated
        private Boolean gcsBucketRetentionLocked;
        @Generated
        private Long gcsBucketRetentionPeriod;
        @Generated
        private String gcsBucketRetentionPolicy;
        @Generated
        private Boolean gcsBucketVersioningEnabled;
        @Generated
        private String gcsETag;
        @Generated
        private String gcsEncryptionType;
        @Generated
        private Long gcsMetaGenerationId;
        @Generated
        private Long gcsObjectCount;
        @Generated
        private ArrayList<IGCSObject> gcsObjects;
        @Generated
        private Boolean gcsRequesterPays;
        @Generated
        private String gcsStorageClass;
        @Generated
        private ArrayList<GoogleLabel> googleLabels;
        @Generated
        private String googleLocation;
        @Generated
        private String googleLocationType;
        @Generated
        private String googleProjectId;
        @Generated
        private String googleProjectName;
        @Generated
        private Long googleProjectNumber;
        @Generated
        private String googleService;
        @Generated
        private ArrayList<GoogleTag> googleTags;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GCSBucketBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(GCSBucket instance, GCSBucketBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.gcsAccessControl(instance.gcsAccessControl);
            b.gcsBucketLifecycleRules(instance.gcsBucketLifecycleRules);
            b.gcsBucketRetentionEffectiveTime(instance.gcsBucketRetentionEffectiveTime);
            b.gcsBucketRetentionLocked(instance.gcsBucketRetentionLocked);
            b.gcsBucketRetentionPeriod(instance.gcsBucketRetentionPeriod);
            b.gcsBucketRetentionPolicy(instance.gcsBucketRetentionPolicy);
            b.gcsBucketVersioningEnabled(instance.gcsBucketVersioningEnabled);
            b.gcsETag(instance.gcsETag);
            b.gcsEncryptionType(instance.gcsEncryptionType);
            b.gcsMetaGenerationId(instance.gcsMetaGenerationId);
            b.gcsObjectCount(instance.gcsObjectCount);
            b.gcsObjects(instance.gcsObjects == null ? Collections.emptySortedSet() : instance.gcsObjects);
            b.gcsRequesterPays(instance.gcsRequesterPays);
            b.gcsStorageClass(instance.gcsStorageClass);
            b.googleLabels(instance.googleLabels == null ? Collections.emptyList() : instance.googleLabels);
            b.googleLocation(instance.googleLocation);
            b.googleLocationType(instance.googleLocationType);
            b.googleProjectId(instance.googleProjectId);
            b.googleProjectName(instance.googleProjectName);
            b.googleProjectNumber(instance.googleProjectNumber);
            b.googleService(instance.googleService);
            b.googleTags(instance.googleTags == null ? Collections.emptyList() : instance.googleTags);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B gcsAccessControl(String gcsAccessControl) {
            this.gcsAccessControl = gcsAccessControl;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketLifecycleRules(String gcsBucketLifecycleRules) {
            this.gcsBucketLifecycleRules = gcsBucketLifecycleRules;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketRetentionEffectiveTime(Long gcsBucketRetentionEffectiveTime) {
            this.gcsBucketRetentionEffectiveTime = gcsBucketRetentionEffectiveTime;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketRetentionLocked(Boolean gcsBucketRetentionLocked) {
            this.gcsBucketRetentionLocked = gcsBucketRetentionLocked;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketRetentionPeriod(Long gcsBucketRetentionPeriod) {
            this.gcsBucketRetentionPeriod = gcsBucketRetentionPeriod;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketRetentionPolicy(String gcsBucketRetentionPolicy) {
            this.gcsBucketRetentionPolicy = gcsBucketRetentionPolicy;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketVersioningEnabled(Boolean gcsBucketVersioningEnabled) {
            this.gcsBucketVersioningEnabled = gcsBucketVersioningEnabled;
            return (B)this.self();
        }

        @Generated
        public B gcsETag(String gcsETag) {
            this.gcsETag = gcsETag;
            return (B)this.self();
        }

        @Generated
        public B gcsEncryptionType(String gcsEncryptionType) {
            this.gcsEncryptionType = gcsEncryptionType;
            return (B)this.self();
        }

        @Generated
        public B gcsMetaGenerationId(Long gcsMetaGenerationId) {
            this.gcsMetaGenerationId = gcsMetaGenerationId;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectCount(Long gcsObjectCount) {
            this.gcsObjectCount = gcsObjectCount;
            return (B)this.self();
        }

        @Generated
        public B gcsObject(IGCSObject gcsObject) {
            if (this.gcsObjects == null) {
                this.gcsObjects = new ArrayList();
            }
            this.gcsObjects.add(gcsObject);
            return (B)this.self();
        }

        @Generated
        public B gcsObjects(Collection<? extends IGCSObject> gcsObjects) {
            if (gcsObjects == null) {
                throw new NullPointerException("gcsObjects cannot be null");
            }
            if (this.gcsObjects == null) {
                this.gcsObjects = new ArrayList();
            }
            this.gcsObjects.addAll(gcsObjects);
            return (B)this.self();
        }

        @Generated
        public B clearGcsObjects() {
            if (this.gcsObjects != null) {
                this.gcsObjects.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B gcsRequesterPays(Boolean gcsRequesterPays) {
            this.gcsRequesterPays = gcsRequesterPays;
            return (B)this.self();
        }

        @Generated
        public B gcsStorageClass(String gcsStorageClass) {
            this.gcsStorageClass = gcsStorageClass;
            return (B)this.self();
        }

        @Generated
        public B googleLabel(GoogleLabel googleLabel) {
            if (this.googleLabels == null) {
                this.googleLabels = new ArrayList();
            }
            this.googleLabels.add(googleLabel);
            return (B)this.self();
        }

        @Generated
        public B googleLabels(Collection<? extends GoogleLabel> googleLabels) {
            if (googleLabels == null) {
                throw new NullPointerException("googleLabels cannot be null");
            }
            if (this.googleLabels == null) {
                this.googleLabels = new ArrayList();
            }
            this.googleLabels.addAll(googleLabels);
            return (B)this.self();
        }

        @Generated
        public B clearGoogleLabels() {
            if (this.googleLabels != null) {
                this.googleLabels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B googleLocation(String googleLocation) {
            this.googleLocation = googleLocation;
            return (B)this.self();
        }

        @Generated
        public B googleLocationType(String googleLocationType) {
            this.googleLocationType = googleLocationType;
            return (B)this.self();
        }

        @Generated
        public B googleProjectId(String googleProjectId) {
            this.googleProjectId = googleProjectId;
            return (B)this.self();
        }

        @Generated
        public B googleProjectName(String googleProjectName) {
            this.googleProjectName = googleProjectName;
            return (B)this.self();
        }

        @Generated
        public B googleProjectNumber(Long googleProjectNumber) {
            this.googleProjectNumber = googleProjectNumber;
            return (B)this.self();
        }

        @Generated
        public B googleService(String googleService) {
            this.googleService = googleService;
            return (B)this.self();
        }

        @Generated
        public B googleTag(GoogleTag googleTag) {
            if (this.googleTags == null) {
                this.googleTags = new ArrayList();
            }
            this.googleTags.add(googleTag);
            return (B)this.self();
        }

        @Generated
        public B googleTags(Collection<? extends GoogleTag> googleTags) {
            if (googleTags == null) {
                throw new NullPointerException("googleTags cannot be null");
            }
            if (this.googleTags == null) {
                this.googleTags = new ArrayList();
            }
            this.googleTags.addAll(googleTags);
            return (B)this.self();
        }

        @Generated
        public B clearGoogleTags() {
            if (this.googleTags != null) {
                this.googleTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "GCSBucket.GCSBucketBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", gcsAccessControl=" + this.gcsAccessControl + ", gcsBucketLifecycleRules=" + this.gcsBucketLifecycleRules + ", gcsBucketRetentionEffectiveTime=" + this.gcsBucketRetentionEffectiveTime + ", gcsBucketRetentionLocked=" + this.gcsBucketRetentionLocked + ", gcsBucketRetentionPeriod=" + this.gcsBucketRetentionPeriod + ", gcsBucketRetentionPolicy=" + this.gcsBucketRetentionPolicy + ", gcsBucketVersioningEnabled=" + this.gcsBucketVersioningEnabled + ", gcsETag=" + this.gcsETag + ", gcsEncryptionType=" + this.gcsEncryptionType + ", gcsMetaGenerationId=" + this.gcsMetaGenerationId + ", gcsObjectCount=" + this.gcsObjectCount + ", gcsObjects=" + this.gcsObjects + ", gcsRequesterPays=" + this.gcsRequesterPays + ", gcsStorageClass=" + this.gcsStorageClass + ", googleLabels=" + this.googleLabels + ", googleLocation=" + this.googleLocation + ", googleLocationType=" + this.googleLocationType + ", googleProjectId=" + this.googleProjectId + ", googleProjectName=" + this.googleProjectName + ", googleProjectNumber=" + this.googleProjectNumber + ", googleService=" + this.googleService + ", googleTags=" + this.googleTags + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ")";
        }
    }
}

