/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GCSBucket;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.ICloud;
import com.atlan.model.assets.IGCS;
import com.atlan.model.assets.IGCSBucket;
import com.atlan.model.assets.IGCSObject;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IGoogle;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IObjectStore;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.GoogleLabel;
import com.atlan.model.structs.GoogleTag;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCSObject
extends Asset
implements IGCSObject,
IGCS,
IGoogle,
IObjectStore,
ICloud,
IAsset,
IReferenceable,
ICatalog {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GCSObject.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "GCSObject";
    String typeName;
    @Attribute
    String gcsAccessControl;
    @Attribute
    IGCSBucket gcsBucket;
    @Attribute
    String gcsBucketName;
    @Attribute
    String gcsBucketQualifiedName;
    @Attribute
    String gcsETag;
    @Attribute
    String gcsEncryptionType;
    @Attribute
    Long gcsMetaGenerationId;
    @Attribute
    String gcsObjectCRC32CHash;
    @Attribute
    String gcsObjectContentDisposition;
    @Attribute
    String gcsObjectContentEncoding;
    @Attribute
    String gcsObjectContentLanguage;
    @Attribute
    String gcsObjectContentType;
    @Attribute
    Long gcsObjectDataLastModifiedTime;
    @Attribute
    Long gcsObjectGenerationId;
    @Attribute
    String gcsObjectHoldType;
    @Attribute
    String gcsObjectKey;
    @Attribute
    String gcsObjectMD5Hash;
    @Attribute
    String gcsObjectMediaLink;
    @Attribute
    Long gcsObjectRetentionExpirationDate;
    @Attribute
    Long gcsObjectSize;
    @Attribute
    Boolean gcsRequesterPays;
    @Attribute
    String gcsStorageClass;
    @Attribute
    List<GoogleLabel> googleLabels;
    @Attribute
    String googleLocation;
    @Attribute
    String googleLocationType;
    @Attribute
    String googleProjectId;
    @Attribute
    String googleProjectName;
    @Attribute
    Long googleProjectNumber;
    @Attribute
    String googleService;
    @Attribute
    List<GoogleTag> googleTags;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;

    @Override
    public GCSObject trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return GCSObject.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return GCSObject.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return GCSObject.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return GCSObject.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return GCSObject.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return GCSObject.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return GCSObject.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return GCSObject.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return GCSObject.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static GCSObject refByGuid(String guid) {
        return ((GCSObjectBuilder)GCSObject._internal().guid(guid)).build();
    }

    public static GCSObject refByQualifiedName(String qualifiedName) {
        return ((GCSObjectBuilder)GCSObject._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static GCSObject get(String id) throws AtlanException {
        return GCSObject.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static GCSObject get(AtlanClient client, String id) throws AtlanException {
        return GCSObject.get(client, id, true);
    }

    @JsonIgnore
    public static GCSObject get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof GCSObject) {
                return (GCSObject)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof GCSObject) {
            return (GCSObject)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static GCSObject retrieveByGuid(String guid) throws AtlanException {
        return GCSObject.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static GCSObject retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return GCSObject.get(client, guid);
    }

    @Deprecated
    public static GCSObject retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return GCSObject.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static GCSObject retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return GCSObject.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return GCSObject.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static GCSObjectBuilder<?, ?> creator(String name, GCSBucket bucket) throws InvalidRequestException {
        if (bucket.getQualifiedName() == null || bucket.getQualifiedName().isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, "GCSBucket", "qualifiedName");
        }
        return GCSObject.creator(name, bucket.getQualifiedName()).gcsBucket(bucket.trimToReference());
    }

    public static GCSObjectBuilder<?, ?> creator(String name, String bucketQualifiedName) {
        String connectionQualifiedName = StringUtils.getConnectionQualifiedName(bucketQualifiedName);
        String bucketName = StringUtils.getNameFromQualifiedName(bucketQualifiedName);
        return ((GCSObjectBuilder)((GCSObjectBuilder)((GCSObjectBuilder)((GCSObjectBuilder)((GCSObjectBuilder)((GCSObjectBuilder)((GCSObjectBuilder)GCSObject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(GCSObject.generateQualifiedName(name, bucketQualifiedName))).name(name)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.GCS)).gcsBucketName(bucketName)).gcsBucketQualifiedName(bucketQualifiedName)).gcsBucket(GCSBucket.refByQualifiedName(bucketQualifiedName));
    }

    public static String generateQualifiedName(String name, String bucketQualifiedName) {
        return bucketQualifiedName + "/" + name;
    }

    public static GCSObjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return (GCSObjectBuilder)((GCSObjectBuilder)((GCSObjectBuilder)GCSObject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public GCSObjectBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return GCSObject.updater(this.getQualifiedName(), this.getName());
    }

    public static GCSObject removeDescription(String qualifiedName, String name) throws AtlanException {
        return GCSObject.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static GCSObject removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GCSObject)Asset.removeDescription(client, GCSObject.updater(qualifiedName, name));
    }

    public static GCSObject removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return GCSObject.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static GCSObject removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GCSObject)Asset.removeUserDescription(client, GCSObject.updater(qualifiedName, name));
    }

    public static GCSObject removeOwners(String qualifiedName, String name) throws AtlanException {
        return GCSObject.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static GCSObject removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GCSObject)Asset.removeOwners(client, GCSObject.updater(qualifiedName, name));
    }

    public static GCSObject updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return GCSObject.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static GCSObject updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (GCSObject)Asset.updateCertificate(client, GCSObject._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static GCSObject removeCertificate(String qualifiedName, String name) throws AtlanException {
        return GCSObject.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static GCSObject removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GCSObject)Asset.removeCertificate(client, GCSObject.updater(qualifiedName, name));
    }

    public static GCSObject updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return GCSObject.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static GCSObject updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (GCSObject)Asset.updateAnnouncement(client, GCSObject._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static GCSObject removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return GCSObject.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static GCSObject removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GCSObject)Asset.removeAnnouncement(client, GCSObject.updater(qualifiedName, name));
    }

    public static GCSObject replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return GCSObject.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static GCSObject replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (GCSObject)Asset.replaceTerms(client, GCSObject.updater(qualifiedName, name), terms);
    }

    public static GCSObject appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return GCSObject.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static GCSObject appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (GCSObject)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static GCSObject removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return GCSObject.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static GCSObject removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (GCSObject)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static GCSObject appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return GCSObject.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static GCSObject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (GCSObject)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static GCSObject appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return GCSObject.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static GCSObject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (GCSObject)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        GCSObject.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        GCSObject.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        GCSObject.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected GCSObject(GCSObjectBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        List<Object> googleTags;
        List<Object> googleLabels;
        this.typeName = b.typeName$set ? b.typeName$value : GCSObject.$default$typeName();
        this.gcsAccessControl = b.gcsAccessControl;
        this.gcsBucket = b.gcsBucket;
        this.gcsBucketName = b.gcsBucketName;
        this.gcsBucketQualifiedName = b.gcsBucketQualifiedName;
        this.gcsETag = b.gcsETag;
        this.gcsEncryptionType = b.gcsEncryptionType;
        this.gcsMetaGenerationId = b.gcsMetaGenerationId;
        this.gcsObjectCRC32CHash = b.gcsObjectCRC32CHash;
        this.gcsObjectContentDisposition = b.gcsObjectContentDisposition;
        this.gcsObjectContentEncoding = b.gcsObjectContentEncoding;
        this.gcsObjectContentLanguage = b.gcsObjectContentLanguage;
        this.gcsObjectContentType = b.gcsObjectContentType;
        this.gcsObjectDataLastModifiedTime = b.gcsObjectDataLastModifiedTime;
        this.gcsObjectGenerationId = b.gcsObjectGenerationId;
        this.gcsObjectHoldType = b.gcsObjectHoldType;
        this.gcsObjectKey = b.gcsObjectKey;
        this.gcsObjectMD5Hash = b.gcsObjectMD5Hash;
        this.gcsObjectMediaLink = b.gcsObjectMediaLink;
        this.gcsObjectRetentionExpirationDate = b.gcsObjectRetentionExpirationDate;
        this.gcsObjectSize = b.gcsObjectSize;
        this.gcsRequesterPays = b.gcsRequesterPays;
        this.gcsStorageClass = b.gcsStorageClass;
        switch (b.googleLabels == null ? 0 : b.googleLabels.size()) {
            case 0: {
                googleLabels = Collections.emptyList();
                break;
            }
            case 1: {
                googleLabels = Collections.singletonList(b.googleLabels.get(0));
                break;
            }
            default: {
                googleLabels = Collections.unmodifiableList(new ArrayList<GoogleLabel>(b.googleLabels));
            }
        }
        this.googleLabels = googleLabels;
        this.googleLocation = b.googleLocation;
        this.googleLocationType = b.googleLocationType;
        this.googleProjectId = b.googleProjectId;
        this.googleProjectName = b.googleProjectName;
        this.googleProjectNumber = b.googleProjectNumber;
        this.googleService = b.googleService;
        switch (b.googleTags == null ? 0 : b.googleTags.size()) {
            case 0: {
                googleTags = Collections.emptyList();
                break;
            }
            case 1: {
                googleTags = Collections.singletonList(b.googleTags.get(0));
                break;
            }
            default: {
                googleTags = Collections.unmodifiableList(new ArrayList<GoogleTag>(b.googleTags));
            }
        }
        this.googleTags = googleTags;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
    }

    @Generated
    public static GCSObjectBuilder<?, ?> _internal() {
        return new GCSObjectBuilderImpl();
    }

    @Generated
    public GCSObjectBuilder<?, ?> toBuilder() {
        return new GCSObjectBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getGcsAccessControl() {
        return this.gcsAccessControl;
    }

    @Override
    @Generated
    public IGCSBucket getGcsBucket() {
        return this.gcsBucket;
    }

    @Override
    @Generated
    public String getGcsBucketName() {
        return this.gcsBucketName;
    }

    @Override
    @Generated
    public String getGcsBucketQualifiedName() {
        return this.gcsBucketQualifiedName;
    }

    @Override
    @Generated
    public String getGcsETag() {
        return this.gcsETag;
    }

    @Override
    @Generated
    public String getGcsEncryptionType() {
        return this.gcsEncryptionType;
    }

    @Override
    @Generated
    public Long getGcsMetaGenerationId() {
        return this.gcsMetaGenerationId;
    }

    @Override
    @Generated
    public String getGcsObjectCRC32CHash() {
        return this.gcsObjectCRC32CHash;
    }

    @Override
    @Generated
    public String getGcsObjectContentDisposition() {
        return this.gcsObjectContentDisposition;
    }

    @Override
    @Generated
    public String getGcsObjectContentEncoding() {
        return this.gcsObjectContentEncoding;
    }

    @Override
    @Generated
    public String getGcsObjectContentLanguage() {
        return this.gcsObjectContentLanguage;
    }

    @Override
    @Generated
    public String getGcsObjectContentType() {
        return this.gcsObjectContentType;
    }

    @Override
    @Generated
    public Long getGcsObjectDataLastModifiedTime() {
        return this.gcsObjectDataLastModifiedTime;
    }

    @Override
    @Generated
    public Long getGcsObjectGenerationId() {
        return this.gcsObjectGenerationId;
    }

    @Override
    @Generated
    public String getGcsObjectHoldType() {
        return this.gcsObjectHoldType;
    }

    @Override
    @Generated
    public String getGcsObjectKey() {
        return this.gcsObjectKey;
    }

    @Override
    @Generated
    public String getGcsObjectMD5Hash() {
        return this.gcsObjectMD5Hash;
    }

    @Override
    @Generated
    public String getGcsObjectMediaLink() {
        return this.gcsObjectMediaLink;
    }

    @Override
    @Generated
    public Long getGcsObjectRetentionExpirationDate() {
        return this.gcsObjectRetentionExpirationDate;
    }

    @Override
    @Generated
    public Long getGcsObjectSize() {
        return this.gcsObjectSize;
    }

    @Override
    @Generated
    public Boolean getGcsRequesterPays() {
        return this.gcsRequesterPays;
    }

    @Override
    @Generated
    public String getGcsStorageClass() {
        return this.gcsStorageClass;
    }

    @Override
    @Generated
    public List<GoogleLabel> getGoogleLabels() {
        return this.googleLabels;
    }

    @Override
    @Generated
    public String getGoogleLocation() {
        return this.googleLocation;
    }

    @Override
    @Generated
    public String getGoogleLocationType() {
        return this.googleLocationType;
    }

    @Override
    @Generated
    public String getGoogleProjectId() {
        return this.googleProjectId;
    }

    @Override
    @Generated
    public String getGoogleProjectName() {
        return this.googleProjectName;
    }

    @Override
    @Generated
    public Long getGoogleProjectNumber() {
        return this.googleProjectNumber;
    }

    @Override
    @Generated
    public String getGoogleService() {
        return this.googleService;
    }

    @Override
    @Generated
    public List<GoogleTag> getGoogleTags() {
        return this.googleTags;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GCSObject)) {
            return false;
        }
        GCSObject other = (GCSObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$gcsMetaGenerationId = this.getGcsMetaGenerationId();
        Long other$gcsMetaGenerationId = other.getGcsMetaGenerationId();
        if (this$gcsMetaGenerationId == null ? other$gcsMetaGenerationId != null : !((Object)this$gcsMetaGenerationId).equals(other$gcsMetaGenerationId)) {
            return false;
        }
        Long this$gcsObjectDataLastModifiedTime = this.getGcsObjectDataLastModifiedTime();
        Long other$gcsObjectDataLastModifiedTime = other.getGcsObjectDataLastModifiedTime();
        if (this$gcsObjectDataLastModifiedTime == null ? other$gcsObjectDataLastModifiedTime != null : !((Object)this$gcsObjectDataLastModifiedTime).equals(other$gcsObjectDataLastModifiedTime)) {
            return false;
        }
        Long this$gcsObjectGenerationId = this.getGcsObjectGenerationId();
        Long other$gcsObjectGenerationId = other.getGcsObjectGenerationId();
        if (this$gcsObjectGenerationId == null ? other$gcsObjectGenerationId != null : !((Object)this$gcsObjectGenerationId).equals(other$gcsObjectGenerationId)) {
            return false;
        }
        Long this$gcsObjectRetentionExpirationDate = this.getGcsObjectRetentionExpirationDate();
        Long other$gcsObjectRetentionExpirationDate = other.getGcsObjectRetentionExpirationDate();
        if (this$gcsObjectRetentionExpirationDate == null ? other$gcsObjectRetentionExpirationDate != null : !((Object)this$gcsObjectRetentionExpirationDate).equals(other$gcsObjectRetentionExpirationDate)) {
            return false;
        }
        Long this$gcsObjectSize = this.getGcsObjectSize();
        Long other$gcsObjectSize = other.getGcsObjectSize();
        if (this$gcsObjectSize == null ? other$gcsObjectSize != null : !((Object)this$gcsObjectSize).equals(other$gcsObjectSize)) {
            return false;
        }
        Boolean this$gcsRequesterPays = this.getGcsRequesterPays();
        Boolean other$gcsRequesterPays = other.getGcsRequesterPays();
        if (this$gcsRequesterPays == null ? other$gcsRequesterPays != null : !((Object)this$gcsRequesterPays).equals(other$gcsRequesterPays)) {
            return false;
        }
        Long this$googleProjectNumber = this.getGoogleProjectNumber();
        Long other$googleProjectNumber = other.getGoogleProjectNumber();
        if (this$googleProjectNumber == null ? other$googleProjectNumber != null : !((Object)this$googleProjectNumber).equals(other$googleProjectNumber)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$gcsAccessControl = this.getGcsAccessControl();
        String other$gcsAccessControl = other.getGcsAccessControl();
        if (this$gcsAccessControl == null ? other$gcsAccessControl != null : !this$gcsAccessControl.equals(other$gcsAccessControl)) {
            return false;
        }
        IGCSBucket this$gcsBucket = this.getGcsBucket();
        IGCSBucket other$gcsBucket = other.getGcsBucket();
        if (this$gcsBucket == null ? other$gcsBucket != null : !this$gcsBucket.equals(other$gcsBucket)) {
            return false;
        }
        String this$gcsBucketName = this.getGcsBucketName();
        String other$gcsBucketName = other.getGcsBucketName();
        if (this$gcsBucketName == null ? other$gcsBucketName != null : !this$gcsBucketName.equals(other$gcsBucketName)) {
            return false;
        }
        String this$gcsBucketQualifiedName = this.getGcsBucketQualifiedName();
        String other$gcsBucketQualifiedName = other.getGcsBucketQualifiedName();
        if (this$gcsBucketQualifiedName == null ? other$gcsBucketQualifiedName != null : !this$gcsBucketQualifiedName.equals(other$gcsBucketQualifiedName)) {
            return false;
        }
        String this$gcsETag = this.getGcsETag();
        String other$gcsETag = other.getGcsETag();
        if (this$gcsETag == null ? other$gcsETag != null : !this$gcsETag.equals(other$gcsETag)) {
            return false;
        }
        String this$gcsEncryptionType = this.getGcsEncryptionType();
        String other$gcsEncryptionType = other.getGcsEncryptionType();
        if (this$gcsEncryptionType == null ? other$gcsEncryptionType != null : !this$gcsEncryptionType.equals(other$gcsEncryptionType)) {
            return false;
        }
        String this$gcsObjectCRC32CHash = this.getGcsObjectCRC32CHash();
        String other$gcsObjectCRC32CHash = other.getGcsObjectCRC32CHash();
        if (this$gcsObjectCRC32CHash == null ? other$gcsObjectCRC32CHash != null : !this$gcsObjectCRC32CHash.equals(other$gcsObjectCRC32CHash)) {
            return false;
        }
        String this$gcsObjectContentDisposition = this.getGcsObjectContentDisposition();
        String other$gcsObjectContentDisposition = other.getGcsObjectContentDisposition();
        if (this$gcsObjectContentDisposition == null ? other$gcsObjectContentDisposition != null : !this$gcsObjectContentDisposition.equals(other$gcsObjectContentDisposition)) {
            return false;
        }
        String this$gcsObjectContentEncoding = this.getGcsObjectContentEncoding();
        String other$gcsObjectContentEncoding = other.getGcsObjectContentEncoding();
        if (this$gcsObjectContentEncoding == null ? other$gcsObjectContentEncoding != null : !this$gcsObjectContentEncoding.equals(other$gcsObjectContentEncoding)) {
            return false;
        }
        String this$gcsObjectContentLanguage = this.getGcsObjectContentLanguage();
        String other$gcsObjectContentLanguage = other.getGcsObjectContentLanguage();
        if (this$gcsObjectContentLanguage == null ? other$gcsObjectContentLanguage != null : !this$gcsObjectContentLanguage.equals(other$gcsObjectContentLanguage)) {
            return false;
        }
        String this$gcsObjectContentType = this.getGcsObjectContentType();
        String other$gcsObjectContentType = other.getGcsObjectContentType();
        if (this$gcsObjectContentType == null ? other$gcsObjectContentType != null : !this$gcsObjectContentType.equals(other$gcsObjectContentType)) {
            return false;
        }
        String this$gcsObjectHoldType = this.getGcsObjectHoldType();
        String other$gcsObjectHoldType = other.getGcsObjectHoldType();
        if (this$gcsObjectHoldType == null ? other$gcsObjectHoldType != null : !this$gcsObjectHoldType.equals(other$gcsObjectHoldType)) {
            return false;
        }
        String this$gcsObjectKey = this.getGcsObjectKey();
        String other$gcsObjectKey = other.getGcsObjectKey();
        if (this$gcsObjectKey == null ? other$gcsObjectKey != null : !this$gcsObjectKey.equals(other$gcsObjectKey)) {
            return false;
        }
        String this$gcsObjectMD5Hash = this.getGcsObjectMD5Hash();
        String other$gcsObjectMD5Hash = other.getGcsObjectMD5Hash();
        if (this$gcsObjectMD5Hash == null ? other$gcsObjectMD5Hash != null : !this$gcsObjectMD5Hash.equals(other$gcsObjectMD5Hash)) {
            return false;
        }
        String this$gcsObjectMediaLink = this.getGcsObjectMediaLink();
        String other$gcsObjectMediaLink = other.getGcsObjectMediaLink();
        if (this$gcsObjectMediaLink == null ? other$gcsObjectMediaLink != null : !this$gcsObjectMediaLink.equals(other$gcsObjectMediaLink)) {
            return false;
        }
        String this$gcsStorageClass = this.getGcsStorageClass();
        String other$gcsStorageClass = other.getGcsStorageClass();
        if (this$gcsStorageClass == null ? other$gcsStorageClass != null : !this$gcsStorageClass.equals(other$gcsStorageClass)) {
            return false;
        }
        List<GoogleLabel> this$googleLabels = this.getGoogleLabels();
        List<GoogleLabel> other$googleLabels = other.getGoogleLabels();
        if (this$googleLabels == null ? other$googleLabels != null : !((Object)this$googleLabels).equals(other$googleLabels)) {
            return false;
        }
        String this$googleLocation = this.getGoogleLocation();
        String other$googleLocation = other.getGoogleLocation();
        if (this$googleLocation == null ? other$googleLocation != null : !this$googleLocation.equals(other$googleLocation)) {
            return false;
        }
        String this$googleLocationType = this.getGoogleLocationType();
        String other$googleLocationType = other.getGoogleLocationType();
        if (this$googleLocationType == null ? other$googleLocationType != null : !this$googleLocationType.equals(other$googleLocationType)) {
            return false;
        }
        String this$googleProjectId = this.getGoogleProjectId();
        String other$googleProjectId = other.getGoogleProjectId();
        if (this$googleProjectId == null ? other$googleProjectId != null : !this$googleProjectId.equals(other$googleProjectId)) {
            return false;
        }
        String this$googleProjectName = this.getGoogleProjectName();
        String other$googleProjectName = other.getGoogleProjectName();
        if (this$googleProjectName == null ? other$googleProjectName != null : !this$googleProjectName.equals(other$googleProjectName)) {
            return false;
        }
        String this$googleService = this.getGoogleService();
        String other$googleService = other.getGoogleService();
        if (this$googleService == null ? other$googleService != null : !this$googleService.equals(other$googleService)) {
            return false;
        }
        List<GoogleTag> this$googleTags = this.getGoogleTags();
        List<GoogleTag> other$googleTags = other.getGoogleTags();
        if (this$googleTags == null ? other$googleTags != null : !((Object)this$googleTags).equals(other$googleTags)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GCSObject;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $gcsMetaGenerationId = this.getGcsMetaGenerationId();
        result = result * 59 + ($gcsMetaGenerationId == null ? 43 : ((Object)$gcsMetaGenerationId).hashCode());
        Long $gcsObjectDataLastModifiedTime = this.getGcsObjectDataLastModifiedTime();
        result = result * 59 + ($gcsObjectDataLastModifiedTime == null ? 43 : ((Object)$gcsObjectDataLastModifiedTime).hashCode());
        Long $gcsObjectGenerationId = this.getGcsObjectGenerationId();
        result = result * 59 + ($gcsObjectGenerationId == null ? 43 : ((Object)$gcsObjectGenerationId).hashCode());
        Long $gcsObjectRetentionExpirationDate = this.getGcsObjectRetentionExpirationDate();
        result = result * 59 + ($gcsObjectRetentionExpirationDate == null ? 43 : ((Object)$gcsObjectRetentionExpirationDate).hashCode());
        Long $gcsObjectSize = this.getGcsObjectSize();
        result = result * 59 + ($gcsObjectSize == null ? 43 : ((Object)$gcsObjectSize).hashCode());
        Boolean $gcsRequesterPays = this.getGcsRequesterPays();
        result = result * 59 + ($gcsRequesterPays == null ? 43 : ((Object)$gcsRequesterPays).hashCode());
        Long $googleProjectNumber = this.getGoogleProjectNumber();
        result = result * 59 + ($googleProjectNumber == null ? 43 : ((Object)$googleProjectNumber).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $gcsAccessControl = this.getGcsAccessControl();
        result = result * 59 + ($gcsAccessControl == null ? 43 : $gcsAccessControl.hashCode());
        IGCSBucket $gcsBucket = this.getGcsBucket();
        result = result * 59 + ($gcsBucket == null ? 43 : $gcsBucket.hashCode());
        String $gcsBucketName = this.getGcsBucketName();
        result = result * 59 + ($gcsBucketName == null ? 43 : $gcsBucketName.hashCode());
        String $gcsBucketQualifiedName = this.getGcsBucketQualifiedName();
        result = result * 59 + ($gcsBucketQualifiedName == null ? 43 : $gcsBucketQualifiedName.hashCode());
        String $gcsETag = this.getGcsETag();
        result = result * 59 + ($gcsETag == null ? 43 : $gcsETag.hashCode());
        String $gcsEncryptionType = this.getGcsEncryptionType();
        result = result * 59 + ($gcsEncryptionType == null ? 43 : $gcsEncryptionType.hashCode());
        String $gcsObjectCRC32CHash = this.getGcsObjectCRC32CHash();
        result = result * 59 + ($gcsObjectCRC32CHash == null ? 43 : $gcsObjectCRC32CHash.hashCode());
        String $gcsObjectContentDisposition = this.getGcsObjectContentDisposition();
        result = result * 59 + ($gcsObjectContentDisposition == null ? 43 : $gcsObjectContentDisposition.hashCode());
        String $gcsObjectContentEncoding = this.getGcsObjectContentEncoding();
        result = result * 59 + ($gcsObjectContentEncoding == null ? 43 : $gcsObjectContentEncoding.hashCode());
        String $gcsObjectContentLanguage = this.getGcsObjectContentLanguage();
        result = result * 59 + ($gcsObjectContentLanguage == null ? 43 : $gcsObjectContentLanguage.hashCode());
        String $gcsObjectContentType = this.getGcsObjectContentType();
        result = result * 59 + ($gcsObjectContentType == null ? 43 : $gcsObjectContentType.hashCode());
        String $gcsObjectHoldType = this.getGcsObjectHoldType();
        result = result * 59 + ($gcsObjectHoldType == null ? 43 : $gcsObjectHoldType.hashCode());
        String $gcsObjectKey = this.getGcsObjectKey();
        result = result * 59 + ($gcsObjectKey == null ? 43 : $gcsObjectKey.hashCode());
        String $gcsObjectMD5Hash = this.getGcsObjectMD5Hash();
        result = result * 59 + ($gcsObjectMD5Hash == null ? 43 : $gcsObjectMD5Hash.hashCode());
        String $gcsObjectMediaLink = this.getGcsObjectMediaLink();
        result = result * 59 + ($gcsObjectMediaLink == null ? 43 : $gcsObjectMediaLink.hashCode());
        String $gcsStorageClass = this.getGcsStorageClass();
        result = result * 59 + ($gcsStorageClass == null ? 43 : $gcsStorageClass.hashCode());
        List<GoogleLabel> $googleLabels = this.getGoogleLabels();
        result = result * 59 + ($googleLabels == null ? 43 : ((Object)$googleLabels).hashCode());
        String $googleLocation = this.getGoogleLocation();
        result = result * 59 + ($googleLocation == null ? 43 : $googleLocation.hashCode());
        String $googleLocationType = this.getGoogleLocationType();
        result = result * 59 + ($googleLocationType == null ? 43 : $googleLocationType.hashCode());
        String $googleProjectId = this.getGoogleProjectId();
        result = result * 59 + ($googleProjectId == null ? 43 : $googleProjectId.hashCode());
        String $googleProjectName = this.getGoogleProjectName();
        result = result * 59 + ($googleProjectName == null ? 43 : $googleProjectName.hashCode());
        String $googleService = this.getGoogleService();
        result = result * 59 + ($googleService == null ? 43 : $googleService.hashCode());
        List<GoogleTag> $googleTags = this.getGoogleTags();
        result = result * 59 + ($googleTags == null ? 43 : ((Object)$googleTags).hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "GCSObject(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", gcsAccessControl=" + this.getGcsAccessControl() + ", gcsBucket=" + this.getGcsBucket() + ", gcsBucketName=" + this.getGcsBucketName() + ", gcsBucketQualifiedName=" + this.getGcsBucketQualifiedName() + ", gcsETag=" + this.getGcsETag() + ", gcsEncryptionType=" + this.getGcsEncryptionType() + ", gcsMetaGenerationId=" + this.getGcsMetaGenerationId() + ", gcsObjectCRC32CHash=" + this.getGcsObjectCRC32CHash() + ", gcsObjectContentDisposition=" + this.getGcsObjectContentDisposition() + ", gcsObjectContentEncoding=" + this.getGcsObjectContentEncoding() + ", gcsObjectContentLanguage=" + this.getGcsObjectContentLanguage() + ", gcsObjectContentType=" + this.getGcsObjectContentType() + ", gcsObjectDataLastModifiedTime=" + this.getGcsObjectDataLastModifiedTime() + ", gcsObjectGenerationId=" + this.getGcsObjectGenerationId() + ", gcsObjectHoldType=" + this.getGcsObjectHoldType() + ", gcsObjectKey=" + this.getGcsObjectKey() + ", gcsObjectMD5Hash=" + this.getGcsObjectMD5Hash() + ", gcsObjectMediaLink=" + this.getGcsObjectMediaLink() + ", gcsObjectRetentionExpirationDate=" + this.getGcsObjectRetentionExpirationDate() + ", gcsObjectSize=" + this.getGcsObjectSize() + ", gcsRequesterPays=" + this.getGcsRequesterPays() + ", gcsStorageClass=" + this.getGcsStorageClass() + ", googleLabels=" + this.getGoogleLabels() + ", googleLocation=" + this.getGoogleLocation() + ", googleLocationType=" + this.getGoogleLocationType() + ", googleProjectId=" + this.getGoogleProjectId() + ", googleProjectName=" + this.getGoogleProjectName() + ", googleProjectNumber=" + this.getGoogleProjectNumber() + ", googleService=" + this.getGoogleService() + ", googleTags=" + this.getGoogleTags() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class GCSObjectBuilderImpl
    extends GCSObjectBuilder<GCSObject, GCSObjectBuilderImpl> {
        @Generated
        private GCSObjectBuilderImpl() {
        }

        @Override
        @Generated
        protected GCSObjectBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public GCSObject build() {
            return new GCSObject(this);
        }
    }

    @Generated
    public static abstract class GCSObjectBuilder<C extends GCSObject, B extends GCSObjectBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String gcsAccessControl;
        @Generated
        private IGCSBucket gcsBucket;
        @Generated
        private String gcsBucketName;
        @Generated
        private String gcsBucketQualifiedName;
        @Generated
        private String gcsETag;
        @Generated
        private String gcsEncryptionType;
        @Generated
        private Long gcsMetaGenerationId;
        @Generated
        private String gcsObjectCRC32CHash;
        @Generated
        private String gcsObjectContentDisposition;
        @Generated
        private String gcsObjectContentEncoding;
        @Generated
        private String gcsObjectContentLanguage;
        @Generated
        private String gcsObjectContentType;
        @Generated
        private Long gcsObjectDataLastModifiedTime;
        @Generated
        private Long gcsObjectGenerationId;
        @Generated
        private String gcsObjectHoldType;
        @Generated
        private String gcsObjectKey;
        @Generated
        private String gcsObjectMD5Hash;
        @Generated
        private String gcsObjectMediaLink;
        @Generated
        private Long gcsObjectRetentionExpirationDate;
        @Generated
        private Long gcsObjectSize;
        @Generated
        private Boolean gcsRequesterPays;
        @Generated
        private String gcsStorageClass;
        @Generated
        private ArrayList<GoogleLabel> googleLabels;
        @Generated
        private String googleLocation;
        @Generated
        private String googleLocationType;
        @Generated
        private String googleProjectId;
        @Generated
        private String googleProjectName;
        @Generated
        private Long googleProjectNumber;
        @Generated
        private String googleService;
        @Generated
        private ArrayList<GoogleTag> googleTags;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GCSObjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(GCSObject instance, GCSObjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.gcsAccessControl(instance.gcsAccessControl);
            b.gcsBucket(instance.gcsBucket);
            b.gcsBucketName(instance.gcsBucketName);
            b.gcsBucketQualifiedName(instance.gcsBucketQualifiedName);
            b.gcsETag(instance.gcsETag);
            b.gcsEncryptionType(instance.gcsEncryptionType);
            b.gcsMetaGenerationId(instance.gcsMetaGenerationId);
            b.gcsObjectCRC32CHash(instance.gcsObjectCRC32CHash);
            b.gcsObjectContentDisposition(instance.gcsObjectContentDisposition);
            b.gcsObjectContentEncoding(instance.gcsObjectContentEncoding);
            b.gcsObjectContentLanguage(instance.gcsObjectContentLanguage);
            b.gcsObjectContentType(instance.gcsObjectContentType);
            b.gcsObjectDataLastModifiedTime(instance.gcsObjectDataLastModifiedTime);
            b.gcsObjectGenerationId(instance.gcsObjectGenerationId);
            b.gcsObjectHoldType(instance.gcsObjectHoldType);
            b.gcsObjectKey(instance.gcsObjectKey);
            b.gcsObjectMD5Hash(instance.gcsObjectMD5Hash);
            b.gcsObjectMediaLink(instance.gcsObjectMediaLink);
            b.gcsObjectRetentionExpirationDate(instance.gcsObjectRetentionExpirationDate);
            b.gcsObjectSize(instance.gcsObjectSize);
            b.gcsRequesterPays(instance.gcsRequesterPays);
            b.gcsStorageClass(instance.gcsStorageClass);
            b.googleLabels(instance.googleLabels == null ? Collections.emptyList() : instance.googleLabels);
            b.googleLocation(instance.googleLocation);
            b.googleLocationType(instance.googleLocationType);
            b.googleProjectId(instance.googleProjectId);
            b.googleProjectName(instance.googleProjectName);
            b.googleProjectNumber(instance.googleProjectNumber);
            b.googleService(instance.googleService);
            b.googleTags(instance.googleTags == null ? Collections.emptyList() : instance.googleTags);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B gcsAccessControl(String gcsAccessControl) {
            this.gcsAccessControl = gcsAccessControl;
            return (B)this.self();
        }

        @Generated
        public B gcsBucket(IGCSBucket gcsBucket) {
            this.gcsBucket = gcsBucket;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketName(String gcsBucketName) {
            this.gcsBucketName = gcsBucketName;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketQualifiedName(String gcsBucketQualifiedName) {
            this.gcsBucketQualifiedName = gcsBucketQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B gcsETag(String gcsETag) {
            this.gcsETag = gcsETag;
            return (B)this.self();
        }

        @Generated
        public B gcsEncryptionType(String gcsEncryptionType) {
            this.gcsEncryptionType = gcsEncryptionType;
            return (B)this.self();
        }

        @Generated
        public B gcsMetaGenerationId(Long gcsMetaGenerationId) {
            this.gcsMetaGenerationId = gcsMetaGenerationId;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectCRC32CHash(String gcsObjectCRC32CHash) {
            this.gcsObjectCRC32CHash = gcsObjectCRC32CHash;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectContentDisposition(String gcsObjectContentDisposition) {
            this.gcsObjectContentDisposition = gcsObjectContentDisposition;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectContentEncoding(String gcsObjectContentEncoding) {
            this.gcsObjectContentEncoding = gcsObjectContentEncoding;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectContentLanguage(String gcsObjectContentLanguage) {
            this.gcsObjectContentLanguage = gcsObjectContentLanguage;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectContentType(String gcsObjectContentType) {
            this.gcsObjectContentType = gcsObjectContentType;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectDataLastModifiedTime(Long gcsObjectDataLastModifiedTime) {
            this.gcsObjectDataLastModifiedTime = gcsObjectDataLastModifiedTime;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectGenerationId(Long gcsObjectGenerationId) {
            this.gcsObjectGenerationId = gcsObjectGenerationId;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectHoldType(String gcsObjectHoldType) {
            this.gcsObjectHoldType = gcsObjectHoldType;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectKey(String gcsObjectKey) {
            this.gcsObjectKey = gcsObjectKey;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectMD5Hash(String gcsObjectMD5Hash) {
            this.gcsObjectMD5Hash = gcsObjectMD5Hash;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectMediaLink(String gcsObjectMediaLink) {
            this.gcsObjectMediaLink = gcsObjectMediaLink;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectRetentionExpirationDate(Long gcsObjectRetentionExpirationDate) {
            this.gcsObjectRetentionExpirationDate = gcsObjectRetentionExpirationDate;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectSize(Long gcsObjectSize) {
            this.gcsObjectSize = gcsObjectSize;
            return (B)this.self();
        }

        @Generated
        public B gcsRequesterPays(Boolean gcsRequesterPays) {
            this.gcsRequesterPays = gcsRequesterPays;
            return (B)this.self();
        }

        @Generated
        public B gcsStorageClass(String gcsStorageClass) {
            this.gcsStorageClass = gcsStorageClass;
            return (B)this.self();
        }

        @Generated
        public B googleLabel(GoogleLabel googleLabel) {
            if (this.googleLabels == null) {
                this.googleLabels = new ArrayList();
            }
            this.googleLabels.add(googleLabel);
            return (B)this.self();
        }

        @Generated
        public B googleLabels(Collection<? extends GoogleLabel> googleLabels) {
            if (googleLabels == null) {
                throw new NullPointerException("googleLabels cannot be null");
            }
            if (this.googleLabels == null) {
                this.googleLabels = new ArrayList();
            }
            this.googleLabels.addAll(googleLabels);
            return (B)this.self();
        }

        @Generated
        public B clearGoogleLabels() {
            if (this.googleLabels != null) {
                this.googleLabels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B googleLocation(String googleLocation) {
            this.googleLocation = googleLocation;
            return (B)this.self();
        }

        @Generated
        public B googleLocationType(String googleLocationType) {
            this.googleLocationType = googleLocationType;
            return (B)this.self();
        }

        @Generated
        public B googleProjectId(String googleProjectId) {
            this.googleProjectId = googleProjectId;
            return (B)this.self();
        }

        @Generated
        public B googleProjectName(String googleProjectName) {
            this.googleProjectName = googleProjectName;
            return (B)this.self();
        }

        @Generated
        public B googleProjectNumber(Long googleProjectNumber) {
            this.googleProjectNumber = googleProjectNumber;
            return (B)this.self();
        }

        @Generated
        public B googleService(String googleService) {
            this.googleService = googleService;
            return (B)this.self();
        }

        @Generated
        public B googleTag(GoogleTag googleTag) {
            if (this.googleTags == null) {
                this.googleTags = new ArrayList();
            }
            this.googleTags.add(googleTag);
            return (B)this.self();
        }

        @Generated
        public B googleTags(Collection<? extends GoogleTag> googleTags) {
            if (googleTags == null) {
                throw new NullPointerException("googleTags cannot be null");
            }
            if (this.googleTags == null) {
                this.googleTags = new ArrayList();
            }
            this.googleTags.addAll(googleTags);
            return (B)this.self();
        }

        @Generated
        public B clearGoogleTags() {
            if (this.googleTags != null) {
                this.googleTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "GCSObject.GCSObjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", gcsAccessControl=" + this.gcsAccessControl + ", gcsBucket=" + this.gcsBucket + ", gcsBucketName=" + this.gcsBucketName + ", gcsBucketQualifiedName=" + this.gcsBucketQualifiedName + ", gcsETag=" + this.gcsETag + ", gcsEncryptionType=" + this.gcsEncryptionType + ", gcsMetaGenerationId=" + this.gcsMetaGenerationId + ", gcsObjectCRC32CHash=" + this.gcsObjectCRC32CHash + ", gcsObjectContentDisposition=" + this.gcsObjectContentDisposition + ", gcsObjectContentEncoding=" + this.gcsObjectContentEncoding + ", gcsObjectContentLanguage=" + this.gcsObjectContentLanguage + ", gcsObjectContentType=" + this.gcsObjectContentType + ", gcsObjectDataLastModifiedTime=" + this.gcsObjectDataLastModifiedTime + ", gcsObjectGenerationId=" + this.gcsObjectGenerationId + ", gcsObjectHoldType=" + this.gcsObjectHoldType + ", gcsObjectKey=" + this.gcsObjectKey + ", gcsObjectMD5Hash=" + this.gcsObjectMD5Hash + ", gcsObjectMediaLink=" + this.gcsObjectMediaLink + ", gcsObjectRetentionExpirationDate=" + this.gcsObjectRetentionExpirationDate + ", gcsObjectSize=" + this.gcsObjectSize + ", gcsRequesterPays=" + this.gcsRequesterPays + ", gcsStorageClass=" + this.gcsStorageClass + ", googleLabels=" + this.googleLabels + ", googleLocation=" + this.googleLocation + ", googleLocationType=" + this.googleLocationType + ", googleProjectId=" + this.googleProjectId + ", googleProjectName=" + this.googleProjectName + ", googleProjectNumber=" + this.googleProjectNumber + ", googleService=" + this.googleService + ", googleTags=" + this.googleTags + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ")";
        }
    }
}

