/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Glossary;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IGlossary;
import com.atlan.model.assets.IGlossaryCategory;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryCategory
extends Asset
implements IGlossaryCategory,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlossaryCategory.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AtlasGlossaryCategory";
    String typeName;
    @Attribute
    Map<String, String> additionalAttributes;
    @Attribute
    IGlossary anchor;
    @Attribute
    SortedSet<IGlossaryCategory> childrenCategories;
    @Attribute
    String longDescription;
    @Attribute
    IGlossaryCategory parentCategory;
    @Attribute
    String shortDescription;
    @Attribute
    SortedSet<IGlossaryTerm> terms;

    @Override
    public GlossaryCategory trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return GlossaryCategory.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return GlossaryCategory.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return GlossaryCategory.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return GlossaryCategory.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return GlossaryCategory.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return GlossaryCategory.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return GlossaryCategory.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return GlossaryCategory.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return GlossaryCategory.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static GlossaryCategory refByGuid(String guid) {
        return ((GlossaryCategoryBuilder)GlossaryCategory._internal().guid(guid)).build();
    }

    public static GlossaryCategory refByQualifiedName(String qualifiedName) {
        return ((GlossaryCategoryBuilder)GlossaryCategory._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static GlossaryCategory get(String id) throws AtlanException {
        return GlossaryCategory.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static GlossaryCategory get(AtlanClient client, String id) throws AtlanException {
        return GlossaryCategory.get(client, id, true);
    }

    @JsonIgnore
    public static GlossaryCategory get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof GlossaryCategory) {
                return (GlossaryCategory)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof GlossaryCategory) {
            return (GlossaryCategory)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static GlossaryCategory retrieveByGuid(String guid) throws AtlanException {
        return GlossaryCategory.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static GlossaryCategory retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return GlossaryCategory.get(client, guid);
    }

    @Deprecated
    public static GlossaryCategory retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return GlossaryCategory.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static GlossaryCategory retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return GlossaryCategory.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return GlossaryCategory.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static GlossaryCategoryBuilder<?, ?> creator(String name, Glossary glossary) throws InvalidRequestException {
        return GlossaryCategory.creator(name, (String)null).anchor(glossary.trimToReference());
    }

    public static GlossaryCategoryBuilder<?, ?> creator(String name, String glossaryId) {
        Glossary anchor = StringUtils.isUUID(glossaryId) ? Glossary.refByGuid(glossaryId) : Glossary.refByQualifiedName(glossaryId);
        return ((GlossaryCategoryBuilder)((GlossaryCategoryBuilder)((GlossaryCategoryBuilder)GlossaryCategory._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(name)).name(name)).anchor(anchor);
    }

    @Deprecated
    public static GlossaryCategoryBuilder<?, ?> creator(String name, String glossaryGuid, String glossaryQualifiedName) {
        if (glossaryGuid != null) {
            return GlossaryCategory.creator(name, glossaryGuid);
        }
        return GlossaryCategory.creator(name, glossaryQualifiedName);
    }

    public static GlossaryCategoryBuilder<?, ?> updater(String qualifiedName, String name, String glossaryGuid) {
        return ((GlossaryCategoryBuilder)((GlossaryCategoryBuilder)((GlossaryCategoryBuilder)GlossaryCategory._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name)).anchor(Glossary.refByGuid(glossaryGuid));
    }

    public GlossaryCategoryBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (this.getAnchor() == null || !this.getAnchor().isValidReferenceByGuid()) {
            missing.add("anchor.guid");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, "GlossaryCategory", String.join((CharSequence)",", missing));
        }
        return GlossaryCategory.updater(this.getQualifiedName(), this.getName(), this.getAnchor().getGuid());
    }

    public static List<GlossaryCategory> findByName(String name, String glossaryName) throws AtlanException {
        return GlossaryCategory.findByName(name, glossaryName, (List<AtlanField>)null);
    }

    public static List<GlossaryCategory> findByName(String name, String glossaryName, Collection<String> attributes) throws AtlanException {
        return GlossaryCategory.findByName(Atlan.getDefaultClient(), name, glossaryName, attributes);
    }

    public static List<GlossaryCategory> findByName(String name, String glossaryName, List<AtlanField> attributes) throws AtlanException {
        return GlossaryCategory.findByName(Atlan.getDefaultClient(), name, glossaryName, attributes);
    }

    public static List<GlossaryCategory> findByName(AtlanClient client, String name, String glossaryName) throws AtlanException {
        return GlossaryCategory.findByName(client, name, glossaryName, (List<AtlanField>)null);
    }

    public static List<GlossaryCategory> findByName(AtlanClient client, String name, String glossaryName, Collection<String> attributes) throws AtlanException {
        Glossary glossary = Glossary.findByName(client, glossaryName);
        return GlossaryCategory.findByNameFast(client, name, glossary.getQualifiedName(), attributes);
    }

    public static List<GlossaryCategory> findByName(AtlanClient client, String name, String glossaryName, List<AtlanField> attributes) throws AtlanException {
        Glossary glossary = Glossary.findByName(client, glossaryName);
        return GlossaryCategory.findByNameFast(client, name, glossary.getQualifiedName(), attributes);
    }

    public static List<GlossaryCategory> findByNameFast(String name, String glossaryQualifiedName) throws AtlanException {
        return GlossaryCategory.findByNameFast(name, glossaryQualifiedName, (List<AtlanField>)null);
    }

    public static List<GlossaryCategory> findByNameFast(String name, String glossaryQualifiedName, Collection<String> attributes) throws AtlanException {
        return GlossaryCategory.findByNameFast(Atlan.getDefaultClient(), name, glossaryQualifiedName, attributes);
    }

    public static List<GlossaryCategory> findByNameFast(String name, String glossaryQualifiedName, List<AtlanField> attributes) throws AtlanException {
        return GlossaryCategory.findByNameFast(Atlan.getDefaultClient(), name, glossaryQualifiedName, attributes);
    }

    public static List<GlossaryCategory> findByNameFast(AtlanClient client, String name, String glossaryQualifiedName) throws AtlanException {
        return GlossaryCategory.findByNameFast(client, name, glossaryQualifiedName, (List<AtlanField>)null);
    }

    public static List<GlossaryCategory> findByNameFast(AtlanClient client, String name, String glossaryQualifiedName, Collection<String> attributes) throws AtlanException {
        ArrayList<GlossaryCategory> results = new ArrayList<GlossaryCategory>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)GlossaryCategory.select(client).where(NAME.eq(name))).where(ANCHOR.eq(glossaryQualifiedName)))._includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof GlossaryCategory).forEach(c -> results.add((GlossaryCategory)c));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        }
        return results;
    }

    public static List<GlossaryCategory> findByNameFast(AtlanClient client, String name, String glossaryQualifiedName, List<AtlanField> attributes) throws AtlanException {
        ArrayList<GlossaryCategory> results = new ArrayList<GlossaryCategory>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)GlossaryCategory.select(client).where(NAME.eq(name))).where(ANCHOR.eq(glossaryQualifiedName))).includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof GlossaryCategory).forEach(c -> results.add((GlossaryCategory)c));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        }
        return results;
    }

    public static GlossaryCategory removeDescription(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return GlossaryCategory.removeDescription(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid);
    }

    public static GlossaryCategory removeDescription(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryCategory)Asset.removeDescription(client, GlossaryCategory.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryCategory removeUserDescription(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return GlossaryCategory.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid);
    }

    public static GlossaryCategory removeUserDescription(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryCategory)Asset.removeUserDescription(client, GlossaryCategory.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryCategory removeOwners(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return GlossaryCategory.removeOwners(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid);
    }

    public static GlossaryCategory removeOwners(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryCategory)Asset.removeOwners(client, GlossaryCategory.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryCategory updateCertificate(String qualifiedName, String name, String glossaryGuid, CertificateStatus certificate, String message) throws AtlanException {
        return GlossaryCategory.updateCertificate(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid, certificate, message);
    }

    public static GlossaryCategory updateCertificate(AtlanClient client, String qualifiedName, String name, String glossaryGuid, CertificateStatus certificate, String message) throws AtlanException {
        return (GlossaryCategory)Asset.updateCertificate(client, GlossaryCategory.updater(qualifiedName, name, glossaryGuid), certificate, message);
    }

    public static GlossaryCategory removeCertificate(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return GlossaryCategory.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid);
    }

    public static GlossaryCategory removeCertificate(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryCategory)Asset.removeCertificate(client, GlossaryCategory.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryCategory updateAnnouncement(String qualifiedName, String name, String glossaryGuid, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return GlossaryCategory.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid, type, title, message);
    }

    public static GlossaryCategory updateAnnouncement(AtlanClient client, String qualifiedName, String name, String glossaryGuid, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (GlossaryCategory)Asset.updateAnnouncement(client, GlossaryCategory.updater(qualifiedName, name, glossaryGuid), type, title, message);
    }

    public static GlossaryCategory removeAnnouncement(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return GlossaryCategory.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid);
    }

    public static GlossaryCategory removeAnnouncement(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryCategory)Asset.removeAnnouncement(client, GlossaryCategory.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryCategory appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return GlossaryCategory.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static GlossaryCategory appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (GlossaryCategory)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static GlossaryCategory appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return GlossaryCategory.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static GlossaryCategory appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (GlossaryCategory)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        GlossaryCategory.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        GlossaryCategory.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        GlossaryCategory.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected GlossaryCategory(GlossaryCategoryBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> additionalAttributes;
        this.typeName = b.typeName$set ? b.typeName$value : GlossaryCategory.$default$typeName();
        switch (b.additionalAttributes$key == null ? 0 : b.additionalAttributes$key.size()) {
            case 0: {
                additionalAttributes = Collections.emptyMap();
                break;
            }
            case 1: {
                additionalAttributes = Collections.singletonMap(b.additionalAttributes$key.get(0), b.additionalAttributes$value.get(0));
                break;
            }
            default: {
                additionalAttributes = new LinkedHashMap(b.additionalAttributes$key.size() < 0x40000000 ? 1 + b.additionalAttributes$key.size() + (b.additionalAttributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.additionalAttributes$key.size(); ++$i) {
                    additionalAttributes.put(b.additionalAttributes$key.get($i), b.additionalAttributes$value.get($i));
                }
                additionalAttributes = Collections.unmodifiableMap(additionalAttributes);
            }
        }
        this.additionalAttributes = additionalAttributes;
        this.anchor = b.anchor;
        SortedSet<IGlossaryCategory> childrenCategories = new TreeSet<IGlossaryCategory>();
        if (b.childrenCategories != null) {
            childrenCategories.addAll(b.childrenCategories);
        }
        childrenCategories = Collections.unmodifiableSortedSet(childrenCategories);
        this.childrenCategories = childrenCategories;
        this.longDescription = b.longDescription;
        this.parentCategory = b.parentCategory;
        this.shortDescription = b.shortDescription;
        SortedSet<IGlossaryTerm> terms = new TreeSet<IGlossaryTerm>();
        if (b.terms != null) {
            terms.addAll(b.terms);
        }
        terms = Collections.unmodifiableSortedSet(terms);
        this.terms = terms;
    }

    @Generated
    public static GlossaryCategoryBuilder<?, ?> _internal() {
        return new GlossaryCategoryBuilderImpl();
    }

    @Generated
    public GlossaryCategoryBuilder<?, ?> toBuilder() {
        return new GlossaryCategoryBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Map<String, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    @Override
    @Generated
    public IGlossary getAnchor() {
        return this.anchor;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryCategory> getChildrenCategories() {
        return this.childrenCategories;
    }

    @Override
    @Generated
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    @Generated
    public IGlossaryCategory getParentCategory() {
        return this.parentCategory;
    }

    @Override
    @Generated
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getTerms() {
        return this.terms;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlossaryCategory)) {
            return false;
        }
        GlossaryCategory other = (GlossaryCategory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        Map<String, String> this$additionalAttributes = this.getAdditionalAttributes();
        Map<String, String> other$additionalAttributes = other.getAdditionalAttributes();
        if (this$additionalAttributes == null ? other$additionalAttributes != null : !((Object)this$additionalAttributes).equals(other$additionalAttributes)) {
            return false;
        }
        IGlossary this$anchor = this.getAnchor();
        IGlossary other$anchor = other.getAnchor();
        if (this$anchor == null ? other$anchor != null : !this$anchor.equals(other$anchor)) {
            return false;
        }
        SortedSet<IGlossaryCategory> this$childrenCategories = this.getChildrenCategories();
        SortedSet<IGlossaryCategory> other$childrenCategories = other.getChildrenCategories();
        if (this$childrenCategories == null ? other$childrenCategories != null : !this$childrenCategories.equals(other$childrenCategories)) {
            return false;
        }
        String this$longDescription = this.getLongDescription();
        String other$longDescription = other.getLongDescription();
        if (this$longDescription == null ? other$longDescription != null : !this$longDescription.equals(other$longDescription)) {
            return false;
        }
        IGlossaryCategory this$parentCategory = this.getParentCategory();
        IGlossaryCategory other$parentCategory = other.getParentCategory();
        if (this$parentCategory == null ? other$parentCategory != null : !this$parentCategory.equals(other$parentCategory)) {
            return false;
        }
        String this$shortDescription = this.getShortDescription();
        String other$shortDescription = other.getShortDescription();
        if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$terms = this.getTerms();
        SortedSet<IGlossaryTerm> other$terms = other.getTerms();
        return !(this$terms == null ? other$terms != null : !this$terms.equals(other$terms));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GlossaryCategory;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        Map<String, String> $additionalAttributes = this.getAdditionalAttributes();
        result = result * 59 + ($additionalAttributes == null ? 43 : ((Object)$additionalAttributes).hashCode());
        IGlossary $anchor = this.getAnchor();
        result = result * 59 + ($anchor == null ? 43 : $anchor.hashCode());
        SortedSet<IGlossaryCategory> $childrenCategories = this.getChildrenCategories();
        result = result * 59 + ($childrenCategories == null ? 43 : $childrenCategories.hashCode());
        String $longDescription = this.getLongDescription();
        result = result * 59 + ($longDescription == null ? 43 : $longDescription.hashCode());
        IGlossaryCategory $parentCategory = this.getParentCategory();
        result = result * 59 + ($parentCategory == null ? 43 : $parentCategory.hashCode());
        String $shortDescription = this.getShortDescription();
        result = result * 59 + ($shortDescription == null ? 43 : $shortDescription.hashCode());
        SortedSet<IGlossaryTerm> $terms = this.getTerms();
        result = result * 59 + ($terms == null ? 43 : $terms.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "GlossaryCategory(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", additionalAttributes=" + this.getAdditionalAttributes() + ", anchor=" + this.getAnchor() + ", childrenCategories=" + this.getChildrenCategories() + ", longDescription=" + this.getLongDescription() + ", parentCategory=" + this.getParentCategory() + ", shortDescription=" + this.getShortDescription() + ", terms=" + this.getTerms() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    void setChildrenCategories(SortedSet<IGlossaryCategory> childrenCategories) {
        this.childrenCategories = childrenCategories;
    }

    @Generated
    private static final class GlossaryCategoryBuilderImpl
    extends GlossaryCategoryBuilder<GlossaryCategory, GlossaryCategoryBuilderImpl> {
        @Generated
        private GlossaryCategoryBuilderImpl() {
        }

        @Override
        @Generated
        protected GlossaryCategoryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public GlossaryCategory build() {
            return new GlossaryCategory(this);
        }
    }

    @Generated
    public static abstract class GlossaryCategoryBuilder<C extends GlossaryCategory, B extends GlossaryCategoryBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<String> additionalAttributes$key;
        @Generated
        private ArrayList<String> additionalAttributes$value;
        @Generated
        private IGlossary anchor;
        @Generated
        private ArrayList<IGlossaryCategory> childrenCategories;
        @Generated
        private String longDescription;
        @Generated
        private IGlossaryCategory parentCategory;
        @Generated
        private String shortDescription;
        @Generated
        private ArrayList<IGlossaryTerm> terms;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GlossaryCategoryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(GlossaryCategory instance, GlossaryCategoryBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.additionalAttributes(instance.additionalAttributes == null ? Collections.emptyMap() : instance.additionalAttributes);
            b.anchor(instance.anchor);
            b.childrenCategories(instance.childrenCategories == null ? Collections.emptySortedSet() : instance.childrenCategories);
            b.longDescription(instance.longDescription);
            b.parentCategory(instance.parentCategory);
            b.shortDescription(instance.shortDescription);
            b.terms(instance.terms == null ? Collections.emptySortedSet() : instance.terms);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B additionalAttribute(String additionalAttributeKey, String additionalAttributeValue) {
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new ArrayList();
                this.additionalAttributes$value = new ArrayList();
            }
            this.additionalAttributes$key.add(additionalAttributeKey);
            this.additionalAttributes$value.add(additionalAttributeValue);
            return (B)this.self();
        }

        @Generated
        public B additionalAttributes(Map<? extends String, ? extends String> additionalAttributes) {
            if (additionalAttributes == null) {
                throw new NullPointerException("additionalAttributes cannot be null");
            }
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new ArrayList();
                this.additionalAttributes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : additionalAttributes.entrySet()) {
                this.additionalAttributes$key.add($lombokEntry.getKey());
                this.additionalAttributes$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearAdditionalAttributes() {
            if (this.additionalAttributes$key != null) {
                this.additionalAttributes$key.clear();
                this.additionalAttributes$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B anchor(IGlossary anchor) {
            this.anchor = anchor;
            return (B)this.self();
        }

        @Generated
        public B childCategory(IGlossaryCategory childCategory) {
            if (this.childrenCategories == null) {
                this.childrenCategories = new ArrayList();
            }
            this.childrenCategories.add(childCategory);
            return (B)this.self();
        }

        @Generated
        public B childrenCategories(Collection<? extends IGlossaryCategory> childrenCategories) {
            if (childrenCategories == null) {
                throw new NullPointerException("childrenCategories cannot be null");
            }
            if (this.childrenCategories == null) {
                this.childrenCategories = new ArrayList();
            }
            this.childrenCategories.addAll(childrenCategories);
            return (B)this.self();
        }

        @Generated
        public B clearChildrenCategories() {
            if (this.childrenCategories != null) {
                this.childrenCategories.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B longDescription(String longDescription) {
            this.longDescription = longDescription;
            return (B)this.self();
        }

        @Generated
        public B parentCategory(IGlossaryCategory parentCategory) {
            this.parentCategory = parentCategory;
            return (B)this.self();
        }

        @Generated
        public B shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return (B)this.self();
        }

        @Generated
        public B term(IGlossaryTerm term) {
            if (this.terms == null) {
                this.terms = new ArrayList();
            }
            this.terms.add(term);
            return (B)this.self();
        }

        @Generated
        public B terms(Collection<? extends IGlossaryTerm> terms) {
            if (terms == null) {
                throw new NullPointerException("terms cannot be null");
            }
            if (this.terms == null) {
                this.terms = new ArrayList();
            }
            this.terms.addAll(terms);
            return (B)this.self();
        }

        @Generated
        public B clearTerms() {
            if (this.terms != null) {
                this.terms.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "GlossaryCategory.GlossaryCategoryBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", additionalAttributes$key=" + this.additionalAttributes$key + ", additionalAttributes$value=" + this.additionalAttributes$value + ", anchor=" + this.anchor + ", childrenCategories=" + this.childrenCategories + ", longDescription=" + this.longDescription + ", parentCategory=" + this.parentCategory + ", shortDescription=" + this.shortDescription + ", terms=" + this.terms + ")";
        }
    }
}

