/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IEventStore;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IKafka;
import com.atlan.model.assets.IKafkaConsumerGroup;
import com.atlan.model.assets.IKafkaTopic;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.KafkaTopicCleanupPolicy;
import com.atlan.model.enums.KafkaTopicCompressionType;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTopic
extends Asset
implements IKafkaTopic,
IKafka,
IEventStore,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaTopic.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "KafkaTopic";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<IKafkaConsumerGroup> kafkaConsumerGroups;
    @Attribute
    KafkaTopicCleanupPolicy kafkaTopicCleanupPolicy;
    @Attribute
    KafkaTopicCompressionType kafkaTopicCompressionType;
    @Attribute
    Boolean kafkaTopicIsInternal;
    @Attribute
    Long kafkaTopicPartitionsCount;
    @Attribute
    Long kafkaTopicRecordCount;
    @Attribute
    Long kafkaTopicReplicationFactor;
    @Attribute
    Long kafkaTopicSegmentBytes;
    @Attribute
    Long kafkaTopicSizeInBytes;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;

    @Override
    public KafkaTopic trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return KafkaTopic.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return KafkaTopic.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return KafkaTopic.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return KafkaTopic.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return KafkaTopic.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return KafkaTopic.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return KafkaTopic.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return KafkaTopic.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return KafkaTopic.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static KafkaTopic refByGuid(String guid) {
        return ((KafkaTopicBuilder)KafkaTopic._internal().guid(guid)).build();
    }

    public static KafkaTopic refByQualifiedName(String qualifiedName) {
        return ((KafkaTopicBuilder)KafkaTopic._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static KafkaTopic get(String id) throws AtlanException {
        return KafkaTopic.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static KafkaTopic get(AtlanClient client, String id) throws AtlanException {
        return KafkaTopic.get(client, id, true);
    }

    @JsonIgnore
    public static KafkaTopic get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof KafkaTopic) {
                return (KafkaTopic)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof KafkaTopic) {
            return (KafkaTopic)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static KafkaTopic retrieveByGuid(String guid) throws AtlanException {
        return KafkaTopic.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static KafkaTopic retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return KafkaTopic.get(client, guid);
    }

    @Deprecated
    public static KafkaTopic retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return KafkaTopic.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static KafkaTopic retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return KafkaTopic.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return KafkaTopic.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static KafkaTopicBuilder<?, ?> updater(String qualifiedName, String name) {
        return (KafkaTopicBuilder)((KafkaTopicBuilder)((KafkaTopicBuilder)KafkaTopic._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public KafkaTopicBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return KafkaTopic.updater(this.getQualifiedName(), this.getName());
    }

    public static KafkaTopic removeDescription(String qualifiedName, String name) throws AtlanException {
        return KafkaTopic.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static KafkaTopic removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (KafkaTopic)Asset.removeDescription(client, KafkaTopic.updater(qualifiedName, name));
    }

    public static KafkaTopic removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return KafkaTopic.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static KafkaTopic removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (KafkaTopic)Asset.removeUserDescription(client, KafkaTopic.updater(qualifiedName, name));
    }

    public static KafkaTopic removeOwners(String qualifiedName, String name) throws AtlanException {
        return KafkaTopic.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static KafkaTopic removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (KafkaTopic)Asset.removeOwners(client, KafkaTopic.updater(qualifiedName, name));
    }

    public static KafkaTopic updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return KafkaTopic.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static KafkaTopic updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (KafkaTopic)Asset.updateCertificate(client, KafkaTopic._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static KafkaTopic removeCertificate(String qualifiedName, String name) throws AtlanException {
        return KafkaTopic.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static KafkaTopic removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (KafkaTopic)Asset.removeCertificate(client, KafkaTopic.updater(qualifiedName, name));
    }

    public static KafkaTopic updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return KafkaTopic.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static KafkaTopic updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (KafkaTopic)Asset.updateAnnouncement(client, KafkaTopic._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static KafkaTopic removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return KafkaTopic.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static KafkaTopic removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (KafkaTopic)Asset.removeAnnouncement(client, KafkaTopic.updater(qualifiedName, name));
    }

    public static KafkaTopic replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return KafkaTopic.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static KafkaTopic replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (KafkaTopic)Asset.replaceTerms(client, KafkaTopic.updater(qualifiedName, name), terms);
    }

    public static KafkaTopic appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return KafkaTopic.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static KafkaTopic appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (KafkaTopic)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static KafkaTopic removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return KafkaTopic.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static KafkaTopic removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (KafkaTopic)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static KafkaTopic appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return KafkaTopic.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static KafkaTopic appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (KafkaTopic)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static KafkaTopic appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return KafkaTopic.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static KafkaTopic appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (KafkaTopic)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        KafkaTopic.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        KafkaTopic.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        KafkaTopic.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected KafkaTopic(KafkaTopicBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : KafkaTopic.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<IKafkaConsumerGroup> kafkaConsumerGroups = new TreeSet<IKafkaConsumerGroup>();
        if (b.kafkaConsumerGroups != null) {
            kafkaConsumerGroups.addAll(b.kafkaConsumerGroups);
        }
        kafkaConsumerGroups = Collections.unmodifiableSortedSet(kafkaConsumerGroups);
        this.kafkaConsumerGroups = kafkaConsumerGroups;
        this.kafkaTopicCleanupPolicy = b.kafkaTopicCleanupPolicy;
        this.kafkaTopicCompressionType = b.kafkaTopicCompressionType;
        this.kafkaTopicIsInternal = b.kafkaTopicIsInternal;
        this.kafkaTopicPartitionsCount = b.kafkaTopicPartitionsCount;
        this.kafkaTopicRecordCount = b.kafkaTopicRecordCount;
        this.kafkaTopicReplicationFactor = b.kafkaTopicReplicationFactor;
        this.kafkaTopicSegmentBytes = b.kafkaTopicSegmentBytes;
        this.kafkaTopicSizeInBytes = b.kafkaTopicSizeInBytes;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
    }

    @Generated
    public static KafkaTopicBuilder<?, ?> _internal() {
        return new KafkaTopicBuilderImpl();
    }

    @Generated
    public KafkaTopicBuilder<?, ?> toBuilder() {
        return new KafkaTopicBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<IKafkaConsumerGroup> getKafkaConsumerGroups() {
        return this.kafkaConsumerGroups;
    }

    @Override
    @Generated
    public KafkaTopicCleanupPolicy getKafkaTopicCleanupPolicy() {
        return this.kafkaTopicCleanupPolicy;
    }

    @Override
    @Generated
    public KafkaTopicCompressionType getKafkaTopicCompressionType() {
        return this.kafkaTopicCompressionType;
    }

    @Override
    @Generated
    public Boolean getKafkaTopicIsInternal() {
        return this.kafkaTopicIsInternal;
    }

    @Override
    @Generated
    public Long getKafkaTopicPartitionsCount() {
        return this.kafkaTopicPartitionsCount;
    }

    @Override
    @Generated
    public Long getKafkaTopicRecordCount() {
        return this.kafkaTopicRecordCount;
    }

    @Override
    @Generated
    public Long getKafkaTopicReplicationFactor() {
        return this.kafkaTopicReplicationFactor;
    }

    @Override
    @Generated
    public Long getKafkaTopicSegmentBytes() {
        return this.kafkaTopicSegmentBytes;
    }

    @Override
    @Generated
    public Long getKafkaTopicSizeInBytes() {
        return this.kafkaTopicSizeInBytes;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaTopic)) {
            return false;
        }
        KafkaTopic other = (KafkaTopic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$kafkaTopicIsInternal = this.getKafkaTopicIsInternal();
        Boolean other$kafkaTopicIsInternal = other.getKafkaTopicIsInternal();
        if (this$kafkaTopicIsInternal == null ? other$kafkaTopicIsInternal != null : !((Object)this$kafkaTopicIsInternal).equals(other$kafkaTopicIsInternal)) {
            return false;
        }
        Long this$kafkaTopicPartitionsCount = this.getKafkaTopicPartitionsCount();
        Long other$kafkaTopicPartitionsCount = other.getKafkaTopicPartitionsCount();
        if (this$kafkaTopicPartitionsCount == null ? other$kafkaTopicPartitionsCount != null : !((Object)this$kafkaTopicPartitionsCount).equals(other$kafkaTopicPartitionsCount)) {
            return false;
        }
        Long this$kafkaTopicRecordCount = this.getKafkaTopicRecordCount();
        Long other$kafkaTopicRecordCount = other.getKafkaTopicRecordCount();
        if (this$kafkaTopicRecordCount == null ? other$kafkaTopicRecordCount != null : !((Object)this$kafkaTopicRecordCount).equals(other$kafkaTopicRecordCount)) {
            return false;
        }
        Long this$kafkaTopicReplicationFactor = this.getKafkaTopicReplicationFactor();
        Long other$kafkaTopicReplicationFactor = other.getKafkaTopicReplicationFactor();
        if (this$kafkaTopicReplicationFactor == null ? other$kafkaTopicReplicationFactor != null : !((Object)this$kafkaTopicReplicationFactor).equals(other$kafkaTopicReplicationFactor)) {
            return false;
        }
        Long this$kafkaTopicSegmentBytes = this.getKafkaTopicSegmentBytes();
        Long other$kafkaTopicSegmentBytes = other.getKafkaTopicSegmentBytes();
        if (this$kafkaTopicSegmentBytes == null ? other$kafkaTopicSegmentBytes != null : !((Object)this$kafkaTopicSegmentBytes).equals(other$kafkaTopicSegmentBytes)) {
            return false;
        }
        Long this$kafkaTopicSizeInBytes = this.getKafkaTopicSizeInBytes();
        Long other$kafkaTopicSizeInBytes = other.getKafkaTopicSizeInBytes();
        if (this$kafkaTopicSizeInBytes == null ? other$kafkaTopicSizeInBytes != null : !((Object)this$kafkaTopicSizeInBytes).equals(other$kafkaTopicSizeInBytes)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IKafkaConsumerGroup> this$kafkaConsumerGroups = this.getKafkaConsumerGroups();
        SortedSet<IKafkaConsumerGroup> other$kafkaConsumerGroups = other.getKafkaConsumerGroups();
        if (this$kafkaConsumerGroups == null ? other$kafkaConsumerGroups != null : !this$kafkaConsumerGroups.equals(other$kafkaConsumerGroups)) {
            return false;
        }
        KafkaTopicCleanupPolicy this$kafkaTopicCleanupPolicy = this.getKafkaTopicCleanupPolicy();
        KafkaTopicCleanupPolicy other$kafkaTopicCleanupPolicy = other.getKafkaTopicCleanupPolicy();
        if (this$kafkaTopicCleanupPolicy == null ? other$kafkaTopicCleanupPolicy != null : !this$kafkaTopicCleanupPolicy.equals(other$kafkaTopicCleanupPolicy)) {
            return false;
        }
        KafkaTopicCompressionType this$kafkaTopicCompressionType = this.getKafkaTopicCompressionType();
        KafkaTopicCompressionType other$kafkaTopicCompressionType = other.getKafkaTopicCompressionType();
        if (this$kafkaTopicCompressionType == null ? other$kafkaTopicCompressionType != null : !this$kafkaTopicCompressionType.equals(other$kafkaTopicCompressionType)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KafkaTopic;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $kafkaTopicIsInternal = this.getKafkaTopicIsInternal();
        result = result * 59 + ($kafkaTopicIsInternal == null ? 43 : ((Object)$kafkaTopicIsInternal).hashCode());
        Long $kafkaTopicPartitionsCount = this.getKafkaTopicPartitionsCount();
        result = result * 59 + ($kafkaTopicPartitionsCount == null ? 43 : ((Object)$kafkaTopicPartitionsCount).hashCode());
        Long $kafkaTopicRecordCount = this.getKafkaTopicRecordCount();
        result = result * 59 + ($kafkaTopicRecordCount == null ? 43 : ((Object)$kafkaTopicRecordCount).hashCode());
        Long $kafkaTopicReplicationFactor = this.getKafkaTopicReplicationFactor();
        result = result * 59 + ($kafkaTopicReplicationFactor == null ? 43 : ((Object)$kafkaTopicReplicationFactor).hashCode());
        Long $kafkaTopicSegmentBytes = this.getKafkaTopicSegmentBytes();
        result = result * 59 + ($kafkaTopicSegmentBytes == null ? 43 : ((Object)$kafkaTopicSegmentBytes).hashCode());
        Long $kafkaTopicSizeInBytes = this.getKafkaTopicSizeInBytes();
        result = result * 59 + ($kafkaTopicSizeInBytes == null ? 43 : ((Object)$kafkaTopicSizeInBytes).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IKafkaConsumerGroup> $kafkaConsumerGroups = this.getKafkaConsumerGroups();
        result = result * 59 + ($kafkaConsumerGroups == null ? 43 : $kafkaConsumerGroups.hashCode());
        KafkaTopicCleanupPolicy $kafkaTopicCleanupPolicy = this.getKafkaTopicCleanupPolicy();
        result = result * 59 + ($kafkaTopicCleanupPolicy == null ? 43 : $kafkaTopicCleanupPolicy.hashCode());
        KafkaTopicCompressionType $kafkaTopicCompressionType = this.getKafkaTopicCompressionType();
        result = result * 59 + ($kafkaTopicCompressionType == null ? 43 : $kafkaTopicCompressionType.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "KafkaTopic(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", kafkaConsumerGroups=" + this.getKafkaConsumerGroups() + ", kafkaTopicCleanupPolicy=" + this.getKafkaTopicCleanupPolicy() + ", kafkaTopicCompressionType=" + this.getKafkaTopicCompressionType() + ", kafkaTopicIsInternal=" + this.getKafkaTopicIsInternal() + ", kafkaTopicPartitionsCount=" + this.getKafkaTopicPartitionsCount() + ", kafkaTopicRecordCount=" + this.getKafkaTopicRecordCount() + ", kafkaTopicReplicationFactor=" + this.getKafkaTopicReplicationFactor() + ", kafkaTopicSegmentBytes=" + this.getKafkaTopicSegmentBytes() + ", kafkaTopicSizeInBytes=" + this.getKafkaTopicSizeInBytes() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class KafkaTopicBuilderImpl
    extends KafkaTopicBuilder<KafkaTopic, KafkaTopicBuilderImpl> {
        @Generated
        private KafkaTopicBuilderImpl() {
        }

        @Override
        @Generated
        protected KafkaTopicBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public KafkaTopic build() {
            return new KafkaTopic(this);
        }
    }

    @Generated
    public static abstract class KafkaTopicBuilder<C extends KafkaTopic, B extends KafkaTopicBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<IKafkaConsumerGroup> kafkaConsumerGroups;
        @Generated
        private KafkaTopicCleanupPolicy kafkaTopicCleanupPolicy;
        @Generated
        private KafkaTopicCompressionType kafkaTopicCompressionType;
        @Generated
        private Boolean kafkaTopicIsInternal;
        @Generated
        private Long kafkaTopicPartitionsCount;
        @Generated
        private Long kafkaTopicRecordCount;
        @Generated
        private Long kafkaTopicReplicationFactor;
        @Generated
        private Long kafkaTopicSegmentBytes;
        @Generated
        private Long kafkaTopicSizeInBytes;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            KafkaTopicBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(KafkaTopic instance, KafkaTopicBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.kafkaConsumerGroups(instance.kafkaConsumerGroups == null ? Collections.emptySortedSet() : instance.kafkaConsumerGroups);
            b.kafkaTopicCleanupPolicy(instance.kafkaTopicCleanupPolicy);
            b.kafkaTopicCompressionType(instance.kafkaTopicCompressionType);
            b.kafkaTopicIsInternal(instance.kafkaTopicIsInternal);
            b.kafkaTopicPartitionsCount(instance.kafkaTopicPartitionsCount);
            b.kafkaTopicRecordCount(instance.kafkaTopicRecordCount);
            b.kafkaTopicReplicationFactor(instance.kafkaTopicReplicationFactor);
            b.kafkaTopicSegmentBytes(instance.kafkaTopicSegmentBytes);
            b.kafkaTopicSizeInBytes(instance.kafkaTopicSizeInBytes);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B kafkaConsumerGroup(IKafkaConsumerGroup kafkaConsumerGroup) {
            if (this.kafkaConsumerGroups == null) {
                this.kafkaConsumerGroups = new ArrayList();
            }
            this.kafkaConsumerGroups.add(kafkaConsumerGroup);
            return (B)this.self();
        }

        @Generated
        public B kafkaConsumerGroups(Collection<? extends IKafkaConsumerGroup> kafkaConsumerGroups) {
            if (kafkaConsumerGroups == null) {
                throw new NullPointerException("kafkaConsumerGroups cannot be null");
            }
            if (this.kafkaConsumerGroups == null) {
                this.kafkaConsumerGroups = new ArrayList();
            }
            this.kafkaConsumerGroups.addAll(kafkaConsumerGroups);
            return (B)this.self();
        }

        @Generated
        public B clearKafkaConsumerGroups() {
            if (this.kafkaConsumerGroups != null) {
                this.kafkaConsumerGroups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B kafkaTopicCleanupPolicy(KafkaTopicCleanupPolicy kafkaTopicCleanupPolicy) {
            this.kafkaTopicCleanupPolicy = kafkaTopicCleanupPolicy;
            return (B)this.self();
        }

        @Generated
        public B kafkaTopicCompressionType(KafkaTopicCompressionType kafkaTopicCompressionType) {
            this.kafkaTopicCompressionType = kafkaTopicCompressionType;
            return (B)this.self();
        }

        @Generated
        public B kafkaTopicIsInternal(Boolean kafkaTopicIsInternal) {
            this.kafkaTopicIsInternal = kafkaTopicIsInternal;
            return (B)this.self();
        }

        @Generated
        public B kafkaTopicPartitionsCount(Long kafkaTopicPartitionsCount) {
            this.kafkaTopicPartitionsCount = kafkaTopicPartitionsCount;
            return (B)this.self();
        }

        @Generated
        public B kafkaTopicRecordCount(Long kafkaTopicRecordCount) {
            this.kafkaTopicRecordCount = kafkaTopicRecordCount;
            return (B)this.self();
        }

        @Generated
        public B kafkaTopicReplicationFactor(Long kafkaTopicReplicationFactor) {
            this.kafkaTopicReplicationFactor = kafkaTopicReplicationFactor;
            return (B)this.self();
        }

        @Generated
        public B kafkaTopicSegmentBytes(Long kafkaTopicSegmentBytes) {
            this.kafkaTopicSegmentBytes = kafkaTopicSegmentBytes;
            return (B)this.self();
        }

        @Generated
        public B kafkaTopicSizeInBytes(Long kafkaTopicSizeInBytes) {
            this.kafkaTopicSizeInBytes = kafkaTopicSizeInBytes;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "KafkaTopic.KafkaTopicBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", kafkaConsumerGroups=" + this.kafkaConsumerGroups + ", kafkaTopicCleanupPolicy=" + this.kafkaTopicCleanupPolicy + ", kafkaTopicCompressionType=" + this.kafkaTopicCompressionType + ", kafkaTopicIsInternal=" + this.kafkaTopicIsInternal + ", kafkaTopicPartitionsCount=" + this.kafkaTopicPartitionsCount + ", kafkaTopicRecordCount=" + this.kafkaTopicRecordCount + ", kafkaTopicReplicationFactor=" + this.kafkaTopicReplicationFactor + ", kafkaTopicSegmentBytes=" + this.kafkaTopicSegmentBytes + ", kafkaTopicSizeInBytes=" + this.kafkaTopicSizeInBytes + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ")";
        }
    }
}

