/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.ILooker;
import com.atlan.model.assets.ILookerExplore;
import com.atlan.model.assets.ILookerField;
import com.atlan.model.assets.ILookerModel;
import com.atlan.model.assets.ILookerProject;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookerExplore
extends Asset
implements ILookerExplore,
ILooker,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LookerExplore.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerExplore";
    String typeName;
    @Attribute
    SortedSet<ILookerField> fields;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    ILookerModel model;
    @Attribute
    String modelName;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    ILookerProject project;
    @Attribute
    String projectName;
    @Attribute
    String sourceConnectionName;
    @Attribute
    String sqlTableName;
    @Attribute
    String viewName;

    @Override
    public LookerExplore trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return LookerExplore.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return LookerExplore.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return LookerExplore.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return LookerExplore.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return LookerExplore.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return LookerExplore.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return LookerExplore.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return LookerExplore.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return LookerExplore.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static LookerExplore refByGuid(String guid) {
        return ((LookerExploreBuilder)LookerExplore._internal().guid(guid)).build();
    }

    public static LookerExplore refByQualifiedName(String qualifiedName) {
        return ((LookerExploreBuilder)LookerExplore._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static LookerExplore get(String id) throws AtlanException {
        return LookerExplore.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static LookerExplore get(AtlanClient client, String id) throws AtlanException {
        return LookerExplore.get(client, id, true);
    }

    @JsonIgnore
    public static LookerExplore get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof LookerExplore) {
                return (LookerExplore)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof LookerExplore) {
            return (LookerExplore)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static LookerExplore retrieveByGuid(String guid) throws AtlanException {
        return LookerExplore.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static LookerExplore retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return LookerExplore.get(client, guid);
    }

    @Deprecated
    public static LookerExplore retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return LookerExplore.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static LookerExplore retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return LookerExplore.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return LookerExplore.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static LookerExploreBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerExploreBuilder)((LookerExploreBuilder)((LookerExploreBuilder)LookerExplore._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public LookerExploreBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return LookerExplore.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerExplore removeDescription(String qualifiedName, String name) throws AtlanException {
        return LookerExplore.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerExplore removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerExplore)Asset.removeDescription(client, LookerExplore.updater(qualifiedName, name));
    }

    public static LookerExplore removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return LookerExplore.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerExplore removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerExplore)Asset.removeUserDescription(client, LookerExplore.updater(qualifiedName, name));
    }

    public static LookerExplore removeOwners(String qualifiedName, String name) throws AtlanException {
        return LookerExplore.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerExplore removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerExplore)Asset.removeOwners(client, LookerExplore.updater(qualifiedName, name));
    }

    public static LookerExplore updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return LookerExplore.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static LookerExplore updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LookerExplore)Asset.updateCertificate(client, LookerExplore._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerExplore removeCertificate(String qualifiedName, String name) throws AtlanException {
        return LookerExplore.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerExplore removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerExplore)Asset.removeCertificate(client, LookerExplore.updater(qualifiedName, name));
    }

    public static LookerExplore updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return LookerExplore.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static LookerExplore updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerExplore)Asset.updateAnnouncement(client, LookerExplore._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerExplore removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return LookerExplore.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerExplore removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerExplore)Asset.removeAnnouncement(client, LookerExplore.updater(qualifiedName, name));
    }

    public static LookerExplore replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return LookerExplore.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static LookerExplore replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerExplore)Asset.replaceTerms(client, LookerExplore.updater(qualifiedName, name), terms);
    }

    public static LookerExplore appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return LookerExplore.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static LookerExplore appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerExplore)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static LookerExplore removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return LookerExplore.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static LookerExplore removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerExplore)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static LookerExplore appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return LookerExplore.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static LookerExplore appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LookerExplore)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static LookerExplore appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return LookerExplore.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static LookerExplore appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LookerExplore)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        LookerExplore.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        LookerExplore.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        LookerExplore.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerExplore(LookerExploreBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerExplore.$default$typeName();
        SortedSet<ILookerField> fields = new TreeSet<ILookerField>();
        if (b.fields != null) {
            fields.addAll(b.fields);
        }
        fields = Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        this.model = b.model;
        this.modelName = b.modelName;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        this.project = b.project;
        this.projectName = b.projectName;
        this.sourceConnectionName = b.sourceConnectionName;
        this.sqlTableName = b.sqlTableName;
        this.viewName = b.viewName;
    }

    @Generated
    public static LookerExploreBuilder<?, ?> _internal() {
        return new LookerExploreBuilderImpl();
    }

    @Generated
    public LookerExploreBuilder<?, ?> toBuilder() {
        return new LookerExploreBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<ILookerField> getFields() {
        return this.fields;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public ILookerModel getModel() {
        return this.model;
    }

    @Override
    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public ILookerProject getProject() {
        return this.project;
    }

    @Override
    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    @Generated
    public String getSourceConnectionName() {
        return this.sourceConnectionName;
    }

    @Override
    @Generated
    public String getSqlTableName() {
        return this.sqlTableName;
    }

    @Override
    @Generated
    public String getViewName() {
        return this.viewName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerExplore)) {
            return false;
        }
        LookerExplore other = (LookerExplore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<ILookerField> this$fields = this.getFields();
        SortedSet<ILookerField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        ILookerModel this$model = this.getModel();
        ILookerModel other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        ILookerProject this$project = this.getProject();
        ILookerProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$sourceConnectionName = this.getSourceConnectionName();
        String other$sourceConnectionName = other.getSourceConnectionName();
        if (this$sourceConnectionName == null ? other$sourceConnectionName != null : !this$sourceConnectionName.equals(other$sourceConnectionName)) {
            return false;
        }
        String this$sqlTableName = this.getSqlTableName();
        String other$sqlTableName = other.getSqlTableName();
        if (this$sqlTableName == null ? other$sqlTableName != null : !this$sqlTableName.equals(other$sqlTableName)) {
            return false;
        }
        String this$viewName = this.getViewName();
        String other$viewName = other.getViewName();
        return !(this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerExplore;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<ILookerField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        ILookerModel $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        ILookerProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $sourceConnectionName = this.getSourceConnectionName();
        result = result * 59 + ($sourceConnectionName == null ? 43 : $sourceConnectionName.hashCode());
        String $sqlTableName = this.getSqlTableName();
        result = result * 59 + ($sqlTableName == null ? 43 : $sqlTableName.hashCode());
        String $viewName = this.getViewName();
        result = result * 59 + ($viewName == null ? 43 : $viewName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LookerExplore(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", fields=" + this.getFields() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", model=" + this.getModel() + ", modelName=" + this.getModelName() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", project=" + this.getProject() + ", projectName=" + this.getProjectName() + ", sourceConnectionName=" + this.getSourceConnectionName() + ", sqlTableName=" + this.getSqlTableName() + ", viewName=" + this.getViewName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class LookerExploreBuilderImpl
    extends LookerExploreBuilder<LookerExplore, LookerExploreBuilderImpl> {
        @Generated
        private LookerExploreBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerExploreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerExplore build() {
            return new LookerExplore(this);
        }
    }

    @Generated
    public static abstract class LookerExploreBuilder<C extends LookerExplore, B extends LookerExploreBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<ILookerField> fields;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ILookerModel model;
        @Generated
        private String modelName;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ILookerProject project;
        @Generated
        private String projectName;
        @Generated
        private String sourceConnectionName;
        @Generated
        private String sqlTableName;
        @Generated
        private String viewName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerExploreBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerExplore instance, LookerExploreBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.fields(instance.fields == null ? Collections.emptySortedSet() : instance.fields);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.model(instance.model);
            b.modelName(instance.modelName);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.project(instance.project);
            b.projectName(instance.projectName);
            b.sourceConnectionName(instance.sourceConnectionName);
            b.sqlTableName(instance.sqlTableName);
            b.viewName(instance.viewName);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B field(ILookerField field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return (B)this.self();
        }

        @Generated
        public B fields(Collection<? extends ILookerField> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return (B)this.self();
        }

        @Generated
        public B clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B model(ILookerModel model) {
            this.model = model;
            return (B)this.self();
        }

        @Generated
        public B modelName(String modelName) {
            this.modelName = modelName;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B project(ILookerProject project) {
            this.project = project;
            return (B)this.self();
        }

        @Generated
        public B projectName(String projectName) {
            this.projectName = projectName;
            return (B)this.self();
        }

        @Generated
        public B sourceConnectionName(String sourceConnectionName) {
            this.sourceConnectionName = sourceConnectionName;
            return (B)this.self();
        }

        @Generated
        public B sqlTableName(String sqlTableName) {
            this.sqlTableName = sqlTableName;
            return (B)this.self();
        }

        @Generated
        public B viewName(String viewName) {
            this.viewName = viewName;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LookerExplore.LookerExploreBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", fields=" + this.fields + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", model=" + this.model + ", modelName=" + this.modelName + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", project=" + this.project + ", projectName=" + this.projectName + ", sourceConnectionName=" + this.sourceConnectionName + ", sqlTableName=" + this.sqlTableName + ", viewName=" + this.viewName + ")";
        }
    }
}

