/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.ILooker;
import com.atlan.model.assets.ILookerExplore;
import com.atlan.model.assets.ILookerField;
import com.atlan.model.assets.ILookerModel;
import com.atlan.model.assets.ILookerProject;
import com.atlan.model.assets.ILookerView;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookerField
extends Asset
implements ILookerField,
ILooker,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LookerField.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerField";
    String typeName;
    @Attribute
    ILookerExplore explore;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    String lookerExploreQualifiedName;
    @Attribute
    String lookerFieldDataType;
    @Attribute
    Integer lookerTimesUsed;
    @Attribute
    String lookerViewQualifiedName;
    @Attribute
    ILookerModel model;
    @Attribute
    String modelName;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    ILookerProject project;
    @Attribute
    String projectName;
    @Attribute
    String sourceDefinition;
    @Attribute
    ILookerView view;

    @Override
    public LookerField trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return LookerField.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return LookerField.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return LookerField.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return LookerField.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return LookerField.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return LookerField.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return LookerField.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return LookerField.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return LookerField.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static LookerField refByGuid(String guid) {
        return ((LookerFieldBuilder)LookerField._internal().guid(guid)).build();
    }

    public static LookerField refByQualifiedName(String qualifiedName) {
        return ((LookerFieldBuilder)LookerField._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static LookerField get(String id) throws AtlanException {
        return LookerField.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static LookerField get(AtlanClient client, String id) throws AtlanException {
        return LookerField.get(client, id, true);
    }

    @JsonIgnore
    public static LookerField get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof LookerField) {
                return (LookerField)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof LookerField) {
            return (LookerField)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static LookerField retrieveByGuid(String guid) throws AtlanException {
        return LookerField.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static LookerField retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return LookerField.get(client, guid);
    }

    @Deprecated
    public static LookerField retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return LookerField.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static LookerField retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return LookerField.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return LookerField.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static LookerFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerFieldBuilder)((LookerFieldBuilder)((LookerFieldBuilder)LookerField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public LookerFieldBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return LookerField.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerField removeDescription(String qualifiedName, String name) throws AtlanException {
        return LookerField.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerField removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerField)Asset.removeDescription(client, LookerField.updater(qualifiedName, name));
    }

    public static LookerField removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return LookerField.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerField removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerField)Asset.removeUserDescription(client, LookerField.updater(qualifiedName, name));
    }

    public static LookerField removeOwners(String qualifiedName, String name) throws AtlanException {
        return LookerField.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerField removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerField)Asset.removeOwners(client, LookerField.updater(qualifiedName, name));
    }

    public static LookerField updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return LookerField.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static LookerField updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LookerField)Asset.updateCertificate(client, LookerField._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerField removeCertificate(String qualifiedName, String name) throws AtlanException {
        return LookerField.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerField removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerField)Asset.removeCertificate(client, LookerField.updater(qualifiedName, name));
    }

    public static LookerField updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return LookerField.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static LookerField updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerField)Asset.updateAnnouncement(client, LookerField._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerField removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return LookerField.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerField removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerField)Asset.removeAnnouncement(client, LookerField.updater(qualifiedName, name));
    }

    public static LookerField replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return LookerField.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static LookerField replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerField)Asset.replaceTerms(client, LookerField.updater(qualifiedName, name), terms);
    }

    public static LookerField appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return LookerField.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static LookerField appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerField)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static LookerField removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return LookerField.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static LookerField removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerField)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static LookerField appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return LookerField.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static LookerField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LookerField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static LookerField appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return LookerField.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static LookerField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LookerField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        LookerField.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        LookerField.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        LookerField.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerField(LookerFieldBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerField.$default$typeName();
        this.explore = b.explore;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        this.lookerExploreQualifiedName = b.lookerExploreQualifiedName;
        this.lookerFieldDataType = b.lookerFieldDataType;
        this.lookerTimesUsed = b.lookerTimesUsed;
        this.lookerViewQualifiedName = b.lookerViewQualifiedName;
        this.model = b.model;
        this.modelName = b.modelName;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        this.project = b.project;
        this.projectName = b.projectName;
        this.sourceDefinition = b.sourceDefinition;
        this.view = b.view;
    }

    @Generated
    public static LookerFieldBuilder<?, ?> _internal() {
        return new LookerFieldBuilderImpl();
    }

    @Generated
    public LookerFieldBuilder<?, ?> toBuilder() {
        return new LookerFieldBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public ILookerExplore getExplore() {
        return this.explore;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public String getLookerExploreQualifiedName() {
        return this.lookerExploreQualifiedName;
    }

    @Override
    @Generated
    public String getLookerFieldDataType() {
        return this.lookerFieldDataType;
    }

    @Override
    @Generated
    public Integer getLookerTimesUsed() {
        return this.lookerTimesUsed;
    }

    @Override
    @Generated
    public String getLookerViewQualifiedName() {
        return this.lookerViewQualifiedName;
    }

    @Override
    @Generated
    public ILookerModel getModel() {
        return this.model;
    }

    @Override
    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public ILookerProject getProject() {
        return this.project;
    }

    @Override
    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    @Generated
    public String getSourceDefinition() {
        return this.sourceDefinition;
    }

    @Override
    @Generated
    public ILookerView getView() {
        return this.view;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerField)) {
            return false;
        }
        LookerField other = (LookerField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$lookerTimesUsed = this.getLookerTimesUsed();
        Integer other$lookerTimesUsed = other.getLookerTimesUsed();
        if (this$lookerTimesUsed == null ? other$lookerTimesUsed != null : !((Object)this$lookerTimesUsed).equals(other$lookerTimesUsed)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        ILookerExplore this$explore = this.getExplore();
        ILookerExplore other$explore = other.getExplore();
        if (this$explore == null ? other$explore != null : !this$explore.equals(other$explore)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        String this$lookerExploreQualifiedName = this.getLookerExploreQualifiedName();
        String other$lookerExploreQualifiedName = other.getLookerExploreQualifiedName();
        if (this$lookerExploreQualifiedName == null ? other$lookerExploreQualifiedName != null : !this$lookerExploreQualifiedName.equals(other$lookerExploreQualifiedName)) {
            return false;
        }
        String this$lookerFieldDataType = this.getLookerFieldDataType();
        String other$lookerFieldDataType = other.getLookerFieldDataType();
        if (this$lookerFieldDataType == null ? other$lookerFieldDataType != null : !this$lookerFieldDataType.equals(other$lookerFieldDataType)) {
            return false;
        }
        String this$lookerViewQualifiedName = this.getLookerViewQualifiedName();
        String other$lookerViewQualifiedName = other.getLookerViewQualifiedName();
        if (this$lookerViewQualifiedName == null ? other$lookerViewQualifiedName != null : !this$lookerViewQualifiedName.equals(other$lookerViewQualifiedName)) {
            return false;
        }
        ILookerModel this$model = this.getModel();
        ILookerModel other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        ILookerProject this$project = this.getProject();
        ILookerProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$sourceDefinition = this.getSourceDefinition();
        String other$sourceDefinition = other.getSourceDefinition();
        if (this$sourceDefinition == null ? other$sourceDefinition != null : !this$sourceDefinition.equals(other$sourceDefinition)) {
            return false;
        }
        ILookerView this$view = this.getView();
        ILookerView other$view = other.getView();
        return !(this$view == null ? other$view != null : !this$view.equals(other$view));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $lookerTimesUsed = this.getLookerTimesUsed();
        result = result * 59 + ($lookerTimesUsed == null ? 43 : ((Object)$lookerTimesUsed).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        ILookerExplore $explore = this.getExplore();
        result = result * 59 + ($explore == null ? 43 : $explore.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        String $lookerExploreQualifiedName = this.getLookerExploreQualifiedName();
        result = result * 59 + ($lookerExploreQualifiedName == null ? 43 : $lookerExploreQualifiedName.hashCode());
        String $lookerFieldDataType = this.getLookerFieldDataType();
        result = result * 59 + ($lookerFieldDataType == null ? 43 : $lookerFieldDataType.hashCode());
        String $lookerViewQualifiedName = this.getLookerViewQualifiedName();
        result = result * 59 + ($lookerViewQualifiedName == null ? 43 : $lookerViewQualifiedName.hashCode());
        ILookerModel $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        ILookerProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $sourceDefinition = this.getSourceDefinition();
        result = result * 59 + ($sourceDefinition == null ? 43 : $sourceDefinition.hashCode());
        ILookerView $view = this.getView();
        result = result * 59 + ($view == null ? 43 : $view.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LookerField(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", explore=" + this.getExplore() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", lookerExploreQualifiedName=" + this.getLookerExploreQualifiedName() + ", lookerFieldDataType=" + this.getLookerFieldDataType() + ", lookerTimesUsed=" + this.getLookerTimesUsed() + ", lookerViewQualifiedName=" + this.getLookerViewQualifiedName() + ", model=" + this.getModel() + ", modelName=" + this.getModelName() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", project=" + this.getProject() + ", projectName=" + this.getProjectName() + ", sourceDefinition=" + this.getSourceDefinition() + ", view=" + this.getView() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class LookerFieldBuilderImpl
    extends LookerFieldBuilder<LookerField, LookerFieldBuilderImpl> {
        @Generated
        private LookerFieldBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerFieldBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerField build() {
            return new LookerField(this);
        }
    }

    @Generated
    public static abstract class LookerFieldBuilder<C extends LookerField, B extends LookerFieldBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ILookerExplore explore;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private String lookerExploreQualifiedName;
        @Generated
        private String lookerFieldDataType;
        @Generated
        private Integer lookerTimesUsed;
        @Generated
        private String lookerViewQualifiedName;
        @Generated
        private ILookerModel model;
        @Generated
        private String modelName;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ILookerProject project;
        @Generated
        private String projectName;
        @Generated
        private String sourceDefinition;
        @Generated
        private ILookerView view;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerField instance, LookerFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.explore(instance.explore);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.lookerExploreQualifiedName(instance.lookerExploreQualifiedName);
            b.lookerFieldDataType(instance.lookerFieldDataType);
            b.lookerTimesUsed(instance.lookerTimesUsed);
            b.lookerViewQualifiedName(instance.lookerViewQualifiedName);
            b.model(instance.model);
            b.modelName(instance.modelName);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.project(instance.project);
            b.projectName(instance.projectName);
            b.sourceDefinition(instance.sourceDefinition);
            b.view(instance.view);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B explore(ILookerExplore explore) {
            this.explore = explore;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B lookerExploreQualifiedName(String lookerExploreQualifiedName) {
            this.lookerExploreQualifiedName = lookerExploreQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B lookerFieldDataType(String lookerFieldDataType) {
            this.lookerFieldDataType = lookerFieldDataType;
            return (B)this.self();
        }

        @Generated
        public B lookerTimesUsed(Integer lookerTimesUsed) {
            this.lookerTimesUsed = lookerTimesUsed;
            return (B)this.self();
        }

        @Generated
        public B lookerViewQualifiedName(String lookerViewQualifiedName) {
            this.lookerViewQualifiedName = lookerViewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B model(ILookerModel model) {
            this.model = model;
            return (B)this.self();
        }

        @Generated
        public B modelName(String modelName) {
            this.modelName = modelName;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B project(ILookerProject project) {
            this.project = project;
            return (B)this.self();
        }

        @Generated
        public B projectName(String projectName) {
            this.projectName = projectName;
            return (B)this.self();
        }

        @Generated
        public B sourceDefinition(String sourceDefinition) {
            this.sourceDefinition = sourceDefinition;
            return (B)this.self();
        }

        @Generated
        public B view(ILookerView view) {
            this.view = view;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LookerField.LookerFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", explore=" + this.explore + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", lookerExploreQualifiedName=" + this.lookerExploreQualifiedName + ", lookerFieldDataType=" + this.lookerFieldDataType + ", lookerTimesUsed=" + this.lookerTimesUsed + ", lookerViewQualifiedName=" + this.lookerViewQualifiedName + ", model=" + this.model + ", modelName=" + this.modelName + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", project=" + this.project + ", projectName=" + this.projectName + ", sourceDefinition=" + this.sourceDefinition + ", view=" + this.view + ")";
        }
    }
}

