/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.ILooker;
import com.atlan.model.assets.ILookerDashboard;
import com.atlan.model.assets.ILookerFolder;
import com.atlan.model.assets.ILookerLook;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookerFolder
extends Asset
implements ILookerFolder,
ILooker,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LookerFolder.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerFolder";
    String typeName;
    @Attribute
    SortedSet<ILookerDashboard> dashboards;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ILookerLook> looks;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    Integer sourceChildCount;
    @Attribute
    Integer sourceContentMetadataId;
    @Attribute
    Integer sourceCreatorId;
    @Attribute
    Integer sourceParentID;

    @Override
    public LookerFolder trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return LookerFolder.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return LookerFolder.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return LookerFolder.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return LookerFolder.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return LookerFolder.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return LookerFolder.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return LookerFolder.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return LookerFolder.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return LookerFolder.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static LookerFolder refByGuid(String guid) {
        return ((LookerFolderBuilder)LookerFolder._internal().guid(guid)).build();
    }

    public static LookerFolder refByQualifiedName(String qualifiedName) {
        return ((LookerFolderBuilder)LookerFolder._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static LookerFolder get(String id) throws AtlanException {
        return LookerFolder.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static LookerFolder get(AtlanClient client, String id) throws AtlanException {
        return LookerFolder.get(client, id, true);
    }

    @JsonIgnore
    public static LookerFolder get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof LookerFolder) {
                return (LookerFolder)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof LookerFolder) {
            return (LookerFolder)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static LookerFolder retrieveByGuid(String guid) throws AtlanException {
        return LookerFolder.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static LookerFolder retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return LookerFolder.get(client, guid);
    }

    @Deprecated
    public static LookerFolder retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return LookerFolder.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static LookerFolder retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return LookerFolder.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return LookerFolder.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static LookerFolderBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerFolderBuilder)((LookerFolderBuilder)((LookerFolderBuilder)LookerFolder._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public LookerFolderBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return LookerFolder.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerFolder removeDescription(String qualifiedName, String name) throws AtlanException {
        return LookerFolder.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerFolder removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerFolder)Asset.removeDescription(client, LookerFolder.updater(qualifiedName, name));
    }

    public static LookerFolder removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return LookerFolder.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerFolder removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerFolder)Asset.removeUserDescription(client, LookerFolder.updater(qualifiedName, name));
    }

    public static LookerFolder removeOwners(String qualifiedName, String name) throws AtlanException {
        return LookerFolder.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerFolder removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerFolder)Asset.removeOwners(client, LookerFolder.updater(qualifiedName, name));
    }

    public static LookerFolder updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return LookerFolder.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static LookerFolder updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LookerFolder)Asset.updateCertificate(client, LookerFolder._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerFolder removeCertificate(String qualifiedName, String name) throws AtlanException {
        return LookerFolder.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerFolder removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerFolder)Asset.removeCertificate(client, LookerFolder.updater(qualifiedName, name));
    }

    public static LookerFolder updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return LookerFolder.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static LookerFolder updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerFolder)Asset.updateAnnouncement(client, LookerFolder._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerFolder removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return LookerFolder.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerFolder removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerFolder)Asset.removeAnnouncement(client, LookerFolder.updater(qualifiedName, name));
    }

    public static LookerFolder replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return LookerFolder.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static LookerFolder replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerFolder)Asset.replaceTerms(client, LookerFolder.updater(qualifiedName, name), terms);
    }

    public static LookerFolder appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return LookerFolder.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static LookerFolder appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerFolder)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static LookerFolder removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return LookerFolder.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static LookerFolder removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerFolder)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static LookerFolder appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return LookerFolder.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static LookerFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LookerFolder)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static LookerFolder appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return LookerFolder.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static LookerFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LookerFolder)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        LookerFolder.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        LookerFolder.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        LookerFolder.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerFolder(LookerFolderBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerFolder.$default$typeName();
        SortedSet<ILookerDashboard> dashboards = new TreeSet<ILookerDashboard>();
        if (b.dashboards != null) {
            dashboards.addAll(b.dashboards);
        }
        dashboards = Collections.unmodifiableSortedSet(dashboards);
        this.dashboards = dashboards;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ILookerLook> looks = new TreeSet<ILookerLook>();
        if (b.looks != null) {
            looks.addAll(b.looks);
        }
        looks = Collections.unmodifiableSortedSet(looks);
        this.looks = looks;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        this.sourceChildCount = b.sourceChildCount;
        this.sourceContentMetadataId = b.sourceContentMetadataId;
        this.sourceCreatorId = b.sourceCreatorId;
        this.sourceParentID = b.sourceParentID;
    }

    @Generated
    public static LookerFolderBuilder<?, ?> _internal() {
        return new LookerFolderBuilderImpl();
    }

    @Generated
    public LookerFolderBuilder<?, ?> toBuilder() {
        return new LookerFolderBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<ILookerDashboard> getDashboards() {
        return this.dashboards;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ILookerLook> getLooks() {
        return this.looks;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public Integer getSourceChildCount() {
        return this.sourceChildCount;
    }

    @Override
    @Generated
    public Integer getSourceContentMetadataId() {
        return this.sourceContentMetadataId;
    }

    @Override
    @Generated
    public Integer getSourceCreatorId() {
        return this.sourceCreatorId;
    }

    @Override
    @Generated
    public Integer getSourceParentID() {
        return this.sourceParentID;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerFolder)) {
            return false;
        }
        LookerFolder other = (LookerFolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$sourceChildCount = this.getSourceChildCount();
        Integer other$sourceChildCount = other.getSourceChildCount();
        if (this$sourceChildCount == null ? other$sourceChildCount != null : !((Object)this$sourceChildCount).equals(other$sourceChildCount)) {
            return false;
        }
        Integer this$sourceContentMetadataId = this.getSourceContentMetadataId();
        Integer other$sourceContentMetadataId = other.getSourceContentMetadataId();
        if (this$sourceContentMetadataId == null ? other$sourceContentMetadataId != null : !((Object)this$sourceContentMetadataId).equals(other$sourceContentMetadataId)) {
            return false;
        }
        Integer this$sourceCreatorId = this.getSourceCreatorId();
        Integer other$sourceCreatorId = other.getSourceCreatorId();
        if (this$sourceCreatorId == null ? other$sourceCreatorId != null : !((Object)this$sourceCreatorId).equals(other$sourceCreatorId)) {
            return false;
        }
        Integer this$sourceParentID = this.getSourceParentID();
        Integer other$sourceParentID = other.getSourceParentID();
        if (this$sourceParentID == null ? other$sourceParentID != null : !((Object)this$sourceParentID).equals(other$sourceParentID)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<ILookerDashboard> this$dashboards = this.getDashboards();
        SortedSet<ILookerDashboard> other$dashboards = other.getDashboards();
        if (this$dashboards == null ? other$dashboards != null : !this$dashboards.equals(other$dashboards)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ILookerLook> this$looks = this.getLooks();
        SortedSet<ILookerLook> other$looks = other.getLooks();
        if (this$looks == null ? other$looks != null : !this$looks.equals(other$looks)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerFolder;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $sourceChildCount = this.getSourceChildCount();
        result = result * 59 + ($sourceChildCount == null ? 43 : ((Object)$sourceChildCount).hashCode());
        Integer $sourceContentMetadataId = this.getSourceContentMetadataId();
        result = result * 59 + ($sourceContentMetadataId == null ? 43 : ((Object)$sourceContentMetadataId).hashCode());
        Integer $sourceCreatorId = this.getSourceCreatorId();
        result = result * 59 + ($sourceCreatorId == null ? 43 : ((Object)$sourceCreatorId).hashCode());
        Integer $sourceParentID = this.getSourceParentID();
        result = result * 59 + ($sourceParentID == null ? 43 : ((Object)$sourceParentID).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<ILookerDashboard> $dashboards = this.getDashboards();
        result = result * 59 + ($dashboards == null ? 43 : $dashboards.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ILookerLook> $looks = this.getLooks();
        result = result * 59 + ($looks == null ? 43 : $looks.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LookerFolder(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dashboards=" + this.getDashboards() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", looks=" + this.getLooks() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", sourceChildCount=" + this.getSourceChildCount() + ", sourceContentMetadataId=" + this.getSourceContentMetadataId() + ", sourceCreatorId=" + this.getSourceCreatorId() + ", sourceParentID=" + this.getSourceParentID() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class LookerFolderBuilderImpl
    extends LookerFolderBuilder<LookerFolder, LookerFolderBuilderImpl> {
        @Generated
        private LookerFolderBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerFolderBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerFolder build() {
            return new LookerFolder(this);
        }
    }

    @Generated
    public static abstract class LookerFolderBuilder<C extends LookerFolder, B extends LookerFolderBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<ILookerDashboard> dashboards;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ILookerLook> looks;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private Integer sourceChildCount;
        @Generated
        private Integer sourceContentMetadataId;
        @Generated
        private Integer sourceCreatorId;
        @Generated
        private Integer sourceParentID;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerFolderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerFolder instance, LookerFolderBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dashboards(instance.dashboards == null ? Collections.emptySortedSet() : instance.dashboards);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.looks(instance.looks == null ? Collections.emptySortedSet() : instance.looks);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.sourceChildCount(instance.sourceChildCount);
            b.sourceContentMetadataId(instance.sourceContentMetadataId);
            b.sourceCreatorId(instance.sourceCreatorId);
            b.sourceParentID(instance.sourceParentID);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dashboard(ILookerDashboard dashboard) {
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.add(dashboard);
            return (B)this.self();
        }

        @Generated
        public B dashboards(Collection<? extends ILookerDashboard> dashboards) {
            if (dashboards == null) {
                throw new NullPointerException("dashboards cannot be null");
            }
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.addAll(dashboards);
            return (B)this.self();
        }

        @Generated
        public B clearDashboards() {
            if (this.dashboards != null) {
                this.dashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B look(ILookerLook look) {
            if (this.looks == null) {
                this.looks = new ArrayList();
            }
            this.looks.add(look);
            return (B)this.self();
        }

        @Generated
        public B looks(Collection<? extends ILookerLook> looks) {
            if (looks == null) {
                throw new NullPointerException("looks cannot be null");
            }
            if (this.looks == null) {
                this.looks = new ArrayList();
            }
            this.looks.addAll(looks);
            return (B)this.self();
        }

        @Generated
        public B clearLooks() {
            if (this.looks != null) {
                this.looks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sourceChildCount(Integer sourceChildCount) {
            this.sourceChildCount = sourceChildCount;
            return (B)this.self();
        }

        @Generated
        public B sourceContentMetadataId(Integer sourceContentMetadataId) {
            this.sourceContentMetadataId = sourceContentMetadataId;
            return (B)this.self();
        }

        @Generated
        public B sourceCreatorId(Integer sourceCreatorId) {
            this.sourceCreatorId = sourceCreatorId;
            return (B)this.self();
        }

        @Generated
        public B sourceParentID(Integer sourceParentID) {
            this.sourceParentID = sourceParentID;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LookerFolder.LookerFolderBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dashboards=" + this.dashboards + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", looks=" + this.looks + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", sourceChildCount=" + this.sourceChildCount + ", sourceContentMetadataId=" + this.sourceContentMetadataId + ", sourceCreatorId=" + this.sourceCreatorId + ", sourceParentID=" + this.sourceParentID + ")";
        }
    }
}

