/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDataQuality;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMCMonitor;
import com.atlan.model.assets.IMonteCarlo;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.MCRuleComparison;
import com.atlan.model.structs.MCRuleSchedule;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCMonitor
extends Asset
implements IMCMonitor,
IMonteCarlo,
IDataQuality,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MCMonitor.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MCMonitor";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<String> mcAssetQualifiedNames;
    @Attribute
    SortedSet<String> mcLabels;
    @Attribute
    String mcMonitorAlertCondition;
    @Attribute
    SortedSet<IAsset> mcMonitorAssets;
    @Attribute
    Double mcMonitorBreachRate;
    @Attribute
    String mcMonitorId;
    @Attribute
    Long mcMonitorIncidentCount;
    @Attribute
    String mcMonitorNamespace;
    @Attribute
    List<MCRuleComparison> mcMonitorRuleComparisons;
    @Attribute
    String mcMonitorRuleCustomSql;
    @Attribute
    Boolean mcMonitorRuleIsSnoozed;
    @Attribute
    Long mcMonitorRuleNextExecutionTime;
    @Attribute
    Long mcMonitorRulePreviousExecutionTime;
    @Attribute
    List<MCRuleSchedule> mcMonitorRuleScheduleConfig;
    @Attribute
    String mcMonitorRuleScheduleConfigHumanized;
    @Attribute
    String mcMonitorRuleType;
    @Attribute
    String mcMonitorScheduleType;
    @Attribute
    String mcMonitorStatus;
    @Attribute
    String mcMonitorType;
    @Attribute
    String mcMonitorWarehouse;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;

    @Override
    public MCMonitor trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return MCMonitor.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return MCMonitor.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return MCMonitor.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return MCMonitor.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return MCMonitor.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return MCMonitor.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return MCMonitor.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return MCMonitor.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return MCMonitor.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static MCMonitor refByGuid(String guid) {
        return ((MCMonitorBuilder)MCMonitor._internal().guid(guid)).build();
    }

    public static MCMonitor refByQualifiedName(String qualifiedName) {
        return ((MCMonitorBuilder)MCMonitor._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static MCMonitor get(String id) throws AtlanException {
        return MCMonitor.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static MCMonitor get(AtlanClient client, String id) throws AtlanException {
        return MCMonitor.get(client, id, true);
    }

    @JsonIgnore
    public static MCMonitor get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof MCMonitor) {
                return (MCMonitor)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof MCMonitor) {
            return (MCMonitor)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static MCMonitor retrieveByGuid(String guid) throws AtlanException {
        return MCMonitor.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static MCMonitor retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return MCMonitor.get(client, guid);
    }

    @Deprecated
    public static MCMonitor retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return MCMonitor.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static MCMonitor retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return MCMonitor.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return MCMonitor.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static MCMonitorBuilder<?, ?> updater(String qualifiedName, String name) {
        return (MCMonitorBuilder)((MCMonitorBuilder)((MCMonitorBuilder)MCMonitor._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public MCMonitorBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return MCMonitor.updater(this.getQualifiedName(), this.getName());
    }

    public static MCMonitor removeDescription(String qualifiedName, String name) throws AtlanException {
        return MCMonitor.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MCMonitor removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCMonitor)Asset.removeDescription(client, MCMonitor.updater(qualifiedName, name));
    }

    public static MCMonitor removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return MCMonitor.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MCMonitor removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCMonitor)Asset.removeUserDescription(client, MCMonitor.updater(qualifiedName, name));
    }

    public static MCMonitor removeOwners(String qualifiedName, String name) throws AtlanException {
        return MCMonitor.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MCMonitor removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCMonitor)Asset.removeOwners(client, MCMonitor.updater(qualifiedName, name));
    }

    public static MCMonitor updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return MCMonitor.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static MCMonitor updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MCMonitor)Asset.updateCertificate(client, MCMonitor._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static MCMonitor removeCertificate(String qualifiedName, String name) throws AtlanException {
        return MCMonitor.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MCMonitor removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCMonitor)Asset.removeCertificate(client, MCMonitor.updater(qualifiedName, name));
    }

    public static MCMonitor updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return MCMonitor.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static MCMonitor updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MCMonitor)Asset.updateAnnouncement(client, MCMonitor._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static MCMonitor removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return MCMonitor.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MCMonitor removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCMonitor)Asset.removeAnnouncement(client, MCMonitor.updater(qualifiedName, name));
    }

    public static MCMonitor replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return MCMonitor.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static MCMonitor replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MCMonitor)Asset.replaceTerms(client, MCMonitor.updater(qualifiedName, name), terms);
    }

    public static MCMonitor appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return MCMonitor.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static MCMonitor appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MCMonitor)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static MCMonitor removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return MCMonitor.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static MCMonitor removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MCMonitor)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static MCMonitor appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return MCMonitor.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static MCMonitor appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MCMonitor)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static MCMonitor appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return MCMonitor.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static MCMonitor appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MCMonitor)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        MCMonitor.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        MCMonitor.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        MCMonitor.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected MCMonitor(MCMonitorBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        List<Object> mcMonitorRuleScheduleConfig;
        List<Object> mcMonitorRuleComparisons;
        this.typeName = b.typeName$set ? b.typeName$value : MCMonitor.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<String> mcAssetQualifiedNames = new TreeSet<String>();
        if (b.mcAssetQualifiedNames != null) {
            mcAssetQualifiedNames.addAll(b.mcAssetQualifiedNames);
        }
        mcAssetQualifiedNames = Collections.unmodifiableSortedSet(mcAssetQualifiedNames);
        this.mcAssetQualifiedNames = mcAssetQualifiedNames;
        SortedSet<String> mcLabels = new TreeSet<String>();
        if (b.mcLabels != null) {
            mcLabels.addAll(b.mcLabels);
        }
        mcLabels = Collections.unmodifiableSortedSet(mcLabels);
        this.mcLabels = mcLabels;
        this.mcMonitorAlertCondition = b.mcMonitorAlertCondition;
        SortedSet<IAsset> mcMonitorAssets = new TreeSet<IAsset>();
        if (b.mcMonitorAssets != null) {
            mcMonitorAssets.addAll(b.mcMonitorAssets);
        }
        mcMonitorAssets = Collections.unmodifiableSortedSet(mcMonitorAssets);
        this.mcMonitorAssets = mcMonitorAssets;
        this.mcMonitorBreachRate = b.mcMonitorBreachRate;
        this.mcMonitorId = b.mcMonitorId;
        this.mcMonitorIncidentCount = b.mcMonitorIncidentCount;
        this.mcMonitorNamespace = b.mcMonitorNamespace;
        switch (b.mcMonitorRuleComparisons == null ? 0 : b.mcMonitorRuleComparisons.size()) {
            case 0: {
                mcMonitorRuleComparisons = Collections.emptyList();
                break;
            }
            case 1: {
                mcMonitorRuleComparisons = Collections.singletonList(b.mcMonitorRuleComparisons.get(0));
                break;
            }
            default: {
                mcMonitorRuleComparisons = Collections.unmodifiableList(new ArrayList<MCRuleComparison>(b.mcMonitorRuleComparisons));
            }
        }
        this.mcMonitorRuleComparisons = mcMonitorRuleComparisons;
        this.mcMonitorRuleCustomSql = b.mcMonitorRuleCustomSql;
        this.mcMonitorRuleIsSnoozed = b.mcMonitorRuleIsSnoozed;
        this.mcMonitorRuleNextExecutionTime = b.mcMonitorRuleNextExecutionTime;
        this.mcMonitorRulePreviousExecutionTime = b.mcMonitorRulePreviousExecutionTime;
        switch (b.mcMonitorRuleScheduleConfig == null ? 0 : b.mcMonitorRuleScheduleConfig.size()) {
            case 0: {
                mcMonitorRuleScheduleConfig = Collections.emptyList();
                break;
            }
            case 1: {
                mcMonitorRuleScheduleConfig = Collections.singletonList(b.mcMonitorRuleScheduleConfig.get(0));
                break;
            }
            default: {
                mcMonitorRuleScheduleConfig = Collections.unmodifiableList(new ArrayList<MCRuleSchedule>(b.mcMonitorRuleScheduleConfig));
            }
        }
        this.mcMonitorRuleScheduleConfig = mcMonitorRuleScheduleConfig;
        this.mcMonitorRuleScheduleConfigHumanized = b.mcMonitorRuleScheduleConfigHumanized;
        this.mcMonitorRuleType = b.mcMonitorRuleType;
        this.mcMonitorScheduleType = b.mcMonitorScheduleType;
        this.mcMonitorStatus = b.mcMonitorStatus;
        this.mcMonitorType = b.mcMonitorType;
        this.mcMonitorWarehouse = b.mcMonitorWarehouse;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
    }

    @Generated
    public static MCMonitorBuilder<?, ?> _internal() {
        return new MCMonitorBuilderImpl();
    }

    @Generated
    public MCMonitorBuilder<?, ?> toBuilder() {
        return new MCMonitorBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<String> getMcAssetQualifiedNames() {
        return this.mcAssetQualifiedNames;
    }

    @Override
    @Generated
    public SortedSet<String> getMcLabels() {
        return this.mcLabels;
    }

    @Override
    @Generated
    public String getMcMonitorAlertCondition() {
        return this.mcMonitorAlertCondition;
    }

    @Override
    @Generated
    public SortedSet<IAsset> getMcMonitorAssets() {
        return this.mcMonitorAssets;
    }

    @Override
    @Generated
    public Double getMcMonitorBreachRate() {
        return this.mcMonitorBreachRate;
    }

    @Override
    @Generated
    public String getMcMonitorId() {
        return this.mcMonitorId;
    }

    @Override
    @Generated
    public Long getMcMonitorIncidentCount() {
        return this.mcMonitorIncidentCount;
    }

    @Override
    @Generated
    public String getMcMonitorNamespace() {
        return this.mcMonitorNamespace;
    }

    @Override
    @Generated
    public List<MCRuleComparison> getMcMonitorRuleComparisons() {
        return this.mcMonitorRuleComparisons;
    }

    @Override
    @Generated
    public String getMcMonitorRuleCustomSql() {
        return this.mcMonitorRuleCustomSql;
    }

    @Override
    @Generated
    public Boolean getMcMonitorRuleIsSnoozed() {
        return this.mcMonitorRuleIsSnoozed;
    }

    @Override
    @Generated
    public Long getMcMonitorRuleNextExecutionTime() {
        return this.mcMonitorRuleNextExecutionTime;
    }

    @Override
    @Generated
    public Long getMcMonitorRulePreviousExecutionTime() {
        return this.mcMonitorRulePreviousExecutionTime;
    }

    @Override
    @Generated
    public List<MCRuleSchedule> getMcMonitorRuleScheduleConfig() {
        return this.mcMonitorRuleScheduleConfig;
    }

    @Override
    @Generated
    public String getMcMonitorRuleScheduleConfigHumanized() {
        return this.mcMonitorRuleScheduleConfigHumanized;
    }

    @Override
    @Generated
    public String getMcMonitorRuleType() {
        return this.mcMonitorRuleType;
    }

    @Override
    @Generated
    public String getMcMonitorScheduleType() {
        return this.mcMonitorScheduleType;
    }

    @Override
    @Generated
    public String getMcMonitorStatus() {
        return this.mcMonitorStatus;
    }

    @Override
    @Generated
    public String getMcMonitorType() {
        return this.mcMonitorType;
    }

    @Override
    @Generated
    public String getMcMonitorWarehouse() {
        return this.mcMonitorWarehouse;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MCMonitor)) {
            return false;
        }
        MCMonitor other = (MCMonitor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$mcMonitorBreachRate = this.getMcMonitorBreachRate();
        Double other$mcMonitorBreachRate = other.getMcMonitorBreachRate();
        if (this$mcMonitorBreachRate == null ? other$mcMonitorBreachRate != null : !((Object)this$mcMonitorBreachRate).equals(other$mcMonitorBreachRate)) {
            return false;
        }
        Long this$mcMonitorIncidentCount = this.getMcMonitorIncidentCount();
        Long other$mcMonitorIncidentCount = other.getMcMonitorIncidentCount();
        if (this$mcMonitorIncidentCount == null ? other$mcMonitorIncidentCount != null : !((Object)this$mcMonitorIncidentCount).equals(other$mcMonitorIncidentCount)) {
            return false;
        }
        Boolean this$mcMonitorRuleIsSnoozed = this.getMcMonitorRuleIsSnoozed();
        Boolean other$mcMonitorRuleIsSnoozed = other.getMcMonitorRuleIsSnoozed();
        if (this$mcMonitorRuleIsSnoozed == null ? other$mcMonitorRuleIsSnoozed != null : !((Object)this$mcMonitorRuleIsSnoozed).equals(other$mcMonitorRuleIsSnoozed)) {
            return false;
        }
        Long this$mcMonitorRuleNextExecutionTime = this.getMcMonitorRuleNextExecutionTime();
        Long other$mcMonitorRuleNextExecutionTime = other.getMcMonitorRuleNextExecutionTime();
        if (this$mcMonitorRuleNextExecutionTime == null ? other$mcMonitorRuleNextExecutionTime != null : !((Object)this$mcMonitorRuleNextExecutionTime).equals(other$mcMonitorRuleNextExecutionTime)) {
            return false;
        }
        Long this$mcMonitorRulePreviousExecutionTime = this.getMcMonitorRulePreviousExecutionTime();
        Long other$mcMonitorRulePreviousExecutionTime = other.getMcMonitorRulePreviousExecutionTime();
        if (this$mcMonitorRulePreviousExecutionTime == null ? other$mcMonitorRulePreviousExecutionTime != null : !((Object)this$mcMonitorRulePreviousExecutionTime).equals(other$mcMonitorRulePreviousExecutionTime)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<String> this$mcAssetQualifiedNames = this.getMcAssetQualifiedNames();
        SortedSet<String> other$mcAssetQualifiedNames = other.getMcAssetQualifiedNames();
        if (this$mcAssetQualifiedNames == null ? other$mcAssetQualifiedNames != null : !this$mcAssetQualifiedNames.equals(other$mcAssetQualifiedNames)) {
            return false;
        }
        SortedSet<String> this$mcLabels = this.getMcLabels();
        SortedSet<String> other$mcLabels = other.getMcLabels();
        if (this$mcLabels == null ? other$mcLabels != null : !this$mcLabels.equals(other$mcLabels)) {
            return false;
        }
        String this$mcMonitorAlertCondition = this.getMcMonitorAlertCondition();
        String other$mcMonitorAlertCondition = other.getMcMonitorAlertCondition();
        if (this$mcMonitorAlertCondition == null ? other$mcMonitorAlertCondition != null : !this$mcMonitorAlertCondition.equals(other$mcMonitorAlertCondition)) {
            return false;
        }
        SortedSet<IAsset> this$mcMonitorAssets = this.getMcMonitorAssets();
        SortedSet<IAsset> other$mcMonitorAssets = other.getMcMonitorAssets();
        if (this$mcMonitorAssets == null ? other$mcMonitorAssets != null : !this$mcMonitorAssets.equals(other$mcMonitorAssets)) {
            return false;
        }
        String this$mcMonitorId = this.getMcMonitorId();
        String other$mcMonitorId = other.getMcMonitorId();
        if (this$mcMonitorId == null ? other$mcMonitorId != null : !this$mcMonitorId.equals(other$mcMonitorId)) {
            return false;
        }
        String this$mcMonitorNamespace = this.getMcMonitorNamespace();
        String other$mcMonitorNamespace = other.getMcMonitorNamespace();
        if (this$mcMonitorNamespace == null ? other$mcMonitorNamespace != null : !this$mcMonitorNamespace.equals(other$mcMonitorNamespace)) {
            return false;
        }
        List<MCRuleComparison> this$mcMonitorRuleComparisons = this.getMcMonitorRuleComparisons();
        List<MCRuleComparison> other$mcMonitorRuleComparisons = other.getMcMonitorRuleComparisons();
        if (this$mcMonitorRuleComparisons == null ? other$mcMonitorRuleComparisons != null : !((Object)this$mcMonitorRuleComparisons).equals(other$mcMonitorRuleComparisons)) {
            return false;
        }
        String this$mcMonitorRuleCustomSql = this.getMcMonitorRuleCustomSql();
        String other$mcMonitorRuleCustomSql = other.getMcMonitorRuleCustomSql();
        if (this$mcMonitorRuleCustomSql == null ? other$mcMonitorRuleCustomSql != null : !this$mcMonitorRuleCustomSql.equals(other$mcMonitorRuleCustomSql)) {
            return false;
        }
        List<MCRuleSchedule> this$mcMonitorRuleScheduleConfig = this.getMcMonitorRuleScheduleConfig();
        List<MCRuleSchedule> other$mcMonitorRuleScheduleConfig = other.getMcMonitorRuleScheduleConfig();
        if (this$mcMonitorRuleScheduleConfig == null ? other$mcMonitorRuleScheduleConfig != null : !((Object)this$mcMonitorRuleScheduleConfig).equals(other$mcMonitorRuleScheduleConfig)) {
            return false;
        }
        String this$mcMonitorRuleScheduleConfigHumanized = this.getMcMonitorRuleScheduleConfigHumanized();
        String other$mcMonitorRuleScheduleConfigHumanized = other.getMcMonitorRuleScheduleConfigHumanized();
        if (this$mcMonitorRuleScheduleConfigHumanized == null ? other$mcMonitorRuleScheduleConfigHumanized != null : !this$mcMonitorRuleScheduleConfigHumanized.equals(other$mcMonitorRuleScheduleConfigHumanized)) {
            return false;
        }
        String this$mcMonitorRuleType = this.getMcMonitorRuleType();
        String other$mcMonitorRuleType = other.getMcMonitorRuleType();
        if (this$mcMonitorRuleType == null ? other$mcMonitorRuleType != null : !this$mcMonitorRuleType.equals(other$mcMonitorRuleType)) {
            return false;
        }
        String this$mcMonitorScheduleType = this.getMcMonitorScheduleType();
        String other$mcMonitorScheduleType = other.getMcMonitorScheduleType();
        if (this$mcMonitorScheduleType == null ? other$mcMonitorScheduleType != null : !this$mcMonitorScheduleType.equals(other$mcMonitorScheduleType)) {
            return false;
        }
        String this$mcMonitorStatus = this.getMcMonitorStatus();
        String other$mcMonitorStatus = other.getMcMonitorStatus();
        if (this$mcMonitorStatus == null ? other$mcMonitorStatus != null : !this$mcMonitorStatus.equals(other$mcMonitorStatus)) {
            return false;
        }
        String this$mcMonitorType = this.getMcMonitorType();
        String other$mcMonitorType = other.getMcMonitorType();
        if (this$mcMonitorType == null ? other$mcMonitorType != null : !this$mcMonitorType.equals(other$mcMonitorType)) {
            return false;
        }
        String this$mcMonitorWarehouse = this.getMcMonitorWarehouse();
        String other$mcMonitorWarehouse = other.getMcMonitorWarehouse();
        if (this$mcMonitorWarehouse == null ? other$mcMonitorWarehouse != null : !this$mcMonitorWarehouse.equals(other$mcMonitorWarehouse)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MCMonitor;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $mcMonitorBreachRate = this.getMcMonitorBreachRate();
        result = result * 59 + ($mcMonitorBreachRate == null ? 43 : ((Object)$mcMonitorBreachRate).hashCode());
        Long $mcMonitorIncidentCount = this.getMcMonitorIncidentCount();
        result = result * 59 + ($mcMonitorIncidentCount == null ? 43 : ((Object)$mcMonitorIncidentCount).hashCode());
        Boolean $mcMonitorRuleIsSnoozed = this.getMcMonitorRuleIsSnoozed();
        result = result * 59 + ($mcMonitorRuleIsSnoozed == null ? 43 : ((Object)$mcMonitorRuleIsSnoozed).hashCode());
        Long $mcMonitorRuleNextExecutionTime = this.getMcMonitorRuleNextExecutionTime();
        result = result * 59 + ($mcMonitorRuleNextExecutionTime == null ? 43 : ((Object)$mcMonitorRuleNextExecutionTime).hashCode());
        Long $mcMonitorRulePreviousExecutionTime = this.getMcMonitorRulePreviousExecutionTime();
        result = result * 59 + ($mcMonitorRulePreviousExecutionTime == null ? 43 : ((Object)$mcMonitorRulePreviousExecutionTime).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<String> $mcAssetQualifiedNames = this.getMcAssetQualifiedNames();
        result = result * 59 + ($mcAssetQualifiedNames == null ? 43 : $mcAssetQualifiedNames.hashCode());
        SortedSet<String> $mcLabels = this.getMcLabels();
        result = result * 59 + ($mcLabels == null ? 43 : $mcLabels.hashCode());
        String $mcMonitorAlertCondition = this.getMcMonitorAlertCondition();
        result = result * 59 + ($mcMonitorAlertCondition == null ? 43 : $mcMonitorAlertCondition.hashCode());
        SortedSet<IAsset> $mcMonitorAssets = this.getMcMonitorAssets();
        result = result * 59 + ($mcMonitorAssets == null ? 43 : $mcMonitorAssets.hashCode());
        String $mcMonitorId = this.getMcMonitorId();
        result = result * 59 + ($mcMonitorId == null ? 43 : $mcMonitorId.hashCode());
        String $mcMonitorNamespace = this.getMcMonitorNamespace();
        result = result * 59 + ($mcMonitorNamespace == null ? 43 : $mcMonitorNamespace.hashCode());
        List<MCRuleComparison> $mcMonitorRuleComparisons = this.getMcMonitorRuleComparisons();
        result = result * 59 + ($mcMonitorRuleComparisons == null ? 43 : ((Object)$mcMonitorRuleComparisons).hashCode());
        String $mcMonitorRuleCustomSql = this.getMcMonitorRuleCustomSql();
        result = result * 59 + ($mcMonitorRuleCustomSql == null ? 43 : $mcMonitorRuleCustomSql.hashCode());
        List<MCRuleSchedule> $mcMonitorRuleScheduleConfig = this.getMcMonitorRuleScheduleConfig();
        result = result * 59 + ($mcMonitorRuleScheduleConfig == null ? 43 : ((Object)$mcMonitorRuleScheduleConfig).hashCode());
        String $mcMonitorRuleScheduleConfigHumanized = this.getMcMonitorRuleScheduleConfigHumanized();
        result = result * 59 + ($mcMonitorRuleScheduleConfigHumanized == null ? 43 : $mcMonitorRuleScheduleConfigHumanized.hashCode());
        String $mcMonitorRuleType = this.getMcMonitorRuleType();
        result = result * 59 + ($mcMonitorRuleType == null ? 43 : $mcMonitorRuleType.hashCode());
        String $mcMonitorScheduleType = this.getMcMonitorScheduleType();
        result = result * 59 + ($mcMonitorScheduleType == null ? 43 : $mcMonitorScheduleType.hashCode());
        String $mcMonitorStatus = this.getMcMonitorStatus();
        result = result * 59 + ($mcMonitorStatus == null ? 43 : $mcMonitorStatus.hashCode());
        String $mcMonitorType = this.getMcMonitorType();
        result = result * 59 + ($mcMonitorType == null ? 43 : $mcMonitorType.hashCode());
        String $mcMonitorWarehouse = this.getMcMonitorWarehouse();
        result = result * 59 + ($mcMonitorWarehouse == null ? 43 : $mcMonitorWarehouse.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "MCMonitor(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", mcAssetQualifiedNames=" + this.getMcAssetQualifiedNames() + ", mcLabels=" + this.getMcLabels() + ", mcMonitorAlertCondition=" + this.getMcMonitorAlertCondition() + ", mcMonitorAssets=" + this.getMcMonitorAssets() + ", mcMonitorBreachRate=" + this.getMcMonitorBreachRate() + ", mcMonitorId=" + this.getMcMonitorId() + ", mcMonitorIncidentCount=" + this.getMcMonitorIncidentCount() + ", mcMonitorNamespace=" + this.getMcMonitorNamespace() + ", mcMonitorRuleComparisons=" + this.getMcMonitorRuleComparisons() + ", mcMonitorRuleCustomSql=" + this.getMcMonitorRuleCustomSql() + ", mcMonitorRuleIsSnoozed=" + this.getMcMonitorRuleIsSnoozed() + ", mcMonitorRuleNextExecutionTime=" + this.getMcMonitorRuleNextExecutionTime() + ", mcMonitorRulePreviousExecutionTime=" + this.getMcMonitorRulePreviousExecutionTime() + ", mcMonitorRuleScheduleConfig=" + this.getMcMonitorRuleScheduleConfig() + ", mcMonitorRuleScheduleConfigHumanized=" + this.getMcMonitorRuleScheduleConfigHumanized() + ", mcMonitorRuleType=" + this.getMcMonitorRuleType() + ", mcMonitorScheduleType=" + this.getMcMonitorScheduleType() + ", mcMonitorStatus=" + this.getMcMonitorStatus() + ", mcMonitorType=" + this.getMcMonitorType() + ", mcMonitorWarehouse=" + this.getMcMonitorWarehouse() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class MCMonitorBuilderImpl
    extends MCMonitorBuilder<MCMonitor, MCMonitorBuilderImpl> {
        @Generated
        private MCMonitorBuilderImpl() {
        }

        @Override
        @Generated
        protected MCMonitorBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MCMonitor build() {
            return new MCMonitor(this);
        }
    }

    @Generated
    public static abstract class MCMonitorBuilder<C extends MCMonitor, B extends MCMonitorBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<String> mcAssetQualifiedNames;
        @Generated
        private ArrayList<String> mcLabels;
        @Generated
        private String mcMonitorAlertCondition;
        @Generated
        private ArrayList<IAsset> mcMonitorAssets;
        @Generated
        private Double mcMonitorBreachRate;
        @Generated
        private String mcMonitorId;
        @Generated
        private Long mcMonitorIncidentCount;
        @Generated
        private String mcMonitorNamespace;
        @Generated
        private ArrayList<MCRuleComparison> mcMonitorRuleComparisons;
        @Generated
        private String mcMonitorRuleCustomSql;
        @Generated
        private Boolean mcMonitorRuleIsSnoozed;
        @Generated
        private Long mcMonitorRuleNextExecutionTime;
        @Generated
        private Long mcMonitorRulePreviousExecutionTime;
        @Generated
        private ArrayList<MCRuleSchedule> mcMonitorRuleScheduleConfig;
        @Generated
        private String mcMonitorRuleScheduleConfigHumanized;
        @Generated
        private String mcMonitorRuleType;
        @Generated
        private String mcMonitorScheduleType;
        @Generated
        private String mcMonitorStatus;
        @Generated
        private String mcMonitorType;
        @Generated
        private String mcMonitorWarehouse;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MCMonitorBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MCMonitor instance, MCMonitorBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.mcAssetQualifiedNames(instance.mcAssetQualifiedNames == null ? Collections.emptySortedSet() : instance.mcAssetQualifiedNames);
            b.mcLabels(instance.mcLabels == null ? Collections.emptySortedSet() : instance.mcLabels);
            b.mcMonitorAlertCondition(instance.mcMonitorAlertCondition);
            b.mcMonitorAssets(instance.mcMonitorAssets == null ? Collections.emptySortedSet() : instance.mcMonitorAssets);
            b.mcMonitorBreachRate(instance.mcMonitorBreachRate);
            b.mcMonitorId(instance.mcMonitorId);
            b.mcMonitorIncidentCount(instance.mcMonitorIncidentCount);
            b.mcMonitorNamespace(instance.mcMonitorNamespace);
            b.mcMonitorRuleComparisons(instance.mcMonitorRuleComparisons == null ? Collections.emptyList() : instance.mcMonitorRuleComparisons);
            b.mcMonitorRuleCustomSql(instance.mcMonitorRuleCustomSql);
            b.mcMonitorRuleIsSnoozed(instance.mcMonitorRuleIsSnoozed);
            b.mcMonitorRuleNextExecutionTime(instance.mcMonitorRuleNextExecutionTime);
            b.mcMonitorRulePreviousExecutionTime(instance.mcMonitorRulePreviousExecutionTime);
            b.mcMonitorRuleScheduleConfig(instance.mcMonitorRuleScheduleConfig == null ? Collections.emptyList() : instance.mcMonitorRuleScheduleConfig);
            b.mcMonitorRuleScheduleConfigHumanized(instance.mcMonitorRuleScheduleConfigHumanized);
            b.mcMonitorRuleType(instance.mcMonitorRuleType);
            b.mcMonitorScheduleType(instance.mcMonitorScheduleType);
            b.mcMonitorStatus(instance.mcMonitorStatus);
            b.mcMonitorType(instance.mcMonitorType);
            b.mcMonitorWarehouse(instance.mcMonitorWarehouse);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B mcAssetQualifiedName(String mcAssetQualifiedName) {
            if (this.mcAssetQualifiedNames == null) {
                this.mcAssetQualifiedNames = new ArrayList();
            }
            this.mcAssetQualifiedNames.add(mcAssetQualifiedName);
            return (B)this.self();
        }

        @Generated
        public B mcAssetQualifiedNames(Collection<? extends String> mcAssetQualifiedNames) {
            if (mcAssetQualifiedNames == null) {
                throw new NullPointerException("mcAssetQualifiedNames cannot be null");
            }
            if (this.mcAssetQualifiedNames == null) {
                this.mcAssetQualifiedNames = new ArrayList();
            }
            this.mcAssetQualifiedNames.addAll(mcAssetQualifiedNames);
            return (B)this.self();
        }

        @Generated
        public B clearMcAssetQualifiedNames() {
            if (this.mcAssetQualifiedNames != null) {
                this.mcAssetQualifiedNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B mcLabel(String mcLabel) {
            if (this.mcLabels == null) {
                this.mcLabels = new ArrayList();
            }
            this.mcLabels.add(mcLabel);
            return (B)this.self();
        }

        @Generated
        public B mcLabels(Collection<? extends String> mcLabels) {
            if (mcLabels == null) {
                throw new NullPointerException("mcLabels cannot be null");
            }
            if (this.mcLabels == null) {
                this.mcLabels = new ArrayList();
            }
            this.mcLabels.addAll(mcLabels);
            return (B)this.self();
        }

        @Generated
        public B clearMcLabels() {
            if (this.mcLabels != null) {
                this.mcLabels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B mcMonitorAlertCondition(String mcMonitorAlertCondition) {
            this.mcMonitorAlertCondition = mcMonitorAlertCondition;
            return (B)this.self();
        }

        @Generated
        public B mcMonitorAsset(IAsset mcMonitorAsset) {
            if (this.mcMonitorAssets == null) {
                this.mcMonitorAssets = new ArrayList();
            }
            this.mcMonitorAssets.add(mcMonitorAsset);
            return (B)this.self();
        }

        @Generated
        public B mcMonitorAssets(Collection<? extends IAsset> mcMonitorAssets) {
            if (mcMonitorAssets == null) {
                throw new NullPointerException("mcMonitorAssets cannot be null");
            }
            if (this.mcMonitorAssets == null) {
                this.mcMonitorAssets = new ArrayList();
            }
            this.mcMonitorAssets.addAll(mcMonitorAssets);
            return (B)this.self();
        }

        @Generated
        public B clearMcMonitorAssets() {
            if (this.mcMonitorAssets != null) {
                this.mcMonitorAssets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B mcMonitorBreachRate(Double mcMonitorBreachRate) {
            this.mcMonitorBreachRate = mcMonitorBreachRate;
            return (B)this.self();
        }

        @Generated
        public B mcMonitorId(String mcMonitorId) {
            this.mcMonitorId = mcMonitorId;
            return (B)this.self();
        }

        @Generated
        public B mcMonitorIncidentCount(Long mcMonitorIncidentCount) {
            this.mcMonitorIncidentCount = mcMonitorIncidentCount;
            return (B)this.self();
        }

        @Generated
        public B mcMonitorNamespace(String mcMonitorNamespace) {
            this.mcMonitorNamespace = mcMonitorNamespace;
            return (B)this.self();
        }

        @Generated
        public B mcMonitorRuleComparison(MCRuleComparison mcMonitorRuleComparison) {
            if (this.mcMonitorRuleComparisons == null) {
                this.mcMonitorRuleComparisons = new ArrayList();
            }
            this.mcMonitorRuleComparisons.add(mcMonitorRuleComparison);
            return (B)this.self();
        }

        @Generated
        public B mcMonitorRuleComparisons(Collection<? extends MCRuleComparison> mcMonitorRuleComparisons) {
            if (mcMonitorRuleComparisons == null) {
                throw new NullPointerException("mcMonitorRuleComparisons cannot be null");
            }
            if (this.mcMonitorRuleComparisons == null) {
                this.mcMonitorRuleComparisons = new ArrayList();
            }
            this.mcMonitorRuleComparisons.addAll(mcMonitorRuleComparisons);
            return (B)this.self();
        }

        @Generated
        public B clearMcMonitorRuleComparisons() {
            if (this.mcMonitorRuleComparisons != null) {
                this.mcMonitorRuleComparisons.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B mcMonitorRuleCustomSql(String mcMonitorRuleCustomSql) {
            this.mcMonitorRuleCustomSql = mcMonitorRuleCustomSql;
            return (B)this.self();
        }

        @Generated
        public B mcMonitorRuleIsSnoozed(Boolean mcMonitorRuleIsSnoozed) {
            this.mcMonitorRuleIsSnoozed = mcMonitorRuleIsSnoozed;
            return (B)this.self();
        }

        @Generated
        public B mcMonitorRuleNextExecutionTime(Long mcMonitorRuleNextExecutionTime) {
            this.mcMonitorRuleNextExecutionTime = mcMonitorRuleNextExecutionTime;
            return (B)this.self();
        }

        @Generated
        public B mcMonitorRulePreviousExecutionTime(Long mcMonitorRulePreviousExecutionTime) {
            this.mcMonitorRulePreviousExecutionTime = mcMonitorRulePreviousExecutionTime;
            return (B)this.self();
        }

        @Generated
        public B addMcMonitorRuleSchedule(MCRuleSchedule addMcMonitorRuleSchedule) {
            if (this.mcMonitorRuleScheduleConfig == null) {
                this.mcMonitorRuleScheduleConfig = new ArrayList();
            }
            this.mcMonitorRuleScheduleConfig.add(addMcMonitorRuleSchedule);
            return (B)this.self();
        }

        @Generated
        public B mcMonitorRuleScheduleConfig(Collection<? extends MCRuleSchedule> mcMonitorRuleScheduleConfig) {
            if (mcMonitorRuleScheduleConfig == null) {
                throw new NullPointerException("mcMonitorRuleScheduleConfig cannot be null");
            }
            if (this.mcMonitorRuleScheduleConfig == null) {
                this.mcMonitorRuleScheduleConfig = new ArrayList();
            }
            this.mcMonitorRuleScheduleConfig.addAll(mcMonitorRuleScheduleConfig);
            return (B)this.self();
        }

        @Generated
        public B clearMcMonitorRuleScheduleConfig() {
            if (this.mcMonitorRuleScheduleConfig != null) {
                this.mcMonitorRuleScheduleConfig.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B mcMonitorRuleScheduleConfigHumanized(String mcMonitorRuleScheduleConfigHumanized) {
            this.mcMonitorRuleScheduleConfigHumanized = mcMonitorRuleScheduleConfigHumanized;
            return (B)this.self();
        }

        @Generated
        public B mcMonitorRuleType(String mcMonitorRuleType) {
            this.mcMonitorRuleType = mcMonitorRuleType;
            return (B)this.self();
        }

        @Generated
        public B mcMonitorScheduleType(String mcMonitorScheduleType) {
            this.mcMonitorScheduleType = mcMonitorScheduleType;
            return (B)this.self();
        }

        @Generated
        public B mcMonitorStatus(String mcMonitorStatus) {
            this.mcMonitorStatus = mcMonitorStatus;
            return (B)this.self();
        }

        @Generated
        public B mcMonitorType(String mcMonitorType) {
            this.mcMonitorType = mcMonitorType;
            return (B)this.self();
        }

        @Generated
        public B mcMonitorWarehouse(String mcMonitorWarehouse) {
            this.mcMonitorWarehouse = mcMonitorWarehouse;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "MCMonitor.MCMonitorBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", mcAssetQualifiedNames=" + this.mcAssetQualifiedNames + ", mcLabels=" + this.mcLabels + ", mcMonitorAlertCondition=" + this.mcMonitorAlertCondition + ", mcMonitorAssets=" + this.mcMonitorAssets + ", mcMonitorBreachRate=" + this.mcMonitorBreachRate + ", mcMonitorId=" + this.mcMonitorId + ", mcMonitorIncidentCount=" + this.mcMonitorIncidentCount + ", mcMonitorNamespace=" + this.mcMonitorNamespace + ", mcMonitorRuleComparisons=" + this.mcMonitorRuleComparisons + ", mcMonitorRuleCustomSql=" + this.mcMonitorRuleCustomSql + ", mcMonitorRuleIsSnoozed=" + this.mcMonitorRuleIsSnoozed + ", mcMonitorRuleNextExecutionTime=" + this.mcMonitorRuleNextExecutionTime + ", mcMonitorRulePreviousExecutionTime=" + this.mcMonitorRulePreviousExecutionTime + ", mcMonitorRuleScheduleConfig=" + this.mcMonitorRuleScheduleConfig + ", mcMonitorRuleScheduleConfigHumanized=" + this.mcMonitorRuleScheduleConfigHumanized + ", mcMonitorRuleType=" + this.mcMonitorRuleType + ", mcMonitorScheduleType=" + this.mcMonitorScheduleType + ", mcMonitorStatus=" + this.mcMonitorStatus + ", mcMonitorType=" + this.mcMonitorType + ", mcMonitorWarehouse=" + this.mcMonitorWarehouse + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ")";
        }
    }
}

