/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IColumn;
import com.atlan.model.assets.IDbtModel;
import com.atlan.model.assets.IDbtSource;
import com.atlan.model.assets.IDbtTest;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMaterializedView;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISQL;
import com.atlan.model.assets.ISchema;
import com.atlan.model.assets.Schema;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterializedView
extends Asset
implements IMaterializedView,
ISQL,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MaterializedView.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MaterialisedView";
    String typeName;
    @Attribute
    String alias;
    @Attribute
    Long columnCount;
    @Attribute
    SortedSet<IColumn> columns;
    @Attribute
    String databaseName;
    @Attribute
    String databaseQualifiedName;
    @Attribute
    SortedSet<IDbtModel> dbtModels;
    @Attribute
    SortedSet<IDbtSource> dbtSources;
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    @Attribute
    String definition;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    Boolean isProfiled;
    @Attribute
    Boolean isQueryPreview;
    @Attribute
    Boolean isTemporary;
    @Attribute
    Long lastProfiledAt;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    Long queryCount;
    @Attribute
    Long queryCountUpdatedAt;
    @Attribute
    Map<String, String> queryPreviewConfig;
    @Attribute
    Long queryUserCount;
    @Attribute
    Map<String, Long> queryUserMap;
    @Attribute
    String refreshMethod;
    @Attribute
    String refreshMode;
    @Attribute
    Long rowCount;
    @Attribute
    @JsonProperty(value="atlanSchema")
    ISchema schema;
    @Attribute
    String schemaName;
    @Attribute
    String schemaQualifiedName;
    @Attribute
    Long sizeBytes;
    @Attribute
    SortedSet<IDbtSource> sqlDBTSources;
    @Attribute
    SortedSet<IDbtModel> sqlDbtModels;
    @Attribute
    Long staleSinceDate;
    @Attribute
    String staleness;
    @Attribute
    String tableName;
    @Attribute
    String tableQualifiedName;
    @Attribute
    String viewName;
    @Attribute
    String viewQualifiedName;

    @Override
    public MaterializedView trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return MaterializedView.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return MaterializedView.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return MaterializedView.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return MaterializedView.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return MaterializedView.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return MaterializedView.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return MaterializedView.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return MaterializedView.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return MaterializedView.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static MaterializedView refByGuid(String guid) {
        return ((MaterializedViewBuilder)MaterializedView._internal().guid(guid)).build();
    }

    public static MaterializedView refByQualifiedName(String qualifiedName) {
        return ((MaterializedViewBuilder)MaterializedView._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static MaterializedView get(String id) throws AtlanException {
        return MaterializedView.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static MaterializedView get(AtlanClient client, String id) throws AtlanException {
        return MaterializedView.get(client, id, true);
    }

    @JsonIgnore
    public static MaterializedView get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof MaterializedView) {
                return (MaterializedView)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof MaterializedView) {
            return (MaterializedView)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static MaterializedView retrieveByGuid(String guid) throws AtlanException {
        return MaterializedView.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static MaterializedView retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return MaterializedView.get(client, guid);
    }

    @Deprecated
    public static MaterializedView retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return MaterializedView.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static MaterializedView retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return MaterializedView.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return MaterializedView.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static MaterializedViewBuilder<?, ?> creator(String name, Schema schema) throws InvalidRequestException {
        if (schema.getQualifiedName() == null || schema.getQualifiedName().isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, "Schema", "qualifiedName");
        }
        return MaterializedView.creator(name, schema.getQualifiedName()).schema(schema.trimToReference());
    }

    public static MaterializedViewBuilder<?, ?> creator(String name, String schemaQualifiedName) {
        String[] tokens = schemaQualifiedName.split("/");
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(tokens);
        String schemaName = StringUtils.getNameFromQualifiedName(schemaQualifiedName);
        String databaseQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(schemaQualifiedName);
        String databaseName = StringUtils.getNameFromQualifiedName(databaseQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(databaseQualifiedName);
        return (MaterializedViewBuilder)((Asset.AssetBuilder)((MaterializedViewBuilder)((MaterializedViewBuilder)((MaterializedViewBuilder)((MaterializedViewBuilder)((MaterializedViewBuilder)((MaterializedViewBuilder)((MaterializedViewBuilder)((MaterializedViewBuilder)MaterializedView._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).qualifiedName(MaterializedView.generateQualifiedName(name, schemaQualifiedName))).connectorType(connectorType)).schemaName(schemaName)).schemaQualifiedName(schemaQualifiedName)).schema(Schema.refByQualifiedName(schemaQualifiedName))).databaseName(databaseName)).databaseQualifiedName(databaseQualifiedName)).connectionQualifiedName(connectionQualifiedName);
    }

    public static String generateQualifiedName(String name, String schemaQualifiedName) {
        return schemaQualifiedName + "/" + name;
    }

    public static MaterializedViewBuilder<?, ?> updater(String qualifiedName, String name) {
        return (MaterializedViewBuilder)((MaterializedViewBuilder)((MaterializedViewBuilder)MaterializedView._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public MaterializedViewBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, "MaterializedView", String.join((CharSequence)",", missing));
        }
        return MaterializedView.updater(this.getQualifiedName(), this.getName());
    }

    public static MaterializedView removeDescription(String qualifiedName, String name) throws AtlanException {
        return MaterializedView.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MaterializedView removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MaterializedView)Asset.removeDescription(client, MaterializedView.updater(qualifiedName, name));
    }

    public static MaterializedView removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return MaterializedView.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MaterializedView removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MaterializedView)Asset.removeUserDescription(client, MaterializedView.updater(qualifiedName, name));
    }

    public static MaterializedView removeOwners(String qualifiedName, String name) throws AtlanException {
        return MaterializedView.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MaterializedView removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MaterializedView)Asset.removeOwners(client, MaterializedView.updater(qualifiedName, name));
    }

    public static MaterializedView updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return MaterializedView.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static MaterializedView updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MaterializedView)Asset.updateCertificate(client, MaterializedView._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static MaterializedView removeCertificate(String qualifiedName, String name) throws AtlanException {
        return MaterializedView.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MaterializedView removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MaterializedView)Asset.removeCertificate(client, MaterializedView.updater(qualifiedName, name));
    }

    public static MaterializedView updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return MaterializedView.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static MaterializedView updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MaterializedView)Asset.updateAnnouncement(client, MaterializedView._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static MaterializedView removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return MaterializedView.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MaterializedView removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MaterializedView)Asset.removeAnnouncement(client, MaterializedView.updater(qualifiedName, name));
    }

    public static MaterializedView replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return MaterializedView.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static MaterializedView replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MaterializedView)Asset.replaceTerms(client, MaterializedView.updater(qualifiedName, name), terms);
    }

    public static MaterializedView appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return MaterializedView.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static MaterializedView appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MaterializedView)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static MaterializedView removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return MaterializedView.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static MaterializedView removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MaterializedView)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static MaterializedView appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return MaterializedView.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static MaterializedView appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MaterializedView)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static MaterializedView appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return MaterializedView.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static MaterializedView appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MaterializedView)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        MaterializedView.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        MaterializedView.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        MaterializedView.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected MaterializedView(MaterializedViewBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> queryUserMap;
        Map<Object, Object> queryPreviewConfig;
        this.typeName = b.typeName$set ? b.typeName$value : MaterializedView.$default$typeName();
        this.alias = b.alias;
        this.columnCount = b.columnCount;
        SortedSet<IColumn> columns = new TreeSet<IColumn>();
        if (b.columns != null) {
            columns.addAll(b.columns);
        }
        columns = Collections.unmodifiableSortedSet(columns);
        this.columns = columns;
        this.databaseName = b.databaseName;
        this.databaseQualifiedName = b.databaseQualifiedName;
        SortedSet<IDbtModel> dbtModels = new TreeSet<IDbtModel>();
        if (b.dbtModels != null) {
            dbtModels.addAll(b.dbtModels);
        }
        dbtModels = Collections.unmodifiableSortedSet(dbtModels);
        this.dbtModels = dbtModels;
        SortedSet<IDbtSource> dbtSources = new TreeSet<IDbtSource>();
        if (b.dbtSources != null) {
            dbtSources.addAll(b.dbtSources);
        }
        dbtSources = Collections.unmodifiableSortedSet(dbtSources);
        this.dbtSources = dbtSources;
        SortedSet<IDbtTest> dbtTests = new TreeSet<IDbtTest>();
        if (b.dbtTests != null) {
            dbtTests.addAll(b.dbtTests);
        }
        dbtTests = Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        this.definition = b.definition;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        this.isProfiled = b.isProfiled;
        this.isQueryPreview = b.isQueryPreview;
        this.isTemporary = b.isTemporary;
        this.lastProfiledAt = b.lastProfiledAt;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        this.queryCount = b.queryCount;
        this.queryCountUpdatedAt = b.queryCountUpdatedAt;
        switch (b.queryPreviewConfig$key == null ? 0 : b.queryPreviewConfig$key.size()) {
            case 0: {
                queryPreviewConfig = Collections.emptyMap();
                break;
            }
            case 1: {
                queryPreviewConfig = Collections.singletonMap(b.queryPreviewConfig$key.get(0), b.queryPreviewConfig$value.get(0));
                break;
            }
            default: {
                queryPreviewConfig = new LinkedHashMap(b.queryPreviewConfig$key.size() < 0x40000000 ? 1 + b.queryPreviewConfig$key.size() + (b.queryPreviewConfig$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryPreviewConfig$key.size(); ++$i) {
                    queryPreviewConfig.put(b.queryPreviewConfig$key.get($i), b.queryPreviewConfig$value.get($i));
                }
                queryPreviewConfig = Collections.unmodifiableMap(queryPreviewConfig);
            }
        }
        this.queryPreviewConfig = queryPreviewConfig;
        this.queryUserCount = b.queryUserCount;
        switch (b.queryUserMap$key == null ? 0 : b.queryUserMap$key.size()) {
            case 0: {
                queryUserMap = Collections.emptyMap();
                break;
            }
            case 1: {
                queryUserMap = Collections.singletonMap(b.queryUserMap$key.get(0), b.queryUserMap$value.get(0));
                break;
            }
            default: {
                queryUserMap = new LinkedHashMap(b.queryUserMap$key.size() < 0x40000000 ? 1 + b.queryUserMap$key.size() + (b.queryUserMap$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryUserMap$key.size(); ++$i) {
                    queryUserMap.put(b.queryUserMap$key.get($i), b.queryUserMap$value.get($i));
                }
                queryUserMap = Collections.unmodifiableMap(queryUserMap);
            }
        }
        this.queryUserMap = queryUserMap;
        this.refreshMethod = b.refreshMethod;
        this.refreshMode = b.refreshMode;
        this.rowCount = b.rowCount;
        this.schema = b.schema;
        this.schemaName = b.schemaName;
        this.schemaQualifiedName = b.schemaQualifiedName;
        this.sizeBytes = b.sizeBytes;
        SortedSet<IDbtSource> sqlDBTSources = new TreeSet<IDbtSource>();
        if (b.sqlDBTSources != null) {
            sqlDBTSources.addAll(b.sqlDBTSources);
        }
        sqlDBTSources = Collections.unmodifiableSortedSet(sqlDBTSources);
        this.sqlDBTSources = sqlDBTSources;
        SortedSet<IDbtModel> sqlDbtModels = new TreeSet<IDbtModel>();
        if (b.sqlDbtModels != null) {
            sqlDbtModels.addAll(b.sqlDbtModels);
        }
        sqlDbtModels = Collections.unmodifiableSortedSet(sqlDbtModels);
        this.sqlDbtModels = sqlDbtModels;
        this.staleSinceDate = b.staleSinceDate;
        this.staleness = b.staleness;
        this.tableName = b.tableName;
        this.tableQualifiedName = b.tableQualifiedName;
        this.viewName = b.viewName;
        this.viewQualifiedName = b.viewQualifiedName;
    }

    @Generated
    public static MaterializedViewBuilder<?, ?> _internal() {
        return new MaterializedViewBuilderImpl();
    }

    @Generated
    public MaterializedViewBuilder<?, ?> toBuilder() {
        return new MaterializedViewBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Override
    @Generated
    public Long getColumnCount() {
        return this.columnCount;
    }

    @Override
    @Generated
    public SortedSet<IColumn> getColumns() {
        return this.columns;
    }

    @Override
    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    @Generated
    public String getDatabaseQualifiedName() {
        return this.databaseQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IDbtModel> getDbtModels() {
        return this.dbtModels;
    }

    @Override
    @Generated
    public SortedSet<IDbtSource> getDbtSources() {
        return this.dbtSources;
    }

    @Override
    @Generated
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    @Override
    @Generated
    public String getDefinition() {
        return this.definition;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public Boolean getIsProfiled() {
        return this.isProfiled;
    }

    @Override
    @Generated
    public Boolean getIsQueryPreview() {
        return this.isQueryPreview;
    }

    @Override
    @Generated
    public Boolean getIsTemporary() {
        return this.isTemporary;
    }

    @Override
    @Generated
    public Long getLastProfiledAt() {
        return this.lastProfiledAt;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public Long getQueryCount() {
        return this.queryCount;
    }

    @Override
    @Generated
    public Long getQueryCountUpdatedAt() {
        return this.queryCountUpdatedAt;
    }

    @Override
    @Generated
    public Map<String, String> getQueryPreviewConfig() {
        return this.queryPreviewConfig;
    }

    @Override
    @Generated
    public Long getQueryUserCount() {
        return this.queryUserCount;
    }

    @Override
    @Generated
    public Map<String, Long> getQueryUserMap() {
        return this.queryUserMap;
    }

    @Override
    @Generated
    public String getRefreshMethod() {
        return this.refreshMethod;
    }

    @Override
    @Generated
    public String getRefreshMode() {
        return this.refreshMode;
    }

    @Override
    @Generated
    public Long getRowCount() {
        return this.rowCount;
    }

    @Override
    @Generated
    public ISchema getSchema() {
        return this.schema;
    }

    @Override
    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    @Generated
    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    @Override
    @Generated
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    @Override
    @Generated
    public SortedSet<IDbtSource> getSqlDBTSources() {
        return this.sqlDBTSources;
    }

    @Override
    @Generated
    public SortedSet<IDbtModel> getSqlDbtModels() {
        return this.sqlDbtModels;
    }

    @Override
    @Generated
    public Long getStaleSinceDate() {
        return this.staleSinceDate;
    }

    @Override
    @Generated
    public String getStaleness() {
        return this.staleness;
    }

    @Override
    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @Generated
    public String getTableQualifiedName() {
        return this.tableQualifiedName;
    }

    @Override
    @Generated
    public String getViewName() {
        return this.viewName;
    }

    @Override
    @Generated
    public String getViewQualifiedName() {
        return this.viewQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaterializedView)) {
            return false;
        }
        MaterializedView other = (MaterializedView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$columnCount = this.getColumnCount();
        Long other$columnCount = other.getColumnCount();
        if (this$columnCount == null ? other$columnCount != null : !((Object)this$columnCount).equals(other$columnCount)) {
            return false;
        }
        Boolean this$isProfiled = this.getIsProfiled();
        Boolean other$isProfiled = other.getIsProfiled();
        if (this$isProfiled == null ? other$isProfiled != null : !((Object)this$isProfiled).equals(other$isProfiled)) {
            return false;
        }
        Boolean this$isQueryPreview = this.getIsQueryPreview();
        Boolean other$isQueryPreview = other.getIsQueryPreview();
        if (this$isQueryPreview == null ? other$isQueryPreview != null : !((Object)this$isQueryPreview).equals(other$isQueryPreview)) {
            return false;
        }
        Boolean this$isTemporary = this.getIsTemporary();
        Boolean other$isTemporary = other.getIsTemporary();
        if (this$isTemporary == null ? other$isTemporary != null : !((Object)this$isTemporary).equals(other$isTemporary)) {
            return false;
        }
        Long this$lastProfiledAt = this.getLastProfiledAt();
        Long other$lastProfiledAt = other.getLastProfiledAt();
        if (this$lastProfiledAt == null ? other$lastProfiledAt != null : !((Object)this$lastProfiledAt).equals(other$lastProfiledAt)) {
            return false;
        }
        Long this$queryCount = this.getQueryCount();
        Long other$queryCount = other.getQueryCount();
        if (this$queryCount == null ? other$queryCount != null : !((Object)this$queryCount).equals(other$queryCount)) {
            return false;
        }
        Long this$queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        Long other$queryCountUpdatedAt = other.getQueryCountUpdatedAt();
        if (this$queryCountUpdatedAt == null ? other$queryCountUpdatedAt != null : !((Object)this$queryCountUpdatedAt).equals(other$queryCountUpdatedAt)) {
            return false;
        }
        Long this$queryUserCount = this.getQueryUserCount();
        Long other$queryUserCount = other.getQueryUserCount();
        if (this$queryUserCount == null ? other$queryUserCount != null : !((Object)this$queryUserCount).equals(other$queryUserCount)) {
            return false;
        }
        Long this$rowCount = this.getRowCount();
        Long other$rowCount = other.getRowCount();
        if (this$rowCount == null ? other$rowCount != null : !((Object)this$rowCount).equals(other$rowCount)) {
            return false;
        }
        Long this$sizeBytes = this.getSizeBytes();
        Long other$sizeBytes = other.getSizeBytes();
        if (this$sizeBytes == null ? other$sizeBytes != null : !((Object)this$sizeBytes).equals(other$sizeBytes)) {
            return false;
        }
        Long this$staleSinceDate = this.getStaleSinceDate();
        Long other$staleSinceDate = other.getStaleSinceDate();
        if (this$staleSinceDate == null ? other$staleSinceDate != null : !((Object)this$staleSinceDate).equals(other$staleSinceDate)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        SortedSet<IColumn> this$columns = this.getColumns();
        SortedSet<IColumn> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$databaseQualifiedName = this.getDatabaseQualifiedName();
        String other$databaseQualifiedName = other.getDatabaseQualifiedName();
        if (this$databaseQualifiedName == null ? other$databaseQualifiedName != null : !this$databaseQualifiedName.equals(other$databaseQualifiedName)) {
            return false;
        }
        SortedSet<IDbtModel> this$dbtModels = this.getDbtModels();
        SortedSet<IDbtModel> other$dbtModels = other.getDbtModels();
        if (this$dbtModels == null ? other$dbtModels != null : !this$dbtModels.equals(other$dbtModels)) {
            return false;
        }
        SortedSet<IDbtSource> this$dbtSources = this.getDbtSources();
        SortedSet<IDbtSource> other$dbtSources = other.getDbtSources();
        if (this$dbtSources == null ? other$dbtSources != null : !this$dbtSources.equals(other$dbtSources)) {
            return false;
        }
        SortedSet<IDbtTest> this$dbtTests = this.getDbtTests();
        SortedSet<IDbtTest> other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) {
            return false;
        }
        String this$definition = this.getDefinition();
        String other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !this$definition.equals(other$definition)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        Map<String, String> this$queryPreviewConfig = this.getQueryPreviewConfig();
        Map<String, String> other$queryPreviewConfig = other.getQueryPreviewConfig();
        if (this$queryPreviewConfig == null ? other$queryPreviewConfig != null : !((Object)this$queryPreviewConfig).equals(other$queryPreviewConfig)) {
            return false;
        }
        Map<String, Long> this$queryUserMap = this.getQueryUserMap();
        Map<String, Long> other$queryUserMap = other.getQueryUserMap();
        if (this$queryUserMap == null ? other$queryUserMap != null : !((Object)this$queryUserMap).equals(other$queryUserMap)) {
            return false;
        }
        String this$refreshMethod = this.getRefreshMethod();
        String other$refreshMethod = other.getRefreshMethod();
        if (this$refreshMethod == null ? other$refreshMethod != null : !this$refreshMethod.equals(other$refreshMethod)) {
            return false;
        }
        String this$refreshMode = this.getRefreshMode();
        String other$refreshMode = other.getRefreshMode();
        if (this$refreshMode == null ? other$refreshMode != null : !this$refreshMode.equals(other$refreshMode)) {
            return false;
        }
        ISchema this$schema = this.getSchema();
        ISchema other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$schemaQualifiedName = this.getSchemaQualifiedName();
        String other$schemaQualifiedName = other.getSchemaQualifiedName();
        if (this$schemaQualifiedName == null ? other$schemaQualifiedName != null : !this$schemaQualifiedName.equals(other$schemaQualifiedName)) {
            return false;
        }
        SortedSet<IDbtSource> this$sqlDBTSources = this.getSqlDBTSources();
        SortedSet<IDbtSource> other$sqlDBTSources = other.getSqlDBTSources();
        if (this$sqlDBTSources == null ? other$sqlDBTSources != null : !this$sqlDBTSources.equals(other$sqlDBTSources)) {
            return false;
        }
        SortedSet<IDbtModel> this$sqlDbtModels = this.getSqlDbtModels();
        SortedSet<IDbtModel> other$sqlDbtModels = other.getSqlDbtModels();
        if (this$sqlDbtModels == null ? other$sqlDbtModels != null : !this$sqlDbtModels.equals(other$sqlDbtModels)) {
            return false;
        }
        String this$staleness = this.getStaleness();
        String other$staleness = other.getStaleness();
        if (this$staleness == null ? other$staleness != null : !this$staleness.equals(other$staleness)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$tableQualifiedName = this.getTableQualifiedName();
        String other$tableQualifiedName = other.getTableQualifiedName();
        if (this$tableQualifiedName == null ? other$tableQualifiedName != null : !this$tableQualifiedName.equals(other$tableQualifiedName)) {
            return false;
        }
        String this$viewName = this.getViewName();
        String other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName)) {
            return false;
        }
        String this$viewQualifiedName = this.getViewQualifiedName();
        String other$viewQualifiedName = other.getViewQualifiedName();
        return !(this$viewQualifiedName == null ? other$viewQualifiedName != null : !this$viewQualifiedName.equals(other$viewQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MaterializedView;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $columnCount = this.getColumnCount();
        result = result * 59 + ($columnCount == null ? 43 : ((Object)$columnCount).hashCode());
        Boolean $isProfiled = this.getIsProfiled();
        result = result * 59 + ($isProfiled == null ? 43 : ((Object)$isProfiled).hashCode());
        Boolean $isQueryPreview = this.getIsQueryPreview();
        result = result * 59 + ($isQueryPreview == null ? 43 : ((Object)$isQueryPreview).hashCode());
        Boolean $isTemporary = this.getIsTemporary();
        result = result * 59 + ($isTemporary == null ? 43 : ((Object)$isTemporary).hashCode());
        Long $lastProfiledAt = this.getLastProfiledAt();
        result = result * 59 + ($lastProfiledAt == null ? 43 : ((Object)$lastProfiledAt).hashCode());
        Long $queryCount = this.getQueryCount();
        result = result * 59 + ($queryCount == null ? 43 : ((Object)$queryCount).hashCode());
        Long $queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        result = result * 59 + ($queryCountUpdatedAt == null ? 43 : ((Object)$queryCountUpdatedAt).hashCode());
        Long $queryUserCount = this.getQueryUserCount();
        result = result * 59 + ($queryUserCount == null ? 43 : ((Object)$queryUserCount).hashCode());
        Long $rowCount = this.getRowCount();
        result = result * 59 + ($rowCount == null ? 43 : ((Object)$rowCount).hashCode());
        Long $sizeBytes = this.getSizeBytes();
        result = result * 59 + ($sizeBytes == null ? 43 : ((Object)$sizeBytes).hashCode());
        Long $staleSinceDate = this.getStaleSinceDate();
        result = result * 59 + ($staleSinceDate == null ? 43 : ((Object)$staleSinceDate).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        SortedSet<IColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : $columns.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $databaseQualifiedName = this.getDatabaseQualifiedName();
        result = result * 59 + ($databaseQualifiedName == null ? 43 : $databaseQualifiedName.hashCode());
        SortedSet<IDbtModel> $dbtModels = this.getDbtModels();
        result = result * 59 + ($dbtModels == null ? 43 : $dbtModels.hashCode());
        SortedSet<IDbtSource> $dbtSources = this.getDbtSources();
        result = result * 59 + ($dbtSources == null ? 43 : $dbtSources.hashCode());
        SortedSet<IDbtTest> $dbtTests = this.getDbtTests();
        result = result * 59 + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        String $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        Map<String, String> $queryPreviewConfig = this.getQueryPreviewConfig();
        result = result * 59 + ($queryPreviewConfig == null ? 43 : ((Object)$queryPreviewConfig).hashCode());
        Map<String, Long> $queryUserMap = this.getQueryUserMap();
        result = result * 59 + ($queryUserMap == null ? 43 : ((Object)$queryUserMap).hashCode());
        String $refreshMethod = this.getRefreshMethod();
        result = result * 59 + ($refreshMethod == null ? 43 : $refreshMethod.hashCode());
        String $refreshMode = this.getRefreshMode();
        result = result * 59 + ($refreshMode == null ? 43 : $refreshMode.hashCode());
        ISchema $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $schemaQualifiedName = this.getSchemaQualifiedName();
        result = result * 59 + ($schemaQualifiedName == null ? 43 : $schemaQualifiedName.hashCode());
        SortedSet<IDbtSource> $sqlDBTSources = this.getSqlDBTSources();
        result = result * 59 + ($sqlDBTSources == null ? 43 : $sqlDBTSources.hashCode());
        SortedSet<IDbtModel> $sqlDbtModels = this.getSqlDbtModels();
        result = result * 59 + ($sqlDbtModels == null ? 43 : $sqlDbtModels.hashCode());
        String $staleness = this.getStaleness();
        result = result * 59 + ($staleness == null ? 43 : $staleness.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $tableQualifiedName = this.getTableQualifiedName();
        result = result * 59 + ($tableQualifiedName == null ? 43 : $tableQualifiedName.hashCode());
        String $viewName = this.getViewName();
        result = result * 59 + ($viewName == null ? 43 : $viewName.hashCode());
        String $viewQualifiedName = this.getViewQualifiedName();
        result = result * 59 + ($viewQualifiedName == null ? 43 : $viewQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "MaterializedView(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", alias=" + this.getAlias() + ", columnCount=" + this.getColumnCount() + ", columns=" + this.getColumns() + ", databaseName=" + this.getDatabaseName() + ", databaseQualifiedName=" + this.getDatabaseQualifiedName() + ", dbtModels=" + this.getDbtModels() + ", dbtSources=" + this.getDbtSources() + ", dbtTests=" + this.getDbtTests() + ", definition=" + this.getDefinition() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", isProfiled=" + this.getIsProfiled() + ", isQueryPreview=" + this.getIsQueryPreview() + ", isTemporary=" + this.getIsTemporary() + ", lastProfiledAt=" + this.getLastProfiledAt() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", queryCount=" + this.getQueryCount() + ", queryCountUpdatedAt=" + this.getQueryCountUpdatedAt() + ", queryPreviewConfig=" + this.getQueryPreviewConfig() + ", queryUserCount=" + this.getQueryUserCount() + ", queryUserMap=" + this.getQueryUserMap() + ", refreshMethod=" + this.getRefreshMethod() + ", refreshMode=" + this.getRefreshMode() + ", rowCount=" + this.getRowCount() + ", schema=" + this.getSchema() + ", schemaName=" + this.getSchemaName() + ", schemaQualifiedName=" + this.getSchemaQualifiedName() + ", sizeBytes=" + this.getSizeBytes() + ", sqlDBTSources=" + this.getSqlDBTSources() + ", sqlDbtModels=" + this.getSqlDbtModels() + ", staleSinceDate=" + this.getStaleSinceDate() + ", staleness=" + this.getStaleness() + ", tableName=" + this.getTableName() + ", tableQualifiedName=" + this.getTableQualifiedName() + ", viewName=" + this.getViewName() + ", viewQualifiedName=" + this.getViewQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class MaterializedViewBuilderImpl
    extends MaterializedViewBuilder<MaterializedView, MaterializedViewBuilderImpl> {
        @Generated
        private MaterializedViewBuilderImpl() {
        }

        @Override
        @Generated
        protected MaterializedViewBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MaterializedView build() {
            return new MaterializedView(this);
        }
    }

    @Generated
    public static abstract class MaterializedViewBuilder<C extends MaterializedView, B extends MaterializedViewBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String alias;
        @Generated
        private Long columnCount;
        @Generated
        private ArrayList<IColumn> columns;
        @Generated
        private String databaseName;
        @Generated
        private String databaseQualifiedName;
        @Generated
        private ArrayList<IDbtModel> dbtModels;
        @Generated
        private ArrayList<IDbtSource> dbtSources;
        @Generated
        private ArrayList<IDbtTest> dbtTests;
        @Generated
        private String definition;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private Boolean isProfiled;
        @Generated
        private Boolean isQueryPreview;
        @Generated
        private Boolean isTemporary;
        @Generated
        private Long lastProfiledAt;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private Long queryCount;
        @Generated
        private Long queryCountUpdatedAt;
        @Generated
        private ArrayList<String> queryPreviewConfig$key;
        @Generated
        private ArrayList<String> queryPreviewConfig$value;
        @Generated
        private Long queryUserCount;
        @Generated
        private ArrayList<String> queryUserMap$key;
        @Generated
        private ArrayList<Long> queryUserMap$value;
        @Generated
        private String refreshMethod;
        @Generated
        private String refreshMode;
        @Generated
        private Long rowCount;
        @Generated
        private ISchema schema;
        @Generated
        private String schemaName;
        @Generated
        private String schemaQualifiedName;
        @Generated
        private Long sizeBytes;
        @Generated
        private ArrayList<IDbtSource> sqlDBTSources;
        @Generated
        private ArrayList<IDbtModel> sqlDbtModels;
        @Generated
        private Long staleSinceDate;
        @Generated
        private String staleness;
        @Generated
        private String tableName;
        @Generated
        private String tableQualifiedName;
        @Generated
        private String viewName;
        @Generated
        private String viewQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MaterializedViewBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MaterializedView instance, MaterializedViewBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.alias(instance.alias);
            b.columnCount(instance.columnCount);
            b.columns(instance.columns == null ? Collections.emptySortedSet() : instance.columns);
            b.databaseName(instance.databaseName);
            b.databaseQualifiedName(instance.databaseQualifiedName);
            b.dbtModels(instance.dbtModels == null ? Collections.emptySortedSet() : instance.dbtModels);
            b.dbtSources(instance.dbtSources == null ? Collections.emptySortedSet() : instance.dbtSources);
            b.dbtTests(instance.dbtTests == null ? Collections.emptySortedSet() : instance.dbtTests);
            b.definition(instance.definition);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.isProfiled(instance.isProfiled);
            b.isQueryPreview(instance.isQueryPreview);
            b.isTemporary(instance.isTemporary);
            b.lastProfiledAt(instance.lastProfiledAt);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.queryCount(instance.queryCount);
            b.queryCountUpdatedAt(instance.queryCountUpdatedAt);
            b.queryPreviewConfig(instance.queryPreviewConfig == null ? Collections.emptyMap() : instance.queryPreviewConfig);
            b.queryUserCount(instance.queryUserCount);
            b.queryUserMap(instance.queryUserMap == null ? Collections.emptyMap() : instance.queryUserMap);
            b.refreshMethod(instance.refreshMethod);
            b.refreshMode(instance.refreshMode);
            b.rowCount(instance.rowCount);
            b.schema(instance.schema);
            b.schemaName(instance.schemaName);
            b.schemaQualifiedName(instance.schemaQualifiedName);
            b.sizeBytes(instance.sizeBytes);
            b.sqlDBTSources(instance.sqlDBTSources == null ? Collections.emptySortedSet() : instance.sqlDBTSources);
            b.sqlDbtModels(instance.sqlDbtModels == null ? Collections.emptySortedSet() : instance.sqlDbtModels);
            b.staleSinceDate(instance.staleSinceDate);
            b.staleness(instance.staleness);
            b.tableName(instance.tableName);
            b.tableQualifiedName(instance.tableQualifiedName);
            b.viewName(instance.viewName);
            b.viewQualifiedName(instance.viewQualifiedName);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B alias(String alias) {
            this.alias = alias;
            return (B)this.self();
        }

        @Generated
        public B columnCount(Long columnCount) {
            this.columnCount = columnCount;
            return (B)this.self();
        }

        @Generated
        public B column(IColumn column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return (B)this.self();
        }

        @Generated
        public B columns(Collection<? extends IColumn> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return (B)this.self();
        }

        @Generated
        public B clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B databaseName(String databaseName) {
            this.databaseName = databaseName;
            return (B)this.self();
        }

        @Generated
        public B databaseQualifiedName(String databaseQualifiedName) {
            this.databaseQualifiedName = databaseQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dbtModel(IDbtModel dbtModel) {
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.add(dbtModel);
            return (B)this.self();
        }

        @Generated
        public B dbtModels(Collection<? extends IDbtModel> dbtModels) {
            if (dbtModels == null) {
                throw new NullPointerException("dbtModels cannot be null");
            }
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.addAll(dbtModels);
            return (B)this.self();
        }

        @Generated
        public B clearDbtModels() {
            if (this.dbtModels != null) {
                this.dbtModels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtSource(IDbtSource dbtSource) {
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.add(dbtSource);
            return (B)this.self();
        }

        @Generated
        public B dbtSources(Collection<? extends IDbtSource> dbtSources) {
            if (dbtSources == null) {
                throw new NullPointerException("dbtSources cannot be null");
            }
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.addAll(dbtSources);
            return (B)this.self();
        }

        @Generated
        public B clearDbtSources() {
            if (this.dbtSources != null) {
                this.dbtSources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtTest(IDbtTest dbtTest) {
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.add(dbtTest);
            return (B)this.self();
        }

        @Generated
        public B dbtTests(Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.addAll(dbtTests);
            return (B)this.self();
        }

        @Generated
        public B clearDbtTests() {
            if (this.dbtTests != null) {
                this.dbtTests.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B definition(String definition) {
            this.definition = definition;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isProfiled(Boolean isProfiled) {
            this.isProfiled = isProfiled;
            return (B)this.self();
        }

        @Generated
        public B isQueryPreview(Boolean isQueryPreview) {
            this.isQueryPreview = isQueryPreview;
            return (B)this.self();
        }

        @Generated
        public B isTemporary(Boolean isTemporary) {
            this.isTemporary = isTemporary;
            return (B)this.self();
        }

        @Generated
        public B lastProfiledAt(Long lastProfiledAt) {
            this.lastProfiledAt = lastProfiledAt;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B queryCount(Long queryCount) {
            this.queryCount = queryCount;
            return (B)this.self();
        }

        @Generated
        public B queryCountUpdatedAt(Long queryCountUpdatedAt) {
            this.queryCountUpdatedAt = queryCountUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B putQueryPreviewConfig(String putQueryPreviewConfigKey, String putQueryPreviewConfigValue) {
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            this.queryPreviewConfig$key.add(putQueryPreviewConfigKey);
            this.queryPreviewConfig$value.add(putQueryPreviewConfigValue);
            return (B)this.self();
        }

        @Generated
        public B queryPreviewConfig(Map<? extends String, ? extends String> queryPreviewConfig) {
            if (queryPreviewConfig == null) {
                throw new NullPointerException("queryPreviewConfig cannot be null");
            }
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : queryPreviewConfig.entrySet()) {
                this.queryPreviewConfig$key.add($lombokEntry.getKey());
                this.queryPreviewConfig$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearQueryPreviewConfig() {
            if (this.queryPreviewConfig$key != null) {
                this.queryPreviewConfig$key.clear();
                this.queryPreviewConfig$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B queryUserCount(Long queryUserCount) {
            this.queryUserCount = queryUserCount;
            return (B)this.self();
        }

        @Generated
        public B putQueryUserMap(String putQueryUserMapKey, Long putQueryUserMapValue) {
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            this.queryUserMap$key.add(putQueryUserMapKey);
            this.queryUserMap$value.add(putQueryUserMapValue);
            return (B)this.self();
        }

        @Generated
        public B queryUserMap(Map<? extends String, ? extends Long> queryUserMap) {
            if (queryUserMap == null) {
                throw new NullPointerException("queryUserMap cannot be null");
            }
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Long> $lombokEntry : queryUserMap.entrySet()) {
                this.queryUserMap$key.add($lombokEntry.getKey());
                this.queryUserMap$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearQueryUserMap() {
            if (this.queryUserMap$key != null) {
                this.queryUserMap$key.clear();
                this.queryUserMap$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B refreshMethod(String refreshMethod) {
            this.refreshMethod = refreshMethod;
            return (B)this.self();
        }

        @Generated
        public B refreshMode(String refreshMode) {
            this.refreshMode = refreshMode;
            return (B)this.self();
        }

        @Generated
        public B rowCount(Long rowCount) {
            this.rowCount = rowCount;
            return (B)this.self();
        }

        @JsonProperty(value="atlanSchema")
        @Generated
        public B schema(ISchema schema) {
            this.schema = schema;
            return (B)this.self();
        }

        @Generated
        public B schemaName(String schemaName) {
            this.schemaName = schemaName;
            return (B)this.self();
        }

        @Generated
        public B schemaQualifiedName(String schemaQualifiedName) {
            this.schemaQualifiedName = schemaQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return (B)this.self();
        }

        @Generated
        public B sqlDBTSource(IDbtSource sqlDBTSource) {
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.add(sqlDBTSource);
            return (B)this.self();
        }

        @Generated
        public B sqlDBTSources(Collection<? extends IDbtSource> sqlDBTSources) {
            if (sqlDBTSources == null) {
                throw new NullPointerException("sqlDBTSources cannot be null");
            }
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.addAll(sqlDBTSources);
            return (B)this.self();
        }

        @Generated
        public B clearSqlDBTSources() {
            if (this.sqlDBTSources != null) {
                this.sqlDBTSources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sqlDbtModel(IDbtModel sqlDbtModel) {
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.add(sqlDbtModel);
            return (B)this.self();
        }

        @Generated
        public B sqlDbtModels(Collection<? extends IDbtModel> sqlDbtModels) {
            if (sqlDbtModels == null) {
                throw new NullPointerException("sqlDbtModels cannot be null");
            }
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.addAll(sqlDbtModels);
            return (B)this.self();
        }

        @Generated
        public B clearSqlDbtModels() {
            if (this.sqlDbtModels != null) {
                this.sqlDbtModels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B staleSinceDate(Long staleSinceDate) {
            this.staleSinceDate = staleSinceDate;
            return (B)this.self();
        }

        @Generated
        public B staleness(String staleness) {
            this.staleness = staleness;
            return (B)this.self();
        }

        @Generated
        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        @Generated
        public B tableQualifiedName(String tableQualifiedName) {
            this.tableQualifiedName = tableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B viewName(String viewName) {
            this.viewName = viewName;
            return (B)this.self();
        }

        @Generated
        public B viewQualifiedName(String viewQualifiedName) {
            this.viewQualifiedName = viewQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "MaterializedView.MaterializedViewBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", alias=" + this.alias + ", columnCount=" + this.columnCount + ", columns=" + this.columns + ", databaseName=" + this.databaseName + ", databaseQualifiedName=" + this.databaseQualifiedName + ", dbtModels=" + this.dbtModels + ", dbtSources=" + this.dbtSources + ", dbtTests=" + this.dbtTests + ", definition=" + this.definition + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", isProfiled=" + this.isProfiled + ", isQueryPreview=" + this.isQueryPreview + ", isTemporary=" + this.isTemporary + ", lastProfiledAt=" + this.lastProfiledAt + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", queryCount=" + this.queryCount + ", queryCountUpdatedAt=" + this.queryCountUpdatedAt + ", queryPreviewConfig$key=" + this.queryPreviewConfig$key + ", queryPreviewConfig$value=" + this.queryPreviewConfig$value + ", queryUserCount=" + this.queryUserCount + ", queryUserMap$key=" + this.queryUserMap$key + ", queryUserMap$value=" + this.queryUserMap$value + ", refreshMethod=" + this.refreshMethod + ", refreshMode=" + this.refreshMode + ", rowCount=" + this.rowCount + ", schema=" + this.schema + ", schemaName=" + this.schemaName + ", schemaQualifiedName=" + this.schemaQualifiedName + ", sizeBytes=" + this.sizeBytes + ", sqlDBTSources=" + this.sqlDBTSources + ", sqlDbtModels=" + this.sqlDbtModels + ", staleSinceDate=" + this.staleSinceDate + ", staleness=" + this.staleness + ", tableName=" + this.tableName + ", tableQualifiedName=" + this.tableQualifiedName + ", viewName=" + this.viewName + ", viewQualifiedName=" + this.viewQualifiedName + ")";
        }
    }
}

