/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMetabase;
import com.atlan.model.assets.IMetabaseCollection;
import com.atlan.model.assets.IMetabaseDashboard;
import com.atlan.model.assets.IMetabaseQuestion;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetabaseCollection
extends Asset
implements IMetabaseCollection,
IMetabase,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetabaseCollection.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MetabaseCollection";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    String metabaseCollectionName;
    @Attribute
    String metabaseCollectionQualifiedName;
    @Attribute
    String metabaseColor;
    @Attribute
    SortedSet<IMetabaseDashboard> metabaseDashboards;
    @Attribute
    Boolean metabaseIsPersonalCollection;
    @Attribute
    String metabaseNamespace;
    @Attribute
    SortedSet<IMetabaseQuestion> metabaseQuestions;
    @Attribute
    String metabaseSlug;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;

    @Override
    public MetabaseCollection trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return MetabaseCollection.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return MetabaseCollection.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return MetabaseCollection.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return MetabaseCollection.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return MetabaseCollection.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return MetabaseCollection.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return MetabaseCollection.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return MetabaseCollection.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return MetabaseCollection.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static MetabaseCollection refByGuid(String guid) {
        return ((MetabaseCollectionBuilder)MetabaseCollection._internal().guid(guid)).build();
    }

    public static MetabaseCollection refByQualifiedName(String qualifiedName) {
        return ((MetabaseCollectionBuilder)MetabaseCollection._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static MetabaseCollection get(String id) throws AtlanException {
        return MetabaseCollection.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static MetabaseCollection get(AtlanClient client, String id) throws AtlanException {
        return MetabaseCollection.get(client, id, true);
    }

    @JsonIgnore
    public static MetabaseCollection get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof MetabaseCollection) {
                return (MetabaseCollection)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof MetabaseCollection) {
            return (MetabaseCollection)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static MetabaseCollection retrieveByGuid(String guid) throws AtlanException {
        return MetabaseCollection.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static MetabaseCollection retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return MetabaseCollection.get(client, guid);
    }

    @Deprecated
    public static MetabaseCollection retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return MetabaseCollection.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static MetabaseCollection retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return MetabaseCollection.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return MetabaseCollection.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static MetabaseCollectionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (MetabaseCollectionBuilder)((MetabaseCollectionBuilder)((MetabaseCollectionBuilder)MetabaseCollection._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public MetabaseCollectionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return MetabaseCollection.updater(this.getQualifiedName(), this.getName());
    }

    public static MetabaseCollection removeDescription(String qualifiedName, String name) throws AtlanException {
        return MetabaseCollection.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MetabaseCollection removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection)Asset.removeDescription(client, MetabaseCollection.updater(qualifiedName, name));
    }

    public static MetabaseCollection removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return MetabaseCollection.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MetabaseCollection removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection)Asset.removeUserDescription(client, MetabaseCollection.updater(qualifiedName, name));
    }

    public static MetabaseCollection removeOwners(String qualifiedName, String name) throws AtlanException {
        return MetabaseCollection.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MetabaseCollection removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection)Asset.removeOwners(client, MetabaseCollection.updater(qualifiedName, name));
    }

    public static MetabaseCollection updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return MetabaseCollection.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static MetabaseCollection updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MetabaseCollection)Asset.updateCertificate(client, MetabaseCollection._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static MetabaseCollection removeCertificate(String qualifiedName, String name) throws AtlanException {
        return MetabaseCollection.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MetabaseCollection removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection)Asset.removeCertificate(client, MetabaseCollection.updater(qualifiedName, name));
    }

    public static MetabaseCollection updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return MetabaseCollection.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static MetabaseCollection updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MetabaseCollection)Asset.updateAnnouncement(client, MetabaseCollection._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static MetabaseCollection removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return MetabaseCollection.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MetabaseCollection removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection)Asset.removeAnnouncement(client, MetabaseCollection.updater(qualifiedName, name));
    }

    public static MetabaseCollection replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return MetabaseCollection.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static MetabaseCollection replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MetabaseCollection)Asset.replaceTerms(client, MetabaseCollection.updater(qualifiedName, name), terms);
    }

    public static MetabaseCollection appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return MetabaseCollection.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static MetabaseCollection appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MetabaseCollection)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static MetabaseCollection removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return MetabaseCollection.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static MetabaseCollection removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MetabaseCollection)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static MetabaseCollection appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return MetabaseCollection.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static MetabaseCollection appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MetabaseCollection)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static MetabaseCollection appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return MetabaseCollection.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static MetabaseCollection appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MetabaseCollection)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        MetabaseCollection.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        MetabaseCollection.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        MetabaseCollection.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected MetabaseCollection(MetabaseCollectionBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : MetabaseCollection.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        this.metabaseCollectionName = b.metabaseCollectionName;
        this.metabaseCollectionQualifiedName = b.metabaseCollectionQualifiedName;
        this.metabaseColor = b.metabaseColor;
        SortedSet<IMetabaseDashboard> metabaseDashboards = new TreeSet<IMetabaseDashboard>();
        if (b.metabaseDashboards != null) {
            metabaseDashboards.addAll(b.metabaseDashboards);
        }
        metabaseDashboards = Collections.unmodifiableSortedSet(metabaseDashboards);
        this.metabaseDashboards = metabaseDashboards;
        this.metabaseIsPersonalCollection = b.metabaseIsPersonalCollection;
        this.metabaseNamespace = b.metabaseNamespace;
        SortedSet<IMetabaseQuestion> metabaseQuestions = new TreeSet<IMetabaseQuestion>();
        if (b.metabaseQuestions != null) {
            metabaseQuestions.addAll(b.metabaseQuestions);
        }
        metabaseQuestions = Collections.unmodifiableSortedSet(metabaseQuestions);
        this.metabaseQuestions = metabaseQuestions;
        this.metabaseSlug = b.metabaseSlug;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
    }

    @Generated
    public static MetabaseCollectionBuilder<?, ?> _internal() {
        return new MetabaseCollectionBuilderImpl();
    }

    @Generated
    public MetabaseCollectionBuilder<?, ?> toBuilder() {
        return new MetabaseCollectionBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public String getMetabaseCollectionName() {
        return this.metabaseCollectionName;
    }

    @Override
    @Generated
    public String getMetabaseCollectionQualifiedName() {
        return this.metabaseCollectionQualifiedName;
    }

    @Override
    @Generated
    public String getMetabaseColor() {
        return this.metabaseColor;
    }

    @Override
    @Generated
    public SortedSet<IMetabaseDashboard> getMetabaseDashboards() {
        return this.metabaseDashboards;
    }

    @Override
    @Generated
    public Boolean getMetabaseIsPersonalCollection() {
        return this.metabaseIsPersonalCollection;
    }

    @Override
    @Generated
    public String getMetabaseNamespace() {
        return this.metabaseNamespace;
    }

    @Override
    @Generated
    public SortedSet<IMetabaseQuestion> getMetabaseQuestions() {
        return this.metabaseQuestions;
    }

    @Override
    @Generated
    public String getMetabaseSlug() {
        return this.metabaseSlug;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetabaseCollection)) {
            return false;
        }
        MetabaseCollection other = (MetabaseCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$metabaseIsPersonalCollection = this.getMetabaseIsPersonalCollection();
        Boolean other$metabaseIsPersonalCollection = other.getMetabaseIsPersonalCollection();
        if (this$metabaseIsPersonalCollection == null ? other$metabaseIsPersonalCollection != null : !((Object)this$metabaseIsPersonalCollection).equals(other$metabaseIsPersonalCollection)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        String this$metabaseCollectionName = this.getMetabaseCollectionName();
        String other$metabaseCollectionName = other.getMetabaseCollectionName();
        if (this$metabaseCollectionName == null ? other$metabaseCollectionName != null : !this$metabaseCollectionName.equals(other$metabaseCollectionName)) {
            return false;
        }
        String this$metabaseCollectionQualifiedName = this.getMetabaseCollectionQualifiedName();
        String other$metabaseCollectionQualifiedName = other.getMetabaseCollectionQualifiedName();
        if (this$metabaseCollectionQualifiedName == null ? other$metabaseCollectionQualifiedName != null : !this$metabaseCollectionQualifiedName.equals(other$metabaseCollectionQualifiedName)) {
            return false;
        }
        String this$metabaseColor = this.getMetabaseColor();
        String other$metabaseColor = other.getMetabaseColor();
        if (this$metabaseColor == null ? other$metabaseColor != null : !this$metabaseColor.equals(other$metabaseColor)) {
            return false;
        }
        SortedSet<IMetabaseDashboard> this$metabaseDashboards = this.getMetabaseDashboards();
        SortedSet<IMetabaseDashboard> other$metabaseDashboards = other.getMetabaseDashboards();
        if (this$metabaseDashboards == null ? other$metabaseDashboards != null : !this$metabaseDashboards.equals(other$metabaseDashboards)) {
            return false;
        }
        String this$metabaseNamespace = this.getMetabaseNamespace();
        String other$metabaseNamespace = other.getMetabaseNamespace();
        if (this$metabaseNamespace == null ? other$metabaseNamespace != null : !this$metabaseNamespace.equals(other$metabaseNamespace)) {
            return false;
        }
        SortedSet<IMetabaseQuestion> this$metabaseQuestions = this.getMetabaseQuestions();
        SortedSet<IMetabaseQuestion> other$metabaseQuestions = other.getMetabaseQuestions();
        if (this$metabaseQuestions == null ? other$metabaseQuestions != null : !this$metabaseQuestions.equals(other$metabaseQuestions)) {
            return false;
        }
        String this$metabaseSlug = this.getMetabaseSlug();
        String other$metabaseSlug = other.getMetabaseSlug();
        if (this$metabaseSlug == null ? other$metabaseSlug != null : !this$metabaseSlug.equals(other$metabaseSlug)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetabaseCollection;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $metabaseIsPersonalCollection = this.getMetabaseIsPersonalCollection();
        result = result * 59 + ($metabaseIsPersonalCollection == null ? 43 : ((Object)$metabaseIsPersonalCollection).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        String $metabaseCollectionName = this.getMetabaseCollectionName();
        result = result * 59 + ($metabaseCollectionName == null ? 43 : $metabaseCollectionName.hashCode());
        String $metabaseCollectionQualifiedName = this.getMetabaseCollectionQualifiedName();
        result = result * 59 + ($metabaseCollectionQualifiedName == null ? 43 : $metabaseCollectionQualifiedName.hashCode());
        String $metabaseColor = this.getMetabaseColor();
        result = result * 59 + ($metabaseColor == null ? 43 : $metabaseColor.hashCode());
        SortedSet<IMetabaseDashboard> $metabaseDashboards = this.getMetabaseDashboards();
        result = result * 59 + ($metabaseDashboards == null ? 43 : $metabaseDashboards.hashCode());
        String $metabaseNamespace = this.getMetabaseNamespace();
        result = result * 59 + ($metabaseNamespace == null ? 43 : $metabaseNamespace.hashCode());
        SortedSet<IMetabaseQuestion> $metabaseQuestions = this.getMetabaseQuestions();
        result = result * 59 + ($metabaseQuestions == null ? 43 : $metabaseQuestions.hashCode());
        String $metabaseSlug = this.getMetabaseSlug();
        result = result * 59 + ($metabaseSlug == null ? 43 : $metabaseSlug.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "MetabaseCollection(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", metabaseCollectionName=" + this.getMetabaseCollectionName() + ", metabaseCollectionQualifiedName=" + this.getMetabaseCollectionQualifiedName() + ", metabaseColor=" + this.getMetabaseColor() + ", metabaseDashboards=" + this.getMetabaseDashboards() + ", metabaseIsPersonalCollection=" + this.getMetabaseIsPersonalCollection() + ", metabaseNamespace=" + this.getMetabaseNamespace() + ", metabaseQuestions=" + this.getMetabaseQuestions() + ", metabaseSlug=" + this.getMetabaseSlug() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class MetabaseCollectionBuilderImpl
    extends MetabaseCollectionBuilder<MetabaseCollection, MetabaseCollectionBuilderImpl> {
        @Generated
        private MetabaseCollectionBuilderImpl() {
        }

        @Override
        @Generated
        protected MetabaseCollectionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MetabaseCollection build() {
            return new MetabaseCollection(this);
        }
    }

    @Generated
    public static abstract class MetabaseCollectionBuilder<C extends MetabaseCollection, B extends MetabaseCollectionBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private String metabaseCollectionName;
        @Generated
        private String metabaseCollectionQualifiedName;
        @Generated
        private String metabaseColor;
        @Generated
        private ArrayList<IMetabaseDashboard> metabaseDashboards;
        @Generated
        private Boolean metabaseIsPersonalCollection;
        @Generated
        private String metabaseNamespace;
        @Generated
        private ArrayList<IMetabaseQuestion> metabaseQuestions;
        @Generated
        private String metabaseSlug;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MetabaseCollectionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MetabaseCollection instance, MetabaseCollectionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.metabaseCollectionName(instance.metabaseCollectionName);
            b.metabaseCollectionQualifiedName(instance.metabaseCollectionQualifiedName);
            b.metabaseColor(instance.metabaseColor);
            b.metabaseDashboards(instance.metabaseDashboards == null ? Collections.emptySortedSet() : instance.metabaseDashboards);
            b.metabaseIsPersonalCollection(instance.metabaseIsPersonalCollection);
            b.metabaseNamespace(instance.metabaseNamespace);
            b.metabaseQuestions(instance.metabaseQuestions == null ? Collections.emptySortedSet() : instance.metabaseQuestions);
            b.metabaseSlug(instance.metabaseSlug);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metabaseCollectionName(String metabaseCollectionName) {
            this.metabaseCollectionName = metabaseCollectionName;
            return (B)this.self();
        }

        @Generated
        public B metabaseCollectionQualifiedName(String metabaseCollectionQualifiedName) {
            this.metabaseCollectionQualifiedName = metabaseCollectionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B metabaseColor(String metabaseColor) {
            this.metabaseColor = metabaseColor;
            return (B)this.self();
        }

        @Generated
        public B metabaseDashboard(IMetabaseDashboard metabaseDashboard) {
            if (this.metabaseDashboards == null) {
                this.metabaseDashboards = new ArrayList();
            }
            this.metabaseDashboards.add(metabaseDashboard);
            return (B)this.self();
        }

        @Generated
        public B metabaseDashboards(Collection<? extends IMetabaseDashboard> metabaseDashboards) {
            if (metabaseDashboards == null) {
                throw new NullPointerException("metabaseDashboards cannot be null");
            }
            if (this.metabaseDashboards == null) {
                this.metabaseDashboards = new ArrayList();
            }
            this.metabaseDashboards.addAll(metabaseDashboards);
            return (B)this.self();
        }

        @Generated
        public B clearMetabaseDashboards() {
            if (this.metabaseDashboards != null) {
                this.metabaseDashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metabaseIsPersonalCollection(Boolean metabaseIsPersonalCollection) {
            this.metabaseIsPersonalCollection = metabaseIsPersonalCollection;
            return (B)this.self();
        }

        @Generated
        public B metabaseNamespace(String metabaseNamespace) {
            this.metabaseNamespace = metabaseNamespace;
            return (B)this.self();
        }

        @Generated
        public B metabaseQuestion(IMetabaseQuestion metabaseQuestion) {
            if (this.metabaseQuestions == null) {
                this.metabaseQuestions = new ArrayList();
            }
            this.metabaseQuestions.add(metabaseQuestion);
            return (B)this.self();
        }

        @Generated
        public B metabaseQuestions(Collection<? extends IMetabaseQuestion> metabaseQuestions) {
            if (metabaseQuestions == null) {
                throw new NullPointerException("metabaseQuestions cannot be null");
            }
            if (this.metabaseQuestions == null) {
                this.metabaseQuestions = new ArrayList();
            }
            this.metabaseQuestions.addAll(metabaseQuestions);
            return (B)this.self();
        }

        @Generated
        public B clearMetabaseQuestions() {
            if (this.metabaseQuestions != null) {
                this.metabaseQuestions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metabaseSlug(String metabaseSlug) {
            this.metabaseSlug = metabaseSlug;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "MetabaseCollection.MetabaseCollectionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", metabaseCollectionName=" + this.metabaseCollectionName + ", metabaseCollectionQualifiedName=" + this.metabaseCollectionQualifiedName + ", metabaseColor=" + this.metabaseColor + ", metabaseDashboards=" + this.metabaseDashboards + ", metabaseIsPersonalCollection=" + this.metabaseIsPersonalCollection + ", metabaseNamespace=" + this.metabaseNamespace + ", metabaseQuestions=" + this.metabaseQuestions + ", metabaseSlug=" + this.metabaseSlug + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ")";
        }
    }
}

