/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMetabase;
import com.atlan.model.assets.IMetabaseCollection;
import com.atlan.model.assets.IMetabaseDashboard;
import com.atlan.model.assets.IMetabaseQuestion;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetabaseQuestion
extends Asset
implements IMetabaseQuestion,
IMetabase,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetabaseQuestion.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MetabaseQuestion";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    IMetabaseCollection metabaseCollection;
    @Attribute
    String metabaseCollectionName;
    @Attribute
    String metabaseCollectionQualifiedName;
    @Attribute
    Long metabaseDashboardCount;
    @Attribute
    SortedSet<IMetabaseDashboard> metabaseDashboards;
    @Attribute
    String metabaseQuery;
    @Attribute
    String metabaseQueryType;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;

    @Override
    public MetabaseQuestion trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return MetabaseQuestion.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return MetabaseQuestion.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return MetabaseQuestion.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return MetabaseQuestion.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return MetabaseQuestion.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return MetabaseQuestion.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return MetabaseQuestion.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return MetabaseQuestion.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return MetabaseQuestion.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static MetabaseQuestion refByGuid(String guid) {
        return ((MetabaseQuestionBuilder)MetabaseQuestion._internal().guid(guid)).build();
    }

    public static MetabaseQuestion refByQualifiedName(String qualifiedName) {
        return ((MetabaseQuestionBuilder)MetabaseQuestion._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static MetabaseQuestion get(String id) throws AtlanException {
        return MetabaseQuestion.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static MetabaseQuestion get(AtlanClient client, String id) throws AtlanException {
        return MetabaseQuestion.get(client, id, true);
    }

    @JsonIgnore
    public static MetabaseQuestion get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof MetabaseQuestion) {
                return (MetabaseQuestion)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof MetabaseQuestion) {
            return (MetabaseQuestion)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static MetabaseQuestion retrieveByGuid(String guid) throws AtlanException {
        return MetabaseQuestion.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static MetabaseQuestion retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return MetabaseQuestion.get(client, guid);
    }

    @Deprecated
    public static MetabaseQuestion retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return MetabaseQuestion.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static MetabaseQuestion retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return MetabaseQuestion.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return MetabaseQuestion.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static MetabaseQuestionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (MetabaseQuestionBuilder)((MetabaseQuestionBuilder)((MetabaseQuestionBuilder)MetabaseQuestion._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public MetabaseQuestionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return MetabaseQuestion.updater(this.getQualifiedName(), this.getName());
    }

    public static MetabaseQuestion removeDescription(String qualifiedName, String name) throws AtlanException {
        return MetabaseQuestion.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MetabaseQuestion removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseQuestion)Asset.removeDescription(client, MetabaseQuestion.updater(qualifiedName, name));
    }

    public static MetabaseQuestion removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return MetabaseQuestion.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MetabaseQuestion removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseQuestion)Asset.removeUserDescription(client, MetabaseQuestion.updater(qualifiedName, name));
    }

    public static MetabaseQuestion removeOwners(String qualifiedName, String name) throws AtlanException {
        return MetabaseQuestion.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MetabaseQuestion removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseQuestion)Asset.removeOwners(client, MetabaseQuestion.updater(qualifiedName, name));
    }

    public static MetabaseQuestion updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return MetabaseQuestion.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static MetabaseQuestion updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MetabaseQuestion)Asset.updateCertificate(client, MetabaseQuestion._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static MetabaseQuestion removeCertificate(String qualifiedName, String name) throws AtlanException {
        return MetabaseQuestion.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MetabaseQuestion removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseQuestion)Asset.removeCertificate(client, MetabaseQuestion.updater(qualifiedName, name));
    }

    public static MetabaseQuestion updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return MetabaseQuestion.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static MetabaseQuestion updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MetabaseQuestion)Asset.updateAnnouncement(client, MetabaseQuestion._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static MetabaseQuestion removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return MetabaseQuestion.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MetabaseQuestion removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseQuestion)Asset.removeAnnouncement(client, MetabaseQuestion.updater(qualifiedName, name));
    }

    public static MetabaseQuestion replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return MetabaseQuestion.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static MetabaseQuestion replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MetabaseQuestion)Asset.replaceTerms(client, MetabaseQuestion.updater(qualifiedName, name), terms);
    }

    public static MetabaseQuestion appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return MetabaseQuestion.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static MetabaseQuestion appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MetabaseQuestion)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static MetabaseQuestion removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return MetabaseQuestion.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static MetabaseQuestion removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MetabaseQuestion)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static MetabaseQuestion appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return MetabaseQuestion.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static MetabaseQuestion appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MetabaseQuestion)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static MetabaseQuestion appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return MetabaseQuestion.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static MetabaseQuestion appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MetabaseQuestion)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        MetabaseQuestion.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        MetabaseQuestion.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        MetabaseQuestion.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected MetabaseQuestion(MetabaseQuestionBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : MetabaseQuestion.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        this.metabaseCollection = b.metabaseCollection;
        this.metabaseCollectionName = b.metabaseCollectionName;
        this.metabaseCollectionQualifiedName = b.metabaseCollectionQualifiedName;
        this.metabaseDashboardCount = b.metabaseDashboardCount;
        SortedSet<IMetabaseDashboard> metabaseDashboards = new TreeSet<IMetabaseDashboard>();
        if (b.metabaseDashboards != null) {
            metabaseDashboards.addAll(b.metabaseDashboards);
        }
        metabaseDashboards = Collections.unmodifiableSortedSet(metabaseDashboards);
        this.metabaseDashboards = metabaseDashboards;
        this.metabaseQuery = b.metabaseQuery;
        this.metabaseQueryType = b.metabaseQueryType;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
    }

    @Generated
    public static MetabaseQuestionBuilder<?, ?> _internal() {
        return new MetabaseQuestionBuilderImpl();
    }

    @Generated
    public MetabaseQuestionBuilder<?, ?> toBuilder() {
        return new MetabaseQuestionBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public IMetabaseCollection getMetabaseCollection() {
        return this.metabaseCollection;
    }

    @Override
    @Generated
    public String getMetabaseCollectionName() {
        return this.metabaseCollectionName;
    }

    @Override
    @Generated
    public String getMetabaseCollectionQualifiedName() {
        return this.metabaseCollectionQualifiedName;
    }

    @Override
    @Generated
    public Long getMetabaseDashboardCount() {
        return this.metabaseDashboardCount;
    }

    @Override
    @Generated
    public SortedSet<IMetabaseDashboard> getMetabaseDashboards() {
        return this.metabaseDashboards;
    }

    @Override
    @Generated
    public String getMetabaseQuery() {
        return this.metabaseQuery;
    }

    @Override
    @Generated
    public String getMetabaseQueryType() {
        return this.metabaseQueryType;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetabaseQuestion)) {
            return false;
        }
        MetabaseQuestion other = (MetabaseQuestion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$metabaseDashboardCount = this.getMetabaseDashboardCount();
        Long other$metabaseDashboardCount = other.getMetabaseDashboardCount();
        if (this$metabaseDashboardCount == null ? other$metabaseDashboardCount != null : !((Object)this$metabaseDashboardCount).equals(other$metabaseDashboardCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        IMetabaseCollection this$metabaseCollection = this.getMetabaseCollection();
        IMetabaseCollection other$metabaseCollection = other.getMetabaseCollection();
        if (this$metabaseCollection == null ? other$metabaseCollection != null : !this$metabaseCollection.equals(other$metabaseCollection)) {
            return false;
        }
        String this$metabaseCollectionName = this.getMetabaseCollectionName();
        String other$metabaseCollectionName = other.getMetabaseCollectionName();
        if (this$metabaseCollectionName == null ? other$metabaseCollectionName != null : !this$metabaseCollectionName.equals(other$metabaseCollectionName)) {
            return false;
        }
        String this$metabaseCollectionQualifiedName = this.getMetabaseCollectionQualifiedName();
        String other$metabaseCollectionQualifiedName = other.getMetabaseCollectionQualifiedName();
        if (this$metabaseCollectionQualifiedName == null ? other$metabaseCollectionQualifiedName != null : !this$metabaseCollectionQualifiedName.equals(other$metabaseCollectionQualifiedName)) {
            return false;
        }
        SortedSet<IMetabaseDashboard> this$metabaseDashboards = this.getMetabaseDashboards();
        SortedSet<IMetabaseDashboard> other$metabaseDashboards = other.getMetabaseDashboards();
        if (this$metabaseDashboards == null ? other$metabaseDashboards != null : !this$metabaseDashboards.equals(other$metabaseDashboards)) {
            return false;
        }
        String this$metabaseQuery = this.getMetabaseQuery();
        String other$metabaseQuery = other.getMetabaseQuery();
        if (this$metabaseQuery == null ? other$metabaseQuery != null : !this$metabaseQuery.equals(other$metabaseQuery)) {
            return false;
        }
        String this$metabaseQueryType = this.getMetabaseQueryType();
        String other$metabaseQueryType = other.getMetabaseQueryType();
        if (this$metabaseQueryType == null ? other$metabaseQueryType != null : !this$metabaseQueryType.equals(other$metabaseQueryType)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetabaseQuestion;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $metabaseDashboardCount = this.getMetabaseDashboardCount();
        result = result * 59 + ($metabaseDashboardCount == null ? 43 : ((Object)$metabaseDashboardCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        IMetabaseCollection $metabaseCollection = this.getMetabaseCollection();
        result = result * 59 + ($metabaseCollection == null ? 43 : $metabaseCollection.hashCode());
        String $metabaseCollectionName = this.getMetabaseCollectionName();
        result = result * 59 + ($metabaseCollectionName == null ? 43 : $metabaseCollectionName.hashCode());
        String $metabaseCollectionQualifiedName = this.getMetabaseCollectionQualifiedName();
        result = result * 59 + ($metabaseCollectionQualifiedName == null ? 43 : $metabaseCollectionQualifiedName.hashCode());
        SortedSet<IMetabaseDashboard> $metabaseDashboards = this.getMetabaseDashboards();
        result = result * 59 + ($metabaseDashboards == null ? 43 : $metabaseDashboards.hashCode());
        String $metabaseQuery = this.getMetabaseQuery();
        result = result * 59 + ($metabaseQuery == null ? 43 : $metabaseQuery.hashCode());
        String $metabaseQueryType = this.getMetabaseQueryType();
        result = result * 59 + ($metabaseQueryType == null ? 43 : $metabaseQueryType.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "MetabaseQuestion(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", metabaseCollection=" + this.getMetabaseCollection() + ", metabaseCollectionName=" + this.getMetabaseCollectionName() + ", metabaseCollectionQualifiedName=" + this.getMetabaseCollectionQualifiedName() + ", metabaseDashboardCount=" + this.getMetabaseDashboardCount() + ", metabaseDashboards=" + this.getMetabaseDashboards() + ", metabaseQuery=" + this.getMetabaseQuery() + ", metabaseQueryType=" + this.getMetabaseQueryType() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class MetabaseQuestionBuilderImpl
    extends MetabaseQuestionBuilder<MetabaseQuestion, MetabaseQuestionBuilderImpl> {
        @Generated
        private MetabaseQuestionBuilderImpl() {
        }

        @Override
        @Generated
        protected MetabaseQuestionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MetabaseQuestion build() {
            return new MetabaseQuestion(this);
        }
    }

    @Generated
    public static abstract class MetabaseQuestionBuilder<C extends MetabaseQuestion, B extends MetabaseQuestionBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private IMetabaseCollection metabaseCollection;
        @Generated
        private String metabaseCollectionName;
        @Generated
        private String metabaseCollectionQualifiedName;
        @Generated
        private Long metabaseDashboardCount;
        @Generated
        private ArrayList<IMetabaseDashboard> metabaseDashboards;
        @Generated
        private String metabaseQuery;
        @Generated
        private String metabaseQueryType;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MetabaseQuestionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MetabaseQuestion instance, MetabaseQuestionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.metabaseCollection(instance.metabaseCollection);
            b.metabaseCollectionName(instance.metabaseCollectionName);
            b.metabaseCollectionQualifiedName(instance.metabaseCollectionQualifiedName);
            b.metabaseDashboardCount(instance.metabaseDashboardCount);
            b.metabaseDashboards(instance.metabaseDashboards == null ? Collections.emptySortedSet() : instance.metabaseDashboards);
            b.metabaseQuery(instance.metabaseQuery);
            b.metabaseQueryType(instance.metabaseQueryType);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metabaseCollection(IMetabaseCollection metabaseCollection) {
            this.metabaseCollection = metabaseCollection;
            return (B)this.self();
        }

        @Generated
        public B metabaseCollectionName(String metabaseCollectionName) {
            this.metabaseCollectionName = metabaseCollectionName;
            return (B)this.self();
        }

        @Generated
        public B metabaseCollectionQualifiedName(String metabaseCollectionQualifiedName) {
            this.metabaseCollectionQualifiedName = metabaseCollectionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B metabaseDashboardCount(Long metabaseDashboardCount) {
            this.metabaseDashboardCount = metabaseDashboardCount;
            return (B)this.self();
        }

        @Generated
        public B metabaseDashboard(IMetabaseDashboard metabaseDashboard) {
            if (this.metabaseDashboards == null) {
                this.metabaseDashboards = new ArrayList();
            }
            this.metabaseDashboards.add(metabaseDashboard);
            return (B)this.self();
        }

        @Generated
        public B metabaseDashboards(Collection<? extends IMetabaseDashboard> metabaseDashboards) {
            if (metabaseDashboards == null) {
                throw new NullPointerException("metabaseDashboards cannot be null");
            }
            if (this.metabaseDashboards == null) {
                this.metabaseDashboards = new ArrayList();
            }
            this.metabaseDashboards.addAll(metabaseDashboards);
            return (B)this.self();
        }

        @Generated
        public B clearMetabaseDashboards() {
            if (this.metabaseDashboards != null) {
                this.metabaseDashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metabaseQuery(String metabaseQuery) {
            this.metabaseQuery = metabaseQuery;
            return (B)this.self();
        }

        @Generated
        public B metabaseQueryType(String metabaseQueryType) {
            this.metabaseQueryType = metabaseQueryType;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "MetabaseQuestion.MetabaseQuestionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", metabaseCollection=" + this.metabaseCollection + ", metabaseCollectionName=" + this.metabaseCollectionName + ", metabaseCollectionQualifiedName=" + this.metabaseCollectionQualifiedName + ", metabaseDashboardCount=" + this.metabaseDashboardCount + ", metabaseDashboards=" + this.metabaseDashboards + ", metabaseQuery=" + this.metabaseQuery + ", metabaseQueryType=" + this.metabaseQueryType + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ")";
        }
    }
}

